/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import wiremock.org.xmlunit.builder.Input;
import wiremock.org.xmlunit.diff.Comparison;
import wiremock.org.xmlunit.diff.ComparisonController;
import wiremock.org.xmlunit.diff.ComparisonControllers;
import wiremock.org.xmlunit.diff.ComparisonFormatter;
import wiremock.org.xmlunit.diff.ComparisonListener;
import wiremock.org.xmlunit.diff.ComparisonResult;
import wiremock.org.xmlunit.diff.DOMDifferenceEngine;
import wiremock.org.xmlunit.diff.Diff;
import wiremock.org.xmlunit.diff.Difference;
import wiremock.org.xmlunit.diff.DifferenceEvaluator;
import wiremock.org.xmlunit.diff.DifferenceEvaluators;
import wiremock.org.xmlunit.diff.NodeMatcher;
import wiremock.org.xmlunit.input.CommentLessSource;
import wiremock.org.xmlunit.input.WhitespaceNormalizedSource;
import wiremock.org.xmlunit.input.WhitespaceStrippedSource;
import wiremock.org.xmlunit.util.Predicate;

public class DiffBuilder {
    private static final ComparisonResult[] CHECK_FOR_SIMILAR = new ComparisonResult[]{ComparisonResult.DIFFERENT};
    private static final ComparisonResult[] CHECK_FOR_IDENTICAL = new ComparisonResult[]{ComparisonResult.SIMILAR, ComparisonResult.DIFFERENT};
    private final Source controlSource;
    private Source testSource;
    private NodeMatcher nodeMatcher;
    private ComparisonController comparisonController = ComparisonControllers.Default;
    private DifferenceEvaluator differenceEvaluator = DifferenceEvaluators.Default;
    private List<ComparisonListener> comparisonListeners = new ArrayList<ComparisonListener>();
    private List<ComparisonListener> differenceListeners = new ArrayList<ComparisonListener>();
    private ComparisonResult[] comparisonResultsToCheck = CHECK_FOR_IDENTICAL;
    private Map<String, String> namespaceContext;
    private Predicate<Attr> attributeFilter;
    private Predicate<Node> nodeFilter;
    private ComparisonFormatter formatter;
    private boolean ignoreWhitespace;
    private boolean normalizeWhitespace;
    private boolean ignoreComments;
    private DocumentBuilderFactory documentBuilderFactory;

    private DiffBuilder(Source controlSource) {
        this.controlSource = controlSource;
    }

    public static DiffBuilder compare(Object control) {
        Source controlSource = DiffBuilder.getSource(control);
        return new DiffBuilder(controlSource);
    }

    public DiffBuilder withTest(Object test) {
        this.testSource = DiffBuilder.getSource(test);
        return this;
    }

    private static Source getSource(Object object) {
        return Input.from(object).build();
    }

    public DiffBuilder ignoreWhitespace() {
        this.ignoreWhitespace = true;
        return this;
    }

    public DiffBuilder normalizeWhitespace() {
        this.normalizeWhitespace = true;
        return this;
    }

    public DiffBuilder ignoreComments() {
        this.ignoreComments = true;
        return this;
    }

    public DiffBuilder withNodeMatcher(NodeMatcher nodeMatcher) {
        this.nodeMatcher = nodeMatcher;
        return this;
    }

    public DiffBuilder withDifferenceEvaluator(DifferenceEvaluator differenceEvaluator) {
        this.differenceEvaluator = differenceEvaluator;
        return this;
    }

    public DiffBuilder withComparisonController(ComparisonController comparisonController) {
        this.comparisonController = comparisonController;
        return this;
    }

    public DiffBuilder withComparisonListeners(ComparisonListener ... comparisonListeners) {
        this.comparisonListeners.addAll(Arrays.asList(comparisonListeners));
        return this;
    }

    public DiffBuilder withDifferenceListeners(ComparisonListener ... comparisonListeners) {
        this.differenceListeners.addAll(Arrays.asList(comparisonListeners));
        return this;
    }

    public DiffBuilder checkForSimilar() {
        this.comparisonResultsToCheck = CHECK_FOR_SIMILAR;
        return this;
    }

    public DiffBuilder checkForIdentical() {
        this.comparisonResultsToCheck = CHECK_FOR_IDENTICAL;
        return this;
    }

    public DiffBuilder withNamespaceContext(Map<String, String> prefix2Uri) {
        this.namespaceContext = prefix2Uri;
        return this;
    }

    public DiffBuilder withAttributeFilter(Predicate<Attr> attributeFilter) {
        this.attributeFilter = attributeFilter;
        return this;
    }

    public DiffBuilder withNodeFilter(Predicate<Node> nodeFilter) {
        this.nodeFilter = nodeFilter;
        return this;
    }

    public DiffBuilder withComparisonFormatter(ComparisonFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public DiffBuilder withDocumentBuilderFactory(DocumentBuilderFactory f) {
        this.documentBuilderFactory = f;
        return this;
    }

    public Diff build() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        CollectResultsListener collectResultsListener = new CollectResultsListener(this.comparisonResultsToCheck);
        d.addDifferenceListener(collectResultsListener);
        if (this.nodeMatcher != null) {
            d.setNodeMatcher(this.nodeMatcher);
        }
        d.setDifferenceEvaluator(this.differenceEvaluator);
        d.setComparisonController(this.comparisonController);
        for (ComparisonListener comparisonListener : this.comparisonListeners) {
            d.addComparisonListener(comparisonListener);
        }
        for (ComparisonListener comparisonListener : this.differenceListeners) {
            d.addDifferenceListener(comparisonListener);
        }
        if (this.namespaceContext != null) {
            d.setNamespaceContext(this.namespaceContext);
        }
        if (this.attributeFilter != null) {
            d.setAttributeFilter(this.attributeFilter);
        }
        if (this.nodeFilter != null) {
            d.setNodeFilter(this.nodeFilter);
        }
        if (this.documentBuilderFactory != null) {
            d.setDocumentBuilderFactory(this.documentBuilderFactory);
        }
        d.compare(this.wrap(this.controlSource), this.wrap(this.testSource));
        return this.formatter == null ? new Diff(this.controlSource, this.testSource, collectResultsListener.getDifferences()) : new Diff(this.controlSource, this.testSource, this.formatter, collectResultsListener.getDifferences());
    }

    private Source wrap(Source source) {
        Source newSource = source;
        if (this.ignoreWhitespace) {
            Source source2 = newSource = this.documentBuilderFactory != null ? new WhitespaceStrippedSource(newSource, this.documentBuilderFactory) : new WhitespaceStrippedSource(newSource);
        }
        if (this.normalizeWhitespace) {
            Source source3 = newSource = this.documentBuilderFactory != null ? new WhitespaceNormalizedSource(newSource, this.documentBuilderFactory) : new WhitespaceNormalizedSource(newSource);
        }
        if (this.ignoreComments) {
            newSource = new CommentLessSource(newSource);
        }
        return newSource;
    }

    private static final class CollectResultsListener
    implements ComparisonListener {
        private final List<Difference> results = new ArrayList<Difference>();
        private final EnumSet<ComparisonResult> comparisonResultsToCheck;

        public CollectResultsListener(ComparisonResult ... comparisonResultsToCheck) {
            this.comparisonResultsToCheck = EnumSet.copyOf(Arrays.asList(comparisonResultsToCheck));
        }

        @Override
        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
            if (this.comparisonResultsToCheck.contains((Object)outcome)) {
                this.results.add(new Difference(comparison, outcome));
            }
        }

        public List<Difference> getDifferences() {
            return Collections.unmodifiableList(this.results);
        }
    }
}

