/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde.ui;

import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.cde.ui.ConstraintSelectComposite;
import org.apache.uima.ruta.cde.utils.DocumentData;
import org.apache.uima.ruta.cde.utils.EvaluationMeasures;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class DocumentTableLabelProvider
implements ITableLabelProvider {
    private final Image green = ConstraintSelectComposite.createImage("/icons/bullet_green.png");
    private final Image yellow = ConstraintSelectComposite.createImage("/icons/bullet_yellow.png");
    private final Image red = ConstraintSelectComposite.createImage("/icons/bullet_red.png");

    public void addListener(ILabelProviderListener arg0) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof DocumentData && columnIndex == 0) {
            DocumentData data = (DocumentData)element;
            Image image = this.red;
            if (data.getAugmentedResult() * 100.0 > (double)RutaAddonsPlugin.getDefault().getPreferenceStore().getInt("AVERAGE_RESULT_THRESHOLD")) {
                image = this.yellow;
            }
            if (data.getAugmentedResult() * 100.0 > (double)RutaAddonsPlugin.getDefault().getPreferenceStore().getInt("GOOD_RESULT_THRESHOLD")) {
                image = this.green;
            }
            return image;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof DocumentData) {
            DocumentData data = (DocumentData)element;
            switch (columnIndex) {
                case 0: {
                    return null;
                }
                case 1: {
                    return data.getDocument().getName();
                }
                case 2: {
                    return String.valueOf(EvaluationMeasures.round(data.getAugmentedResult()));
                }
                case 3: {
                    return String.valueOf(EvaluationMeasures.round(data.getFMeasure()));
                }
            }
        }
        return "failure";
    }
}

