/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.uima.cas.CAS;
import org.apache.uima.ruta.textruler.core.CasCacheLoader;
import org.apache.uima.ruta.textruler.core.GlobalCASSource;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasCache {
    private static final boolean DISABLE_CACHE = false;
    private static CAS reuseCASforDisabledCache = null;
    private CasCacheLoader casLoader;
    private int cacheSize;
    private MLCacheEntry tail = null;
    private MLCacheEntry head = null;
    private HashMap<String, MLCacheEntry> map;

    public CasCache(int size, CasCacheLoader casLoader) {
        this.cacheSize = size;
        this.map = new HashMap(size);
        this.casLoader = casLoader;
    }

    public void logDebugInfo(String str) {
    }

    public boolean containsElementWithKey(String key) {
        return this.map.containsKey(key);
    }

    public CAS getCAS(String fileName) {
        MLCacheEntry entry = this.map.get(fileName);
        if (entry != null) {
            if (entry != this.head) {
                MLCacheEntry newTail;
                MLCacheEntry mLCacheEntry = newTail = entry == this.tail ? this.tail.next : this.tail;
                if (entry.prev != null) {
                    entry.prev.next = entry.next;
                }
                if (entry.next != null) {
                    entry.next.prev = entry == this.tail ? null : entry.prev;
                }
                this.tail = newTail;
                this.head.next = entry;
                entry.next = null;
                entry.prev = this.head;
                this.head = entry;
            }
        } else {
            entry = new MLCacheEntry();
            entry.key = fileName;
            entry.prev = this.head;
            entry.next = null;
            if (this.head != null) {
                this.head.next = entry;
            }
            this.head = entry;
            CAS reuseCAS = null;
            if (this.map.size() >= this.cacheSize) {
                this.tail.cas.reset();
                reuseCAS = this.tail.cas;
                this.tail.cas = null;
                this.map.remove(this.tail.key);
                this.tail = this.tail.next;
                this.tail.prev = null;
            } else if (this.tail == null) {
                this.tail = this.head;
            }
            entry.cas = this.casLoader.loadCAS(fileName, reuseCAS);
            this.map.put(fileName, entry);
            if (this.map.size() > this.cacheSize) {
                TextRulerToolkit.logIfDebug("[CASCACHE] ERROR, CACHE SIZE EXCEEDED!");
            }
        }
        return entry.cas;
    }

    private void debugList() {
        if (this.tail == null) {
            return;
        }
        MLCacheEntry e = this.tail;
        int i = 1;
        while (e.next != null) {
            e = e.next;
            if (++i <= this.map.size()) continue;
            TextRulerToolkit.log("[CASCACHE] ERROR, INNER LENGTH INCOSISTENCY! " + i + "   vs. " + this.map.size());
        }
        if (i != this.map.size()) {
            TextRulerToolkit.log("[CASCACHE] ERROR, LENGTH INCOSISTENCY! " + i + "   vs. " + this.map.size());
        }
    }

    public Collection<CAS> getCachedCASes() {
        ArrayList<CAS> result = new ArrayList<CAS>();
        for (MLCacheEntry e : this.map.values()) {
            result.add(e.cas);
        }
        return result;
    }

    public void clear() {
        this.tail = null;
        this.head = null;
        for (MLCacheEntry ce : this.map.values()) {
            ce.cas.reset();
            GlobalCASSource.releaseCAS(ce.cas);
        }
        this.map.clear();
    }

    private static class MLCacheEntry {
        public String key;
        public CAS cas;
        public MLCacheEntry prev;
        public MLCacheEntry next;

        private MLCacheEntry() {
        }

        public String toString() {
            return this.key;
        }
    }
}

