/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.example.extensions;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.string.AbstractStringExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ExampleCondition
extends AbstractRutaCondition {
    private final AbstractStringExpression dateExpr;
    private final AbstractStringExpression formatExpr;

    public ExampleCondition(AbstractStringExpression expr, AbstractStringExpression format) {
        this.dateExpr = expr;
        this.formatExpr = format;
    }

    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        String coveredText = annotation.getCoveredText();
        String dateValue = this.dateExpr.getStringValue(context, stream);
        String formatValue = this.formatExpr.getStringValue(context, stream);
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatValue);
        boolean result = false;
        try {
            Date matchedDate = dateFormat.parse(coveredText);
            Date givenDate = dateFormat.parse(dateValue);
            int compareTo = matchedDate.compareTo(givenDate);
            result = compareTo < 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new EvaluatedCondition((AbstractRutaCondition)this, result);
    }

    public AbstractStringExpression getExpr() {
        return this.dateExpr;
    }

    public AbstractStringExpression getFormatExpr() {
        return this.formatExpr;
    }
}

