/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.stylemap;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class StyleMapTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7573410680191060690L;
    Vector v;
    String[] columnNames = new String[7];
    boolean DEBUG = false;

    StyleMapTableModel(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.v != null) {
            return this.v.size();
        }
        return 0;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return ((Vector)this.v.elementAt(row)).elementAt(col);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Vector rowVector = (Vector)this.v.elementAt(row);
        rowVector.setElementAt(value, col);
        this.fireTableCellUpdated(row, col);
        if (this.DEBUG) {
            this.printDebugData();
        }
    }

    private void printDebugData() {
        int numRows = this.getRowCount();
        int numCols = this.getColumnCount();
        for (int row = 0; row < numRows; ++row) {
            System.out.print("    row " + row + ":");
            for (int column = 0; column < numCols; ++column) {
                Object value = this.getValueAt(row, column);
                if (value == null) continue;
                System.out.println("  " + String.valueOf(value));
            }
        }
        System.out.println("--------------------------");
    }

    public void set(Object[][] data) {
        if (data.length <= 0) {
            return;
        }
        this.v = new Vector(data.length);
        for (int row = 0; row < data.length; ++row) {
            Vector<Object> rowVector = new Vector<Object>(this.columnNames.length);
            for (int column = 0; column < this.columnNames.length; ++column) {
                rowVector.addElement(data[row][column]);
            }
            this.v.addElement(rowVector);
        }
    }

    public void removeRow(int row) {
        this.v.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void addRow(Vector rowVector) {
        this.v.addElement(rowVector);
        this.fireTableRowsInserted(this.v.size(), this.v.size());
    }

    public void moveRowUp(int row) {
        Vector rowVector = (Vector)this.v.elementAt(row);
        this.v.removeElementAt(row);
        this.v.insertElementAt(rowVector, row - 1);
        this.fireTableDataChanged();
    }

    public void moveRowDown(int row) {
        Vector rowVector = (Vector)this.v.elementAt(row);
        this.v.removeElementAt(row);
        this.v.insertElementAt(rowVector, row + 1);
        this.fireTableDataChanged();
    }
}

