/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.DateRangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.NumberRangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.TermRangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.UntypedRangeQuery;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQuery;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQueryVariant;
import co.elastic.clients.elasticsearch.security.query_role.RoleQuery;
import co.elastic.clients.elasticsearch.security.query_role.RoleQueryVariant;
import co.elastic.clients.elasticsearch.security.query_user.UserQuery;
import co.elastic.clients.elasticsearch.security.query_user.UserQueryVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RangeQuery
implements TaggedUnion<Kind, RangeQueryVariant>,
ApiKeyQueryVariant,
QueryVariant,
RoleQueryVariant,
UserQueryVariant,
JsonpSerializable {
    private final Kind _kind;
    private final RangeQueryVariant _value;
    public static final JsonpDeserializer<RangeQuery> _DESERIALIZER = JsonpDeserializer.lazy(RangeQuery::buildRangeQueryDeserializer);

    public ApiKeyQuery.Kind _apiKeyQueryKind() {
        return ApiKeyQuery.Kind.Range;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Range;
    }

    public RoleQuery.Kind _roleQueryKind() {
        return RoleQuery.Kind.Range;
    }

    public UserQuery.Kind _userQueryKind() {
        return UserQuery.Kind.Range;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final RangeQueryVariant _get() {
        return this._value;
    }

    public RangeQuery(RangeQueryVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._rangeQueryKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private RangeQuery(Kind kind, RangeQueryVariant value) {
        this._kind = kind;
        this._value = value;
    }

    private RangeQuery(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static RangeQuery of(Function<Builder, ObjectBuilder<RangeQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isDate() {
        return this._kind == Kind.Date;
    }

    public DateRangeQuery date() {
        return (DateRangeQuery)TaggedUnionUtils.get(this, Kind.Date);
    }

    public boolean isNumber() {
        return this._kind == Kind.Number;
    }

    public NumberRangeQuery number() {
        return (NumberRangeQuery)TaggedUnionUtils.get(this, Kind.Number);
    }

    public boolean isTerm() {
        return this._kind == Kind.Term;
    }

    public TermRangeQuery term() {
        return (TermRangeQuery)TaggedUnionUtils.get(this, Kind.Term);
    }

    public boolean isUntyped() {
        return this._kind == Kind.Untyped;
    }

    public UntypedRangeQuery untyped() {
        return (UntypedRangeQuery)TaggedUnionUtils.get(this, Kind.Untyped);
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize((Object)this._value, generator);
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    private static JsonpDeserializer<RangeQuery> buildRangeQueryDeserializer() {
        return new UnionDeserializer.Builder(RangeQuery::new, false).addMember((Object)Kind.Untyped, UntypedRangeQuery._DESERIALIZER).build();
    }

    public static enum Kind implements JsonEnum
    {
        Date("date"),
        Number("number"),
        Term("term"),
        Untyped("untyped");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RangeQuery> {
        private Kind _kind;
        private RangeQueryVariant _value;

        public ObjectBuilder<RangeQuery> date(DateRangeQuery v) {
            this._kind = Kind.Date;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RangeQuery> date(Function<DateRangeQuery.Builder, ObjectBuilder<DateRangeQuery>> fn) {
            return this.date(fn.apply(new DateRangeQuery.Builder()).build());
        }

        public ObjectBuilder<RangeQuery> number(NumberRangeQuery v) {
            this._kind = Kind.Number;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RangeQuery> number(Function<NumberRangeQuery.Builder, ObjectBuilder<NumberRangeQuery>> fn) {
            return this.number(fn.apply(new NumberRangeQuery.Builder()).build());
        }

        public ObjectBuilder<RangeQuery> term(TermRangeQuery v) {
            this._kind = Kind.Term;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RangeQuery> term(Function<TermRangeQuery.Builder, ObjectBuilder<TermRangeQuery>> fn) {
            return this.term(fn.apply(new TermRangeQuery.Builder()).build());
        }

        public ObjectBuilder<RangeQuery> untyped(UntypedRangeQuery v) {
            this._kind = Kind.Untyped;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RangeQuery> untyped(Function<UntypedRangeQuery.Builder, ObjectBuilder<UntypedRangeQuery>> fn) {
            return this.untyped(fn.apply(new UntypedRangeQuery.Builder()).build());
        }

        @Override
        public RangeQuery build() {
            this._checkSingleUse();
            return new RangeQuery(this);
        }
    }
}

