/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.scripting.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.scripting.ExpressionFilter;
import org.apache.unomi.scripting.ExpressionFilterFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionFilterFactoryImpl
implements ExpressionFilterFactory,
BundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExpressionFilterFactoryImpl.class.getName());
    private final Map<Bundle, Map<String, Set<Pattern>>> allowedExpressionPatternsByBundle = new HashMap<Bundle, Map<String, Set<Pattern>>>();
    private final Map<String, Set<Pattern>> allowedExpressionPatternsByCollection = new HashMap<String, Set<Pattern>>();
    private final Map<String, Set<Pattern>> forbiddenExpressionPatternsByCollection = new HashMap<String, Set<Pattern>>();
    private BundleContext bundleContext = null;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private boolean expressionFiltersActivated = Boolean.parseBoolean(System.getProperty("org.apache.unomi.scripting.filter.activated", "true"));

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() {
        String initialFilterCollections = System.getProperty("org.apache.unomi.scripting.filter.collections", "mvel");
        String[] initialFilterCollectionParts = initialFilterCollections.split(",");
        if (initialFilterCollectionParts != null) {
            for (String string : initialFilterCollectionParts) {
                this.allowedExpressionPatternsByCollection.put(string, this.loadPatternsFromConfig("org.apache.unomi.scripting.filter." + string + ".allow"));
                this.forbiddenExpressionPatternsByCollection.put(string, this.loadPatternsFromConfig("org.apache.unomi.scripting.filter." + string + ".forbid"));
            }
        }
        if (this.bundleContext != null) {
            this.loadPredefinedAllowedPatterns(this.bundleContext);
            for (String string : this.bundleContext.getBundles()) {
                if (string.getBundleContext() == null || string.getBundleId() == this.bundleContext.getBundle().getBundleId()) continue;
                this.loadPredefinedAllowedPatterns(string.getBundleContext());
            }
            this.bundleContext.addBundleListener((BundleListener)this);
        }
    }

    private Set<Pattern> loadPatternsFromConfig(String propertyKey) {
        String patternsFile = System.getProperty(propertyKey, null);
        if (StringUtils.isNotEmpty((CharSequence)patternsFile)) {
            HashSet<Pattern> patterns = new HashSet<Pattern>();
            try {
                JsonNode jsonPatterns = this.objectMapper.readTree(new File(patternsFile));
                for (JsonNode jsonPattern : jsonPatterns) {
                    patterns.add(Pattern.compile(jsonPattern.asText()));
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while loading expressions definition from {}", (Object)propertyKey, (Object)e);
            }
            return patterns;
        }
        return null;
    }

    public void destroy() {
        if (this.bundleContext != null) {
            this.bundleContext.removeBundleListener((BundleListener)this);
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.processBundleStartup(event.getBundle().getBundleContext());
                break;
            }
            case 256: {
                this.processBundleStop(event.getBundle().getBundleContext());
            }
        }
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.loadPredefinedAllowedPatterns(bundleContext);
    }

    private void processBundleStop(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.removePredefinedAllowedPatterns(bundleContext);
    }

    private void loadPredefinedAllowedPatterns(BundleContext bundleContext) {
        Enumeration predefinedAllowedExpressions = bundleContext.getBundle().findEntries("META-INF/cxs/expressions", "*.json", true);
        if (predefinedAllowedExpressions == null) {
            return;
        }
        HashMap predefinedAllowedExpressionsForBundle = new HashMap();
        while (predefinedAllowedExpressions.hasMoreElements()) {
            URL predefinedAllowedExpressionsURL = (URL)predefinedAllowedExpressions.nextElement();
            LOGGER.debug("Found predefined allowed expressions at {}, loading... ", (Object)predefinedAllowedExpressionsURL);
            try {
                JsonNode predefinedAllowedExpressionsNode = this.objectMapper.readTree(predefinedAllowedExpressionsURL);
                HashSet<Pattern> bundleAllowedExpressions = new HashSet<Pattern>();
                for (JsonNode predefinedAllowedExpressionNode : predefinedAllowedExpressionsNode) {
                    bundleAllowedExpressions.add(Pattern.compile(predefinedAllowedExpressionNode.asText()));
                }
                String collection = predefinedAllowedExpressionsURL.getFile().substring("/META-INF/cxs/expressions/".length(), predefinedAllowedExpressionsURL.getFile().length() - ".json".length());
                predefinedAllowedExpressionsForBundle.put(collection, bundleAllowedExpressions);
                Set<Pattern> existingAllowedExpressions = this.allowedExpressionPatternsByCollection.get(collection);
                if (existingAllowedExpressions == null) {
                    existingAllowedExpressions = new HashSet<Pattern>();
                }
                existingAllowedExpressions.addAll(bundleAllowedExpressions);
                this.allowedExpressionPatternsByCollection.put(collection, existingAllowedExpressions);
            }
            catch (IOException e) {
                LOGGER.error("Error while loading expressions definition {}", (Object)predefinedAllowedExpressionsURL, (Object)e);
            }
        }
        this.allowedExpressionPatternsByBundle.put(bundleContext.getBundle(), predefinedAllowedExpressionsForBundle);
    }

    private void removePredefinedAllowedPatterns(BundleContext bundleContext) {
        Map<String, Set<Pattern>> allowedExpressionPatternsForBundle = this.allowedExpressionPatternsByBundle.get(bundleContext.getBundle());
        for (Map.Entry<String, Set<Pattern>> allowedExpressionPatternsEntry : allowedExpressionPatternsForBundle.entrySet()) {
            Set<Pattern> allowedExpressionPatterns = this.allowedExpressionPatternsByCollection.get(allowedExpressionPatternsEntry.getKey());
            allowedExpressionPatterns.removeAll((Collection)allowedExpressionPatternsEntry.getValue());
            this.allowedExpressionPatternsByCollection.put(allowedExpressionPatternsEntry.getKey(), allowedExpressionPatterns);
        }
    }

    @Override
    public ExpressionFilter getExpressionFilter(String filterCollection) {
        if (this.expressionFiltersActivated) {
            return new ExpressionFilter(this.allowedExpressionPatternsByCollection.get(filterCollection), this.forbiddenExpressionPatternsByCollection.get(filterCollection));
        }
        return new ExpressionFilter(null, null);
    }
}

