/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.fop.image.analyser.AbstractImageReader;

public class BMPReader
extends AbstractImageReader {
    protected static final int BMP_SIG_LENGTH = 26;
    protected byte[] header;

    public String getMimeType() {
        return "image/bmp";
    }

    protected void setDefaultHeader() throws IOException {
        this.header = new byte[26];
        try {
            this.imageStream.mark(27);
            this.imageStream.read(this.header);
            this.imageStream.reset();
        }
        catch (IOException ex) {
            try {
                this.imageStream.reset();
            }
            catch (IOException iOException) {}
            throw ex;
        }
    }

    protected void setDimension() {
        int byte1 = this.header[18] & 0xFF;
        int byte2 = this.header[19] & 0xFF;
        int byte3 = this.header[20] & 0xFF;
        int byte4 = this.header[21] & 0xFF;
        long l = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        this.width = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        byte1 = this.header[22] & 0xFF;
        byte2 = this.header[23] & 0xFF;
        byte3 = this.header[24] & 0xFF;
        byte4 = this.header[25] & 0xFF;
        l = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        this.height = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean verifySignature(String uri, BufferedInputStream fis) throws IOException {
        boolean supported;
        this.imageStream = fis;
        this.setDefaultHeader();
        boolean bl = supported = this.header[0] == 66 && this.header[1] == 77;
        if (supported) {
            this.setDimension();
            return true;
        }
        return false;
    }
}

