/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.wicket.Application;
import org.apache.wicket.cdi.CdiConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanManagerLookup {
    private static final Logger log = LoggerFactory.getLogger(BeanManagerLookup.class);
    private static BeanManagerLookupStrategy lastSuccessful = BeanManagerLookupStrategy.CUSTOM;

    private BeanManagerLookup() {
    }

    public static BeanManager lookup() {
        BeanManager ret = lastSuccessful.lookup();
        if (ret != null) {
            return ret;
        }
        for (BeanManagerLookupStrategy curStrategy : BeanManagerLookupStrategy.values()) {
            ret = curStrategy.lookup();
            if (ret == null) continue;
            lastSuccessful = curStrategy;
            return ret;
        }
        throw new IllegalStateException("No BeanManager found via the CDI provider and no fallback specified. Check your CDI setup or specify a fallback BeanManager in the CdiConfiguration.");
    }

    static void detach() {
        lastSuccessful = BeanManagerLookupStrategy.CUSTOM;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum BeanManagerLookupStrategy {
        CUSTOM{

            @Override
            public BeanManager lookup() {
                CdiConfiguration cdiConfiguration = CdiConfiguration.get(Application.get());
                if (cdiConfiguration == null) {
                    throw new IllegalStateException("NonContextual injection can only be used after a CdiConfiguration is set");
                }
                return cdiConfiguration.getBeanManager();
            }
        }
        ,
        JNDI{

            @Override
            public BeanManager lookup() {
                try {
                    return (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
                }
                catch (NamingException e) {
                    return null;
                }
            }
        }
        ,
        JNDI_ENV{

            @Override
            public BeanManager lookup() {
                try {
                    return (BeanManager)InitialContext.doLookup("java:comp/env/BeanManager");
                }
                catch (NamingException e) {
                    return null;
                }
            }
        }
        ,
        CDI_PROVIDER{

            @Override
            public BeanManager lookup() {
                try {
                    return CDI.current().getBeanManager();
                }
                catch (Exception e) {
                    log.debug(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        }
        ,
        FALLBACK{

            @Override
            public BeanManager lookup() {
                return CdiConfiguration.get(Application.get()).getFallbackBeanManager();
            }
        };


        public abstract BeanManager lookup();
    }
}

