/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.resource.IScopeAwareTextResourceProcessor;
import org.apache.wicket.util.image.ImageUtil;

public class CssUrlReplacer
implements IScopeAwareTextResourceProcessor,
ICssCompressor {
    private static final Pattern URL_PATTERN = Pattern.compile("url\\([ ]*['|\"]?([^ ]*?)['|\"]?[ ]*\\)");
    public static final String EMBED_BASE64 = "embedBase64";
    private final Set<String> excludes = new LinkedHashSet<String>();

    public CssUrlReplacer() {
    }

    public CssUrlReplacer(Collection<String> excludes) {
        this.excludes.addAll(excludes);
    }

    @Override
    public String process(String input, Class<?> scope, String name) {
        for (String excludeName : this.excludes) {
            if (!name.endsWith(excludeName)) continue;
            return input;
        }
        RequestCycle cycle = RequestCycle.get();
        Url cssUrl = Url.parse(name);
        Matcher matcher = URL_PATTERN.matcher(input);
        StringBuffer output = new StringBuffer();
        while (matcher.find()) {
            CharSequence processedUrl;
            Url imageCandidateUrl = Url.parse(matcher.group(1));
            boolean embedded = false;
            if (imageCandidateUrl.isFull()) {
                processedUrl = imageCandidateUrl.toString(Url.StringMode.FULL);
            } else if (imageCandidateUrl.isContextAbsolute()) {
                processedUrl = imageCandidateUrl.toString();
            } else if (imageCandidateUrl.isDataUrl()) {
                embedded = true;
                processedUrl = imageCandidateUrl.toString();
            } else {
                PackageResourceReference imageReference;
                Url cssUrlCopy = new Url(cssUrl);
                cssUrlCopy.resolveRelative(imageCandidateUrl);
                if (cssUrlCopy.getQueryString() != null && cssUrlCopy.getQueryString().contains(EMBED_BASE64)) {
                    embedded = true;
                    imageReference = new PackageResourceReference(scope, cssUrlCopy.toString().replace("?embedBase64", ""));
                    try {
                        processedUrl = ImageUtil.createBase64EncodedImage(imageReference, true);
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException("Error while embedding an image into the css: " + String.valueOf(imageReference), e);
                    }
                } else {
                    imageReference = new PackageResourceReference(scope, cssUrlCopy.toString());
                    processedUrl = cycle.urlFor(imageReference, null);
                }
            }
            matcher.appendReplacement(output, embedded ? "url(" + String.valueOf(processedUrl) + ")" : "url('" + String.valueOf(processedUrl) + "')");
        }
        matcher.appendTail(output);
        return output.toString();
    }

    @Override
    public String compress(String original) {
        throw new UnsupportedOperationException(CssUrlReplacer.class.getSimpleName() + ".process() should be used instead!");
    }

    public Collection<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection<String> excludes) {
        this.excludes.clear();
        this.excludes.addAll(excludes);
    }
}

