/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.http2.markup.head.jetty;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.http2.markup.head.PushBuilder;
import org.apache.wicket.http2.markup.head.PushItem;
import org.apache.wicket.http2.markup.head.PushItemHeaderValue;
import org.apache.wicket.request.cycle.RequestCycle;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty9PushBuilder
implements PushBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(Jetty9PushBuilder.class);

    public void push(HttpServletRequest httpServletRequest, PushItem ... pushItems) {
        org.apache.wicket.request.Request request = RequestCycle.get().getRequest();
        HttpServletRequest httpRequest = (HttpServletRequest)request.getContainerRequest();
        org.eclipse.jetty.server.PushBuilder pushBuilder = Request.getBaseRequest((ServletRequest)httpRequest).getPushBuilder();
        if (pushBuilder != null) {
            for (PushItem pushItem : pushItems) {
                pushBuilder.path(pushItem.getUrl());
                pushItem.getHeaders().entrySet().stream().forEach(pushHeader -> {
                    String key = (String)pushHeader.getKey();
                    PushItemHeaderValue value = (PushItemHeaderValue)pushHeader.getValue();
                    if (value.getOperation() == PushItemHeaderValue.HeaderOperation.ADD) {
                        pushBuilder.addHeader(key, value.getValue());
                    } else {
                        pushBuilder.setHeader(key, value.getValue());
                    }
                });
                pushBuilder.push();
            }
        } else {
            LOG.warn("Attempted to use HTTP2 Push but it is not supported for the current request: {}!", (Object)httpRequest);
        }
    }
}

