/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.AttributePSVImpl;
import org.apache.xerces.impl.xs.ObjectFactory;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.SecuritySupport;
import org.apache.xerces.impl.xs.XMLAssertXPath2EngineImpl;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.impl.xs.assertion.XMLAssertHandler;
import org.apache.xerces.impl.xs.assertion.XSAssert;
import org.apache.xerces.impl.xs.assertion.XSAssertConstants;
import org.apache.xerces.impl.xs.assertion.XSAssertImpl;
import org.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class XSDAssertionValidator {
    XMLSchemaValidator fXmlSchemaValidator = null;
    XMLAssertHandler fAssertionProcessor = null;
    boolean fAttributesHaveAsserts = false;

    public XSDAssertionValidator(XMLSchemaValidator xMLSchemaValidator) {
        this.fXmlSchemaValidator = xMLSchemaValidator;
    }

    public void characterDataHandler(XMLString xMLString) {
        if (this.fAssertionProcessor != null) {
            this.fAssertionProcessor.characters(xMLString);
        }
    }

    public void handleStartElement(QName qName, XMLAttributes xMLAttributes) throws Exception {
        Object object;
        List list = this.getAssertsForEvaluation(qName, xMLAttributes);
        if (list != null && this.fAssertionProcessor == null) {
            Cloneable cloneable;
            object = null;
            if (list instanceof XSObjectList) {
                object = ((XSAssertImpl)((XSObjectList)list).item(0)).getXPath2NamespaceContext();
            } else {
                cloneable = (Vector)list;
                object = ((XSAssertImpl)((Vector)cloneable).get(0)).getXPath2NamespaceContext();
            }
            cloneable = new HashMap();
            cloneable.put("XPATH2_NS_CONTEXT", object);
            this.initializeAssertProcessor((Map)((Object)cloneable));
        }
        if (this.fAssertionProcessor != null) {
            object = new AugmentationsImpl();
            ((AugmentationsImpl)object).putItem(XSAssertConstants.assertList, list);
            ((AugmentationsImpl)object).putItem(XSAssertConstants.isAttrHaveAsserts, this.fAttributesHaveAsserts);
            this.fAttributesHaveAsserts = false;
            this.fAssertionProcessor.startElement(qName, xMLAttributes, (Augmentations)object);
        }
    }

    public void handleEndElement(QName qName, Augmentations augmentations) {
        if (this.fAssertionProcessor != null) {
            try {
                this.fAssertionProcessor.endElement(qName, augmentations);
            }
            catch (Exception exception) {
                throw new XNIException(exception.getMessage(), exception);
            }
        }
    }

    public void comment(XMLString xMLString) {
        if (this.fAssertionProcessor != null) {
            this.fAssertionProcessor.comment(xMLString);
        }
    }

    public void processingInstruction(String string, XMLString xMLString) {
        if (this.fAssertionProcessor != null) {
            this.fAssertionProcessor.processingInstruction(string, xMLString);
        }
    }

    private List getAssertsForEvaluation(QName qName, XMLAttributes xMLAttributes) {
        List list = null;
        XSTypeDefinition xSTypeDefinition = this.fXmlSchemaValidator.fCurrentPSVI.getTypeDefinition();
        if (xSTypeDefinition != null) {
            if (xSTypeDefinition.getTypeCategory() == 15) {
                XSObjectListImpl xSObjectListImpl = this.getAssertsFromComplexType((XSComplexTypeDefinition)xSTypeDefinition, xMLAttributes);
                if (xSObjectListImpl.size() > 0) {
                    list = xSObjectListImpl;
                }
            } else {
                list = this.getAssertsFromSimpleType((XSSimpleTypeDefinition)xSTypeDefinition);
            }
        }
        return list;
    }

    private XSObjectListImpl getAssertsFromComplexType(XSComplexTypeDefinition xSComplexTypeDefinition, XMLAttributes xMLAttributes) {
        int n;
        AbstractList abstractList;
        XSSimpleTypeDefinition xSSimpleTypeDefinition;
        XSObjectListImpl xSObjectListImpl = new XSObjectListImpl();
        XSObjectList xSObjectList = xSComplexTypeDefinition.getAssertions();
        if (xSObjectList.getLength() > 0) {
            for (int i = 0; i < xSObjectList.getLength(); ++i) {
                xSObjectListImpl.addXSObject((XSAssert)xSObjectList.get(i));
            }
        }
        if ((xSSimpleTypeDefinition = xSComplexTypeDefinition.getSimpleType()) != null) {
            if (xSComplexTypeDefinition.getDerivationMethod() == 2) {
                abstractList = XS11TypeHelper.getAssertsFromSimpleType(xSSimpleTypeDefinition);
                for (n = 0; n < ((Vector)abstractList).size(); ++n) {
                    xSObjectListImpl.addXSObject((XSAssert)((Vector)abstractList).get(n));
                }
            } else if (XS11TypeHelper.isComplexTypeDerivedFromSTList(xSComplexTypeDefinition, (short)1)) {
                abstractList = XS11TypeHelper.getAssertsFromSimpleType(((XSSimpleTypeDefinition)xSComplexTypeDefinition.getBaseType()).getItemType());
                for (n = 0; n < ((Vector)abstractList).size(); ++n) {
                    xSObjectListImpl.addXSObject((XSAssert)((Vector)abstractList).get(n));
                }
            }
        }
        abstractList = this.getAssertsFromAttributes(xMLAttributes);
        n = ((XSObjectListImpl)abstractList).getLength();
        for (int i = 0; i < n; ++i) {
            xSObjectListImpl.addXSObject(((XSObjectListImpl)abstractList).item(i));
        }
        if (n > 0) {
            this.fAttributesHaveAsserts = true;
        }
        return xSObjectListImpl;
    }

    private XSObjectListImpl getAssertsFromAttributes(XMLAttributes xMLAttributes) {
        XSObjectListImpl xSObjectListImpl = new XSObjectListImpl();
        ArrayList<XSSimpleTypeDefinition> arrayList = new ArrayList<XSSimpleTypeDefinition>();
        for (int i = 0; i < xMLAttributes.getLength(); ++i) {
            Augmentations augmentations = xMLAttributes.getAugmentations(i);
            AttributePSVImpl attributePSVImpl = (AttributePSVImpl)augmentations.getItem("ATTRIBUTE_PSVI");
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)attributePSVImpl.getTypeDefinition();
            if (xSSimpleTypeDefinition == null || XS11TypeHelper.isListContainsType(arrayList, xSSimpleTypeDefinition)) continue;
            arrayList.add(xSSimpleTypeDefinition);
            List list = this.getAssertsFromSimpleType(xSSimpleTypeDefinition);
            if (list == null) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                xSObjectListImpl.addXSObject((XSAssertImpl)iterator.next());
            }
        }
        return xSObjectListImpl;
    }

    public List getAssertsFromSimpleType(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        XSAssertImpl xSAssertImpl;
        Vector<XSAssertImpl> vector = null;
        XSObjectListImpl xSObjectListImpl = (XSObjectListImpl)xSSimpleTypeDefinition.getMultiValueFacets();
        if (xSObjectListImpl.getLength() == 0 && xSSimpleTypeDefinition.getItemType() != null) {
            xSObjectListImpl = (XSObjectListImpl)xSSimpleTypeDefinition.getItemType().getMultiValueFacets();
        } else if (xSSimpleTypeDefinition.getVariety() == 3 && (xSAssertImpl = this.getFirstAssertFromUnionMemberTypes(xSSimpleTypeDefinition.getMemberTypes())) != null) {
            vector = new Vector<XSAssertImpl>();
            vector.add(xSAssertImpl);
        }
        for (int i = 0; i < xSObjectListImpl.getLength(); ++i) {
            XSMultiValueFacet xSMultiValueFacet = (XSMultiValueFacet)xSObjectListImpl.item(i);
            if (xSMultiValueFacet.getFacetKind() != 16384) continue;
            if (vector == null) {
                vector = new Vector();
            }
            vector.addAll(xSMultiValueFacet.getAsserts());
        }
        return vector;
    }

    private XSAssertImpl getFirstAssertFromUnionMemberTypes(XSObjectList xSObjectList) {
        XSAssertImpl xSAssertImpl = null;
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            Vector vector;
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSObjectList.item(i);
            if (SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(xSSimpleTypeDefinition.getNamespace()) || (vector = XS11TypeHelper.getAssertsFromSimpleType(xSSimpleTypeDefinition)).isEmpty()) continue;
            xSAssertImpl = (XSAssertImpl)vector.get(0);
            break;
        }
        return xSAssertImpl;
    }

    private void initializeAssertProcessor(Map map) {
        String string;
        try {
            string = SecuritySupport.getSystemProperty("org.apache.xerces.assertProcessor");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        if (string == null || string.length() == 0) {
            this.fAssertionProcessor = new XMLAssertXPath2EngineImpl(map);
        } else {
            try {
                ClassLoader classLoader = ObjectFactory.findClassLoader();
                Class clazz = ObjectFactory.findProviderClass(string, classLoader, true);
                this.fAssertionProcessor = (XMLAssertHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XNIException(classNotFoundException.getMessage(), classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new XNIException(instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XNIException(illegalAccessException.getMessage(), illegalAccessException);
            }
        }
        this.fAssertionProcessor.setProperty("http://apache.org/xml/properties/assert/validator", this.fXmlSchemaValidator);
    }

    void extraCheckForSTUnionAssertsAttrs(XMLAttributes xMLAttributes) {
        XMLAttributesImpl xMLAttributesImpl = (XMLAttributesImpl)xMLAttributes;
        for (int i = 0; i < xMLAttributesImpl.getLength(); ++i) {
            Augmentations augmentations = xMLAttributesImpl.getAugmentations(i);
            AttributePSVImpl attributePSVImpl = (AttributePSVImpl)augmentations.getItem("ATTRIBUTE_PSVI");
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)attributePSVImpl.getTypeDefinition();
            List list = this.fXmlSchemaValidator.getIsAssertProcessingNeededForSTUnionAttrs();
            if (xSSimpleTypeDefinition != null && xSSimpleTypeDefinition.getVariety() == 3 && ((XSSimpleType)xSSimpleTypeDefinition.getBaseType()).getVariety() != 3) {
                if (XS11TypeHelper.isAtomicStrValueValidForSTUnion(xSSimpleTypeDefinition.getMemberTypes(), xMLAttributesImpl.getValue(i), attributePSVImpl.fValue, (short)4)) {
                    list.add(false);
                    continue;
                }
                list.add(true);
                continue;
            }
            list.add(true);
        }
    }

    void extraCheckForSTUnionAssertsElem(XSSimpleType xSSimpleType, String string, ValidatedInfo validatedInfo) {
        if (xSSimpleType.getVariety() == 3 && ((XSSimpleType)xSSimpleType.getBaseType()).getVariety() != 3 && XS11TypeHelper.isAtomicStrValueValidForSTUnion(xSSimpleType.getMemberTypes(), string, validatedInfo, (short)4)) {
            this.fXmlSchemaValidator.setIsAssertProcessingNeededForSTUnionElem(false);
        }
    }
}

