/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class ElementType
extends NodeType {
    private static final String ELEMENT = "element";
    private Element _value;
    private String _string_value;

    public ElementType() {
        this(null);
    }

    public ElementType(Element v) {
        super(v);
        this._value = v;
        this._string_value = null;
    }

    public ElementType(Element v, int nodePosition) {
        super(v);
        this._value = v;
        this._string_value = null;
    }

    public Element value() {
        return this._value;
    }

    @Override
    public String string_type() {
        return ELEMENT;
    }

    @Override
    public String string_value() {
        if (this._string_value != null) {
            return this._string_value;
        }
        this._string_value = ElementType.textnode_strings(this._value);
        return this._string_value;
    }

    @Override
    public ResultSequence typed_value() throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (!(this._value instanceof PSVIElementNSImpl)) {
            rs.add(new XSUntypedAtomic(this.string_value()));
        } else {
            PSVIElementNSImpl typeInfo = (PSVIElementNSImpl)this._value;
            if (!typeInfo.getNil()) {
                XSTypeDefinition typeDef = typeInfo.getTypeDefinition();
                if (typeDef != null) {
                    rs = this.getXDMTypedValue(typeDef, typeInfo.getItemValueTypes());
                } else {
                    rs.add(new XSUntypedAtomic(this.string_value()));
                }
            }
        }
        return rs;
    }

    private boolean isDescendantElementValidatedByWildCard(Element elemNode) {
        boolean isDescElemValByWildCard = false;
        NodeList childNodes = ((PSVIElementNSImpl)elemNode).getChildNodes();
        int ndIdex = 0;
        while (ndIdex < childNodes.getLength()) {
            PSVIElementNSImpl psviElem;
            XSTypeDefinition elemType;
            Node node = childNodes.item(ndIdex);
            if (node.getNodeType() == 1 && ((elemType = (psviElem = (PSVIElementNSImpl)node).getTypeDefinition()) == null || "anyType".equals(elemType.getName()) || this.isDescendantElementValidatedByWildCard((Element)node))) {
                isDescElemValByWildCard = true;
                break;
            }
            ++ndIdex;
        }
        return isDescElemValByWildCard;
    }

    public static String textnode_strings(Node node) {
        String result = "";
        if (node.getNodeType() == 3) {
            Text tn = (Text)node;
            result = String.valueOf(result) + tn.getData();
        }
        NodeList nl = node.getChildNodes();
        StringBuffer buf = new StringBuffer(result);
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            buf.append(ElementType.textnode_strings(n));
            ++i;
        }
        result = buf.toString();
        return result;
    }

    @Override
    public QName node_name() {
        QName name = new QName(this._value.getPrefix(), this._value.getLocalName(), this._value.getNamespaceURI());
        return name;
    }

    @Override
    public ResultSequence nilled() {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (this._value instanceof PSVIElementNSImpl) {
            PSVIElementNSImpl psviElement = (PSVIElementNSImpl)this._value;
            rs.add(new XSBoolean(psviElement.getNil()));
        } else {
            rs.add(new XSBoolean(false));
        }
        return rs;
    }

    @Override
    public boolean isID() {
        return this.isElementType("ID");
    }

    @Override
    public boolean isIDREF() {
        return this.isElementType("IDREF");
    }

    protected boolean isElementType(String typeName) {
        TypeInfo typeInfo = this._value.getSchemaTypeInfo();
        return this.isType(typeInfo, typeName);
    }
}

