/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUnsignedLong;

public class XSUnsignedInt
extends XSUnsignedLong {
    private static final String XS_UNSIGNED_INT = "xs:unsignedInt";

    public XSUnsignedInt() {
        this(BigInteger.valueOf(0L));
    }

    public XSUnsignedInt(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_UNSIGNED_INT;
    }

    @Override
    public String type_name() {
        return "unsignedInt";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.string_value());
            BigInteger min = BigInteger.valueOf(0L);
            BigInteger max = BigInteger.valueOf(0xFFFFFFFFL);
            if (bigInt.compareTo(min) < 0 || bigInt.compareTo(max) > 0) {
                throw DynamicError.cant_cast(null);
            }
            rs.add(new XSUnsignedInt(bigInt));
            return rs;
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }
}

