/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.jdk;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.jdk.PsuedoSystemClassLoader;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.logging.Log;

public class JDK12Hooks
extends JDKHooks {
    private static Log log = DiscoveryLogFactory.newLog(class$org$apache$commons$discovery$jdk$JDK12Hooks == null ? (class$org$apache$commons$discovery$jdk$JDK12Hooks = JDK12Hooks.class$("org.apache.commons.discovery.jdk.JDK12Hooks")) : class$org$apache$commons$discovery$jdk$JDK12Hooks);
    private static final ClassLoader systemClassLoader = JDK12Hooks.findSystemClassLoader();
    static /* synthetic */ Class class$org$apache$commons$discovery$jdk$JDK12Hooks;

    public static void setLog(Log _log) {
        log = _log;
    }

    public String getSystemProperty(final String propName) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(propName);
                }
                catch (SecurityException se) {
                    return null;
                }
            }
        });
    }

    public ClassLoader getThreadContextClassLoader() {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException e) {
            classLoader = null;
        }
        return classLoader;
    }

    public ClassLoader getSystemClassLoader() {
        return systemClassLoader;
    }

    public Enumeration getResources(ClassLoader loader, String resourceName) throws IOException {
        Enumeration resources;
        URL first = loader.getResource(resourceName);
        if (first == null) {
            log.debug((Object)("Could not find resource: " + resourceName));
            resources = Collections.enumeration(Collections.EMPTY_LIST);
        } else {
            try {
                resources = loader.getResources(resourceName);
            }
            catch (RuntimeException ex) {
                log.error((Object)("Exception occured during attept to get " + resourceName + " from " + first), (Throwable)ex);
                resources = Collections.enumeration(Collections.EMPTY_LIST);
            }
            resources = JDK12Hooks.getResourcesFromUrl(first, resources);
        }
        return resources;
    }

    private static Enumeration getResourcesFromUrl(final URL first, final Enumeration rest) {
        return new Enumeration(){
            private boolean firstDone;
            private URL next;
            {
                this.firstDone = first == null;
                this.next = this.getNext();
            }

            public Object nextElement() {
                URL o = this.next;
                this.next = this.getNext();
                return o;
            }

            public boolean hasMoreElements() {
                return this.next != null;
            }

            private URL getNext() {
                URL n;
                if (!this.firstDone) {
                    this.firstDone = true;
                    n = first;
                } else {
                    n = null;
                    while (rest.hasMoreElements() && n == null) {
                        n = (URL)rest.nextElement();
                        if (first == null || n == null || !n.equals(first)) continue;
                        n = null;
                    }
                }
                return n;
            }
        };
    }

    private static ClassLoader findSystemClassLoader() {
        SecurityManager security;
        ClassLoader classLoader;
        try {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException e) {
            classLoader = null;
        }
        if (classLoader == null && (security = System.getSecurityManager()) != null) {
            try {
                security.checkCreateClassLoader();
                classLoader = new PsuedoSystemClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return classLoader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

