/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.vcs.log.VcsLogProvider;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0007J\u0018\u0010\u0013\u001a\u00020\u0014*\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002J\u001d\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b\u0018J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/util/PersistentUtil;", "", "<init>", "()V", "LOG_CACHE", "Ljava/nio/file/Path;", "CORRUPTION_MARKER", "", "corruptionMarkerFile", "getCorruptionMarkerFile$annotations", "getCorruptionMarkerFile", "()Ljava/nio/file/Path;", "calcLogId", "project", "Lcom/intellij/openapi/project/Project;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "calcHash", "", "getPersistenceLogCacheDir", "projectName", "logId", "getPersistenceLogCacheDir$intellij_platform_vcs_log_impl", "getProjectLogDataDirectoryName", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nPersistentUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentUtil.kt\ncom/intellij/vcs/log/util/PersistentUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1056#2:107\n*S KotlinDebug\n*F\n+ 1 PersistentUtil.kt\ncom/intellij/vcs/log/util/PersistentUtil\n*L\n36#1:107\n*E\n"})
public final class PersistentUtil {
    @NotNull
    public static final PersistentUtil INSTANCE = new PersistentUtil();
    @JvmField
    @NotNull
    public static final Path LOG_CACHE;
    @NonNls
    @NotNull
    private static final String CORRUPTION_MARKER = "corruption.marker";

    private PersistentUtil() {
    }

    @NotNull
    public static final Path getCorruptionMarkerFile() {
        Path path = LOG_CACHE.resolve(CORRUPTION_MARKER);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @JvmStatic
    public static /* synthetic */ void getCorruptionMarkerFile$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String calcLogId(@NotNull Project project, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        return project.getLocationHash() + "." + Integer.toHexString(INSTANCE.calcHash(logProviders));
    }

    private final int calcHash(Map<VirtualFile, ? extends VcsLogProvider> $this$calcHash) {
        Iterable $this$sortedBy$iv = $this$calcHash.keySet();
        boolean $i$f$sortedBy = false;
        List sortedRoots2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VirtualFile it = (VirtualFile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPath());
                it = (VirtualFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
            }
        });
        return CollectionsKt.joinToString$default((Iterable)sortedRoots2, (CharSequence)".", null, null, (int)0, null, arg_0 -> PersistentUtil.calcHash$lambda$1($this$calcHash, arg_0), (int)30, null).hashCode();
    }

    @JvmStatic
    @NotNull
    public static final Path getPersistenceLogCacheDir$intellij_platform_vcs_log_impl(@NotNull String projectName, @NotNull String logId) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        Path path = LOG_CACHE.resolve(PersistentUtil.getProjectLogDataDirectoryName(projectName, logId));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @JvmStatic
    @NotNull
    public static final String getProjectLogDataDirectoryName(@NotNull String projectName, @NotNull String logId) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        String string = PathUtilRt.suggestFileName((String)(StringsKt.take((String)projectName, (int)7) + "." + logId), (boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"suggestFileName(...)");
        return string;
    }

    private static final CharSequence calcHash$lambda$1(Map $this_calcHash, VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return root.getPath() + "." + ((VcsLogProvider)MapsKt.getValue((Map)$this_calcHash, (Object)root)).getSupportedVcs().getName();
    }

    static {
        String[] stringArray = new String[]{"vcs-log"};
        Path path = Path.of(PathManager.getSystemPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        LOG_CACHE = path;
    }
}

