/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.AbstractInstruction;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlanes;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileBox;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileRepeat;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.StyleBuilder;

public class InstructionRepeat
extends AbstractInstruction
implements Instruction {
    private final InstructionList repeatList;
    private final Instruction parent;
    private final LinkRendering nextLinkRenderer;
    private final Swimlane swimlane;
    private final Swimlanes swimlanes;
    private Swimlane swimlaneOut;
    private Swimlane swimlaneBackward;
    private BoxStyle boxStyle;
    private boolean killed = false;
    private final BoxStyle boxStyleIn;
    private Display backward = Display.NULL;
    private Stereotype stereotypeLoop;
    private Stereotype stereotypeBack;
    private LinkRendering incoming1 = LinkRendering.none();
    private LinkRendering incoming2 = LinkRendering.none();
    private List<PositionedNote> backwardNotes = new ArrayList<PositionedNote>();
    private Display test = Display.NULL;
    private Display yes = Display.NULL;
    private Display out = Display.NULL;
    private final Display startLabel;
    private boolean testCalled = false;
    private LinkRendering endRepeatLinkRendering = LinkRendering.none();
    private final Colors colors;
    private final StyleBuilder currentStyleBuilder;
    private Colors colors2;
    private Stereotype stereotype2;

    @Override
    public boolean containsBreak() {
        return this.repeatList.containsBreak();
    }

    public InstructionRepeat(Swimlanes swimlanes, Instruction parent, LinkRendering nextLinkRenderer, Display startLabel, BoxStyle boxStyleIn, Colors colors, Stereotype stereotype) {
        this.currentStyleBuilder = swimlanes.getCurrentStyleBuilder();
        this.swimlanes = swimlanes;
        this.swimlane = swimlanes.getCurrentSwimlane();
        this.repeatList = new InstructionList(this.swimlane);
        this.boxStyleIn = boxStyleIn;
        this.startLabel = startLabel;
        this.parent = parent;
        this.nextLinkRenderer = Objects.requireNonNull(nextLinkRenderer);
        this.colors = colors;
        this.stereotypeLoop = stereotype;
    }

    private boolean isLastOfTheParent() {
        if (this.parent instanceof InstructionList) {
            return ((InstructionList)this.parent).getLast() == this;
        }
        return false;
    }

    public void setBackward(Display label, Swimlane swimlaneBackward, BoxStyle boxStyle, LinkRendering incoming1, LinkRendering incoming2, Stereotype stereotype) {
        this.backward = label;
        this.swimlaneBackward = swimlaneBackward;
        this.boxStyle = boxStyle;
        this.incoming1 = incoming1;
        this.incoming2 = incoming2;
        this.stereotypeBack = stereotype;
    }

    public boolean hasBackward() {
        return this.backward != Display.NULL;
    }

    @Override
    public CommandExecutionResult add(Instruction ins) {
        return this.repeatList.add(ins);
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        Gtile tile = this.repeatList.createGtile(skinParam, stringBounder);
        Gtile backward = this.getGtileBackward(skinParam, stringBounder);
        return new GtileRepeat(this.swimlane, tile, null, this.test, backward);
    }

    private Gtile getGtileBackward(ISkinParam skinParam, StringBounder stringBounder) {
        if (Display.isNull(this.backward)) {
            return null;
        }
        GtileBox result = GtileBox.create(stringBounder, skinParam, this.backward, this.getSwimlaneIn(), this.boxStyle, null);
        return result;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile back = this.getFtileBackward(factory);
        Ftile tmp = this.repeatList.createFtile(factory);
        tmp = factory.decorateOut(tmp, this.endRepeatLinkRendering);
        if (!this.testCalled && this.incoming1.isNone()) {
            this.incoming1 = this.swimlanes.nextLinkRenderer();
        }
        tmp = factory.repeat(this.boxStyleIn, this.stereotypeLoop, this.swimlane, this.swimlaneOut, this.startLabel, tmp, this.test, this.yes, this.out, this.colors, back, this.isLastOfTheParent(), this.incoming1, this.incoming2, this.currentStyleBuilder, this.colors2, this.stereotype2);
        tmp = FtileUtils.withSwimlaneIn(tmp, this.swimlane);
        if (this.killed) {
            return new FtileKilled(tmp);
        }
        return tmp;
    }

    private Ftile getFtileBackward(FtileFactory factory) {
        if (Display.isNull(this.backward)) {
            return null;
        }
        Ftile result = factory.activity(this.backward, this.swimlaneBackward, this.boxStyle, Colors.empty(), this.stereotypeBack, null);
        if (this.backwardNotes.size() > 0) {
            result = factory.addNote(result, this.swimlaneBackward, this.backwardNotes, VerticalAlignment.CENTER);
        }
        return result;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void setTest(Display test, Display yes, Display out, LinkRendering endRepeatLinkRendering, LinkRendering back, Swimlane swimlaneOut, Colors colors2, Stereotype stereotype2) {
        this.colors2 = colors2;
        this.stereotype2 = stereotype2;
        this.swimlaneOut = swimlaneOut;
        this.test = Objects.requireNonNull(test);
        this.yes = Objects.requireNonNull(yes);
        this.out = Objects.requireNonNull(out);
        this.endRepeatLinkRendering = endRepeatLinkRendering;
        if (!back.isNone()) {
            this.incoming1 = back;
        }
        this.testCalled = true;
    }

    @Override
    public final boolean kill() {
        if (this.testCalled) {
            this.killed = true;
            return true;
        }
        return this.repeatList.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.nextLinkRenderer;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote, Stereotype stereotype) {
        if (Display.isNull(this.backward)) {
            return this.repeatList.addNote(note, position, type, colors, swimlaneNote, stereotype);
        }
        this.backwardNotes.add(new PositionedNote(note, position, type, swimlaneNote, colors, stereotype));
        return true;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeatList.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.parent.getSwimlaneOut();
    }
}

