﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sts/STS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace STS {
namespace Model {

/**
 * <p>Contains information about the provided context. This includes the signed and
 * encrypted trusted context assertion and the context provider ARN from which the
 * trusted context assertion was generated.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/ProvidedContext">AWS
 * API Reference</a></p>
 */
class ProvidedContext {
 public:
  AWS_STS_API ProvidedContext() = default;
  AWS_STS_API ProvidedContext(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_STS_API ProvidedContext& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_STS_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_STS_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The context provider ARN from which the trusted context assertion was
   * generated.</p>
   */
  inline const Aws::String& GetProviderArn() const { return m_providerArn; }
  inline bool ProviderArnHasBeenSet() const { return m_providerArnHasBeenSet; }
  template <typename ProviderArnT = Aws::String>
  void SetProviderArn(ProviderArnT&& value) {
    m_providerArnHasBeenSet = true;
    m_providerArn = std::forward<ProviderArnT>(value);
  }
  template <typename ProviderArnT = Aws::String>
  ProvidedContext& WithProviderArn(ProviderArnT&& value) {
    SetProviderArn(std::forward<ProviderArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The signed and encrypted trusted context assertion generated by the context
   * provider. The trusted context assertion is signed and encrypted by Amazon Web
   * Services STS.</p>
   */
  inline const Aws::String& GetContextAssertion() const { return m_contextAssertion; }
  inline bool ContextAssertionHasBeenSet() const { return m_contextAssertionHasBeenSet; }
  template <typename ContextAssertionT = Aws::String>
  void SetContextAssertion(ContextAssertionT&& value) {
    m_contextAssertionHasBeenSet = true;
    m_contextAssertion = std::forward<ContextAssertionT>(value);
  }
  template <typename ContextAssertionT = Aws::String>
  ProvidedContext& WithContextAssertion(ContextAssertionT&& value) {
    SetContextAssertion(std::forward<ContextAssertionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_providerArn;

  Aws::String m_contextAssertion;
  bool m_providerArnHasBeenSet = false;
  bool m_contextAssertionHasBeenSet = false;
};

}  // namespace Model
}  // namespace STS
}  // namespace Aws
