/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WorkbenchPatcher {
    private static final Log log = Log.getLog(WorkbenchPatcher.class);

    private WorkbenchPatcher() {
    }

    public static boolean needsPerspectiveReset(@NotNull Workbench workbench) {
        Set views;
        EModelService modelService = (EModelService)workbench.getService(EModelService.class);
        if (modelService == null) {
            return false;
        }
        Set placeholders = modelService.findElements((MUIElement)workbench.getApplication(), null, MPlaceholder.class).stream().map(MApplicationElement::getElementId).collect(Collectors.toSet());
        return !placeholders.containsAll(views = WorkbenchPatcher.getExtensions("org.eclipse.ui", "perspectiveExtensions").filter(WorkbenchPatcher::isContributedByDBeaver).map(IExtension::getConfigurationElements).flatMap(Stream::of).filter(e -> e.getName().equals("perspectiveExtension")).map(IConfigurationElement::getChildren).flatMap(Stream::of).filter(e -> e.getName().equals("view")).map(x -> x.getAttribute("id")).collect(Collectors.toSet()));
    }

    public static void patchWorkbenchXmi(@NotNull Location instance) {
        Path path = WorkbenchPatcher.getWorkbenchSaveLocation(instance);
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            WorkbenchPatcher.patchWorkbenchXmi(path);
        }
        catch (Throwable e) {
            log.debug((Object)("Failed to patch workbench state file: " + String.valueOf(path)), e);
        }
    }

    private static void patchWorkbenchXmi(@NotNull Path workbenchXmi) throws Exception {
        Document document = XMLUtils.parseDocument((Path)workbenchXmi);
        boolean transformed = WorkbenchPatcher.patchPartIconsRecursively(document, WorkbenchPatcher.collectContributedParts());
        if (transformed) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "no");
            Path workbenchXmiPatch = workbenchXmi.resolveSibling(String.valueOf(workbenchXmi.getFileName()) + ".patch");
            try (OutputStream os = Files.newOutputStream(workbenchXmiPatch, new OpenOption[0]);){
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
            }
            Files.move(workbenchXmiPatch, workbenchXmi, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    private static boolean patchPartIconsRecursively(@NotNull Node node, @NotNull Map<String, PartDescriptor> parts) {
        NodeList children = node.getChildNodes();
        boolean modified = false;
        for (int i = 0; i < children.getLength(); ++i) {
            Node node2 = children.item(i);
            if (!(node2 instanceof Element)) continue;
            Element child = (Element)node2;
            if (child.hasAttribute("elementId") && child.hasAttribute("iconURI")) {
                PartDescriptor part;
                Attr iconURI = child.getAttributeNode("iconURI");
                String elementId = child.getAttribute("elementId");
                if (elementId.equals("org.eclipse.e4.ui.compatibility.editor")) {
                    elementId = WorkbenchPatcher.extractCompatibilityEditorId(child);
                }
                if ((part = parts.get(elementId)) != null && !iconURI.getNodeValue().equals(part.icon())) {
                    log.debug((Object)("Replacing icon for part '" + part.id() + "' with '" + part.icon() + "'"));
                    iconURI.setNodeValue(part.icon());
                    modified = true;
                }
            }
            modified |= WorkbenchPatcher.patchPartIconsRecursively(child, parts);
        }
        return modified;
    }

    @Nullable
    private static String extractCompatibilityEditorId(@NotNull Element element) {
        Element persistedState = XMLUtils.getChildElement((Element)element, (String)"persistedState");
        if (persistedState == null) {
            return null;
        }
        String key = persistedState.getAttribute("key");
        String value = persistedState.getAttribute("value");
        if (!"memento".equals(key)) {
            return null;
        }
        try {
            Document memento = XMLUtils.parseDocument((Reader)new StringReader(value));
            Element editor = memento.getDocumentElement();
            if (editor.getTagName().equals("editor") && editor.hasAttribute("id")) {
                return editor.getAttribute("id");
            }
        }
        catch (XMLException e) {
            log.debug((Object)"Error parsing editor memento", (Throwable)e);
        }
        return null;
    }

    @NotNull
    private static Map<String, PartDescriptor> collectContributedParts() {
        List<PartDescriptor> views = WorkbenchPatcher.getExtensions("org.eclipse.ui", "views").map(IExtension::getConfigurationElements).flatMap(Stream::of).filter(e -> e.getName().equals("view") && e.getAttribute("icon") != null).map(PartDescriptor::of).toList();
        List<PartDescriptor> editors = WorkbenchPatcher.getExtensions("org.eclipse.ui", "editors").map(IExtension::getConfigurationElements).flatMap(Stream::of).filter(e -> e.getName().equals("editor") && e.getAttribute("icon") != null).map(PartDescriptor::of).toList();
        return Stream.concat(views.stream(), editors.stream()).collect(Collectors.toMap(PartDescriptor::id, Function.identity(), (a, b) -> b));
    }

    @Nullable
    private static Path getWorkbenchSaveLocation(@NotNull Location instance) {
        try {
            Path path = RuntimeUtils.getLocalPathFromURL((URL)instance.getURL());
            return path.resolve(".metadata/.plugins/org.eclipse.e4.workbench/workbench.xmi");
        }
        catch (IOException e) {
            log.error((Object)("Unable to resolve workbench save location: " + String.valueOf(instance.getURL())), (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static Stream<IExtension> getExtensions(@NotNull String namespace, @NotNull String extensionPointName) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(namespace, extensionPointName);
        return Arrays.stream(point.getExtensions());
    }

    private static boolean isContributedByDBeaver(@NotNull IExtension extension) {
        String contributor = extension.getContributor().getName();
        return contributor.startsWith("org.jkiss.dbeaver") || contributor.startsWith("com.dbeaver");
    }

    private record PartDescriptor(@NotNull IConfigurationElement element, @NotNull String id, @NotNull String icon) {
        @NotNull
        static PartDescriptor of(@NotNull IConfigurationElement element) {
            String id = element.getAttribute("id");
            String icon = MenuHelper.getIconURI((IConfigurationElement)element, (String)"icon");
            return new PartDescriptor(element, id, icon);
        }
    }
}

