/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import com.google.common.io.ByteSource;
import java.nio.charset.Charset;
import java.util.List;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.internal.BuildOperationParameters;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GradleExecutionResult {
    private final BuildOperationParameters buildOperationParameters;
    private final ByteSource outputSource;
    private final List<BuildTask> tasks;
    private final @Nullable Throwable throwable;

    public GradleExecutionResult(BuildOperationParameters buildOperationParameters, String standardOutput, List<BuildTask> tasks) {
        this(buildOperationParameters, standardOutput, tasks, null);
    }

    public GradleExecutionResult(BuildOperationParameters buildOperationParameters, String standardOutput, List<BuildTask> tasks, @Nullable Throwable throwable) {
        this(buildOperationParameters, ByteSource.wrap((byte[])standardOutput.getBytes(Charset.defaultCharset())), tasks, throwable);
    }

    public GradleExecutionResult(BuildOperationParameters buildOperationParameters, ByteSource outputSource, List<BuildTask> tasks) {
        this(buildOperationParameters, outputSource, tasks, null);
    }

    public GradleExecutionResult(BuildOperationParameters buildOperationParameters, ByteSource outputSource, List<BuildTask> tasks, @Nullable Throwable throwable) {
        this.buildOperationParameters = buildOperationParameters;
        this.outputSource = outputSource;
        this.tasks = tasks;
        this.throwable = throwable;
    }

    public BuildOperationParameters getBuildOperationParameters() {
        return this.buildOperationParameters;
    }

    public @NonNull ByteSource getOutputSource() {
        return this.outputSource;
    }

    public List<BuildTask> getTasks() {
        return this.tasks;
    }

    public @Nullable Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isSuccessful() {
        return this.throwable == null;
    }
}

