/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene103.Lucene103Codec;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.codec.AdditionalCodecs;
import org.opensearch.index.codec.PerFieldMappingPostingFormatCodec;
import org.opensearch.index.codec.composite.CompositeCodecFactory;
import org.opensearch.index.mapper.MapperService;

@PublicApi(since="3.3.0")
public class CodecService {
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String LZ4 = "lz4";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String ZLIB = "zlib";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";
    private final CompositeCodecFactory compositeCodecFactory = new CompositeCodecFactory();

    @Deprecated(forRemoval=true)
    public CodecService(@Nullable MapperService mapperService, IndexSettings indexSettings, Logger logger) {
        this(mapperService, indexSettings, logger, List.of());
    }

    public CodecService(@Nullable MapperService mapperService, IndexSettings indexSettings, Logger logger, Collection<AdditionalCodecs> registries) {
        MapBuilder codecs = MapBuilder.newMapBuilder();
        assert (null != indexSettings);
        if (mapperService == null) {
            codecs.put((Object)DEFAULT_CODEC, (Object)new Lucene103Codec());
            codecs.put((Object)LZ4, (Object)new Lucene103Codec());
            codecs.put((Object)BEST_COMPRESSION_CODEC, (Object)new Lucene103Codec(Lucene103Codec.Mode.BEST_COMPRESSION));
            codecs.put((Object)ZLIB, (Object)new Lucene103Codec(Lucene103Codec.Mode.BEST_COMPRESSION));
        } else if (mapperService.isCompositeIndexPresent()) {
            codecs.putAll(this.compositeCodecFactory.getCompositeIndexCodecs(mapperService, logger));
        } else {
            codecs.put((Object)DEFAULT_CODEC, (Object)new PerFieldMappingPostingFormatCodec(Lucene103Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put((Object)LZ4, (Object)new PerFieldMappingPostingFormatCodec(Lucene103Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put((Object)BEST_COMPRESSION_CODEC, (Object)new PerFieldMappingPostingFormatCodec(Lucene103Codec.Mode.BEST_COMPRESSION, mapperService, logger));
            codecs.put((Object)ZLIB, (Object)new PerFieldMappingPostingFormatCodec(Lucene103Codec.Mode.BEST_COMPRESSION, mapperService, logger));
        }
        codecs.put((Object)LUCENE_DEFAULT_CODEC, (Object)Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put((Object)codec, (Object)Codec.forName((String)codec));
        }
        Supplier<Codec> defaultCodec = () -> (Codec)codecs.get((Object)DEFAULT_CODEC);
        for (AdditionalCodecs registry : registries) {
            Map<String, Codec> additionalCodecs = registry.getCodecs(mapperService, indexSettings, defaultCodec);
            for (Map.Entry<String, Codec> additionalCodec : additionalCodecs.entrySet()) {
                String name = additionalCodec.getKey();
                if (name.equalsIgnoreCase(LUCENE_DEFAULT_CODEC)) {
                    throw new IllegalStateException("The default codec could not be replaced");
                }
                Codec existing = (Codec)codecs.get((Object)name);
                if (existing == null) {
                    codecs.put((Object)name, (Object)additionalCodec.getValue());
                    continue;
                }
                throw new IllegalStateException("The codec with name " + name + " is already registered.");
            }
        }
        this.codecs = codecs.immutableMap();
    }

    public final Codec defaultCodec() {
        return this.codecs.get(DEFAULT_CODEC);
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }
}

