"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderBubbles = void 0;
var canvas_1 = require("../../../../renderers/canvas");
var utils_1 = require("../../rendering/utils");
var points_1 = require("./points");
function renderBubbles(ctx, props) {
    canvas_1.withContext(ctx, function (ctx) {
        var _a;
        var bubbles = props.bubbles, sharedStyle = props.sharedStyle, highlightedLegendItem = props.highlightedLegendItem, clippings = props.clippings, rotation = props.rotation, renderingArea = props.renderingArea;
        var geometryStyles = {};
        var pointStyles = {};
        var allPoints = bubbles.reduce(function (acc, _a) {
            var _b = _a.value, seriesIdentifier = _b.seriesIdentifier, seriesPointStyle = _b.seriesPointStyle, points = _b.points;
            geometryStyles[seriesIdentifier.key] = utils_1.getGeometryStateStyle(seriesIdentifier, sharedStyle, highlightedLegendItem);
            pointStyles[seriesIdentifier.key] = seriesPointStyle;
            acc.push.apply(acc, __spread(points));
            return acc;
        }, []);
        if (allPoints.length === 0) {
            return;
        }
        points_1.renderPointGroup(ctx, allPoints, pointStyles, geometryStyles, rotation, renderingArea, clippings, ((_a = allPoints[0]) === null || _a === void 0 ? void 0 : _a.value.mark) !== null);
    });
}
exports.renderBubbles = renderBubbles;
//# sourceMappingURL=bubbles.js.map