/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class PreferencesLayoutPanel
extends JComponent {
    private static final Insets INSETS = new Insets(0, 0, 0, 0);
    private final JPanel backingPanel;
    private int currentRow = 0;
    private int componentCol = 1;
    private List<JRadioButton> currentButtonRun = new ArrayList<JRadioButton>();

    public PreferencesLayoutPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.backingPanel = new JPanel(new GridBagLayout());
        this.add((Component)this.backingPanel, "North");
    }

    public void setUseVerticalLabelling(boolean useVerticalLabelling) {
        this.componentCol = useVerticalLabelling ? 0 : 1;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.backingPanel.getPreferredSize();
    }

    public void addSeparator() {
        this.backingPanel.add((Component)new JSeparator(), new GridBagConstraints(0, this.currentRow, 3, 1, 100.0, 0.0, 512, 2, new Insets(5, 0, 5, 0), 0, 0));
        ++this.currentRow;
    }

    public void addVerticalPadding() {
        this.backingPanel.add(Box.createVerticalStrut(12), new GridBagConstraints(0, this.currentRow, 3, 1, 100.0, 0.0, 512, 2, INSETS, 0, 0));
        ++this.currentRow;
    }

    public void addGroup(String groupLabel) {
        JLabel label = new JLabel(groupLabel);
        int alignment = this.isUseVerticalLabelling() ? 1280 : 1536;
        label.setFont(label.getFont().deriveFont(1));
        this.backingPanel.add((Component)label, new GridBagConstraints(0, this.currentRow, 1, 1, 0.0, 0.0, alignment, 0, new Insets(0, 0, 0, 10), 0, 0));
        if (this.isUseVerticalLabelling()) {
            ++this.currentRow;
        }
    }

    private boolean isUseVerticalLabelling() {
        return this.componentCol == 0;
    }

    public void addGroupComponent(JComponent component) {
        this.handleComponentAdded(component);
        Insets insets = this.currentRow == 0 ? INSETS : (component instanceof JRadioButton ? INSETS : (component instanceof JCheckBox ? INSETS : new Insets(4, 0, 4, 0)));
        this.backingPanel.add((Component)component, new GridBagConstraints(this.componentCol, this.currentRow, 2, 1, 100.0, 0.0, 512, 0, insets, 0, 0));
        if (component instanceof JTextField) {
            JTextField field = (JTextField)component;
            field.setMinimumSize(field.getPreferredSize());
        }
        ++this.currentRow;
    }

    public void closeCurrentButtonRun() {
        if (this.currentButtonRun.isEmpty()) {
            return;
        }
        ButtonGroup bg = new ButtonGroup();
        for (JRadioButton button : this.currentButtonRun) {
            bg.add(button);
        }
        this.currentButtonRun.clear();
    }

    public void addIndentedGroupComponent(JComponent component) {
        this.handleComponentAdded(component);
        this.backingPanel.add((Component)component, new GridBagConstraints(this.componentCol, this.currentRow, 2, 1, 100.0, 0.0, 512, 0, new Insets(0, 50, 0, 0), 0, 0));
        if (component instanceof JTextField) {
            JTextField field = (JTextField)component;
            field.setMinimumSize(field.getPreferredSize());
        }
        ++this.currentRow;
    }

    private void handleComponentAdded(JComponent component) {
        if (component instanceof JRadioButton) {
            this.currentButtonRun.add((JRadioButton)component);
        }
    }

    public void addHelpText(String helpText) {
        JLabel label = new JLabel(helpText);
        label.setFont(label.getFont().deriveFont(0, 10.0f));
        label.setForeground(Color.GRAY);
        label.setBorder(BorderFactory.createEmptyBorder(3, 20, 7, 0));
        this.addGroupComponent(label);
    }

    public void addLabelledGroupComponent(String label, JComponent component) {
        this.backingPanel.add((Component)new JLabel(label), new GridBagConstraints(1, this.currentRow, 1, 1, 0.0, 0.0, 768, 0, INSETS, 0, 0));
        if (this.isUseVerticalLabelling()) {
            ++this.currentRow;
        }
        this.backingPanel.add((Component)component, new GridBagConstraints(this.componentCol, this.currentRow, 1, 1, 100.0, 0.0, 512, 0, INSETS, 0, 0));
        ++this.currentRow;
    }
}

