/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.res.StringManager;

public class NioChannel
implements ByteChannel,
ScatteringByteChannel,
GatheringByteChannel {
    protected static final StringManager sm = StringManager.getManager(NioChannel.class);
    protected static final ByteBuffer emptyBuf = ByteBuffer.allocate(0);
    protected final SocketBufferHandler bufHandler;
    protected SocketChannel sc = null;
    protected NioEndpoint.NioSocketWrapper socketWrapper = null;
    private ApplicationBufferHandler appReadBufHandler;
    static final NioChannel CLOSED_NIO_CHANNEL = new NioChannel(SocketBufferHandler.EMPTY){

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void reset(SocketChannel socketChannel, NioEndpoint.NioSocketWrapper nioSocketWrapper) throws IOException {
        }

        @Override
        public void free() {
        }

        @Override
        protected ApplicationBufferHandler getAppReadBufHandler() {
            return ApplicationBufferHandler.EMPTY;
        }

        @Override
        public void setAppReadBufHandler(ApplicationBufferHandler applicationBufferHandler) {
        }

        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            return -1;
        }

        @Override
        public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            return -1L;
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            this.checkInterruptStatus();
            throw new ClosedChannelException();
        }

        @Override
        public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            throw new ClosedChannelException();
        }

        @Override
        public String toString() {
            return "Closed NioChannel";
        }
    };

    public NioChannel(SocketBufferHandler socketBufferHandler) {
        this.bufHandler = socketBufferHandler;
    }

    public void reset(SocketChannel socketChannel, NioEndpoint.NioSocketWrapper nioSocketWrapper) throws IOException {
        this.sc = socketChannel;
        this.socketWrapper = nioSocketWrapper;
        this.bufHandler.reset();
    }

    NioEndpoint.NioSocketWrapper getSocketWrapper() {
        return this.socketWrapper;
    }

    public void free() {
        this.bufHandler.free();
    }

    @Override
    public void close() throws IOException {
        this.sc.close();
    }

    public void close(boolean bl) throws IOException {
        if (this.isOpen() || bl) {
            this.close();
        }
    }

    @Override
    public boolean isOpen() {
        return this.sc.isOpen();
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.checkInterruptStatus();
        if (!byteBuffer.hasRemaining()) {
            return 0;
        }
        return this.sc.write(byteBuffer);
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.write(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        this.checkInterruptStatus();
        return this.sc.write(byteBufferArray, n, n2);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.sc.read(byteBuffer);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.read(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.sc.read(byteBufferArray, n, n2);
    }

    public SocketBufferHandler getBufHandler() {
        return this.bufHandler;
    }

    public SocketChannel getIOChannel() {
        return this.sc;
    }

    public boolean isClosing() {
        return false;
    }

    public boolean isHandshakeComplete() {
        return true;
    }

    public int handshake(boolean bl, boolean bl2) throws IOException {
        return 0;
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.sc);
    }

    public int getOutboundRemaining() {
        return 0;
    }

    public boolean flushOutbound() throws IOException {
        return false;
    }

    protected void checkInterruptStatus() throws IOException {
        if (Thread.interrupted()) {
            throw new IOException(sm.getString("channel.nio.interrupted"));
        }
    }

    public void setAppReadBufHandler(ApplicationBufferHandler applicationBufferHandler) {
        this.appReadBufHandler = applicationBufferHandler;
    }

    protected ApplicationBufferHandler getAppReadBufHandler() {
        return this.appReadBufHandler;
    }
}

