# -*- coding: utf-8 -*-
# Copyright 2024 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the iosxr_vrf_address_family module
"""


class Vrf_address_familyArgs(object):  # pylint: disable=R0903
    """The arg spec for the iosxr_vrf_address_family module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str", "required": True},
                "address_families": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "afi": {"type": "str", "choices": ["ipv4", "ipv6"]},
                        "safi": {
                            "type": "str",
                            "choices": ["flowspec", "multicast", "unicast"],
                        },
                        "export": {
                            "type": "dict",
                            "options": {
                                "route_policy": {"type": "str"},
                                "route_target": {"type": "str"},
                                "to": {
                                    "type": "dict",
                                    "options": {
                                        "default_vrf": {
                                            "type": "dict",
                                            "options": {
                                                "route_policy": {"type": "str"},
                                            },
                                        },
                                        "vrf": {
                                            "type": "dict",
                                            "options": {
                                                "allow_imported_vpn": {
                                                    "type": "bool",
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "import_config": {
                            "type": "dict",
                            "options": {
                                "route_policy": {"type": "str"},
                                "route_target": {"type": "str"},
                                "from_config": {
                                    "type": "dict",
                                    "options": {
                                        "bridge_domain": {
                                            "type": "dict",
                                            "options": {
                                                "advertise_as_vpn": {
                                                    "type": "bool",
                                                },
                                            },
                                        },
                                        "default_vrf": {
                                            "type": "dict",
                                            "options": {
                                                "route_policy": {"type": "str"},
                                            },
                                        },
                                        "vrf": {
                                            "type": "dict",
                                            "options": {
                                                "advertise_as_vpn": {
                                                    "type": "bool",
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "maximum": {
                            "type": "dict",
                            "options": {"prefix": {"type": "int"}},
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "parsed",
                "gathered",
                "deleted",
                "merged",
                "replaced",
                "rendered",
                "overridden",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
