﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/frauddetector/FraudDetector_EXPORTS.h>
#include <aws/frauddetector/model/DetectorVersionStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FraudDetector {
namespace Model {

/**
 * <p>The summary of the detector version.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DetectorVersionSummary">AWS
 * API Reference</a></p>
 */
class DetectorVersionSummary {
 public:
  AWS_FRAUDDETECTOR_API DetectorVersionSummary() = default;
  AWS_FRAUDDETECTOR_API DetectorVersionSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_FRAUDDETECTOR_API DetectorVersionSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FRAUDDETECTOR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The detector version ID. </p>
   */
  inline const Aws::String& GetDetectorVersionId() const { return m_detectorVersionId; }
  inline bool DetectorVersionIdHasBeenSet() const { return m_detectorVersionIdHasBeenSet; }
  template <typename DetectorVersionIdT = Aws::String>
  void SetDetectorVersionId(DetectorVersionIdT&& value) {
    m_detectorVersionIdHasBeenSet = true;
    m_detectorVersionId = std::forward<DetectorVersionIdT>(value);
  }
  template <typename DetectorVersionIdT = Aws::String>
  DetectorVersionSummary& WithDetectorVersionId(DetectorVersionIdT&& value) {
    SetDetectorVersionId(std::forward<DetectorVersionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The detector version status. </p>
   */
  inline DetectorVersionStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(DetectorVersionStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline DetectorVersionSummary& WithStatus(DetectorVersionStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The detector version description. </p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DetectorVersionSummary& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Timestamp of when the detector version was last updated.</p>
   */
  inline const Aws::String& GetLastUpdatedTime() const { return m_lastUpdatedTime; }
  inline bool LastUpdatedTimeHasBeenSet() const { return m_lastUpdatedTimeHasBeenSet; }
  template <typename LastUpdatedTimeT = Aws::String>
  void SetLastUpdatedTime(LastUpdatedTimeT&& value) {
    m_lastUpdatedTimeHasBeenSet = true;
    m_lastUpdatedTime = std::forward<LastUpdatedTimeT>(value);
  }
  template <typename LastUpdatedTimeT = Aws::String>
  DetectorVersionSummary& WithLastUpdatedTime(LastUpdatedTimeT&& value) {
    SetLastUpdatedTime(std::forward<LastUpdatedTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_detectorVersionId;

  DetectorVersionStatus m_status{DetectorVersionStatus::NOT_SET};

  Aws::String m_description;

  Aws::String m_lastUpdatedTime;
  bool m_detectorVersionIdHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_lastUpdatedTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace FraudDetector
}  // namespace Aws
