# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "monitor log-analytics workspace get-schema",
)
class GetSchema(AAZCommand):
    """Get the schema for a given workspace.

    Schema represents the internal structure of the workspace, which can be used during the query.
    For more information, visit: https://learn.microsoft.com/en-us/rest/api/loganalytics/workspace-schema/get

    :example: Get the schema for a given workspace.
        az monitor log-analytics workspace get-schema --resource-group MyResourceGroup --workspace-name MyWorkspace
    """

    _aaz_info = {
        "version": "2020-08-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.operationalinsights/workspaces/{}/schema", "2020-08-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.workspace_name = AAZStrArg(
            options=["-n", "--name", "--workspace-name"],
            help="The name of the workspace.",
            required=True,
            fmt=AAZStrArgFormat(
                pattern="^[A-Za-z0-9][A-Za-z0-9-]+[A-Za-z0-9]$",
                max_length=63,
                min_length=4,
            ),
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.SchemaGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class SchemaGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/schema",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "workspaceName", self.ctx.args.workspace_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2020-08-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.metadata = AAZObjectType()
            _schema_on_200.value = AAZListType()

            metadata = cls._schema_on_200.metadata
            metadata.aggregated_grouping_fields = AAZStrType(
                serialized_name="aggregatedGroupingFields",
            )
            metadata.aggregated_value_field = AAZStrType(
                serialized_name="aggregatedValueField",
            )
            metadata.core_summaries = AAZListType(
                serialized_name="coreSummaries",
            )
            metadata.e_tag = AAZStrType(
                serialized_name="eTag",
            )
            metadata.id = AAZStrType()
            metadata.last_updated = AAZStrType(
                serialized_name="lastUpdated",
            )
            metadata.max = AAZIntType()
            metadata.request_id = AAZStrType(
                serialized_name="requestId",
            )
            metadata.request_time = AAZIntType(
                serialized_name="requestTime",
            )
            metadata.result_type = AAZStrType(
                serialized_name="resultType",
            )
            metadata.schema = AAZObjectType()
            metadata.sort = AAZListType()
            metadata.start_time = AAZStrType(
                serialized_name="startTime",
            )
            metadata.status = AAZStrType()
            metadata.sum = AAZIntType()
            metadata.top = AAZIntType()
            metadata.total = AAZIntType()

            core_summaries = cls._schema_on_200.metadata.core_summaries
            core_summaries.Element = AAZObjectType()

            _element = cls._schema_on_200.metadata.core_summaries.Element
            _element.number_of_documents = AAZIntType(
                serialized_name="numberOfDocuments",
                flags={"required": True},
            )
            _element.status = AAZStrType()

            schema = cls._schema_on_200.metadata.schema
            schema.name = AAZStrType()
            schema.version = AAZIntType()

            sort = cls._schema_on_200.metadata.sort
            sort.Element = AAZObjectType()

            _element = cls._schema_on_200.metadata.sort.Element
            _element.name = AAZStrType()
            _element.order = AAZStrType()

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.display_name = AAZStrType(
                serialized_name="displayName",
            )
            _element.facet = AAZBoolType(
                flags={"required": True},
            )
            _element.indexed = AAZBoolType(
                flags={"required": True},
            )
            _element.name = AAZStrType()
            _element.owner_type = AAZListType(
                serialized_name="ownerType",
            )
            _element.stored = AAZBoolType(
                flags={"required": True},
            )
            _element.type = AAZStrType()

            owner_type = cls._schema_on_200.value.Element.owner_type
            owner_type.Element = AAZStrType()

            return cls._schema_on_200


class _GetSchemaHelper:
    """Helper class for GetSchema"""


__all__ = ["GetSchema"]
