/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.update;

import java.io.IOException;
import java.util.Calendar;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationActivator;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class DBeaverVersionChecker
extends AbstractJob {
    private static final Log log = Log.getLog(DBeaverVersionChecker.class);
    private static final boolean SKIP_VERSION_CHECK;
    private static final Version OVERRIDE_PRODUCT_VERSION;
    private final boolean showAlways;

    public DBeaverVersionChecker(boolean force) {
        super("DBeaver new version release checker");
        this.showAlways = force;
        this.setUser(false);
        this.setSystem(true);
    }

    @NotNull
    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
        VersionDescriptor newVersion;
        long lastVersionCheckTime;
        if (monitor.isCanceled() || DBWorkbench.getPlatform().isShuttingDown()) {
            return Status.CANCEL_STATUS;
        }
        boolean showUpdateDialog = this.showAlways;
        if (!showUpdateDialog && (showUpdateDialog = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ui.auto.update.check")) && (lastVersionCheckTime = DBWorkbench.getPlatform().getPreferenceStore().getLong("ui.auto.update.check.time")) > 0L) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(lastVersionCheckTime);
            int checkMonth = cal.get(2);
            int checkDay = cal.get(5);
            cal.setTimeInMillis(System.currentTimeMillis());
            int curMonth = cal.get(2);
            int curDay = cal.get(5);
            if (curMonth == checkMonth && curDay == checkDay) {
                return Status.OK_STATUS;
            }
        }
        if (!this.showAlways && !showUpdateDialog) {
            return Status.OK_STATUS;
        }
        DBWorkbench.getPlatform().getPreferenceStore().setValue("ui.auto.update.check.time", System.currentTimeMillis());
        IProduct product = Platform.getProduct();
        if (product == null) {
            log.error((Object)"No Eclipse product found. Installation is corrupted");
            return Status.OK_STATUS;
        }
        String updateURL = product.getProperty("versionUpdateURL");
        if (updateURL == null) {
            return Status.OK_STATUS;
        }
        Version currentVersion = DBeaverVersionChecker.getProductVersion();
        try {
            newVersion = new VersionDescriptor(DBWorkbench.getPlatform(), updateURL);
        }
        catch (IOException e) {
            if (this.showAlways) {
                DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_version_update_title, CoreMessages.dialog_version_update_error_cannot_check_version, (Throwable)e);
            }
            return Status.CANCEL_STATUS;
        }
        if (this.showAlways || !DBeaverVersionChecker.isSuppressed(newVersion) && (SKIP_VERSION_CHECK || newVersion.getProgramVersion().compareTo(currentVersion) > 0)) {
            this.showUpdaterDialog(currentVersion, newVersion);
        }
        return Status.OK_STATUS;
    }

    private void showUpdaterDialog(@NotNull Version currentVersion, @NotNull VersionDescriptor newVersion) {
        UIUtils.asyncExec(() -> DBeaverApplication.getInstance().notifyVersionUpgrade(currentVersion, newVersion, !this.showAlways));
    }

    private static boolean isSuppressed(@NotNull VersionDescriptor version) {
        CoreApplicationActivator activator = CoreApplicationActivator.getDefault();
        return activator != null && activator.getPreferenceStore().getBoolean("suppressUpdateCheck." + version.getPlainVersion());
    }

    @NotNull
    private static Version getProductVersion() {
        return OVERRIDE_PRODUCT_VERSION == null ? GeneralUtils.getProductVersion() : OVERRIDE_PRODUCT_VERSION;
    }

    static {
        String versionProperty = CommonUtils.toString((Object)System.getProperty("dbeaver.debug.override-product-version"));
        Version version = null;
        if (CommonUtils.isNotEmpty((String)versionProperty)) {
            try {
                version = new Version(versionProperty);
            }
            catch (Exception e) {
                log.debug((Object)("Cannot parse override version '" + versionProperty + "'"), (Throwable)e);
            }
        }
        OVERRIDE_PRODUCT_VERSION = version;
        SKIP_VERSION_CHECK = CommonUtils.toBoolean((Object)System.getProperty("dbeaver.debug.skip-version-check"));
    }
}

