/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime.features;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.features.DBRFeature;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureTracker;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DBRFeatureRegistry {
    private static final Log log = Log.getLog(DBRFeatureRegistry.class);
    private final Map<String, DBRFeature> allFeatures = new LinkedHashMap<String, DBRFeature>();
    private final Map<String, DBRFeature> commandFeatures = new HashMap<String, DBRFeature>();
    private final DBRFeatureTracker tracker = GeneralUtils.adapt(this, DBRFeatureTracker.class);
    private static DBRFeatureRegistry instance = null;

    public static synchronized DBRFeatureRegistry getInstance() {
        if (instance == null) {
            instance = new DBRFeatureRegistry();
        }
        return instance;
    }

    private DBRFeatureRegistry() {
    }

    public void startTracking() {
        if (this.tracker != null) {
            this.tracker.startTracking();
        }
    }

    public void endTracking() {
        if (this.tracker != null) {
            this.tracker.dispose();
        }
    }

    public synchronized void registerFeatures(Class<?> theClass) {
        for (Field field : theClass.getDeclaredFields()) {
            if ((field.getModifiers() & 8) == 0 || field.getType() != DBRFeature.class) continue;
            try {
                DBRFeature feature = (DBRFeature)field.get(null);
                if (feature == null) continue;
                String id = field.getName();
                feature.setId(id);
                if (this.allFeatures.containsKey(id)) {
                    log.warn("Duplicate feature definition: " + id);
                }
                this.allFeatures.put(id, feature);
                if (CommonUtils.isEmpty((String)feature.getCommandId())) continue;
                this.commandFeatures.put(feature.getCommandId(), feature);
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    public List<DBRFeature> getAllFeatures() {
        return new ArrayList<DBRFeature>(this.allFeatures.values());
    }

    public DBRFeature findCommandFeature(String commandId) {
        return this.commandFeatures.get(commandId);
    }

    public static void useFeature(DBRFeature feature, Map<String, Object> parameters) {
        if (DBRFeatureRegistry.instance.tracker != null) {
            DBRFeatureRegistry.instance.tracker.trackFeature(feature, parameters);
        }
        QMUtils.getDefaultHandler().handleFeatureUsage(feature, parameters);
    }
}

