/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml.rules;

import com.tngtech.archunit.library.plantuml.rules.ComponentIdentifier;
import com.tngtech.archunit.library.plantuml.rules.ParsedDependency;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlComponent;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlComponentDependency;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlComponents;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;

class PlantUmlDiagram {
    private final PlantUmlComponents plantUmlComponents;

    private PlantUmlDiagram(Builder builder) {
        this.plantUmlComponents = Preconditions.checkNotNull(builder.plantUmlComponents);
    }

    Set<PlantUmlComponent> getAllComponents() {
        return ImmutableSet.copyOf(this.plantUmlComponents.getAllComponents());
    }

    Set<PlantUmlComponent> getComponentsWithAlias() {
        return ImmutableSet.copyOf(this.plantUmlComponents.getComponentsWithAlias());
    }

    static class Builder {
        private final PlantUmlComponents plantUmlComponents;
        private Multimap<ComponentIdentifier, ParsedDependency> originToParsedDependency;

        Builder(PlantUmlComponents plantUmlComponents) {
            this.plantUmlComponents = plantUmlComponents;
        }

        Builder withDependencies(List<ParsedDependency> dependencies) {
            this.originToParsedDependency = FluentIterable.from(dependencies).index(ParsedDependency::getOrigin);
            return this;
        }

        PlantUmlDiagram build() {
            for (PlantUmlComponent component : this.plantUmlComponents.getAllComponents()) {
                this.finish(component);
            }
            return new PlantUmlDiagram(this);
        }

        private void finish(PlantUmlComponent component) {
            ImmutableList.Builder dependencies = ImmutableList.builder();
            for (ParsedDependency dependencyOriginatingFromComponent : this.originToParsedDependency.get(component.getIdentifier())) {
                PlantUmlComponent target = this.plantUmlComponents.findComponentWith(dependencyOriginatingFromComponent.getTarget());
                dependencies.add(new PlantUmlComponentDependency(component, target));
            }
            component.finish((List<PlantUmlComponentDependency>)((Object)dependencies.build()));
        }
    }
}

