---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Exposure of Private Personal Information (PII) to an unauthorized actor (United States social security number)
---

## Description

The target application was found to return Social Security Number (SSN) information in the response. Organizations
found returning such information may be in violation of (United States) state or federal laws and may face stiff penalties.

## Remediation

PII such as social security numbers should never be directly returned to the user. The majority of the information
should masked except the last few digits or characters of the identifier. For example, social security numbers
only be displayed with the last four digits: `***-**-1234`. Ensure this masking is done on the server
and only then send the masked data back to the client. Do not rely on client side JavaScript or other methods
to mask these values as the data could still be intercepted or unmasked.

Additionally, social security numbers should never be stored un-encrypted in files or databases.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 359.2 | true | 359 | Passive | Medium |

## Links

- [OWASP Top 10 A3 2017 - Sensitive Data Exposure](https://owasp.org/www-project-top-ten/2017/A3_2017-Sensitive_Data_Exposure)
- [CWE](https://cwe.mitre.org/data/definitions/359.html)
- [Privacy Act (CMPPA)](https://www.ssa.gov/dataexchange/privacyinfo.html)
