"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// ../../node_modules/browserfs/dist/node/core/api_error.js
var require_api_error = __commonJS({
  "../../node_modules/browserfs/dist/node/core/api_error.js"(exports) {
    var __extends = exports && exports.__extends || function() {
      var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d, b) {
        d.__proto__ = b;
      } || function(d, b) {
        for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      };
      return function(d, b) {
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    exports.__esModule = true;
    var ErrorCode5;
    (function(ErrorCode6) {
      ErrorCode6[ErrorCode6["EPERM"] = 1] = "EPERM";
      ErrorCode6[ErrorCode6["ENOENT"] = 2] = "ENOENT";
      ErrorCode6[ErrorCode6["EIO"] = 5] = "EIO";
      ErrorCode6[ErrorCode6["EBADF"] = 9] = "EBADF";
      ErrorCode6[ErrorCode6["EACCES"] = 13] = "EACCES";
      ErrorCode6[ErrorCode6["EBUSY"] = 16] = "EBUSY";
      ErrorCode6[ErrorCode6["EEXIST"] = 17] = "EEXIST";
      ErrorCode6[ErrorCode6["ENOTDIR"] = 20] = "ENOTDIR";
      ErrorCode6[ErrorCode6["EISDIR"] = 21] = "EISDIR";
      ErrorCode6[ErrorCode6["EINVAL"] = 22] = "EINVAL";
      ErrorCode6[ErrorCode6["EFBIG"] = 27] = "EFBIG";
      ErrorCode6[ErrorCode6["ENOSPC"] = 28] = "ENOSPC";
      ErrorCode6[ErrorCode6["EROFS"] = 30] = "EROFS";
      ErrorCode6[ErrorCode6["ENOTEMPTY"] = 39] = "ENOTEMPTY";
      ErrorCode6[ErrorCode6["ENOTSUP"] = 95] = "ENOTSUP";
    })(ErrorCode5 = exports.ErrorCode || (exports.ErrorCode = {}));
    exports.ErrorStrings = {};
    exports.ErrorStrings[ErrorCode5.EPERM] = "Operation not permitted.";
    exports.ErrorStrings[ErrorCode5.ENOENT] = "No such file or directory.";
    exports.ErrorStrings[ErrorCode5.EIO] = "Input/output error.";
    exports.ErrorStrings[ErrorCode5.EBADF] = "Bad file descriptor.";
    exports.ErrorStrings[ErrorCode5.EACCES] = "Permission denied.";
    exports.ErrorStrings[ErrorCode5.EBUSY] = "Resource busy or locked.";
    exports.ErrorStrings[ErrorCode5.EEXIST] = "File exists.";
    exports.ErrorStrings[ErrorCode5.ENOTDIR] = "File is not a directory.";
    exports.ErrorStrings[ErrorCode5.EISDIR] = "File is a directory.";
    exports.ErrorStrings[ErrorCode5.EINVAL] = "Invalid argument.";
    exports.ErrorStrings[ErrorCode5.EFBIG] = "File is too big.";
    exports.ErrorStrings[ErrorCode5.ENOSPC] = "No space left on disk.";
    exports.ErrorStrings[ErrorCode5.EROFS] = "Cannot modify a read-only file system.";
    exports.ErrorStrings[ErrorCode5.ENOTEMPTY] = "Directory is not empty.";
    exports.ErrorStrings[ErrorCode5.ENOTSUP] = "Operation is not supported.";
    var ApiError3 = function(_super) {
      __extends(ApiError4, _super);
      function ApiError4(type, message, path) {
        if (message === void 0) {
          message = exports.ErrorStrings[type];
        }
        var _this = _super.call(this, message) || this;
        _this.syscall = "";
        _this.errno = type;
        _this.code = ErrorCode5[type];
        _this.path = path;
        _this.stack = new Error().stack;
        _this.message = "Error: " + _this.code + ": " + message + (_this.path ? ", '" + _this.path + "'" : "");
        return _this;
      }
      ApiError4.fromJSON = function(json) {
        var err = new ApiError4(0);
        err.errno = json.errno;
        err.code = json.code;
        err.path = json.path;
        err.stack = json.stack;
        err.message = json.message;
        return err;
      };
      ApiError4.fromBuffer = function(buffer, i) {
        if (i === void 0) {
          i = 0;
        }
        return ApiError4.fromJSON(JSON.parse(buffer.toString("utf8", i + 4, i + 4 + buffer.readUInt32LE(i))));
      };
      ApiError4.FileError = function(code, p) {
        return new ApiError4(code, exports.ErrorStrings[code], p);
      };
      ApiError4.ENOENT = function(path) {
        return this.FileError(ErrorCode5.ENOENT, path);
      };
      ApiError4.EEXIST = function(path) {
        return this.FileError(ErrorCode5.EEXIST, path);
      };
      ApiError4.EISDIR = function(path) {
        return this.FileError(ErrorCode5.EISDIR, path);
      };
      ApiError4.ENOTDIR = function(path) {
        return this.FileError(ErrorCode5.ENOTDIR, path);
      };
      ApiError4.EPERM = function(path) {
        return this.FileError(ErrorCode5.EPERM, path);
      };
      ApiError4.ENOTEMPTY = function(path) {
        return this.FileError(ErrorCode5.ENOTEMPTY, path);
      };
      ApiError4.prototype.toString = function() {
        return this.message;
      };
      ApiError4.prototype.toJSON = function() {
        return {
          errno: this.errno,
          code: this.code,
          path: this.path,
          stack: this.stack,
          message: this.message
        };
      };
      ApiError4.prototype.writeToBuffer = function(buffer, i) {
        if (buffer === void 0) {
          buffer = Buffer.alloc(this.bufferSize());
        }
        if (i === void 0) {
          i = 0;
        }
        var bytesWritten = buffer.write(JSON.stringify(this.toJSON()), i + 4);
        buffer.writeUInt32LE(bytesWritten, i);
        return buffer;
      };
      ApiError4.prototype.bufferSize = function() {
        return 4 + Buffer.byteLength(JSON.stringify(this.toJSON()));
      };
      return ApiError4;
    }(Error);
    exports.ApiError = ApiError3;
  }
});

// ../../node_modules/browserfs/dist/browserfs.js
var require_browserfs = __commonJS({
  "../../node_modules/browserfs/dist/browserfs.js"(exports, module2) {
    (function webpackUniversalModuleDefinition(root, factory2) {
      if (typeof exports === "object" && typeof module2 === "object")
        module2.exports = factory2();
      else if (typeof define === "function" && define.amd)
        define([], factory2);
      else if (typeof exports === "object")
        exports["BrowserFS"] = factory2();
      else
        root["BrowserFS"] = factory2();
    })(exports, function() {
      return (
        /******/
        function(modules) {
          var installedModules = {};
          function __webpack_require__(moduleId) {
            if (installedModules[moduleId])
              return installedModules[moduleId].exports;
            var module3 = installedModules[moduleId] = {
              /******/
              exports: {},
              /******/
              id: moduleId,
              /******/
              loaded: false
              /******/
            };
            modules[moduleId].call(module3.exports, module3, module3.exports, __webpack_require__);
            module3.loaded = true;
            return module3.exports;
          }
          __webpack_require__.m = modules;
          __webpack_require__.c = installedModules;
          __webpack_require__.p = "";
          return __webpack_require__(0);
        }([
          /* 0 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(Buffer2, global2, module4, process2) {
              "use strict";
              Object.defineProperty(exports2, "__esModule", { value: true });
              var buffer = __webpack_require__(2);
              var path = __webpack_require__(9);
              var ErrorCode5;
              (function(ErrorCode6) {
                ErrorCode6[ErrorCode6["EPERM"] = 1] = "EPERM";
                ErrorCode6[ErrorCode6["ENOENT"] = 2] = "ENOENT";
                ErrorCode6[ErrorCode6["EIO"] = 5] = "EIO";
                ErrorCode6[ErrorCode6["EBADF"] = 9] = "EBADF";
                ErrorCode6[ErrorCode6["EACCES"] = 13] = "EACCES";
                ErrorCode6[ErrorCode6["EBUSY"] = 16] = "EBUSY";
                ErrorCode6[ErrorCode6["EEXIST"] = 17] = "EEXIST";
                ErrorCode6[ErrorCode6["ENOTDIR"] = 20] = "ENOTDIR";
                ErrorCode6[ErrorCode6["EISDIR"] = 21] = "EISDIR";
                ErrorCode6[ErrorCode6["EINVAL"] = 22] = "EINVAL";
                ErrorCode6[ErrorCode6["EFBIG"] = 27] = "EFBIG";
                ErrorCode6[ErrorCode6["ENOSPC"] = 28] = "ENOSPC";
                ErrorCode6[ErrorCode6["EROFS"] = 30] = "EROFS";
                ErrorCode6[ErrorCode6["ENOTEMPTY"] = 39] = "ENOTEMPTY";
                ErrorCode6[ErrorCode6["ENOTSUP"] = 95] = "ENOTSUP";
              })(ErrorCode5 || (ErrorCode5 = {}));
              var ErrorStrings = {};
              ErrorStrings[ErrorCode5.EPERM] = "Operation not permitted.";
              ErrorStrings[ErrorCode5.ENOENT] = "No such file or directory.";
              ErrorStrings[ErrorCode5.EIO] = "Input/output error.";
              ErrorStrings[ErrorCode5.EBADF] = "Bad file descriptor.";
              ErrorStrings[ErrorCode5.EACCES] = "Permission denied.";
              ErrorStrings[ErrorCode5.EBUSY] = "Resource busy or locked.";
              ErrorStrings[ErrorCode5.EEXIST] = "File exists.";
              ErrorStrings[ErrorCode5.ENOTDIR] = "File is not a directory.";
              ErrorStrings[ErrorCode5.EISDIR] = "File is a directory.";
              ErrorStrings[ErrorCode5.EINVAL] = "Invalid argument.";
              ErrorStrings[ErrorCode5.EFBIG] = "File is too big.";
              ErrorStrings[ErrorCode5.ENOSPC] = "No space left on disk.";
              ErrorStrings[ErrorCode5.EROFS] = "Cannot modify a read-only file system.";
              ErrorStrings[ErrorCode5.ENOTEMPTY] = "Directory is not empty.";
              ErrorStrings[ErrorCode5.ENOTSUP] = "Operation is not supported.";
              var ApiError3 = function(Error2) {
                function ApiError4(type, message, path$$1) {
                  if (message === void 0) message = ErrorStrings[type];
                  Error2.call(this, message);
                  this.syscall = "";
                  this.errno = type;
                  this.code = ErrorCode5[type];
                  this.path = path$$1;
                  this.stack = new Error2().stack;
                  this.message = "Error: " + this.code + ": " + message + (this.path ? ", '" + this.path + "'" : "");
                }
                if (Error2) ApiError4.__proto__ = Error2;
                ApiError4.prototype = Object.create(Error2 && Error2.prototype);
                ApiError4.prototype.constructor = ApiError4;
                ApiError4.fromJSON = function fromJSON(json) {
                  var err = new ApiError4(0);
                  err.errno = json.errno;
                  err.code = json.code;
                  err.path = json.path;
                  err.stack = json.stack;
                  err.message = json.message;
                  return err;
                };
                ApiError4.fromBuffer = function fromBuffer(buffer$$1, i2) {
                  if (i2 === void 0) i2 = 0;
                  return ApiError4.fromJSON(JSON.parse(buffer$$1.toString("utf8", i2 + 4, i2 + 4 + buffer$$1.readUInt32LE(i2))));
                };
                ApiError4.FileError = function FileError(code, p) {
                  return new ApiError4(code, ErrorStrings[code], p);
                };
                ApiError4.ENOENT = function ENOENT(path$$1) {
                  return this.FileError(ErrorCode5.ENOENT, path$$1);
                };
                ApiError4.EEXIST = function EEXIST(path$$1) {
                  return this.FileError(ErrorCode5.EEXIST, path$$1);
                };
                ApiError4.EISDIR = function EISDIR(path$$1) {
                  return this.FileError(ErrorCode5.EISDIR, path$$1);
                };
                ApiError4.ENOTDIR = function ENOTDIR(path$$1) {
                  return this.FileError(ErrorCode5.ENOTDIR, path$$1);
                };
                ApiError4.EPERM = function EPERM(path$$1) {
                  return this.FileError(ErrorCode5.EPERM, path$$1);
                };
                ApiError4.ENOTEMPTY = function ENOTEMPTY(path$$1) {
                  return this.FileError(ErrorCode5.ENOTEMPTY, path$$1);
                };
                ApiError4.prototype.toString = function toString() {
                  return this.message;
                };
                ApiError4.prototype.toJSON = function toJSON() {
                  return {
                    errno: this.errno,
                    code: this.code,
                    path: this.path,
                    stack: this.stack,
                    message: this.message
                  };
                };
                ApiError4.prototype.writeToBuffer = function writeToBuffer(buffer$$1, i2) {
                  if (buffer$$1 === void 0) buffer$$1 = Buffer2.alloc(this.bufferSize());
                  if (i2 === void 0) i2 = 0;
                  var bytesWritten = buffer$$1.write(JSON.stringify(this.toJSON()), i2 + 4);
                  buffer$$1.writeUInt32LE(bytesWritten, i2);
                  return buffer$$1;
                };
                ApiError4.prototype.bufferSize = function bufferSize() {
                  return 4 + Buffer2.byteLength(JSON.stringify(this.toJSON()));
                };
                return ApiError4;
              }(Error);
              var api_error = Object.freeze({
                get ErrorCode() {
                  return ErrorCode5;
                },
                ErrorStrings,
                ApiError: ApiError3
              });
              var ActionType3;
              (function(ActionType4) {
                ActionType4[ActionType4["NOP"] = 0] = "NOP";
                ActionType4[ActionType4["THROW_EXCEPTION"] = 1] = "THROW_EXCEPTION";
                ActionType4[ActionType4["TRUNCATE_FILE"] = 2] = "TRUNCATE_FILE";
                ActionType4[ActionType4["CREATE_FILE"] = 3] = "CREATE_FILE";
              })(ActionType3 || (ActionType3 = {}));
              var FileFlag8 = function FileFlag9(flagStr) {
                this.flagStr = flagStr;
                if (FileFlag9.validFlagStrs.indexOf(flagStr) < 0) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid flag: " + flagStr);
                }
              };
              FileFlag8.getFileFlag = function getFileFlag(flagStr) {
                if (FileFlag8.flagCache.hasOwnProperty(flagStr)) {
                  return FileFlag8.flagCache[flagStr];
                }
                return FileFlag8.flagCache[flagStr] = new FileFlag8(flagStr);
              };
              FileFlag8.prototype.getFlagString = function getFlagString() {
                return this.flagStr;
              };
              FileFlag8.prototype.isReadable = function isReadable() {
                return this.flagStr.indexOf("r") !== -1 || this.flagStr.indexOf("+") !== -1;
              };
              FileFlag8.prototype.isWriteable = function isWriteable() {
                return this.flagStr.indexOf("w") !== -1 || this.flagStr.indexOf("a") !== -1 || this.flagStr.indexOf("+") !== -1;
              };
              FileFlag8.prototype.isTruncating = function isTruncating() {
                return this.flagStr.indexOf("w") !== -1;
              };
              FileFlag8.prototype.isAppendable = function isAppendable() {
                return this.flagStr.indexOf("a") !== -1;
              };
              FileFlag8.prototype.isSynchronous = function isSynchronous() {
                return this.flagStr.indexOf("s") !== -1;
              };
              FileFlag8.prototype.isExclusive = function isExclusive() {
                return this.flagStr.indexOf("x") !== -1;
              };
              FileFlag8.prototype.pathExistsAction = function pathExistsAction() {
                if (this.isExclusive()) {
                  return ActionType3.THROW_EXCEPTION;
                } else if (this.isTruncating()) {
                  return ActionType3.TRUNCATE_FILE;
                } else {
                  return ActionType3.NOP;
                }
              };
              FileFlag8.prototype.pathNotExistsAction = function pathNotExistsAction() {
                if ((this.isWriteable() || this.isAppendable()) && this.flagStr !== "r+") {
                  return ActionType3.CREATE_FILE;
                } else {
                  return ActionType3.THROW_EXCEPTION;
                }
              };
              FileFlag8.flagCache = {};
              FileFlag8.validFlagStrs = ["r", "r+", "rs", "rs+", "w", "wx", "w+", "wx+", "a", "ax", "a+", "ax+"];
              var FileType5;
              (function(FileType6) {
                FileType6[FileType6["FILE"] = 32768] = "FILE";
                FileType6[FileType6["DIRECTORY"] = 16384] = "DIRECTORY";
                FileType6[FileType6["SYMLINK"] = 40960] = "SYMLINK";
              })(FileType5 || (FileType5 = {}));
              var Stats2 = function Stats3(itemType, size, mode, atime, mtime, ctime) {
                if (atime === void 0) atime = /* @__PURE__ */ new Date();
                if (mtime === void 0) mtime = /* @__PURE__ */ new Date();
                if (ctime === void 0) ctime = /* @__PURE__ */ new Date();
                this.size = size;
                this.atime = atime;
                this.mtime = mtime;
                this.ctime = ctime;
                this.dev = 0;
                this.ino = 0;
                this.rdev = 0;
                this.nlink = 1;
                this.blksize = 4096;
                this.uid = 0;
                this.gid = 0;
                this.birthtime = /* @__PURE__ */ new Date(0);
                this.fileData = null;
                if (!mode) {
                  switch (itemType) {
                    case FileType5.FILE:
                      this.mode = 420;
                      break;
                    case FileType5.DIRECTORY:
                    default:
                      this.mode = 511;
                  }
                } else {
                  this.mode = mode;
                }
                this.blocks = Math.ceil(size / 512);
                if (this.mode < 4096) {
                  this.mode |= itemType;
                }
              };
              Stats2.fromBuffer = function fromBuffer(buffer$$1) {
                var size = buffer$$1.readUInt32LE(0), mode = buffer$$1.readUInt32LE(4), atime = buffer$$1.readDoubleLE(8), mtime = buffer$$1.readDoubleLE(16), ctime = buffer$$1.readDoubleLE(24);
                return new Stats2(mode & 61440, size, mode & 4095, new Date(atime), new Date(mtime), new Date(ctime));
              };
              Stats2.prototype.toBuffer = function toBuffer() {
                var buffer$$1 = Buffer2.alloc(32);
                buffer$$1.writeUInt32LE(this.size, 0);
                buffer$$1.writeUInt32LE(this.mode, 4);
                buffer$$1.writeDoubleLE(this.atime.getTime(), 8);
                buffer$$1.writeDoubleLE(this.mtime.getTime(), 16);
                buffer$$1.writeDoubleLE(this.ctime.getTime(), 24);
                return buffer$$1;
              };
              Stats2.prototype.clone = function clone() {
                return new Stats2(this.mode & 61440, this.size, this.mode & 4095, this.atime, this.mtime, this.ctime);
              };
              Stats2.prototype.isFile = function isFile() {
                return (this.mode & 61440) === FileType5.FILE;
              };
              Stats2.prototype.isDirectory = function isDirectory() {
                return (this.mode & 61440) === FileType5.DIRECTORY;
              };
              Stats2.prototype.isSymbolicLink = function isSymbolicLink() {
                return (this.mode & 61440) === FileType5.SYMLINK;
              };
              Stats2.prototype.chmod = function chmod(mode) {
                this.mode = this.mode & 61440 | mode;
              };
              Stats2.prototype.isSocket = function isSocket() {
                return false;
              };
              Stats2.prototype.isBlockDevice = function isBlockDevice() {
                return false;
              };
              Stats2.prototype.isCharacterDevice = function isCharacterDevice() {
                return false;
              };
              Stats2.prototype.isFIFO = function isFIFO() {
                return false;
              };
              var wrapCb = function(cb, numArgs) {
                return cb;
              };
              function assertRoot(fs2) {
                if (fs2) {
                  return fs2;
                }
                throw new ApiError3(ErrorCode5.EIO, "Initialize BrowserFS with a file system using BrowserFS.initialize(filesystem)");
              }
              function normalizeMode(mode, def) {
                switch (typeof mode) {
                  case "number":
                    return mode;
                  case "string":
                    var trueMode = parseInt(mode, 8);
                    if (!isNaN(trueMode)) {
                      return trueMode;
                    }
                    return def;
                  default:
                    return def;
                }
              }
              function normalizeTime(time) {
                if (time instanceof Date) {
                  return time;
                } else if (typeof time === "number") {
                  return new Date(time * 1e3);
                } else {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid time.");
                }
              }
              function normalizePath(p) {
                if (p.indexOf("\0") >= 0) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Path must be a string without null bytes.");
                } else if (p === "") {
                  throw new ApiError3(ErrorCode5.EINVAL, "Path must not be empty.");
                }
                return path.resolve(p);
              }
              function normalizeOptions(options, defEnc, defFlag, defMode) {
                switch (typeof options) {
                  case "object":
                    return {
                      encoding: typeof options["encoding"] !== "undefined" ? options["encoding"] : defEnc,
                      flag: typeof options["flag"] !== "undefined" ? options["flag"] : defFlag,
                      mode: normalizeMode(options["mode"], defMode)
                    };
                  case "string":
                    return {
                      encoding: options,
                      flag: defFlag,
                      mode: defMode
                    };
                  default:
                    return {
                      encoding: defEnc,
                      flag: defFlag,
                      mode: defMode
                    };
                }
              }
              function nopCb() {
              }
              var FS = function FS2() {
                this.F_OK = 0;
                this.R_OK = 4;
                this.W_OK = 2;
                this.X_OK = 1;
                this.root = null;
                this.fdMap = {};
                this.nextFd = 100;
              };
              FS.prototype.initialize = function initialize3(rootFS) {
                if (!rootFS.constructor.isAvailable()) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Tried to instantiate BrowserFS with an unavailable file system.");
                }
                return this.root = rootFS;
              };
              FS.prototype._toUnixTimestamp = function _toUnixTimestamp(time) {
                if (typeof time === "number") {
                  return time;
                } else if (time instanceof Date) {
                  return time.getTime() / 1e3;
                }
                throw new Error("Cannot parse time: " + time);
              };
              FS.prototype.getRootFS = function getRootFS() {
                if (this.root) {
                  return this.root;
                } else {
                  return null;
                }
              };
              FS.prototype.rename = function rename(oldPath, newPath, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  assertRoot(this.root).rename(normalizePath(oldPath), normalizePath(newPath), newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.renameSync = function renameSync(oldPath, newPath) {
                assertRoot(this.root).renameSync(normalizePath(oldPath), normalizePath(newPath));
              };
              FS.prototype.exists = function exists(path$$1, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  return assertRoot(this.root).exists(normalizePath(path$$1), newCb);
                } catch (e) {
                  return newCb(false);
                }
              };
              FS.prototype.existsSync = function existsSync(path$$1) {
                try {
                  return assertRoot(this.root).existsSync(normalizePath(path$$1));
                } catch (e) {
                  return false;
                }
              };
              FS.prototype.stat = function stat(path$$1, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 2);
                try {
                  return assertRoot(this.root).stat(normalizePath(path$$1), false, newCb);
                } catch (e) {
                  return newCb(e);
                }
              };
              FS.prototype.statSync = function statSync(path$$1) {
                return assertRoot(this.root).statSync(normalizePath(path$$1), false);
              };
              FS.prototype.lstat = function lstat(path$$1, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 2);
                try {
                  return assertRoot(this.root).stat(normalizePath(path$$1), true, newCb);
                } catch (e) {
                  return newCb(e);
                }
              };
              FS.prototype.lstatSync = function lstatSync(path$$1) {
                return assertRoot(this.root).statSync(normalizePath(path$$1), true);
              };
              FS.prototype.truncate = function truncate(path$$1, arg2, cb) {
                if (arg2 === void 0) arg2 = 0;
                if (cb === void 0) cb = nopCb;
                var len = 0;
                if (typeof arg2 === "function") {
                  cb = arg2;
                } else if (typeof arg2 === "number") {
                  len = arg2;
                }
                var newCb = wrapCb(cb, 1);
                try {
                  if (len < 0) {
                    throw new ApiError3(ErrorCode5.EINVAL);
                  }
                  return assertRoot(this.root).truncate(normalizePath(path$$1), len, newCb);
                } catch (e) {
                  return newCb(e);
                }
              };
              FS.prototype.truncateSync = function truncateSync(path$$1, len) {
                if (len === void 0) len = 0;
                if (len < 0) {
                  throw new ApiError3(ErrorCode5.EINVAL);
                }
                return assertRoot(this.root).truncateSync(normalizePath(path$$1), len);
              };
              FS.prototype.unlink = function unlink(path$$1, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  return assertRoot(this.root).unlink(normalizePath(path$$1), newCb);
                } catch (e) {
                  return newCb(e);
                }
              };
              FS.prototype.unlinkSync = function unlinkSync(path$$1) {
                return assertRoot(this.root).unlinkSync(normalizePath(path$$1));
              };
              FS.prototype.open = function open(path$$1, flag, arg2, cb) {
                var this$1 = this;
                if (cb === void 0) cb = nopCb;
                var mode = normalizeMode(arg2, 420);
                cb = typeof arg2 === "function" ? arg2 : cb;
                var newCb = wrapCb(cb, 2);
                try {
                  assertRoot(this.root).open(normalizePath(path$$1), FileFlag8.getFileFlag(flag), mode, function(e, file) {
                    if (file) {
                      newCb(e, this$1.getFdForFile(file));
                    } else {
                      newCb(e);
                    }
                  });
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.openSync = function openSync(path$$1, flag, mode) {
                if (mode === void 0) mode = 420;
                return this.getFdForFile(assertRoot(this.root).openSync(normalizePath(path$$1), FileFlag8.getFileFlag(flag), normalizeMode(mode, 420)));
              };
              FS.prototype.readFile = function readFile(filename, arg2, cb) {
                if (arg2 === void 0) arg2 = {};
                if (cb === void 0) cb = nopCb;
                var options = normalizeOptions(arg2, null, "r", null);
                cb = typeof arg2 === "function" ? arg2 : cb;
                var newCb = wrapCb(cb, 2);
                try {
                  var flag = FileFlag8.getFileFlag(options["flag"]);
                  if (!flag.isReadable()) {
                    return newCb(new ApiError3(ErrorCode5.EINVAL, "Flag passed to readFile must allow for reading."));
                  }
                  return assertRoot(this.root).readFile(normalizePath(filename), options.encoding, flag, newCb);
                } catch (e) {
                  return newCb(e);
                }
              };
              FS.prototype.readFileSync = function readFileSync(filename, arg2) {
                if (arg2 === void 0) arg2 = {};
                var options = normalizeOptions(arg2, null, "r", null);
                var flag = FileFlag8.getFileFlag(options.flag);
                if (!flag.isReadable()) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Flag passed to readFile must allow for reading.");
                }
                return assertRoot(this.root).readFileSync(normalizePath(filename), options.encoding, flag);
              };
              FS.prototype.writeFile = function writeFile(filename, data, arg3, cb) {
                if (arg3 === void 0) arg3 = {};
                if (cb === void 0) cb = nopCb;
                var options = normalizeOptions(arg3, "utf8", "w", 420);
                cb = typeof arg3 === "function" ? arg3 : cb;
                var newCb = wrapCb(cb, 1);
                try {
                  var flag = FileFlag8.getFileFlag(options.flag);
                  if (!flag.isWriteable()) {
                    return newCb(new ApiError3(ErrorCode5.EINVAL, "Flag passed to writeFile must allow for writing."));
                  }
                  return assertRoot(this.root).writeFile(normalizePath(filename), data, options.encoding, flag, options.mode, newCb);
                } catch (e) {
                  return newCb(e);
                }
              };
              FS.prototype.writeFileSync = function writeFileSync(filename, data, arg3) {
                var options = normalizeOptions(arg3, "utf8", "w", 420);
                var flag = FileFlag8.getFileFlag(options.flag);
                if (!flag.isWriteable()) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Flag passed to writeFile must allow for writing.");
                }
                return assertRoot(this.root).writeFileSync(normalizePath(filename), data, options.encoding, flag, options.mode);
              };
              FS.prototype.appendFile = function appendFile(filename, data, arg3, cb) {
                if (cb === void 0) cb = nopCb;
                var options = normalizeOptions(arg3, "utf8", "a", 420);
                cb = typeof arg3 === "function" ? arg3 : cb;
                var newCb = wrapCb(cb, 1);
                try {
                  var flag = FileFlag8.getFileFlag(options.flag);
                  if (!flag.isAppendable()) {
                    return newCb(new ApiError3(ErrorCode5.EINVAL, "Flag passed to appendFile must allow for appending."));
                  }
                  assertRoot(this.root).appendFile(normalizePath(filename), data, options.encoding, flag, options.mode, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.appendFileSync = function appendFileSync(filename, data, arg3) {
                var options = normalizeOptions(arg3, "utf8", "a", 420);
                var flag = FileFlag8.getFileFlag(options.flag);
                if (!flag.isAppendable()) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Flag passed to appendFile must allow for appending.");
                }
                return assertRoot(this.root).appendFileSync(normalizePath(filename), data, options.encoding, flag, options.mode);
              };
              FS.prototype.fstat = function fstat(fd, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 2);
                try {
                  var file = this.fd2file(fd);
                  file.stat(newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.fstatSync = function fstatSync(fd) {
                return this.fd2file(fd).statSync();
              };
              FS.prototype.close = function close(fd, cb) {
                var this$1 = this;
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  this.fd2file(fd).close(function(e) {
                    if (!e) {
                      this$1.closeFd(fd);
                    }
                    newCb(e);
                  });
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.closeSync = function closeSync(fd) {
                this.fd2file(fd).closeSync();
                this.closeFd(fd);
              };
              FS.prototype.ftruncate = function ftruncate(fd, arg2, cb) {
                if (cb === void 0) cb = nopCb;
                var length = typeof arg2 === "number" ? arg2 : 0;
                cb = typeof arg2 === "function" ? arg2 : cb;
                var newCb = wrapCb(cb, 1);
                try {
                  var file = this.fd2file(fd);
                  if (length < 0) {
                    throw new ApiError3(ErrorCode5.EINVAL);
                  }
                  file.truncate(length, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.ftruncateSync = function ftruncateSync(fd, len) {
                if (len === void 0) len = 0;
                var file = this.fd2file(fd);
                if (len < 0) {
                  throw new ApiError3(ErrorCode5.EINVAL);
                }
                file.truncateSync(len);
              };
              FS.prototype.fsync = function fsync(fd, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  this.fd2file(fd).sync(newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.fsyncSync = function fsyncSync(fd) {
                this.fd2file(fd).syncSync();
              };
              FS.prototype.fdatasync = function fdatasync(fd, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  this.fd2file(fd).datasync(newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.fdatasyncSync = function fdatasyncSync(fd) {
                this.fd2file(fd).datasyncSync();
              };
              FS.prototype.write = function write(fd, arg2, arg3, arg4, arg5, cb) {
                if (cb === void 0) cb = nopCb;
                var buffer$$1, offset, length, position = null;
                if (typeof arg2 === "string") {
                  var encoding = "utf8";
                  switch (typeof arg3) {
                    case "function":
                      cb = arg3;
                      break;
                    case "number":
                      position = arg3;
                      encoding = typeof arg4 === "string" ? arg4 : "utf8";
                      cb = typeof arg5 === "function" ? arg5 : cb;
                      break;
                    default:
                      cb = typeof arg4 === "function" ? arg4 : typeof arg5 === "function" ? arg5 : cb;
                      return cb(new ApiError3(ErrorCode5.EINVAL, "Invalid arguments."));
                  }
                  buffer$$1 = Buffer2.from(arg2, encoding);
                  offset = 0;
                  length = buffer$$1.length;
                } else {
                  buffer$$1 = arg2;
                  offset = arg3;
                  length = arg4;
                  position = typeof arg5 === "number" ? arg5 : null;
                  cb = typeof arg5 === "function" ? arg5 : cb;
                }
                var newCb = wrapCb(cb, 3);
                try {
                  var file = this.fd2file(fd);
                  if (position === void 0 || position === null) {
                    position = file.getPos();
                  }
                  file.write(buffer$$1, offset, length, position, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.writeSync = function writeSync(fd, arg2, arg3, arg4, arg5) {
                var buffer$$1, offset = 0, length, position;
                if (typeof arg2 === "string") {
                  position = typeof arg3 === "number" ? arg3 : null;
                  var encoding = typeof arg4 === "string" ? arg4 : "utf8";
                  offset = 0;
                  buffer$$1 = Buffer2.from(arg2, encoding);
                  length = buffer$$1.length;
                } else {
                  buffer$$1 = arg2;
                  offset = arg3;
                  length = arg4;
                  position = typeof arg5 === "number" ? arg5 : null;
                }
                var file = this.fd2file(fd);
                if (position === void 0 || position === null) {
                  position = file.getPos();
                }
                return file.writeSync(buffer$$1, offset, length, position);
              };
              FS.prototype.read = function read(fd, arg2, arg3, arg4, arg5, cb) {
                if (cb === void 0) cb = nopCb;
                var position, offset, length, buffer$$1, newCb;
                if (typeof arg2 === "number") {
                  length = arg2;
                  position = arg3;
                  var encoding = arg4;
                  cb = typeof arg5 === "function" ? arg5 : cb;
                  offset = 0;
                  buffer$$1 = Buffer2.alloc(length);
                  newCb = wrapCb(function(err, bytesRead, buf) {
                    if (err) {
                      return cb(err);
                    }
                    cb(err, buf.toString(encoding), bytesRead);
                  }, 3);
                } else {
                  buffer$$1 = arg2;
                  offset = arg3;
                  length = arg4;
                  position = arg5;
                  newCb = wrapCb(cb, 3);
                }
                try {
                  var file = this.fd2file(fd);
                  if (position === void 0 || position === null) {
                    position = file.getPos();
                  }
                  file.read(buffer$$1, offset, length, position, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.readSync = function readSync(fd, arg2, arg3, arg4, arg5) {
                var shenanigans = false;
                var buffer$$1, offset, length, position, encoding = "utf8";
                if (typeof arg2 === "number") {
                  length = arg2;
                  position = arg3;
                  encoding = arg4;
                  offset = 0;
                  buffer$$1 = Buffer2.alloc(length);
                  shenanigans = true;
                } else {
                  buffer$$1 = arg2;
                  offset = arg3;
                  length = arg4;
                  position = arg5;
                }
                var file = this.fd2file(fd);
                if (position === void 0 || position === null) {
                  position = file.getPos();
                }
                var rv = file.readSync(buffer$$1, offset, length, position);
                if (!shenanigans) {
                  return rv;
                } else {
                  return [buffer$$1.toString(encoding), rv];
                }
              };
              FS.prototype.fchown = function fchown(fd, uid, gid, callback) {
                if (callback === void 0) callback = nopCb;
                var newCb = wrapCb(callback, 1);
                try {
                  this.fd2file(fd).chown(uid, gid, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.fchownSync = function fchownSync(fd, uid, gid) {
                this.fd2file(fd).chownSync(uid, gid);
              };
              FS.prototype.fchmod = function fchmod(fd, mode, cb) {
                var newCb = wrapCb(cb, 1);
                try {
                  var numMode = typeof mode === "string" ? parseInt(mode, 8) : mode;
                  this.fd2file(fd).chmod(numMode, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.fchmodSync = function fchmodSync(fd, mode) {
                var numMode = typeof mode === "string" ? parseInt(mode, 8) : mode;
                this.fd2file(fd).chmodSync(numMode);
              };
              FS.prototype.futimes = function futimes(fd, atime, mtime, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  var file = this.fd2file(fd);
                  if (typeof atime === "number") {
                    atime = new Date(atime * 1e3);
                  }
                  if (typeof mtime === "number") {
                    mtime = new Date(mtime * 1e3);
                  }
                  file.utimes(atime, mtime, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.futimesSync = function futimesSync(fd, atime, mtime) {
                this.fd2file(fd).utimesSync(normalizeTime(atime), normalizeTime(mtime));
              };
              FS.prototype.rmdir = function rmdir(path$$1, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  path$$1 = normalizePath(path$$1);
                  assertRoot(this.root).rmdir(path$$1, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.rmdirSync = function rmdirSync(path$$1) {
                path$$1 = normalizePath(path$$1);
                return assertRoot(this.root).rmdirSync(path$$1);
              };
              FS.prototype.mkdir = function mkdir(path$$1, mode, cb) {
                if (cb === void 0) cb = nopCb;
                if (typeof mode === "function") {
                  cb = mode;
                  mode = 511;
                }
                var newCb = wrapCb(cb, 1);
                try {
                  path$$1 = normalizePath(path$$1);
                  assertRoot(this.root).mkdir(path$$1, mode, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.mkdirSync = function mkdirSync(path$$1, mode) {
                assertRoot(this.root).mkdirSync(normalizePath(path$$1), normalizeMode(mode, 511));
              };
              FS.prototype.readdir = function readdir(path$$1, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 2);
                try {
                  path$$1 = normalizePath(path$$1);
                  assertRoot(this.root).readdir(path$$1, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.readdirSync = function readdirSync(path$$1) {
                path$$1 = normalizePath(path$$1);
                return assertRoot(this.root).readdirSync(path$$1);
              };
              FS.prototype.link = function link(srcpath, dstpath, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  srcpath = normalizePath(srcpath);
                  dstpath = normalizePath(dstpath);
                  assertRoot(this.root).link(srcpath, dstpath, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.linkSync = function linkSync(srcpath, dstpath) {
                srcpath = normalizePath(srcpath);
                dstpath = normalizePath(dstpath);
                return assertRoot(this.root).linkSync(srcpath, dstpath);
              };
              FS.prototype.symlink = function symlink(srcpath, dstpath, arg3, cb) {
                if (cb === void 0) cb = nopCb;
                var type = typeof arg3 === "string" ? arg3 : "file";
                cb = typeof arg3 === "function" ? arg3 : cb;
                var newCb = wrapCb(cb, 1);
                try {
                  if (type !== "file" && type !== "dir") {
                    return newCb(new ApiError3(ErrorCode5.EINVAL, "Invalid type: " + type));
                  }
                  srcpath = normalizePath(srcpath);
                  dstpath = normalizePath(dstpath);
                  assertRoot(this.root).symlink(srcpath, dstpath, type, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.symlinkSync = function symlinkSync(srcpath, dstpath, type) {
                if (!type) {
                  type = "file";
                } else if (type !== "file" && type !== "dir") {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid type: " + type);
                }
                srcpath = normalizePath(srcpath);
                dstpath = normalizePath(dstpath);
                return assertRoot(this.root).symlinkSync(srcpath, dstpath, type);
              };
              FS.prototype.readlink = function readlink(path$$1, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 2);
                try {
                  path$$1 = normalizePath(path$$1);
                  assertRoot(this.root).readlink(path$$1, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.readlinkSync = function readlinkSync(path$$1) {
                path$$1 = normalizePath(path$$1);
                return assertRoot(this.root).readlinkSync(path$$1);
              };
              FS.prototype.chown = function chown(path$$1, uid, gid, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  path$$1 = normalizePath(path$$1);
                  assertRoot(this.root).chown(path$$1, false, uid, gid, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.chownSync = function chownSync(path$$1, uid, gid) {
                path$$1 = normalizePath(path$$1);
                assertRoot(this.root).chownSync(path$$1, false, uid, gid);
              };
              FS.prototype.lchown = function lchown(path$$1, uid, gid, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  path$$1 = normalizePath(path$$1);
                  assertRoot(this.root).chown(path$$1, true, uid, gid, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.lchownSync = function lchownSync(path$$1, uid, gid) {
                path$$1 = normalizePath(path$$1);
                assertRoot(this.root).chownSync(path$$1, true, uid, gid);
              };
              FS.prototype.chmod = function chmod(path$$1, mode, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  var numMode = normalizeMode(mode, -1);
                  if (numMode < 0) {
                    throw new ApiError3(ErrorCode5.EINVAL, "Invalid mode.");
                  }
                  assertRoot(this.root).chmod(normalizePath(path$$1), false, numMode, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.chmodSync = function chmodSync(path$$1, mode) {
                var numMode = normalizeMode(mode, -1);
                if (numMode < 0) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid mode.");
                }
                path$$1 = normalizePath(path$$1);
                assertRoot(this.root).chmodSync(path$$1, false, numMode);
              };
              FS.prototype.lchmod = function lchmod(path$$1, mode, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  var numMode = normalizeMode(mode, -1);
                  if (numMode < 0) {
                    throw new ApiError3(ErrorCode5.EINVAL, "Invalid mode.");
                  }
                  assertRoot(this.root).chmod(normalizePath(path$$1), true, numMode, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.lchmodSync = function lchmodSync(path$$1, mode) {
                var numMode = normalizeMode(mode, -1);
                if (numMode < 1) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid mode.");
                }
                assertRoot(this.root).chmodSync(normalizePath(path$$1), true, numMode);
              };
              FS.prototype.utimes = function utimes(path$$1, atime, mtime, cb) {
                if (cb === void 0) cb = nopCb;
                var newCb = wrapCb(cb, 1);
                try {
                  assertRoot(this.root).utimes(normalizePath(path$$1), normalizeTime(atime), normalizeTime(mtime), newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.utimesSync = function utimesSync(path$$1, atime, mtime) {
                assertRoot(this.root).utimesSync(normalizePath(path$$1), normalizeTime(atime), normalizeTime(mtime));
              };
              FS.prototype.realpath = function realpath(path$$1, arg2, cb) {
                if (cb === void 0) cb = nopCb;
                var cache = typeof arg2 === "object" ? arg2 : {};
                cb = typeof arg2 === "function" ? arg2 : nopCb;
                var newCb = wrapCb(cb, 2);
                try {
                  path$$1 = normalizePath(path$$1);
                  assertRoot(this.root).realpath(path$$1, cache, newCb);
                } catch (e) {
                  newCb(e);
                }
              };
              FS.prototype.realpathSync = function realpathSync(path$$1, cache) {
                if (cache === void 0) cache = {};
                path$$1 = normalizePath(path$$1);
                return assertRoot(this.root).realpathSync(path$$1, cache);
              };
              FS.prototype.watchFile = function watchFile(filename, arg2, listener) {
                if (listener === void 0) listener = nopCb;
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              FS.prototype.unwatchFile = function unwatchFile(filename, listener) {
                if (listener === void 0) listener = nopCb;
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              FS.prototype.watch = function watch(filename, arg2, listener) {
                if (listener === void 0) listener = nopCb;
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              FS.prototype.access = function access(path$$1, arg2, cb) {
                if (cb === void 0) cb = nopCb;
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              FS.prototype.accessSync = function accessSync(path$$1, mode) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              FS.prototype.createReadStream = function createReadStream(path$$1, options) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              FS.prototype.createWriteStream = function createWriteStream(path$$1, options) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              FS.prototype.wrapCallbacks = function wrapCallbacks(cbWrapper) {
                wrapCb = cbWrapper;
              };
              FS.prototype.getFdForFile = function getFdForFile(file) {
                var fd = this.nextFd++;
                this.fdMap[fd] = file;
                return fd;
              };
              FS.prototype.fd2file = function fd2file(fd) {
                var rv = this.fdMap[fd];
                if (rv) {
                  return rv;
                } else {
                  throw new ApiError3(ErrorCode5.EBADF, "Invalid file descriptor.");
                }
              };
              FS.prototype.closeFd = function closeFd(fd) {
                delete this.fdMap[fd];
              };
              FS.Stats = Stats2;
              var fs = new FS();
              var _fsMock = {};
              var fsProto = FS.prototype;
              Object.keys(fsProto).forEach(function(key) {
                if (typeof fs[key] === "function") {
                  _fsMock[key] = function() {
                    return fs[key].apply(fs, arguments);
                  };
                } else {
                  _fsMock[key] = fs[key];
                }
              });
              _fsMock["changeFSModule"] = function(newFs) {
                fs = newFs;
              };
              _fsMock["getFSModule"] = function() {
                return fs;
              };
              _fsMock["FS"] = FS;
              function _min(d0, d1, d2, bx, ay) {
                return d0 < d1 || d2 < d1 ? d0 > d2 ? d2 + 1 : d0 + 1 : bx === ay ? d1 : d1 + 1;
              }
              function levenshtein(a, b) {
                if (a === b) {
                  return 0;
                }
                if (a.length > b.length) {
                  var tmp = a;
                  a = b;
                  b = tmp;
                }
                var la = a.length;
                var lb = b.length;
                while (la > 0 && a.charCodeAt(la - 1) === b.charCodeAt(lb - 1)) {
                  la--;
                  lb--;
                }
                var offset = 0;
                while (offset < la && a.charCodeAt(offset) === b.charCodeAt(offset)) {
                  offset++;
                }
                la -= offset;
                lb -= offset;
                if (la === 0 || lb === 1) {
                  return lb;
                }
                var vector = new Array(la << 1);
                for (var y = 0; y < la; ) {
                  vector[la + y] = a.charCodeAt(offset + y);
                  vector[y] = ++y;
                }
                var x;
                var d0;
                var d1;
                var d2;
                var d3;
                for (x = 0; x + 3 < lb; ) {
                  var bx0 = b.charCodeAt(offset + (d0 = x));
                  var bx1 = b.charCodeAt(offset + (d1 = x + 1));
                  var bx2 = b.charCodeAt(offset + (d2 = x + 2));
                  var bx3 = b.charCodeAt(offset + (d3 = x + 3));
                  var dd$1 = x += 4;
                  for (var y$1 = 0; y$1 < la; ) {
                    var ay = vector[la + y$1];
                    var dy = vector[y$1];
                    d0 = _min(dy, d0, d1, bx0, ay);
                    d1 = _min(d0, d1, d2, bx1, ay);
                    d2 = _min(d1, d2, d3, bx2, ay);
                    dd$1 = _min(d2, d3, dd$1, bx3, ay);
                    vector[y$1++] = dd$1;
                    d3 = d2;
                    d2 = d1;
                    d1 = d0;
                    d0 = dy;
                  }
                }
                var dd = 0;
                for (; x < lb; ) {
                  var bx0$1 = b.charCodeAt(offset + (d0 = x));
                  dd = ++x;
                  for (var y$2 = 0; y$2 < la; y$2++) {
                    var dy$1 = vector[y$2];
                    vector[y$2] = dd = dy$1 < d0 || dd < d0 ? dy$1 > dd ? dd + 1 : dy$1 + 1 : bx0$1 === vector[la + y$2] ? d0 : d0 + 1;
                    d0 = dy$1;
                  }
                }
                return dd;
              }
              function deprecationMessage(print, fsName, opts) {
                if (print) {
                  console.warn("[" + fsName + "] Direct file system constructor usage is deprecated for this file system, and will be removed in the next major version. Please use the '" + fsName + ".Create(" + JSON.stringify(opts) + ", callback)' method instead. See https://github.com/jvilk/BrowserFS/issues/176 for more details.");
                }
              }
              var isIE = typeof navigator !== "undefined" && !!(/(msie) ([\w.]+)/.exec(navigator.userAgent.toLowerCase()) || navigator.userAgent.indexOf("Trident") !== -1);
              var isWebWorker = typeof window === "undefined";
              function fail() {
                throw new Error("BFS has reached an impossible code path; please file a bug.");
              }
              function mkdirpSync(p, mode, fs2) {
                if (!fs2.existsSync(p)) {
                  mkdirpSync(path.dirname(p), mode, fs2);
                  fs2.mkdirSync(p, mode);
                }
              }
              function buffer2ArrayBuffer(buff) {
                var u8 = buffer2Uint8array(buff), u8offset = u8.byteOffset, u8Len = u8.byteLength;
                if (u8offset === 0 && u8Len === u8.buffer.byteLength) {
                  return u8.buffer;
                } else {
                  return u8.buffer.slice(u8offset, u8offset + u8Len);
                }
              }
              function buffer2Uint8array(buff) {
                if (buff instanceof Uint8Array) {
                  return buff;
                } else {
                  return new Uint8Array(buff);
                }
              }
              function arrayish2Buffer(arr) {
                if (arr instanceof Buffer2) {
                  return arr;
                } else if (arr instanceof Uint8Array) {
                  return uint8Array2Buffer(arr);
                } else {
                  return Buffer2.from(arr);
                }
              }
              function uint8Array2Buffer(u8) {
                if (u8 instanceof Buffer2) {
                  return u8;
                } else if (u8.byteOffset === 0 && u8.byteLength === u8.buffer.byteLength) {
                  return arrayBuffer2Buffer(u8.buffer);
                } else {
                  return Buffer2.from(u8.buffer, u8.byteOffset, u8.byteLength);
                }
              }
              function arrayBuffer2Buffer(ab) {
                return Buffer2.from(ab);
              }
              function copyingSlice2(buff, start2, end) {
                if (start2 === void 0) start2 = 0;
                if (end === void 0) end = buff.length;
                if (start2 < 0 || end < 0 || end > buff.length || start2 > end) {
                  throw new TypeError("Invalid slice bounds on buffer of length " + buff.length + ": [" + start2 + ", " + end + "]");
                }
                if (buff.length === 0) {
                  return emptyBuffer();
                } else {
                  var u8 = buffer2Uint8array(buff), s0 = buff[0], newS0 = (s0 + 1) % 255;
                  buff[0] = newS0;
                  if (u8[0] === newS0) {
                    u8[0] = s0;
                    return uint8Array2Buffer(u8.slice(start2, end));
                  } else {
                    buff[0] = s0;
                    return uint8Array2Buffer(u8.subarray(start2, end));
                  }
                }
              }
              var emptyBuff = null;
              function emptyBuffer() {
                if (emptyBuff) {
                  return emptyBuff;
                }
                return emptyBuff = Buffer2.alloc(0);
              }
              function bufferValidator(v, cb) {
                if (Buffer2.isBuffer(v)) {
                  cb();
                } else {
                  cb(new ApiError3(ErrorCode5.EINVAL, "option must be a Buffer."));
                }
              }
              function checkOptions(fsType, opts, cb) {
                var optsInfo = fsType.Options;
                var fsName = fsType.Name;
                var pendingValidators = 0;
                var callbackCalled = false;
                var loopEnded = false;
                function validatorCallback(e) {
                  if (!callbackCalled) {
                    if (e) {
                      callbackCalled = true;
                      cb(e);
                    }
                    pendingValidators--;
                    if (pendingValidators === 0 && loopEnded) {
                      cb();
                    }
                  }
                }
                var loop = function(optName2) {
                  if (optsInfo.hasOwnProperty(optName2)) {
                    var opt = optsInfo[optName2];
                    var providedValue = opts[optName2];
                    if (providedValue === void 0 || providedValue === null) {
                      if (!opt.optional) {
                        var incorrectOptions = Object.keys(opts).filter(function(o) {
                          return !(o in optsInfo);
                        }).map(function(a) {
                          return { str: a, distance: levenshtein(optName2, a) };
                        }).filter(function(o) {
                          return o.distance < 5;
                        }).sort(function(a, b) {
                          return a.distance - b.distance;
                        });
                        if (callbackCalled) {
                          return {};
                        }
                        callbackCalled = true;
                        return { v: cb(new ApiError3(ErrorCode5.EINVAL, "[" + fsName + "] Required option '" + optName2 + "' not provided." + (incorrectOptions.length > 0 ? " You provided unrecognized option '" + incorrectOptions[0].str + "'; perhaps you meant to type '" + optName2 + "'." : "") + "\nOption description: " + opt.description)) };
                      }
                    } else {
                      var typeMatches = false;
                      if (Array.isArray(opt.type)) {
                        typeMatches = opt.type.indexOf(typeof providedValue) !== -1;
                      } else {
                        typeMatches = typeof providedValue === opt.type;
                      }
                      if (!typeMatches) {
                        if (callbackCalled) {
                          return {};
                        }
                        callbackCalled = true;
                        return { v: cb(new ApiError3(ErrorCode5.EINVAL, "[" + fsName + "] Value provided for option " + optName2 + " is not the proper type. Expected " + (Array.isArray(opt.type) ? "one of {" + opt.type.join(", ") + "}" : opt.type) + ", but received " + typeof providedValue + "\nOption description: " + opt.description)) };
                      } else if (opt.validator) {
                        pendingValidators++;
                        opt.validator(providedValue, validatorCallback);
                      }
                    }
                  }
                };
                for (var optName in optsInfo) {
                  var returned = loop(optName);
                  if (returned) return returned.v;
                }
                loopEnded = true;
                if (pendingValidators === 0 && !callbackCalled) {
                  cb();
                }
              }
              var BFSUtils = Object.freeze({
                deprecationMessage,
                isIE,
                isWebWorker,
                fail,
                mkdirpSync,
                buffer2ArrayBuffer,
                buffer2Uint8array,
                arrayish2Buffer,
                uint8Array2Buffer,
                arrayBuffer2Buffer,
                copyingSlice: copyingSlice2,
                emptyBuffer,
                bufferValidator,
                checkOptions
              });
              var BFSEmscriptenStreamOps = function BFSEmscriptenStreamOps2(fs2) {
                this.fs = fs2;
                this.nodefs = fs2.getNodeFS();
                this.FS = fs2.getFS();
                this.PATH = fs2.getPATH();
                this.ERRNO_CODES = fs2.getERRNO_CODES();
              };
              BFSEmscriptenStreamOps.prototype.open = function open(stream) {
                var path$$1 = this.fs.realPath(stream.node);
                var FS2 = this.FS;
                try {
                  if (FS2.isFile(stream.node.mode)) {
                    stream.nfd = this.nodefs.openSync(path$$1, this.fs.flagsToPermissionString(stream.flags));
                  }
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new FS2.ErrnoError(this.ERRNO_CODES[e.code]);
                }
              };
              BFSEmscriptenStreamOps.prototype.close = function close(stream) {
                var FS2 = this.FS;
                try {
                  if (FS2.isFile(stream.node.mode) && stream.nfd) {
                    this.nodefs.closeSync(stream.nfd);
                  }
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new FS2.ErrnoError(this.ERRNO_CODES[e.code]);
                }
              };
              BFSEmscriptenStreamOps.prototype.read = function read(stream, buffer$$1, offset, length, position) {
                try {
                  return this.nodefs.readSync(stream.nfd, uint8Array2Buffer(buffer$$1), offset, length, position);
                } catch (e) {
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
              };
              BFSEmscriptenStreamOps.prototype.write = function write(stream, buffer$$1, offset, length, position) {
                try {
                  return this.nodefs.writeSync(stream.nfd, uint8Array2Buffer(buffer$$1), offset, length, position);
                } catch (e) {
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
              };
              BFSEmscriptenStreamOps.prototype.llseek = function llseek(stream, offset, whence) {
                var position = offset;
                if (whence === 1) {
                  position += stream.position;
                } else if (whence === 2) {
                  if (this.FS.isFile(stream.node.mode)) {
                    try {
                      var stat = this.nodefs.fstatSync(stream.nfd);
                      position += stat.size;
                    } catch (e) {
                      throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                    }
                  }
                }
                if (position < 0) {
                  throw new this.FS.ErrnoError(this.ERRNO_CODES.EINVAL);
                }
                stream.position = position;
                return position;
              };
              var BFSEmscriptenNodeOps = function BFSEmscriptenNodeOps2(fs2) {
                this.fs = fs2;
                this.nodefs = fs2.getNodeFS();
                this.FS = fs2.getFS();
                this.PATH = fs2.getPATH();
                this.ERRNO_CODES = fs2.getERRNO_CODES();
              };
              BFSEmscriptenNodeOps.prototype.getattr = function getattr(node) {
                var path$$1 = this.fs.realPath(node);
                var stat;
                try {
                  stat = this.nodefs.lstatSync(path$$1);
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
                return {
                  dev: stat.dev,
                  ino: stat.ino,
                  mode: stat.mode,
                  nlink: stat.nlink,
                  uid: stat.uid,
                  gid: stat.gid,
                  rdev: stat.rdev,
                  size: stat.size,
                  atime: stat.atime,
                  mtime: stat.mtime,
                  ctime: stat.ctime,
                  blksize: stat.blksize,
                  blocks: stat.blocks
                };
              };
              BFSEmscriptenNodeOps.prototype.setattr = function setattr(node, attr) {
                var path$$1 = this.fs.realPath(node);
                try {
                  if (attr.mode !== void 0) {
                    this.nodefs.chmodSync(path$$1, attr.mode);
                    node.mode = attr.mode;
                  }
                  if (attr.timestamp !== void 0) {
                    var date = new Date(attr.timestamp);
                    this.nodefs.utimesSync(path$$1, date, date);
                  }
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  if (e.code !== "ENOTSUP") {
                    throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                  }
                }
                if (attr.size !== void 0) {
                  try {
                    this.nodefs.truncateSync(path$$1, attr.size);
                  } catch (e) {
                    if (!e.code) {
                      throw e;
                    }
                    throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                  }
                }
              };
              BFSEmscriptenNodeOps.prototype.lookup = function lookup(parent, name) {
                var path$$1 = this.PATH.join2(this.fs.realPath(parent), name);
                var mode = this.fs.getMode(path$$1);
                return this.fs.createNode(parent, name, mode);
              };
              BFSEmscriptenNodeOps.prototype.mknod = function mknod(parent, name, mode, dev) {
                var node = this.fs.createNode(parent, name, mode, dev);
                var path$$1 = this.fs.realPath(node);
                try {
                  if (this.FS.isDir(node.mode)) {
                    this.nodefs.mkdirSync(path$$1, node.mode);
                  } else {
                    this.nodefs.writeFileSync(path$$1, "", { mode: node.mode });
                  }
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
                return node;
              };
              BFSEmscriptenNodeOps.prototype.rename = function rename(oldNode, newDir, newName) {
                var oldPath = this.fs.realPath(oldNode);
                var newPath = this.PATH.join2(this.fs.realPath(newDir), newName);
                try {
                  this.nodefs.renameSync(oldPath, newPath);
                  oldNode.name = newName;
                  oldNode.parent = newDir;
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
              };
              BFSEmscriptenNodeOps.prototype.unlink = function unlink(parent, name) {
                var path$$1 = this.PATH.join2(this.fs.realPath(parent), name);
                try {
                  this.nodefs.unlinkSync(path$$1);
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
              };
              BFSEmscriptenNodeOps.prototype.rmdir = function rmdir(parent, name) {
                var path$$1 = this.PATH.join2(this.fs.realPath(parent), name);
                try {
                  this.nodefs.rmdirSync(path$$1);
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
              };
              BFSEmscriptenNodeOps.prototype.readdir = function readdir(node) {
                var path$$1 = this.fs.realPath(node);
                try {
                  var contents = this.nodefs.readdirSync(path$$1);
                  contents.push(".", "..");
                  return contents;
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
              };
              BFSEmscriptenNodeOps.prototype.symlink = function symlink(parent, newName, oldPath) {
                var newPath = this.PATH.join2(this.fs.realPath(parent), newName);
                try {
                  this.nodefs.symlinkSync(oldPath, newPath);
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
              };
              BFSEmscriptenNodeOps.prototype.readlink = function readlink(node) {
                var path$$1 = this.fs.realPath(node);
                try {
                  return this.nodefs.readlinkSync(path$$1);
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
              };
              var BFSEmscriptenFS = function BFSEmscriptenFS2(_FS, _PATH, _ERRNO_CODES, nodefs) {
                if (_FS === void 0) _FS = self["FS"];
                if (_PATH === void 0) _PATH = self["PATH"];
                if (_ERRNO_CODES === void 0) _ERRNO_CODES = self["ERRNO_CODES"];
                if (nodefs === void 0) nodefs = _fsMock;
                this.flagsToPermissionStringMap = {
                  0: "r",
                  1: "r+",
                  2: "r+",
                  64: "r",
                  65: "r+",
                  66: "r+",
                  129: "rx+",
                  193: "rx+",
                  514: "w+",
                  577: "w",
                  578: "w+",
                  705: "wx",
                  706: "wx+",
                  1024: "a",
                  1025: "a",
                  1026: "a+",
                  1089: "a",
                  1090: "a+",
                  1153: "ax",
                  1154: "ax+",
                  1217: "ax",
                  1218: "ax+",
                  4096: "rs",
                  4098: "rs+"
                };
                this.nodefs = nodefs;
                this.FS = _FS;
                this.PATH = _PATH;
                this.ERRNO_CODES = _ERRNO_CODES;
                this.node_ops = new BFSEmscriptenNodeOps(this);
                this.stream_ops = new BFSEmscriptenStreamOps(this);
              };
              BFSEmscriptenFS.prototype.mount = function mount(m) {
                return this.createNode(null, "/", this.getMode(m.opts.root), 0);
              };
              BFSEmscriptenFS.prototype.createNode = function createNode(parent, name, mode, dev) {
                var FS2 = this.FS;
                if (!FS2.isDir(mode) && !FS2.isFile(mode) && !FS2.isLink(mode)) {
                  throw new FS2.ErrnoError(this.ERRNO_CODES.EINVAL);
                }
                var node = FS2.createNode(parent, name, mode);
                node.node_ops = this.node_ops;
                node.stream_ops = this.stream_ops;
                return node;
              };
              BFSEmscriptenFS.prototype.getMode = function getMode(path$$1) {
                var stat;
                try {
                  stat = this.nodefs.lstatSync(path$$1);
                } catch (e) {
                  if (!e.code) {
                    throw e;
                  }
                  throw new this.FS.ErrnoError(this.ERRNO_CODES[e.code]);
                }
                return stat.mode;
              };
              BFSEmscriptenFS.prototype.realPath = function realPath(node) {
                var parts = [];
                while (node.parent !== node) {
                  parts.push(node.name);
                  node = node.parent;
                }
                parts.push(node.mount.opts.root);
                parts.reverse();
                return this.PATH.join.apply(null, parts);
              };
              BFSEmscriptenFS.prototype.flagsToPermissionString = function flagsToPermissionString(flags) {
                var parsedFlags = typeof flags === "string" ? parseInt(flags, 10) : flags;
                parsedFlags &= 8191;
                if (parsedFlags in this.flagsToPermissionStringMap) {
                  return this.flagsToPermissionStringMap[parsedFlags];
                } else {
                  return flags;
                }
              };
              BFSEmscriptenFS.prototype.getNodeFS = function getNodeFS() {
                return this.nodefs;
              };
              BFSEmscriptenFS.prototype.getFS = function getFS() {
                return this.FS;
              };
              BFSEmscriptenFS.prototype.getPATH = function getPATH() {
                return this.PATH;
              };
              BFSEmscriptenFS.prototype.getERRNO_CODES = function getERRNO_CODES() {
                return this.ERRNO_CODES;
              };
              var BaseFileSystem3 = function BaseFileSystem4() {
              };
              BaseFileSystem3.prototype.supportsLinks = function supportsLinks() {
                return false;
              };
              BaseFileSystem3.prototype.diskSpace = function diskSpace(p, cb) {
                cb(0, 0);
              };
              BaseFileSystem3.prototype.openFile = function openFile(p, flag, cb) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.createFile = function createFile(p, flag, mode, cb) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.open = function open(p, flag, mode, cb) {
                var this$1 = this;
                var mustBeFile = function(e, stats) {
                  if (e) {
                    switch (flag.pathNotExistsAction()) {
                      case ActionType3.CREATE_FILE:
                        return this$1.stat(path.dirname(p), false, function(e2, parentStats) {
                          if (e2) {
                            cb(e2);
                          } else if (parentStats && !parentStats.isDirectory()) {
                            cb(ApiError3.ENOTDIR(path.dirname(p)));
                          } else {
                            this$1.createFile(p, flag, mode, cb);
                          }
                        });
                      case ActionType3.THROW_EXCEPTION:
                        return cb(ApiError3.ENOENT(p));
                      default:
                        return cb(new ApiError3(ErrorCode5.EINVAL, "Invalid FileFlag object."));
                    }
                  } else {
                    if (stats && stats.isDirectory()) {
                      return cb(ApiError3.EISDIR(p));
                    }
                    switch (flag.pathExistsAction()) {
                      case ActionType3.THROW_EXCEPTION:
                        return cb(ApiError3.EEXIST(p));
                      case ActionType3.TRUNCATE_FILE:
                        return this$1.openFile(p, flag, function(e2, fd) {
                          if (e2) {
                            cb(e2);
                          } else if (fd) {
                            fd.truncate(0, function() {
                              fd.sync(function() {
                                cb(null, fd);
                              });
                            });
                          } else {
                            fail();
                          }
                        });
                      case ActionType3.NOP:
                        return this$1.openFile(p, flag, cb);
                      default:
                        return cb(new ApiError3(ErrorCode5.EINVAL, "Invalid FileFlag object."));
                    }
                  }
                };
                this.stat(p, false, mustBeFile);
              };
              BaseFileSystem3.prototype.rename = function rename(oldPath, newPath, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.renameSync = function renameSync(oldPath, newPath) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.stat = function stat(p, isLstat, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.statSync = function statSync(p, isLstat) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.openFileSync = function openFileSync(p, flag, mode) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.createFileSync = function createFileSync(p, flag, mode) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.openSync = function openSync(p, flag, mode) {
                var stats;
                try {
                  stats = this.statSync(p, false);
                } catch (e) {
                  switch (flag.pathNotExistsAction()) {
                    case ActionType3.CREATE_FILE:
                      var parentStats = this.statSync(path.dirname(p), false);
                      if (!parentStats.isDirectory()) {
                        throw ApiError3.ENOTDIR(path.dirname(p));
                      }
                      return this.createFileSync(p, flag, mode);
                    case ActionType3.THROW_EXCEPTION:
                      throw ApiError3.ENOENT(p);
                    default:
                      throw new ApiError3(ErrorCode5.EINVAL, "Invalid FileFlag object.");
                  }
                }
                if (stats.isDirectory()) {
                  throw ApiError3.EISDIR(p);
                }
                switch (flag.pathExistsAction()) {
                  case ActionType3.THROW_EXCEPTION:
                    throw ApiError3.EEXIST(p);
                  case ActionType3.TRUNCATE_FILE:
                    this.unlinkSync(p);
                    return this.createFileSync(p, flag, stats.mode);
                  case ActionType3.NOP:
                    return this.openFileSync(p, flag, mode);
                  default:
                    throw new ApiError3(ErrorCode5.EINVAL, "Invalid FileFlag object.");
                }
              };
              BaseFileSystem3.prototype.unlink = function unlink(p, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.unlinkSync = function unlinkSync(p) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.rmdir = function rmdir(p, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.rmdirSync = function rmdirSync(p) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.mkdir = function mkdir(p, mode, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.mkdirSync = function mkdirSync(p, mode) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.readdir = function readdir(p, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.readdirSync = function readdirSync(p) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.exists = function exists(p, cb) {
                this.stat(p, null, function(err) {
                  cb(!err);
                });
              };
              BaseFileSystem3.prototype.existsSync = function existsSync(p) {
                try {
                  this.statSync(p, true);
                  return true;
                } catch (e) {
                  return false;
                }
              };
              BaseFileSystem3.prototype.realpath = function realpath(p, cache, cb) {
                if (this.supportsLinks()) {
                  var splitPath2 = p.split(path.sep);
                  for (var i2 = 0; i2 < splitPath2.length; i2++) {
                    var addPaths = splitPath2.slice(0, i2 + 1);
                    splitPath2[i2] = path.join.apply(null, addPaths);
                  }
                } else {
                  this.exists(p, function(doesExist) {
                    if (doesExist) {
                      cb(null, p);
                    } else {
                      cb(ApiError3.ENOENT(p));
                    }
                  });
                }
              };
              BaseFileSystem3.prototype.realpathSync = function realpathSync(p, cache) {
                if (this.supportsLinks()) {
                  var splitPath2 = p.split(path.sep);
                  for (var i2 = 0; i2 < splitPath2.length; i2++) {
                    var addPaths = splitPath2.slice(0, i2 + 1);
                    splitPath2[i2] = path.join.apply(path, addPaths);
                  }
                  return splitPath2.join(path.sep);
                } else {
                  if (this.existsSync(p)) {
                    return p;
                  } else {
                    throw ApiError3.ENOENT(p);
                  }
                }
              };
              BaseFileSystem3.prototype.truncate = function truncate(p, len, cb) {
                this.open(p, FileFlag8.getFileFlag("r+"), 420, function(er, fd) {
                  if (er) {
                    return cb(er);
                  }
                  fd.truncate(len, function(er2) {
                    fd.close(function(er22) {
                      cb(er2 || er22);
                    });
                  });
                });
              };
              BaseFileSystem3.prototype.truncateSync = function truncateSync(p, len) {
                var fd = this.openSync(p, FileFlag8.getFileFlag("r+"), 420);
                try {
                  fd.truncateSync(len);
                } catch (e) {
                  throw e;
                } finally {
                  fd.closeSync();
                }
              };
              BaseFileSystem3.prototype.readFile = function readFile(fname, encoding, flag, cb) {
                var oldCb = cb;
                this.open(fname, flag, 420, function(err, fd) {
                  if (err) {
                    return cb(err);
                  }
                  cb = function(err2, arg) {
                    fd.close(function(err22) {
                      if (!err2) {
                        err2 = err22;
                      }
                      return oldCb(err2, arg);
                    });
                  };
                  fd.stat(function(err2, stat) {
                    if (err2) {
                      return cb(err2);
                    }
                    var buf = Buffer2.alloc(stat.size);
                    fd.read(buf, 0, stat.size, 0, function(err3) {
                      if (err3) {
                        return cb(err3);
                      } else if (encoding === null) {
                        return cb(err3, buf);
                      }
                      try {
                        cb(null, buf.toString(encoding));
                      } catch (e) {
                        cb(e);
                      }
                    });
                  });
                });
              };
              BaseFileSystem3.prototype.readFileSync = function readFileSync(fname, encoding, flag) {
                var fd = this.openSync(fname, flag, 420);
                try {
                  var stat = fd.statSync();
                  var buf = Buffer2.alloc(stat.size);
                  fd.readSync(buf, 0, stat.size, 0);
                  fd.closeSync();
                  if (encoding === null) {
                    return buf;
                  }
                  return buf.toString(encoding);
                } finally {
                  fd.closeSync();
                }
              };
              BaseFileSystem3.prototype.writeFile = function writeFile(fname, data, encoding, flag, mode, cb) {
                var oldCb = cb;
                this.open(fname, flag, 420, function(err, fd) {
                  if (err) {
                    return cb(err);
                  }
                  cb = function(err2) {
                    fd.close(function(err22) {
                      oldCb(err2 ? err2 : err22);
                    });
                  };
                  try {
                    if (typeof data === "string") {
                      data = Buffer2.from(data, encoding);
                    }
                  } catch (e) {
                    return cb(e);
                  }
                  fd.write(data, 0, data.length, 0, cb);
                });
              };
              BaseFileSystem3.prototype.writeFileSync = function writeFileSync(fname, data, encoding, flag, mode) {
                var fd = this.openSync(fname, flag, mode);
                try {
                  if (typeof data === "string") {
                    data = Buffer2.from(data, encoding);
                  }
                  fd.writeSync(data, 0, data.length, 0);
                } finally {
                  fd.closeSync();
                }
              };
              BaseFileSystem3.prototype.appendFile = function appendFile(fname, data, encoding, flag, mode, cb) {
                var oldCb = cb;
                this.open(fname, flag, mode, function(err, fd) {
                  if (err) {
                    return cb(err);
                  }
                  cb = function(err2) {
                    fd.close(function(err22) {
                      oldCb(err2 ? err2 : err22);
                    });
                  };
                  if (typeof data === "string") {
                    data = Buffer2.from(data, encoding);
                  }
                  fd.write(data, 0, data.length, null, cb);
                });
              };
              BaseFileSystem3.prototype.appendFileSync = function appendFileSync(fname, data, encoding, flag, mode) {
                var fd = this.openSync(fname, flag, mode);
                try {
                  if (typeof data === "string") {
                    data = Buffer2.from(data, encoding);
                  }
                  fd.writeSync(data, 0, data.length, null);
                } finally {
                  fd.closeSync();
                }
              };
              BaseFileSystem3.prototype.chmod = function chmod(p, isLchmod, mode, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.chmodSync = function chmodSync(p, isLchmod, mode) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.chown = function chown(p, isLchown, uid, gid, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.chownSync = function chownSync(p, isLchown, uid, gid) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.utimes = function utimes(p, atime, mtime, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.utimesSync = function utimesSync(p, atime, mtime) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.link = function link(srcpath, dstpath, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.linkSync = function linkSync(srcpath, dstpath) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.symlink = function symlink(srcpath, dstpath, type, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.symlinkSync = function symlinkSync(srcpath, dstpath, type) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFileSystem3.prototype.readlink = function readlink(p, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFileSystem3.prototype.readlinkSync = function readlinkSync(p) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              var SynchronousFileSystem = function(BaseFileSystem4) {
                function SynchronousFileSystem2() {
                  BaseFileSystem4.apply(this, arguments);
                }
                if (BaseFileSystem4) SynchronousFileSystem2.__proto__ = BaseFileSystem4;
                SynchronousFileSystem2.prototype = Object.create(BaseFileSystem4 && BaseFileSystem4.prototype);
                SynchronousFileSystem2.prototype.constructor = SynchronousFileSystem2;
                SynchronousFileSystem2.prototype.supportsSynch = function supportsSynch() {
                  return true;
                };
                SynchronousFileSystem2.prototype.rename = function rename(oldPath, newPath, cb) {
                  try {
                    this.renameSync(oldPath, newPath);
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.stat = function stat(p, isLstat, cb) {
                  try {
                    cb(null, this.statSync(p, isLstat));
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.open = function open(p, flags, mode, cb) {
                  try {
                    cb(null, this.openSync(p, flags, mode));
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.unlink = function unlink(p, cb) {
                  try {
                    this.unlinkSync(p);
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.rmdir = function rmdir(p, cb) {
                  try {
                    this.rmdirSync(p);
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.mkdir = function mkdir(p, mode, cb) {
                  try {
                    this.mkdirSync(p, mode);
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.readdir = function readdir(p, cb) {
                  try {
                    cb(null, this.readdirSync(p));
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.chmod = function chmod(p, isLchmod, mode, cb) {
                  try {
                    this.chmodSync(p, isLchmod, mode);
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.chown = function chown(p, isLchown, uid, gid, cb) {
                  try {
                    this.chownSync(p, isLchown, uid, gid);
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.utimes = function utimes(p, atime, mtime, cb) {
                  try {
                    this.utimesSync(p, atime, mtime);
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.link = function link(srcpath, dstpath, cb) {
                  try {
                    this.linkSync(srcpath, dstpath);
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.symlink = function symlink(srcpath, dstpath, type, cb) {
                  try {
                    this.symlinkSync(srcpath, dstpath, type);
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                SynchronousFileSystem2.prototype.readlink = function readlink(p, cb) {
                  try {
                    cb(null, this.readlinkSync(p));
                  } catch (e) {
                    cb(e);
                  }
                };
                return SynchronousFileSystem2;
              }(BaseFileSystem3);
              var BaseFile = function BaseFile2() {
              };
              BaseFile.prototype.sync = function sync(cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFile.prototype.syncSync = function syncSync() {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFile.prototype.datasync = function datasync(cb) {
                this.sync(cb);
              };
              BaseFile.prototype.datasyncSync = function datasyncSync() {
                return this.syncSync();
              };
              BaseFile.prototype.chown = function chown(uid, gid, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFile.prototype.chownSync = function chownSync(uid, gid) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFile.prototype.chmod = function chmod(mode, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFile.prototype.chmodSync = function chmodSync(mode) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              BaseFile.prototype.utimes = function utimes(atime, mtime, cb) {
                cb(new ApiError3(ErrorCode5.ENOTSUP));
              };
              BaseFile.prototype.utimesSync = function utimesSync(atime, mtime) {
                throw new ApiError3(ErrorCode5.ENOTSUP);
              };
              var PreloadFile2 = function(BaseFile$$1) {
                function PreloadFile3(_fs, _path, _flag, _stat, contents) {
                  BaseFile$$1.call(this);
                  this._pos = 0;
                  this._dirty = false;
                  this._fs = _fs;
                  this._path = _path;
                  this._flag = _flag;
                  this._stat = _stat;
                  if (contents) {
                    this._buffer = contents;
                  } else {
                    this._buffer = emptyBuffer();
                  }
                  if (this._stat.size !== this._buffer.length && this._flag.isReadable()) {
                    throw new Error("Invalid buffer: Buffer is " + this._buffer.length + " long, yet Stats object specifies that file is " + this._stat.size + " long.");
                  }
                }
                if (BaseFile$$1) PreloadFile3.__proto__ = BaseFile$$1;
                PreloadFile3.prototype = Object.create(BaseFile$$1 && BaseFile$$1.prototype);
                PreloadFile3.prototype.constructor = PreloadFile3;
                PreloadFile3.prototype.getBuffer = function getBuffer() {
                  return this._buffer;
                };
                PreloadFile3.prototype.getStats = function getStats() {
                  return this._stat;
                };
                PreloadFile3.prototype.getFlag = function getFlag2() {
                  return this._flag;
                };
                PreloadFile3.prototype.getPath = function getPath() {
                  return this._path;
                };
                PreloadFile3.prototype.getPos = function getPos() {
                  if (this._flag.isAppendable()) {
                    return this._stat.size;
                  }
                  return this._pos;
                };
                PreloadFile3.prototype.advancePos = function advancePos(delta) {
                  return this._pos += delta;
                };
                PreloadFile3.prototype.setPos = function setPos(newPos) {
                  return this._pos = newPos;
                };
                PreloadFile3.prototype.sync = function sync(cb) {
                  try {
                    this.syncSync();
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                PreloadFile3.prototype.syncSync = function syncSync() {
                  throw new ApiError3(ErrorCode5.ENOTSUP);
                };
                PreloadFile3.prototype.close = function close(cb) {
                  try {
                    this.closeSync();
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                PreloadFile3.prototype.closeSync = function closeSync() {
                  throw new ApiError3(ErrorCode5.ENOTSUP);
                };
                PreloadFile3.prototype.stat = function stat(cb) {
                  try {
                    cb(null, this._stat.clone());
                  } catch (e) {
                    cb(e);
                  }
                };
                PreloadFile3.prototype.statSync = function statSync() {
                  return this._stat.clone();
                };
                PreloadFile3.prototype.truncate = function truncate(len, cb) {
                  try {
                    this.truncateSync(len);
                    if (this._flag.isSynchronous() && !_fsMock.getRootFS().supportsSynch()) {
                      this.sync(cb);
                    }
                    cb();
                  } catch (e) {
                    return cb(e);
                  }
                };
                PreloadFile3.prototype.truncateSync = function truncateSync(len) {
                  this._dirty = true;
                  if (!this._flag.isWriteable()) {
                    throw new ApiError3(ErrorCode5.EPERM, "File not opened with a writeable mode.");
                  }
                  this._stat.mtime = /* @__PURE__ */ new Date();
                  if (len > this._buffer.length) {
                    var buf = Buffer2.alloc(len - this._buffer.length, 0);
                    this.writeSync(buf, 0, buf.length, this._buffer.length);
                    if (this._flag.isSynchronous() && _fsMock.getRootFS().supportsSynch()) {
                      this.syncSync();
                    }
                    return;
                  }
                  this._stat.size = len;
                  var newBuff = Buffer2.alloc(len);
                  this._buffer.copy(newBuff, 0, 0, len);
                  this._buffer = newBuff;
                  if (this._flag.isSynchronous() && _fsMock.getRootFS().supportsSynch()) {
                    this.syncSync();
                  }
                };
                PreloadFile3.prototype.write = function write(buffer$$1, offset, length, position, cb) {
                  try {
                    cb(null, this.writeSync(buffer$$1, offset, length, position), buffer$$1);
                  } catch (e) {
                    cb(e);
                  }
                };
                PreloadFile3.prototype.writeSync = function writeSync(buffer$$1, offset, length, position) {
                  this._dirty = true;
                  if (position === void 0 || position === null) {
                    position = this.getPos();
                  }
                  if (!this._flag.isWriteable()) {
                    throw new ApiError3(ErrorCode5.EPERM, "File not opened with a writeable mode.");
                  }
                  var endFp = position + length;
                  if (endFp > this._stat.size) {
                    this._stat.size = endFp;
                    if (endFp > this._buffer.length) {
                      var newBuff = Buffer2.alloc(endFp);
                      this._buffer.copy(newBuff);
                      this._buffer = newBuff;
                    }
                  }
                  var len = buffer$$1.copy(this._buffer, position, offset, offset + length);
                  this._stat.mtime = /* @__PURE__ */ new Date();
                  if (this._flag.isSynchronous()) {
                    this.syncSync();
                    return len;
                  }
                  this.setPos(position + len);
                  return len;
                };
                PreloadFile3.prototype.read = function read(buffer$$1, offset, length, position, cb) {
                  try {
                    cb(null, this.readSync(buffer$$1, offset, length, position), buffer$$1);
                  } catch (e) {
                    cb(e);
                  }
                };
                PreloadFile3.prototype.readSync = function readSync(buffer$$1, offset, length, position) {
                  if (!this._flag.isReadable()) {
                    throw new ApiError3(ErrorCode5.EPERM, "File not opened with a readable mode.");
                  }
                  if (position === void 0 || position === null) {
                    position = this.getPos();
                  }
                  var endRead = position + length;
                  if (endRead > this._stat.size) {
                    length = this._stat.size - position;
                  }
                  var rv = this._buffer.copy(buffer$$1, offset, position, position + length);
                  this._stat.atime = /* @__PURE__ */ new Date();
                  this._pos = position + length;
                  return rv;
                };
                PreloadFile3.prototype.chmod = function chmod(mode, cb) {
                  try {
                    this.chmodSync(mode);
                    cb();
                  } catch (e) {
                    cb(e);
                  }
                };
                PreloadFile3.prototype.chmodSync = function chmodSync(mode) {
                  if (!this._fs.supportsProps()) {
                    throw new ApiError3(ErrorCode5.ENOTSUP);
                  }
                  this._dirty = true;
                  this._stat.chmod(mode);
                  this.syncSync();
                };
                PreloadFile3.prototype.isDirty = function isDirty() {
                  return this._dirty;
                };
                PreloadFile3.prototype.resetDirty = function resetDirty() {
                  this._dirty = false;
                };
                return PreloadFile3;
              }(BaseFile);
              var NoSyncFile2 = function(PreloadFile3) {
                function NoSyncFile3(_fs, _path, _flag, _stat, contents) {
                  PreloadFile3.call(this, _fs, _path, _flag, _stat, contents);
                }
                if (PreloadFile3) NoSyncFile3.__proto__ = PreloadFile3;
                NoSyncFile3.prototype = Object.create(PreloadFile3 && PreloadFile3.prototype);
                NoSyncFile3.prototype.constructor = NoSyncFile3;
                NoSyncFile3.prototype.sync = function sync(cb) {
                  cb();
                };
                NoSyncFile3.prototype.syncSync = function syncSync() {
                };
                NoSyncFile3.prototype.close = function close(cb) {
                  cb();
                };
                NoSyncFile3.prototype.closeSync = function closeSync() {
                };
                return NoSyncFile3;
              }(PreloadFile2);
              var MirrorFile = function(PreloadFile$$1) {
                function MirrorFile2(fs2, path$$1, flag, stat, data) {
                  PreloadFile$$1.call(this, fs2, path$$1, flag, stat, data);
                }
                if (PreloadFile$$1) MirrorFile2.__proto__ = PreloadFile$$1;
                MirrorFile2.prototype = Object.create(PreloadFile$$1 && PreloadFile$$1.prototype);
                MirrorFile2.prototype.constructor = MirrorFile2;
                MirrorFile2.prototype.syncSync = function syncSync() {
                  if (this.isDirty()) {
                    this._fs._syncSync(this);
                    this.resetDirty();
                  }
                };
                MirrorFile2.prototype.closeSync = function closeSync() {
                  this.syncSync();
                };
                return MirrorFile2;
              }(PreloadFile2);
              var AsyncMirror = function(SynchronousFileSystem$$1) {
                function AsyncMirror2(sync, async, deprecateMsg) {
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  SynchronousFileSystem$$1.call(this);
                  this._queue = [];
                  this._queueRunning = false;
                  this._isInitialized = false;
                  this._initializeCallbacks = [];
                  this._sync = sync;
                  this._async = async;
                  if (!sync.supportsSynch()) {
                    throw new Error("The first argument to AsyncMirror needs to be a synchronous file system.");
                  }
                  deprecationMessage(deprecateMsg, AsyncMirror2.Name, { sync: "sync file system instance", async: "async file system instance" });
                }
                if (SynchronousFileSystem$$1) AsyncMirror2.__proto__ = SynchronousFileSystem$$1;
                AsyncMirror2.prototype = Object.create(SynchronousFileSystem$$1 && SynchronousFileSystem$$1.prototype);
                AsyncMirror2.prototype.constructor = AsyncMirror2;
                AsyncMirror2.Create = function Create(opts, cb) {
                  try {
                    var fs2 = new AsyncMirror2(opts.sync, opts.async, false);
                    fs2.initialize(function(e) {
                      if (e) {
                        cb(e);
                      } else {
                        cb(null, fs2);
                      }
                    }, false);
                  } catch (e) {
                    cb(e);
                  }
                };
                AsyncMirror2.isAvailable = function isAvailable() {
                  return true;
                };
                AsyncMirror2.prototype.getName = function getName() {
                  return AsyncMirror2.Name;
                };
                AsyncMirror2.prototype._syncSync = function _syncSync(fd) {
                  this._sync.writeFileSync(fd.getPath(), fd.getBuffer(), null, FileFlag8.getFileFlag("w"), fd.getStats().mode);
                  this.enqueueOp({
                    apiMethod: "writeFile",
                    arguments: [fd.getPath(), fd.getBuffer(), null, fd.getFlag(), fd.getStats().mode]
                  });
                };
                AsyncMirror2.prototype.initialize = function initialize3(userCb, deprecateMsg) {
                  var this$1 = this;
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  if (deprecateMsg) {
                    console.warn("[AsyncMirror] AsyncMirror.initialize() is deprecated and will be removed in the next major version. Please use 'AsyncMirror.Create({ sync: (sync file system instance), async: (async file system instance)}, cb)' to create and initialize AsyncMirror instances.");
                  }
                  var callbacks = this._initializeCallbacks;
                  var end = function(e) {
                    this$1._isInitialized = !e;
                    this$1._initializeCallbacks = [];
                    callbacks.forEach(function(cb) {
                      return cb(e);
                    });
                  };
                  if (!this._isInitialized) {
                    if (callbacks.push(userCb) === 1) {
                      var copyDirectory = function(p, mode, cb) {
                        if (p !== "/") {
                          this$1._sync.mkdirSync(p, mode);
                        }
                        this$1._async.readdir(p, function(err, files) {
                          var i2 = 0;
                          function copyNextFile(err2) {
                            if (err2) {
                              cb(err2);
                            } else if (i2 < files.length) {
                              copyItem(path.join(p, files[i2]), copyNextFile);
                              i2++;
                            } else {
                              cb();
                            }
                          }
                          if (err) {
                            cb(err);
                          } else {
                            copyNextFile();
                          }
                        });
                      }, copyFile = function(p, mode, cb) {
                        this$1._async.readFile(p, null, FileFlag8.getFileFlag("r"), function(err, data) {
                          if (err) {
                            cb(err);
                          } else {
                            try {
                              this$1._sync.writeFileSync(p, data, null, FileFlag8.getFileFlag("w"), mode);
                            } catch (e) {
                              err = e;
                            } finally {
                              cb(err);
                            }
                          }
                        });
                      }, copyItem = function(p, cb) {
                        this$1._async.stat(p, false, function(err, stats) {
                          if (err) {
                            cb(err);
                          } else if (stats.isDirectory()) {
                            copyDirectory(p, stats.mode, cb);
                          } else {
                            copyFile(p, stats.mode, cb);
                          }
                        });
                      };
                      copyDirectory("/", 0, end);
                    }
                  } else {
                    userCb();
                  }
                };
                AsyncMirror2.prototype.isReadOnly = function isReadOnly() {
                  return false;
                };
                AsyncMirror2.prototype.supportsSynch = function supportsSynch() {
                  return true;
                };
                AsyncMirror2.prototype.supportsLinks = function supportsLinks() {
                  return false;
                };
                AsyncMirror2.prototype.supportsProps = function supportsProps() {
                  return this._sync.supportsProps() && this._async.supportsProps();
                };
                AsyncMirror2.prototype.renameSync = function renameSync(oldPath, newPath) {
                  this.checkInitialized();
                  this._sync.renameSync(oldPath, newPath);
                  this.enqueueOp({
                    apiMethod: "rename",
                    arguments: [oldPath, newPath]
                  });
                };
                AsyncMirror2.prototype.statSync = function statSync(p, isLstat) {
                  this.checkInitialized();
                  return this._sync.statSync(p, isLstat);
                };
                AsyncMirror2.prototype.openSync = function openSync(p, flag, mode) {
                  this.checkInitialized();
                  var fd = this._sync.openSync(p, flag, mode);
                  fd.closeSync();
                  return new MirrorFile(this, p, flag, this._sync.statSync(p, false), this._sync.readFileSync(p, null, FileFlag8.getFileFlag("r")));
                };
                AsyncMirror2.prototype.unlinkSync = function unlinkSync(p) {
                  this.checkInitialized();
                  this._sync.unlinkSync(p);
                  this.enqueueOp({
                    apiMethod: "unlink",
                    arguments: [p]
                  });
                };
                AsyncMirror2.prototype.rmdirSync = function rmdirSync(p) {
                  this.checkInitialized();
                  this._sync.rmdirSync(p);
                  this.enqueueOp({
                    apiMethod: "rmdir",
                    arguments: [p]
                  });
                };
                AsyncMirror2.prototype.mkdirSync = function mkdirSync(p, mode) {
                  this.checkInitialized();
                  this._sync.mkdirSync(p, mode);
                  this.enqueueOp({
                    apiMethod: "mkdir",
                    arguments: [p, mode]
                  });
                };
                AsyncMirror2.prototype.readdirSync = function readdirSync(p) {
                  this.checkInitialized();
                  return this._sync.readdirSync(p);
                };
                AsyncMirror2.prototype.existsSync = function existsSync(p) {
                  this.checkInitialized();
                  return this._sync.existsSync(p);
                };
                AsyncMirror2.prototype.chmodSync = function chmodSync(p, isLchmod, mode) {
                  this.checkInitialized();
                  this._sync.chmodSync(p, isLchmod, mode);
                  this.enqueueOp({
                    apiMethod: "chmod",
                    arguments: [p, isLchmod, mode]
                  });
                };
                AsyncMirror2.prototype.chownSync = function chownSync(p, isLchown, uid, gid) {
                  this.checkInitialized();
                  this._sync.chownSync(p, isLchown, uid, gid);
                  this.enqueueOp({
                    apiMethod: "chown",
                    arguments: [p, isLchown, uid, gid]
                  });
                };
                AsyncMirror2.prototype.utimesSync = function utimesSync(p, atime, mtime) {
                  this.checkInitialized();
                  this._sync.utimesSync(p, atime, mtime);
                  this.enqueueOp({
                    apiMethod: "utimes",
                    arguments: [p, atime, mtime]
                  });
                };
                AsyncMirror2.prototype.checkInitialized = function checkInitialized() {
                  if (!this._isInitialized) {
                    throw new ApiError3(ErrorCode5.EPERM, "AsyncMirrorFS is not initialized. Please initialize AsyncMirrorFS using its initialize() method before using it.");
                  }
                };
                AsyncMirror2.prototype.enqueueOp = function enqueueOp(op) {
                  var this$1 = this;
                  this._queue.push(op);
                  if (!this._queueRunning) {
                    this._queueRunning = true;
                    var doNextOp = function(err) {
                      if (err) {
                        console.error("WARNING: File system has desynchronized. Received following error: " + err + "\n$");
                      }
                      if (this$1._queue.length > 0) {
                        var op2 = this$1._queue.shift(), args = op2.arguments;
                        args.push(doNextOp);
                        this$1._async[op2.apiMethod].apply(this$1._async, args);
                      } else {
                        this$1._queueRunning = false;
                      }
                    };
                    doNextOp();
                  }
                };
                return AsyncMirror2;
              }(SynchronousFileSystem);
              AsyncMirror.Name = "AsyncMirror";
              AsyncMirror.Options = {
                sync: {
                  type: "object",
                  description: "The synchronous file system to mirror the asynchronous file system to."
                },
                async: {
                  type: "object",
                  description: "The asynchronous file system to mirror."
                }
              };
              function apply(func, thisArg, args) {
                switch (args.length) {
                  case 0:
                    return func.call(thisArg);
                  case 1:
                    return func.call(thisArg, args[0]);
                  case 2:
                    return func.call(thisArg, args[0], args[1]);
                  case 3:
                    return func.call(thisArg, args[0], args[1], args[2]);
                }
                return func.apply(thisArg, args);
              }
              var nativeMax = Math.max;
              function overRest$1(func, start2, transform) {
                start2 = nativeMax(start2 === void 0 ? func.length - 1 : start2, 0);
                return function() {
                  var args = arguments, index = -1, length = nativeMax(args.length - start2, 0), array = Array(length);
                  while (++index < length) {
                    array[index] = args[start2 + index];
                  }
                  index = -1;
                  var otherArgs = Array(start2 + 1);
                  while (++index < start2) {
                    otherArgs[index] = args[index];
                  }
                  otherArgs[start2] = transform(array);
                  return apply(func, this, otherArgs);
                };
              }
              function identity(value) {
                return value;
              }
              function rest(func, start2) {
                return overRest$1(func, start2, identity);
              }
              var initialParams = function(fn) {
                return rest(function(args) {
                  var callback = args.pop();
                  fn.call(this, args, callback);
                });
              };
              function applyEach$1(eachfn) {
                return rest(function(fns, args) {
                  var go = initialParams(function(args2, callback) {
                    var that = this;
                    return eachfn(fns, function(fn, cb) {
                      fn.apply(that, args2.concat(cb));
                    }, callback);
                  });
                  if (args.length) {
                    return go.apply(this, args);
                  } else {
                    return go;
                  }
                });
              }
              var freeGlobal = typeof global2 == "object" && global2 && global2.Object === Object && global2;
              var freeSelf = typeof self == "object" && self && self.Object === Object && self;
              var root = freeGlobal || freeSelf || Function("return this")();
              var Symbol$1 = root.Symbol;
              var objectProto = Object.prototype;
              var hasOwnProperty = objectProto.hasOwnProperty;
              var nativeObjectToString = objectProto.toString;
              var symToStringTag$1 = Symbol$1 ? Symbol$1.toStringTag : void 0;
              function getRawTag(value) {
                var isOwn = hasOwnProperty.call(value, symToStringTag$1), tag = value[symToStringTag$1];
                try {
                  value[symToStringTag$1] = void 0;
                  var unmasked = true;
                } catch (e) {
                }
                var result = nativeObjectToString.call(value);
                if (unmasked) {
                  if (isOwn) {
                    value[symToStringTag$1] = tag;
                  } else {
                    delete value[symToStringTag$1];
                  }
                }
                return result;
              }
              var objectProto$1 = Object.prototype;
              var nativeObjectToString$1 = objectProto$1.toString;
              function objectToString(value) {
                return nativeObjectToString$1.call(value);
              }
              var nullTag = "[object Null]";
              var undefinedTag = "[object Undefined]";
              var symToStringTag = Symbol$1 ? Symbol$1.toStringTag : void 0;
              function baseGetTag(value) {
                if (value == null) {
                  return value === void 0 ? undefinedTag : nullTag;
                }
                return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
              }
              function isObject(value) {
                var type = typeof value;
                return value != null && (type == "object" || type == "function");
              }
              var asyncTag = "[object AsyncFunction]";
              var funcTag = "[object Function]";
              var genTag = "[object GeneratorFunction]";
              var proxyTag = "[object Proxy]";
              function isFunction(value) {
                if (!isObject(value)) {
                  return false;
                }
                var tag = baseGetTag(value);
                return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
              }
              var MAX_SAFE_INTEGER = 9007199254740991;
              function isLength(value) {
                return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
              }
              function isArrayLike(value) {
                return value != null && isLength(value.length) && !isFunction(value);
              }
              var breakLoop = {};
              function noop() {
              }
              function once(fn) {
                return function() {
                  if (fn === null) {
                    return;
                  }
                  var callFn = fn;
                  fn = null;
                  callFn.apply(this, arguments);
                };
              }
              var iteratorSymbol = typeof Symbol === "function" && Symbol.iterator;
              var getIterator = function(coll) {
                return iteratorSymbol && coll[iteratorSymbol] && coll[iteratorSymbol]();
              };
              function baseTimes(n, iteratee) {
                var index = -1, result = Array(n);
                while (++index < n) {
                  result[index] = iteratee(index);
                }
                return result;
              }
              function isObjectLike(value) {
                return value != null && typeof value == "object";
              }
              var argsTag = "[object Arguments]";
              function baseIsArguments(value) {
                return isObjectLike(value) && baseGetTag(value) == argsTag;
              }
              var objectProto$3 = Object.prototype;
              var hasOwnProperty$2 = objectProto$3.hasOwnProperty;
              var propertyIsEnumerable = objectProto$3.propertyIsEnumerable;
              var isArguments = baseIsArguments(/* @__PURE__ */ function() {
                return arguments;
              }()) ? baseIsArguments : function(value) {
                return isObjectLike(value) && hasOwnProperty$2.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
              };
              var isArray = Array.isArray;
              function stubFalse() {
                return false;
              }
              var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
              var freeModule = freeExports && typeof module4 == "object" && module4 && !module4.nodeType && module4;
              var moduleExports = freeModule && freeModule.exports === freeExports;
              var Buffer$1 = moduleExports ? root.Buffer : void 0;
              var nativeIsBuffer = Buffer$1 ? Buffer$1.isBuffer : void 0;
              var isBuffer = nativeIsBuffer || stubFalse;
              var MAX_SAFE_INTEGER$1 = 9007199254740991;
              var reIsUint = /^(?:0|[1-9]\d*)$/;
              function isIndex(value, length) {
                length = length == null ? MAX_SAFE_INTEGER$1 : length;
                return !!length && (typeof value == "number" || reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
              }
              var argsTag$1 = "[object Arguments]";
              var arrayTag = "[object Array]";
              var boolTag = "[object Boolean]";
              var dateTag = "[object Date]";
              var errorTag = "[object Error]";
              var funcTag$1 = "[object Function]";
              var mapTag = "[object Map]";
              var numberTag = "[object Number]";
              var objectTag = "[object Object]";
              var regexpTag = "[object RegExp]";
              var setTag = "[object Set]";
              var stringTag = "[object String]";
              var weakMapTag = "[object WeakMap]";
              var arrayBufferTag = "[object ArrayBuffer]";
              var dataViewTag = "[object DataView]";
              var float32Tag = "[object Float32Array]";
              var float64Tag = "[object Float64Array]";
              var int8Tag = "[object Int8Array]";
              var int16Tag = "[object Int16Array]";
              var int32Tag = "[object Int32Array]";
              var uint8Tag = "[object Uint8Array]";
              var uint8ClampedTag = "[object Uint8ClampedArray]";
              var uint16Tag = "[object Uint16Array]";
              var uint32Tag = "[object Uint32Array]";
              var typedArrayTags = {};
              typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
              typedArrayTags[argsTag$1] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag$1] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
              function baseIsTypedArray(value) {
                return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
              }
              function baseUnary(func) {
                return function(value) {
                  return func(value);
                };
              }
              var freeExports$1 = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
              var freeModule$1 = freeExports$1 && typeof module4 == "object" && module4 && !module4.nodeType && module4;
              var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;
              var freeProcess = moduleExports$1 && freeGlobal.process;
              var nodeUtil = function() {
                try {
                  return freeProcess && freeProcess.binding && freeProcess.binding("util");
                } catch (e) {
                }
              }();
              var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
              var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
              var objectProto$2 = Object.prototype;
              var hasOwnProperty$1 = objectProto$2.hasOwnProperty;
              function arrayLikeKeys(value, inherited) {
                var isArr = isArray(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer(value), isType = !isArr && !isArg && !isBuff && isTypedArray(value), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? baseTimes(value.length, String) : [], length = result.length;
                for (var key in value) {
                  if ((inherited || hasOwnProperty$1.call(value, key)) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
                  (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
                  isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
                  isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
                  isIndex(key, length)))) {
                    result.push(key);
                  }
                }
                return result;
              }
              var objectProto$5 = Object.prototype;
              function isPrototype(value) {
                var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto$5;
                return value === proto;
              }
              function overArg(func, transform) {
                return function(arg) {
                  return func(transform(arg));
                };
              }
              var nativeKeys = overArg(Object.keys, Object);
              var objectProto$4 = Object.prototype;
              var hasOwnProperty$3 = objectProto$4.hasOwnProperty;
              function baseKeys(object) {
                if (!isPrototype(object)) {
                  return nativeKeys(object);
                }
                var result = [];
                for (var key in Object(object)) {
                  if (hasOwnProperty$3.call(object, key) && key != "constructor") {
                    result.push(key);
                  }
                }
                return result;
              }
              function keys(object) {
                return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
              }
              function createArrayIterator(coll) {
                var i2 = -1;
                var len = coll.length;
                return function next() {
                  return ++i2 < len ? { value: coll[i2], key: i2 } : null;
                };
              }
              function createES2015Iterator(iterator2) {
                var i2 = -1;
                return function next() {
                  var item = iterator2.next();
                  if (item.done) {
                    return null;
                  }
                  i2++;
                  return { value: item.value, key: i2 };
                };
              }
              function createObjectIterator(obj) {
                var okeys = keys(obj);
                var i2 = -1;
                var len = okeys.length;
                return function next() {
                  var key = okeys[++i2];
                  return i2 < len ? { value: obj[key], key } : null;
                };
              }
              function iterator(coll) {
                if (isArrayLike(coll)) {
                  return createArrayIterator(coll);
                }
                var iterator2 = getIterator(coll);
                return iterator2 ? createES2015Iterator(iterator2) : createObjectIterator(coll);
              }
              function onlyOnce(fn) {
                return function() {
                  if (fn === null) {
                    throw new Error("Callback was already called.");
                  }
                  var callFn = fn;
                  fn = null;
                  callFn.apply(this, arguments);
                };
              }
              function _eachOfLimit(limit) {
                return function(obj, iteratee, callback) {
                  callback = once(callback || noop);
                  if (limit <= 0 || !obj) {
                    return callback(null);
                  }
                  var nextElem = iterator(obj);
                  var done = false;
                  var running = 0;
                  function iterateeCallback(err, value) {
                    running -= 1;
                    if (err) {
                      done = true;
                      callback(err);
                    } else if (value === breakLoop || done && running <= 0) {
                      done = true;
                      return callback(null);
                    } else {
                      replenish();
                    }
                  }
                  function replenish() {
                    while (running < limit && !done) {
                      var elem = nextElem();
                      if (elem === null) {
                        done = true;
                        if (running <= 0) {
                          callback(null);
                        }
                        return;
                      }
                      running += 1;
                      iteratee(elem.value, elem.key, onlyOnce(iterateeCallback));
                    }
                  }
                  replenish();
                };
              }
              function eachOfLimit(coll, limit, iteratee, callback) {
                _eachOfLimit(limit)(coll, iteratee, callback);
              }
              function doLimit(fn, limit) {
                return function(iterable, iteratee, callback) {
                  return fn(iterable, limit, iteratee, callback);
                };
              }
              function eachOfArrayLike(coll, iteratee, callback) {
                callback = once(callback || noop);
                var index = 0, completed = 0, length = coll.length;
                if (length === 0) {
                  callback(null);
                }
                function iteratorCallback(err, value) {
                  if (err) {
                    callback(err);
                  } else if (++completed === length || value === breakLoop) {
                    callback(null);
                  }
                }
                for (; index < length; index++) {
                  iteratee(coll[index], index, onlyOnce(iteratorCallback));
                }
              }
              var eachOfGeneric = doLimit(eachOfLimit, Infinity);
              var eachOf = function(coll, iteratee, callback) {
                var eachOfImplementation = isArrayLike(coll) ? eachOfArrayLike : eachOfGeneric;
                eachOfImplementation(coll, iteratee, callback);
              };
              function doParallel(fn) {
                return function(obj, iteratee, callback) {
                  return fn(eachOf, obj, iteratee, callback);
                };
              }
              function _asyncMap(eachfn, arr, iteratee, callback) {
                callback = callback || noop;
                arr = arr || [];
                var results = [];
                var counter = 0;
                eachfn(arr, function(value, _, callback2) {
                  var index = counter++;
                  iteratee(value, function(err, v) {
                    results[index] = v;
                    callback2(err);
                  });
                }, function(err) {
                  callback(err, results);
                });
              }
              var map = doParallel(_asyncMap);
              applyEach$1(map);
              function doParallelLimit(fn) {
                return function(obj, limit, iteratee, callback) {
                  return fn(_eachOfLimit(limit), obj, iteratee, callback);
                };
              }
              var mapLimit = doParallelLimit(_asyncMap);
              var mapSeries = doLimit(mapLimit, 1);
              applyEach$1(mapSeries);
              rest(function(fn, args) {
                return rest(function(callArgs) {
                  return fn.apply(null, args.concat(callArgs));
                });
              });
              function arrayEach(array, iteratee) {
                var index = -1, length = array == null ? 0 : array.length;
                while (++index < length) {
                  if (iteratee(array[index], index, array) === false) {
                    break;
                  }
                }
                return array;
              }
              function createBaseFor(fromRight) {
                return function(object, iteratee, keysFunc) {
                  var index = -1, iterable = Object(object), props = keysFunc(object), length = props.length;
                  while (length--) {
                    var key = props[fromRight ? length : ++index];
                    if (iteratee(iterable[key], key, iterable) === false) {
                      break;
                    }
                  }
                  return object;
                };
              }
              var baseFor = createBaseFor();
              function baseForOwn(object, iteratee) {
                return object && baseFor(object, iteratee, keys);
              }
              function baseFindIndex(array, predicate, fromIndex, fromRight) {
                var length = array.length, index = fromIndex + (fromRight ? 1 : -1);
                while (fromRight ? index-- : ++index < length) {
                  if (predicate(array[index], index, array)) {
                    return index;
                  }
                }
                return -1;
              }
              function baseIsNaN(value) {
                return value !== value;
              }
              function strictIndexOf(array, value, fromIndex) {
                var index = fromIndex - 1, length = array.length;
                while (++index < length) {
                  if (array[index] === value) {
                    return index;
                  }
                }
                return -1;
              }
              function baseIndexOf(array, value, fromIndex) {
                return value === value ? strictIndexOf(array, value, fromIndex) : baseFindIndex(array, baseIsNaN, fromIndex);
              }
              var rsAstralRange$1 = "\\ud800-\\udfff";
              var rsComboMarksRange$1 = "\\u0300-\\u036f";
              var reComboHalfMarksRange$1 = "\\ufe20-\\ufe2f";
              var rsComboSymbolsRange$1 = "\\u20d0-\\u20ff";
              var rsComboRange$1 = rsComboMarksRange$1 + reComboHalfMarksRange$1 + rsComboSymbolsRange$1;
              var rsVarRange$1 = "\\ufe0e\\ufe0f";
              var rsAstral = "[" + rsAstralRange$1 + "]";
              var rsCombo = "[" + rsComboRange$1 + "]";
              var rsFitz = "\\ud83c[\\udffb-\\udfff]";
              var rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")";
              var rsNonAstral = "[^" + rsAstralRange$1 + "]";
              var rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}";
              var rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]";
              var rsZWJ$1 = "\\u200d";
              var reOptMod = rsModifier + "?";
              var rsOptVar = "[" + rsVarRange$1 + "]?";
              var rsOptJoin = "(?:" + rsZWJ$1 + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*";
              var rsSeq = rsOptVar + reOptMod + rsOptJoin;
              var rsSymbol = "(?:" + [rsNonAstral + rsCombo + "?", rsCombo, rsRegional, rsSurrPair, rsAstral].join("|") + ")";
              var hasSetImmediate = typeof setImmediate === "function" && setImmediate;
              var hasNextTick = typeof process2 === "object" && typeof process2.nextTick === "function";
              function fallback(fn) {
                setTimeout(fn, 0);
              }
              function wrap(defer) {
                return rest(function(fn, args) {
                  defer(function() {
                    fn.apply(null, args);
                  });
                });
              }
              var _defer;
              if (hasSetImmediate) {
                _defer = setImmediate;
              } else if (hasNextTick) {
                _defer = process2.nextTick;
              } else {
                _defer = fallback;
              }
              wrap(_defer);
              var eachOfSeries = doLimit(eachOfLimit, 1);
              function reduce(coll, memo, iteratee, callback) {
                callback = once(callback || noop);
                eachOfSeries(coll, function(x, i2, callback2) {
                  iteratee(memo, x, function(err, v) {
                    memo = v;
                    callback2(err);
                  });
                }, function(err) {
                  callback(err, memo);
                });
              }
              var seq = rest(function seq2(functions) {
                return rest(function(args) {
                  var that = this;
                  var cb = args[args.length - 1];
                  if (typeof cb == "function") {
                    args.pop();
                  } else {
                    cb = noop;
                  }
                  reduce(
                    functions,
                    args,
                    function(newargs, fn, cb2) {
                      fn.apply(that, newargs.concat(rest(function(err, nextargs) {
                        cb2(err, nextargs);
                      })));
                    },
                    function(err, results) {
                      cb.apply(that, [err].concat(results));
                    }
                  );
                });
              });
              rest(function(args) {
                return seq.apply(null, args.reverse());
              });
              rest(function(values) {
                var args = [null].concat(values);
                return initialParams(function(ignoredArgs, callback) {
                  return callback.apply(this, args);
                });
              });
              function consoleFunc(name) {
                return rest(function(fn, args) {
                  fn.apply(null, args.concat(rest(function(err, args2) {
                    if (typeof console === "object") {
                      if (err) {
                        if (console.error) {
                          console.error(err);
                        }
                      } else if (console[name]) {
                        arrayEach(args2, function(x) {
                          console[name](x);
                        });
                      }
                    }
                  })));
                });
              }
              consoleFunc("dir");
              function _withoutIndex(iteratee) {
                return function(value, index, callback) {
                  return iteratee(value, callback);
                };
              }
              function eachLimit(coll, iteratee, callback) {
                eachOf(coll, _withoutIndex(iteratee), callback);
              }
              consoleFunc("log");
              var _defer$1;
              if (hasNextTick) {
                _defer$1 = process2.nextTick;
              } else if (hasSetImmediate) {
                _defer$1 = setImmediate;
              } else {
                _defer$1 = fallback;
              }
              wrap(_defer$1);
              var nativeCeil = Math.ceil;
              var nativeMax$1 = Math.max;
              var errorCodeLookup;
              function constructErrorCodeLookup() {
                if (errorCodeLookup) {
                  return;
                }
                errorCodeLookup = {};
                errorCodeLookup[Dropbox.ApiError.NETWORK_ERROR] = ErrorCode5.EIO;
                errorCodeLookup[Dropbox.ApiError.INVALID_PARAM] = ErrorCode5.EINVAL;
                errorCodeLookup[Dropbox.ApiError.INVALID_TOKEN] = ErrorCode5.EPERM;
                errorCodeLookup[Dropbox.ApiError.OAUTH_ERROR] = ErrorCode5.EPERM;
                errorCodeLookup[Dropbox.ApiError.NOT_FOUND] = ErrorCode5.ENOENT;
                errorCodeLookup[Dropbox.ApiError.INVALID_METHOD] = ErrorCode5.EINVAL;
                errorCodeLookup[Dropbox.ApiError.NOT_ACCEPTABLE] = ErrorCode5.EINVAL;
                errorCodeLookup[Dropbox.ApiError.CONFLICT] = ErrorCode5.EINVAL;
                errorCodeLookup[Dropbox.ApiError.RATE_LIMITED] = ErrorCode5.EBUSY;
                errorCodeLookup[Dropbox.ApiError.SERVER_ERROR] = ErrorCode5.EBUSY;
                errorCodeLookup[Dropbox.ApiError.OVER_QUOTA] = ErrorCode5.ENOSPC;
              }
              function isFileInfo(cache) {
                return cache && cache.stat.isFile;
              }
              function isDirInfo(cache) {
                return cache && cache.stat.isFolder;
              }
              function isArrayBuffer(ab) {
                return ab === null || ab === void 0 || typeof ab === "object" && typeof ab["byteLength"] === "number";
              }
              var CachedDropboxClient = function CachedDropboxClient2(client) {
                this._cache = {};
                this._client = client;
              };
              CachedDropboxClient.prototype.readdir = function readdir(p, cb) {
                var this$1 = this;
                var cacheInfo = this.getCachedDirInfo(p);
                this._wrap(function(interceptCb) {
                  if (cacheInfo !== null && cacheInfo.contents) {
                    this$1._client.readdir(p, {
                      contentHash: cacheInfo.stat.contentHash
                    }, interceptCb);
                  } else {
                    this$1._client.readdir(p, interceptCb);
                  }
                }, function(err, filenames, stat, folderEntries) {
                  if (err) {
                    if (err.status === Dropbox.ApiError.NO_CONTENT && cacheInfo !== null) {
                      cb(null, cacheInfo.contents.slice(0));
                    } else {
                      cb(err);
                    }
                  } else {
                    this$1.updateCachedDirInfo(p, stat, filenames.slice(0));
                    folderEntries.forEach(function(entry) {
                      this$1.updateCachedInfo(path.join(p, entry.name), entry);
                    });
                    cb(null, filenames);
                  }
                });
              };
              CachedDropboxClient.prototype.remove = function remove(p, cb) {
                var this$1 = this;
                this._wrap(function(interceptCb) {
                  this$1._client.remove(p, interceptCb);
                }, function(err, stat) {
                  if (!err) {
                    this$1.updateCachedInfo(p, stat);
                  }
                  cb(err);
                });
              };
              CachedDropboxClient.prototype.move = function move(src, dest, cb) {
                var this$1 = this;
                this._wrap(function(interceptCb) {
                  this$1._client.move(src, dest, interceptCb);
                }, function(err, stat) {
                  if (!err) {
                    this$1.deleteCachedInfo(src);
                    this$1.updateCachedInfo(dest, stat);
                  }
                  cb(err);
                });
              };
              CachedDropboxClient.prototype.stat = function stat(p, cb) {
                var this$1 = this;
                this._wrap(function(interceptCb) {
                  this$1._client.stat(p, interceptCb);
                }, function(err, stat2) {
                  if (!err) {
                    this$1.updateCachedInfo(p, stat2);
                  }
                  cb(err, stat2);
                });
              };
              CachedDropboxClient.prototype.readFile = function readFile(p, cb) {
                var this$1 = this;
                var cacheInfo = this.getCachedFileInfo(p);
                if (cacheInfo !== null && cacheInfo.contents !== null) {
                  this.stat(p, function(error, stat) {
                    if (error) {
                      cb(error);
                    } else if (stat.contentHash === cacheInfo.stat.contentHash) {
                      cb(error, cacheInfo.contents.slice(0), cacheInfo.stat);
                    } else {
                      this$1.readFile(p, cb);
                    }
                  });
                } else {
                  this._wrap(function(interceptCb) {
                    this$1._client.readFile(p, { arrayBuffer: true }, interceptCb);
                  }, function(err, contents, stat) {
                    if (!err) {
                      this$1.updateCachedInfo(p, stat, contents.slice(0));
                    }
                    cb(err, contents, stat);
                  });
                }
              };
              CachedDropboxClient.prototype.writeFile = function writeFile(p, contents, cb) {
                var this$1 = this;
                this._wrap(function(interceptCb) {
                  this$1._client.writeFile(p, contents, interceptCb);
                }, function(err, stat) {
                  if (!err) {
                    this$1.updateCachedInfo(p, stat, contents.slice(0));
                  }
                  cb(err, stat);
                });
              };
              CachedDropboxClient.prototype.mkdir = function mkdir(p, cb) {
                var this$1 = this;
                this._wrap(function(interceptCb) {
                  this$1._client.mkdir(p, interceptCb);
                }, function(err, stat) {
                  if (!err) {
                    this$1.updateCachedInfo(p, stat, []);
                  }
                  cb(err);
                });
              };
              CachedDropboxClient.prototype._wrap = function _wrap(performOp, cb) {
                var numRun = 0;
                var interceptCb = function(error) {
                  var timeoutDuration = 2;
                  if (error && 3 > ++numRun) {
                    switch (error.status) {
                      case Dropbox.ApiError.SERVER_ERROR:
                      case Dropbox.ApiError.NETWORK_ERROR:
                      case Dropbox.ApiError.RATE_LIMITED:
                        setTimeout(function() {
                          performOp(interceptCb);
                        }, timeoutDuration * 1e3);
                        break;
                      default:
                        cb.apply(null, arguments);
                        break;
                    }
                  } else {
                    cb.apply(null, arguments);
                  }
                };
                performOp(interceptCb);
              };
              CachedDropboxClient.prototype.getCachedInfo = function getCachedInfo(p) {
                return this._cache[p.toLowerCase()];
              };
              CachedDropboxClient.prototype.putCachedInfo = function putCachedInfo(p, cache) {
                this._cache[p.toLowerCase()] = cache;
              };
              CachedDropboxClient.prototype.deleteCachedInfo = function deleteCachedInfo(p) {
                delete this._cache[p.toLowerCase()];
              };
              CachedDropboxClient.prototype.getCachedDirInfo = function getCachedDirInfo(p) {
                var info = this.getCachedInfo(p);
                if (isDirInfo(info)) {
                  return info;
                } else {
                  return null;
                }
              };
              CachedDropboxClient.prototype.getCachedFileInfo = function getCachedFileInfo(p) {
                var info = this.getCachedInfo(p);
                if (isFileInfo(info)) {
                  return info;
                } else {
                  return null;
                }
              };
              CachedDropboxClient.prototype.updateCachedDirInfo = function updateCachedDirInfo(p, stat, contents) {
                if (contents === void 0) contents = null;
                var cachedInfo = this.getCachedInfo(p);
                if (stat.contentHash !== null && (cachedInfo === void 0 || cachedInfo.stat.contentHash !== stat.contentHash)) {
                  this.putCachedInfo(p, {
                    stat,
                    contents
                  });
                }
              };
              CachedDropboxClient.prototype.updateCachedFileInfo = function updateCachedFileInfo(p, stat, contents) {
                if (contents === void 0) contents = null;
                var cachedInfo = this.getCachedInfo(p);
                if (stat.versionTag !== null && (cachedInfo === void 0 || cachedInfo.stat.versionTag !== stat.versionTag)) {
                  this.putCachedInfo(p, {
                    stat,
                    contents
                  });
                }
              };
              CachedDropboxClient.prototype.updateCachedInfo = function updateCachedInfo(p, stat, contents) {
                if (contents === void 0) contents = null;
                if (stat.isFile && isArrayBuffer(contents)) {
                  this.updateCachedFileInfo(p, stat, contents);
                } else if (stat.isFolder && Array.isArray(contents)) {
                  this.updateCachedDirInfo(p, stat, contents);
                }
              };
              var DropboxFile = function(PreloadFile$$1) {
                function DropboxFile2(_fs, _path, _flag, _stat, contents) {
                  PreloadFile$$1.call(this, _fs, _path, _flag, _stat, contents);
                }
                if (PreloadFile$$1) DropboxFile2.__proto__ = PreloadFile$$1;
                DropboxFile2.prototype = Object.create(PreloadFile$$1 && PreloadFile$$1.prototype);
                DropboxFile2.prototype.constructor = DropboxFile2;
                DropboxFile2.prototype.sync = function sync(cb) {
                  var this$1 = this;
                  if (this.isDirty()) {
                    var buffer$$1 = this.getBuffer(), arrayBuffer = buffer2ArrayBuffer(buffer$$1);
                    this._fs._writeFileStrict(this.getPath(), arrayBuffer, function(e) {
                      if (!e) {
                        this$1.resetDirty();
                      }
                      cb(e);
                    });
                  } else {
                    cb();
                  }
                };
                DropboxFile2.prototype.close = function close(cb) {
                  this.sync(cb);
                };
                return DropboxFile2;
              }(PreloadFile2);
              var DropboxFileSystem = function(BaseFileSystem$$1) {
                function DropboxFileSystem2(client, deprecateMsg) {
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  BaseFileSystem$$1.call(this);
                  this._client = new CachedDropboxClient(client);
                  deprecationMessage(deprecateMsg, DropboxFileSystem2.Name, { client: "authenticated dropbox client instance" });
                  constructErrorCodeLookup();
                }
                if (BaseFileSystem$$1) DropboxFileSystem2.__proto__ = BaseFileSystem$$1;
                DropboxFileSystem2.prototype = Object.create(BaseFileSystem$$1 && BaseFileSystem$$1.prototype);
                DropboxFileSystem2.prototype.constructor = DropboxFileSystem2;
                DropboxFileSystem2.Create = function Create(opts, cb) {
                  cb(null, new DropboxFileSystem2(opts.client, false));
                };
                DropboxFileSystem2.isAvailable = function isAvailable() {
                  return typeof Dropbox !== "undefined";
                };
                DropboxFileSystem2.prototype.getName = function getName() {
                  return DropboxFileSystem2.Name;
                };
                DropboxFileSystem2.prototype.isReadOnly = function isReadOnly() {
                  return false;
                };
                DropboxFileSystem2.prototype.supportsSymlinks = function supportsSymlinks() {
                  return false;
                };
                DropboxFileSystem2.prototype.supportsProps = function supportsProps() {
                  return false;
                };
                DropboxFileSystem2.prototype.supportsSynch = function supportsSynch() {
                  return false;
                };
                DropboxFileSystem2.prototype.empty = function empty(mainCb) {
                  var this$1 = this;
                  this._client.readdir("/", function(error, files) {
                    if (error) {
                      mainCb(this$1.convert(error, "/"));
                    } else {
                      var deleteFile = function(file, cb) {
                        var p = path.join("/", file);
                        this$1._client.remove(p, function(err) {
                          cb(err ? this$1.convert(err, p) : null);
                        });
                      };
                      var finished = function(err) {
                        if (err) {
                          mainCb(err);
                        } else {
                          mainCb();
                        }
                      };
                      eachLimit(files, deleteFile, finished);
                    }
                  });
                };
                DropboxFileSystem2.prototype.rename = function rename(oldPath, newPath, cb) {
                  var this$1 = this;
                  this._client.move(oldPath, newPath, function(error) {
                    if (error) {
                      this$1._client.stat(newPath, function(error2, stat) {
                        if (error2 || stat.isFolder) {
                          var missingPath = error.response.error.indexOf(oldPath) > -1 ? oldPath : newPath;
                          cb(this$1.convert(error, missingPath));
                        } else {
                          this$1._client.remove(newPath, function(error22) {
                            if (error22) {
                              cb(this$1.convert(error22, newPath));
                            } else {
                              this$1.rename(oldPath, newPath, cb);
                            }
                          });
                        }
                      });
                    } else {
                      cb();
                    }
                  });
                };
                DropboxFileSystem2.prototype.stat = function stat(path$$1, isLstat, cb) {
                  var this$1 = this;
                  this._client.stat(path$$1, function(error, stat2) {
                    if (error) {
                      cb(this$1.convert(error, path$$1));
                    } else if (stat2 && stat2.isRemoved) {
                      cb(ApiError3.FileError(ErrorCode5.ENOENT, path$$1));
                    } else {
                      var stats = new Stats2(this$1._statType(stat2), stat2.size);
                      return cb(null, stats);
                    }
                  });
                };
                DropboxFileSystem2.prototype.open = function open(path$$1, flags, mode, cb) {
                  var this$1 = this;
                  this._client.readFile(path$$1, function(error, content, dbStat) {
                    if (error) {
                      if (flags.isReadable()) {
                        cb(this$1.convert(error, path$$1));
                      } else {
                        switch (error.status) {
                          // If it's being opened for writing or appending, create it so that
                          // it can be written to
                          case Dropbox.ApiError.NOT_FOUND:
                            var ab = new ArrayBuffer(0);
                            return this$1._writeFileStrict(path$$1, ab, function(error2, stat) {
                              if (error2) {
                                cb(error2);
                              } else {
                                var file2 = this$1._makeFile(path$$1, flags, stat, arrayBuffer2Buffer(ab));
                                cb(null, file2);
                              }
                            });
                          default:
                            return cb(this$1.convert(error, path$$1));
                        }
                      }
                    } else {
                      var buffer$$1;
                      if (content === null) {
                        buffer$$1 = emptyBuffer();
                      } else {
                        buffer$$1 = arrayBuffer2Buffer(content);
                      }
                      var file = this$1._makeFile(path$$1, flags, dbStat, buffer$$1);
                      return cb(null, file);
                    }
                  });
                };
                DropboxFileSystem2.prototype._writeFileStrict = function _writeFileStrict(p, data, cb) {
                  var this$1 = this;
                  var parent = path.dirname(p);
                  this.stat(parent, false, function(error, stat) {
                    if (error) {
                      cb(ApiError3.FileError(ErrorCode5.ENOENT, parent));
                    } else {
                      this$1._client.writeFile(p, data, function(error2, stat2) {
                        if (error2) {
                          cb(this$1.convert(error2, p));
                        } else {
                          cb(null, stat2);
                        }
                      });
                    }
                  });
                };
                DropboxFileSystem2.prototype._statType = function _statType(stat) {
                  return stat.isFile ? FileType5.FILE : FileType5.DIRECTORY;
                };
                DropboxFileSystem2.prototype._makeFile = function _makeFile(path$$1, flag, stat, buffer$$1) {
                  var type = this._statType(stat);
                  var stats = new Stats2(type, stat.size);
                  return new DropboxFile(this, path$$1, flag, stats, buffer$$1);
                };
                DropboxFileSystem2.prototype._remove = function _remove(path$$1, cb, isFile) {
                  var this$1 = this;
                  this._client.stat(path$$1, function(error, stat) {
                    if (error) {
                      cb(this$1.convert(error, path$$1));
                    } else {
                      if (stat.isFile && !isFile) {
                        cb(ApiError3.FileError(ErrorCode5.ENOTDIR, path$$1));
                      } else if (!stat.isFile && isFile) {
                        cb(ApiError3.FileError(ErrorCode5.EISDIR, path$$1));
                      } else {
                        this$1._client.remove(path$$1, function(error2) {
                          if (error2) {
                            cb(this$1.convert(error2, path$$1));
                          } else {
                            cb(null);
                          }
                        });
                      }
                    }
                  });
                };
                DropboxFileSystem2.prototype.unlink = function unlink(path$$1, cb) {
                  this._remove(path$$1, cb, true);
                };
                DropboxFileSystem2.prototype.rmdir = function rmdir(path$$1, cb) {
                  this._remove(path$$1, cb, false);
                };
                DropboxFileSystem2.prototype.mkdir = function mkdir(p, mode, cb) {
                  var this$1 = this;
                  var parent = path.dirname(p);
                  this._client.stat(parent, function(error, stat) {
                    if (error) {
                      cb(this$1.convert(error, parent));
                    } else {
                      this$1._client.mkdir(p, function(error2) {
                        if (error2) {
                          cb(ApiError3.FileError(ErrorCode5.EEXIST, p));
                        } else {
                          cb(null);
                        }
                      });
                    }
                  });
                };
                DropboxFileSystem2.prototype.readdir = function readdir(path$$1, cb) {
                  var this$1 = this;
                  this._client.readdir(path$$1, function(error, files) {
                    if (error) {
                      return cb(this$1.convert(error));
                    } else {
                      return cb(null, files);
                    }
                  });
                };
                DropboxFileSystem2.prototype.convert = function convert(err, path$$1) {
                  if (path$$1 === void 0) path$$1 = null;
                  var errorCode = errorCodeLookup[err.status];
                  if (errorCode === void 0) {
                    errorCode = ErrorCode5.EIO;
                  }
                  if (!path$$1) {
                    return new ApiError3(errorCode);
                  } else {
                    return ApiError3.FileError(errorCode, path$$1);
                  }
                };
                return DropboxFileSystem2;
              }(BaseFileSystem3);
              DropboxFileSystem.Name = "Dropbox";
              DropboxFileSystem.Options = {
                client: {
                  type: "object",
                  description: "An *authenticated* Dropbox client. Must be from the 0.10 JS SDK.",
                  validator: function(opt, cb) {
                    if (opt.isAuthenticated && opt.isAuthenticated()) {
                      cb();
                    } else {
                      cb(new ApiError3(ErrorCode5.EINVAL, "'client' option must be an authenticated Dropbox client from the v0.10 JS SDK."));
                    }
                  }
                }
              };
              function convertError(e, path$$1) {
                if (path$$1 === void 0) path$$1 = "";
                var errno = e.errno;
                var parent = e.node;
                var paths = [];
                while (parent) {
                  paths.unshift(parent.name);
                  if (parent === parent.parent) {
                    break;
                  }
                  parent = parent.parent;
                }
                return new ApiError3(errno, ErrorStrings[errno], paths.length > 0 ? "/" + paths.join("/") : path$$1);
              }
              var EmscriptenFile = function(BaseFile$$1) {
                function EmscriptenFile2(_fs, _FS, _path, _stream) {
                  BaseFile$$1.call(this);
                  this._fs = _fs;
                  this._FS = _FS;
                  this._path = _path;
                  this._stream = _stream;
                }
                if (BaseFile$$1) EmscriptenFile2.__proto__ = BaseFile$$1;
                EmscriptenFile2.prototype = Object.create(BaseFile$$1 && BaseFile$$1.prototype);
                EmscriptenFile2.prototype.constructor = EmscriptenFile2;
                EmscriptenFile2.prototype.getPos = function getPos() {
                  return void 0;
                };
                EmscriptenFile2.prototype.close = function close(cb) {
                  var err = null;
                  try {
                    this.closeSync();
                  } catch (e) {
                    err = e;
                  } finally {
                    cb(err);
                  }
                };
                EmscriptenFile2.prototype.closeSync = function closeSync() {
                  try {
                    this._FS.close(this._stream);
                  } catch (e) {
                    throw convertError(e, this._path);
                  }
                };
                EmscriptenFile2.prototype.stat = function stat(cb) {
                  try {
                    cb(null, this.statSync());
                  } catch (e) {
                    cb(e);
                  }
                };
                EmscriptenFile2.prototype.statSync = function statSync() {
                  try {
                    return this._fs.statSync(this._path, false);
                  } catch (e) {
                    throw convertError(e, this._path);
                  }
                };
                EmscriptenFile2.prototype.truncate = function truncate(len, cb) {
                  var err = null;
                  try {
                    this.truncateSync(len);
                  } catch (e) {
                    err = e;
                  } finally {
                    cb(err);
                  }
                };
                EmscriptenFile2.prototype.truncateSync = function truncateSync(len) {
                  try {
                    this._FS.ftruncate(this._stream.fd, len);
                  } catch (e) {
                    throw convertError(e, this._path);
                  }
                };
                EmscriptenFile2.prototype.write = function write(buffer$$1, offset, length, position, cb) {
                  try {
                    cb(null, this.writeSync(buffer$$1, offset, length, position), buffer$$1);
                  } catch (e) {
                    cb(e);
                  }
                };
                EmscriptenFile2.prototype.writeSync = function writeSync(buffer$$1, offset, length, position) {
                  try {
                    var u8 = buffer2Uint8array(buffer$$1);
                    var emPosition = position === null ? void 0 : position;
                    return this._FS.write(this._stream, u8, offset, length, emPosition);
                  } catch (e) {
                    throw convertError(e, this._path);
                  }
                };
                EmscriptenFile2.prototype.read = function read(buffer$$1, offset, length, position, cb) {
                  try {
                    cb(null, this.readSync(buffer$$1, offset, length, position), buffer$$1);
                  } catch (e) {
                    cb(e);
                  }
                };
                EmscriptenFile2.prototype.readSync = function readSync(buffer$$1, offset, length, position) {
                  try {
                    var u8 = buffer2Uint8array(buffer$$1);
                    var emPosition = position === null ? void 0 : position;
                    return this._FS.read(this._stream, u8, offset, length, emPosition);
                  } catch (e) {
                    throw convertError(e, this._path);
                  }
                };
                EmscriptenFile2.prototype.sync = function sync(cb) {
                  cb();
                };
                EmscriptenFile2.prototype.syncSync = function syncSync() {
                };
                EmscriptenFile2.prototype.chown = function chown(uid, gid, cb) {
                  var err = null;
                  try {
                    this.chownSync(uid, gid);
                  } catch (e) {
                    err = e;
                  } finally {
                    cb(err);
                  }
                };
                EmscriptenFile2.prototype.chownSync = function chownSync(uid, gid) {
                  try {
                    this._FS.fchown(this._stream.fd, uid, gid);
                  } catch (e) {
                    throw convertError(e, this._path);
                  }
                };
                EmscriptenFile2.prototype.chmod = function chmod(mode, cb) {
                  var err = null;
                  try {
                    this.chmodSync(mode);
                  } catch (e) {
                    err = e;
                  } finally {
                    cb(err);
                  }
                };
                EmscriptenFile2.prototype.chmodSync = function chmodSync(mode) {
                  try {
                    this._FS.fchmod(this._stream.fd, mode);
                  } catch (e) {
                    throw convertError(e, this._path);
                  }
                };
                EmscriptenFile2.prototype.utimes = function utimes(atime, mtime, cb) {
                  var err = null;
                  try {
                    this.utimesSync(atime, mtime);
                  } catch (e) {
                    err = e;
                  } finally {
                    cb(err);
                  }
                };
                EmscriptenFile2.prototype.utimesSync = function utimesSync(atime, mtime) {
                  this._fs.utimesSync(this._path, atime, mtime);
                };
                return EmscriptenFile2;
              }(BaseFile);
              var EmscriptenFileSystem = function(SynchronousFileSystem$$1) {
                function EmscriptenFileSystem2(_FS) {
                  SynchronousFileSystem$$1.call(this);
                  this._FS = _FS;
                }
                if (SynchronousFileSystem$$1) EmscriptenFileSystem2.__proto__ = SynchronousFileSystem$$1;
                EmscriptenFileSystem2.prototype = Object.create(SynchronousFileSystem$$1 && SynchronousFileSystem$$1.prototype);
                EmscriptenFileSystem2.prototype.constructor = EmscriptenFileSystem2;
                EmscriptenFileSystem2.Create = function Create(opts, cb) {
                  cb(null, new EmscriptenFileSystem2(opts.FS));
                };
                EmscriptenFileSystem2.isAvailable = function isAvailable() {
                  return true;
                };
                EmscriptenFileSystem2.prototype.getName = function getName() {
                  return this._FS.DB_NAME();
                };
                EmscriptenFileSystem2.prototype.isReadOnly = function isReadOnly() {
                  return false;
                };
                EmscriptenFileSystem2.prototype.supportsLinks = function supportsLinks() {
                  return true;
                };
                EmscriptenFileSystem2.prototype.supportsProps = function supportsProps() {
                  return true;
                };
                EmscriptenFileSystem2.prototype.supportsSynch = function supportsSynch() {
                  return true;
                };
                EmscriptenFileSystem2.prototype.renameSync = function renameSync(oldPath, newPath) {
                  try {
                    this._FS.rename(oldPath, newPath);
                  } catch (e) {
                    if (e.errno === ErrorCode5.ENOENT) {
                      throw convertError(e, this.existsSync(oldPath) ? newPath : oldPath);
                    } else {
                      throw convertError(e);
                    }
                  }
                };
                EmscriptenFileSystem2.prototype.statSync = function statSync(p, isLstat) {
                  try {
                    var stats = isLstat ? this._FS.lstat(p) : this._FS.stat(p);
                    var itemType = this.modeToFileType(stats.mode);
                    return new Stats2(itemType, stats.size, stats.mode, stats.atime, stats.mtime, stats.ctime);
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.openSync = function openSync(p, flag, mode) {
                  try {
                    var stream = this._FS.open(p, flag.getFlagString(), mode);
                    if (this._FS.isDir(stream.node.mode)) {
                      this._FS.close(stream);
                      throw ApiError3.EISDIR(p);
                    }
                    return new EmscriptenFile(this, this._FS, p, stream);
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.unlinkSync = function unlinkSync(p) {
                  try {
                    this._FS.unlink(p);
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.rmdirSync = function rmdirSync(p) {
                  try {
                    this._FS.rmdir(p);
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.mkdirSync = function mkdirSync(p, mode) {
                  try {
                    this._FS.mkdir(p, mode);
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.readdirSync = function readdirSync(p) {
                  try {
                    return this._FS.readdir(p).filter(function(p2) {
                      return p2 !== "." && p2 !== "..";
                    });
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.truncateSync = function truncateSync(p, len) {
                  try {
                    this._FS.truncate(p, len);
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.readFileSync = function readFileSync(p, encoding, flag) {
                  try {
                    var data = this._FS.readFile(p, { flags: flag.getFlagString() });
                    var buff = uint8Array2Buffer(data);
                    if (encoding) {
                      return buff.toString(encoding);
                    } else {
                      return buff;
                    }
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.writeFileSync = function writeFileSync(p, data, encoding, flag, mode) {
                  try {
                    if (encoding) {
                      data = Buffer2.from(data, encoding);
                    }
                    var u8 = buffer2Uint8array(data);
                    this._FS.writeFile(p, u8, { flags: flag.getFlagString(), encoding: "binary" });
                    this._FS.chmod(p, mode);
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.chmodSync = function chmodSync(p, isLchmod, mode) {
                  try {
                    isLchmod ? this._FS.lchmod(p, mode) : this._FS.chmod(p, mode);
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.chownSync = function chownSync(p, isLchown, uid, gid) {
                  try {
                    isLchown ? this._FS.lchown(p, uid, gid) : this._FS.chown(p, uid, gid);
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.symlinkSync = function symlinkSync(srcpath, dstpath, type) {
                  try {
                    this._FS.symlink(srcpath, dstpath);
                  } catch (e) {
                    throw convertError(e);
                  }
                };
                EmscriptenFileSystem2.prototype.readlinkSync = function readlinkSync(p) {
                  try {
                    return this._FS.readlink(p);
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.utimesSync = function utimesSync(p, atime, mtime) {
                  try {
                    this._FS.utime(p, atime.getTime(), mtime.getTime());
                  } catch (e) {
                    throw convertError(e, p);
                  }
                };
                EmscriptenFileSystem2.prototype.modeToFileType = function modeToFileType(mode) {
                  if (this._FS.isDir(mode)) {
                    return FileType5.DIRECTORY;
                  } else if (this._FS.isFile(mode)) {
                    return FileType5.FILE;
                  } else if (this._FS.isLink(mode)) {
                    return FileType5.SYMLINK;
                  } else {
                    throw ApiError3.EPERM("Invalid mode: " + mode);
                  }
                };
                return EmscriptenFileSystem2;
              }(SynchronousFileSystem);
              EmscriptenFileSystem.Name = "EmscriptenFileSystem";
              EmscriptenFileSystem.Options = {
                FS: {
                  type: "object",
                  description: "The Emscripten file system to use (the `FS` variable)"
                }
              };
              var FolderAdapter = function(BaseFileSystem$$1) {
                function FolderAdapter2(folder, wrapped) {
                  BaseFileSystem$$1.call(this);
                  this._folder = folder;
                  this._wrapped = wrapped;
                }
                if (BaseFileSystem$$1) FolderAdapter2.__proto__ = BaseFileSystem$$1;
                FolderAdapter2.prototype = Object.create(BaseFileSystem$$1 && BaseFileSystem$$1.prototype);
                FolderAdapter2.prototype.constructor = FolderAdapter2;
                FolderAdapter2.Create = function Create(opts, cb) {
                  cb(null, new FolderAdapter2(opts.folder, opts.wrapped));
                };
                FolderAdapter2.isAvailable = function isAvailable() {
                  return true;
                };
                FolderAdapter2.prototype.initialize = function initialize3(cb) {
                  var this$1 = this;
                  this._wrapped.exists(this._folder, function(exists) {
                    if (exists) {
                      cb();
                    } else if (this$1._wrapped.isReadOnly()) {
                      cb(ApiError3.ENOENT(this$1._folder));
                    } else {
                      this$1._wrapped.mkdir(this$1._folder, 511, cb);
                    }
                  });
                };
                FolderAdapter2.prototype.getName = function getName() {
                  return this._wrapped.getName();
                };
                FolderAdapter2.prototype.isReadOnly = function isReadOnly() {
                  return this._wrapped.isReadOnly();
                };
                FolderAdapter2.prototype.supportsProps = function supportsProps() {
                  return this._wrapped.supportsProps();
                };
                FolderAdapter2.prototype.supportsSynch = function supportsSynch() {
                  return this._wrapped.supportsSynch();
                };
                FolderAdapter2.prototype.supportsLinks = function supportsLinks() {
                  return false;
                };
                return FolderAdapter2;
              }(BaseFileSystem3);
              FolderAdapter.Name = "FolderAdapter";
              FolderAdapter.Options = {
                folder: {
                  type: "string",
                  description: "The folder to use as the root directory"
                },
                wrapped: {
                  type: "object",
                  description: "The file system to wrap"
                }
              };
              function translateError(folder, e) {
                if (e !== null && typeof e === "object") {
                  var err = e;
                  var p = err.path;
                  if (p) {
                    p = "/" + path.relative(folder, p);
                    err.message = err.message.replace(err.path, p);
                    err.path = p;
                  }
                }
                return e;
              }
              function wrapCallback(folder, cb) {
                if (typeof cb === "function") {
                  return function(err) {
                    if (arguments.length > 0) {
                      arguments[0] = translateError(folder, err);
                    }
                    cb.apply(null, arguments);
                  };
                } else {
                  return cb;
                }
              }
              function wrapFunction(name, wrapFirst, wrapSecond) {
                if (name.slice(name.length - 4) !== "Sync") {
                  return function() {
                    if (arguments.length > 0) {
                      if (wrapFirst) {
                        arguments[0] = path.join(this._folder, arguments[0]);
                      }
                      if (wrapSecond) {
                        arguments[1] = path.join(this._folder, arguments[1]);
                      }
                      arguments[arguments.length - 1] = wrapCallback(this._folder, arguments[arguments.length - 1]);
                    }
                    return this._wrapped[name].apply(this._wrapped, arguments);
                  };
                } else {
                  return function() {
                    try {
                      if (wrapFirst) {
                        arguments[0] = path.join(this._folder, arguments[0]);
                      }
                      if (wrapSecond) {
                        arguments[1] = path.join(this._folder, arguments[1]);
                      }
                      return this._wrapped[name].apply(this._wrapped, arguments);
                    } catch (e) {
                      throw translateError(this._folder, e);
                    }
                  };
                }
              }
              [
                "diskSpace",
                "stat",
                "statSync",
                "open",
                "openSync",
                "unlink",
                "unlinkSync",
                "rmdir",
                "rmdirSync",
                "mkdir",
                "mkdirSync",
                "readdir",
                "readdirSync",
                "exists",
                "existsSync",
                "realpath",
                "realpathSync",
                "truncate",
                "truncateSync",
                "readFile",
                "readFileSync",
                "writeFile",
                "writeFileSync",
                "appendFile",
                "appendFileSync",
                "chmod",
                "chmodSync",
                "chown",
                "chownSync",
                "utimes",
                "utimesSync",
                "readlink",
                "readlinkSync"
              ].forEach(function(name) {
                FolderAdapter.prototype[name] = wrapFunction(name, true, false);
              });
              ["rename", "renameSync", "link", "linkSync", "symlink", "symlinkSync"].forEach(function(name) {
                FolderAdapter.prototype[name] = wrapFunction(name, true, true);
              });
              var toExport;
              if (typeof window !== "undefined") {
                toExport = window;
              } else if (typeof self !== "undefined") {
                toExport = self;
              } else {
                toExport = global2;
              }
              var global$1 = toExport;
              function isDirectoryEntry(entry) {
                return entry.isDirectory;
              }
              var _getFS = global$1.webkitRequestFileSystem || global$1.requestFileSystem || null;
              function _requestQuota(type, size, success, errorCallback) {
                if (typeof navigator["webkitPersistentStorage"] !== "undefined") {
                  switch (type) {
                    case global$1.PERSISTENT:
                      navigator.webkitPersistentStorage.requestQuota(size, success, errorCallback);
                      break;
                    case global$1.TEMPORARY:
                      navigator.webkitTemporaryStorage.requestQuota(size, success, errorCallback);
                      break;
                    default:
                      errorCallback(new TypeError("Invalid storage type: " + type));
                      break;
                  }
                } else {
                  global$1.webkitStorageInfo.requestQuota(type, size, success, errorCallback);
                }
              }
              function _toArray(list2) {
                return Array.prototype.slice.call(list2 || [], 0);
              }
              function convertError$1(err, p, expectedDir) {
                switch (err.name) {
                  /* The user agent failed to create a file or directory due to the existence of a file or
                      directory with the same path.  */
                  case "PathExistsError":
                    return ApiError3.EEXIST(p);
                  /* The operation failed because it would cause the application to exceed its storage quota.  */
                  case "QuotaExceededError":
                    return ApiError3.FileError(ErrorCode5.ENOSPC, p);
                  /*  A required file or directory could not be found at the time an operation was processed.   */
                  case "NotFoundError":
                    return ApiError3.ENOENT(p);
                  /* This is a security error code to be used in situations not covered by any other error codes.
                      - A required file was unsafe for access within a Web application
                      - Too many calls are being made on filesystem resources */
                  case "SecurityError":
                    return ApiError3.FileError(ErrorCode5.EACCES, p);
                  /* The modification requested was illegal. Examples of invalid modifications include moving a
                      directory into its own child, moving a file into its parent directory without changing its name,
                      or copying a directory to a path occupied by a file.  */
                  case "InvalidModificationError":
                    return ApiError3.FileError(ErrorCode5.EPERM, p);
                  /* The user has attempted to look up a file or directory, but the Entry found is of the wrong type
                      [e.g. is a DirectoryEntry when the user requested a FileEntry].  */
                  case "TypeMismatchError":
                    return ApiError3.FileError(expectedDir ? ErrorCode5.ENOTDIR : ErrorCode5.EISDIR, p);
                  /* A path or URL supplied to the API was malformed.  */
                  case "EncodingError":
                  /* An operation depended on state cached in an interface object, but that state that has changed
                      since it was read from disk.  */
                  case "InvalidStateError":
                  /* The user attempted to write to a file or directory which could not be modified due to the state
                      of the underlying filesystem.  */
                  case "NoModificationAllowedError":
                  default:
                    return ApiError3.FileError(ErrorCode5.EINVAL, p);
                }
              }
              var HTML5FSFile = function(PreloadFile$$1) {
                function HTML5FSFile2(fs2, entry, path$$1, flag, stat, contents) {
                  PreloadFile$$1.call(this, fs2, path$$1, flag, stat, contents);
                  this._entry = entry;
                }
                if (PreloadFile$$1) HTML5FSFile2.__proto__ = PreloadFile$$1;
                HTML5FSFile2.prototype = Object.create(PreloadFile$$1 && PreloadFile$$1.prototype);
                HTML5FSFile2.prototype.constructor = HTML5FSFile2;
                HTML5FSFile2.prototype.sync = function sync(cb) {
                  var this$1 = this;
                  if (!this.isDirty()) {
                    return cb();
                  }
                  this._entry.createWriter(function(writer) {
                    var buffer$$1 = this$1.getBuffer();
                    var blob = new Blob([buffer2ArrayBuffer(buffer$$1)]);
                    var length = blob.size;
                    writer.onwriteend = function(err) {
                      writer.onwriteend = null;
                      writer.onerror = null;
                      writer.truncate(length);
                      this$1.resetDirty();
                      cb();
                    };
                    writer.onerror = function(err) {
                      cb(convertError$1(err, this$1.getPath(), false));
                    };
                    writer.write(blob);
                  });
                };
                HTML5FSFile2.prototype.close = function close(cb) {
                  this.sync(cb);
                };
                return HTML5FSFile2;
              }(PreloadFile2);
              var HTML5FS = function(BaseFileSystem$$1) {
                function HTML5FS2(size, type, deprecateMsg) {
                  if (size === void 0) size = 5;
                  if (type === void 0) type = global$1.PERSISTENT;
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  BaseFileSystem$$1.call(this);
                  this.size = 1024 * 1024 * size;
                  this.type = type;
                  deprecationMessage(deprecateMsg, HTML5FS2.Name, { size, type });
                }
                if (BaseFileSystem$$1) HTML5FS2.__proto__ = BaseFileSystem$$1;
                HTML5FS2.prototype = Object.create(BaseFileSystem$$1 && BaseFileSystem$$1.prototype);
                HTML5FS2.prototype.constructor = HTML5FS2;
                HTML5FS2.Create = function Create(opts, cb) {
                  var fs2 = new HTML5FS2(opts.size, opts.type, false);
                  fs2.allocate(function(e) {
                    return e ? cb(e) : cb(null, fs2);
                  }, false);
                };
                HTML5FS2.isAvailable = function isAvailable() {
                  return !!_getFS;
                };
                HTML5FS2.prototype.getName = function getName() {
                  return HTML5FS2.Name;
                };
                HTML5FS2.prototype.isReadOnly = function isReadOnly() {
                  return false;
                };
                HTML5FS2.prototype.supportsSymlinks = function supportsSymlinks() {
                  return false;
                };
                HTML5FS2.prototype.supportsProps = function supportsProps() {
                  return false;
                };
                HTML5FS2.prototype.supportsSynch = function supportsSynch() {
                  return false;
                };
                HTML5FS2.prototype.allocate = function allocate(cb, deprecateMsg) {
                  var this$1 = this;
                  if (cb === void 0) cb = function() {
                  };
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  if (deprecateMsg) {
                    console.warn("[HTML5FS] HTML5FS.allocate() is deprecated and will be removed in the next major release. Please use 'HTML5FS.Create({type: " + this.type + ", size: " + this.size + "}, cb)' to create and allocate HTML5FS instances.");
                  }
                  var success = function(fs2) {
                    this$1.fs = fs2;
                    cb();
                  };
                  var error = function(err) {
                    cb(convertError$1(err, "/", true));
                  };
                  if (this.type === global$1.PERSISTENT) {
                    _requestQuota(this.type, this.size, function(granted) {
                      _getFS(this$1.type, granted, success, error);
                    }, error);
                  } else {
                    _getFS(this.type, this.size, success, error);
                  }
                };
                HTML5FS2.prototype.empty = function empty(mainCb) {
                  this._readdir("/", function(err, entries) {
                    if (err) {
                      console.error("Failed to empty FS");
                      mainCb(err);
                    } else {
                      var finished = function(er) {
                        if (err) {
                          console.error("Failed to empty FS");
                          mainCb(err);
                        } else {
                          mainCb();
                        }
                      };
                      var deleteEntry = function(entry, cb) {
                        var succ = function() {
                          cb();
                        };
                        var error = function(err2) {
                          cb(convertError$1(err2, entry.fullPath, !entry.isDirectory));
                        };
                        if (isDirectoryEntry(entry)) {
                          entry.removeRecursively(succ, error);
                        } else {
                          entry.remove(succ, error);
                        }
                      };
                      eachLimit(entries, deleteEntry, finished);
                    }
                  });
                };
                HTML5FS2.prototype.rename = function rename(oldPath, newPath, cb) {
                  var this$1 = this;
                  var semaphore = 2;
                  var successCount = 0;
                  var root2 = this.fs.root;
                  var currentPath = oldPath;
                  var error = function(err) {
                    if (--semaphore <= 0) {
                      cb(convertError$1(err, currentPath, false));
                    }
                  };
                  var success = function(file) {
                    if (++successCount === 2) {
                      return cb(new ApiError3(ErrorCode5.EINVAL, "Something was identified as both a file and a directory. This should never happen."));
                    }
                    if (oldPath === newPath) {
                      return cb();
                    }
                    currentPath = path.dirname(newPath);
                    root2.getDirectory(currentPath, {}, function(parentDir) {
                      currentPath = path.basename(newPath);
                      file.moveTo(parentDir, currentPath, function(entry) {
                        cb();
                      }, function(err) {
                        if (file.isDirectory) {
                          currentPath = newPath;
                          this$1.unlink(newPath, function(e) {
                            if (e) {
                              error(err);
                            } else {
                              this$1.rename(oldPath, newPath, cb);
                            }
                          });
                        } else {
                          error(err);
                        }
                      });
                    }, error);
                  };
                  root2.getFile(oldPath, {}, success, error);
                  root2.getDirectory(oldPath, {}, success, error);
                };
                HTML5FS2.prototype.stat = function stat(path$$1, isLstat, cb) {
                  var this$1 = this;
                  var opts = {
                    create: false
                  };
                  var loadAsFile = function(entry) {
                    var fileFromEntry = function(file) {
                      var stat2 = new Stats2(FileType5.FILE, file.size);
                      cb(null, stat2);
                    };
                    entry.file(fileFromEntry, failedToLoad);
                  };
                  var loadAsDir = function(dir$$1) {
                    var size = 4096;
                    var stat2 = new Stats2(FileType5.DIRECTORY, size);
                    cb(null, stat2);
                  };
                  var failedToLoad = function(err) {
                    cb(convertError$1(
                      err,
                      path$$1,
                      false
                      /* Unknown / irrelevant */
                    ));
                  };
                  var failedToLoadAsFile = function() {
                    this$1.fs.root.getDirectory(path$$1, opts, loadAsDir, failedToLoad);
                  };
                  this.fs.root.getFile(path$$1, opts, loadAsFile, failedToLoadAsFile);
                };
                HTML5FS2.prototype.open = function open(p, flags, mode, cb) {
                  var this$1 = this;
                  var error = function(err) {
                    if (err.name === "InvalidModificationError" && flags.isExclusive()) {
                      cb(ApiError3.EEXIST(p));
                    } else {
                      cb(convertError$1(err, p, false));
                    }
                  };
                  this.fs.root.getFile(p, {
                    create: flags.pathNotExistsAction() === ActionType3.CREATE_FILE,
                    exclusive: flags.isExclusive()
                  }, function(entry) {
                    entry.file(function(file) {
                      var reader = new FileReader();
                      reader.onloadend = function(event) {
                        var bfsFile = this$1._makeFile(p, entry, flags, file, reader.result);
                        cb(null, bfsFile);
                      };
                      reader.onerror = function(ev) {
                        error(reader.error);
                      };
                      reader.readAsArrayBuffer(file);
                    }, error);
                  }, error);
                };
                HTML5FS2.prototype.unlink = function unlink(path$$1, cb) {
                  this._remove(path$$1, cb, true);
                };
                HTML5FS2.prototype.rmdir = function rmdir(path$$1, cb) {
                  var this$1 = this;
                  this.readdir(path$$1, function(e, files) {
                    if (e) {
                      cb(e);
                    } else if (files.length > 0) {
                      cb(ApiError3.ENOTEMPTY(path$$1));
                    } else {
                      this$1._remove(path$$1, cb, false);
                    }
                  });
                };
                HTML5FS2.prototype.mkdir = function mkdir(path$$1, mode, cb) {
                  var opts = {
                    create: true,
                    exclusive: true
                  };
                  var success = function(dir$$1) {
                    cb();
                  };
                  var error = function(err) {
                    cb(convertError$1(err, path$$1, true));
                  };
                  this.fs.root.getDirectory(path$$1, opts, success, error);
                };
                HTML5FS2.prototype.readdir = function readdir(path$$1, cb) {
                  this._readdir(path$$1, function(e, entries) {
                    if (entries) {
                      var rv = [];
                      for (var i2 = 0, list2 = entries; i2 < list2.length; i2 += 1) {
                        var entry = list2[i2];
                        rv.push(entry.name);
                      }
                      cb(null, rv);
                    } else {
                      return cb(e);
                    }
                  });
                };
                HTML5FS2.prototype._makeFile = function _makeFile(path$$1, entry, flag, stat, data) {
                  if (data === void 0) data = new ArrayBuffer(0);
                  var stats = new Stats2(FileType5.FILE, stat.size);
                  var buffer$$1 = arrayBuffer2Buffer(data);
                  return new HTML5FSFile(this, entry, path$$1, flag, stats, buffer$$1);
                };
                HTML5FS2.prototype._readdir = function _readdir(path$$1, cb) {
                  var error = function(err) {
                    cb(convertError$1(err, path$$1, true));
                  };
                  this.fs.root.getDirectory(path$$1, { create: false }, function(dirEntry) {
                    var reader = dirEntry.createReader();
                    var entries = [];
                    var readEntries = function() {
                      reader.readEntries(function(results) {
                        if (results.length) {
                          entries = entries.concat(_toArray(results));
                          readEntries();
                        } else {
                          cb(null, entries);
                        }
                      }, error);
                    };
                    readEntries();
                  }, error);
                };
                HTML5FS2.prototype._remove = function _remove(path$$1, cb, isFile) {
                  var success = function(entry) {
                    var succ = function() {
                      cb();
                    };
                    var err = function(err2) {
                      cb(convertError$1(err2, path$$1, !isFile));
                    };
                    entry.remove(succ, err);
                  };
                  var error = function(err) {
                    cb(convertError$1(err, path$$1, !isFile));
                  };
                  var opts = {
                    create: false
                  };
                  if (isFile) {
                    this.fs.root.getFile(path$$1, opts, success, error);
                  } else {
                    this.fs.root.getDirectory(path$$1, opts, success, error);
                  }
                };
                return HTML5FS2;
              }(BaseFileSystem3);
              HTML5FS.Name = "HTML5FS";
              HTML5FS.Options = {
                size: {
                  type: "number",
                  optional: true,
                  description: "Storage quota to request, in megabytes. Allocated value may be less. Defaults to 5."
                },
                type: {
                  type: "number",
                  optional: true,
                  description: "window.PERSISTENT or window.TEMPORARY. Defaults to PERSISTENT."
                }
              };
              var Inode = function Inode2(id, size, mode, atime, mtime, ctime) {
                this.id = id;
                this.size = size;
                this.mode = mode;
                this.atime = atime;
                this.mtime = mtime;
                this.ctime = ctime;
              };
              Inode.fromBuffer = function fromBuffer(buffer$$1) {
                if (buffer$$1 === void 0) {
                  throw new Error("NO");
                }
                return new Inode(buffer$$1.toString("ascii", 30), buffer$$1.readUInt32LE(0), buffer$$1.readUInt16LE(4), buffer$$1.readDoubleLE(6), buffer$$1.readDoubleLE(14), buffer$$1.readDoubleLE(22));
              };
              Inode.prototype.toStats = function toStats() {
                return new Stats2((this.mode & 61440) === FileType5.DIRECTORY ? FileType5.DIRECTORY : FileType5.FILE, this.size, this.mode, new Date(this.atime), new Date(this.mtime), new Date(this.ctime));
              };
              Inode.prototype.getSize = function getSize() {
                return 30 + this.id.length;
              };
              Inode.prototype.toBuffer = function toBuffer(buff) {
                if (buff === void 0) buff = Buffer2.alloc(this.getSize());
                buff.writeUInt32LE(this.size, 0);
                buff.writeUInt16LE(this.mode, 4);
                buff.writeDoubleLE(this.atime, 6);
                buff.writeDoubleLE(this.mtime, 14);
                buff.writeDoubleLE(this.ctime, 22);
                buff.write(this.id, 30, this.id.length, "ascii");
                return buff;
              };
              Inode.prototype.update = function update(stats) {
                var hasChanged = false;
                if (this.size !== stats.size) {
                  this.size = stats.size;
                  hasChanged = true;
                }
                if (this.mode !== stats.mode) {
                  this.mode = stats.mode;
                  hasChanged = true;
                }
                var atimeMs = stats.atime.getTime();
                if (this.atime !== atimeMs) {
                  this.atime = atimeMs;
                  hasChanged = true;
                }
                var mtimeMs = stats.mtime.getTime();
                if (this.mtime !== mtimeMs) {
                  this.mtime = mtimeMs;
                  hasChanged = true;
                }
                var ctimeMs = stats.ctime.getTime();
                if (this.ctime !== ctimeMs) {
                  this.ctime = ctimeMs;
                  hasChanged = true;
                }
                return hasChanged;
              };
              Inode.prototype.isFile = function isFile() {
                return (this.mode & 61440) === FileType5.FILE;
              };
              Inode.prototype.isDirectory = function isDirectory() {
                return (this.mode & 61440) === FileType5.DIRECTORY;
              };
              var ROOT_NODE_ID = "/";
              var emptyDirNode = null;
              function getEmptyDirNode() {
                if (emptyDirNode) {
                  return emptyDirNode;
                }
                return emptyDirNode = Buffer2.from("{}");
              }
              function GenerateRandomID() {
                return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(c) {
                  var r = Math.random() * 16 | 0;
                  var v = c === "x" ? r : r & 3 | 8;
                  return v.toString(16);
                });
              }
              function noError(e, cb) {
                if (e) {
                  cb(e);
                  return false;
                }
                return true;
              }
              function noErrorTx(e, tx, cb) {
                if (e) {
                  tx.abort(function() {
                    cb(e);
                  });
                  return false;
                }
                return true;
              }
              var SimpleSyncRWTransaction = function SimpleSyncRWTransaction2(store) {
                this.store = store;
                this.originalData = {};
                this.modifiedKeys = [];
              };
              SimpleSyncRWTransaction.prototype.get = function get(key) {
                var val = this.store.get(key);
                this.stashOldValue(key, val);
                return val;
              };
              SimpleSyncRWTransaction.prototype.put = function put(key, data, overwrite) {
                this.markModified(key);
                return this.store.put(key, data, overwrite);
              };
              SimpleSyncRWTransaction.prototype.del = function del(key) {
                this.markModified(key);
                this.store.del(key);
              };
              SimpleSyncRWTransaction.prototype.commit = function commit() {
              };
              SimpleSyncRWTransaction.prototype.abort = function abort() {
                var this$1 = this;
                for (var i2 = 0, list2 = this$1.modifiedKeys; i2 < list2.length; i2 += 1) {
                  var key = list2[i2];
                  var value = this$1.originalData[key];
                  if (!value) {
                    this$1.store.del(key);
                  } else {
                    this$1.store.put(key, value, true);
                  }
                }
              };
              SimpleSyncRWTransaction.prototype.stashOldValue = function stashOldValue(key, value) {
                if (!this.originalData.hasOwnProperty(key)) {
                  this.originalData[key] = value;
                }
              };
              SimpleSyncRWTransaction.prototype.markModified = function markModified(key) {
                if (this.modifiedKeys.indexOf(key) === -1) {
                  this.modifiedKeys.push(key);
                  if (!this.originalData.hasOwnProperty(key)) {
                    this.originalData[key] = this.store.get(key);
                  }
                }
              };
              var SyncKeyValueFile = function(PreloadFile$$1) {
                function SyncKeyValueFile2(_fs, _path, _flag, _stat, contents) {
                  PreloadFile$$1.call(this, _fs, _path, _flag, _stat, contents);
                }
                if (PreloadFile$$1) SyncKeyValueFile2.__proto__ = PreloadFile$$1;
                SyncKeyValueFile2.prototype = Object.create(PreloadFile$$1 && PreloadFile$$1.prototype);
                SyncKeyValueFile2.prototype.constructor = SyncKeyValueFile2;
                SyncKeyValueFile2.prototype.syncSync = function syncSync() {
                  if (this.isDirty()) {
                    this._fs._syncSync(this.getPath(), this.getBuffer(), this.getStats());
                    this.resetDirty();
                  }
                };
                SyncKeyValueFile2.prototype.closeSync = function closeSync() {
                  this.syncSync();
                };
                return SyncKeyValueFile2;
              }(PreloadFile2);
              var SyncKeyValueFileSystem = function(SynchronousFileSystem$$1) {
                function SyncKeyValueFileSystem2(options) {
                  SynchronousFileSystem$$1.call(this);
                  this.store = options.store;
                  this.makeRootDirectory();
                }
                if (SynchronousFileSystem$$1) SyncKeyValueFileSystem2.__proto__ = SynchronousFileSystem$$1;
                SyncKeyValueFileSystem2.prototype = Object.create(SynchronousFileSystem$$1 && SynchronousFileSystem$$1.prototype);
                SyncKeyValueFileSystem2.prototype.constructor = SyncKeyValueFileSystem2;
                SyncKeyValueFileSystem2.isAvailable = function isAvailable() {
                  return true;
                };
                SyncKeyValueFileSystem2.prototype.getName = function getName() {
                  return this.store.name();
                };
                SyncKeyValueFileSystem2.prototype.isReadOnly = function isReadOnly() {
                  return false;
                };
                SyncKeyValueFileSystem2.prototype.supportsSymlinks = function supportsSymlinks() {
                  return false;
                };
                SyncKeyValueFileSystem2.prototype.supportsProps = function supportsProps() {
                  return false;
                };
                SyncKeyValueFileSystem2.prototype.supportsSynch = function supportsSynch() {
                  return true;
                };
                SyncKeyValueFileSystem2.prototype.empty = function empty() {
                  this.store.clear();
                  this.makeRootDirectory();
                };
                SyncKeyValueFileSystem2.prototype.renameSync = function renameSync(oldPath, newPath) {
                  var tx = this.store.beginTransaction("readwrite"), oldParent = path.dirname(oldPath), oldName = path.basename(oldPath), newParent = path.dirname(newPath), newName = path.basename(newPath), oldDirNode = this.findINode(tx, oldParent), oldDirList = this.getDirListing(tx, oldParent, oldDirNode);
                  if (!oldDirList[oldName]) {
                    throw ApiError3.ENOENT(oldPath);
                  }
                  var nodeId = oldDirList[oldName];
                  delete oldDirList[oldName];
                  if ((newParent + "/").indexOf(oldPath + "/") === 0) {
                    throw new ApiError3(ErrorCode5.EBUSY, oldParent);
                  }
                  var newDirNode, newDirList;
                  if (newParent === oldParent) {
                    newDirNode = oldDirNode;
                    newDirList = oldDirList;
                  } else {
                    newDirNode = this.findINode(tx, newParent);
                    newDirList = this.getDirListing(tx, newParent, newDirNode);
                  }
                  if (newDirList[newName]) {
                    var newNameNode = this.getINode(tx, newPath, newDirList[newName]);
                    if (newNameNode.isFile()) {
                      try {
                        tx.del(newNameNode.id);
                        tx.del(newDirList[newName]);
                      } catch (e) {
                        tx.abort();
                        throw e;
                      }
                    } else {
                      throw ApiError3.EPERM(newPath);
                    }
                  }
                  newDirList[newName] = nodeId;
                  try {
                    tx.put(oldDirNode.id, Buffer2.from(JSON.stringify(oldDirList)), true);
                    tx.put(newDirNode.id, Buffer2.from(JSON.stringify(newDirList)), true);
                  } catch (e) {
                    tx.abort();
                    throw e;
                  }
                  tx.commit();
                };
                SyncKeyValueFileSystem2.prototype.statSync = function statSync(p, isLstat) {
                  return this.findINode(this.store.beginTransaction("readonly"), p).toStats();
                };
                SyncKeyValueFileSystem2.prototype.createFileSync = function createFileSync(p, flag, mode) {
                  var tx = this.store.beginTransaction("readwrite"), data = emptyBuffer(), newFile = this.commitNewFile(tx, p, FileType5.FILE, mode, data);
                  return new SyncKeyValueFile(this, p, flag, newFile.toStats(), data);
                };
                SyncKeyValueFileSystem2.prototype.openFileSync = function openFileSync(p, flag) {
                  var tx = this.store.beginTransaction("readonly"), node = this.findINode(tx, p), data = tx.get(node.id);
                  if (data === void 0) {
                    throw ApiError3.ENOENT(p);
                  }
                  return new SyncKeyValueFile(this, p, flag, node.toStats(), data);
                };
                SyncKeyValueFileSystem2.prototype.unlinkSync = function unlinkSync(p) {
                  this.removeEntry(p, false);
                };
                SyncKeyValueFileSystem2.prototype.rmdirSync = function rmdirSync(p) {
                  if (this.readdirSync(p).length > 0) {
                    throw ApiError3.ENOTEMPTY(p);
                  } else {
                    this.removeEntry(p, true);
                  }
                };
                SyncKeyValueFileSystem2.prototype.mkdirSync = function mkdirSync(p, mode) {
                  var tx = this.store.beginTransaction("readwrite"), data = Buffer2.from("{}");
                  this.commitNewFile(tx, p, FileType5.DIRECTORY, mode, data);
                };
                SyncKeyValueFileSystem2.prototype.readdirSync = function readdirSync(p) {
                  var tx = this.store.beginTransaction("readonly");
                  return Object.keys(this.getDirListing(tx, p, this.findINode(tx, p)));
                };
                SyncKeyValueFileSystem2.prototype._syncSync = function _syncSync(p, data, stats) {
                  var tx = this.store.beginTransaction("readwrite"), fileInodeId = this._findINode(tx, path.dirname(p), path.basename(p)), fileInode = this.getINode(tx, p, fileInodeId), inodeChanged = fileInode.update(stats);
                  try {
                    tx.put(fileInode.id, data, true);
                    if (inodeChanged) {
                      tx.put(fileInodeId, fileInode.toBuffer(), true);
                    }
                  } catch (e) {
                    tx.abort();
                    throw e;
                  }
                  tx.commit();
                };
                SyncKeyValueFileSystem2.prototype.makeRootDirectory = function makeRootDirectory() {
                  var tx = this.store.beginTransaction("readwrite");
                  if (tx.get(ROOT_NODE_ID) === void 0) {
                    var currTime = (/* @__PURE__ */ new Date()).getTime(), dirInode = new Inode(GenerateRandomID(), 4096, 511 | FileType5.DIRECTORY, currTime, currTime, currTime);
                    tx.put(dirInode.id, getEmptyDirNode(), false);
                    tx.put(ROOT_NODE_ID, dirInode.toBuffer(), false);
                    tx.commit();
                  }
                };
                SyncKeyValueFileSystem2.prototype._findINode = function _findINode(tx, parent, filename) {
                  var this$1 = this;
                  var readDirectory = function(inode) {
                    var dirList = this$1.getDirListing(tx, parent, inode);
                    if (dirList[filename]) {
                      return dirList[filename];
                    } else {
                      throw ApiError3.ENOENT(path.resolve(parent, filename));
                    }
                  };
                  if (parent === "/") {
                    if (filename === "") {
                      return ROOT_NODE_ID;
                    } else {
                      return readDirectory(this.getINode(tx, parent, ROOT_NODE_ID));
                    }
                  } else {
                    return readDirectory(this.getINode(tx, parent + path.sep + filename, this._findINode(tx, path.dirname(parent), path.basename(parent))));
                  }
                };
                SyncKeyValueFileSystem2.prototype.findINode = function findINode(tx, p) {
                  return this.getINode(tx, p, this._findINode(tx, path.dirname(p), path.basename(p)));
                };
                SyncKeyValueFileSystem2.prototype.getINode = function getINode(tx, p, id) {
                  var inode = tx.get(id);
                  if (inode === void 0) {
                    throw ApiError3.ENOENT(p);
                  }
                  return Inode.fromBuffer(inode);
                };
                SyncKeyValueFileSystem2.prototype.getDirListing = function getDirListing(tx, p, inode) {
                  if (!inode.isDirectory()) {
                    throw ApiError3.ENOTDIR(p);
                  }
                  var data = tx.get(inode.id);
                  if (data === void 0) {
                    throw ApiError3.ENOENT(p);
                  }
                  return JSON.parse(data.toString());
                };
                SyncKeyValueFileSystem2.prototype.addNewNode = function addNewNode(tx, data) {
                  var retries = 0;
                  var currId;
                  while (retries < 5) {
                    try {
                      currId = GenerateRandomID();
                      tx.put(currId, data, false);
                      return currId;
                    } catch (e) {
                    }
                  }
                  throw new ApiError3(ErrorCode5.EIO, "Unable to commit data to key-value store.");
                };
                SyncKeyValueFileSystem2.prototype.commitNewFile = function commitNewFile(tx, p, type, mode, data) {
                  var parentDir = path.dirname(p), fname = path.basename(p), parentNode = this.findINode(tx, parentDir), dirListing = this.getDirListing(tx, parentDir, parentNode), currTime = (/* @__PURE__ */ new Date()).getTime();
                  if (p === "/") {
                    throw ApiError3.EEXIST(p);
                  }
                  if (dirListing[fname]) {
                    throw ApiError3.EEXIST(p);
                  }
                  var fileNode;
                  try {
                    var dataId = this.addNewNode(tx, data);
                    fileNode = new Inode(dataId, data.length, mode | type, currTime, currTime, currTime);
                    var fileNodeId = this.addNewNode(tx, fileNode.toBuffer());
                    dirListing[fname] = fileNodeId;
                    tx.put(parentNode.id, Buffer2.from(JSON.stringify(dirListing)), true);
                  } catch (e) {
                    tx.abort();
                    throw e;
                  }
                  tx.commit();
                  return fileNode;
                };
                SyncKeyValueFileSystem2.prototype.removeEntry = function removeEntry(p, isDir) {
                  var tx = this.store.beginTransaction("readwrite"), parent = path.dirname(p), parentNode = this.findINode(tx, parent), parentListing = this.getDirListing(tx, parent, parentNode), fileName = path.basename(p);
                  if (!parentListing[fileName]) {
                    throw ApiError3.ENOENT(p);
                  }
                  var fileNodeId = parentListing[fileName];
                  delete parentListing[fileName];
                  var fileNode = this.getINode(tx, p, fileNodeId);
                  if (!isDir && fileNode.isDirectory()) {
                    throw ApiError3.EISDIR(p);
                  } else if (isDir && !fileNode.isDirectory()) {
                    throw ApiError3.ENOTDIR(p);
                  }
                  try {
                    tx.del(fileNode.id);
                    tx.del(fileNodeId);
                    tx.put(parentNode.id, Buffer2.from(JSON.stringify(parentListing)), true);
                  } catch (e) {
                    tx.abort();
                    throw e;
                  }
                  tx.commit();
                };
                return SyncKeyValueFileSystem2;
              }(SynchronousFileSystem);
              var AsyncKeyValueFile = function(PreloadFile$$1) {
                function AsyncKeyValueFile2(_fs, _path, _flag, _stat, contents) {
                  PreloadFile$$1.call(this, _fs, _path, _flag, _stat, contents);
                }
                if (PreloadFile$$1) AsyncKeyValueFile2.__proto__ = PreloadFile$$1;
                AsyncKeyValueFile2.prototype = Object.create(PreloadFile$$1 && PreloadFile$$1.prototype);
                AsyncKeyValueFile2.prototype.constructor = AsyncKeyValueFile2;
                AsyncKeyValueFile2.prototype.sync = function sync(cb) {
                  var this$1 = this;
                  if (this.isDirty()) {
                    this._fs._sync(this.getPath(), this.getBuffer(), this.getStats(), function(e) {
                      if (!e) {
                        this$1.resetDirty();
                      }
                      cb(e);
                    });
                  } else {
                    cb();
                  }
                };
                AsyncKeyValueFile2.prototype.close = function close(cb) {
                  this.sync(cb);
                };
                return AsyncKeyValueFile2;
              }(PreloadFile2);
              var AsyncKeyValueFileSystem = function(BaseFileSystem$$1) {
                function AsyncKeyValueFileSystem2() {
                  BaseFileSystem$$1.apply(this, arguments);
                }
                if (BaseFileSystem$$1) AsyncKeyValueFileSystem2.__proto__ = BaseFileSystem$$1;
                AsyncKeyValueFileSystem2.prototype = Object.create(BaseFileSystem$$1 && BaseFileSystem$$1.prototype);
                AsyncKeyValueFileSystem2.prototype.constructor = AsyncKeyValueFileSystem2;
                AsyncKeyValueFileSystem2.isAvailable = function isAvailable() {
                  return true;
                };
                AsyncKeyValueFileSystem2.prototype.init = function init(store, cb) {
                  this.store = store;
                  this.makeRootDirectory(cb);
                };
                AsyncKeyValueFileSystem2.prototype.getName = function getName() {
                  return this.store.name();
                };
                AsyncKeyValueFileSystem2.prototype.isReadOnly = function isReadOnly() {
                  return false;
                };
                AsyncKeyValueFileSystem2.prototype.supportsSymlinks = function supportsSymlinks() {
                  return false;
                };
                AsyncKeyValueFileSystem2.prototype.supportsProps = function supportsProps() {
                  return false;
                };
                AsyncKeyValueFileSystem2.prototype.supportsSynch = function supportsSynch() {
                  return false;
                };
                AsyncKeyValueFileSystem2.prototype.empty = function empty(cb) {
                  var this$1 = this;
                  this.store.clear(function(e) {
                    if (noError(e, cb)) {
                      this$1.makeRootDirectory(cb);
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype.rename = function rename(oldPath, newPath, cb) {
                  var this$1 = this;
                  var tx = this.store.beginTransaction("readwrite");
                  var oldParent = path.dirname(oldPath), oldName = path.basename(oldPath);
                  var newParent = path.dirname(newPath), newName = path.basename(newPath);
                  var inodes = {};
                  var lists = {};
                  var errorOccurred = false;
                  if ((newParent + "/").indexOf(oldPath + "/") === 0) {
                    return cb(new ApiError3(ErrorCode5.EBUSY, oldParent));
                  }
                  var theOleSwitcharoo = function() {
                    if (errorOccurred || !lists.hasOwnProperty(oldParent) || !lists.hasOwnProperty(newParent)) {
                      return;
                    }
                    var oldParentList = lists[oldParent], oldParentINode = inodes[oldParent], newParentList = lists[newParent], newParentINode = inodes[newParent];
                    if (!oldParentList[oldName]) {
                      cb(ApiError3.ENOENT(oldPath));
                    } else {
                      var fileId = oldParentList[oldName];
                      delete oldParentList[oldName];
                      var completeRename = function() {
                        newParentList[newName] = fileId;
                        tx.put(oldParentINode.id, Buffer2.from(JSON.stringify(oldParentList)), true, function(e) {
                          if (noErrorTx(e, tx, cb)) {
                            if (oldParent === newParent) {
                              tx.commit(cb);
                            } else {
                              tx.put(newParentINode.id, Buffer2.from(JSON.stringify(newParentList)), true, function(e2) {
                                if (noErrorTx(e2, tx, cb)) {
                                  tx.commit(cb);
                                }
                              });
                            }
                          }
                        });
                      };
                      if (newParentList[newName]) {
                        this$1.getINode(tx, newPath, newParentList[newName], function(e, inode) {
                          if (noErrorTx(e, tx, cb)) {
                            if (inode.isFile()) {
                              tx.del(inode.id, function(e2) {
                                if (noErrorTx(e2, tx, cb)) {
                                  tx.del(newParentList[newName], function(e3) {
                                    if (noErrorTx(e3, tx, cb)) {
                                      completeRename();
                                    }
                                  });
                                }
                              });
                            } else {
                              tx.abort(function(e2) {
                                cb(ApiError3.EPERM(newPath));
                              });
                            }
                          }
                        });
                      } else {
                        completeRename();
                      }
                    }
                  };
                  var processInodeAndListings = function(p) {
                    this$1.findINodeAndDirListing(tx, p, function(e, node, dirList) {
                      if (e) {
                        if (!errorOccurred) {
                          errorOccurred = true;
                          tx.abort(function() {
                            cb(e);
                          });
                        }
                      } else {
                        inodes[p] = node;
                        lists[p] = dirList;
                        theOleSwitcharoo();
                      }
                    });
                  };
                  processInodeAndListings(oldParent);
                  if (oldParent !== newParent) {
                    processInodeAndListings(newParent);
                  }
                };
                AsyncKeyValueFileSystem2.prototype.stat = function stat(p, isLstat, cb) {
                  var tx = this.store.beginTransaction("readonly");
                  this.findINode(tx, p, function(e, inode) {
                    if (noError(e, cb)) {
                      cb(null, inode.toStats());
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype.createFile = function createFile(p, flag, mode, cb) {
                  var this$1 = this;
                  var tx = this.store.beginTransaction("readwrite"), data = emptyBuffer();
                  this.commitNewFile(tx, p, FileType5.FILE, mode, data, function(e, newFile) {
                    if (noError(e, cb)) {
                      cb(null, new AsyncKeyValueFile(this$1, p, flag, newFile.toStats(), data));
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype.openFile = function openFile(p, flag, cb) {
                  var this$1 = this;
                  var tx = this.store.beginTransaction("readonly");
                  this.findINode(tx, p, function(e, inode) {
                    if (noError(e, cb)) {
                      tx.get(inode.id, function(e2, data) {
                        if (noError(e2, cb)) {
                          if (data === void 0) {
                            cb(ApiError3.ENOENT(p));
                          } else {
                            cb(null, new AsyncKeyValueFile(this$1, p, flag, inode.toStats(), data));
                          }
                        }
                      });
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype.unlink = function unlink(p, cb) {
                  this.removeEntry(p, false, cb);
                };
                AsyncKeyValueFileSystem2.prototype.rmdir = function rmdir(p, cb) {
                  var this$1 = this;
                  this.readdir(p, function(err, files) {
                    if (err) {
                      cb(err);
                    } else if (files.length > 0) {
                      cb(ApiError3.ENOTEMPTY(p));
                    } else {
                      this$1.removeEntry(p, true, cb);
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype.mkdir = function mkdir(p, mode, cb) {
                  var tx = this.store.beginTransaction("readwrite"), data = Buffer2.from("{}");
                  this.commitNewFile(tx, p, FileType5.DIRECTORY, mode, data, cb);
                };
                AsyncKeyValueFileSystem2.prototype.readdir = function readdir(p, cb) {
                  var this$1 = this;
                  var tx = this.store.beginTransaction("readonly");
                  this.findINode(tx, p, function(e, inode) {
                    if (noError(e, cb)) {
                      this$1.getDirListing(tx, p, inode, function(e2, dirListing) {
                        if (noError(e2, cb)) {
                          cb(null, Object.keys(dirListing));
                        }
                      });
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype._sync = function _sync(p, data, stats, cb) {
                  var this$1 = this;
                  var tx = this.store.beginTransaction("readwrite");
                  this._findINode(tx, path.dirname(p), path.basename(p), function(e, fileInodeId) {
                    if (noErrorTx(e, tx, cb)) {
                      this$1.getINode(tx, p, fileInodeId, function(e2, fileInode) {
                        if (noErrorTx(e2, tx, cb)) {
                          var inodeChanged = fileInode.update(stats);
                          tx.put(fileInode.id, data, true, function(e3) {
                            if (noErrorTx(e3, tx, cb)) {
                              if (inodeChanged) {
                                tx.put(fileInodeId, fileInode.toBuffer(), true, function(e4) {
                                  if (noErrorTx(e4, tx, cb)) {
                                    tx.commit(cb);
                                  }
                                });
                              } else {
                                tx.commit(cb);
                              }
                            }
                          });
                        }
                      });
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype.makeRootDirectory = function makeRootDirectory(cb) {
                  var tx = this.store.beginTransaction("readwrite");
                  tx.get(ROOT_NODE_ID, function(e, data) {
                    if (e || data === void 0) {
                      var currTime = (/* @__PURE__ */ new Date()).getTime(), dirInode = new Inode(GenerateRandomID(), 4096, 511 | FileType5.DIRECTORY, currTime, currTime, currTime);
                      tx.put(dirInode.id, getEmptyDirNode(), false, function(e2) {
                        if (noErrorTx(e2, tx, cb)) {
                          tx.put(ROOT_NODE_ID, dirInode.toBuffer(), false, function(e3) {
                            if (e3) {
                              tx.abort(function() {
                                cb(e3);
                              });
                            } else {
                              tx.commit(cb);
                            }
                          });
                        }
                      });
                    } else {
                      tx.commit(cb);
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype._findINode = function _findINode(tx, parent, filename, cb) {
                  var this$1 = this;
                  var handleDirectoryListings = function(e, inode, dirList) {
                    if (e) {
                      cb(e);
                    } else if (dirList[filename]) {
                      cb(null, dirList[filename]);
                    } else {
                      cb(ApiError3.ENOENT(path.resolve(parent, filename)));
                    }
                  };
                  if (parent === "/") {
                    if (filename === "") {
                      cb(null, ROOT_NODE_ID);
                    } else {
                      this.getINode(tx, parent, ROOT_NODE_ID, function(e, inode) {
                        if (noError(e, cb)) {
                          this$1.getDirListing(tx, parent, inode, function(e2, dirList) {
                            handleDirectoryListings(e2, inode, dirList);
                          });
                        }
                      });
                    }
                  } else {
                    this.findINodeAndDirListing(tx, parent, handleDirectoryListings);
                  }
                };
                AsyncKeyValueFileSystem2.prototype.findINode = function findINode(tx, p, cb) {
                  var this$1 = this;
                  this._findINode(tx, path.dirname(p), path.basename(p), function(e, id) {
                    if (noError(e, cb)) {
                      this$1.getINode(tx, p, id, cb);
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype.getINode = function getINode(tx, p, id, cb) {
                  tx.get(id, function(e, data) {
                    if (noError(e, cb)) {
                      if (data === void 0) {
                        cb(ApiError3.ENOENT(p));
                      } else {
                        cb(null, Inode.fromBuffer(data));
                      }
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype.getDirListing = function getDirListing(tx, p, inode, cb) {
                  if (!inode.isDirectory()) {
                    cb(ApiError3.ENOTDIR(p));
                  } else {
                    tx.get(inode.id, function(e, data) {
                      if (noError(e, cb)) {
                        try {
                          cb(null, JSON.parse(data.toString()));
                        } catch (e2) {
                          cb(ApiError3.ENOENT(p));
                        }
                      }
                    });
                  }
                };
                AsyncKeyValueFileSystem2.prototype.findINodeAndDirListing = function findINodeAndDirListing(tx, p, cb) {
                  var this$1 = this;
                  this.findINode(tx, p, function(e, inode) {
                    if (noError(e, cb)) {
                      this$1.getDirListing(tx, p, inode, function(e2, listing) {
                        if (noError(e2, cb)) {
                          cb(null, inode, listing);
                        }
                      });
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype.addNewNode = function addNewNode(tx, data, cb) {
                  var retries = 0, currId;
                  var reroll = function() {
                    if (++retries === 5) {
                      cb(new ApiError3(ErrorCode5.EIO, "Unable to commit data to key-value store."));
                    } else {
                      currId = GenerateRandomID();
                      tx.put(currId, data, false, function(e, committed) {
                        if (e || !committed) {
                          reroll();
                        } else {
                          cb(null, currId);
                        }
                      });
                    }
                  };
                  reroll();
                };
                AsyncKeyValueFileSystem2.prototype.commitNewFile = function commitNewFile(tx, p, type, mode, data, cb) {
                  var this$1 = this;
                  var parentDir = path.dirname(p), fname = path.basename(p), currTime = (/* @__PURE__ */ new Date()).getTime();
                  if (p === "/") {
                    return cb(ApiError3.EEXIST(p));
                  }
                  this.findINodeAndDirListing(tx, parentDir, function(e, parentNode, dirListing) {
                    if (noErrorTx(e, tx, cb)) {
                      if (dirListing[fname]) {
                        tx.abort(function() {
                          cb(ApiError3.EEXIST(p));
                        });
                      } else {
                        this$1.addNewNode(tx, data, function(e2, dataId) {
                          if (noErrorTx(e2, tx, cb)) {
                            var fileInode = new Inode(dataId, data.length, mode | type, currTime, currTime, currTime);
                            this$1.addNewNode(tx, fileInode.toBuffer(), function(e3, fileInodeId) {
                              if (noErrorTx(e3, tx, cb)) {
                                dirListing[fname] = fileInodeId;
                                tx.put(parentNode.id, Buffer2.from(JSON.stringify(dirListing)), true, function(e4) {
                                  if (noErrorTx(e4, tx, cb)) {
                                    tx.commit(function(e5) {
                                      if (noErrorTx(e5, tx, cb)) {
                                        cb(null, fileInode);
                                      }
                                    });
                                  }
                                });
                              }
                            });
                          }
                        });
                      }
                    }
                  });
                };
                AsyncKeyValueFileSystem2.prototype.removeEntry = function removeEntry(p, isDir, cb) {
                  var this$1 = this;
                  var tx = this.store.beginTransaction("readwrite"), parent = path.dirname(p), fileName = path.basename(p);
                  this.findINodeAndDirListing(tx, parent, function(e, parentNode, parentListing) {
                    if (noErrorTx(e, tx, cb)) {
                      if (!parentListing[fileName]) {
                        tx.abort(function() {
                          cb(ApiError3.ENOENT(p));
                        });
                      } else {
                        var fileNodeId = parentListing[fileName];
                        delete parentListing[fileName];
                        this$1.getINode(tx, p, fileNodeId, function(e2, fileNode) {
                          if (noErrorTx(e2, tx, cb)) {
                            if (!isDir && fileNode.isDirectory()) {
                              tx.abort(function() {
                                cb(ApiError3.EISDIR(p));
                              });
                            } else if (isDir && !fileNode.isDirectory()) {
                              tx.abort(function() {
                                cb(ApiError3.ENOTDIR(p));
                              });
                            } else {
                              tx.del(fileNode.id, function(e3) {
                                if (noErrorTx(e3, tx, cb)) {
                                  tx.del(fileNodeId, function(e4) {
                                    if (noErrorTx(e4, tx, cb)) {
                                      tx.put(parentNode.id, Buffer2.from(JSON.stringify(parentListing)), true, function(e5) {
                                        if (noErrorTx(e5, tx, cb)) {
                                          tx.commit(cb);
                                        }
                                      });
                                    }
                                  });
                                }
                              });
                            }
                          }
                        });
                      }
                    }
                  });
                };
                return AsyncKeyValueFileSystem2;
              }(BaseFileSystem3);
              var InMemoryStore = function InMemoryStore2() {
                this.store = {};
              };
              InMemoryStore.prototype.name = function name() {
                return InMemoryFileSystem.Name;
              };
              InMemoryStore.prototype.clear = function clear() {
                this.store = {};
              };
              InMemoryStore.prototype.beginTransaction = function beginTransaction(type) {
                return new SimpleSyncRWTransaction(this);
              };
              InMemoryStore.prototype.get = function get(key) {
                return this.store[key];
              };
              InMemoryStore.prototype.put = function put(key, data, overwrite) {
                if (!overwrite && this.store.hasOwnProperty(key)) {
                  return false;
                }
                this.store[key] = data;
                return true;
              };
              InMemoryStore.prototype.del = function del(key) {
                delete this.store[key];
              };
              var InMemoryFileSystem = function(SyncKeyValueFileSystem$$1) {
                function InMemoryFileSystem2() {
                  SyncKeyValueFileSystem$$1.call(this, { store: new InMemoryStore() });
                }
                if (SyncKeyValueFileSystem$$1) InMemoryFileSystem2.__proto__ = SyncKeyValueFileSystem$$1;
                InMemoryFileSystem2.prototype = Object.create(SyncKeyValueFileSystem$$1 && SyncKeyValueFileSystem$$1.prototype);
                InMemoryFileSystem2.prototype.constructor = InMemoryFileSystem2;
                InMemoryFileSystem2.Create = function Create(options, cb) {
                  cb(null, new InMemoryFileSystem2());
                };
                return InMemoryFileSystem2;
              }(SyncKeyValueFileSystem);
              InMemoryFileSystem.Name = "InMemory";
              InMemoryFileSystem.Options = {};
              var indexedDB = global$1.indexedDB || global$1.mozIndexedDB || global$1.webkitIndexedDB || global$1.msIndexedDB;
              function convertError$2(e, message) {
                if (message === void 0) message = e.toString();
                switch (e.name) {
                  case "NotFoundError":
                    return new ApiError3(ErrorCode5.ENOENT, message);
                  case "QuotaExceededError":
                    return new ApiError3(ErrorCode5.ENOSPC, message);
                  default:
                    return new ApiError3(ErrorCode5.EIO, message);
                }
              }
              function onErrorHandler(cb, code, message) {
                if (code === void 0) code = ErrorCode5.EIO;
                if (message === void 0) message = null;
                return function(e) {
                  e.preventDefault();
                  cb(new ApiError3(code, message !== null ? message : void 0));
                };
              }
              var IndexedDBROTransaction = function IndexedDBROTransaction2(tx, store) {
                this.tx = tx;
                this.store = store;
              };
              IndexedDBROTransaction.prototype.get = function get(key, cb) {
                try {
                  var r = this.store.get(key);
                  r.onerror = onErrorHandler(cb);
                  r.onsuccess = function(event) {
                    var result = event.target.result;
                    if (result === void 0) {
                      cb(null, result);
                    } else {
                      cb(null, arrayBuffer2Buffer(result));
                    }
                  };
                } catch (e) {
                  cb(convertError$2(e));
                }
              };
              var IndexedDBRWTransaction = function(IndexedDBROTransaction2) {
                function IndexedDBRWTransaction2(tx, store) {
                  IndexedDBROTransaction2.call(this, tx, store);
                }
                if (IndexedDBROTransaction2) IndexedDBRWTransaction2.__proto__ = IndexedDBROTransaction2;
                IndexedDBRWTransaction2.prototype = Object.create(IndexedDBROTransaction2 && IndexedDBROTransaction2.prototype);
                IndexedDBRWTransaction2.prototype.constructor = IndexedDBRWTransaction2;
                IndexedDBRWTransaction2.prototype.put = function put(key, data, overwrite, cb) {
                  try {
                    var arraybuffer = buffer2ArrayBuffer(data);
                    var r;
                    if (overwrite) {
                      r = this.store.put(arraybuffer, key);
                    } else {
                      r = this.store.add(arraybuffer, key);
                    }
                    r.onerror = onErrorHandler(cb);
                    r.onsuccess = function(event) {
                      cb(null, true);
                    };
                  } catch (e) {
                    cb(convertError$2(e));
                  }
                };
                IndexedDBRWTransaction2.prototype.del = function del(key, cb) {
                  try {
                    var r = this.store["delete"](key);
                    r.onerror = onErrorHandler(cb);
                    r.onsuccess = function(event) {
                      cb();
                    };
                  } catch (e) {
                    cb(convertError$2(e));
                  }
                };
                IndexedDBRWTransaction2.prototype.commit = function commit(cb) {
                  setTimeout(cb, 0);
                };
                IndexedDBRWTransaction2.prototype.abort = function abort(cb) {
                  var _e = null;
                  try {
                    this.tx.abort();
                  } catch (e) {
                    _e = convertError$2(e);
                  } finally {
                    cb(_e);
                  }
                };
                return IndexedDBRWTransaction2;
              }(IndexedDBROTransaction);
              var IndexedDBStore = function IndexedDBStore2(cb, storeName) {
                var this$1 = this;
                if (storeName === void 0) storeName = "browserfs";
                this.storeName = storeName;
                var openReq = indexedDB.open(this.storeName, 1);
                openReq.onupgradeneeded = function(event) {
                  var db = event.target.result;
                  if (db.objectStoreNames.contains(this$1.storeName)) {
                    db.deleteObjectStore(this$1.storeName);
                  }
                  db.createObjectStore(this$1.storeName);
                };
                openReq.onsuccess = function(event) {
                  this$1.db = event.target.result;
                  cb(null, this$1);
                };
                openReq.onerror = onErrorHandler(cb, ErrorCode5.EACCES);
              };
              IndexedDBStore.prototype.name = function name() {
                return IndexedDBFileSystem.Name + " - " + this.storeName;
              };
              IndexedDBStore.prototype.clear = function clear(cb) {
                try {
                  var tx = this.db.transaction(this.storeName, "readwrite"), objectStore = tx.objectStore(this.storeName), r = objectStore.clear();
                  r.onsuccess = function(event) {
                    setTimeout(cb, 0);
                  };
                  r.onerror = onErrorHandler(cb);
                } catch (e) {
                  cb(convertError$2(e));
                }
              };
              IndexedDBStore.prototype.beginTransaction = function beginTransaction(type) {
                if (type === void 0) type = "readonly";
                var tx = this.db.transaction(this.storeName, type), objectStore = tx.objectStore(this.storeName);
                if (type === "readwrite") {
                  return new IndexedDBRWTransaction(tx, objectStore);
                } else if (type === "readonly") {
                  return new IndexedDBROTransaction(tx, objectStore);
                } else {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid transaction type.");
                }
              };
              var IndexedDBFileSystem = function(AsyncKeyValueFileSystem$$1) {
                function IndexedDBFileSystem2(cb, storeName, deprecateMsg) {
                  var this$1 = this;
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  AsyncKeyValueFileSystem$$1.call(this);
                  this.store = new IndexedDBStore(function(e) {
                    if (e) {
                      cb(e);
                    } else {
                      this$1.init(this$1.store, function(e2) {
                        cb(e2, this$1);
                      });
                    }
                  }, storeName);
                  deprecationMessage(deprecateMsg, IndexedDBFileSystem2.Name, { storeName });
                }
                if (AsyncKeyValueFileSystem$$1) IndexedDBFileSystem2.__proto__ = AsyncKeyValueFileSystem$$1;
                IndexedDBFileSystem2.prototype = Object.create(AsyncKeyValueFileSystem$$1 && AsyncKeyValueFileSystem$$1.prototype);
                IndexedDBFileSystem2.prototype.constructor = IndexedDBFileSystem2;
                IndexedDBFileSystem2.Create = function Create(opts, cb) {
                  new IndexedDBFileSystem2(cb, opts.storeName, false);
                };
                IndexedDBFileSystem2.isAvailable = function isAvailable() {
                  try {
                    return typeof indexedDB !== "undefined" && null !== indexedDB.open("__browserfs_test__");
                  } catch (e) {
                    return false;
                  }
                };
                return IndexedDBFileSystem2;
              }(AsyncKeyValueFileSystem);
              IndexedDBFileSystem.Name = "IndexedDB";
              IndexedDBFileSystem.Options = {
                storeName: {
                  type: "string",
                  optional: true,
                  description: "The name of this file system. You can have multiple IndexedDB file systems operating at once, but each must have a different name."
                }
              };
              var supportsBinaryString = false;
              var binaryEncoding;
              try {
                global$1.localStorage.setItem("__test__", String.fromCharCode(55296));
                supportsBinaryString = global$1.localStorage.getItem("__test__") === String.fromCharCode(55296);
              } catch (e) {
                supportsBinaryString = false;
              }
              binaryEncoding = supportsBinaryString ? "binary_string" : "binary_string_ie";
              if (!Buffer2.isEncoding(binaryEncoding)) {
                binaryEncoding = "base64";
              }
              var LocalStorageStore = function LocalStorageStore2() {
              };
              LocalStorageStore.prototype.name = function name() {
                return LocalStorageFileSystem.Name;
              };
              LocalStorageStore.prototype.clear = function clear() {
                global$1.localStorage.clear();
              };
              LocalStorageStore.prototype.beginTransaction = function beginTransaction(type) {
                return new SimpleSyncRWTransaction(this);
              };
              LocalStorageStore.prototype.get = function get(key) {
                try {
                  var data = global$1.localStorage.getItem(key);
                  if (data !== null) {
                    return Buffer2.from(data, binaryEncoding);
                  }
                } catch (e) {
                }
                return void 0;
              };
              LocalStorageStore.prototype.put = function put(key, data, overwrite) {
                try {
                  if (!overwrite && global$1.localStorage.getItem(key) !== null) {
                    return false;
                  }
                  global$1.localStorage.setItem(key, data.toString(binaryEncoding));
                  return true;
                } catch (e) {
                  throw new ApiError3(ErrorCode5.ENOSPC, "LocalStorage is full.");
                }
              };
              LocalStorageStore.prototype.del = function del(key) {
                try {
                  global$1.localStorage.removeItem(key);
                } catch (e) {
                  throw new ApiError3(ErrorCode5.EIO, "Unable to delete key " + key + ": " + e);
                }
              };
              var LocalStorageFileSystem = function(SyncKeyValueFileSystem$$1) {
                function LocalStorageFileSystem2() {
                  SyncKeyValueFileSystem$$1.call(this, { store: new LocalStorageStore() });
                }
                if (SyncKeyValueFileSystem$$1) LocalStorageFileSystem2.__proto__ = SyncKeyValueFileSystem$$1;
                LocalStorageFileSystem2.prototype = Object.create(SyncKeyValueFileSystem$$1 && SyncKeyValueFileSystem$$1.prototype);
                LocalStorageFileSystem2.prototype.constructor = LocalStorageFileSystem2;
                LocalStorageFileSystem2.Create = function Create(options, cb) {
                  cb(null, new LocalStorageFileSystem2());
                };
                LocalStorageFileSystem2.isAvailable = function isAvailable() {
                  return typeof global$1.localStorage !== "undefined";
                };
                return LocalStorageFileSystem2;
              }(SyncKeyValueFileSystem);
              LocalStorageFileSystem.Name = "LocalStorage";
              LocalStorageFileSystem.Options = {};
              var MountableFileSystem = function(BaseFileSystem$$1) {
                function MountableFileSystem2() {
                  BaseFileSystem$$1.call(this);
                  this.mountList = [];
                  this.mntMap = {};
                  this.rootFs = new InMemoryFileSystem();
                }
                if (BaseFileSystem$$1) MountableFileSystem2.__proto__ = BaseFileSystem$$1;
                MountableFileSystem2.prototype = Object.create(BaseFileSystem$$1 && BaseFileSystem$$1.prototype);
                MountableFileSystem2.prototype.constructor = MountableFileSystem2;
                MountableFileSystem2.Create = function Create(opts, cb) {
                  var fs2 = new MountableFileSystem2();
                  Object.keys(opts).forEach(function(mountPoint) {
                    fs2.mount(mountPoint, opts[mountPoint]);
                  });
                  cb(null, fs2);
                };
                MountableFileSystem2.isAvailable = function isAvailable() {
                  return true;
                };
                MountableFileSystem2.prototype.mount = function mount(mountPoint, fs2) {
                  if (mountPoint[0] !== "/") {
                    mountPoint = "/" + mountPoint;
                  }
                  mountPoint = path.resolve(mountPoint);
                  if (this.mntMap[mountPoint]) {
                    throw new ApiError3(ErrorCode5.EINVAL, "Mount point " + mountPoint + " is already taken.");
                  }
                  mkdirpSync(mountPoint, 511, this.rootFs);
                  this.mntMap[mountPoint] = fs2;
                  this.mountList.push(mountPoint);
                  this.mountList = this.mountList.sort(function(a, b) {
                    return b.length - a.length;
                  });
                };
                MountableFileSystem2.prototype.umount = function umount(mountPoint) {
                  var this$1 = this;
                  if (mountPoint[0] !== "/") {
                    mountPoint = "/" + mountPoint;
                  }
                  mountPoint = path.resolve(mountPoint);
                  if (!this.mntMap[mountPoint]) {
                    throw new ApiError3(ErrorCode5.EINVAL, "Mount point " + mountPoint + " is already unmounted.");
                  }
                  delete this.mntMap[mountPoint];
                  this.mountList.splice(this.mountList.indexOf(mountPoint), 1);
                  while (mountPoint !== "/") {
                    if (this$1.rootFs.readdirSync(mountPoint).length === 0) {
                      this$1.rootFs.rmdirSync(mountPoint);
                      mountPoint = path.dirname(mountPoint);
                    } else {
                      break;
                    }
                  }
                };
                MountableFileSystem2.prototype._getFs = function _getFs(path$$1) {
                  var this$1 = this;
                  var mountList = this.mountList, len = mountList.length;
                  for (var i2 = 0; i2 < len; i2++) {
                    var mountPoint = mountList[i2];
                    if (mountPoint.length <= path$$1.length && path$$1.indexOf(mountPoint) === 0) {
                      path$$1 = path$$1.substr(mountPoint.length > 1 ? mountPoint.length : 0);
                      if (path$$1 === "") {
                        path$$1 = "/";
                      }
                      return { fs: this$1.mntMap[mountPoint], path: path$$1 };
                    }
                  }
                  return { fs: this.rootFs, path: path$$1 };
                };
                MountableFileSystem2.prototype.getName = function getName() {
                  return MountableFileSystem2.Name;
                };
                MountableFileSystem2.prototype.diskSpace = function diskSpace(path$$1, cb) {
                  cb(0, 0);
                };
                MountableFileSystem2.prototype.isReadOnly = function isReadOnly() {
                  return false;
                };
                MountableFileSystem2.prototype.supportsLinks = function supportsLinks() {
                  return false;
                };
                MountableFileSystem2.prototype.supportsProps = function supportsProps() {
                  return false;
                };
                MountableFileSystem2.prototype.supportsSynch = function supportsSynch() {
                  return true;
                };
                MountableFileSystem2.prototype.standardizeError = function standardizeError(err, path$$1, realPath) {
                  var index = err.message.indexOf(path$$1);
                  if (index !== -1) {
                    err.message = err.message.substr(0, index) + realPath + err.message.substr(index + path$$1.length);
                    err.path = realPath;
                  }
                  return err;
                };
                MountableFileSystem2.prototype.rename = function rename(oldPath, newPath, cb) {
                  var this$1 = this;
                  var fs1rv = this._getFs(oldPath);
                  var fs2rv = this._getFs(newPath);
                  if (fs1rv.fs === fs2rv.fs) {
                    return fs1rv.fs.rename(fs1rv.path, fs2rv.path, function(e) {
                      if (e) {
                        this$1.standardizeError(this$1.standardizeError(e, fs1rv.path, oldPath), fs2rv.path, newPath);
                      }
                      cb(e);
                    });
                  }
                  return _fsMock.readFile(oldPath, function(err, data) {
                    if (err) {
                      return cb(err);
                    }
                    _fsMock.writeFile(newPath, data, function(err2) {
                      if (err2) {
                        return cb(err2);
                      }
                      _fsMock.unlink(oldPath, cb);
                    });
                  });
                };
                MountableFileSystem2.prototype.renameSync = function renameSync(oldPath, newPath) {
                  var fs1rv = this._getFs(oldPath);
                  var fs2rv = this._getFs(newPath);
                  if (fs1rv.fs === fs2rv.fs) {
                    try {
                      return fs1rv.fs.renameSync(fs1rv.path, fs2rv.path);
                    } catch (e) {
                      this.standardizeError(this.standardizeError(e, fs1rv.path, oldPath), fs2rv.path, newPath);
                      throw e;
                    }
                  }
                  var data = _fsMock.readFileSync(oldPath);
                  _fsMock.writeFileSync(newPath, data);
                  return _fsMock.unlinkSync(oldPath);
                };
                MountableFileSystem2.prototype.readdirSync = function readdirSync(p) {
                  var fsInfo = this._getFs(p);
                  var rv = null;
                  if (fsInfo.fs !== this.rootFs) {
                    try {
                      rv = this.rootFs.readdirSync(p);
                    } catch (e) {
                    }
                  }
                  try {
                    var rv2 = fsInfo.fs.readdirSync(fsInfo.path);
                    if (rv === null) {
                      return rv2;
                    } else {
                      return rv2.concat(rv.filter(function(val) {
                        return rv2.indexOf(val) === -1;
                      }));
                    }
                  } catch (e) {
                    if (rv === null) {
                      throw this.standardizeError(e, fsInfo.path, p);
                    } else {
                      return rv;
                    }
                  }
                };
                MountableFileSystem2.prototype.readdir = function readdir(p, cb) {
                  var this$1 = this;
                  var fsInfo = this._getFs(p);
                  fsInfo.fs.readdir(fsInfo.path, function(err, files) {
                    if (fsInfo.fs !== this$1.rootFs) {
                      try {
                        var rv = this$1.rootFs.readdirSync(p);
                        if (files) {
                          files = files.concat(rv.filter(function(val) {
                            return files.indexOf(val) === -1;
                          }));
                        } else {
                          files = rv;
                        }
                      } catch (e) {
                        if (err) {
                          return cb(this$1.standardizeError(err, fsInfo.path, p));
                        }
                      }
                    } else if (err) {
                      return cb(this$1.standardizeError(err, fsInfo.path, p));
                    }
                    cb(null, files);
                  });
                };
                MountableFileSystem2.prototype.rmdirSync = function rmdirSync(p) {
                  var fsInfo = this._getFs(p);
                  if (this._containsMountPt(p)) {
                    throw ApiError3.ENOTEMPTY(p);
                  } else {
                    try {
                      fsInfo.fs.rmdirSync(fsInfo.path);
                    } catch (e) {
                      throw this.standardizeError(e, fsInfo.path, p);
                    }
                  }
                };
                MountableFileSystem2.prototype.rmdir = function rmdir(p, cb) {
                  var this$1 = this;
                  var fsInfo = this._getFs(p);
                  if (this._containsMountPt(p)) {
                    cb(ApiError3.ENOTEMPTY(p));
                  } else {
                    fsInfo.fs.rmdir(fsInfo.path, function(err) {
                      cb(err ? this$1.standardizeError(err, fsInfo.path, p) : null);
                    });
                  }
                };
                MountableFileSystem2.prototype._containsMountPt = function _containsMountPt(p) {
                  var mountPoints = this.mountList, len = mountPoints.length;
                  for (var i2 = 0; i2 < len; i2++) {
                    var pt = mountPoints[i2];
                    if (pt.length >= p.length && pt.slice(0, p.length) === p) {
                      return true;
                    }
                  }
                  return false;
                };
                return MountableFileSystem2;
              }(BaseFileSystem3);
              MountableFileSystem.Name = "MountableFileSystem";
              MountableFileSystem.Options = {};
              function defineFcn(name, isSync, numArgs) {
                if (isSync) {
                  return function() {
                    var args = [], len = arguments.length;
                    while (len--) args[len] = arguments[len];
                    var path$$1 = args[0];
                    var rv = this._getFs(path$$1);
                    args[0] = rv.path;
                    try {
                      return rv.fs[name].apply(rv.fs, args);
                    } catch (e) {
                      this.standardizeError(e, rv.path, path$$1);
                      throw e;
                    }
                  };
                } else {
                  return function() {
                    var this$1 = this;
                    var args = [], len = arguments.length;
                    while (len--) args[len] = arguments[len];
                    var path$$1 = args[0];
                    var rv = this._getFs(path$$1);
                    args[0] = rv.path;
                    if (typeof args[args.length - 1] === "function") {
                      var cb = args[args.length - 1];
                      args[args.length - 1] = function() {
                        var args2 = [], len2 = arguments.length;
                        while (len2--) args2[len2] = arguments[len2];
                        if (args2.length > 0 && args2[0] instanceof ApiError3) {
                          this$1.standardizeError(args2[0], rv.path, path$$1);
                        }
                        cb.apply(null, args2);
                      };
                    }
                    return rv.fs[name].apply(rv.fs, args);
                  };
                }
              }
              var fsCmdMap = [
                // 1 arg functions
                ["exists", "unlink", "readlink"],
                // 2 arg functions
                ["stat", "mkdir", "realpath", "truncate"],
                // 3 arg functions
                ["open", "readFile", "chmod", "utimes"],
                // 4 arg functions
                ["chown"],
                // 5 arg functions
                ["writeFile", "appendFile"]
              ];
              for (var i = 0; i < fsCmdMap.length; i++) {
                var cmds = fsCmdMap[i];
                for (var i$1 = 0, list = cmds; i$1 < list.length; i$1 += 1) {
                  var fnName = list[i$1];
                  MountableFileSystem.prototype[fnName] = defineFcn(fnName, false, i + 1);
                  MountableFileSystem.prototype[fnName + "Sync"] = defineFcn(fnName + "Sync", true, i + 1);
                }
              }
              var bfsSetImmediate;
              if (typeof setImmediate !== "undefined") {
                bfsSetImmediate = setImmediate;
              } else {
                var gScope = global$1;
                var timeouts = [];
                var messageName = "zero-timeout-message";
                var canUsePostMessage = function() {
                  if (typeof gScope.importScripts !== "undefined" || !gScope.postMessage) {
                    return false;
                  }
                  var postMessageIsAsync = true;
                  var oldOnMessage = gScope.onmessage;
                  gScope.onmessage = function() {
                    postMessageIsAsync = false;
                  };
                  gScope.postMessage("", "*");
                  gScope.onmessage = oldOnMessage;
                  return postMessageIsAsync;
                };
                if (canUsePostMessage()) {
                  bfsSetImmediate = function(fn) {
                    timeouts.push(fn);
                    gScope.postMessage(messageName, "*");
                  };
                  var handleMessage = function(event) {
                    if (event.source === self && event.data === messageName) {
                      if (event.stopPropagation) {
                        event.stopPropagation();
                      } else {
                        event.cancelBubble = true;
                      }
                      if (timeouts.length > 0) {
                        var fn = timeouts.shift();
                        return fn();
                      }
                    }
                  };
                  if (gScope.addEventListener) {
                    gScope.addEventListener("message", handleMessage, true);
                  } else {
                    gScope.attachEvent("onmessage", handleMessage);
                  }
                } else if (gScope.MessageChannel) {
                  var channel = new gScope.MessageChannel();
                  channel.port1.onmessage = function(event) {
                    if (timeouts.length > 0) {
                      return timeouts.shift()();
                    }
                  };
                  bfsSetImmediate = function(fn) {
                    timeouts.push(fn);
                    channel.port2.postMessage("");
                  };
                } else {
                  bfsSetImmediate = function(fn) {
                    return setTimeout(fn, 0);
                  };
                }
              }
              var setImmediate$3 = bfsSetImmediate;
              var Mutex = function Mutex2() {
                this._locked = false;
                this._waiters = [];
              };
              Mutex.prototype.lock = function lock(cb) {
                if (this._locked) {
                  this._waiters.push(cb);
                  return;
                }
                this._locked = true;
                cb();
              };
              Mutex.prototype.unlock = function unlock() {
                if (!this._locked) {
                  throw new Error("unlock of a non-locked mutex");
                }
                var next = this._waiters.shift();
                if (next) {
                  setImmediate$3(next);
                  return;
                }
                this._locked = false;
              };
              Mutex.prototype.tryLock = function tryLock() {
                if (this._locked) {
                  return false;
                }
                this._locked = true;
                return true;
              };
              Mutex.prototype.isLocked = function isLocked() {
                return this._locked;
              };
              var LockedFS2 = function LockedFS3(fs2) {
                this._fs = fs2;
                this._mu = new Mutex();
              };
              LockedFS2.prototype.getName = function getName() {
                return "LockedFS<" + this._fs.getName() + ">";
              };
              LockedFS2.prototype.getFSUnlocked = function getFSUnlocked() {
                return this._fs;
              };
              LockedFS2.prototype.initialize = function initialize3(cb) {
                this._fs.initialize(cb);
              };
              LockedFS2.prototype.diskSpace = function diskSpace(p, cb) {
                this._fs.diskSpace(p, cb);
              };
              LockedFS2.prototype.isReadOnly = function isReadOnly() {
                return this._fs.isReadOnly();
              };
              LockedFS2.prototype.supportsLinks = function supportsLinks() {
                return this._fs.supportsLinks();
              };
              LockedFS2.prototype.supportsProps = function supportsProps() {
                return this._fs.supportsProps();
              };
              LockedFS2.prototype.supportsSynch = function supportsSynch() {
                return this._fs.supportsSynch();
              };
              LockedFS2.prototype.rename = function rename(oldPath, newPath, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.rename(oldPath, newPath, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.renameSync = function renameSync(oldPath, newPath) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.renameSync(oldPath, newPath);
              };
              LockedFS2.prototype.stat = function stat(p, isLstat, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.stat(p, isLstat, function(err, stat2) {
                    this$1._mu.unlock();
                    cb(err, stat2);
                  });
                });
              };
              LockedFS2.prototype.statSync = function statSync(p, isLstat) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.statSync(p, isLstat);
              };
              LockedFS2.prototype.open = function open(p, flag, mode, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.open(p, flag, mode, function(err, fd) {
                    this$1._mu.unlock();
                    cb(err, fd);
                  });
                });
              };
              LockedFS2.prototype.openSync = function openSync(p, flag, mode) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.openSync(p, flag, mode);
              };
              LockedFS2.prototype.unlink = function unlink(p, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.unlink(p, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.unlinkSync = function unlinkSync(p) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.unlinkSync(p);
              };
              LockedFS2.prototype.rmdir = function rmdir(p, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.rmdir(p, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.rmdirSync = function rmdirSync(p) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.rmdirSync(p);
              };
              LockedFS2.prototype.mkdir = function mkdir(p, mode, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.mkdir(p, mode, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.mkdirSync = function mkdirSync(p, mode) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.mkdirSync(p, mode);
              };
              LockedFS2.prototype.readdir = function readdir(p, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.readdir(p, function(err, files) {
                    this$1._mu.unlock();
                    cb(err, files);
                  });
                });
              };
              LockedFS2.prototype.readdirSync = function readdirSync(p) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.readdirSync(p);
              };
              LockedFS2.prototype.exists = function exists(p, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.exists(p, function(exists2) {
                    this$1._mu.unlock();
                    cb(exists2);
                  });
                });
              };
              LockedFS2.prototype.existsSync = function existsSync(p) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.existsSync(p);
              };
              LockedFS2.prototype.realpath = function realpath(p, cache, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.realpath(p, cache, function(err, resolvedPath) {
                    this$1._mu.unlock();
                    cb(err, resolvedPath);
                  });
                });
              };
              LockedFS2.prototype.realpathSync = function realpathSync(p, cache) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.realpathSync(p, cache);
              };
              LockedFS2.prototype.truncate = function truncate(p, len, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.truncate(p, len, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.truncateSync = function truncateSync(p, len) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.truncateSync(p, len);
              };
              LockedFS2.prototype.readFile = function readFile(fname, encoding, flag, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.readFile(fname, encoding, flag, function(err, data) {
                    this$1._mu.unlock();
                    cb(err, data);
                  });
                });
              };
              LockedFS2.prototype.readFileSync = function readFileSync(fname, encoding, flag) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.readFileSync(fname, encoding, flag);
              };
              LockedFS2.prototype.writeFile = function writeFile(fname, data, encoding, flag, mode, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.writeFile(fname, data, encoding, flag, mode, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.writeFileSync = function writeFileSync(fname, data, encoding, flag, mode) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.writeFileSync(fname, data, encoding, flag, mode);
              };
              LockedFS2.prototype.appendFile = function appendFile(fname, data, encoding, flag, mode, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.appendFile(fname, data, encoding, flag, mode, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.appendFileSync = function appendFileSync(fname, data, encoding, flag, mode) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.appendFileSync(fname, data, encoding, flag, mode);
              };
              LockedFS2.prototype.chmod = function chmod(p, isLchmod, mode, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.chmod(p, isLchmod, mode, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.chmodSync = function chmodSync(p, isLchmod, mode) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.chmodSync(p, isLchmod, mode);
              };
              LockedFS2.prototype.chown = function chown(p, isLchown, uid, gid, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.chown(p, isLchown, uid, gid, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.chownSync = function chownSync(p, isLchown, uid, gid) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.chownSync(p, isLchown, uid, gid);
              };
              LockedFS2.prototype.utimes = function utimes(p, atime, mtime, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.utimes(p, atime, mtime, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.utimesSync = function utimesSync(p, atime, mtime) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.utimesSync(p, atime, mtime);
              };
              LockedFS2.prototype.link = function link(srcpath, dstpath, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.link(srcpath, dstpath, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.linkSync = function linkSync(srcpath, dstpath) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.linkSync(srcpath, dstpath);
              };
              LockedFS2.prototype.symlink = function symlink(srcpath, dstpath, type, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.symlink(srcpath, dstpath, type, function(err) {
                    this$1._mu.unlock();
                    cb(err);
                  });
                });
              };
              LockedFS2.prototype.symlinkSync = function symlinkSync(srcpath, dstpath, type) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.symlinkSync(srcpath, dstpath, type);
              };
              LockedFS2.prototype.readlink = function readlink(p, cb) {
                var this$1 = this;
                this._mu.lock(function() {
                  this$1._fs.readlink(p, function(err, linkString) {
                    this$1._mu.unlock();
                    cb(err, linkString);
                  });
                });
              };
              LockedFS2.prototype.readlinkSync = function readlinkSync(p) {
                if (this._mu.isLocked()) {
                  throw new Error("invalid sync call");
                }
                return this._fs.readlinkSync(p);
              };
              var deletionLogPath = "/.deletedFiles.log";
              function makeModeWritable2(mode) {
                return 146 | mode;
              }
              function getFlag(f) {
                return FileFlag8.getFileFlag(f);
              }
              var OverlayFile2 = function(PreloadFile$$1) {
                function OverlayFile3(fs2, path$$1, flag, stats, data) {
                  PreloadFile$$1.call(this, fs2, path$$1, flag, stats, data);
                }
                if (PreloadFile$$1) OverlayFile3.__proto__ = PreloadFile$$1;
                OverlayFile3.prototype = Object.create(PreloadFile$$1 && PreloadFile$$1.prototype);
                OverlayFile3.prototype.constructor = OverlayFile3;
                OverlayFile3.prototype.sync = function sync(cb) {
                  var this$1 = this;
                  if (!this.isDirty()) {
                    cb(null);
                    return;
                  }
                  this._fs._syncAsync(this, function(err) {
                    this$1.resetDirty();
                    cb(err);
                  });
                };
                OverlayFile3.prototype.syncSync = function syncSync() {
                  if (this.isDirty()) {
                    this._fs._syncSync(this);
                    this.resetDirty();
                  }
                };
                OverlayFile3.prototype.close = function close(cb) {
                  this.sync(cb);
                };
                OverlayFile3.prototype.closeSync = function closeSync() {
                  this.syncSync();
                };
                return OverlayFile3;
              }(PreloadFile2);
              var UnlockedOverlayFS2 = function(BaseFileSystem$$1) {
                function UnlockedOverlayFS3(writable, readable) {
                  BaseFileSystem$$1.call(this);
                  this._isInitialized = false;
                  this._initializeCallbacks = [];
                  this._deletedFiles = {};
                  this._deleteLog = "";
                  this._deleteLogUpdatePending = false;
                  this._deleteLogUpdateNeeded = false;
                  this._deleteLogError = null;
                  this._writable = writable;
                  this._readable = readable;
                  if (this._writable.isReadOnly()) {
                    throw new ApiError3(ErrorCode5.EINVAL, "Writable file system must be writable.");
                  }
                }
                if (BaseFileSystem$$1) UnlockedOverlayFS3.__proto__ = BaseFileSystem$$1;
                UnlockedOverlayFS3.prototype = Object.create(BaseFileSystem$$1 && BaseFileSystem$$1.prototype);
                UnlockedOverlayFS3.prototype.constructor = UnlockedOverlayFS3;
                UnlockedOverlayFS3.isAvailable = function isAvailable() {
                  return true;
                };
                UnlockedOverlayFS3.prototype.getOverlayedFileSystems = function getOverlayedFileSystems() {
                  return {
                    readable: this._readable,
                    writable: this._writable
                  };
                };
                UnlockedOverlayFS3.prototype._syncAsync = function _syncAsync(file, cb) {
                  var this$1 = this;
                  this.createParentDirectoriesAsync(file.getPath(), function(err) {
                    if (err) {
                      return cb(err);
                    }
                    this$1._writable.writeFile(file.getPath(), file.getBuffer(), null, getFlag("w"), file.getStats().mode, cb);
                  });
                };
                UnlockedOverlayFS3.prototype._syncSync = function _syncSync(file) {
                  this.createParentDirectories(file.getPath());
                  this._writable.writeFileSync(file.getPath(), file.getBuffer(), null, getFlag("w"), file.getStats().mode);
                };
                UnlockedOverlayFS3.prototype.getName = function getName() {
                  return OverlayFS2.Name;
                };
                UnlockedOverlayFS3.prototype.initialize = function initialize3(cb) {
                  var this$1 = this;
                  var callbackArray = this._initializeCallbacks;
                  var end = function(e) {
                    this$1._isInitialized = !e;
                    this$1._initializeCallbacks = [];
                    callbackArray.forEach(function(cb2) {
                      return cb2(e);
                    });
                  };
                  if (this._isInitialized) {
                    return cb();
                  }
                  callbackArray.push(cb);
                  if (callbackArray.length !== 1) {
                    return;
                  }
                  this._writable.readFile(deletionLogPath, "utf8", getFlag("r"), function(err, data) {
                    if (err) {
                      if (err.errno !== ErrorCode5.ENOENT) {
                        return end(err);
                      }
                    } else {
                      this$1._deleteLog = data;
                    }
                    this$1._reparseDeletionLog();
                    end();
                  });
                };
                UnlockedOverlayFS3.prototype.isReadOnly = function isReadOnly() {
                  return false;
                };
                UnlockedOverlayFS3.prototype.supportsSynch = function supportsSynch() {
                  return this._readable.supportsSynch() && this._writable.supportsSynch();
                };
                UnlockedOverlayFS3.prototype.supportsLinks = function supportsLinks() {
                  return false;
                };
                UnlockedOverlayFS3.prototype.supportsProps = function supportsProps() {
                  return this._readable.supportsProps() && this._writable.supportsProps();
                };
                UnlockedOverlayFS3.prototype.getDeletionLog = function getDeletionLog() {
                  return this._deleteLog;
                };
                UnlockedOverlayFS3.prototype.restoreDeletionLog = function restoreDeletionLog(log2) {
                  this._deleteLog = log2;
                  this._reparseDeletionLog();
                  this.updateLog("");
                };
                UnlockedOverlayFS3.prototype.rename = function rename(oldPath, newPath, cb) {
                  var this$1 = this;
                  if (!this.checkInitAsync(cb) || this.checkPathAsync(oldPath, cb) || this.checkPathAsync(newPath, cb)) {
                    return;
                  }
                  if (oldPath === deletionLogPath || newPath === deletionLogPath) {
                    return cb(ApiError3.EPERM("Cannot rename deletion log."));
                  }
                  if (oldPath === newPath) {
                    return cb();
                  }
                  this.stat(oldPath, false, function(oldErr, oldStats) {
                    if (oldErr) {
                      return cb(oldErr);
                    }
                    return this$1.stat(newPath, false, function(newErr, newStats) {
                      var self2 = this$1;
                      function copyDirContents(files) {
                        var file = files.shift();
                        if (!file) {
                          return cb();
                        }
                        var oldFile = path.resolve(oldPath, file);
                        var newFile = path.resolve(newPath, file);
                        self2.rename(oldFile, newFile, function(err) {
                          if (err) {
                            return cb(err);
                          }
                          copyDirContents(files);
                        });
                      }
                      var mode = 511;
                      if (oldStats.isDirectory()) {
                        if (newErr) {
                          if (newErr.errno !== ErrorCode5.ENOENT) {
                            return cb(newErr);
                          }
                          return this$1._writable.exists(oldPath, function(exists) {
                            if (exists) {
                              return this$1._writable.rename(oldPath, newPath, cb);
                            }
                            this$1._writable.mkdir(newPath, mode, function(mkdirErr) {
                              if (mkdirErr) {
                                return cb(mkdirErr);
                              }
                              this$1._readable.readdir(oldPath, function(err, files) {
                                if (err) {
                                  return cb();
                                }
                                copyDirContents(files);
                              });
                            });
                          });
                        }
                        mode = newStats.mode;
                        if (!newStats.isDirectory()) {
                          return cb(ApiError3.ENOTDIR(newPath));
                        }
                        this$1.readdir(newPath, function(readdirErr, files) {
                          if (files && files.length) {
                            return cb(ApiError3.ENOTEMPTY(newPath));
                          }
                          this$1._readable.readdir(oldPath, function(err, files2) {
                            if (err) {
                              return cb();
                            }
                            copyDirContents(files2);
                          });
                        });
                      }
                      if (newStats && newStats.isDirectory()) {
                        return cb(ApiError3.EISDIR(newPath));
                      }
                      this$1.readFile(oldPath, null, getFlag("r"), function(err, data) {
                        if (err) {
                          return cb(err);
                        }
                        return this$1.writeFile(newPath, data, null, getFlag("w"), oldStats.mode, function(err2) {
                          if (err2) {
                            return cb(err2);
                          }
                          return this$1.unlink(oldPath, cb);
                        });
                      });
                    });
                  });
                };
                UnlockedOverlayFS3.prototype.renameSync = function renameSync(oldPath, newPath) {
                  var this$1 = this;
                  this.checkInitialized();
                  this.checkPath(oldPath);
                  this.checkPath(newPath);
                  if (oldPath === deletionLogPath || newPath === deletionLogPath) {
                    throw ApiError3.EPERM("Cannot rename deletion log.");
                  }
                  var oldStats = this.statSync(oldPath, false);
                  if (oldStats.isDirectory()) {
                    if (oldPath === newPath) {
                      return;
                    }
                    var mode = 511;
                    if (this.existsSync(newPath)) {
                      var stats = this.statSync(newPath, false);
                      mode = stats.mode;
                      if (stats.isDirectory()) {
                        if (this.readdirSync(newPath).length > 0) {
                          throw ApiError3.ENOTEMPTY(newPath);
                        }
                      } else {
                        throw ApiError3.ENOTDIR(newPath);
                      }
                    }
                    if (this._writable.existsSync(oldPath)) {
                      this._writable.renameSync(oldPath, newPath);
                    } else if (!this._writable.existsSync(newPath)) {
                      this._writable.mkdirSync(newPath, mode);
                    }
                    if (this._readable.existsSync(oldPath)) {
                      this._readable.readdirSync(oldPath).forEach(function(name) {
                        this$1.renameSync(path.resolve(oldPath, name), path.resolve(newPath, name));
                      });
                    }
                  } else {
                    if (this.existsSync(newPath) && this.statSync(newPath, false).isDirectory()) {
                      throw ApiError3.EISDIR(newPath);
                    }
                    this.writeFileSync(newPath, this.readFileSync(oldPath, null, getFlag("r")), null, getFlag("w"), oldStats.mode);
                  }
                  if (oldPath !== newPath && this.existsSync(oldPath)) {
                    this.unlinkSync(oldPath);
                  }
                };
                UnlockedOverlayFS3.prototype.stat = function stat(p, isLstat, cb) {
                  var this$1 = this;
                  if (!this.checkInitAsync(cb)) {
                    return;
                  }
                  this._writable.stat(p, isLstat, function(err, stat2) {
                    if (err && err.errno === ErrorCode5.ENOENT) {
                      if (this$1._deletedFiles[p]) {
                        cb(ApiError3.ENOENT(p));
                      }
                      this$1._readable.stat(p, isLstat, function(err2, stat3) {
                        if (stat3) {
                          stat3 = stat3.clone();
                          stat3.mode = makeModeWritable2(stat3.mode);
                        }
                        cb(err2, stat3);
                      });
                    } else {
                      cb(err, stat2);
                    }
                  });
                };
                UnlockedOverlayFS3.prototype.statSync = function statSync(p, isLstat) {
                  this.checkInitialized();
                  try {
                    return this._writable.statSync(p, isLstat);
                  } catch (e) {
                    if (this._deletedFiles[p]) {
                      throw ApiError3.ENOENT(p);
                    }
                    var oldStat = this._readable.statSync(p, isLstat).clone();
                    oldStat.mode = makeModeWritable2(oldStat.mode);
                    return oldStat;
                  }
                };
                UnlockedOverlayFS3.prototype.open = function open(p, flag, mode, cb) {
                  var this$1 = this;
                  if (!this.checkInitAsync(cb) || this.checkPathAsync(p, cb)) {
                    return;
                  }
                  this.stat(p, false, function(err, stats) {
                    if (stats) {
                      switch (flag.pathExistsAction()) {
                        case ActionType3.TRUNCATE_FILE:
                          return this$1.createParentDirectoriesAsync(p, function(err2) {
                            if (err2) {
                              return cb(err2);
                            }
                            this$1._writable.open(p, flag, mode, cb);
                          });
                        case ActionType3.NOP:
                          return this$1._writable.exists(p, function(exists) {
                            if (exists) {
                              this$1._writable.open(p, flag, mode, cb);
                            } else {
                              stats = stats.clone();
                              stats.mode = mode;
                              this$1._readable.readFile(p, null, getFlag("r"), function(readFileErr, data) {
                                if (readFileErr) {
                                  return cb(readFileErr);
                                }
                                if (stats.size === -1) {
                                  stats.size = data.length;
                                }
                                var f = new OverlayFile2(this$1, p, flag, stats, data);
                                cb(null, f);
                              });
                            }
                          });
                        default:
                          return cb(ApiError3.EEXIST(p));
                      }
                    } else {
                      switch (flag.pathNotExistsAction()) {
                        case ActionType3.CREATE_FILE:
                          return this$1.createParentDirectoriesAsync(p, function(err2) {
                            if (err2) {
                              return cb(err2);
                            }
                            return this$1._writable.open(p, flag, mode, cb);
                          });
                        default:
                          return cb(ApiError3.ENOENT(p));
                      }
                    }
                  });
                };
                UnlockedOverlayFS3.prototype.openSync = function openSync(p, flag, mode) {
                  this.checkInitialized();
                  this.checkPath(p);
                  if (p === deletionLogPath) {
                    throw ApiError3.EPERM("Cannot open deletion log.");
                  }
                  if (this.existsSync(p)) {
                    switch (flag.pathExistsAction()) {
                      case ActionType3.TRUNCATE_FILE:
                        this.createParentDirectories(p);
                        return this._writable.openSync(p, flag, mode);
                      case ActionType3.NOP:
                        if (this._writable.existsSync(p)) {
                          return this._writable.openSync(p, flag, mode);
                        } else {
                          var buf = this._readable.readFileSync(p, null, getFlag("r"));
                          var stats = this._readable.statSync(p, false).clone();
                          stats.mode = mode;
                          return new OverlayFile2(this, p, flag, stats, buf);
                        }
                      default:
                        throw ApiError3.EEXIST(p);
                    }
                  } else {
                    switch (flag.pathNotExistsAction()) {
                      case ActionType3.CREATE_FILE:
                        this.createParentDirectories(p);
                        return this._writable.openSync(p, flag, mode);
                      default:
                        throw ApiError3.ENOENT(p);
                    }
                  }
                };
                UnlockedOverlayFS3.prototype.unlink = function unlink(p, cb) {
                  var this$1 = this;
                  if (!this.checkInitAsync(cb) || this.checkPathAsync(p, cb)) {
                    return;
                  }
                  this.exists(p, function(exists) {
                    if (!exists) {
                      return cb(ApiError3.ENOENT(p));
                    }
                    this$1._writable.exists(p, function(writableExists) {
                      if (writableExists) {
                        return this$1._writable.unlink(p, function(err) {
                          if (err) {
                            return cb(err);
                          }
                          this$1.exists(p, function(readableExists) {
                            if (readableExists) {
                              this$1.deletePath(p);
                            }
                            cb(null);
                          });
                        });
                      } else {
                        this$1.deletePath(p);
                        cb(null);
                      }
                    });
                  });
                };
                UnlockedOverlayFS3.prototype.unlinkSync = function unlinkSync(p) {
                  this.checkInitialized();
                  this.checkPath(p);
                  if (this.existsSync(p)) {
                    if (this._writable.existsSync(p)) {
                      this._writable.unlinkSync(p);
                    }
                    if (this.existsSync(p)) {
                      this.deletePath(p);
                    }
                  } else {
                    throw ApiError3.ENOENT(p);
                  }
                };
                UnlockedOverlayFS3.prototype.rmdir = function rmdir(p, cb) {
                  var this$1 = this;
                  if (!this.checkInitAsync(cb)) {
                    return;
                  }
                  var rmdirLower = function() {
                    this$1.readdir(p, function(err, files) {
                      if (err) {
                        return cb(err);
                      }
                      if (files.length) {
                        return cb(ApiError3.ENOTEMPTY(p));
                      }
                      this$1.deletePath(p);
                      cb(null);
                    });
                  };
                  this.exists(p, function(exists) {
                    if (!exists) {
                      return cb(ApiError3.ENOENT(p));
                    }
                    this$1._writable.exists(p, function(writableExists) {
                      if (writableExists) {
                        this$1._writable.rmdir(p, function(err) {
                          if (err) {
                            return cb(err);
                          }
                          this$1._readable.exists(p, function(readableExists) {
                            if (readableExists) {
                              rmdirLower();
                            } else {
                              cb();
                            }
                          });
                        });
                      } else {
                        rmdirLower();
                      }
                    });
                  });
                };
                UnlockedOverlayFS3.prototype.rmdirSync = function rmdirSync(p) {
                  this.checkInitialized();
                  if (this.existsSync(p)) {
                    if (this._writable.existsSync(p)) {
                      this._writable.rmdirSync(p);
                    }
                    if (this.existsSync(p)) {
                      if (this.readdirSync(p).length > 0) {
                        throw ApiError3.ENOTEMPTY(p);
                      } else {
                        this.deletePath(p);
                      }
                    }
                  } else {
                    throw ApiError3.ENOENT(p);
                  }
                };
                UnlockedOverlayFS3.prototype.mkdir = function mkdir(p, mode, cb) {
                  var this$1 = this;
                  if (!this.checkInitAsync(cb)) {
                    return;
                  }
                  this.exists(p, function(exists) {
                    if (exists) {
                      return cb(ApiError3.EEXIST(p));
                    }
                    this$1.createParentDirectoriesAsync(p, function(err) {
                      if (err) {
                        return cb(err);
                      }
                      this$1._writable.mkdir(p, mode, cb);
                    });
                  });
                };
                UnlockedOverlayFS3.prototype.mkdirSync = function mkdirSync(p, mode) {
                  this.checkInitialized();
                  if (this.existsSync(p)) {
                    throw ApiError3.EEXIST(p);
                  } else {
                    this.createParentDirectories(p);
                    this._writable.mkdirSync(p, mode);
                  }
                };
                UnlockedOverlayFS3.prototype.readdir = function readdir(p, cb) {
                  var this$1 = this;
                  if (!this.checkInitAsync(cb)) {
                    return;
                  }
                  this.stat(p, false, function(err, dirStats) {
                    if (err) {
                      return cb(err);
                    }
                    if (!dirStats.isDirectory()) {
                      return cb(ApiError3.ENOTDIR(p));
                    }
                    this$1._writable.readdir(p, function(err2, wFiles) {
                      if (err2 && err2.code !== "ENOENT") {
                        return cb(err2);
                      } else if (err2 || !wFiles) {
                        wFiles = [];
                      }
                      this$1._readable.readdir(p, function(err3, rFiles) {
                        if (err3 || !rFiles) {
                          rFiles = [];
                        }
                        var seenMap = {};
                        var filtered = wFiles.concat(rFiles.filter(function(fPath) {
                          return !this$1._deletedFiles[p + "/" + fPath];
                        })).filter(function(fPath) {
                          var result = !seenMap[fPath];
                          seenMap[fPath] = true;
                          return result;
                        });
                        cb(null, filtered);
                      });
                    });
                  });
                };
                UnlockedOverlayFS3.prototype.readdirSync = function readdirSync(p) {
                  var this$1 = this;
                  this.checkInitialized();
                  var dirStats = this.statSync(p, false);
                  if (!dirStats.isDirectory()) {
                    throw ApiError3.ENOTDIR(p);
                  }
                  var contents = [];
                  try {
                    contents = contents.concat(this._writable.readdirSync(p));
                  } catch (e) {
                  }
                  try {
                    contents = contents.concat(this._readable.readdirSync(p).filter(function(fPath) {
                      return !this$1._deletedFiles[p + "/" + fPath];
                    }));
                  } catch (e) {
                  }
                  var seenMap = {};
                  return contents.filter(function(fileP) {
                    var result = !seenMap[fileP];
                    seenMap[fileP] = true;
                    return result;
                  });
                };
                UnlockedOverlayFS3.prototype.exists = function exists(p, cb) {
                  var this$1 = this;
                  this.checkInitialized();
                  this._writable.exists(p, function(existsWritable) {
                    if (existsWritable) {
                      return cb(true);
                    }
                    this$1._readable.exists(p, function(existsReadable) {
                      cb(existsReadable && this$1._deletedFiles[p] !== true);
                    });
                  });
                };
                UnlockedOverlayFS3.prototype.existsSync = function existsSync(p) {
                  this.checkInitialized();
                  return this._writable.existsSync(p) || this._readable.existsSync(p) && this._deletedFiles[p] !== true;
                };
                UnlockedOverlayFS3.prototype.chmod = function chmod(p, isLchmod, mode, cb) {
                  var this$1 = this;
                  if (!this.checkInitAsync(cb)) {
                    return;
                  }
                  this.operateOnWritableAsync(p, function(err) {
                    if (err) {
                      return cb(err);
                    } else {
                      this$1._writable.chmod(p, isLchmod, mode, cb);
                    }
                  });
                };
                UnlockedOverlayFS3.prototype.chmodSync = function chmodSync(p, isLchmod, mode) {
                  var this$1 = this;
                  this.checkInitialized();
                  this.operateOnWritable(p, function() {
                    this$1._writable.chmodSync(p, isLchmod, mode);
                  });
                };
                UnlockedOverlayFS3.prototype.chown = function chown(p, isLchmod, uid, gid, cb) {
                  var this$1 = this;
                  if (!this.checkInitAsync(cb)) {
                    return;
                  }
                  this.operateOnWritableAsync(p, function(err) {
                    if (err) {
                      return cb(err);
                    } else {
                      this$1._writable.chown(p, isLchmod, uid, gid, cb);
                    }
                  });
                };
                UnlockedOverlayFS3.prototype.chownSync = function chownSync(p, isLchown, uid, gid) {
                  var this$1 = this;
                  this.checkInitialized();
                  this.operateOnWritable(p, function() {
                    this$1._writable.chownSync(p, isLchown, uid, gid);
                  });
                };
                UnlockedOverlayFS3.prototype.utimes = function utimes(p, atime, mtime, cb) {
                  var this$1 = this;
                  if (!this.checkInitAsync(cb)) {
                    return;
                  }
                  this.operateOnWritableAsync(p, function(err) {
                    if (err) {
                      return cb(err);
                    } else {
                      this$1._writable.utimes(p, atime, mtime, cb);
                    }
                  });
                };
                UnlockedOverlayFS3.prototype.utimesSync = function utimesSync(p, atime, mtime) {
                  var this$1 = this;
                  this.checkInitialized();
                  this.operateOnWritable(p, function() {
                    this$1._writable.utimesSync(p, atime, mtime);
                  });
                };
                UnlockedOverlayFS3.prototype.deletePath = function deletePath(p) {
                  this._deletedFiles[p] = true;
                  this.updateLog("d" + p + "\n");
                };
                UnlockedOverlayFS3.prototype.updateLog = function updateLog(addition) {
                  var this$1 = this;
                  this._deleteLog += addition;
                  if (this._deleteLogUpdatePending) {
                    this._deleteLogUpdateNeeded = true;
                  } else {
                    this._deleteLogUpdatePending = true;
                    this._writable.writeFile(deletionLogPath, this._deleteLog, "utf8", FileFlag8.getFileFlag("w"), 420, function(e) {
                      this$1._deleteLogUpdatePending = false;
                      if (e) {
                        this$1._deleteLogError = e;
                      } else if (this$1._deleteLogUpdateNeeded) {
                        this$1._deleteLogUpdateNeeded = false;
                        this$1.updateLog("");
                      }
                    });
                  }
                };
                UnlockedOverlayFS3.prototype._reparseDeletionLog = function _reparseDeletionLog() {
                  var this$1 = this;
                  this._deletedFiles = {};
                  this._deleteLog.split("\n").forEach(function(path$$1) {
                    this$1._deletedFiles[path$$1.slice(1)] = path$$1.slice(0, 1) === "d";
                  });
                };
                UnlockedOverlayFS3.prototype.checkInitialized = function checkInitialized() {
                  if (!this._isInitialized) {
                    throw new ApiError3(ErrorCode5.EPERM, "OverlayFS is not initialized. Please initialize OverlayFS using its initialize() method before using it.");
                  } else if (this._deleteLogError !== null) {
                    var e = this._deleteLogError;
                    this._deleteLogError = null;
                    throw e;
                  }
                };
                UnlockedOverlayFS3.prototype.checkInitAsync = function checkInitAsync(cb) {
                  if (!this._isInitialized) {
                    cb(new ApiError3(ErrorCode5.EPERM, "OverlayFS is not initialized. Please initialize OverlayFS using its initialize() method before using it."));
                    return false;
                  } else if (this._deleteLogError !== null) {
                    var e = this._deleteLogError;
                    this._deleteLogError = null;
                    cb(e);
                    return false;
                  }
                  return true;
                };
                UnlockedOverlayFS3.prototype.checkPath = function checkPath(p) {
                  if (p === deletionLogPath) {
                    throw ApiError3.EPERM(p);
                  }
                };
                UnlockedOverlayFS3.prototype.checkPathAsync = function checkPathAsync(p, cb) {
                  if (p === deletionLogPath) {
                    cb(ApiError3.EPERM(p));
                    return true;
                  }
                  return false;
                };
                UnlockedOverlayFS3.prototype.createParentDirectoriesAsync = function createParentDirectoriesAsync(p, cb) {
                  var parent = path.dirname(p);
                  var toCreate = [];
                  var self2 = this;
                  this._writable.stat(parent, false, statDone);
                  function statDone(err, stat) {
                    if (err) {
                      toCreate.push(parent);
                      parent = path.dirname(parent);
                      self2._writable.stat(parent, false, statDone);
                    } else {
                      createParents();
                    }
                  }
                  function createParents() {
                    if (!toCreate.length) {
                      return cb();
                    }
                    var dir = toCreate.pop();
                    self2._readable.stat(dir, false, function(err, stats) {
                      if (!stats) {
                        return cb();
                      }
                      self2._writable.mkdir(dir, stats.mode, function(err2) {
                        if (err2) {
                          return cb(err2);
                        }
                        createParents();
                      });
                    });
                  }
                };
                UnlockedOverlayFS3.prototype.createParentDirectories = function createParentDirectories(p) {
                  var this$1 = this;
                  var parent = path.dirname(p), toCreate = [];
                  while (!this._writable.existsSync(parent)) {
                    toCreate.push(parent);
                    parent = path.dirname(parent);
                  }
                  toCreate = toCreate.reverse();
                  toCreate.forEach(function(p2) {
                    this$1._writable.mkdirSync(p2, this$1.statSync(p2, false).mode);
                  });
                };
                UnlockedOverlayFS3.prototype.operateOnWritable = function operateOnWritable(p, f) {
                  if (this.existsSync(p)) {
                    if (!this._writable.existsSync(p)) {
                      this.copyToWritable(p);
                    }
                    f();
                  } else {
                    throw ApiError3.ENOENT(p);
                  }
                };
                UnlockedOverlayFS3.prototype.operateOnWritableAsync = function operateOnWritableAsync(p, cb) {
                  var this$1 = this;
                  this.exists(p, function(exists) {
                    if (!exists) {
                      return cb(ApiError3.ENOENT(p));
                    }
                    this$1._writable.exists(p, function(existsWritable) {
                      if (existsWritable) {
                        cb();
                      } else {
                        return this$1.copyToWritableAsync(p, cb);
                      }
                    });
                  });
                };
                UnlockedOverlayFS3.prototype.copyToWritable = function copyToWritable(p) {
                  var pStats = this.statSync(p, false);
                  if (pStats.isDirectory()) {
                    this._writable.mkdirSync(p, pStats.mode);
                  } else {
                    this.writeFileSync(p, this._readable.readFileSync(p, null, getFlag("r")), null, getFlag("w"), this.statSync(p, false).mode);
                  }
                };
                UnlockedOverlayFS3.prototype.copyToWritableAsync = function copyToWritableAsync(p, cb) {
                  var this$1 = this;
                  this.stat(p, false, function(err, pStats) {
                    if (err) {
                      return cb(err);
                    }
                    if (pStats.isDirectory()) {
                      return this$1._writable.mkdir(p, pStats.mode, cb);
                    }
                    this$1._readable.readFile(p, null, getFlag("r"), function(err2, data) {
                      if (err2) {
                        return cb(err2);
                      }
                      this$1.writeFile(p, data, null, getFlag("w"), pStats.mode, cb);
                    });
                  });
                };
                return UnlockedOverlayFS3;
              }(BaseFileSystem3);
              var OverlayFS2 = function(LockedFS$$1) {
                function OverlayFS3(writable, readable, deprecateMsg) {
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  LockedFS$$1.call(this, new UnlockedOverlayFS2(writable, readable));
                  deprecationMessage(deprecateMsg, OverlayFS3.Name, { readable: "readable file system", writable: "writable file system" });
                }
                if (LockedFS$$1) OverlayFS3.__proto__ = LockedFS$$1;
                OverlayFS3.prototype = Object.create(LockedFS$$1 && LockedFS$$1.prototype);
                OverlayFS3.prototype.constructor = OverlayFS3;
                OverlayFS3.Create = function Create(opts, cb) {
                  try {
                    var fs2 = new OverlayFS3(opts.writable, opts.readable, false);
                    fs2.initialize(function(e) {
                      cb(e, fs2);
                    }, false);
                  } catch (e) {
                    cb(e);
                  }
                };
                OverlayFS3.isAvailable = function isAvailable() {
                  return UnlockedOverlayFS2.isAvailable();
                };
                OverlayFS3.prototype.initialize = function initialize3(cb, deprecateMsg) {
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  if (deprecateMsg) {
                    console.warn("[OverlayFS] OverlayFS.initialize() is deprecated and will be removed in the next major release. Please use 'OverlayFS.Create({readable: readable file system instance, writable: writable file system instance}, cb)' to create and initialize OverlayFS instances.");
                  }
                  LockedFS$$1.prototype.initialize.call(this, cb);
                };
                OverlayFS3.prototype.getOverlayedFileSystems = function getOverlayedFileSystems() {
                  return LockedFS$$1.prototype.getFSUnlocked.call(this).getOverlayedFileSystems();
                };
                OverlayFS3.prototype.unwrap = function unwrap() {
                  return LockedFS$$1.prototype.getFSUnlocked.call(this);
                };
                return OverlayFS3;
              }(LockedFS2);
              OverlayFS2.Name = "OverlayFS";
              OverlayFS2.Options = {
                writable: {
                  type: "object",
                  description: "The file system to write modified files to."
                },
                readable: {
                  type: "object",
                  description: "The file system that initially populates this file system."
                }
              };
              var SpecialArgType;
              (function(SpecialArgType2) {
                SpecialArgType2[SpecialArgType2["CB"] = 0] = "CB";
                SpecialArgType2[SpecialArgType2["FD"] = 1] = "FD";
                SpecialArgType2[SpecialArgType2["API_ERROR"] = 2] = "API_ERROR";
                SpecialArgType2[SpecialArgType2["STATS"] = 3] = "STATS";
                SpecialArgType2[SpecialArgType2["PROBE"] = 4] = "PROBE";
                SpecialArgType2[SpecialArgType2["FILEFLAG"] = 5] = "FILEFLAG";
                SpecialArgType2[SpecialArgType2["BUFFER"] = 6] = "BUFFER";
                SpecialArgType2[SpecialArgType2["ERROR"] = 7] = "ERROR";
              })(SpecialArgType || (SpecialArgType = {}));
              var CallbackArgumentConverter = function CallbackArgumentConverter2() {
                this._callbacks = {};
                this._nextId = 0;
              };
              CallbackArgumentConverter.prototype.toRemoteArg = function toRemoteArg(cb) {
                var id = this._nextId++;
                this._callbacks[id] = cb;
                return {
                  type: SpecialArgType.CB,
                  id
                };
              };
              CallbackArgumentConverter.prototype.toLocalArg = function toLocalArg(id) {
                var cb = this._callbacks[id];
                delete this._callbacks[id];
                return cb;
              };
              var FileDescriptorArgumentConverter = function FileDescriptorArgumentConverter2() {
                this._fileDescriptors = {};
                this._nextId = 0;
              };
              FileDescriptorArgumentConverter.prototype.toRemoteArg = function toRemoteArg(fd, p, flag, cb) {
                var id = this._nextId++;
                var data;
                var stat;
                this._fileDescriptors[id] = fd;
                fd.stat(function(err, stats) {
                  if (err) {
                    cb(err);
                  } else {
                    stat = bufferToTransferrableObject(stats.toBuffer());
                    if (flag.isReadable()) {
                      fd.read(Buffer2.alloc(stats.size), 0, stats.size, 0, function(err2, bytesRead, buff) {
                        if (err2) {
                          cb(err2);
                        } else {
                          data = bufferToTransferrableObject(buff);
                          cb(null, {
                            type: SpecialArgType.FD,
                            id,
                            data,
                            stat,
                            path: p,
                            flag: flag.getFlagString()
                          });
                        }
                      });
                    } else {
                      cb(null, {
                        type: SpecialArgType.FD,
                        id,
                        data: new ArrayBuffer(0),
                        stat,
                        path: p,
                        flag: flag.getFlagString()
                      });
                    }
                  }
                });
              };
              FileDescriptorArgumentConverter.prototype.applyFdAPIRequest = function applyFdAPIRequest(request, cb) {
                var this$1 = this;
                var fdArg = request.args[0];
                this._applyFdChanges(fdArg, function(err, fd) {
                  if (err) {
                    cb(err);
                  } else {
                    fd[request.method](function(e) {
                      if (request.method === "close") {
                        delete this$1._fileDescriptors[fdArg.id];
                      }
                      cb(e);
                    });
                  }
                });
              };
              FileDescriptorArgumentConverter.prototype._applyFdChanges = function _applyFdChanges(remoteFd, cb) {
                var fd = this._fileDescriptors[remoteFd.id], data = transferrableObjectToBuffer(remoteFd.data), remoteStats = Stats2.fromBuffer(transferrableObjectToBuffer(remoteFd.stat));
                var flag = FileFlag8.getFileFlag(remoteFd.flag);
                if (flag.isWriteable()) {
                  fd.write(data, 0, data.length, flag.isAppendable() ? fd.getPos() : 0, function(e) {
                    function applyStatChanges() {
                      fd.stat(function(e2, stats) {
                        if (e2) {
                          cb(e2);
                        } else {
                          if (stats.mode !== remoteStats.mode) {
                            fd.chmod(remoteStats.mode, function(e3) {
                              cb(e3, fd);
                            });
                          } else {
                            cb(e2, fd);
                          }
                        }
                      });
                    }
                    if (e) {
                      cb(e);
                    } else {
                      if (!flag.isAppendable()) {
                        fd.truncate(data.length, function() {
                          applyStatChanges();
                        });
                      } else {
                        applyStatChanges();
                      }
                    }
                  });
                } else {
                  cb(null, fd);
                }
              };
              function apiErrorLocal2Remote(e) {
                return {
                  type: SpecialArgType.API_ERROR,
                  errorData: bufferToTransferrableObject(e.writeToBuffer())
                };
              }
              function apiErrorRemote2Local(e) {
                return ApiError3.fromBuffer(transferrableObjectToBuffer(e.errorData));
              }
              function errorLocal2Remote(e) {
                return {
                  type: SpecialArgType.ERROR,
                  name: e.name,
                  message: e.message,
                  stack: e.stack
                };
              }
              function errorRemote2Local(e) {
                var cnstr = global$1[e.name];
                if (typeof cnstr !== "function") {
                  cnstr = Error;
                }
                var err = new cnstr(e.message);
                err.stack = e.stack;
                return err;
              }
              function statsLocal2Remote(stats) {
                return {
                  type: SpecialArgType.STATS,
                  statsData: bufferToTransferrableObject(stats.toBuffer())
                };
              }
              function statsRemote2Local(stats) {
                return Stats2.fromBuffer(transferrableObjectToBuffer(stats.statsData));
              }
              function fileFlagLocal2Remote(flag) {
                return {
                  type: SpecialArgType.FILEFLAG,
                  flagStr: flag.getFlagString()
                };
              }
              function fileFlagRemote2Local(remoteFlag) {
                return FileFlag8.getFileFlag(remoteFlag.flagStr);
              }
              function bufferToTransferrableObject(buff) {
                return buffer2ArrayBuffer(buff);
              }
              function transferrableObjectToBuffer(buff) {
                return arrayBuffer2Buffer(buff);
              }
              function bufferLocal2Remote(buff) {
                return {
                  type: SpecialArgType.BUFFER,
                  data: bufferToTransferrableObject(buff)
                };
              }
              function bufferRemote2Local(buffArg) {
                return transferrableObjectToBuffer(buffArg.data);
              }
              function isAPIRequest(data) {
                return data && typeof data === "object" && data.hasOwnProperty("browserfsMessage") && data["browserfsMessage"];
              }
              function isAPIResponse(data) {
                return data && typeof data === "object" && data.hasOwnProperty("browserfsMessage") && data["browserfsMessage"];
              }
              var WorkerFile = function(PreloadFile$$1) {
                function WorkerFile2(_fs, _path, _flag, _stat, remoteFdId, contents) {
                  PreloadFile$$1.call(this, _fs, _path, _flag, _stat, contents);
                  this._remoteFdId = remoteFdId;
                }
                if (PreloadFile$$1) WorkerFile2.__proto__ = PreloadFile$$1;
                WorkerFile2.prototype = Object.create(PreloadFile$$1 && PreloadFile$$1.prototype);
                WorkerFile2.prototype.constructor = WorkerFile2;
                WorkerFile2.prototype.getRemoteFdId = function getRemoteFdId() {
                  return this._remoteFdId;
                };
                WorkerFile2.prototype.toRemoteArg = function toRemoteArg() {
                  return {
                    type: SpecialArgType.FD,
                    id: this._remoteFdId,
                    data: bufferToTransferrableObject(this.getBuffer()),
                    stat: bufferToTransferrableObject(this.getStats().toBuffer()),
                    path: this.getPath(),
                    flag: this.getFlag().getFlagString()
                  };
                };
                WorkerFile2.prototype.sync = function sync(cb) {
                  this._syncClose("sync", cb);
                };
                WorkerFile2.prototype.close = function close(cb) {
                  this._syncClose("close", cb);
                };
                WorkerFile2.prototype._syncClose = function _syncClose(type, cb) {
                  var this$1 = this;
                  if (this.isDirty()) {
                    this._fs.syncClose(type, this, function(e) {
                      if (!e) {
                        this$1.resetDirty();
                      }
                      cb(e);
                    });
                  } else {
                    cb();
                  }
                };
                return WorkerFile2;
              }(PreloadFile2);
              var WorkerFS = function(BaseFileSystem$$1) {
                function WorkerFS2(worker, deprecateMsg) {
                  var this$1 = this;
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  BaseFileSystem$$1.call(this);
                  this._callbackConverter = new CallbackArgumentConverter();
                  this._isInitialized = false;
                  this._isReadOnly = false;
                  this._supportLinks = false;
                  this._supportProps = false;
                  this._worker = worker;
                  deprecationMessage(deprecateMsg, WorkerFS2.Name, { worker: "Web Worker instance" });
                  this._worker.addEventListener("message", function(e) {
                    var resp = e.data;
                    if (isAPIResponse(resp)) {
                      var i2;
                      var args = resp.args;
                      var fixedArgs = new Array(args.length);
                      for (i2 = 0; i2 < fixedArgs.length; i2++) {
                        fixedArgs[i2] = this$1._argRemote2Local(args[i2]);
                      }
                      this$1._callbackConverter.toLocalArg(resp.cbId).apply(null, fixedArgs);
                    }
                  });
                }
                if (BaseFileSystem$$1) WorkerFS2.__proto__ = BaseFileSystem$$1;
                WorkerFS2.prototype = Object.create(BaseFileSystem$$1 && BaseFileSystem$$1.prototype);
                WorkerFS2.prototype.constructor = WorkerFS2;
                WorkerFS2.Create = function Create(opts, cb) {
                  var fs2 = new WorkerFS2(opts.worker, false);
                  fs2.initialize(function() {
                    cb(null, fs2);
                  });
                };
                WorkerFS2.isAvailable = function isAvailable() {
                  return typeof importScripts !== "undefined" || typeof Worker !== "undefined";
                };
                WorkerFS2.attachRemoteListener = function attachRemoteListener(worker) {
                  var fdConverter = new FileDescriptorArgumentConverter();
                  function argLocal2Remote(arg, requestArgs, cb) {
                    switch (typeof arg) {
                      case "object":
                        if (arg instanceof Stats2) {
                          cb(null, statsLocal2Remote(arg));
                        } else if (arg instanceof ApiError3) {
                          cb(null, apiErrorLocal2Remote(arg));
                        } else if (arg instanceof BaseFile) {
                          cb(null, fdConverter.toRemoteArg(arg, requestArgs[0], requestArgs[1], cb));
                        } else if (arg instanceof FileFlag8) {
                          cb(null, fileFlagLocal2Remote(arg));
                        } else if (arg instanceof Buffer2) {
                          cb(null, bufferLocal2Remote(arg));
                        } else if (arg instanceof Error) {
                          cb(null, errorLocal2Remote(arg));
                        } else {
                          cb(null, arg);
                        }
                        break;
                      default:
                        cb(null, arg);
                        break;
                    }
                  }
                  function argRemote2Local(arg, fixedRequestArgs) {
                    if (!arg) {
                      return arg;
                    }
                    switch (typeof arg) {
                      case "object":
                        if (typeof arg["type"] === "number") {
                          var specialArg = arg;
                          switch (specialArg.type) {
                            case SpecialArgType.CB:
                              var cbId = arg.id;
                              return function() {
                                var arguments$1 = arguments;
                                var i2;
                                var fixedArgs = new Array(arguments.length);
                                var message, countdown = arguments.length;
                                function abortAndSendError(err) {
                                  if (countdown > 0) {
                                    countdown = -1;
                                    message = {
                                      browserfsMessage: true,
                                      cbId,
                                      args: [apiErrorLocal2Remote(err)]
                                    };
                                    worker.postMessage(message);
                                  }
                                }
                                for (i2 = 0; i2 < arguments.length; i2++) {
                                  (function(i3, arg2) {
                                    argLocal2Remote(arg2, fixedRequestArgs, function(err, fixedArg) {
                                      fixedArgs[i3] = fixedArg;
                                      if (err) {
                                        abortAndSendError(err);
                                      } else if (--countdown === 0) {
                                        message = {
                                          browserfsMessage: true,
                                          cbId,
                                          args: fixedArgs
                                        };
                                        worker.postMessage(message);
                                      }
                                    });
                                  })(i2, arguments$1[i2]);
                                }
                                if (arguments.length === 0) {
                                  message = {
                                    browserfsMessage: true,
                                    cbId,
                                    args: fixedArgs
                                  };
                                  worker.postMessage(message);
                                }
                              };
                            case SpecialArgType.API_ERROR:
                              return apiErrorRemote2Local(specialArg);
                            case SpecialArgType.STATS:
                              return statsRemote2Local(specialArg);
                            case SpecialArgType.FILEFLAG:
                              return fileFlagRemote2Local(specialArg);
                            case SpecialArgType.BUFFER:
                              return bufferRemote2Local(specialArg);
                            case SpecialArgType.ERROR:
                              return errorRemote2Local(specialArg);
                            default:
                              return arg;
                          }
                        } else {
                          return arg;
                        }
                      default:
                        return arg;
                    }
                  }
                  worker.addEventListener("message", function(e) {
                    var request = e.data;
                    if (isAPIRequest(request)) {
                      var args = request.args, fixedArgs = new Array(args.length);
                      switch (request.method) {
                        case "close":
                        case "sync":
                          (function() {
                            var remoteCb = args[1];
                            fdConverter.applyFdAPIRequest(request, function(err) {
                              var response = {
                                browserfsMessage: true,
                                cbId: remoteCb.id,
                                args: err ? [apiErrorLocal2Remote(err)] : []
                              };
                              worker.postMessage(response);
                            });
                          })();
                          break;
                        case "probe":
                          (function() {
                            var rootFs = _fsMock.getRootFS(), remoteCb = args[1], probeResponse = {
                              type: SpecialArgType.PROBE,
                              isReadOnly: rootFs.isReadOnly(),
                              supportsLinks: rootFs.supportsLinks(),
                              supportsProps: rootFs.supportsProps()
                            }, response = {
                              browserfsMessage: true,
                              cbId: remoteCb.id,
                              args: [probeResponse]
                            };
                            worker.postMessage(response);
                          })();
                          break;
                        default:
                          for (var i2 = 0; i2 < args.length; i2++) {
                            fixedArgs[i2] = argRemote2Local(args[i2], fixedArgs);
                          }
                          var rootFS = _fsMock.getRootFS();
                          rootFS[request.method].apply(rootFS, fixedArgs);
                          break;
                      }
                    }
                  });
                };
                WorkerFS2.prototype.getName = function getName() {
                  return WorkerFS2.Name;
                };
                WorkerFS2.prototype.initialize = function initialize3(cb) {
                  var this$1 = this;
                  if (!this._isInitialized) {
                    var message = {
                      browserfsMessage: true,
                      method: "probe",
                      args: [this._argLocal2Remote(emptyBuffer()), this._callbackConverter.toRemoteArg(function(probeResponse) {
                        this$1._isInitialized = true;
                        this$1._isReadOnly = probeResponse.isReadOnly;
                        this$1._supportLinks = probeResponse.supportsLinks;
                        this$1._supportProps = probeResponse.supportsProps;
                        cb();
                      })]
                    };
                    this._worker.postMessage(message);
                  } else {
                    cb();
                  }
                };
                WorkerFS2.prototype.isReadOnly = function isReadOnly() {
                  return this._isReadOnly;
                };
                WorkerFS2.prototype.supportsSynch = function supportsSynch() {
                  return false;
                };
                WorkerFS2.prototype.supportsLinks = function supportsLinks() {
                  return this._supportLinks;
                };
                WorkerFS2.prototype.supportsProps = function supportsProps() {
                  return this._supportProps;
                };
                WorkerFS2.prototype.rename = function rename(oldPath, newPath, cb) {
                  this._rpc("rename", arguments);
                };
                WorkerFS2.prototype.stat = function stat(p, isLstat, cb) {
                  this._rpc("stat", arguments);
                };
                WorkerFS2.prototype.open = function open(p, flag, mode, cb) {
                  this._rpc("open", arguments);
                };
                WorkerFS2.prototype.unlink = function unlink(p, cb) {
                  this._rpc("unlink", arguments);
                };
                WorkerFS2.prototype.rmdir = function rmdir(p, cb) {
                  this._rpc("rmdir", arguments);
                };
                WorkerFS2.prototype.mkdir = function mkdir(p, mode, cb) {
                  this._rpc("mkdir", arguments);
                };
                WorkerFS2.prototype.readdir = function readdir(p, cb) {
                  this._rpc("readdir", arguments);
                };
                WorkerFS2.prototype.exists = function exists(p, cb) {
                  this._rpc("exists", arguments);
                };
                WorkerFS2.prototype.realpath = function realpath(p, cache, cb) {
                  this._rpc("realpath", arguments);
                };
                WorkerFS2.prototype.truncate = function truncate(p, len, cb) {
                  this._rpc("truncate", arguments);
                };
                WorkerFS2.prototype.readFile = function readFile(fname, encoding, flag, cb) {
                  this._rpc("readFile", arguments);
                };
                WorkerFS2.prototype.writeFile = function writeFile(fname, data, encoding, flag, mode, cb) {
                  this._rpc("writeFile", arguments);
                };
                WorkerFS2.prototype.appendFile = function appendFile(fname, data, encoding, flag, mode, cb) {
                  this._rpc("appendFile", arguments);
                };
                WorkerFS2.prototype.chmod = function chmod(p, isLchmod, mode, cb) {
                  this._rpc("chmod", arguments);
                };
                WorkerFS2.prototype.chown = function chown(p, isLchown, uid, gid, cb) {
                  this._rpc("chown", arguments);
                };
                WorkerFS2.prototype.utimes = function utimes(p, atime, mtime, cb) {
                  this._rpc("utimes", arguments);
                };
                WorkerFS2.prototype.link = function link(srcpath, dstpath, cb) {
                  this._rpc("link", arguments);
                };
                WorkerFS2.prototype.symlink = function symlink(srcpath, dstpath, type, cb) {
                  this._rpc("symlink", arguments);
                };
                WorkerFS2.prototype.readlink = function readlink(p, cb) {
                  this._rpc("readlink", arguments);
                };
                WorkerFS2.prototype.syncClose = function syncClose(method, fd, cb) {
                  this._worker.postMessage({
                    browserfsMessage: true,
                    method,
                    args: [fd.toRemoteArg(), this._callbackConverter.toRemoteArg(cb)]
                  });
                };
                WorkerFS2.prototype._argRemote2Local = function _argRemote2Local(arg) {
                  if (!arg) {
                    return arg;
                  }
                  switch (typeof arg) {
                    case "object":
                      if (typeof arg["type"] === "number") {
                        var specialArg = arg;
                        switch (specialArg.type) {
                          case SpecialArgType.API_ERROR:
                            return apiErrorRemote2Local(specialArg);
                          case SpecialArgType.FD:
                            var fdArg = specialArg;
                            return new WorkerFile(this, fdArg.path, FileFlag8.getFileFlag(fdArg.flag), Stats2.fromBuffer(transferrableObjectToBuffer(fdArg.stat)), fdArg.id, transferrableObjectToBuffer(fdArg.data));
                          case SpecialArgType.STATS:
                            return statsRemote2Local(specialArg);
                          case SpecialArgType.FILEFLAG:
                            return fileFlagRemote2Local(specialArg);
                          case SpecialArgType.BUFFER:
                            return bufferRemote2Local(specialArg);
                          case SpecialArgType.ERROR:
                            return errorRemote2Local(specialArg);
                          default:
                            return arg;
                        }
                      } else {
                        return arg;
                      }
                    default:
                      return arg;
                  }
                };
                WorkerFS2.prototype._rpc = function _rpc(methodName, args) {
                  var this$1 = this;
                  var fixedArgs = new Array(args.length);
                  for (var i2 = 0; i2 < args.length; i2++) {
                    fixedArgs[i2] = this$1._argLocal2Remote(args[i2]);
                  }
                  var message = {
                    browserfsMessage: true,
                    method: methodName,
                    args: fixedArgs
                  };
                  this._worker.postMessage(message);
                };
                WorkerFS2.prototype._argLocal2Remote = function _argLocal2Remote(arg) {
                  if (!arg) {
                    return arg;
                  }
                  switch (typeof arg) {
                    case "object":
                      if (arg instanceof Stats2) {
                        return statsLocal2Remote(arg);
                      } else if (arg instanceof ApiError3) {
                        return apiErrorLocal2Remote(arg);
                      } else if (arg instanceof WorkerFile) {
                        return arg.toRemoteArg();
                      } else if (arg instanceof FileFlag8) {
                        return fileFlagLocal2Remote(arg);
                      } else if (arg instanceof Buffer2) {
                        return bufferLocal2Remote(arg);
                      } else if (arg instanceof Error) {
                        return errorLocal2Remote(arg);
                      } else {
                        return "Unknown argument";
                      }
                    case "function":
                      return this._callbackConverter.toRemoteArg(arg);
                    default:
                      return arg;
                  }
                };
                return WorkerFS2;
              }(BaseFileSystem3);
              WorkerFS.Name = "WorkerFS";
              WorkerFS.Options = {
                worker: {
                  type: "object",
                  description: "The target worker that you want to connect to, or the current worker if in a worker context.",
                  validator: function(v, cb) {
                    if (v["postMessage"]) {
                      cb();
                    } else {
                      cb(new ApiError3(ErrorCode5.EINVAL, "option must be a Web Worker instance."));
                    }
                  }
                }
              };
              function asyncDownloadFileModern(p, type, cb) {
                var req = new XMLHttpRequest();
                req.open("GET", p, true);
                var jsonSupported = true;
                switch (type) {
                  case "buffer":
                    req.responseType = "arraybuffer";
                    break;
                  case "json":
                    try {
                      req.responseType = "json";
                      jsonSupported = req.responseType === "json";
                    } catch (e) {
                      jsonSupported = false;
                    }
                    break;
                  default:
                    return cb(new ApiError3(ErrorCode5.EINVAL, "Invalid download type: " + type));
                }
                req.onreadystatechange = function(e) {
                  if (req.readyState === 4) {
                    if (req.status === 200) {
                      switch (type) {
                        case "buffer":
                          return cb(null, req.response ? Buffer2.from(req.response) : emptyBuffer());
                        case "json":
                          if (jsonSupported) {
                            return cb(null, req.response);
                          } else {
                            return cb(null, JSON.parse(req.responseText));
                          }
                      }
                    } else {
                      return cb(new ApiError3(req.status, "XHR error."));
                    }
                  }
                };
                req.send();
              }
              function syncDownloadFileModern(p, type) {
                var req = new XMLHttpRequest();
                req.open("GET", p, false);
                var data = null;
                var err = null;
                req.overrideMimeType("text/plain; charset=x-user-defined");
                req.onreadystatechange = function(e) {
                  if (req.readyState === 4) {
                    if (req.status === 200) {
                      switch (type) {
                        case "buffer":
                          var text = req.responseText;
                          data = Buffer2.alloc(text.length);
                          for (var i2 = 0; i2 < text.length; i2++) {
                            data[i2] = text.charCodeAt(i2);
                          }
                          return;
                        case "json":
                          data = JSON.parse(req.responseText);
                          return;
                      }
                    } else {
                      err = new ApiError3(req.status, "XHR error.");
                      return;
                    }
                  }
                };
                req.send();
                if (err) {
                  throw err;
                }
                return data;
              }
              function syncDownloadFileIE10(p, type) {
                var req = new XMLHttpRequest();
                req.open("GET", p, false);
                switch (type) {
                  case "buffer":
                    req.responseType = "arraybuffer";
                    break;
                  case "json":
                    break;
                  default:
                    throw new ApiError3(ErrorCode5.EINVAL, "Invalid download type: " + type);
                }
                var data;
                var err;
                req.onreadystatechange = function(e) {
                  if (req.readyState === 4) {
                    if (req.status === 200) {
                      switch (type) {
                        case "buffer":
                          data = Buffer2.from(req.response);
                          break;
                        case "json":
                          data = JSON.parse(req.response);
                          break;
                      }
                    } else {
                      err = new ApiError3(req.status, "XHR error.");
                    }
                  }
                };
                req.send();
                if (err) {
                  throw err;
                }
                return data;
              }
              function getFileSize(async, p, cb) {
                var req = new XMLHttpRequest();
                req.open("HEAD", p, async);
                req.onreadystatechange = function(e) {
                  if (req.readyState === 4) {
                    if (req.status === 200) {
                      try {
                        return cb(null, parseInt(req.getResponseHeader("Content-Length") || "-1", 10));
                      } catch (e2) {
                        return cb(new ApiError3(ErrorCode5.EIO, "XHR HEAD error: Could not read content-length."));
                      }
                    } else {
                      return cb(new ApiError3(req.status, "XHR HEAD error."));
                    }
                  }
                };
                req.send();
              }
              var asyncDownloadFile = asyncDownloadFileModern;
              var syncDownloadFile = isIE && typeof Blob !== "undefined" ? syncDownloadFileIE10 : syncDownloadFileModern;
              function getFileSizeSync(p) {
                var rv = -1;
                getFileSize(false, p, function(err, size) {
                  if (err) {
                    throw err;
                  }
                  rv = size;
                });
                return rv;
              }
              function getFileSizeAsync(p, cb) {
                getFileSize(true, p, cb);
              }
              var FileIndex = function FileIndex2() {
                this._index = {};
                this.addPath("/", new DirInode());
              };
              FileIndex.fromListing = function fromListing(listing) {
                var idx = new FileIndex();
                var rootInode = new DirInode();
                idx._index["/"] = rootInode;
                var queue = [["", listing, rootInode]];
                while (queue.length > 0) {
                  var inode = void 0;
                  var next = queue.pop();
                  var pwd = next[0];
                  var tree = next[1];
                  var parent = next[2];
                  for (var node in tree) {
                    if (tree.hasOwnProperty(node)) {
                      var children = tree[node];
                      var name = pwd + "/" + node;
                      if (children) {
                        idx._index[name] = inode = new DirInode();
                        queue.push([name, children, inode]);
                      } else {
                        inode = new FileInode(new Stats2(FileType5.FILE, -1, 365));
                      }
                      if (parent) {
                        parent._ls[node] = inode;
                      }
                    }
                  }
                }
                return idx;
              };
              FileIndex.prototype.fileIterator = function fileIterator(cb) {
                var this$1 = this;
                for (var path$$1 in this$1._index) {
                  if (this$1._index.hasOwnProperty(path$$1)) {
                    var dir = this$1._index[path$$1];
                    var files = dir.getListing();
                    for (var i2 = 0, list2 = files; i2 < list2.length; i2 += 1) {
                      var file = list2[i2];
                      var item = dir.getItem(file);
                      if (isFileInode(item)) {
                        cb(item.getData());
                      }
                    }
                  }
                }
              };
              FileIndex.prototype.addPath = function addPath(path$$1, inode) {
                if (!inode) {
                  throw new Error("Inode must be specified");
                }
                if (path$$1[0] !== "/") {
                  throw new Error("Path must be absolute, got: " + path$$1);
                }
                if (this._index.hasOwnProperty(path$$1)) {
                  return this._index[path$$1] === inode;
                }
                var splitPath2 = this._split_path(path$$1);
                var dirpath = splitPath2[0];
                var itemname = splitPath2[1];
                var parent = this._index[dirpath];
                if (parent === void 0 && path$$1 !== "/") {
                  parent = new DirInode();
                  if (!this.addPath(dirpath, parent)) {
                    return false;
                  }
                }
                if (path$$1 !== "/") {
                  if (!parent.addItem(itemname, inode)) {
                    return false;
                  }
                }
                if (isDirInode(inode)) {
                  this._index[path$$1] = inode;
                }
                return true;
              };
              FileIndex.prototype.addPathFast = function addPathFast(path$$1, inode) {
                var itemNameMark = path$$1.lastIndexOf("/");
                var parentPath = itemNameMark === 0 ? "/" : path$$1.substring(0, itemNameMark);
                var itemName = path$$1.substring(itemNameMark + 1);
                var parent = this._index[parentPath];
                if (parent === void 0) {
                  parent = new DirInode();
                  this.addPathFast(parentPath, parent);
                }
                if (!parent.addItem(itemName, inode)) {
                  return false;
                }
                if (inode.isDir()) {
                  this._index[path$$1] = inode;
                }
                return true;
              };
              FileIndex.prototype.removePath = function removePath(path$$1) {
                var this$1 = this;
                var splitPath2 = this._split_path(path$$1);
                var dirpath = splitPath2[0];
                var itemname = splitPath2[1];
                var parent = this._index[dirpath];
                if (parent === void 0) {
                  return null;
                }
                var inode = parent.remItem(itemname);
                if (inode === null) {
                  return null;
                }
                if (isDirInode(inode)) {
                  var children = inode.getListing();
                  for (var i2 = 0, list2 = children; i2 < list2.length; i2 += 1) {
                    var child = list2[i2];
                    this$1.removePath(path$$1 + "/" + child);
                  }
                  if (path$$1 !== "/") {
                    delete this._index[path$$1];
                  }
                }
                return inode;
              };
              FileIndex.prototype.ls = function ls(path$$1) {
                var item = this._index[path$$1];
                if (item === void 0) {
                  return null;
                }
                return item.getListing();
              };
              FileIndex.prototype.getInode = function getInode(path$$1) {
                var splitPath2 = this._split_path(path$$1);
                var dirpath = splitPath2[0];
                var itemname = splitPath2[1];
                var parent = this._index[dirpath];
                if (parent === void 0) {
                  return null;
                }
                if (dirpath === path$$1) {
                  return parent;
                }
                return parent.getItem(itemname);
              };
              FileIndex.prototype._split_path = function _split_path(p) {
                var dirpath = path.dirname(p);
                var itemname = p.substr(dirpath.length + (dirpath === "/" ? 0 : 1));
                return [dirpath, itemname];
              };
              var FileInode = function FileInode2(data) {
                this.data = data;
              };
              FileInode.prototype.isFile = function isFile() {
                return true;
              };
              FileInode.prototype.isDir = function isDir() {
                return false;
              };
              FileInode.prototype.getData = function getData() {
                return this.data;
              };
              FileInode.prototype.setData = function setData(data) {
                this.data = data;
              };
              var DirInode = function DirInode2(data) {
                if (data === void 0) data = null;
                this.data = data;
                this._ls = {};
              };
              DirInode.prototype.isFile = function isFile() {
                return false;
              };
              DirInode.prototype.isDir = function isDir() {
                return true;
              };
              DirInode.prototype.getData = function getData() {
                return this.data;
              };
              DirInode.prototype.getStats = function getStats() {
                return new Stats2(FileType5.DIRECTORY, 4096, 365);
              };
              DirInode.prototype.getListing = function getListing() {
                return Object.keys(this._ls);
              };
              DirInode.prototype.getItem = function getItem(p) {
                var item = this._ls[p];
                return item ? item : null;
              };
              DirInode.prototype.addItem = function addItem(p, inode) {
                if (p in this._ls) {
                  return false;
                }
                this._ls[p] = inode;
                return true;
              };
              DirInode.prototype.remItem = function remItem(p) {
                var item = this._ls[p];
                if (item === void 0) {
                  return null;
                }
                delete this._ls[p];
                return item;
              };
              function isFileInode(inode) {
                return !!inode && inode.isFile();
              }
              function isDirInode(inode) {
                return !!inode && inode.isDir();
              }
              function tryToString(buff, encoding, cb) {
                try {
                  cb(null, buff.toString(encoding));
                } catch (e) {
                  cb(e);
                }
              }
              var XmlHttpRequest = function(BaseFileSystem$$1) {
                function XmlHttpRequest2(listingUrlOrObj, prefixUrl, deprecateMsg) {
                  if (prefixUrl === void 0) prefixUrl = "";
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  BaseFileSystem$$1.call(this);
                  if (!listingUrlOrObj) {
                    listingUrlOrObj = "index.json";
                  }
                  if (prefixUrl.length > 0 && prefixUrl.charAt(prefixUrl.length - 1) !== "/") {
                    prefixUrl = prefixUrl + "/";
                  }
                  this.prefixUrl = prefixUrl;
                  var listing = null;
                  if (typeof listingUrlOrObj === "string") {
                    listing = this._requestFileSync(listingUrlOrObj, "json");
                    if (!listing) {
                      throw new Error("Unable to find listing at URL: ${listingUrlOrObj}");
                    }
                  } else {
                    listing = listingUrlOrObj;
                  }
                  deprecationMessage(deprecateMsg, XmlHttpRequest2.Name, { index: typeof listingUrlOrObj === "string" ? listingUrlOrObj : "file index as an object", baseUrl: prefixUrl });
                  this._index = FileIndex.fromListing(listing);
                }
                if (BaseFileSystem$$1) XmlHttpRequest2.__proto__ = BaseFileSystem$$1;
                XmlHttpRequest2.prototype = Object.create(BaseFileSystem$$1 && BaseFileSystem$$1.prototype);
                XmlHttpRequest2.prototype.constructor = XmlHttpRequest2;
                XmlHttpRequest2.Create = function Create(opts, cb) {
                  if (opts.index === void 0) {
                    opts.index = "index.json";
                  }
                  if (typeof opts.index === "string") {
                    XmlHttpRequest2.FromURL(opts.index, cb, opts.baseUrl, false);
                  } else {
                    cb(null, new XmlHttpRequest2(opts.index, opts.baseUrl, false));
                  }
                };
                XmlHttpRequest2.isAvailable = function isAvailable() {
                  return typeof XMLHttpRequest !== "undefined" && XMLHttpRequest !== null;
                };
                XmlHttpRequest2.FromURL = function FromURL(url, cb, baseUrl, deprecateMsg) {
                  if (baseUrl === void 0) baseUrl = url.slice(0, url.lastIndexOf("/") + 1);
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  if (deprecateMsg) {
                    console.warn(`[XmlHttpRequest] XmlHttpRequest.FromURL() is deprecated and will be removed in the next major release. Please use 'XmlHttpRequest.Create({ index: "` + url + '", baseUrl: "' + baseUrl + `" }, cb)' instead.`);
                  }
                  asyncDownloadFile(url, "json", function(e, data) {
                    if (e) {
                      cb(e);
                    } else {
                      cb(null, new XmlHttpRequest2(data, baseUrl, false));
                    }
                  });
                };
                XmlHttpRequest2.prototype.empty = function empty() {
                  this._index.fileIterator(function(file) {
                    file.fileData = null;
                  });
                };
                XmlHttpRequest2.prototype.getName = function getName() {
                  return XmlHttpRequest2.Name;
                };
                XmlHttpRequest2.prototype.diskSpace = function diskSpace(path$$1, cb) {
                  cb(0, 0);
                };
                XmlHttpRequest2.prototype.isReadOnly = function isReadOnly() {
                  return true;
                };
                XmlHttpRequest2.prototype.supportsLinks = function supportsLinks() {
                  return false;
                };
                XmlHttpRequest2.prototype.supportsProps = function supportsProps() {
                  return false;
                };
                XmlHttpRequest2.prototype.supportsSynch = function supportsSynch() {
                  return true;
                };
                XmlHttpRequest2.prototype.preloadFile = function preloadFile(path$$1, buffer$$1) {
                  var inode = this._index.getInode(path$$1);
                  if (isFileInode(inode)) {
                    if (inode === null) {
                      throw ApiError3.ENOENT(path$$1);
                    }
                    var stats = inode.getData();
                    stats.size = buffer$$1.length;
                    stats.fileData = buffer$$1;
                  } else {
                    throw ApiError3.EISDIR(path$$1);
                  }
                };
                XmlHttpRequest2.prototype.stat = function stat(path$$1, isLstat, cb) {
                  var inode = this._index.getInode(path$$1);
                  if (inode === null) {
                    return cb(ApiError3.ENOENT(path$$1));
                  }
                  var stats;
                  if (isFileInode(inode)) {
                    stats = inode.getData();
                    if (stats.size < 0) {
                      this._requestFileSizeAsync(path$$1, function(e, size) {
                        if (e) {
                          return cb(e);
                        }
                        stats.size = size;
                        cb(null, stats.clone());
                      });
                    } else {
                      cb(null, stats.clone());
                    }
                  } else if (isDirInode(inode)) {
                    stats = inode.getStats();
                    cb(null, stats);
                  } else {
                    cb(ApiError3.FileError(ErrorCode5.EINVAL, path$$1));
                  }
                };
                XmlHttpRequest2.prototype.statSync = function statSync(path$$1, isLstat) {
                  var inode = this._index.getInode(path$$1);
                  if (inode === null) {
                    throw ApiError3.ENOENT(path$$1);
                  }
                  var stats;
                  if (isFileInode(inode)) {
                    stats = inode.getData();
                    if (stats.size < 0) {
                      stats.size = this._requestFileSizeSync(path$$1);
                    }
                  } else if (isDirInode(inode)) {
                    stats = inode.getStats();
                  } else {
                    throw ApiError3.FileError(ErrorCode5.EINVAL, path$$1);
                  }
                  return stats;
                };
                XmlHttpRequest2.prototype.open = function open(path$$1, flags, mode, cb) {
                  if (flags.isWriteable()) {
                    return cb(new ApiError3(ErrorCode5.EPERM, path$$1));
                  }
                  var self2 = this;
                  var inode = this._index.getInode(path$$1);
                  if (inode === null) {
                    return cb(ApiError3.ENOENT(path$$1));
                  }
                  if (isFileInode(inode)) {
                    var stats = inode.getData();
                    switch (flags.pathExistsAction()) {
                      case ActionType3.THROW_EXCEPTION:
                      case ActionType3.TRUNCATE_FILE:
                        return cb(ApiError3.EEXIST(path$$1));
                      case ActionType3.NOP:
                        if (stats.fileData) {
                          return cb(null, new NoSyncFile2(self2, path$$1, flags, stats.clone(), stats.fileData));
                        }
                        this._requestFileAsync(path$$1, "buffer", function(err, buffer$$1) {
                          if (err) {
                            return cb(err);
                          }
                          stats.size = buffer$$1.length;
                          stats.fileData = buffer$$1;
                          return cb(null, new NoSyncFile2(self2, path$$1, flags, stats.clone(), buffer$$1));
                        });
                        break;
                      default:
                        return cb(new ApiError3(ErrorCode5.EINVAL, "Invalid FileMode object."));
                    }
                  } else {
                    return cb(ApiError3.EISDIR(path$$1));
                  }
                };
                XmlHttpRequest2.prototype.openSync = function openSync(path$$1, flags, mode) {
                  if (flags.isWriteable()) {
                    throw new ApiError3(ErrorCode5.EPERM, path$$1);
                  }
                  var inode = this._index.getInode(path$$1);
                  if (inode === null) {
                    throw ApiError3.ENOENT(path$$1);
                  }
                  if (isFileInode(inode)) {
                    var stats = inode.getData();
                    switch (flags.pathExistsAction()) {
                      case ActionType3.THROW_EXCEPTION:
                      case ActionType3.TRUNCATE_FILE:
                        throw ApiError3.EEXIST(path$$1);
                      case ActionType3.NOP:
                        if (stats.fileData) {
                          return new NoSyncFile2(this, path$$1, flags, stats.clone(), stats.fileData);
                        }
                        var buffer$$1 = this._requestFileSync(path$$1, "buffer");
                        stats.size = buffer$$1.length;
                        stats.fileData = buffer$$1;
                        return new NoSyncFile2(this, path$$1, flags, stats.clone(), buffer$$1);
                      default:
                        throw new ApiError3(ErrorCode5.EINVAL, "Invalid FileMode object.");
                    }
                  } else {
                    throw ApiError3.EISDIR(path$$1);
                  }
                };
                XmlHttpRequest2.prototype.readdir = function readdir(path$$1, cb) {
                  try {
                    cb(null, this.readdirSync(path$$1));
                  } catch (e) {
                    cb(e);
                  }
                };
                XmlHttpRequest2.prototype.readdirSync = function readdirSync(path$$1) {
                  var inode = this._index.getInode(path$$1);
                  if (inode === null) {
                    throw ApiError3.ENOENT(path$$1);
                  } else if (isDirInode(inode)) {
                    return inode.getListing();
                  } else {
                    throw ApiError3.ENOTDIR(path$$1);
                  }
                };
                XmlHttpRequest2.prototype.readFile = function readFile(fname, encoding, flag, cb) {
                  var oldCb = cb;
                  this.open(fname, flag, 420, function(err, fd) {
                    if (err) {
                      return cb(err);
                    }
                    cb = function(err2, arg) {
                      fd.close(function(err22) {
                        if (!err2) {
                          err2 = err22;
                        }
                        return oldCb(err2, arg);
                      });
                    };
                    var fdCast = fd;
                    var fdBuff = fdCast.getBuffer();
                    if (encoding === null) {
                      cb(err, copyingSlice2(fdBuff));
                    } else {
                      tryToString(fdBuff, encoding, cb);
                    }
                  });
                };
                XmlHttpRequest2.prototype.readFileSync = function readFileSync(fname, encoding, flag) {
                  var fd = this.openSync(fname, flag, 420);
                  try {
                    var fdCast = fd;
                    var fdBuff = fdCast.getBuffer();
                    if (encoding === null) {
                      return copyingSlice2(fdBuff);
                    }
                    return fdBuff.toString(encoding);
                  } finally {
                    fd.closeSync();
                  }
                };
                XmlHttpRequest2.prototype.getXhrPath = function getXhrPath(filePath) {
                  if (filePath.charAt(0) === "/") {
                    filePath = filePath.slice(1);
                  }
                  return this.prefixUrl + filePath;
                };
                XmlHttpRequest2.prototype._requestFileAsync = function _requestFileAsync(p, type, cb) {
                  asyncDownloadFile(this.getXhrPath(p), type, cb);
                };
                XmlHttpRequest2.prototype._requestFileSync = function _requestFileSync(p, type) {
                  return syncDownloadFile(this.getXhrPath(p), type);
                };
                XmlHttpRequest2.prototype._requestFileSizeAsync = function _requestFileSizeAsync(path$$1, cb) {
                  getFileSizeAsync(this.getXhrPath(path$$1), cb);
                };
                XmlHttpRequest2.prototype._requestFileSizeSync = function _requestFileSizeSync(path$$1) {
                  return getFileSizeSync(this.getXhrPath(path$$1));
                };
                return XmlHttpRequest2;
              }(BaseFileSystem3);
              XmlHttpRequest.Name = "XmlHttpRequest";
              XmlHttpRequest.Options = {
                index: {
                  type: ["string", "object"],
                  optional: true,
                  description: "URL to a file index as a JSON file or the file index object itself, generated with the make_xhrfs_index script. Defaults to `index.json`."
                },
                baseUrl: {
                  type: "string",
                  optional: true,
                  description: "Used as the URL prefix for fetched files. Default: Fetch files relative to the index."
                }
              };
              var ExtendedASCII = function ExtendedASCII2() {
              };
              ExtendedASCII.str2byte = function str2byte(str, buf) {
                var length = str.length > buf.length ? buf.length : str.length;
                for (var i2 = 0; i2 < length; i2++) {
                  var charCode = str.charCodeAt(i2);
                  if (charCode > 127) {
                    var charIdx = ExtendedASCII.extendedChars.indexOf(str.charAt(i2));
                    if (charIdx > -1) {
                      charCode = charIdx + 128;
                    }
                  }
                  buf[charCode] = i2;
                }
                return length;
              };
              ExtendedASCII.byte2str = function byte2str(buff) {
                var chars = new Array(buff.length);
                for (var i2 = 0; i2 < buff.length; i2++) {
                  var charCode = buff[i2];
                  if (charCode > 127) {
                    chars[i2] = ExtendedASCII.extendedChars[charCode - 128];
                  } else {
                    chars[i2] = String.fromCharCode(charCode);
                  }
                }
                return chars.join("");
              };
              ExtendedASCII.byteLength = function byteLength(str) {
                return str.length;
              };
              ExtendedASCII.extendedChars = [
                "\xC7",
                "\xFC",
                "\xE9",
                "\xE2",
                "\xE4",
                "\xE0",
                "\xE5",
                "\xE7",
                "\xEA",
                "\xEB",
                "\xE8",
                "\xEF",
                "\xEE",
                "\xEC",
                "\xC4",
                "\xC5",
                "\xC9",
                "\xE6",
                "\xC6",
                "\xF4",
                "\xF6",
                "\xF2",
                "\xFB",
                "\xF9",
                "\xFF",
                "\xD6",
                "\xDC",
                "\xF8",
                "\xA3",
                "\xD8",
                "\xD7",
                "\u0192",
                "\xE1",
                "\xED",
                "\xF3",
                "\xFA",
                "\xF1",
                "\xD1",
                "\xAA",
                "\xBA",
                "\xBF",
                "\xAE",
                "\xAC",
                "\xBD",
                "\xBC",
                "\xA1",
                "\xAB",
                "\xBB",
                "_",
                "_",
                "_",
                "\xA6",
                "\xA6",
                "\xC1",
                "\xC2",
                "\xC0",
                "\xA9",
                "\xA6",
                "\xA6",
                "+",
                "+",
                "\xA2",
                "\xA5",
                "+",
                "+",
                "-",
                "-",
                "+",
                "-",
                "+",
                "\xE3",
                "\xC3",
                "+",
                "+",
                "-",
                "-",
                "\xA6",
                "-",
                "+",
                "\xA4",
                "\xF0",
                "\xD0",
                "\xCA",
                "\xCB",
                "\xC8",
                "i",
                "\xCD",
                "\xCE",
                "\xCF",
                "+",
                "+",
                "_",
                "_",
                "\xA6",
                "\xCC",
                "_",
                "\xD3",
                "\xDF",
                "\xD4",
                "\xD2",
                "\xF5",
                "\xD5",
                "\xB5",
                "\xFE",
                "\xDE",
                "\xDA",
                "\xDB",
                "\xD9",
                "\xFD",
                "\xDD",
                "\xAF",
                "\xB4",
                "\xAD",
                "\xB1",
                "_",
                "\xBE",
                "\xB6",
                "\xA7",
                "\xF7",
                "\xB8",
                "\xB0",
                "\xA8",
                "\xB7",
                "\xB9",
                "\xB3",
                "\xB2",
                "_",
                " "
              ];
              var inflateRaw = __webpack_require__(31).inflateRaw;
              var decompressionMethods = {};
              var ExternalFileAttributeType;
              (function(ExternalFileAttributeType2) {
                ExternalFileAttributeType2[ExternalFileAttributeType2["MSDOS"] = 0] = "MSDOS";
                ExternalFileAttributeType2[ExternalFileAttributeType2["AMIGA"] = 1] = "AMIGA";
                ExternalFileAttributeType2[ExternalFileAttributeType2["OPENVMS"] = 2] = "OPENVMS";
                ExternalFileAttributeType2[ExternalFileAttributeType2["UNIX"] = 3] = "UNIX";
                ExternalFileAttributeType2[ExternalFileAttributeType2["VM_CMS"] = 4] = "VM_CMS";
                ExternalFileAttributeType2[ExternalFileAttributeType2["ATARI_ST"] = 5] = "ATARI_ST";
                ExternalFileAttributeType2[ExternalFileAttributeType2["OS2_HPFS"] = 6] = "OS2_HPFS";
                ExternalFileAttributeType2[ExternalFileAttributeType2["MAC"] = 7] = "MAC";
                ExternalFileAttributeType2[ExternalFileAttributeType2["Z_SYSTEM"] = 8] = "Z_SYSTEM";
                ExternalFileAttributeType2[ExternalFileAttributeType2["CP_M"] = 9] = "CP_M";
                ExternalFileAttributeType2[ExternalFileAttributeType2["NTFS"] = 10] = "NTFS";
                ExternalFileAttributeType2[ExternalFileAttributeType2["MVS"] = 11] = "MVS";
                ExternalFileAttributeType2[ExternalFileAttributeType2["VSE"] = 12] = "VSE";
                ExternalFileAttributeType2[ExternalFileAttributeType2["ACORN_RISC"] = 13] = "ACORN_RISC";
                ExternalFileAttributeType2[ExternalFileAttributeType2["VFAT"] = 14] = "VFAT";
                ExternalFileAttributeType2[ExternalFileAttributeType2["ALT_MVS"] = 15] = "ALT_MVS";
                ExternalFileAttributeType2[ExternalFileAttributeType2["BEOS"] = 16] = "BEOS";
                ExternalFileAttributeType2[ExternalFileAttributeType2["TANDEM"] = 17] = "TANDEM";
                ExternalFileAttributeType2[ExternalFileAttributeType2["OS_400"] = 18] = "OS_400";
                ExternalFileAttributeType2[ExternalFileAttributeType2["OSX"] = 19] = "OSX";
              })(ExternalFileAttributeType || (ExternalFileAttributeType = {}));
              var CompressionMethod;
              (function(CompressionMethod2) {
                CompressionMethod2[CompressionMethod2["STORED"] = 0] = "STORED";
                CompressionMethod2[CompressionMethod2["SHRUNK"] = 1] = "SHRUNK";
                CompressionMethod2[CompressionMethod2["REDUCED_1"] = 2] = "REDUCED_1";
                CompressionMethod2[CompressionMethod2["REDUCED_2"] = 3] = "REDUCED_2";
                CompressionMethod2[CompressionMethod2["REDUCED_3"] = 4] = "REDUCED_3";
                CompressionMethod2[CompressionMethod2["REDUCED_4"] = 5] = "REDUCED_4";
                CompressionMethod2[CompressionMethod2["IMPLODE"] = 6] = "IMPLODE";
                CompressionMethod2[CompressionMethod2["DEFLATE"] = 8] = "DEFLATE";
                CompressionMethod2[CompressionMethod2["DEFLATE64"] = 9] = "DEFLATE64";
                CompressionMethod2[CompressionMethod2["TERSE_OLD"] = 10] = "TERSE_OLD";
                CompressionMethod2[CompressionMethod2["BZIP2"] = 12] = "BZIP2";
                CompressionMethod2[CompressionMethod2["LZMA"] = 14] = "LZMA";
                CompressionMethod2[CompressionMethod2["TERSE_NEW"] = 18] = "TERSE_NEW";
                CompressionMethod2[CompressionMethod2["LZ77"] = 19] = "LZ77";
                CompressionMethod2[CompressionMethod2["WAVPACK"] = 97] = "WAVPACK";
                CompressionMethod2[CompressionMethod2["PPMD"] = 98] = "PPMD";
              })(CompressionMethod || (CompressionMethod = {}));
              function msdos2date(time, date) {
                var day = date & 31;
                var month = (date >> 5 & 15) - 1;
                var year = (date >> 9) + 1980;
                var second = time & 31;
                var minute = time >> 5 & 63;
                var hour = time >> 11;
                return new Date(year, month, day, hour, minute, second);
              }
              function safeToString(buff, useUTF8, start2, length) {
                if (length === 0) {
                  return "";
                } else if (useUTF8) {
                  return buff.toString("utf8", start2, start2 + length);
                } else {
                  return ExtendedASCII.byte2str(buff.slice(start2, start2 + length));
                }
              }
              var FileHeader = function FileHeader2(data) {
                this.data = data;
                if (data.readUInt32LE(0) !== 67324752) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid Zip file: Local file header has invalid signature: " + this.data.readUInt32LE(0));
                }
              };
              FileHeader.prototype.versionNeeded = function versionNeeded() {
                return this.data.readUInt16LE(4);
              };
              FileHeader.prototype.flags = function flags() {
                return this.data.readUInt16LE(6);
              };
              FileHeader.prototype.compressionMethod = function compressionMethod() {
                return this.data.readUInt16LE(8);
              };
              FileHeader.prototype.lastModFileTime = function lastModFileTime() {
                return msdos2date(this.data.readUInt16LE(10), this.data.readUInt16LE(12));
              };
              FileHeader.prototype.rawLastModFileTime = function rawLastModFileTime() {
                return this.data.readUInt32LE(10);
              };
              FileHeader.prototype.crc32 = function crc32() {
                return this.data.readUInt32LE(14);
              };
              FileHeader.prototype.fileNameLength = function fileNameLength() {
                return this.data.readUInt16LE(26);
              };
              FileHeader.prototype.extraFieldLength = function extraFieldLength() {
                return this.data.readUInt16LE(28);
              };
              FileHeader.prototype.fileName = function fileName() {
                return safeToString(this.data, this.useUTF8(), 30, this.fileNameLength());
              };
              FileHeader.prototype.extraField = function extraField() {
                var start2 = 30 + this.fileNameLength();
                return this.data.slice(start2, start2 + this.extraFieldLength());
              };
              FileHeader.prototype.totalSize = function totalSize() {
                return 30 + this.fileNameLength() + this.extraFieldLength();
              };
              FileHeader.prototype.useUTF8 = function useUTF8() {
                return (this.flags() & 2048) === 2048;
              };
              var FileData = function FileData2(header, record, data) {
                this.header = header;
                this.record = record;
                this.data = data;
              };
              FileData.prototype.decompress = function decompress() {
                var compressionMethod = this.header.compressionMethod();
                var fcn = decompressionMethods[compressionMethod];
                if (fcn) {
                  return fcn(this.data, this.record.compressedSize(), this.record.uncompressedSize(), this.record.flag());
                } else {
                  var name = CompressionMethod[compressionMethod];
                  if (!name) {
                    name = "Unknown: " + compressionMethod;
                  }
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid compression method on file '" + this.header.fileName() + "': " + name);
                }
              };
              FileData.prototype.getHeader = function getHeader() {
                return this.header;
              };
              FileData.prototype.getRecord = function getRecord() {
                return this.record;
              };
              FileData.prototype.getRawData = function getRawData() {
                return this.data;
              };
              var DataDescriptor = function DataDescriptor2(data) {
                this.data = data;
              };
              DataDescriptor.prototype.crc32 = function crc32() {
                return this.data.readUInt32LE(0);
              };
              DataDescriptor.prototype.compressedSize = function compressedSize() {
                return this.data.readUInt32LE(4);
              };
              DataDescriptor.prototype.uncompressedSize = function uncompressedSize() {
                return this.data.readUInt32LE(8);
              };
              var ArchiveExtraDataRecord = function ArchiveExtraDataRecord2(data) {
                this.data = data;
                if (this.data.readUInt32LE(0) !== 134630224) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid archive extra data record signature: " + this.data.readUInt32LE(0));
                }
              };
              ArchiveExtraDataRecord.prototype.length = function length() {
                return this.data.readUInt32LE(4);
              };
              ArchiveExtraDataRecord.prototype.extraFieldData = function extraFieldData() {
                return this.data.slice(8, 8 + this.length());
              };
              var DigitalSignature = function DigitalSignature2(data) {
                this.data = data;
                if (this.data.readUInt32LE(0) !== 84233040) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid digital signature signature: " + this.data.readUInt32LE(0));
                }
              };
              DigitalSignature.prototype.size = function size() {
                return this.data.readUInt16LE(4);
              };
              DigitalSignature.prototype.signatureData = function signatureData() {
                return this.data.slice(6, 6 + this.size());
              };
              var CentralDirectory = function CentralDirectory2(zipData, data) {
                this.zipData = zipData;
                this.data = data;
                if (this.data.readUInt32LE(0) !== 33639248) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid Zip file: Central directory record has invalid signature: " + this.data.readUInt32LE(0));
                }
                this._filename = this.produceFilename();
              };
              CentralDirectory.prototype.versionMadeBy = function versionMadeBy() {
                return this.data.readUInt16LE(4);
              };
              CentralDirectory.prototype.versionNeeded = function versionNeeded() {
                return this.data.readUInt16LE(6);
              };
              CentralDirectory.prototype.flag = function flag() {
                return this.data.readUInt16LE(8);
              };
              CentralDirectory.prototype.compressionMethod = function compressionMethod() {
                return this.data.readUInt16LE(10);
              };
              CentralDirectory.prototype.lastModFileTime = function lastModFileTime() {
                return msdos2date(this.data.readUInt16LE(12), this.data.readUInt16LE(14));
              };
              CentralDirectory.prototype.rawLastModFileTime = function rawLastModFileTime() {
                return this.data.readUInt32LE(12);
              };
              CentralDirectory.prototype.crc32 = function crc32() {
                return this.data.readUInt32LE(16);
              };
              CentralDirectory.prototype.compressedSize = function compressedSize() {
                return this.data.readUInt32LE(20);
              };
              CentralDirectory.prototype.uncompressedSize = function uncompressedSize() {
                return this.data.readUInt32LE(24);
              };
              CentralDirectory.prototype.fileNameLength = function fileNameLength() {
                return this.data.readUInt16LE(28);
              };
              CentralDirectory.prototype.extraFieldLength = function extraFieldLength() {
                return this.data.readUInt16LE(30);
              };
              CentralDirectory.prototype.fileCommentLength = function fileCommentLength() {
                return this.data.readUInt16LE(32);
              };
              CentralDirectory.prototype.diskNumberStart = function diskNumberStart() {
                return this.data.readUInt16LE(34);
              };
              CentralDirectory.prototype.internalAttributes = function internalAttributes() {
                return this.data.readUInt16LE(36);
              };
              CentralDirectory.prototype.externalAttributes = function externalAttributes() {
                return this.data.readUInt32LE(38);
              };
              CentralDirectory.prototype.headerRelativeOffset = function headerRelativeOffset() {
                return this.data.readUInt32LE(42);
              };
              CentralDirectory.prototype.produceFilename = function produceFilename() {
                var fileName = safeToString(this.data, this.useUTF8(), 46, this.fileNameLength());
                return fileName.replace(/\\/g, "/");
              };
              CentralDirectory.prototype.fileName = function fileName() {
                return this._filename;
              };
              CentralDirectory.prototype.rawFileName = function rawFileName() {
                return this.data.slice(46, 46 + this.fileNameLength());
              };
              CentralDirectory.prototype.extraField = function extraField() {
                var start2 = 44 + this.fileNameLength();
                return this.data.slice(start2, start2 + this.extraFieldLength());
              };
              CentralDirectory.prototype.fileComment = function fileComment() {
                var start2 = 46 + this.fileNameLength() + this.extraFieldLength();
                return safeToString(this.data, this.useUTF8(), start2, this.fileCommentLength());
              };
              CentralDirectory.prototype.rawFileComment = function rawFileComment() {
                var start2 = 46 + this.fileNameLength() + this.extraFieldLength();
                return this.data.slice(start2, start2 + this.fileCommentLength());
              };
              CentralDirectory.prototype.totalSize = function totalSize() {
                return 46 + this.fileNameLength() + this.extraFieldLength() + this.fileCommentLength();
              };
              CentralDirectory.prototype.isDirectory = function isDirectory() {
                var fileName = this.fileName();
                return (this.externalAttributes() & 16 ? true : false) || fileName.charAt(fileName.length - 1) === "/";
              };
              CentralDirectory.prototype.isFile = function isFile() {
                return !this.isDirectory();
              };
              CentralDirectory.prototype.useUTF8 = function useUTF8() {
                return (this.flag() & 2048) === 2048;
              };
              CentralDirectory.prototype.isEncrypted = function isEncrypted() {
                return (this.flag() & 1) === 1;
              };
              CentralDirectory.prototype.getFileData = function getFileData() {
                var start2 = this.headerRelativeOffset();
                var header = new FileHeader(this.zipData.slice(start2));
                return new FileData(header, this, this.zipData.slice(start2 + header.totalSize()));
              };
              CentralDirectory.prototype.getData = function getData() {
                return this.getFileData().decompress();
              };
              CentralDirectory.prototype.getRawData = function getRawData() {
                return this.getFileData().getRawData();
              };
              CentralDirectory.prototype.getStats = function getStats() {
                return new Stats2(FileType5.FILE, this.uncompressedSize(), 365, /* @__PURE__ */ new Date(), this.lastModFileTime());
              };
              var EndOfCentralDirectory = function EndOfCentralDirectory2(data) {
                this.data = data;
                if (this.data.readUInt32LE(0) !== 101010256) {
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid Zip file: End of central directory record has invalid signature: " + this.data.readUInt32LE(0));
                }
              };
              EndOfCentralDirectory.prototype.diskNumber = function diskNumber() {
                return this.data.readUInt16LE(4);
              };
              EndOfCentralDirectory.prototype.cdDiskNumber = function cdDiskNumber() {
                return this.data.readUInt16LE(6);
              };
              EndOfCentralDirectory.prototype.cdDiskEntryCount = function cdDiskEntryCount() {
                return this.data.readUInt16LE(8);
              };
              EndOfCentralDirectory.prototype.cdTotalEntryCount = function cdTotalEntryCount() {
                return this.data.readUInt16LE(10);
              };
              EndOfCentralDirectory.prototype.cdSize = function cdSize() {
                return this.data.readUInt32LE(12);
              };
              EndOfCentralDirectory.prototype.cdOffset = function cdOffset() {
                return this.data.readUInt32LE(16);
              };
              EndOfCentralDirectory.prototype.cdZipCommentLength = function cdZipCommentLength() {
                return this.data.readUInt16LE(20);
              };
              EndOfCentralDirectory.prototype.cdZipComment = function cdZipComment() {
                return safeToString(this.data, true, 22, this.cdZipCommentLength());
              };
              EndOfCentralDirectory.prototype.rawCdZipComment = function rawCdZipComment() {
                return this.data.slice(22, 22 + this.cdZipCommentLength());
              };
              var ZipTOC = function ZipTOC2(index, directoryEntries, eocd, data) {
                this.index = index;
                this.directoryEntries = directoryEntries;
                this.eocd = eocd;
                this.data = data;
              };
              var ZipFS = function(SynchronousFileSystem$$1) {
                function ZipFS2(input, name, deprecateMsg) {
                  if (name === void 0) name = "";
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  SynchronousFileSystem$$1.call(this);
                  this.name = name;
                  this._index = new FileIndex();
                  this._directoryEntries = [];
                  this._eocd = null;
                  deprecationMessage(deprecateMsg, ZipFS2.Name, { zipData: "zip data as a Buffer", name });
                  if (input instanceof ZipTOC) {
                    this._index = input.index;
                    this._directoryEntries = input.directoryEntries;
                    this._eocd = input.eocd;
                    this.data = input.data;
                  } else {
                    this.data = input;
                    this.populateIndex();
                  }
                }
                if (SynchronousFileSystem$$1) ZipFS2.__proto__ = SynchronousFileSystem$$1;
                ZipFS2.prototype = Object.create(SynchronousFileSystem$$1 && SynchronousFileSystem$$1.prototype);
                ZipFS2.prototype.constructor = ZipFS2;
                ZipFS2.Create = function Create(opts, cb) {
                  try {
                    ZipFS2.computeIndex(opts.zipData, function(zipTOC) {
                      var fs2 = new ZipFS2(zipTOC, opts.name, false);
                      cb(null, fs2);
                    }, false);
                  } catch (e) {
                    cb(e);
                  }
                };
                ZipFS2.isAvailable = function isAvailable() {
                  return true;
                };
                ZipFS2.RegisterDecompressionMethod = function RegisterDecompressionMethod(m, fcn) {
                  decompressionMethods[m] = fcn;
                };
                ZipFS2.computeIndex = function computeIndex(data, cb, deprecateMsg) {
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  if (deprecateMsg) {
                    console.warn("[ZipFS] ZipFS.computeIndex is now deprecated, and will be removed in the next major release. Please update your code to use 'ZipFS.Create({ zipData: zip file as a Buffer}, cb)' instead.");
                  }
                  var index = new FileIndex();
                  var eocd = ZipFS2.getEOCD(data);
                  if (eocd.diskNumber() !== eocd.cdDiskNumber()) {
                    throw new ApiError3(ErrorCode5.EINVAL, "ZipFS does not support spanned zip files.");
                  }
                  var cdPtr = eocd.cdOffset();
                  if (cdPtr === 4294967295) {
                    throw new ApiError3(ErrorCode5.EINVAL, "ZipFS does not support Zip64.");
                  }
                  var cdEnd = cdPtr + eocd.cdSize();
                  ZipFS2.computeIndexResponsive(data, index, cdPtr, cdEnd, cb, [], eocd);
                };
                ZipFS2.getEOCD = function getEOCD(data) {
                  var startOffset = 22;
                  var endOffset = Math.min(startOffset + 65535, data.length - 1);
                  for (var i2 = startOffset; i2 < endOffset; i2++) {
                    if (data.readUInt32LE(data.length - i2) === 101010256) {
                      return new EndOfCentralDirectory(data.slice(data.length - i2));
                    }
                  }
                  throw new ApiError3(ErrorCode5.EINVAL, "Invalid ZIP file: Could not locate End of Central Directory signature.");
                };
                ZipFS2.addToIndex = function addToIndex(cd, index) {
                  var filename = cd.fileName();
                  if (filename.charAt(0) === "/") {
                    throw new Error("WHY IS THIS ABSOLUTE");
                  }
                  if (filename.charAt(filename.length - 1) === "/") {
                    filename = filename.substr(0, filename.length - 1);
                  }
                  if (cd.isDirectory()) {
                    index.addPathFast("/" + filename, new DirInode(cd));
                  } else {
                    index.addPathFast("/" + filename, new FileInode(cd));
                  }
                };
                ZipFS2.computeIndexResponsive = function computeIndexResponsive(data, index, cdPtr, cdEnd, cb, cdEntries, eocd) {
                  if (cdPtr < cdEnd) {
                    var count = 0;
                    while (count++ < 200 && cdPtr < cdEnd) {
                      var cd = new CentralDirectory(data, data.slice(cdPtr));
                      ZipFS2.addToIndex(cd, index);
                      cdPtr += cd.totalSize();
                      cdEntries.push(cd);
                    }
                    setImmediate$3(function() {
                      ZipFS2.computeIndexResponsive(data, index, cdPtr, cdEnd, cb, cdEntries, eocd);
                    });
                  } else {
                    cb(new ZipTOC(index, cdEntries, eocd, data));
                  }
                };
                ZipFS2.prototype.getName = function getName() {
                  return ZipFS2.Name + (this.name !== "" ? " " + this.name : "");
                };
                ZipFS2.prototype.getCentralDirectoryEntry = function getCentralDirectoryEntry(path$$1) {
                  var inode = this._index.getInode(path$$1);
                  if (inode === null) {
                    throw ApiError3.ENOENT(path$$1);
                  }
                  if (isFileInode(inode)) {
                    return inode.getData();
                  } else if (isDirInode(inode)) {
                    return inode.getData();
                  } else {
                    throw ApiError3.EPERM("Invalid inode: " + inode);
                  }
                };
                ZipFS2.prototype.getCentralDirectoryEntryAt = function getCentralDirectoryEntryAt(index) {
                  var dirEntry = this._directoryEntries[index];
                  if (!dirEntry) {
                    throw new RangeError("Invalid directory index: " + index + ".");
                  }
                  return dirEntry;
                };
                ZipFS2.prototype.getNumberOfCentralDirectoryEntries = function getNumberOfCentralDirectoryEntries() {
                  return this._directoryEntries.length;
                };
                ZipFS2.prototype.getEndOfCentralDirectory = function getEndOfCentralDirectory() {
                  return this._eocd;
                };
                ZipFS2.prototype.diskSpace = function diskSpace(path$$1, cb) {
                  cb(this.data.length, 0);
                };
                ZipFS2.prototype.isReadOnly = function isReadOnly() {
                  return true;
                };
                ZipFS2.prototype.supportsLinks = function supportsLinks() {
                  return false;
                };
                ZipFS2.prototype.supportsProps = function supportsProps() {
                  return false;
                };
                ZipFS2.prototype.supportsSynch = function supportsSynch() {
                  return true;
                };
                ZipFS2.prototype.statSync = function statSync(path$$1, isLstat) {
                  var inode = this._index.getInode(path$$1);
                  if (inode === null) {
                    throw ApiError3.ENOENT(path$$1);
                  }
                  var stats;
                  if (isFileInode(inode)) {
                    stats = inode.getData().getStats();
                  } else if (isDirInode(inode)) {
                    stats = inode.getStats();
                  } else {
                    throw new ApiError3(ErrorCode5.EINVAL, "Invalid inode.");
                  }
                  return stats;
                };
                ZipFS2.prototype.openSync = function openSync(path$$1, flags, mode) {
                  if (flags.isWriteable()) {
                    throw new ApiError3(ErrorCode5.EPERM, path$$1);
                  }
                  var inode = this._index.getInode(path$$1);
                  if (!inode) {
                    throw ApiError3.ENOENT(path$$1);
                  } else if (isFileInode(inode)) {
                    var cdRecord = inode.getData();
                    var stats = cdRecord.getStats();
                    switch (flags.pathExistsAction()) {
                      case ActionType3.THROW_EXCEPTION:
                      case ActionType3.TRUNCATE_FILE:
                        throw ApiError3.EEXIST(path$$1);
                      case ActionType3.NOP:
                        return new NoSyncFile2(this, path$$1, flags, stats, cdRecord.getData());
                      default:
                        throw new ApiError3(ErrorCode5.EINVAL, "Invalid FileMode object.");
                    }
                  } else {
                    throw ApiError3.EISDIR(path$$1);
                  }
                };
                ZipFS2.prototype.readdirSync = function readdirSync(path$$1) {
                  var inode = this._index.getInode(path$$1);
                  if (!inode) {
                    throw ApiError3.ENOENT(path$$1);
                  } else if (isDirInode(inode)) {
                    return inode.getListing();
                  } else {
                    throw ApiError3.ENOTDIR(path$$1);
                  }
                };
                ZipFS2.prototype.readFileSync = function readFileSync(fname, encoding, flag) {
                  var fd = this.openSync(fname, flag, 420);
                  try {
                    var fdCast = fd;
                    var fdBuff = fdCast.getBuffer();
                    if (encoding === null) {
                      return copyingSlice2(fdBuff);
                    }
                    return fdBuff.toString(encoding);
                  } finally {
                    fd.closeSync();
                  }
                };
                ZipFS2.prototype.populateIndex = function populateIndex() {
                  var this$1 = this;
                  var eocd = this._eocd = ZipFS2.getEOCD(this.data);
                  if (eocd.diskNumber() !== eocd.cdDiskNumber()) {
                    throw new ApiError3(ErrorCode5.EINVAL, "ZipFS does not support spanned zip files.");
                  }
                  var cdPtr = eocd.cdOffset();
                  if (cdPtr === 4294967295) {
                    throw new ApiError3(ErrorCode5.EINVAL, "ZipFS does not support Zip64.");
                  }
                  var cdEnd = cdPtr + eocd.cdSize();
                  while (cdPtr < cdEnd) {
                    var cd = new CentralDirectory(this$1.data, this$1.data.slice(cdPtr));
                    cdPtr += cd.totalSize();
                    ZipFS2.addToIndex(cd, this$1._index);
                    this$1._directoryEntries.push(cd);
                  }
                };
                return ZipFS2;
              }(SynchronousFileSystem);
              ZipFS.Name = "ZipFS";
              ZipFS.Options = {
                zipData: {
                  type: "object",
                  description: "The zip file as a Buffer object.",
                  validator: bufferValidator
                },
                name: {
                  type: "string",
                  optional: true,
                  description: "The name of the zip file (optional)."
                }
              };
              ZipFS.CompressionMethod = CompressionMethod;
              ZipFS.RegisterDecompressionMethod(CompressionMethod.DEFLATE, function(data, compressedSize, uncompressedSize) {
                return arrayish2Buffer(inflateRaw(data.slice(0, compressedSize), { chunkSize: uncompressedSize }));
              });
              ZipFS.RegisterDecompressionMethod(CompressionMethod.STORED, function(data, compressedSize, uncompressedSize) {
                return copyingSlice2(data, 0, uncompressedSize);
              });
              var rockRidgeIdentifier = "IEEE_P1282";
              function getASCIIString(data, startIndex, length) {
                return data.toString("ascii", startIndex, startIndex + length).trim();
              }
              function getJolietString(data, startIndex, length) {
                if (length === 1) {
                  return String.fromCharCode(data[startIndex]);
                }
                var pairs = Math.floor(length / 2);
                var chars = new Array(pairs);
                for (var i2 = 0; i2 < pairs; i2++) {
                  var pos = startIndex + (i2 << 1);
                  chars[i2] = String.fromCharCode(data[pos + 1] | data[pos] << 8);
                }
                return chars.join("");
              }
              function getDate(data, startIndex) {
                var year = parseInt(getASCIIString(data, startIndex, 4), 10);
                var mon = parseInt(getASCIIString(data, startIndex + 4, 2), 10);
                var day = parseInt(getASCIIString(data, startIndex + 6, 2), 10);
                var hour = parseInt(getASCIIString(data, startIndex + 8, 2), 10);
                var min = parseInt(getASCIIString(data, startIndex + 10, 2), 10);
                var sec = parseInt(getASCIIString(data, startIndex + 12, 2), 10);
                var hundrethsSec = parseInt(getASCIIString(data, startIndex + 14, 2), 10);
                return new Date(year, mon, day, hour, min, sec, hundrethsSec * 100);
              }
              function getShortFormDate(data, startIndex) {
                var yearsSince1900 = data[startIndex];
                var month = data[startIndex + 1];
                var day = data[startIndex + 2];
                var hour = data[startIndex + 3];
                var minute = data[startIndex + 4];
                var second = data[startIndex + 5];
                return new Date(yearsSince1900, month - 1, day, hour, minute, second);
              }
              function constructSystemUseEntry(bigData, i2) {
                var data = bigData.slice(i2);
                var sue = new SystemUseEntry(data);
                switch (sue.signatureWord()) {
                  case 17221:
                    return new CEEntry(data);
                  case 20548:
                    return new PDEntry(data);
                  case 21328:
                    return new SPEntry(data);
                  case 21332:
                    return new STEntry(data);
                  case 17746:
                    return new EREntry(data);
                  case 17747:
                    return new ESEntry(data);
                  case 20568:
                    return new PXEntry(data);
                  case 20558:
                    return new PNEntry(data);
                  case 21324:
                    return new SLEntry(data);
                  case 20045:
                    return new NMEntry(data);
                  case 17228:
                    return new CLEntry(data);
                  case 20556:
                    return new PLEntry(data);
                  case 21061:
                    return new REEntry(data);
                  case 21574:
                    return new TFEntry(data);
                  case 21318:
                    return new SFEntry(data);
                  case 21074:
                    return new RREntry(data);
                  default:
                    return sue;
                }
              }
              function constructSystemUseEntries(data, i2, len, isoData) {
                len = len - 4;
                var entries = new Array();
                while (i2 < len) {
                  var entry = constructSystemUseEntry(data, i2);
                  var length = entry.length();
                  if (length === 0) {
                    return entries;
                  }
                  i2 += length;
                  if (entry instanceof STEntry) {
                    break;
                  }
                  if (entry instanceof CEEntry) {
                    entries = entries.concat(entry.getEntries(isoData));
                  } else {
                    entries.push(entry);
                  }
                }
                return entries;
              }
              var VolumeDescriptor = function VolumeDescriptor2(data) {
                this._data = data;
              };
              VolumeDescriptor.prototype.type = function type() {
                return this._data[0];
              };
              VolumeDescriptor.prototype.standardIdentifier = function standardIdentifier() {
                return getASCIIString(this._data, 1, 5);
              };
              VolumeDescriptor.prototype.version = function version() {
                return this._data[6];
              };
              VolumeDescriptor.prototype.data = function data() {
                return this._data.slice(7, 2048);
              };
              var PrimaryOrSupplementaryVolumeDescriptor = function(VolumeDescriptor2) {
                function PrimaryOrSupplementaryVolumeDescriptor2(data) {
                  VolumeDescriptor2.call(this, data);
                  this._root = null;
                }
                if (VolumeDescriptor2) PrimaryOrSupplementaryVolumeDescriptor2.__proto__ = VolumeDescriptor2;
                PrimaryOrSupplementaryVolumeDescriptor2.prototype = Object.create(VolumeDescriptor2 && VolumeDescriptor2.prototype);
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.constructor = PrimaryOrSupplementaryVolumeDescriptor2;
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.systemIdentifier = function systemIdentifier() {
                  return this._getString32(8);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.volumeIdentifier = function volumeIdentifier() {
                  return this._getString32(40);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.volumeSpaceSize = function volumeSpaceSize() {
                  return this._data.readUInt32LE(80);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.volumeSetSize = function volumeSetSize() {
                  return this._data.readUInt16LE(120);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.volumeSequenceNumber = function volumeSequenceNumber() {
                  return this._data.readUInt16LE(124);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.logicalBlockSize = function logicalBlockSize() {
                  return this._data.readUInt16LE(128);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.pathTableSize = function pathTableSize() {
                  return this._data.readUInt32LE(132);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.locationOfTypeLPathTable = function locationOfTypeLPathTable() {
                  return this._data.readUInt32LE(140);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.locationOfOptionalTypeLPathTable = function locationOfOptionalTypeLPathTable() {
                  return this._data.readUInt32LE(144);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.locationOfTypeMPathTable = function locationOfTypeMPathTable() {
                  return this._data.readUInt32BE(148);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.locationOfOptionalTypeMPathTable = function locationOfOptionalTypeMPathTable() {
                  return this._data.readUInt32BE(152);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.rootDirectoryEntry = function rootDirectoryEntry(isoData) {
                  if (this._root === null) {
                    this._root = this._constructRootDirectoryRecord(this._data.slice(156));
                    this._root.rootCheckForRockRidge(isoData);
                  }
                  return this._root;
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.volumeSetIdentifier = function volumeSetIdentifier() {
                  return this._getString(190, 128);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.publisherIdentifier = function publisherIdentifier() {
                  return this._getString(318, 128);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.dataPreparerIdentifier = function dataPreparerIdentifier() {
                  return this._getString(446, 128);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.applicationIdentifier = function applicationIdentifier() {
                  return this._getString(574, 128);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.copyrightFileIdentifier = function copyrightFileIdentifier() {
                  return this._getString(702, 38);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.abstractFileIdentifier = function abstractFileIdentifier() {
                  return this._getString(740, 36);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.bibliographicFileIdentifier = function bibliographicFileIdentifier() {
                  return this._getString(776, 37);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.volumeCreationDate = function volumeCreationDate() {
                  return getDate(this._data, 813);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.volumeModificationDate = function volumeModificationDate() {
                  return getDate(this._data, 830);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.volumeExpirationDate = function volumeExpirationDate() {
                  return getDate(this._data, 847);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.volumeEffectiveDate = function volumeEffectiveDate() {
                  return getDate(this._data, 864);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.fileStructureVersion = function fileStructureVersion() {
                  return this._data[881];
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.applicationUsed = function applicationUsed() {
                  return this._data.slice(883, 883 + 512);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype.reserved = function reserved() {
                  return this._data.slice(1395, 1395 + 653);
                };
                PrimaryOrSupplementaryVolumeDescriptor2.prototype._getString32 = function _getString32(idx) {
                  return this._getString(idx, 32);
                };
                return PrimaryOrSupplementaryVolumeDescriptor2;
              }(VolumeDescriptor);
              var PrimaryVolumeDescriptor = function(PrimaryOrSupplementaryVolumeDescriptor2) {
                function PrimaryVolumeDescriptor2(data) {
                  PrimaryOrSupplementaryVolumeDescriptor2.call(this, data);
                  if (this.type() !== 1) {
                    throw new ApiError3(ErrorCode5.EIO, "Invalid primary volume descriptor.");
                  }
                }
                if (PrimaryOrSupplementaryVolumeDescriptor2) PrimaryVolumeDescriptor2.__proto__ = PrimaryOrSupplementaryVolumeDescriptor2;
                PrimaryVolumeDescriptor2.prototype = Object.create(PrimaryOrSupplementaryVolumeDescriptor2 && PrimaryOrSupplementaryVolumeDescriptor2.prototype);
                PrimaryVolumeDescriptor2.prototype.constructor = PrimaryVolumeDescriptor2;
                PrimaryVolumeDescriptor2.prototype.name = function name() {
                  return "ISO9660";
                };
                PrimaryVolumeDescriptor2.prototype._constructRootDirectoryRecord = function _constructRootDirectoryRecord(data) {
                  return new ISODirectoryRecord(data, -1);
                };
                PrimaryVolumeDescriptor2.prototype._getString = function _getString(idx, len) {
                  return this._getString(idx, len);
                };
                return PrimaryVolumeDescriptor2;
              }(PrimaryOrSupplementaryVolumeDescriptor);
              var SupplementaryVolumeDescriptor = function(PrimaryOrSupplementaryVolumeDescriptor2) {
                function SupplementaryVolumeDescriptor2(data) {
                  PrimaryOrSupplementaryVolumeDescriptor2.call(this, data);
                  if (this.type() !== 2) {
                    throw new ApiError3(ErrorCode5.EIO, "Invalid supplementary volume descriptor.");
                  }
                  var escapeSequence = this.escapeSequence();
                  var third = escapeSequence[2];
                  if (escapeSequence[0] !== 37 || escapeSequence[1] !== 47 || third !== 64 && third !== 67 && third !== 69) {
                    throw new ApiError3(ErrorCode5.EIO, "Unrecognized escape sequence for SupplementaryVolumeDescriptor: " + escapeSequence.toString());
                  }
                }
                if (PrimaryOrSupplementaryVolumeDescriptor2) SupplementaryVolumeDescriptor2.__proto__ = PrimaryOrSupplementaryVolumeDescriptor2;
                SupplementaryVolumeDescriptor2.prototype = Object.create(PrimaryOrSupplementaryVolumeDescriptor2 && PrimaryOrSupplementaryVolumeDescriptor2.prototype);
                SupplementaryVolumeDescriptor2.prototype.constructor = SupplementaryVolumeDescriptor2;
                SupplementaryVolumeDescriptor2.prototype.name = function name() {
                  return "Joliet";
                };
                SupplementaryVolumeDescriptor2.prototype.escapeSequence = function escapeSequence() {
                  return this._data.slice(88, 120);
                };
                SupplementaryVolumeDescriptor2.prototype._constructRootDirectoryRecord = function _constructRootDirectoryRecord(data) {
                  return new JolietDirectoryRecord(data, -1);
                };
                SupplementaryVolumeDescriptor2.prototype._getString = function _getString(idx, len) {
                  return getJolietString(this._data, idx, len);
                };
                return SupplementaryVolumeDescriptor2;
              }(PrimaryOrSupplementaryVolumeDescriptor);
              var DirectoryRecord = function DirectoryRecord2(data, rockRidgeOffset) {
                this._suEntries = null;
                this._fileOrDir = null;
                this._data = data;
                this._rockRidgeOffset = rockRidgeOffset;
              };
              DirectoryRecord.prototype.hasRockRidge = function hasRockRidge() {
                return this._rockRidgeOffset > -1;
              };
              DirectoryRecord.prototype.getRockRidgeOffset = function getRockRidgeOffset() {
                return this._rockRidgeOffset;
              };
              DirectoryRecord.prototype.rootCheckForRockRidge = function rootCheckForRockRidge(isoData) {
                var dir = this.getDirectory(isoData);
                this._rockRidgeOffset = dir.getDotEntry(isoData)._getRockRidgeOffset(isoData);
                if (this._rockRidgeOffset > -1) {
                  this._fileOrDir = null;
                }
              };
              DirectoryRecord.prototype.length = function length() {
                return this._data[0];
              };
              DirectoryRecord.prototype.extendedAttributeRecordLength = function extendedAttributeRecordLength() {
                return this._data[1];
              };
              DirectoryRecord.prototype.lba = function lba() {
                return this._data.readUInt32LE(2) * 2048;
              };
              DirectoryRecord.prototype.dataLength = function dataLength() {
                return this._data.readUInt32LE(10);
              };
              DirectoryRecord.prototype.recordingDate = function recordingDate() {
                return getShortFormDate(this._data, 18);
              };
              DirectoryRecord.prototype.fileFlags = function fileFlags() {
                return this._data[25];
              };
              DirectoryRecord.prototype.fileUnitSize = function fileUnitSize() {
                return this._data[26];
              };
              DirectoryRecord.prototype.interleaveGapSize = function interleaveGapSize() {
                return this._data[27];
              };
              DirectoryRecord.prototype.volumeSequenceNumber = function volumeSequenceNumber() {
                return this._data.readUInt16LE(28);
              };
              DirectoryRecord.prototype.identifier = function identifier() {
                return this._getString(33, this._data[32]);
              };
              DirectoryRecord.prototype.fileName = function fileName(isoData) {
                if (this.hasRockRidge()) {
                  var fn = this._rockRidgeFilename(isoData);
                  if (fn !== null) {
                    return fn;
                  }
                }
                var ident = this.identifier();
                if (this.isDirectory(isoData)) {
                  return ident;
                }
                var versionSeparator = ident.indexOf(";");
                if (versionSeparator === -1) {
                  return ident;
                } else if (ident[versionSeparator - 1] === ".") {
                  return ident.slice(0, versionSeparator - 1);
                } else {
                  return ident.slice(0, versionSeparator);
                }
              };
              DirectoryRecord.prototype.isDirectory = function isDirectory(isoData) {
                var rv = !!(this.fileFlags() & 2);
                if (!rv && this.hasRockRidge()) {
                  rv = this.getSUEntries(isoData).filter(function(e) {
                    return e instanceof CLEntry;
                  }).length > 0;
                }
                return rv;
              };
              DirectoryRecord.prototype.isSymlink = function isSymlink(isoData) {
                return this.hasRockRidge() && this.getSUEntries(isoData).filter(function(e) {
                  return e instanceof SLEntry;
                }).length > 0;
              };
              DirectoryRecord.prototype.getSymlinkPath = function getSymlinkPath(isoData) {
                var p = "";
                var entries = this.getSUEntries(isoData);
                var getStr = this._getGetString();
                for (var i2 = 0, list2 = entries; i2 < list2.length; i2 += 1) {
                  var entry = list2[i2];
                  if (entry instanceof SLEntry) {
                    var components = entry.componentRecords();
                    for (var i$12 = 0, list$1 = components; i$12 < list$1.length; i$12 += 1) {
                      var component = list$1[i$12];
                      var flags = component.flags();
                      if (flags & 2) {
                        p += "./";
                      } else if (flags & 4) {
                        p += "../";
                      } else if (flags & 8) {
                        p += "/";
                      } else {
                        p += component.content(getStr);
                        if (!(flags & 1)) {
                          p += "/";
                        }
                      }
                    }
                    if (!entry.continueFlag()) {
                      break;
                    }
                  }
                }
                if (p.length > 1 && p[p.length - 1] === "/") {
                  return p.slice(0, p.length - 1);
                } else {
                  return p;
                }
              };
              DirectoryRecord.prototype.getFile = function getFile(isoData) {
                if (this.isDirectory(isoData)) {
                  throw new Error("Tried to get a File from a directory.");
                }
                if (this._fileOrDir === null) {
                  this._fileOrDir = isoData.slice(this.lba(), this.lba() + this.dataLength());
                }
                return this._fileOrDir;
              };
              DirectoryRecord.prototype.getDirectory = function getDirectory(isoData) {
                if (!this.isDirectory(isoData)) {
                  throw new Error("Tried to get a Directory from a file.");
                }
                if (this._fileOrDir === null) {
                  this._fileOrDir = this._constructDirectory(isoData);
                }
                return this._fileOrDir;
              };
              DirectoryRecord.prototype.getSUEntries = function getSUEntries(isoData) {
                if (!this._suEntries) {
                  this._constructSUEntries(isoData);
                }
                return this._suEntries;
              };
              DirectoryRecord.prototype._rockRidgeFilename = function _rockRidgeFilename(isoData) {
                var nmEntries = this.getSUEntries(isoData).filter(function(e2) {
                  return e2 instanceof NMEntry;
                });
                if (nmEntries.length === 0 || nmEntries[0].flags() & (2 | 4)) {
                  return null;
                }
                var str = "";
                var getString = this._getGetString();
                for (var i2 = 0, list2 = nmEntries; i2 < list2.length; i2 += 1) {
                  var e = list2[i2];
                  str += e.name(getString);
                  if (!(e.flags() & 1)) {
                    break;
                  }
                }
                return str;
              };
              DirectoryRecord.prototype._constructSUEntries = function _constructSUEntries(isoData) {
                var i2 = 33 + this._data[32];
                if (i2 % 2 === 1) {
                  i2++;
                }
                i2 += this._rockRidgeOffset;
                this._suEntries = constructSystemUseEntries(this._data, i2, this.length(), isoData);
              };
              DirectoryRecord.prototype._getRockRidgeOffset = function _getRockRidgeOffset(isoData) {
                this._rockRidgeOffset = 0;
                var suEntries = this.getSUEntries(isoData);
                if (suEntries.length > 0) {
                  var spEntry = suEntries[0];
                  if (spEntry instanceof SPEntry && spEntry.checkBytesPass()) {
                    for (var i2 = 1; i2 < suEntries.length; i2++) {
                      var entry = suEntries[i2];
                      if (entry instanceof RREntry || entry instanceof EREntry && entry.extensionIdentifier() === rockRidgeIdentifier) {
                        return spEntry.bytesSkipped();
                      }
                    }
                  }
                }
                this._rockRidgeOffset = -1;
                return -1;
              };
              var ISODirectoryRecord = function(DirectoryRecord2) {
                function ISODirectoryRecord2(data, rockRidgeOffset) {
                  DirectoryRecord2.call(this, data, rockRidgeOffset);
                }
                if (DirectoryRecord2) ISODirectoryRecord2.__proto__ = DirectoryRecord2;
                ISODirectoryRecord2.prototype = Object.create(DirectoryRecord2 && DirectoryRecord2.prototype);
                ISODirectoryRecord2.prototype.constructor = ISODirectoryRecord2;
                ISODirectoryRecord2.prototype._getString = function _getString(i2, len) {
                  return getASCIIString(this._data, i2, len);
                };
                ISODirectoryRecord2.prototype._constructDirectory = function _constructDirectory(isoData) {
                  return new ISODirectory(this, isoData);
                };
                ISODirectoryRecord2.prototype._getGetString = function _getGetString() {
                  return getASCIIString;
                };
                return ISODirectoryRecord2;
              }(DirectoryRecord);
              var JolietDirectoryRecord = function(DirectoryRecord2) {
                function JolietDirectoryRecord2(data, rockRidgeOffset) {
                  DirectoryRecord2.call(this, data, rockRidgeOffset);
                }
                if (DirectoryRecord2) JolietDirectoryRecord2.__proto__ = DirectoryRecord2;
                JolietDirectoryRecord2.prototype = Object.create(DirectoryRecord2 && DirectoryRecord2.prototype);
                JolietDirectoryRecord2.prototype.constructor = JolietDirectoryRecord2;
                JolietDirectoryRecord2.prototype._getString = function _getString(i2, len) {
                  return getJolietString(this._data, i2, len);
                };
                JolietDirectoryRecord2.prototype._constructDirectory = function _constructDirectory(isoData) {
                  return new JolietDirectory(this, isoData);
                };
                JolietDirectoryRecord2.prototype._getGetString = function _getGetString() {
                  return getJolietString;
                };
                return JolietDirectoryRecord2;
              }(DirectoryRecord);
              var SystemUseEntry = function SystemUseEntry2(data) {
                this._data = data;
              };
              SystemUseEntry.prototype.signatureWord = function signatureWord() {
                return this._data.readUInt16BE(0);
              };
              SystemUseEntry.prototype.signatureWordString = function signatureWordString() {
                return getASCIIString(this._data, 0, 2);
              };
              SystemUseEntry.prototype.length = function length() {
                return this._data[2];
              };
              SystemUseEntry.prototype.suVersion = function suVersion() {
                return this._data[3];
              };
              var CEEntry = function(SystemUseEntry2) {
                function CEEntry2(data) {
                  SystemUseEntry2.call(this, data);
                  this._entries = null;
                }
                if (SystemUseEntry2) CEEntry2.__proto__ = SystemUseEntry2;
                CEEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                CEEntry2.prototype.constructor = CEEntry2;
                CEEntry2.prototype.continuationLba = function continuationLba() {
                  return this._data.readUInt32LE(4);
                };
                CEEntry2.prototype.continuationLbaOffset = function continuationLbaOffset() {
                  return this._data.readUInt32LE(12);
                };
                CEEntry2.prototype.continuationLength = function continuationLength() {
                  return this._data.readUInt32LE(20);
                };
                CEEntry2.prototype.getEntries = function getEntries(isoData) {
                  if (!this._entries) {
                    var start2 = this.continuationLba() * 2048 + this.continuationLbaOffset();
                    this._entries = constructSystemUseEntries(isoData, start2, this.continuationLength(), isoData);
                  }
                  return this._entries;
                };
                return CEEntry2;
              }(SystemUseEntry);
              var PDEntry = function(SystemUseEntry2) {
                function PDEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) PDEntry2.__proto__ = SystemUseEntry2;
                PDEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                PDEntry2.prototype.constructor = PDEntry2;
                return PDEntry2;
              }(SystemUseEntry);
              var SPEntry = function(SystemUseEntry2) {
                function SPEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) SPEntry2.__proto__ = SystemUseEntry2;
                SPEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                SPEntry2.prototype.constructor = SPEntry2;
                SPEntry2.prototype.checkBytesPass = function checkBytesPass() {
                  return this._data[4] === 190 && this._data[5] === 239;
                };
                SPEntry2.prototype.bytesSkipped = function bytesSkipped() {
                  return this._data[6];
                };
                return SPEntry2;
              }(SystemUseEntry);
              var STEntry = function(SystemUseEntry2) {
                function STEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) STEntry2.__proto__ = SystemUseEntry2;
                STEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                STEntry2.prototype.constructor = STEntry2;
                return STEntry2;
              }(SystemUseEntry);
              var EREntry = function(SystemUseEntry2) {
                function EREntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) EREntry2.__proto__ = SystemUseEntry2;
                EREntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                EREntry2.prototype.constructor = EREntry2;
                EREntry2.prototype.identifierLength = function identifierLength() {
                  return this._data[4];
                };
                EREntry2.prototype.descriptorLength = function descriptorLength() {
                  return this._data[5];
                };
                EREntry2.prototype.sourceLength = function sourceLength() {
                  return this._data[6];
                };
                EREntry2.prototype.extensionVersion = function extensionVersion() {
                  return this._data[7];
                };
                EREntry2.prototype.extensionIdentifier = function extensionIdentifier() {
                  return getASCIIString(this._data, 8, this.identifierLength());
                };
                EREntry2.prototype.extensionDescriptor = function extensionDescriptor() {
                  return getASCIIString(this._data, 8 + this.identifierLength(), this.descriptorLength());
                };
                EREntry2.prototype.extensionSource = function extensionSource() {
                  return getASCIIString(this._data, 8 + this.identifierLength() + this.descriptorLength(), this.sourceLength());
                };
                return EREntry2;
              }(SystemUseEntry);
              var ESEntry = function(SystemUseEntry2) {
                function ESEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) ESEntry2.__proto__ = SystemUseEntry2;
                ESEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                ESEntry2.prototype.constructor = ESEntry2;
                ESEntry2.prototype.extensionSequence = function extensionSequence() {
                  return this._data[4];
                };
                return ESEntry2;
              }(SystemUseEntry);
              var RREntry = function(SystemUseEntry2) {
                function RREntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) RREntry2.__proto__ = SystemUseEntry2;
                RREntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                RREntry2.prototype.constructor = RREntry2;
                return RREntry2;
              }(SystemUseEntry);
              var PXEntry = function(SystemUseEntry2) {
                function PXEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) PXEntry2.__proto__ = SystemUseEntry2;
                PXEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                PXEntry2.prototype.constructor = PXEntry2;
                PXEntry2.prototype.mode = function mode() {
                  return this._data.readUInt32LE(4);
                };
                PXEntry2.prototype.fileLinks = function fileLinks() {
                  return this._data.readUInt32LE(12);
                };
                PXEntry2.prototype.uid = function uid() {
                  return this._data.readUInt32LE(20);
                };
                PXEntry2.prototype.gid = function gid() {
                  return this._data.readUInt32LE(28);
                };
                PXEntry2.prototype.inode = function inode() {
                  return this._data.readUInt32LE(36);
                };
                return PXEntry2;
              }(SystemUseEntry);
              var PNEntry = function(SystemUseEntry2) {
                function PNEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) PNEntry2.__proto__ = SystemUseEntry2;
                PNEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                PNEntry2.prototype.constructor = PNEntry2;
                PNEntry2.prototype.devTHigh = function devTHigh() {
                  return this._data.readUInt32LE(4);
                };
                PNEntry2.prototype.devTLow = function devTLow() {
                  return this._data.readUInt32LE(12);
                };
                return PNEntry2;
              }(SystemUseEntry);
              var SLEntry = function(SystemUseEntry2) {
                function SLEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) SLEntry2.__proto__ = SystemUseEntry2;
                SLEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                SLEntry2.prototype.constructor = SLEntry2;
                SLEntry2.prototype.flags = function flags() {
                  return this._data[4];
                };
                SLEntry2.prototype.continueFlag = function continueFlag() {
                  return this.flags() & 1;
                };
                SLEntry2.prototype.componentRecords = function componentRecords() {
                  var this$1 = this;
                  var records = new Array();
                  var i2 = 5;
                  while (i2 < this.length()) {
                    var record = new SLComponentRecord(this$1._data.slice(i2));
                    records.push(record);
                    i2 += record.length();
                  }
                  return records;
                };
                return SLEntry2;
              }(SystemUseEntry);
              var SLComponentRecord = function SLComponentRecord2(data) {
                this._data = data;
              };
              SLComponentRecord.prototype.flags = function flags() {
                return this._data[0];
              };
              SLComponentRecord.prototype.length = function length() {
                return 2 + this.componentLength();
              };
              SLComponentRecord.prototype.componentLength = function componentLength() {
                return this._data[1];
              };
              SLComponentRecord.prototype.content = function content(getString) {
                return getString(this._data, 2, this.componentLength());
              };
              var NMEntry = function(SystemUseEntry2) {
                function NMEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) NMEntry2.__proto__ = SystemUseEntry2;
                NMEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                NMEntry2.prototype.constructor = NMEntry2;
                NMEntry2.prototype.flags = function flags() {
                  return this._data[4];
                };
                NMEntry2.prototype.name = function name(getString) {
                  return getString(this._data, 5, this.length() - 5);
                };
                return NMEntry2;
              }(SystemUseEntry);
              var CLEntry = function(SystemUseEntry2) {
                function CLEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) CLEntry2.__proto__ = SystemUseEntry2;
                CLEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                CLEntry2.prototype.constructor = CLEntry2;
                CLEntry2.prototype.childDirectoryLba = function childDirectoryLba() {
                  return this._data.readUInt32LE(4);
                };
                return CLEntry2;
              }(SystemUseEntry);
              var PLEntry = function(SystemUseEntry2) {
                function PLEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) PLEntry2.__proto__ = SystemUseEntry2;
                PLEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                PLEntry2.prototype.constructor = PLEntry2;
                PLEntry2.prototype.parentDirectoryLba = function parentDirectoryLba() {
                  return this._data.readUInt32LE(4);
                };
                return PLEntry2;
              }(SystemUseEntry);
              var REEntry = function(SystemUseEntry2) {
                function REEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) REEntry2.__proto__ = SystemUseEntry2;
                REEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                REEntry2.prototype.constructor = REEntry2;
                return REEntry2;
              }(SystemUseEntry);
              var TFEntry = function(SystemUseEntry2) {
                function TFEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) TFEntry2.__proto__ = SystemUseEntry2;
                TFEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                TFEntry2.prototype.constructor = TFEntry2;
                TFEntry2.prototype.flags = function flags() {
                  return this._data[4];
                };
                TFEntry2.prototype.creation = function creation() {
                  if (this.flags() & 1) {
                    if (this._longFormDates()) {
                      return getDate(this._data, 5);
                    } else {
                      return getShortFormDate(this._data, 5);
                    }
                  } else {
                    return null;
                  }
                };
                TFEntry2.prototype.modify = function modify() {
                  if (this.flags() & 2) {
                    var previousDates = this.flags() & 1 ? 1 : 0;
                    if (this._longFormDates) {
                      return getDate(this._data, 5 + previousDates * 17);
                    } else {
                      return getShortFormDate(this._data, 5 + previousDates * 7);
                    }
                  } else {
                    return null;
                  }
                };
                TFEntry2.prototype.access = function access() {
                  if (this.flags() & 4) {
                    var previousDates = this.flags() & 1 ? 1 : 0;
                    previousDates += this.flags() & 2 ? 1 : 0;
                    if (this._longFormDates) {
                      return getDate(this._data, 5 + previousDates * 17);
                    } else {
                      return getShortFormDate(this._data, 5 + previousDates * 7);
                    }
                  } else {
                    return null;
                  }
                };
                TFEntry2.prototype.backup = function backup() {
                  if (this.flags() & 16) {
                    var previousDates = this.flags() & 1 ? 1 : 0;
                    previousDates += this.flags() & 2 ? 1 : 0;
                    previousDates += this.flags() & 4 ? 1 : 0;
                    if (this._longFormDates) {
                      return getDate(this._data, 5 + previousDates * 17);
                    } else {
                      return getShortFormDate(this._data, 5 + previousDates * 7);
                    }
                  } else {
                    return null;
                  }
                };
                TFEntry2.prototype.expiration = function expiration() {
                  if (this.flags() & 32) {
                    var previousDates = this.flags() & 1 ? 1 : 0;
                    previousDates += this.flags() & 2 ? 1 : 0;
                    previousDates += this.flags() & 4 ? 1 : 0;
                    previousDates += this.flags() & 16 ? 1 : 0;
                    if (this._longFormDates) {
                      return getDate(this._data, 5 + previousDates * 17);
                    } else {
                      return getShortFormDate(this._data, 5 + previousDates * 7);
                    }
                  } else {
                    return null;
                  }
                };
                TFEntry2.prototype.effective = function effective() {
                  if (this.flags() & 64) {
                    var previousDates = this.flags() & 1 ? 1 : 0;
                    previousDates += this.flags() & 2 ? 1 : 0;
                    previousDates += this.flags() & 4 ? 1 : 0;
                    previousDates += this.flags() & 16 ? 1 : 0;
                    previousDates += this.flags() & 32 ? 1 : 0;
                    if (this._longFormDates) {
                      return getDate(this._data, 5 + previousDates * 17);
                    } else {
                      return getShortFormDate(this._data, 5 + previousDates * 7);
                    }
                  } else {
                    return null;
                  }
                };
                TFEntry2.prototype._longFormDates = function _longFormDates() {
                  return !!(this.flags() && 128);
                };
                return TFEntry2;
              }(SystemUseEntry);
              var SFEntry = function(SystemUseEntry2) {
                function SFEntry2(data) {
                  SystemUseEntry2.call(this, data);
                }
                if (SystemUseEntry2) SFEntry2.__proto__ = SystemUseEntry2;
                SFEntry2.prototype = Object.create(SystemUseEntry2 && SystemUseEntry2.prototype);
                SFEntry2.prototype.constructor = SFEntry2;
                SFEntry2.prototype.virtualSizeHigh = function virtualSizeHigh() {
                  return this._data.readUInt32LE(4);
                };
                SFEntry2.prototype.virtualSizeLow = function virtualSizeLow() {
                  return this._data.readUInt32LE(12);
                };
                SFEntry2.prototype.tableDepth = function tableDepth() {
                  return this._data[20];
                };
                return SFEntry2;
              }(SystemUseEntry);
              var Directory = function Directory2(record, isoData) {
                var this$1 = this;
                this._fileList = [];
                this._fileMap = {};
                this._record = record;
                var i2 = record.lba();
                var iLimit = i2 + record.dataLength();
                if (!(record.fileFlags() & 2)) {
                  var cl = record.getSUEntries(isoData).filter(function(e) {
                    return e instanceof CLEntry;
                  })[0];
                  i2 = cl.childDirectoryLba() * 2048;
                  iLimit = Infinity;
                }
                while (i2 < iLimit) {
                  var len = isoData[i2];
                  if (len === 0) {
                    i2++;
                    continue;
                  }
                  var r = this$1._constructDirectoryRecord(isoData.slice(i2));
                  var fname = r.fileName(isoData);
                  if (fname !== "\0" && fname !== "") {
                    if (!r.hasRockRidge() || r.getSUEntries(isoData).filter(function(e) {
                      return e instanceof REEntry;
                    }).length === 0) {
                      this$1._fileMap[fname] = r;
                      this$1._fileList.push(fname);
                    }
                  } else if (iLimit === Infinity) {
                    iLimit = i2 + r.dataLength();
                  }
                  i2 += r.length();
                }
              };
              Directory.prototype.getRecord = function getRecord(name) {
                return this._fileMap[name];
              };
              Directory.prototype.getFileList = function getFileList() {
                return this._fileList;
              };
              Directory.prototype.getDotEntry = function getDotEntry(isoData) {
                return this._constructDirectoryRecord(isoData.slice(this._record.lba()));
              };
              var ISODirectory = function(Directory2) {
                function ISODirectory2(record, isoData) {
                  Directory2.call(this, record, isoData);
                }
                if (Directory2) ISODirectory2.__proto__ = Directory2;
                ISODirectory2.prototype = Object.create(Directory2 && Directory2.prototype);
                ISODirectory2.prototype.constructor = ISODirectory2;
                ISODirectory2.prototype._constructDirectoryRecord = function _constructDirectoryRecord(data) {
                  return new ISODirectoryRecord(data, this._record.getRockRidgeOffset());
                };
                return ISODirectory2;
              }(Directory);
              var JolietDirectory = function(Directory2) {
                function JolietDirectory2(record, isoData) {
                  Directory2.call(this, record, isoData);
                }
                if (Directory2) JolietDirectory2.__proto__ = Directory2;
                JolietDirectory2.prototype = Object.create(Directory2 && Directory2.prototype);
                JolietDirectory2.prototype.constructor = JolietDirectory2;
                JolietDirectory2.prototype._constructDirectoryRecord = function _constructDirectoryRecord(data) {
                  return new JolietDirectoryRecord(data, this._record.getRockRidgeOffset());
                };
                return JolietDirectory2;
              }(Directory);
              var IsoFS = function(SynchronousFileSystem$$1) {
                function IsoFS2(data, name, deprecateMsg) {
                  var this$1 = this;
                  if (name === void 0) name = "";
                  if (deprecateMsg === void 0) deprecateMsg = true;
                  SynchronousFileSystem$$1.call(this);
                  this._data = data;
                  deprecationMessage(deprecateMsg, IsoFS2.Name, { data: "ISO data as a Buffer", name });
                  var vdTerminatorFound = false;
                  var i2 = 16 * 2048;
                  var candidateVDs = new Array();
                  while (!vdTerminatorFound) {
                    var slice = data.slice(i2);
                    var vd = new VolumeDescriptor(slice);
                    switch (vd.type()) {
                      case 1:
                        candidateVDs.push(new PrimaryVolumeDescriptor(slice));
                        break;
                      case 2:
                        candidateVDs.push(new SupplementaryVolumeDescriptor(slice));
                        break;
                      case 255:
                        vdTerminatorFound = true;
                        break;
                    }
                    i2 += 2048;
                  }
                  if (candidateVDs.length === 0) {
                    throw new ApiError3(ErrorCode5.EIO, "Unable to find a suitable volume descriptor.");
                  }
                  candidateVDs.forEach(function(v) {
                    if (!this$1._pvd || this$1._pvd.type() !== 2) {
                      this$1._pvd = v;
                    }
                  });
                  this._root = this._pvd.rootDirectoryEntry(data);
                  this._name = name;
                }
                if (SynchronousFileSystem$$1) IsoFS2.__proto__ = SynchronousFileSystem$$1;
                IsoFS2.prototype = Object.create(SynchronousFileSystem$$1 && SynchronousFileSystem$$1.prototype);
                IsoFS2.prototype.constructor = IsoFS2;
                IsoFS2.Create = function Create(opts, cb) {
                  var fs2;
                  var e;
                  try {
                    fs2 = new IsoFS2(opts.data, opts.name, false);
                  } catch (e2) {
                    e2 = e2;
                  } finally {
                    cb(e, fs2);
                  }
                };
                IsoFS2.isAvailable = function isAvailable() {
                  return true;
                };
                IsoFS2.prototype.getName = function getName() {
                  var name = "IsoFS" + this._name + (this._pvd ? "-" + this._pvd.name() : "");
                  if (this._root && this._root.hasRockRidge()) {
                    name += "-RockRidge";
                  }
                  return name;
                };
                IsoFS2.prototype.diskSpace = function diskSpace(path$$1, cb) {
                  cb(this._data.length, 0);
                };
                IsoFS2.prototype.isReadOnly = function isReadOnly() {
                  return true;
                };
                IsoFS2.prototype.supportsLinks = function supportsLinks() {
                  return false;
                };
                IsoFS2.prototype.supportsProps = function supportsProps() {
                  return false;
                };
                IsoFS2.prototype.supportsSynch = function supportsSynch() {
                  return true;
                };
                IsoFS2.prototype.statSync = function statSync(p, isLstat) {
                  var record = this._getDirectoryRecord(p);
                  if (record === null) {
                    throw ApiError3.ENOENT(p);
                  }
                  return this._getStats(p, record);
                };
                IsoFS2.prototype.openSync = function openSync(p, flags, mode) {
                  if (flags.isWriteable()) {
                    throw new ApiError3(ErrorCode5.EPERM, p);
                  }
                  var record = this._getDirectoryRecord(p);
                  if (!record) {
                    throw ApiError3.ENOENT(p);
                  } else if (record.isSymlink(this._data)) {
                    return this.openSync(path.resolve(p, record.getSymlinkPath(this._data)), flags, mode);
                  } else if (!record.isDirectory(this._data)) {
                    var data = record.getFile(this._data);
                    var stats = this._getStats(p, record);
                    switch (flags.pathExistsAction()) {
                      case ActionType3.THROW_EXCEPTION:
                      case ActionType3.TRUNCATE_FILE:
                        throw ApiError3.EEXIST(p);
                      case ActionType3.NOP:
                        return new NoSyncFile2(this, p, flags, stats, data);
                      default:
                        throw new ApiError3(ErrorCode5.EINVAL, "Invalid FileMode object.");
                    }
                  } else {
                    throw ApiError3.EISDIR(p);
                  }
                };
                IsoFS2.prototype.readdirSync = function readdirSync(path$$1) {
                  var record = this._getDirectoryRecord(path$$1);
                  if (!record) {
                    throw ApiError3.ENOENT(path$$1);
                  } else if (record.isDirectory(this._data)) {
                    return record.getDirectory(this._data).getFileList().slice(0);
                  } else {
                    throw ApiError3.ENOTDIR(path$$1);
                  }
                };
                IsoFS2.prototype.readFileSync = function readFileSync(fname, encoding, flag) {
                  var fd = this.openSync(fname, flag, 420);
                  try {
                    var fdCast = fd;
                    var fdBuff = fdCast.getBuffer();
                    if (encoding === null) {
                      return copyingSlice2(fdBuff);
                    }
                    return fdBuff.toString(encoding);
                  } finally {
                    fd.closeSync();
                  }
                };
                IsoFS2.prototype._getDirectoryRecord = function _getDirectoryRecord(path$$1) {
                  var this$1 = this;
                  if (path$$1 === "/") {
                    return this._root;
                  }
                  var components = path$$1.split("/").slice(1);
                  var dir = this._root;
                  for (var i2 = 0, list2 = components; i2 < list2.length; i2 += 1) {
                    var component = list2[i2];
                    if (dir.isDirectory(this$1._data)) {
                      dir = dir.getDirectory(this$1._data).getRecord(component);
                      if (!dir) {
                        return null;
                      }
                    } else {
                      return null;
                    }
                  }
                  return dir;
                };
                IsoFS2.prototype._getStats = function _getStats(p, record) {
                  if (record.isSymlink(this._data)) {
                    var newP = path.resolve(p, record.getSymlinkPath(this._data));
                    var dirRec = this._getDirectoryRecord(newP);
                    if (!dirRec) {
                      return null;
                    }
                    return this._getStats(newP, dirRec);
                  } else {
                    var len = record.dataLength();
                    var mode = 365;
                    var date = record.recordingDate();
                    var atime = date;
                    var mtime = date;
                    var ctime = date;
                    if (record.hasRockRidge()) {
                      var entries = record.getSUEntries(this._data);
                      for (var i2 = 0, list2 = entries; i2 < list2.length; i2 += 1) {
                        var entry = list2[i2];
                        if (entry instanceof PXEntry) {
                          mode = entry.mode();
                        } else if (entry instanceof TFEntry) {
                          var flags = entry.flags();
                          if (flags & 4) {
                            atime = entry.access();
                          }
                          if (flags & 2) {
                            mtime = entry.modify();
                          }
                          if (flags & 1) {
                            ctime = entry.creation();
                          }
                        }
                      }
                    }
                    mode = mode & 365;
                    return new Stats2(record.isDirectory(this._data) ? FileType5.DIRECTORY : FileType5.FILE, len, mode, atime, mtime, ctime);
                  }
                };
                return IsoFS2;
              }(SynchronousFileSystem);
              IsoFS.Name = "IsoFS";
              IsoFS.Options = {
                data: {
                  type: "object",
                  description: "The ISO file in a buffer",
                  validator: bufferValidator
                }
              };
              [AsyncMirror, DropboxFileSystem, EmscriptenFileSystem, FolderAdapter, HTML5FS, InMemoryFileSystem, IndexedDBFileSystem, IsoFS, LocalStorageFileSystem, MountableFileSystem, OverlayFS2, WorkerFS, XmlHttpRequest, ZipFS].forEach(function(fsType) {
                var create = fsType.Create;
                fsType.Create = function(opts, cb) {
                  var oneArg = typeof opts === "function";
                  var normalizedCb = oneArg ? opts : cb;
                  var normalizedOpts = oneArg ? {} : opts;
                  function wrappedCb(e) {
                    if (e) {
                      normalizedCb(e);
                    } else {
                      create.call(fsType, normalizedOpts, normalizedCb);
                    }
                  }
                  checkOptions(fsType, normalizedOpts, wrappedCb);
                };
              });
              var Backends = { AsyncMirror, Dropbox: DropboxFileSystem, Emscripten: EmscriptenFileSystem, FolderAdapter, HTML5FS, InMemory: InMemoryFileSystem, IndexedDB: IndexedDBFileSystem, IsoFS, LocalStorage: LocalStorageFileSystem, MountableFileSystem, OverlayFS: OverlayFS2, WorkerFS, XmlHttpRequest, ZipFS };
              if (process2["initializeTTYs"]) {
                process2["initializeTTYs"]();
              }
              function install2(obj) {
                obj.Buffer = Buffer2;
                obj.process = process2;
                var oldRequire = obj.require ? obj.require : null;
                obj.require = function(arg) {
                  var rv = BFSRequire2(arg);
                  if (!rv) {
                    return oldRequire.apply(null, Array.prototype.slice.call(arguments, 0));
                  } else {
                    return rv;
                  }
                };
              }
              function registerFileSystem(name, fs2) {
                Backends[name] = fs2;
              }
              function BFSRequire2(module5) {
                switch (module5) {
                  case "fs":
                    return _fsMock;
                  case "path":
                    return path;
                  case "buffer":
                    return buffer;
                  case "process":
                    return process2;
                  case "bfs_utils":
                    return BFSUtils;
                  default:
                    return Backends[module5];
                }
              }
              function initialize2(rootfs) {
                return _fsMock.initialize(rootfs);
              }
              function configure(config, cb) {
                getFileSystem(config, function(e, fs2) {
                  if (fs2) {
                    initialize2(fs2);
                    cb();
                  } else {
                    cb(e);
                  }
                });
              }
              function getFileSystem(config, cb) {
                var fsName = config["fs"];
                if (!fsName) {
                  return cb(new ApiError3(ErrorCode5.EPERM, 'Missing "fs" property on configuration object.'));
                }
                var options = config["options"];
                var waitCount = 0;
                var called = false;
                function finish() {
                  if (!called) {
                    called = true;
                    var fsc = Backends[fsName];
                    if (!fsc) {
                      cb(new ApiError3(ErrorCode5.EPERM, "File system " + fsName + " is not available in BrowserFS."));
                    } else {
                      fsc.Create(options, cb);
                    }
                  }
                }
                if (options !== null && typeof options === "object") {
                  var finishedIterating = false;
                  var props = Object.keys(options).filter(function(k) {
                    return k !== "fs";
                  });
                  props.forEach(function(p) {
                    var d = options[p];
                    if (d !== null && typeof d === "object" && d["fs"]) {
                      waitCount++;
                      getFileSystem(d, function(e, fs2) {
                        waitCount--;
                        if (e) {
                          if (called) {
                            return;
                          }
                          called = true;
                          cb(e);
                        } else {
                          options[p] = fs2;
                          if (waitCount === 0 && finishedIterating) {
                            finish();
                          }
                        }
                      });
                    }
                  });
                  finishedIterating = true;
                }
                if (waitCount === 0) {
                  finish();
                }
              }
              if ("ab".substr(-1) !== "b") {
                String.prototype.substr = /* @__PURE__ */ function(substr2) {
                  return function(start2, length) {
                    if (start2 < 0) {
                      start2 = this.length + start2;
                    }
                    return substr2.call(this, start2, length);
                  };
                }(String.prototype.substr);
              }
              if (typeof ArrayBuffer !== "undefined" && typeof Uint8Array !== "undefined") {
                if (!Uint8Array.prototype["slice"]) {
                  Uint8Array.prototype.slice = function(start2, end) {
                    if (start2 === void 0) start2 = 0;
                    if (end === void 0) end = this.length;
                    var self2 = this;
                    if (start2 < 0) {
                      start2 = this.length + start2;
                      if (start2 < 0) {
                        start2 = 0;
                      }
                    }
                    if (end < 0) {
                      end = this.length + end;
                      if (end < 0) {
                        end = 0;
                      }
                    }
                    if (end < start2) {
                      end = start2;
                    }
                    return new Uint8Array(self2.buffer, self2.byteOffset + start2, end - start2);
                  };
                }
              }
              exports2.install = install2;
              exports2.registerFileSystem = registerFileSystem;
              exports2.BFSRequire = BFSRequire2;
              exports2.initialize = initialize2;
              exports2.configure = configure;
              exports2.getFileSystem = getFileSystem;
              exports2.EmscriptenFS = BFSEmscriptenFS;
              exports2.FileSystem = Backends;
              exports2.Errors = api_error;
              exports2.setImmediate = setImmediate$3;
            }).call(exports2, __webpack_require__(1), /* @__PURE__ */ function() {
              return this;
            }(), __webpack_require__(5)(module3), __webpack_require__(6));
          },
          /* 1 */
          /***/
          function(module3, exports2, __webpack_require__) {
            module3.exports = __webpack_require__(2).Buffer;
          },
          /* 2 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(Buffer2) {
              "use strict";
              var base64 = __webpack_require__(3);
              var ieee754 = __webpack_require__(4);
              exports2.Buffer = Buffer2;
              exports2.SlowBuffer = SlowBuffer;
              exports2.INSPECT_MAX_BYTES = 50;
              var K_MAX_LENGTH = 2147483647;
              exports2.kMaxLength = K_MAX_LENGTH;
              Buffer2.TYPED_ARRAY_SUPPORT = typedArraySupport();
              if (!Buffer2.TYPED_ARRAY_SUPPORT && typeof console !== "undefined" && typeof console.error === "function") {
                console.error(
                  "This browser lacks typed array (Uint8Array) support which is required by `buffer` v5.x. Use `buffer` v4.x if you require old browser support."
                );
              }
              function typedArraySupport() {
                try {
                  var arr = new Uint8Array(1);
                  arr.__proto__ = { __proto__: Uint8Array.prototype, foo: function() {
                    return 42;
                  } };
                  return arr.foo() === 42;
                } catch (e) {
                  return false;
                }
              }
              function createBuffer(length) {
                if (length > K_MAX_LENGTH) {
                  throw new RangeError("Invalid typed array length");
                }
                var buf = new Uint8Array(length);
                buf.__proto__ = Buffer2.prototype;
                return buf;
              }
              function Buffer2(arg, encodingOrOffset, length) {
                if (typeof arg === "number") {
                  if (typeof encodingOrOffset === "string") {
                    throw new Error(
                      "If encoding is specified then the first argument must be a string"
                    );
                  }
                  return allocUnsafe(arg);
                }
                return from(arg, encodingOrOffset, length);
              }
              if (typeof Symbol !== "undefined" && Symbol.species && Buffer2[Symbol.species] === Buffer2) {
                Object.defineProperty(Buffer2, Symbol.species, {
                  value: null,
                  configurable: true,
                  enumerable: false,
                  writable: false
                });
              }
              Buffer2.poolSize = 8192;
              function from(value, encodingOrOffset, length) {
                if (typeof value === "number") {
                  throw new TypeError('"value" argument must not be a number');
                }
                if (isArrayBuffer(value)) {
                  return fromArrayBuffer(value, encodingOrOffset, length);
                }
                if (typeof value === "string") {
                  return fromString(value, encodingOrOffset);
                }
                return fromObject(value);
              }
              Buffer2.from = function(value, encodingOrOffset, length) {
                return from(value, encodingOrOffset, length);
              };
              Buffer2.prototype.__proto__ = Uint8Array.prototype;
              Buffer2.__proto__ = Uint8Array;
              function assertSize(size) {
                if (typeof size !== "number") {
                  throw new TypeError('"size" argument must be a number');
                } else if (size < 0) {
                  throw new RangeError('"size" argument must not be negative');
                }
              }
              function alloc(size, fill, encoding) {
                assertSize(size);
                if (size <= 0) {
                  return createBuffer(size);
                }
                if (fill !== void 0) {
                  return typeof encoding === "string" ? createBuffer(size).fill(fill, encoding) : createBuffer(size).fill(fill);
                }
                return createBuffer(size);
              }
              Buffer2.alloc = function(size, fill, encoding) {
                return alloc(size, fill, encoding);
              };
              function allocUnsafe(size) {
                assertSize(size);
                return createBuffer(size < 0 ? 0 : checked(size) | 0);
              }
              Buffer2.allocUnsafe = function(size) {
                return allocUnsafe(size);
              };
              Buffer2.allocUnsafeSlow = function(size) {
                return allocUnsafe(size);
              };
              function fromString(string, encoding) {
                if (typeof encoding !== "string" || encoding === "") {
                  encoding = "utf8";
                }
                if (!Buffer2.isEncoding(encoding)) {
                  throw new TypeError('"encoding" must be a valid string encoding');
                }
                var length = byteLength(string, encoding) | 0;
                var buf = createBuffer(length);
                var actual = buf.write(string, encoding);
                if (actual !== length) {
                  buf = buf.slice(0, actual);
                }
                return buf;
              }
              function fromArrayLike(array) {
                var length = array.length < 0 ? 0 : checked(array.length) | 0;
                var buf = createBuffer(length);
                for (var i = 0; i < length; i += 1) {
                  buf[i] = array[i] & 255;
                }
                return buf;
              }
              function fromArrayBuffer(array, byteOffset, length) {
                if (byteOffset < 0 || array.byteLength < byteOffset) {
                  throw new RangeError("'offset' is out of bounds");
                }
                if (array.byteLength < byteOffset + (length || 0)) {
                  throw new RangeError("'length' is out of bounds");
                }
                var buf;
                if (byteOffset === void 0 && length === void 0) {
                  buf = new Uint8Array(array);
                } else if (length === void 0) {
                  buf = new Uint8Array(array, byteOffset);
                } else {
                  buf = new Uint8Array(array, byteOffset, length);
                }
                buf.__proto__ = Buffer2.prototype;
                return buf;
              }
              function fromObject(obj) {
                if (Buffer2.isBuffer(obj)) {
                  var len = checked(obj.length) | 0;
                  var buf = createBuffer(len);
                  if (buf.length === 0) {
                    return buf;
                  }
                  obj.copy(buf, 0, 0, len);
                  return buf;
                }
                if (obj) {
                  if (isArrayBufferView(obj) || "length" in obj) {
                    if (typeof obj.length !== "number" || numberIsNaN(obj.length)) {
                      return createBuffer(0);
                    }
                    return fromArrayLike(obj);
                  }
                  if (obj.type === "Buffer" && Array.isArray(obj.data)) {
                    return fromArrayLike(obj.data);
                  }
                }
                throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.");
              }
              function checked(length) {
                if (length >= K_MAX_LENGTH) {
                  throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x" + K_MAX_LENGTH.toString(16) + " bytes");
                }
                return length | 0;
              }
              function SlowBuffer(length) {
                if (+length != length) {
                  length = 0;
                }
                return Buffer2.alloc(+length);
              }
              Buffer2.isBuffer = function isBuffer(b) {
                return b != null && b._isBuffer === true;
              };
              Buffer2.compare = function compare(a, b) {
                if (!Buffer2.isBuffer(a) || !Buffer2.isBuffer(b)) {
                  throw new TypeError("Arguments must be Buffers");
                }
                if (a === b) return 0;
                var x = a.length;
                var y = b.length;
                for (var i = 0, len = Math.min(x, y); i < len; ++i) {
                  if (a[i] !== b[i]) {
                    x = a[i];
                    y = b[i];
                    break;
                  }
                }
                if (x < y) return -1;
                if (y < x) return 1;
                return 0;
              };
              Buffer2.isEncoding = function isEncoding(encoding) {
                switch (String(encoding).toLowerCase()) {
                  case "hex":
                  case "utf8":
                  case "utf-8":
                  case "ascii":
                  case "latin1":
                  case "binary":
                  case "base64":
                  case "ucs2":
                  case "ucs-2":
                  case "utf16le":
                  case "utf-16le":
                    return true;
                  default:
                    return false;
                }
              };
              Buffer2.concat = function concat(list, length) {
                if (!Array.isArray(list)) {
                  throw new TypeError('"list" argument must be an Array of Buffers');
                }
                if (list.length === 0) {
                  return Buffer2.alloc(0);
                }
                var i;
                if (length === void 0) {
                  length = 0;
                  for (i = 0; i < list.length; ++i) {
                    length += list[i].length;
                  }
                }
                var buffer = Buffer2.allocUnsafe(length);
                var pos = 0;
                for (i = 0; i < list.length; ++i) {
                  var buf = list[i];
                  if (!Buffer2.isBuffer(buf)) {
                    throw new TypeError('"list" argument must be an Array of Buffers');
                  }
                  buf.copy(buffer, pos);
                  pos += buf.length;
                }
                return buffer;
              };
              function byteLength(string, encoding) {
                if (Buffer2.isBuffer(string)) {
                  return string.length;
                }
                if (isArrayBufferView(string) || isArrayBuffer(string)) {
                  return string.byteLength;
                }
                if (typeof string !== "string") {
                  string = "" + string;
                }
                var len = string.length;
                if (len === 0) return 0;
                var loweredCase = false;
                for (; ; ) {
                  switch (encoding) {
                    case "ascii":
                    case "latin1":
                    case "binary":
                      return len;
                    case "utf8":
                    case "utf-8":
                    case void 0:
                      return utf8ToBytes(string).length;
                    case "ucs2":
                    case "ucs-2":
                    case "utf16le":
                    case "utf-16le":
                      return len * 2;
                    case "hex":
                      return len >>> 1;
                    case "base64":
                      return base64ToBytes(string).length;
                    default:
                      if (loweredCase) return utf8ToBytes(string).length;
                      encoding = ("" + encoding).toLowerCase();
                      loweredCase = true;
                  }
                }
              }
              Buffer2.byteLength = byteLength;
              function slowToString(encoding, start2, end) {
                var loweredCase = false;
                if (start2 === void 0 || start2 < 0) {
                  start2 = 0;
                }
                if (start2 > this.length) {
                  return "";
                }
                if (end === void 0 || end > this.length) {
                  end = this.length;
                }
                if (end <= 0) {
                  return "";
                }
                end >>>= 0;
                start2 >>>= 0;
                if (end <= start2) {
                  return "";
                }
                if (!encoding) encoding = "utf8";
                while (true) {
                  switch (encoding) {
                    case "hex":
                      return hexSlice(this, start2, end);
                    case "utf8":
                    case "utf-8":
                      return utf8Slice(this, start2, end);
                    case "ascii":
                      return asciiSlice(this, start2, end);
                    case "latin1":
                    case "binary":
                      return latin1Slice(this, start2, end);
                    case "base64":
                      return base64Slice(this, start2, end);
                    case "ucs2":
                    case "ucs-2":
                    case "utf16le":
                    case "utf-16le":
                      return utf16leSlice(this, start2, end);
                    default:
                      if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
                      encoding = (encoding + "").toLowerCase();
                      loweredCase = true;
                  }
                }
              }
              Buffer2.prototype._isBuffer = true;
              function swap(b, n, m) {
                var i = b[n];
                b[n] = b[m];
                b[m] = i;
              }
              Buffer2.prototype.swap16 = function swap16() {
                var len = this.length;
                if (len % 2 !== 0) {
                  throw new RangeError("Buffer size must be a multiple of 16-bits");
                }
                for (var i = 0; i < len; i += 2) {
                  swap(this, i, i + 1);
                }
                return this;
              };
              Buffer2.prototype.swap32 = function swap32() {
                var len = this.length;
                if (len % 4 !== 0) {
                  throw new RangeError("Buffer size must be a multiple of 32-bits");
                }
                for (var i = 0; i < len; i += 4) {
                  swap(this, i, i + 3);
                  swap(this, i + 1, i + 2);
                }
                return this;
              };
              Buffer2.prototype.swap64 = function swap64() {
                var len = this.length;
                if (len % 8 !== 0) {
                  throw new RangeError("Buffer size must be a multiple of 64-bits");
                }
                for (var i = 0; i < len; i += 8) {
                  swap(this, i, i + 7);
                  swap(this, i + 1, i + 6);
                  swap(this, i + 2, i + 5);
                  swap(this, i + 3, i + 4);
                }
                return this;
              };
              Buffer2.prototype.toString = function toString() {
                var length = this.length;
                if (length === 0) return "";
                if (arguments.length === 0) return utf8Slice(this, 0, length);
                return slowToString.apply(this, arguments);
              };
              Buffer2.prototype.equals = function equals(b) {
                if (!Buffer2.isBuffer(b)) throw new TypeError("Argument must be a Buffer");
                if (this === b) return true;
                return Buffer2.compare(this, b) === 0;
              };
              Buffer2.prototype.inspect = function inspect() {
                var str = "";
                var max = exports2.INSPECT_MAX_BYTES;
                if (this.length > 0) {
                  str = this.toString("hex", 0, max).match(/.{2}/g).join(" ");
                  if (this.length > max) str += " ... ";
                }
                return "<Buffer " + str + ">";
              };
              Buffer2.prototype.compare = function compare(target, start2, end, thisStart, thisEnd) {
                if (!Buffer2.isBuffer(target)) {
                  throw new TypeError("Argument must be a Buffer");
                }
                if (start2 === void 0) {
                  start2 = 0;
                }
                if (end === void 0) {
                  end = target ? target.length : 0;
                }
                if (thisStart === void 0) {
                  thisStart = 0;
                }
                if (thisEnd === void 0) {
                  thisEnd = this.length;
                }
                if (start2 < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
                  throw new RangeError("out of range index");
                }
                if (thisStart >= thisEnd && start2 >= end) {
                  return 0;
                }
                if (thisStart >= thisEnd) {
                  return -1;
                }
                if (start2 >= end) {
                  return 1;
                }
                start2 >>>= 0;
                end >>>= 0;
                thisStart >>>= 0;
                thisEnd >>>= 0;
                if (this === target) return 0;
                var x = thisEnd - thisStart;
                var y = end - start2;
                var len = Math.min(x, y);
                var thisCopy = this.slice(thisStart, thisEnd);
                var targetCopy = target.slice(start2, end);
                for (var i = 0; i < len; ++i) {
                  if (thisCopy[i] !== targetCopy[i]) {
                    x = thisCopy[i];
                    y = targetCopy[i];
                    break;
                  }
                }
                if (x < y) return -1;
                if (y < x) return 1;
                return 0;
              };
              function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
                if (buffer.length === 0) return -1;
                if (typeof byteOffset === "string") {
                  encoding = byteOffset;
                  byteOffset = 0;
                } else if (byteOffset > 2147483647) {
                  byteOffset = 2147483647;
                } else if (byteOffset < -2147483648) {
                  byteOffset = -2147483648;
                }
                byteOffset = +byteOffset;
                if (numberIsNaN(byteOffset)) {
                  byteOffset = dir ? 0 : buffer.length - 1;
                }
                if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
                if (byteOffset >= buffer.length) {
                  if (dir) return -1;
                  else byteOffset = buffer.length - 1;
                } else if (byteOffset < 0) {
                  if (dir) byteOffset = 0;
                  else return -1;
                }
                if (typeof val === "string") {
                  val = Buffer2.from(val, encoding);
                }
                if (Buffer2.isBuffer(val)) {
                  if (val.length === 0) {
                    return -1;
                  }
                  return arrayIndexOf(buffer, val, byteOffset, encoding, dir);
                } else if (typeof val === "number") {
                  val = val & 255;
                  if (typeof Uint8Array.prototype.indexOf === "function") {
                    if (dir) {
                      return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset);
                    } else {
                      return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset);
                    }
                  }
                  return arrayIndexOf(buffer, [val], byteOffset, encoding, dir);
                }
                throw new TypeError("val must be string, number or Buffer");
              }
              function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
                var indexSize = 1;
                var arrLength = arr.length;
                var valLength = val.length;
                if (encoding !== void 0) {
                  encoding = String(encoding).toLowerCase();
                  if (encoding === "ucs2" || encoding === "ucs-2" || encoding === "utf16le" || encoding === "utf-16le") {
                    if (arr.length < 2 || val.length < 2) {
                      return -1;
                    }
                    indexSize = 2;
                    arrLength /= 2;
                    valLength /= 2;
                    byteOffset /= 2;
                  }
                }
                function read(buf, i2) {
                  if (indexSize === 1) {
                    return buf[i2];
                  } else {
                    return buf.readUInt16BE(i2 * indexSize);
                  }
                }
                var i;
                if (dir) {
                  var foundIndex = -1;
                  for (i = byteOffset; i < arrLength; i++) {
                    if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
                      if (foundIndex === -1) foundIndex = i;
                      if (i - foundIndex + 1 === valLength) return foundIndex * indexSize;
                    } else {
                      if (foundIndex !== -1) i -= i - foundIndex;
                      foundIndex = -1;
                    }
                  }
                } else {
                  if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
                  for (i = byteOffset; i >= 0; i--) {
                    var found = true;
                    for (var j = 0; j < valLength; j++) {
                      if (read(arr, i + j) !== read(val, j)) {
                        found = false;
                        break;
                      }
                    }
                    if (found) return i;
                  }
                }
                return -1;
              }
              Buffer2.prototype.includes = function includes(val, byteOffset, encoding) {
                return this.indexOf(val, byteOffset, encoding) !== -1;
              };
              Buffer2.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
                return bidirectionalIndexOf(this, val, byteOffset, encoding, true);
              };
              Buffer2.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
                return bidirectionalIndexOf(this, val, byteOffset, encoding, false);
              };
              function hexWrite(buf, string, offset, length) {
                offset = Number(offset) || 0;
                var remaining = buf.length - offset;
                if (!length) {
                  length = remaining;
                } else {
                  length = Number(length);
                  if (length > remaining) {
                    length = remaining;
                  }
                }
                var strLen = string.length;
                if (strLen % 2 !== 0) throw new TypeError("Invalid hex string");
                if (length > strLen / 2) {
                  length = strLen / 2;
                }
                for (var i = 0; i < length; ++i) {
                  var parsed = parseInt(string.substr(i * 2, 2), 16);
                  if (numberIsNaN(parsed)) return i;
                  buf[offset + i] = parsed;
                }
                return i;
              }
              function utf8Write(buf, string, offset, length) {
                return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
              }
              function asciiWrite(buf, string, offset, length) {
                return blitBuffer(asciiToBytes(string), buf, offset, length);
              }
              function latin1Write(buf, string, offset, length) {
                return asciiWrite(buf, string, offset, length);
              }
              function base64Write(buf, string, offset, length) {
                return blitBuffer(base64ToBytes(string), buf, offset, length);
              }
              function ucs2Write(buf, string, offset, length) {
                return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length);
              }
              Buffer2.prototype.write = function write(string, offset, length, encoding) {
                if (offset === void 0) {
                  encoding = "utf8";
                  length = this.length;
                  offset = 0;
                } else if (length === void 0 && typeof offset === "string") {
                  encoding = offset;
                  length = this.length;
                  offset = 0;
                } else if (isFinite(offset)) {
                  offset = offset >>> 0;
                  if (isFinite(length)) {
                    length = length >>> 0;
                    if (encoding === void 0) encoding = "utf8";
                  } else {
                    encoding = length;
                    length = void 0;
                  }
                } else {
                  throw new Error(
                    "Buffer.write(string, encoding, offset[, length]) is no longer supported"
                  );
                }
                var remaining = this.length - offset;
                if (length === void 0 || length > remaining) length = remaining;
                if (string.length > 0 && (length < 0 || offset < 0) || offset > this.length) {
                  throw new RangeError("Attempt to write outside buffer bounds");
                }
                if (!encoding) encoding = "utf8";
                var loweredCase = false;
                for (; ; ) {
                  switch (encoding) {
                    case "hex":
                      return hexWrite(this, string, offset, length);
                    case "utf8":
                    case "utf-8":
                      return utf8Write(this, string, offset, length);
                    case "ascii":
                      return asciiWrite(this, string, offset, length);
                    case "latin1":
                    case "binary":
                      return latin1Write(this, string, offset, length);
                    case "base64":
                      return base64Write(this, string, offset, length);
                    case "ucs2":
                    case "ucs-2":
                    case "utf16le":
                    case "utf-16le":
                      return ucs2Write(this, string, offset, length);
                    default:
                      if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
                      encoding = ("" + encoding).toLowerCase();
                      loweredCase = true;
                  }
                }
              };
              Buffer2.prototype.toJSON = function toJSON() {
                return {
                  type: "Buffer",
                  data: Array.prototype.slice.call(this._arr || this, 0)
                };
              };
              function base64Slice(buf, start2, end) {
                if (start2 === 0 && end === buf.length) {
                  return base64.fromByteArray(buf);
                } else {
                  return base64.fromByteArray(buf.slice(start2, end));
                }
              }
              function utf8Slice(buf, start2, end) {
                end = Math.min(buf.length, end);
                var res = [];
                var i = start2;
                while (i < end) {
                  var firstByte = buf[i];
                  var codePoint = null;
                  var bytesPerSequence = firstByte > 239 ? 4 : firstByte > 223 ? 3 : firstByte > 191 ? 2 : 1;
                  if (i + bytesPerSequence <= end) {
                    var secondByte, thirdByte, fourthByte, tempCodePoint;
                    switch (bytesPerSequence) {
                      case 1:
                        if (firstByte < 128) {
                          codePoint = firstByte;
                        }
                        break;
                      case 2:
                        secondByte = buf[i + 1];
                        if ((secondByte & 192) === 128) {
                          tempCodePoint = (firstByte & 31) << 6 | secondByte & 63;
                          if (tempCodePoint > 127) {
                            codePoint = tempCodePoint;
                          }
                        }
                        break;
                      case 3:
                        secondByte = buf[i + 1];
                        thirdByte = buf[i + 2];
                        if ((secondByte & 192) === 128 && (thirdByte & 192) === 128) {
                          tempCodePoint = (firstByte & 15) << 12 | (secondByte & 63) << 6 | thirdByte & 63;
                          if (tempCodePoint > 2047 && (tempCodePoint < 55296 || tempCodePoint > 57343)) {
                            codePoint = tempCodePoint;
                          }
                        }
                        break;
                      case 4:
                        secondByte = buf[i + 1];
                        thirdByte = buf[i + 2];
                        fourthByte = buf[i + 3];
                        if ((secondByte & 192) === 128 && (thirdByte & 192) === 128 && (fourthByte & 192) === 128) {
                          tempCodePoint = (firstByte & 15) << 18 | (secondByte & 63) << 12 | (thirdByte & 63) << 6 | fourthByte & 63;
                          if (tempCodePoint > 65535 && tempCodePoint < 1114112) {
                            codePoint = tempCodePoint;
                          }
                        }
                    }
                  }
                  if (codePoint === null) {
                    codePoint = 65533;
                    bytesPerSequence = 1;
                  } else if (codePoint > 65535) {
                    codePoint -= 65536;
                    res.push(codePoint >>> 10 & 1023 | 55296);
                    codePoint = 56320 | codePoint & 1023;
                  }
                  res.push(codePoint);
                  i += bytesPerSequence;
                }
                return decodeCodePointsArray(res);
              }
              var MAX_ARGUMENTS_LENGTH = 4096;
              function decodeCodePointsArray(codePoints) {
                var len = codePoints.length;
                if (len <= MAX_ARGUMENTS_LENGTH) {
                  return String.fromCharCode.apply(String, codePoints);
                }
                var res = "";
                var i = 0;
                while (i < len) {
                  res += String.fromCharCode.apply(
                    String,
                    codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
                  );
                }
                return res;
              }
              function asciiSlice(buf, start2, end) {
                var ret = "";
                end = Math.min(buf.length, end);
                for (var i = start2; i < end; ++i) {
                  ret += String.fromCharCode(buf[i] & 127);
                }
                return ret;
              }
              function latin1Slice(buf, start2, end) {
                var ret = "";
                end = Math.min(buf.length, end);
                for (var i = start2; i < end; ++i) {
                  ret += String.fromCharCode(buf[i]);
                }
                return ret;
              }
              function hexSlice(buf, start2, end) {
                var len = buf.length;
                if (!start2 || start2 < 0) start2 = 0;
                if (!end || end < 0 || end > len) end = len;
                var out = "";
                for (var i = start2; i < end; ++i) {
                  out += toHex(buf[i]);
                }
                return out;
              }
              function utf16leSlice(buf, start2, end) {
                var bytes = buf.slice(start2, end);
                var res = "";
                for (var i = 0; i < bytes.length; i += 2) {
                  res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
                }
                return res;
              }
              Buffer2.prototype.slice = function slice(start2, end) {
                var len = this.length;
                start2 = ~~start2;
                end = end === void 0 ? len : ~~end;
                if (start2 < 0) {
                  start2 += len;
                  if (start2 < 0) start2 = 0;
                } else if (start2 > len) {
                  start2 = len;
                }
                if (end < 0) {
                  end += len;
                  if (end < 0) end = 0;
                } else if (end > len) {
                  end = len;
                }
                if (end < start2) end = start2;
                var newBuf = this.subarray(start2, end);
                newBuf.__proto__ = Buffer2.prototype;
                return newBuf;
              };
              function checkOffset(offset, ext, length) {
                if (offset % 1 !== 0 || offset < 0) throw new RangeError("offset is not uint");
                if (offset + ext > length) throw new RangeError("Trying to access beyond buffer length");
              }
              Buffer2.prototype.readUIntLE = function readUIntLE(offset, byteLength2, noAssert) {
                offset = offset >>> 0;
                byteLength2 = byteLength2 >>> 0;
                if (!noAssert) checkOffset(offset, byteLength2, this.length);
                var val = this[offset];
                var mul = 1;
                var i = 0;
                while (++i < byteLength2 && (mul *= 256)) {
                  val += this[offset + i] * mul;
                }
                return val;
              };
              Buffer2.prototype.readUIntBE = function readUIntBE(offset, byteLength2, noAssert) {
                offset = offset >>> 0;
                byteLength2 = byteLength2 >>> 0;
                if (!noAssert) {
                  checkOffset(offset, byteLength2, this.length);
                }
                var val = this[offset + --byteLength2];
                var mul = 1;
                while (byteLength2 > 0 && (mul *= 256)) {
                  val += this[offset + --byteLength2] * mul;
                }
                return val;
              };
              Buffer2.prototype.readUInt8 = function readUInt8(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 1, this.length);
                return this[offset];
              };
              Buffer2.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 2, this.length);
                return this[offset] | this[offset + 1] << 8;
              };
              Buffer2.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 2, this.length);
                return this[offset] << 8 | this[offset + 1];
              };
              Buffer2.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 4, this.length);
                return (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + this[offset + 3] * 16777216;
              };
              Buffer2.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 4, this.length);
                return this[offset] * 16777216 + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
              };
              Buffer2.prototype.readIntLE = function readIntLE(offset, byteLength2, noAssert) {
                offset = offset >>> 0;
                byteLength2 = byteLength2 >>> 0;
                if (!noAssert) checkOffset(offset, byteLength2, this.length);
                var val = this[offset];
                var mul = 1;
                var i = 0;
                while (++i < byteLength2 && (mul *= 256)) {
                  val += this[offset + i] * mul;
                }
                mul *= 128;
                if (val >= mul) val -= Math.pow(2, 8 * byteLength2);
                return val;
              };
              Buffer2.prototype.readIntBE = function readIntBE(offset, byteLength2, noAssert) {
                offset = offset >>> 0;
                byteLength2 = byteLength2 >>> 0;
                if (!noAssert) checkOffset(offset, byteLength2, this.length);
                var i = byteLength2;
                var mul = 1;
                var val = this[offset + --i];
                while (i > 0 && (mul *= 256)) {
                  val += this[offset + --i] * mul;
                }
                mul *= 128;
                if (val >= mul) val -= Math.pow(2, 8 * byteLength2);
                return val;
              };
              Buffer2.prototype.readInt8 = function readInt8(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 1, this.length);
                if (!(this[offset] & 128)) return this[offset];
                return (255 - this[offset] + 1) * -1;
              };
              Buffer2.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 2, this.length);
                var val = this[offset] | this[offset + 1] << 8;
                return val & 32768 ? val | 4294901760 : val;
              };
              Buffer2.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 2, this.length);
                var val = this[offset + 1] | this[offset] << 8;
                return val & 32768 ? val | 4294901760 : val;
              };
              Buffer2.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 4, this.length);
                return this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
              };
              Buffer2.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 4, this.length);
                return this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
              };
              Buffer2.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 4, this.length);
                return ieee754.read(this, offset, true, 23, 4);
              };
              Buffer2.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 4, this.length);
                return ieee754.read(this, offset, false, 23, 4);
              };
              Buffer2.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 8, this.length);
                return ieee754.read(this, offset, true, 52, 8);
              };
              Buffer2.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
                offset = offset >>> 0;
                if (!noAssert) checkOffset(offset, 8, this.length);
                return ieee754.read(this, offset, false, 52, 8);
              };
              function checkInt(buf, value, offset, ext, max, min) {
                if (!Buffer2.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
                if (value > max || value < min) throw new RangeError('"value" argument is out of bounds');
                if (offset + ext > buf.length) throw new RangeError("Index out of range");
              }
              Buffer2.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength2, noAssert) {
                value = +value;
                offset = offset >>> 0;
                byteLength2 = byteLength2 >>> 0;
                if (!noAssert) {
                  var maxBytes = Math.pow(2, 8 * byteLength2) - 1;
                  checkInt(this, value, offset, byteLength2, maxBytes, 0);
                }
                var mul = 1;
                var i = 0;
                this[offset] = value & 255;
                while (++i < byteLength2 && (mul *= 256)) {
                  this[offset + i] = value / mul & 255;
                }
                return offset + byteLength2;
              };
              Buffer2.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength2, noAssert) {
                value = +value;
                offset = offset >>> 0;
                byteLength2 = byteLength2 >>> 0;
                if (!noAssert) {
                  var maxBytes = Math.pow(2, 8 * byteLength2) - 1;
                  checkInt(this, value, offset, byteLength2, maxBytes, 0);
                }
                var i = byteLength2 - 1;
                var mul = 1;
                this[offset + i] = value & 255;
                while (--i >= 0 && (mul *= 256)) {
                  this[offset + i] = value / mul & 255;
                }
                return offset + byteLength2;
              };
              Buffer2.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) checkInt(this, value, offset, 1, 255, 0);
                this[offset] = value & 255;
                return offset + 1;
              };
              Buffer2.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) checkInt(this, value, offset, 2, 65535, 0);
                this[offset] = value & 255;
                this[offset + 1] = value >>> 8;
                return offset + 2;
              };
              Buffer2.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) checkInt(this, value, offset, 2, 65535, 0);
                this[offset] = value >>> 8;
                this[offset + 1] = value & 255;
                return offset + 2;
              };
              Buffer2.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) checkInt(this, value, offset, 4, 4294967295, 0);
                this[offset + 3] = value >>> 24;
                this[offset + 2] = value >>> 16;
                this[offset + 1] = value >>> 8;
                this[offset] = value & 255;
                return offset + 4;
              };
              Buffer2.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) checkInt(this, value, offset, 4, 4294967295, 0);
                this[offset] = value >>> 24;
                this[offset + 1] = value >>> 16;
                this[offset + 2] = value >>> 8;
                this[offset + 3] = value & 255;
                return offset + 4;
              };
              Buffer2.prototype.writeIntLE = function writeIntLE(value, offset, byteLength2, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) {
                  var limit = Math.pow(2, 8 * byteLength2 - 1);
                  checkInt(this, value, offset, byteLength2, limit - 1, -limit);
                }
                var i = 0;
                var mul = 1;
                var sub = 0;
                this[offset] = value & 255;
                while (++i < byteLength2 && (mul *= 256)) {
                  if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
                    sub = 1;
                  }
                  this[offset + i] = (value / mul >> 0) - sub & 255;
                }
                return offset + byteLength2;
              };
              Buffer2.prototype.writeIntBE = function writeIntBE(value, offset, byteLength2, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) {
                  var limit = Math.pow(2, 8 * byteLength2 - 1);
                  checkInt(this, value, offset, byteLength2, limit - 1, -limit);
                }
                var i = byteLength2 - 1;
                var mul = 1;
                var sub = 0;
                this[offset + i] = value & 255;
                while (--i >= 0 && (mul *= 256)) {
                  if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
                    sub = 1;
                  }
                  this[offset + i] = (value / mul >> 0) - sub & 255;
                }
                return offset + byteLength2;
              };
              Buffer2.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) checkInt(this, value, offset, 1, 127, -128);
                if (value < 0) value = 255 + value + 1;
                this[offset] = value & 255;
                return offset + 1;
              };
              Buffer2.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) checkInt(this, value, offset, 2, 32767, -32768);
                this[offset] = value & 255;
                this[offset + 1] = value >>> 8;
                return offset + 2;
              };
              Buffer2.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) checkInt(this, value, offset, 2, 32767, -32768);
                this[offset] = value >>> 8;
                this[offset + 1] = value & 255;
                return offset + 2;
              };
              Buffer2.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) checkInt(this, value, offset, 4, 2147483647, -2147483648);
                this[offset] = value & 255;
                this[offset + 1] = value >>> 8;
                this[offset + 2] = value >>> 16;
                this[offset + 3] = value >>> 24;
                return offset + 4;
              };
              Buffer2.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) checkInt(this, value, offset, 4, 2147483647, -2147483648);
                if (value < 0) value = 4294967295 + value + 1;
                this[offset] = value >>> 24;
                this[offset + 1] = value >>> 16;
                this[offset + 2] = value >>> 8;
                this[offset + 3] = value & 255;
                return offset + 4;
              };
              function checkIEEE754(buf, value, offset, ext, max, min) {
                if (offset + ext > buf.length) throw new RangeError("Index out of range");
                if (offset < 0) throw new RangeError("Index out of range");
              }
              function writeFloat(buf, value, offset, littleEndian, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) {
                  checkIEEE754(buf, value, offset, 4, 34028234663852886e22, -34028234663852886e22);
                }
                ieee754.write(buf, value, offset, littleEndian, 23, 4);
                return offset + 4;
              }
              Buffer2.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
                return writeFloat(this, value, offset, true, noAssert);
              };
              Buffer2.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
                return writeFloat(this, value, offset, false, noAssert);
              };
              function writeDouble(buf, value, offset, littleEndian, noAssert) {
                value = +value;
                offset = offset >>> 0;
                if (!noAssert) {
                  checkIEEE754(buf, value, offset, 8, 17976931348623157e292, -17976931348623157e292);
                }
                ieee754.write(buf, value, offset, littleEndian, 52, 8);
                return offset + 8;
              }
              Buffer2.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
                return writeDouble(this, value, offset, true, noAssert);
              };
              Buffer2.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
                return writeDouble(this, value, offset, false, noAssert);
              };
              Buffer2.prototype.copy = function copy(target, targetStart, start2, end) {
                if (!start2) start2 = 0;
                if (!end && end !== 0) end = this.length;
                if (targetStart >= target.length) targetStart = target.length;
                if (!targetStart) targetStart = 0;
                if (end > 0 && end < start2) end = start2;
                if (end === start2) return 0;
                if (target.length === 0 || this.length === 0) return 0;
                if (targetStart < 0) {
                  throw new RangeError("targetStart out of bounds");
                }
                if (start2 < 0 || start2 >= this.length) throw new RangeError("sourceStart out of bounds");
                if (end < 0) throw new RangeError("sourceEnd out of bounds");
                if (end > this.length) end = this.length;
                if (target.length - targetStart < end - start2) {
                  end = target.length - targetStart + start2;
                }
                var len = end - start2;
                var i;
                if (this === target && start2 < targetStart && targetStart < end) {
                  for (i = len - 1; i >= 0; --i) {
                    target[i + targetStart] = this[i + start2];
                  }
                } else if (len < 1e3) {
                  for (i = 0; i < len; ++i) {
                    target[i + targetStart] = this[i + start2];
                  }
                } else {
                  Uint8Array.prototype.set.call(
                    target,
                    this.subarray(start2, start2 + len),
                    targetStart
                  );
                }
                return len;
              };
              Buffer2.prototype.fill = function fill(val, start2, end, encoding) {
                if (typeof val === "string") {
                  if (typeof start2 === "string") {
                    encoding = start2;
                    start2 = 0;
                    end = this.length;
                  } else if (typeof end === "string") {
                    encoding = end;
                    end = this.length;
                  }
                  if (val.length === 1) {
                    var code = val.charCodeAt(0);
                    if (code < 256) {
                      val = code;
                    }
                  }
                  if (encoding !== void 0 && typeof encoding !== "string") {
                    throw new TypeError("encoding must be a string");
                  }
                  if (typeof encoding === "string" && !Buffer2.isEncoding(encoding)) {
                    throw new TypeError("Unknown encoding: " + encoding);
                  }
                } else if (typeof val === "number") {
                  val = val & 255;
                }
                if (start2 < 0 || this.length < start2 || this.length < end) {
                  throw new RangeError("Out of range index");
                }
                if (end <= start2) {
                  return this;
                }
                start2 = start2 >>> 0;
                end = end === void 0 ? this.length : end >>> 0;
                if (!val) val = 0;
                var i;
                if (typeof val === "number") {
                  for (i = start2; i < end; ++i) {
                    this[i] = val;
                  }
                } else {
                  var bytes = Buffer2.isBuffer(val) ? val : new Buffer2(val, encoding);
                  var len = bytes.length;
                  for (i = 0; i < end - start2; ++i) {
                    this[i + start2] = bytes[i % len];
                  }
                }
                return this;
              };
              var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;
              function base64clean(str) {
                str = str.trim().replace(INVALID_BASE64_RE, "");
                if (str.length < 2) return "";
                while (str.length % 4 !== 0) {
                  str = str + "=";
                }
                return str;
              }
              function toHex(n) {
                if (n < 16) return "0" + n.toString(16);
                return n.toString(16);
              }
              function utf8ToBytes(string, units) {
                units = units || Infinity;
                var codePoint;
                var length = string.length;
                var leadSurrogate = null;
                var bytes = [];
                for (var i = 0; i < length; ++i) {
                  codePoint = string.charCodeAt(i);
                  if (codePoint > 55295 && codePoint < 57344) {
                    if (!leadSurrogate) {
                      if (codePoint > 56319) {
                        if ((units -= 3) > -1) bytes.push(239, 191, 189);
                        continue;
                      } else if (i + 1 === length) {
                        if ((units -= 3) > -1) bytes.push(239, 191, 189);
                        continue;
                      }
                      leadSurrogate = codePoint;
                      continue;
                    }
                    if (codePoint < 56320) {
                      if ((units -= 3) > -1) bytes.push(239, 191, 189);
                      leadSurrogate = codePoint;
                      continue;
                    }
                    codePoint = (leadSurrogate - 55296 << 10 | codePoint - 56320) + 65536;
                  } else if (leadSurrogate) {
                    if ((units -= 3) > -1) bytes.push(239, 191, 189);
                  }
                  leadSurrogate = null;
                  if (codePoint < 128) {
                    if ((units -= 1) < 0) break;
                    bytes.push(codePoint);
                  } else if (codePoint < 2048) {
                    if ((units -= 2) < 0) break;
                    bytes.push(
                      codePoint >> 6 | 192,
                      codePoint & 63 | 128
                    );
                  } else if (codePoint < 65536) {
                    if ((units -= 3) < 0) break;
                    bytes.push(
                      codePoint >> 12 | 224,
                      codePoint >> 6 & 63 | 128,
                      codePoint & 63 | 128
                    );
                  } else if (codePoint < 1114112) {
                    if ((units -= 4) < 0) break;
                    bytes.push(
                      codePoint >> 18 | 240,
                      codePoint >> 12 & 63 | 128,
                      codePoint >> 6 & 63 | 128,
                      codePoint & 63 | 128
                    );
                  } else {
                    throw new Error("Invalid code point");
                  }
                }
                return bytes;
              }
              function asciiToBytes(str) {
                var byteArray = [];
                for (var i = 0; i < str.length; ++i) {
                  byteArray.push(str.charCodeAt(i) & 255);
                }
                return byteArray;
              }
              function utf16leToBytes(str, units) {
                var c, hi, lo;
                var byteArray = [];
                for (var i = 0; i < str.length; ++i) {
                  if ((units -= 2) < 0) break;
                  c = str.charCodeAt(i);
                  hi = c >> 8;
                  lo = c % 256;
                  byteArray.push(lo);
                  byteArray.push(hi);
                }
                return byteArray;
              }
              function base64ToBytes(str) {
                return base64.toByteArray(base64clean(str));
              }
              function blitBuffer(src, dst, offset, length) {
                for (var i = 0; i < length; ++i) {
                  if (i + offset >= dst.length || i >= src.length) break;
                  dst[i + offset] = src[i];
                }
                return i;
              }
              function isArrayBuffer(obj) {
                return obj instanceof ArrayBuffer || obj != null && obj.constructor != null && obj.constructor.name === "ArrayBuffer" && typeof obj.byteLength === "number";
              }
              function isArrayBufferView(obj) {
                return typeof ArrayBuffer.isView === "function" && ArrayBuffer.isView(obj);
              }
              function numberIsNaN(obj) {
                return obj !== obj;
              }
            }).call(exports2, __webpack_require__(1));
          },
          /* 3 */
          /***/
          function(module3, exports2) {
            "use strict";
            exports2.byteLength = byteLength;
            exports2.toByteArray = toByteArray;
            exports2.fromByteArray = fromByteArray;
            var lookup = [];
            var revLookup = [];
            var Arr = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
            var code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
            for (var i = 0, len = code.length; i < len; ++i) {
              lookup[i] = code[i];
              revLookup[code.charCodeAt(i)] = i;
            }
            revLookup["-".charCodeAt(0)] = 62;
            revLookup["_".charCodeAt(0)] = 63;
            function placeHoldersCount(b64) {
              var len2 = b64.length;
              if (len2 % 4 > 0) {
                throw new Error("Invalid string. Length must be a multiple of 4");
              }
              return b64[len2 - 2] === "=" ? 2 : b64[len2 - 1] === "=" ? 1 : 0;
            }
            function byteLength(b64) {
              return b64.length * 3 / 4 - placeHoldersCount(b64);
            }
            function toByteArray(b64) {
              var i2, j, l, tmp, placeHolders, arr;
              var len2 = b64.length;
              placeHolders = placeHoldersCount(b64);
              arr = new Arr(len2 * 3 / 4 - placeHolders);
              l = placeHolders > 0 ? len2 - 4 : len2;
              var L = 0;
              for (i2 = 0, j = 0; i2 < l; i2 += 4, j += 3) {
                tmp = revLookup[b64.charCodeAt(i2)] << 18 | revLookup[b64.charCodeAt(i2 + 1)] << 12 | revLookup[b64.charCodeAt(i2 + 2)] << 6 | revLookup[b64.charCodeAt(i2 + 3)];
                arr[L++] = tmp >> 16 & 255;
                arr[L++] = tmp >> 8 & 255;
                arr[L++] = tmp & 255;
              }
              if (placeHolders === 2) {
                tmp = revLookup[b64.charCodeAt(i2)] << 2 | revLookup[b64.charCodeAt(i2 + 1)] >> 4;
                arr[L++] = tmp & 255;
              } else if (placeHolders === 1) {
                tmp = revLookup[b64.charCodeAt(i2)] << 10 | revLookup[b64.charCodeAt(i2 + 1)] << 4 | revLookup[b64.charCodeAt(i2 + 2)] >> 2;
                arr[L++] = tmp >> 8 & 255;
                arr[L++] = tmp & 255;
              }
              return arr;
            }
            function tripletToBase64(num) {
              return lookup[num >> 18 & 63] + lookup[num >> 12 & 63] + lookup[num >> 6 & 63] + lookup[num & 63];
            }
            function encodeChunk(uint8, start2, end) {
              var tmp;
              var output = [];
              for (var i2 = start2; i2 < end; i2 += 3) {
                tmp = (uint8[i2] << 16) + (uint8[i2 + 1] << 8) + uint8[i2 + 2];
                output.push(tripletToBase64(tmp));
              }
              return output.join("");
            }
            function fromByteArray(uint8) {
              var tmp;
              var len2 = uint8.length;
              var extraBytes = len2 % 3;
              var output = "";
              var parts = [];
              var maxChunkLength = 16383;
              for (var i2 = 0, len22 = len2 - extraBytes; i2 < len22; i2 += maxChunkLength) {
                parts.push(encodeChunk(uint8, i2, i2 + maxChunkLength > len22 ? len22 : i2 + maxChunkLength));
              }
              if (extraBytes === 1) {
                tmp = uint8[len2 - 1];
                output += lookup[tmp >> 2];
                output += lookup[tmp << 4 & 63];
                output += "==";
              } else if (extraBytes === 2) {
                tmp = (uint8[len2 - 2] << 8) + uint8[len2 - 1];
                output += lookup[tmp >> 10];
                output += lookup[tmp >> 4 & 63];
                output += lookup[tmp << 2 & 63];
                output += "=";
              }
              parts.push(output);
              return parts.join("");
            }
          },
          /* 4 */
          /***/
          function(module3, exports2) {
            exports2.read = function(buffer, offset, isLE, mLen, nBytes) {
              var e, m;
              var eLen = nBytes * 8 - mLen - 1;
              var eMax = (1 << eLen) - 1;
              var eBias = eMax >> 1;
              var nBits = -7;
              var i = isLE ? nBytes - 1 : 0;
              var d = isLE ? -1 : 1;
              var s = buffer[offset + i];
              i += d;
              e = s & (1 << -nBits) - 1;
              s >>= -nBits;
              nBits += eLen;
              for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {
              }
              m = e & (1 << -nBits) - 1;
              e >>= -nBits;
              nBits += mLen;
              for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {
              }
              if (e === 0) {
                e = 1 - eBias;
              } else if (e === eMax) {
                return m ? NaN : (s ? -1 : 1) * Infinity;
              } else {
                m = m + Math.pow(2, mLen);
                e = e - eBias;
              }
              return (s ? -1 : 1) * m * Math.pow(2, e - mLen);
            };
            exports2.write = function(buffer, value, offset, isLE, mLen, nBytes) {
              var e, m, c;
              var eLen = nBytes * 8 - mLen - 1;
              var eMax = (1 << eLen) - 1;
              var eBias = eMax >> 1;
              var rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
              var i = isLE ? 0 : nBytes - 1;
              var d = isLE ? 1 : -1;
              var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
              value = Math.abs(value);
              if (isNaN(value) || value === Infinity) {
                m = isNaN(value) ? 1 : 0;
                e = eMax;
              } else {
                e = Math.floor(Math.log(value) / Math.LN2);
                if (value * (c = Math.pow(2, -e)) < 1) {
                  e--;
                  c *= 2;
                }
                if (e + eBias >= 1) {
                  value += rt / c;
                } else {
                  value += rt * Math.pow(2, 1 - eBias);
                }
                if (value * c >= 2) {
                  e++;
                  c /= 2;
                }
                if (e + eBias >= eMax) {
                  m = 0;
                  e = eMax;
                } else if (e + eBias >= 1) {
                  m = (value * c - 1) * Math.pow(2, mLen);
                  e = e + eBias;
                } else {
                  m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
                  e = 0;
                }
              }
              for (; mLen >= 8; buffer[offset + i] = m & 255, i += d, m /= 256, mLen -= 8) {
              }
              e = e << mLen | m;
              eLen += mLen;
              for (; eLen > 0; buffer[offset + i] = e & 255, i += d, e /= 256, eLen -= 8) {
              }
              buffer[offset + i - d] |= s * 128;
            };
          },
          /* 5 */
          /***/
          function(module3, exports2) {
            module3.exports = function(module4) {
              if (!module4.webpackPolyfill) {
                module4.deprecate = function() {
                };
                module4.paths = [];
                module4.children = [];
                module4.webpackPolyfill = 1;
              }
              return module4;
            };
          },
          /* 6 */
          /***/
          function(module3, exports2, __webpack_require__) {
            "use strict";
            var Process = __webpack_require__(7);
            var process2 = new Process(), processProxy = {};
            function defineKey(key2) {
              if (processProxy[key2]) {
                return;
              }
              if (typeof process2[key2] === "function") {
                processProxy[key2] = function() {
                  return process2[key2].apply(process2, arguments);
                };
              } else {
                processProxy[key2] = process2[key2];
              }
            }
            for (var key in process2) {
              defineKey(key);
            }
            processProxy.initializeTTYs = function() {
              if (process2.stdin === null) {
                process2.initializeTTYs();
                processProxy.stdin = process2.stdin;
                processProxy.stdout = process2.stdout;
                processProxy.stderr = process2.stderr;
              }
            };
            process2.nextTick(function() {
              processProxy.initializeTTYs();
            });
            module3.exports = processProxy;
          },
          /* 7 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(__dirname) {
              "use strict";
              var __extends = this && this.__extends || function(d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() {
                  this.constructor = d;
                }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
              };
              var events = __webpack_require__(8);
              var path = null;
              var Item = function() {
                function Item2(fun, array) {
                  this.fun = fun;
                  this.array = array;
                }
                Item2.prototype.run = function() {
                  this.fun.apply(null, this.array);
                };
                return Item2;
              }();
              var NextTickQueue = function() {
                function NextTickQueue2() {
                  this._queue = [];
                  this._draining = false;
                  this._currentQueue = null;
                  this._queueIndex = -1;
                }
                NextTickQueue2.prototype.push = function(item) {
                  var _this = this;
                  if (this._queue.push(item) === 1 && !this._draining) {
                    setTimeout(function() {
                      return _this._drainQueue();
                    }, 0);
                  }
                };
                NextTickQueue2.prototype._cleanUpNextTick = function() {
                  this._draining = false;
                  if (this._currentQueue && this._currentQueue.length) {
                    this._queue = this._currentQueue.concat(this._queue);
                  } else {
                    this._queueIndex = -1;
                  }
                  if (this._queue.length) {
                    this._drainQueue();
                  }
                };
                NextTickQueue2.prototype._drainQueue = function() {
                  var _this = this;
                  if (this._draining) {
                    return;
                  }
                  var timeout = setTimeout(function() {
                    return _this._cleanUpNextTick();
                  });
                  this._draining = true;
                  var len = this._queue.length;
                  while (len) {
                    this._currentQueue = this._queue;
                    this._queue = [];
                    while (++this._queueIndex < len) {
                      if (this._currentQueue) {
                        this._currentQueue[this._queueIndex].run();
                      }
                    }
                    this._queueIndex = -1;
                    len = this._queue.length;
                  }
                  this._currentQueue = null;
                  this._draining = false;
                  clearTimeout(timeout);
                };
                return NextTickQueue2;
              }();
              var Process = function(_super) {
                __extends(Process2, _super);
                function Process2() {
                  _super.apply(this, arguments);
                  this.startTime = Date.now();
                  this._cwd = "/";
                  this.platform = "browser";
                  this.argv = [];
                  this.execArgv = [];
                  this.stdout = null;
                  this.stderr = null;
                  this.stdin = null;
                  this.domain = null;
                  this._queue = new NextTickQueue();
                  this.execPath = __dirname;
                  this.env = {};
                  this.exitCode = 0;
                  this._gid = 1;
                  this._uid = 1;
                  this.version = "v5.0";
                  this.versions = {
                    http_parser: "0.0",
                    node: "5.0",
                    v8: "0.0",
                    uv: "0.0",
                    zlib: "0.0",
                    ares: "0.0",
                    icu: "0.0",
                    modules: "0",
                    openssl: "0.0"
                  };
                  this.config = {
                    target_defaults: {
                      cflags: [],
                      default_configuration: "Release",
                      defines: [],
                      include_dirs: [],
                      libraries: []
                    },
                    variables: {
                      clang: 0,
                      host_arch: "x32",
                      node_install_npm: false,
                      node_install_waf: false,
                      node_prefix: "",
                      node_shared_cares: false,
                      node_shared_http_parser: false,
                      node_shared_libuv: false,
                      node_shared_zlib: false,
                      node_shared_v8: false,
                      node_use_dtrace: false,
                      node_use_etw: false,
                      node_use_openssl: false,
                      node_shared_openssl: false,
                      strict_aliasing: false,
                      target_arch: "x32",
                      v8_use_snapshot: false,
                      v8_no_strict_aliasing: 0,
                      visibility: ""
                    }
                  };
                  this.pid = Math.random() * 1e3 | 0;
                  this.title = "node";
                  this.arch = "x32";
                  this._mask = 18;
                  this.connected = void 0;
                }
                Process2.prototype.chdir = function(dir) {
                  if (path === null) {
                    path = __webpack_require__(9);
                  }
                  this._cwd = path.resolve(dir);
                };
                Process2.prototype.cwd = function() {
                  return this._cwd;
                };
                Process2.prototype.uptime = function() {
                  return (Date.now() - this.startTime) / 1e3 | 0;
                };
                Process2.prototype.nextTick = function(fun) {
                  var args = [];
                  for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                  }
                  this._queue.push(new Item(fun, args));
                };
                Process2.prototype.abort = function() {
                  this.emit("abort");
                };
                Process2.prototype.exit = function(code) {
                  this.exitCode = code;
                  this.emit("exit", [code]);
                };
                Process2.prototype.getgid = function() {
                  return this._gid;
                };
                Process2.prototype.setgid = function(gid) {
                  if (typeof gid === "number") {
                    this._gid = gid;
                  } else {
                    this._gid = 1;
                  }
                };
                Process2.prototype.getuid = function() {
                  return this._uid;
                };
                Process2.prototype.setuid = function(uid) {
                  if (typeof uid === "number") {
                    this._uid = uid;
                  } else {
                    this._uid = 1;
                  }
                };
                Process2.prototype.kill = function(pid, signal) {
                  this.emit("kill", [pid, signal]);
                };
                Process2.prototype.memoryUsage = function() {
                  return { rss: 0, heapTotal: 0, heapUsed: 0 };
                };
                Process2.prototype.umask = function(mask) {
                  if (mask === void 0) {
                    mask = this._mask;
                  }
                  var oldMask = this._mask;
                  this._mask = mask;
                  this.emit("umask", [mask]);
                  return oldMask;
                };
                Process2.prototype.hrtime = function() {
                  var timeinfo;
                  if (typeof performance !== "undefined") {
                    timeinfo = performance.now();
                  } else if (Date["now"]) {
                    timeinfo = Date.now();
                  } else {
                    timeinfo = (/* @__PURE__ */ new Date()).getTime();
                  }
                  var secs = timeinfo / 1e3 | 0;
                  timeinfo -= secs * 1e3;
                  timeinfo = timeinfo * 1e6 | 0;
                  return [secs, timeinfo];
                };
                Process2.prototype.initializeTTYs = function() {
                  if (this.stdout === null) {
                    var TTY = __webpack_require__(10);
                    this.stdout = new TTY();
                    this.stderr = new TTY();
                    this.stdin = new TTY();
                  }
                };
                Process2.prototype.disconnect = function() {
                };
                return Process2;
              }(events.EventEmitter);
              module3.exports = Process;
            }).call(exports2, "/");
          },
          /* 8 */
          /***/
          function(module3, exports2) {
            function EventEmitter4() {
              this._events = this._events || {};
              this._maxListeners = this._maxListeners || void 0;
            }
            module3.exports = EventEmitter4;
            EventEmitter4.EventEmitter = EventEmitter4;
            EventEmitter4.prototype._events = void 0;
            EventEmitter4.prototype._maxListeners = void 0;
            EventEmitter4.defaultMaxListeners = 10;
            EventEmitter4.prototype.setMaxListeners = function(n) {
              if (!isNumber(n) || n < 0 || isNaN(n))
                throw TypeError("n must be a positive number");
              this._maxListeners = n;
              return this;
            };
            EventEmitter4.prototype.emit = function(type) {
              var er, handler, len, args, i, listeners;
              if (!this._events)
                this._events = {};
              if (type === "error") {
                if (!this._events.error || isObject(this._events.error) && !this._events.error.length) {
                  er = arguments[1];
                  if (er instanceof Error) {
                    throw er;
                  } else {
                    var err = new Error('Uncaught, unspecified "error" event. (' + er + ")");
                    err.context = er;
                    throw err;
                  }
                }
              }
              handler = this._events[type];
              if (isUndefined(handler))
                return false;
              if (isFunction(handler)) {
                switch (arguments.length) {
                  // fast cases
                  case 1:
                    handler.call(this);
                    break;
                  case 2:
                    handler.call(this, arguments[1]);
                    break;
                  case 3:
                    handler.call(this, arguments[1], arguments[2]);
                    break;
                  // slower
                  default:
                    args = Array.prototype.slice.call(arguments, 1);
                    handler.apply(this, args);
                }
              } else if (isObject(handler)) {
                args = Array.prototype.slice.call(arguments, 1);
                listeners = handler.slice();
                len = listeners.length;
                for (i = 0; i < len; i++)
                  listeners[i].apply(this, args);
              }
              return true;
            };
            EventEmitter4.prototype.addListener = function(type, listener) {
              var m;
              if (!isFunction(listener))
                throw TypeError("listener must be a function");
              if (!this._events)
                this._events = {};
              if (this._events.newListener)
                this.emit(
                  "newListener",
                  type,
                  isFunction(listener.listener) ? listener.listener : listener
                );
              if (!this._events[type])
                this._events[type] = listener;
              else if (isObject(this._events[type]))
                this._events[type].push(listener);
              else
                this._events[type] = [this._events[type], listener];
              if (isObject(this._events[type]) && !this._events[type].warned) {
                if (!isUndefined(this._maxListeners)) {
                  m = this._maxListeners;
                } else {
                  m = EventEmitter4.defaultMaxListeners;
                }
                if (m && m > 0 && this._events[type].length > m) {
                  this._events[type].warned = true;
                  console.error(
                    "(node) warning: possible EventEmitter memory leak detected. %d listeners added. Use emitter.setMaxListeners() to increase limit.",
                    this._events[type].length
                  );
                  if (typeof console.trace === "function") {
                    console.trace();
                  }
                }
              }
              return this;
            };
            EventEmitter4.prototype.on = EventEmitter4.prototype.addListener;
            EventEmitter4.prototype.once = function(type, listener) {
              if (!isFunction(listener))
                throw TypeError("listener must be a function");
              var fired = false;
              function g() {
                this.removeListener(type, g);
                if (!fired) {
                  fired = true;
                  listener.apply(this, arguments);
                }
              }
              g.listener = listener;
              this.on(type, g);
              return this;
            };
            EventEmitter4.prototype.removeListener = function(type, listener) {
              var list, position, length, i;
              if (!isFunction(listener))
                throw TypeError("listener must be a function");
              if (!this._events || !this._events[type])
                return this;
              list = this._events[type];
              length = list.length;
              position = -1;
              if (list === listener || isFunction(list.listener) && list.listener === listener) {
                delete this._events[type];
                if (this._events.removeListener)
                  this.emit("removeListener", type, listener);
              } else if (isObject(list)) {
                for (i = length; i-- > 0; ) {
                  if (list[i] === listener || list[i].listener && list[i].listener === listener) {
                    position = i;
                    break;
                  }
                }
                if (position < 0)
                  return this;
                if (list.length === 1) {
                  list.length = 0;
                  delete this._events[type];
                } else {
                  list.splice(position, 1);
                }
                if (this._events.removeListener)
                  this.emit("removeListener", type, listener);
              }
              return this;
            };
            EventEmitter4.prototype.removeAllListeners = function(type) {
              var key, listeners;
              if (!this._events)
                return this;
              if (!this._events.removeListener) {
                if (arguments.length === 0)
                  this._events = {};
                else if (this._events[type])
                  delete this._events[type];
                return this;
              }
              if (arguments.length === 0) {
                for (key in this._events) {
                  if (key === "removeListener") continue;
                  this.removeAllListeners(key);
                }
                this.removeAllListeners("removeListener");
                this._events = {};
                return this;
              }
              listeners = this._events[type];
              if (isFunction(listeners)) {
                this.removeListener(type, listeners);
              } else if (listeners) {
                while (listeners.length)
                  this.removeListener(type, listeners[listeners.length - 1]);
              }
              delete this._events[type];
              return this;
            };
            EventEmitter4.prototype.listeners = function(type) {
              var ret;
              if (!this._events || !this._events[type])
                ret = [];
              else if (isFunction(this._events[type]))
                ret = [this._events[type]];
              else
                ret = this._events[type].slice();
              return ret;
            };
            EventEmitter4.prototype.listenerCount = function(type) {
              if (this._events) {
                var evlistener = this._events[type];
                if (isFunction(evlistener))
                  return 1;
                else if (evlistener)
                  return evlistener.length;
              }
              return 0;
            };
            EventEmitter4.listenerCount = function(emitter, type) {
              return emitter.listenerCount(type);
            };
            function isFunction(arg) {
              return typeof arg === "function";
            }
            function isNumber(arg) {
              return typeof arg === "number";
            }
            function isObject(arg) {
              return typeof arg === "object" && arg !== null;
            }
            function isUndefined(arg) {
              return arg === void 0;
            }
          },
          /* 9 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(process2) {
              "use strict";
              var splitPathRe2 = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
              function posixSplitPath(filename) {
                var out = splitPathRe2.exec(filename);
                out.shift();
                return out;
              }
              var path = function() {
                function path2() {
                }
                path2.normalize = function(p) {
                  if (p === "") {
                    p = ".";
                  }
                  var absolute = p.charAt(0) === path2.sep;
                  p = path2._removeDuplicateSeps(p);
                  var components = p.split(path2.sep);
                  var goodComponents = [];
                  for (var idx = 0; idx < components.length; idx++) {
                    var c = components[idx];
                    if (c === ".") {
                      continue;
                    } else if (c === ".." && (absolute || !absolute && goodComponents.length > 0 && goodComponents[0] !== "..")) {
                      goodComponents.pop();
                    } else {
                      goodComponents.push(c);
                    }
                  }
                  if (!absolute && goodComponents.length < 2) {
                    switch (goodComponents.length) {
                      case 1:
                        if (goodComponents[0] === "") {
                          goodComponents.unshift(".");
                        }
                        break;
                      default:
                        goodComponents.push(".");
                    }
                  }
                  p = goodComponents.join(path2.sep);
                  if (absolute && p.charAt(0) !== path2.sep) {
                    p = path2.sep + p;
                  }
                  return p;
                };
                path2.join = function() {
                  var paths = [];
                  for (var _i = 0; _i < arguments.length; _i++) {
                    paths[_i - 0] = arguments[_i];
                  }
                  var processed = [];
                  for (var i = 0; i < paths.length; i++) {
                    var segment = paths[i];
                    if (typeof segment !== "string") {
                      throw new TypeError("Invalid argument type to path.join: " + typeof segment);
                    } else if (segment !== "") {
                      processed.push(segment);
                    }
                  }
                  return path2.normalize(processed.join(path2.sep));
                };
                path2.resolve = function() {
                  var paths = [];
                  for (var _i = 0; _i < arguments.length; _i++) {
                    paths[_i - 0] = arguments[_i];
                  }
                  var processed = [];
                  for (var i = 0; i < paths.length; i++) {
                    var p = paths[i];
                    if (typeof p !== "string") {
                      throw new TypeError("Invalid argument type to path.join: " + typeof p);
                    } else if (p !== "") {
                      if (p.charAt(0) === path2.sep) {
                        processed = [];
                      }
                      processed.push(p);
                    }
                  }
                  var resolved = path2.normalize(processed.join(path2.sep));
                  if (resolved.length > 1 && resolved.charAt(resolved.length - 1) === path2.sep) {
                    return resolved.substr(0, resolved.length - 1);
                  }
                  if (resolved.charAt(0) !== path2.sep) {
                    if (resolved.charAt(0) === "." && (resolved.length === 1 || resolved.charAt(1) === path2.sep)) {
                      resolved = resolved.length === 1 ? "" : resolved.substr(2);
                    }
                    var cwd = process2.cwd();
                    if (resolved !== "") {
                      resolved = this.normalize(cwd + (cwd !== "/" ? path2.sep : "") + resolved);
                    } else {
                      resolved = cwd;
                    }
                  }
                  return resolved;
                };
                path2.relative = function(from, to) {
                  var i;
                  from = path2.resolve(from);
                  to = path2.resolve(to);
                  var fromSegs = from.split(path2.sep);
                  var toSegs = to.split(path2.sep);
                  toSegs.shift();
                  fromSegs.shift();
                  var upCount = 0;
                  var downSegs = [];
                  for (i = 0; i < fromSegs.length; i++) {
                    var seg = fromSegs[i];
                    if (seg === toSegs[i]) {
                      continue;
                    }
                    upCount = fromSegs.length - i;
                    break;
                  }
                  downSegs = toSegs.slice(i);
                  if (fromSegs.length === 1 && fromSegs[0] === "") {
                    upCount = 0;
                  }
                  if (upCount > fromSegs.length) {
                    upCount = fromSegs.length;
                  }
                  var rv = "";
                  for (i = 0; i < upCount; i++) {
                    rv += "../";
                  }
                  rv += downSegs.join(path2.sep);
                  if (rv.length > 1 && rv.charAt(rv.length - 1) === path2.sep) {
                    rv = rv.substr(0, rv.length - 1);
                  }
                  return rv;
                };
                path2.dirname = function(p) {
                  p = path2._removeDuplicateSeps(p);
                  var absolute = p.charAt(0) === path2.sep;
                  var sections = p.split(path2.sep);
                  if (sections.pop() === "" && sections.length > 0) {
                    sections.pop();
                  }
                  if (sections.length > 1 || sections.length === 1 && !absolute) {
                    return sections.join(path2.sep);
                  } else if (absolute) {
                    return path2.sep;
                  } else {
                    return ".";
                  }
                };
                path2.basename = function(p, ext) {
                  if (ext === void 0) {
                    ext = "";
                  }
                  if (p === "") {
                    return p;
                  }
                  p = path2.normalize(p);
                  var sections = p.split(path2.sep);
                  var lastPart = sections[sections.length - 1];
                  if (lastPart === "" && sections.length > 1) {
                    return sections[sections.length - 2];
                  }
                  if (ext.length > 0) {
                    var lastPartExt = lastPart.substr(lastPart.length - ext.length);
                    if (lastPartExt === ext) {
                      return lastPart.substr(0, lastPart.length - ext.length);
                    }
                  }
                  return lastPart;
                };
                path2.extname = function(p) {
                  p = path2.normalize(p);
                  var sections = p.split(path2.sep);
                  p = sections.pop();
                  if (p === "" && sections.length > 0) {
                    p = sections.pop();
                  }
                  if (p === "..") {
                    return "";
                  }
                  var i = p.lastIndexOf(".");
                  if (i === -1 || i === 0) {
                    return "";
                  }
                  return p.substr(i);
                };
                path2.isAbsolute = function(p) {
                  return p.length > 0 && p.charAt(0) === path2.sep;
                };
                path2._makeLong = function(p) {
                  return p;
                };
                path2.parse = function(p) {
                  var allParts = posixSplitPath(p);
                  return {
                    root: allParts[0],
                    dir: allParts[0] + allParts[1].slice(0, -1),
                    base: allParts[2],
                    ext: allParts[3],
                    name: allParts[2].slice(0, allParts[2].length - allParts[3].length)
                  };
                };
                path2.format = function(pathObject) {
                  if (pathObject === null || typeof pathObject !== "object") {
                    throw new TypeError("Parameter 'pathObject' must be an object, not " + typeof pathObject);
                  }
                  var root = pathObject.root || "";
                  if (typeof root !== "string") {
                    throw new TypeError("'pathObject.root' must be a string or undefined, not " + typeof pathObject.root);
                  }
                  var dir = pathObject.dir ? pathObject.dir + path2.sep : "";
                  var base = pathObject.base || "";
                  return dir + base;
                };
                path2._removeDuplicateSeps = function(p) {
                  p = p.replace(this._replaceRegex, this.sep);
                  return p;
                };
                path2.sep = "/";
                path2._replaceRegex = new RegExp("//+", "g");
                path2.delimiter = ":";
                path2.posix = path2;
                path2.win32 = path2;
                return path2;
              }();
              var _ = path;
              module3.exports = path;
            }).call(exports2, __webpack_require__(6));
          },
          /* 10 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(Buffer2) {
              "use strict";
              var __extends = this && this.__extends || function(d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() {
                  this.constructor = d;
                }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
              };
              var stream = __webpack_require__(11);
              var TTY = function(_super) {
                __extends(TTY2, _super);
                function TTY2() {
                  _super.call(this);
                  this.isRaw = false;
                  this.columns = 80;
                  this.rows = 120;
                  this.isTTY = true;
                  this._bufferedWrites = [];
                  this._waitingForWrites = false;
                }
                TTY2.prototype.setRawMode = function(mode) {
                  if (this.isRaw !== mode) {
                    this.isRaw = mode;
                    this.emit("modeChange");
                  }
                };
                TTY2.prototype.changeColumns = function(columns) {
                  if (columns !== this.columns) {
                    this.columns = columns;
                    this.emit("resize");
                  }
                };
                TTY2.prototype.changeRows = function(rows) {
                  if (rows !== this.rows) {
                    this.rows = rows;
                    this.emit("resize");
                  }
                };
                TTY2.isatty = function(fd) {
                  return fd && fd instanceof TTY2;
                };
                TTY2.prototype._write = function(chunk, encoding, cb) {
                  var error;
                  try {
                    var data;
                    if (typeof chunk === "string") {
                      data = new Buffer2(chunk, encoding);
                    } else {
                      data = chunk;
                    }
                    this._bufferedWrites.push(data);
                    if (this._waitingForWrites) {
                      this._read(1024);
                    }
                  } catch (e) {
                    error = e;
                  } finally {
                    cb(error);
                  }
                };
                TTY2.prototype._read = function(size) {
                  if (this._bufferedWrites.length === 0) {
                    this._waitingForWrites = true;
                  } else {
                    while (this._bufferedWrites.length > 0) {
                      this._waitingForWrites = this.push(this._bufferedWrites.shift());
                      if (!this._waitingForWrites) {
                        break;
                      }
                    }
                  }
                };
                return TTY2;
              }(stream.Duplex);
              module3.exports = TTY;
            }).call(exports2, __webpack_require__(1));
          },
          /* 11 */
          /***/
          function(module3, exports2, __webpack_require__) {
            module3.exports = Stream;
            var EE = __webpack_require__(8).EventEmitter;
            var inherits = __webpack_require__(12);
            inherits(Stream, EE);
            Stream.Readable = __webpack_require__(13);
            Stream.Writable = __webpack_require__(27);
            Stream.Duplex = __webpack_require__(28);
            Stream.Transform = __webpack_require__(29);
            Stream.PassThrough = __webpack_require__(30);
            Stream.Stream = Stream;
            function Stream() {
              EE.call(this);
            }
            Stream.prototype.pipe = function(dest, options) {
              var source = this;
              function ondata(chunk) {
                if (dest.writable) {
                  if (false === dest.write(chunk) && source.pause) {
                    source.pause();
                  }
                }
              }
              source.on("data", ondata);
              function ondrain() {
                if (source.readable && source.resume) {
                  source.resume();
                }
              }
              dest.on("drain", ondrain);
              if (!dest._isStdio && (!options || options.end !== false)) {
                source.on("end", onend);
                source.on("close", onclose);
              }
              var didOnEnd = false;
              function onend() {
                if (didOnEnd) return;
                didOnEnd = true;
                dest.end();
              }
              function onclose() {
                if (didOnEnd) return;
                didOnEnd = true;
                if (typeof dest.destroy === "function") dest.destroy();
              }
              function onerror(er) {
                cleanup();
                if (EE.listenerCount(this, "error") === 0) {
                  throw er;
                }
              }
              source.on("error", onerror);
              dest.on("error", onerror);
              function cleanup() {
                source.removeListener("data", ondata);
                dest.removeListener("drain", ondrain);
                source.removeListener("end", onend);
                source.removeListener("close", onclose);
                source.removeListener("error", onerror);
                dest.removeListener("error", onerror);
                source.removeListener("end", cleanup);
                source.removeListener("close", cleanup);
                dest.removeListener("close", cleanup);
              }
              source.on("end", cleanup);
              source.on("close", cleanup);
              dest.on("close", cleanup);
              dest.emit("pipe", source);
              return dest;
            };
          },
          /* 12 */
          /***/
          function(module3, exports2) {
            if (typeof Object.create === "function") {
              module3.exports = function inherits(ctor, superCtor) {
                ctor.super_ = superCtor;
                ctor.prototype = Object.create(superCtor.prototype, {
                  constructor: {
                    value: ctor,
                    enumerable: false,
                    writable: true,
                    configurable: true
                  }
                });
              };
            } else {
              module3.exports = function inherits(ctor, superCtor) {
                ctor.super_ = superCtor;
                var TempCtor = function() {
                };
                TempCtor.prototype = superCtor.prototype;
                ctor.prototype = new TempCtor();
                ctor.prototype.constructor = ctor;
              };
            }
          },
          /* 13 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(process2) {
              var Stream = function() {
                try {
                  return __webpack_require__(11);
                } catch (_) {
                }
              }();
              exports2 = module3.exports = __webpack_require__(14);
              exports2.Stream = Stream || exports2;
              exports2.Readable = exports2;
              exports2.Writable = __webpack_require__(22);
              exports2.Duplex = __webpack_require__(21);
              exports2.Transform = __webpack_require__(25);
              exports2.PassThrough = __webpack_require__(26);
              if (!process2.browser && process2.env.READABLE_STREAM === "disable" && Stream) {
                module3.exports = Stream;
              }
            }).call(exports2, __webpack_require__(6));
          },
          /* 14 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(process2) {
              "use strict";
              module3.exports = Readable;
              var processNextTick = __webpack_require__(15);
              var isArray = __webpack_require__(16);
              var Duplex;
              Readable.ReadableState = ReadableState;
              var EE = __webpack_require__(8).EventEmitter;
              var EElistenerCount = function(emitter, type) {
                return emitter.listeners(type).length;
              };
              var Stream;
              (function() {
                try {
                  Stream = __webpack_require__(11);
                } catch (_) {
                } finally {
                  if (!Stream) Stream = __webpack_require__(8).EventEmitter;
                }
              })();
              var Buffer2 = __webpack_require__(2).Buffer;
              var bufferShim = __webpack_require__(17);
              var util = __webpack_require__(18);
              util.inherits = __webpack_require__(12);
              var debugUtil = __webpack_require__(19);
              var debug = void 0;
              if (debugUtil && debugUtil.debuglog) {
                debug = debugUtil.debuglog("stream");
              } else {
                debug = function() {
                };
              }
              var BufferList = __webpack_require__(20);
              var StringDecoder;
              util.inherits(Readable, Stream);
              function prependListener(emitter, event, fn) {
                if (typeof emitter.prependListener === "function") {
                  return emitter.prependListener(event, fn);
                } else {
                  if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);
                  else if (isArray(emitter._events[event])) emitter._events[event].unshift(fn);
                  else emitter._events[event] = [fn, emitter._events[event]];
                }
              }
              function ReadableState(options, stream) {
                Duplex = Duplex || __webpack_require__(21);
                options = options || {};
                this.objectMode = !!options.objectMode;
                if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.readableObjectMode;
                var hwm = options.highWaterMark;
                var defaultHwm = this.objectMode ? 16 : 16 * 1024;
                this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;
                this.highWaterMark = ~~this.highWaterMark;
                this.buffer = new BufferList();
                this.length = 0;
                this.pipes = null;
                this.pipesCount = 0;
                this.flowing = null;
                this.ended = false;
                this.endEmitted = false;
                this.reading = false;
                this.sync = true;
                this.needReadable = false;
                this.emittedReadable = false;
                this.readableListening = false;
                this.resumeScheduled = false;
                this.defaultEncoding = options.defaultEncoding || "utf8";
                this.ranOut = false;
                this.awaitDrain = 0;
                this.readingMore = false;
                this.decoder = null;
                this.encoding = null;
                if (options.encoding) {
                  if (!StringDecoder) StringDecoder = __webpack_require__(24).StringDecoder;
                  this.decoder = new StringDecoder(options.encoding);
                  this.encoding = options.encoding;
                }
              }
              function Readable(options) {
                Duplex = Duplex || __webpack_require__(21);
                if (!(this instanceof Readable)) return new Readable(options);
                this._readableState = new ReadableState(options, this);
                this.readable = true;
                if (options && typeof options.read === "function") this._read = options.read;
                Stream.call(this);
              }
              Readable.prototype.push = function(chunk, encoding) {
                var state = this._readableState;
                if (!state.objectMode && typeof chunk === "string") {
                  encoding = encoding || state.defaultEncoding;
                  if (encoding !== state.encoding) {
                    chunk = bufferShim.from(chunk, encoding);
                    encoding = "";
                  }
                }
                return readableAddChunk(this, state, chunk, encoding, false);
              };
              Readable.prototype.unshift = function(chunk) {
                var state = this._readableState;
                return readableAddChunk(this, state, chunk, "", true);
              };
              Readable.prototype.isPaused = function() {
                return this._readableState.flowing === false;
              };
              function readableAddChunk(stream, state, chunk, encoding, addToFront) {
                var er = chunkInvalid(state, chunk);
                if (er) {
                  stream.emit("error", er);
                } else if (chunk === null) {
                  state.reading = false;
                  onEofChunk(stream, state);
                } else if (state.objectMode || chunk && chunk.length > 0) {
                  if (state.ended && !addToFront) {
                    var e = new Error("stream.push() after EOF");
                    stream.emit("error", e);
                  } else if (state.endEmitted && addToFront) {
                    var _e = new Error("stream.unshift() after end event");
                    stream.emit("error", _e);
                  } else {
                    var skipAdd;
                    if (state.decoder && !addToFront && !encoding) {
                      chunk = state.decoder.write(chunk);
                      skipAdd = !state.objectMode && chunk.length === 0;
                    }
                    if (!addToFront) state.reading = false;
                    if (!skipAdd) {
                      if (state.flowing && state.length === 0 && !state.sync) {
                        stream.emit("data", chunk);
                        stream.read(0);
                      } else {
                        state.length += state.objectMode ? 1 : chunk.length;
                        if (addToFront) state.buffer.unshift(chunk);
                        else state.buffer.push(chunk);
                        if (state.needReadable) emitReadable(stream);
                      }
                    }
                    maybeReadMore(stream, state);
                  }
                } else if (!addToFront) {
                  state.reading = false;
                }
                return needMoreData(state);
              }
              function needMoreData(state) {
                return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
              }
              Readable.prototype.setEncoding = function(enc) {
                if (!StringDecoder) StringDecoder = __webpack_require__(24).StringDecoder;
                this._readableState.decoder = new StringDecoder(enc);
                this._readableState.encoding = enc;
                return this;
              };
              var MAX_HWM = 8388608;
              function computeNewHighWaterMark(n) {
                if (n >= MAX_HWM) {
                  n = MAX_HWM;
                } else {
                  n--;
                  n |= n >>> 1;
                  n |= n >>> 2;
                  n |= n >>> 4;
                  n |= n >>> 8;
                  n |= n >>> 16;
                  n++;
                }
                return n;
              }
              function howMuchToRead(n, state) {
                if (n <= 0 || state.length === 0 && state.ended) return 0;
                if (state.objectMode) return 1;
                if (n !== n) {
                  if (state.flowing && state.length) return state.buffer.head.data.length;
                  else return state.length;
                }
                if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
                if (n <= state.length) return n;
                if (!state.ended) {
                  state.needReadable = true;
                  return 0;
                }
                return state.length;
              }
              Readable.prototype.read = function(n) {
                debug("read", n);
                n = parseInt(n, 10);
                var state = this._readableState;
                var nOrig = n;
                if (n !== 0) state.emittedReadable = false;
                if (n === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
                  debug("read: emitReadable", state.length, state.ended);
                  if (state.length === 0 && state.ended) endReadable(this);
                  else emitReadable(this);
                  return null;
                }
                n = howMuchToRead(n, state);
                if (n === 0 && state.ended) {
                  if (state.length === 0) endReadable(this);
                  return null;
                }
                var doRead = state.needReadable;
                debug("need readable", doRead);
                if (state.length === 0 || state.length - n < state.highWaterMark) {
                  doRead = true;
                  debug("length less than watermark", doRead);
                }
                if (state.ended || state.reading) {
                  doRead = false;
                  debug("reading or ended", doRead);
                } else if (doRead) {
                  debug("do read");
                  state.reading = true;
                  state.sync = true;
                  if (state.length === 0) state.needReadable = true;
                  this._read(state.highWaterMark);
                  state.sync = false;
                  if (!state.reading) n = howMuchToRead(nOrig, state);
                }
                var ret;
                if (n > 0) ret = fromList(n, state);
                else ret = null;
                if (ret === null) {
                  state.needReadable = true;
                  n = 0;
                } else {
                  state.length -= n;
                }
                if (state.length === 0) {
                  if (!state.ended) state.needReadable = true;
                  if (nOrig !== n && state.ended) endReadable(this);
                }
                if (ret !== null) this.emit("data", ret);
                return ret;
              };
              function chunkInvalid(state, chunk) {
                var er = null;
                if (!Buffer2.isBuffer(chunk) && typeof chunk !== "string" && chunk !== null && chunk !== void 0 && !state.objectMode) {
                  er = new TypeError("Invalid non-string/buffer chunk");
                }
                return er;
              }
              function onEofChunk(stream, state) {
                if (state.ended) return;
                if (state.decoder) {
                  var chunk = state.decoder.end();
                  if (chunk && chunk.length) {
                    state.buffer.push(chunk);
                    state.length += state.objectMode ? 1 : chunk.length;
                  }
                }
                state.ended = true;
                emitReadable(stream);
              }
              function emitReadable(stream) {
                var state = stream._readableState;
                state.needReadable = false;
                if (!state.emittedReadable) {
                  debug("emitReadable", state.flowing);
                  state.emittedReadable = true;
                  if (state.sync) processNextTick(emitReadable_, stream);
                  else emitReadable_(stream);
                }
              }
              function emitReadable_(stream) {
                debug("emit readable");
                stream.emit("readable");
                flow2(stream);
              }
              function maybeReadMore(stream, state) {
                if (!state.readingMore) {
                  state.readingMore = true;
                  processNextTick(maybeReadMore_, stream, state);
                }
              }
              function maybeReadMore_(stream, state) {
                var len = state.length;
                while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
                  debug("maybeReadMore read 0");
                  stream.read(0);
                  if (len === state.length)
                    break;
                  else len = state.length;
                }
                state.readingMore = false;
              }
              Readable.prototype._read = function(n) {
                this.emit("error", new Error("_read() is not implemented"));
              };
              Readable.prototype.pipe = function(dest, pipeOpts) {
                var src = this;
                var state = this._readableState;
                switch (state.pipesCount) {
                  case 0:
                    state.pipes = dest;
                    break;
                  case 1:
                    state.pipes = [state.pipes, dest];
                    break;
                  default:
                    state.pipes.push(dest);
                    break;
                }
                state.pipesCount += 1;
                debug("pipe count=%d opts=%j", state.pipesCount, pipeOpts);
                var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process2.stdout && dest !== process2.stderr;
                var endFn = doEnd ? onend : cleanup;
                if (state.endEmitted) processNextTick(endFn);
                else src.once("end", endFn);
                dest.on("unpipe", onunpipe);
                function onunpipe(readable) {
                  debug("onunpipe");
                  if (readable === src) {
                    cleanup();
                  }
                }
                function onend() {
                  debug("onend");
                  dest.end();
                }
                var ondrain = pipeOnDrain(src);
                dest.on("drain", ondrain);
                var cleanedUp = false;
                function cleanup() {
                  debug("cleanup");
                  dest.removeListener("close", onclose);
                  dest.removeListener("finish", onfinish);
                  dest.removeListener("drain", ondrain);
                  dest.removeListener("error", onerror);
                  dest.removeListener("unpipe", onunpipe);
                  src.removeListener("end", onend);
                  src.removeListener("end", cleanup);
                  src.removeListener("data", ondata);
                  cleanedUp = true;
                  if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
                }
                var increasedAwaitDrain = false;
                src.on("data", ondata);
                function ondata(chunk) {
                  debug("ondata");
                  increasedAwaitDrain = false;
                  var ret = dest.write(chunk);
                  if (false === ret && !increasedAwaitDrain) {
                    if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
                      debug("false write response, pause", src._readableState.awaitDrain);
                      src._readableState.awaitDrain++;
                      increasedAwaitDrain = true;
                    }
                    src.pause();
                  }
                }
                function onerror(er) {
                  debug("onerror", er);
                  unpipe();
                  dest.removeListener("error", onerror);
                  if (EElistenerCount(dest, "error") === 0) dest.emit("error", er);
                }
                prependListener(dest, "error", onerror);
                function onclose() {
                  dest.removeListener("finish", onfinish);
                  unpipe();
                }
                dest.once("close", onclose);
                function onfinish() {
                  debug("onfinish");
                  dest.removeListener("close", onclose);
                  unpipe();
                }
                dest.once("finish", onfinish);
                function unpipe() {
                  debug("unpipe");
                  src.unpipe(dest);
                }
                dest.emit("pipe", src);
                if (!state.flowing) {
                  debug("pipe resume");
                  src.resume();
                }
                return dest;
              };
              function pipeOnDrain(src) {
                return function() {
                  var state = src._readableState;
                  debug("pipeOnDrain", state.awaitDrain);
                  if (state.awaitDrain) state.awaitDrain--;
                  if (state.awaitDrain === 0 && EElistenerCount(src, "data")) {
                    state.flowing = true;
                    flow2(src);
                  }
                };
              }
              Readable.prototype.unpipe = function(dest) {
                var state = this._readableState;
                if (state.pipesCount === 0) return this;
                if (state.pipesCount === 1) {
                  if (dest && dest !== state.pipes) return this;
                  if (!dest) dest = state.pipes;
                  state.pipes = null;
                  state.pipesCount = 0;
                  state.flowing = false;
                  if (dest) dest.emit("unpipe", this);
                  return this;
                }
                if (!dest) {
                  var dests = state.pipes;
                  var len = state.pipesCount;
                  state.pipes = null;
                  state.pipesCount = 0;
                  state.flowing = false;
                  for (var i = 0; i < len; i++) {
                    dests[i].emit("unpipe", this);
                  }
                  return this;
                }
                var index = indexOf(state.pipes, dest);
                if (index === -1) return this;
                state.pipes.splice(index, 1);
                state.pipesCount -= 1;
                if (state.pipesCount === 1) state.pipes = state.pipes[0];
                dest.emit("unpipe", this);
                return this;
              };
              Readable.prototype.on = function(ev, fn) {
                var res = Stream.prototype.on.call(this, ev, fn);
                if (ev === "data") {
                  if (this._readableState.flowing !== false) this.resume();
                } else if (ev === "readable") {
                  var state = this._readableState;
                  if (!state.endEmitted && !state.readableListening) {
                    state.readableListening = state.needReadable = true;
                    state.emittedReadable = false;
                    if (!state.reading) {
                      processNextTick(nReadingNextTick, this);
                    } else if (state.length) {
                      emitReadable(this, state);
                    }
                  }
                }
                return res;
              };
              Readable.prototype.addListener = Readable.prototype.on;
              function nReadingNextTick(self2) {
                debug("readable nexttick read 0");
                self2.read(0);
              }
              Readable.prototype.resume = function() {
                var state = this._readableState;
                if (!state.flowing) {
                  debug("resume");
                  state.flowing = true;
                  resume(this, state);
                }
                return this;
              };
              function resume(stream, state) {
                if (!state.resumeScheduled) {
                  state.resumeScheduled = true;
                  processNextTick(resume_, stream, state);
                }
              }
              function resume_(stream, state) {
                if (!state.reading) {
                  debug("resume read 0");
                  stream.read(0);
                }
                state.resumeScheduled = false;
                state.awaitDrain = 0;
                stream.emit("resume");
                flow2(stream);
                if (state.flowing && !state.reading) stream.read(0);
              }
              Readable.prototype.pause = function() {
                debug("call pause flowing=%j", this._readableState.flowing);
                if (false !== this._readableState.flowing) {
                  debug("pause");
                  this._readableState.flowing = false;
                  this.emit("pause");
                }
                return this;
              };
              function flow2(stream) {
                var state = stream._readableState;
                debug("flow", state.flowing);
                while (state.flowing && stream.read() !== null) {
                }
              }
              Readable.prototype.wrap = function(stream) {
                var state = this._readableState;
                var paused = false;
                var self2 = this;
                stream.on("end", function() {
                  debug("wrapped end");
                  if (state.decoder && !state.ended) {
                    var chunk = state.decoder.end();
                    if (chunk && chunk.length) self2.push(chunk);
                  }
                  self2.push(null);
                });
                stream.on("data", function(chunk) {
                  debug("wrapped data");
                  if (state.decoder) chunk = state.decoder.write(chunk);
                  if (state.objectMode && (chunk === null || chunk === void 0)) return;
                  else if (!state.objectMode && (!chunk || !chunk.length)) return;
                  var ret = self2.push(chunk);
                  if (!ret) {
                    paused = true;
                    stream.pause();
                  }
                });
                for (var i in stream) {
                  if (this[i] === void 0 && typeof stream[i] === "function") {
                    this[i] = /* @__PURE__ */ function(method) {
                      return function() {
                        return stream[method].apply(stream, arguments);
                      };
                    }(i);
                  }
                }
                var events = ["error", "close", "destroy", "pause", "resume"];
                forEach(events, function(ev) {
                  stream.on(ev, self2.emit.bind(self2, ev));
                });
                self2._read = function(n) {
                  debug("wrapped _read", n);
                  if (paused) {
                    paused = false;
                    stream.resume();
                  }
                };
                return self2;
              };
              Readable._fromList = fromList;
              function fromList(n, state) {
                if (state.length === 0) return null;
                var ret;
                if (state.objectMode) ret = state.buffer.shift();
                else if (!n || n >= state.length) {
                  if (state.decoder) ret = state.buffer.join("");
                  else if (state.buffer.length === 1) ret = state.buffer.head.data;
                  else ret = state.buffer.concat(state.length);
                  state.buffer.clear();
                } else {
                  ret = fromListPartial(n, state.buffer, state.decoder);
                }
                return ret;
              }
              function fromListPartial(n, list, hasStrings) {
                var ret;
                if (n < list.head.data.length) {
                  ret = list.head.data.slice(0, n);
                  list.head.data = list.head.data.slice(n);
                } else if (n === list.head.data.length) {
                  ret = list.shift();
                } else {
                  ret = hasStrings ? copyFromBufferString(n, list) : copyFromBuffer(n, list);
                }
                return ret;
              }
              function copyFromBufferString(n, list) {
                var p = list.head;
                var c = 1;
                var ret = p.data;
                n -= ret.length;
                while (p = p.next) {
                  var str = p.data;
                  var nb = n > str.length ? str.length : n;
                  if (nb === str.length) ret += str;
                  else ret += str.slice(0, n);
                  n -= nb;
                  if (n === 0) {
                    if (nb === str.length) {
                      ++c;
                      if (p.next) list.head = p.next;
                      else list.head = list.tail = null;
                    } else {
                      list.head = p;
                      p.data = str.slice(nb);
                    }
                    break;
                  }
                  ++c;
                }
                list.length -= c;
                return ret;
              }
              function copyFromBuffer(n, list) {
                var ret = bufferShim.allocUnsafe(n);
                var p = list.head;
                var c = 1;
                p.data.copy(ret);
                n -= p.data.length;
                while (p = p.next) {
                  var buf = p.data;
                  var nb = n > buf.length ? buf.length : n;
                  buf.copy(ret, ret.length - n, 0, nb);
                  n -= nb;
                  if (n === 0) {
                    if (nb === buf.length) {
                      ++c;
                      if (p.next) list.head = p.next;
                      else list.head = list.tail = null;
                    } else {
                      list.head = p;
                      p.data = buf.slice(nb);
                    }
                    break;
                  }
                  ++c;
                }
                list.length -= c;
                return ret;
              }
              function endReadable(stream) {
                var state = stream._readableState;
                if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');
                if (!state.endEmitted) {
                  state.ended = true;
                  processNextTick(endReadableNT, state, stream);
                }
              }
              function endReadableNT(state, stream) {
                if (!state.endEmitted && state.length === 0) {
                  state.endEmitted = true;
                  stream.readable = false;
                  stream.emit("end");
                }
              }
              function forEach(xs, f) {
                for (var i = 0, l = xs.length; i < l; i++) {
                  f(xs[i], i);
                }
              }
              function indexOf(xs, x) {
                for (var i = 0, l = xs.length; i < l; i++) {
                  if (xs[i] === x) return i;
                }
                return -1;
              }
            }).call(exports2, __webpack_require__(6));
          },
          /* 15 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(process2) {
              "use strict";
              if (!process2.version || process2.version.indexOf("v0.") === 0 || process2.version.indexOf("v1.") === 0 && process2.version.indexOf("v1.8.") !== 0) {
                module3.exports = nextTick;
              } else {
                module3.exports = process2.nextTick;
              }
              function nextTick(fn, arg1, arg2, arg3) {
                if (typeof fn !== "function") {
                  throw new TypeError('"callback" argument must be a function');
                }
                var len = arguments.length;
                var args, i;
                switch (len) {
                  case 0:
                  case 1:
                    return process2.nextTick(fn);
                  case 2:
                    return process2.nextTick(function afterTickOne() {
                      fn.call(null, arg1);
                    });
                  case 3:
                    return process2.nextTick(function afterTickTwo() {
                      fn.call(null, arg1, arg2);
                    });
                  case 4:
                    return process2.nextTick(function afterTickThree() {
                      fn.call(null, arg1, arg2, arg3);
                    });
                  default:
                    args = new Array(len - 1);
                    i = 0;
                    while (i < args.length) {
                      args[i++] = arguments[i];
                    }
                    return process2.nextTick(function afterTick() {
                      fn.apply(null, args);
                    });
                }
              }
            }).call(exports2, __webpack_require__(6));
          },
          /* 16 */
          /***/
          function(module3, exports2) {
            var toString = {}.toString;
            module3.exports = Array.isArray || function(arr) {
              return toString.call(arr) == "[object Array]";
            };
          },
          /* 17 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(global2) {
              "use strict";
              var buffer = __webpack_require__(2);
              var Buffer2 = buffer.Buffer;
              var SlowBuffer = buffer.SlowBuffer;
              var MAX_LEN = buffer.kMaxLength || 2147483647;
              exports2.alloc = function alloc(size, fill, encoding) {
                if (typeof Buffer2.alloc === "function") {
                  return Buffer2.alloc(size, fill, encoding);
                }
                if (typeof encoding === "number") {
                  throw new TypeError("encoding must not be number");
                }
                if (typeof size !== "number") {
                  throw new TypeError("size must be a number");
                }
                if (size > MAX_LEN) {
                  throw new RangeError("size is too large");
                }
                var enc = encoding;
                var _fill = fill;
                if (_fill === void 0) {
                  enc = void 0;
                  _fill = 0;
                }
                var buf = new Buffer2(size);
                if (typeof _fill === "string") {
                  var fillBuf = new Buffer2(_fill, enc);
                  var flen = fillBuf.length;
                  var i = -1;
                  while (++i < size) {
                    buf[i] = fillBuf[i % flen];
                  }
                } else {
                  buf.fill(_fill);
                }
                return buf;
              };
              exports2.allocUnsafe = function allocUnsafe(size) {
                if (typeof Buffer2.allocUnsafe === "function") {
                  return Buffer2.allocUnsafe(size);
                }
                if (typeof size !== "number") {
                  throw new TypeError("size must be a number");
                }
                if (size > MAX_LEN) {
                  throw new RangeError("size is too large");
                }
                return new Buffer2(size);
              };
              exports2.from = function from(value, encodingOrOffset, length) {
                if (typeof Buffer2.from === "function" && (!global2.Uint8Array || Uint8Array.from !== Buffer2.from)) {
                  return Buffer2.from(value, encodingOrOffset, length);
                }
                if (typeof value === "number") {
                  throw new TypeError('"value" argument must not be a number');
                }
                if (typeof value === "string") {
                  return new Buffer2(value, encodingOrOffset);
                }
                if (typeof ArrayBuffer !== "undefined" && value instanceof ArrayBuffer) {
                  var offset = encodingOrOffset;
                  if (arguments.length === 1) {
                    return new Buffer2(value);
                  }
                  if (typeof offset === "undefined") {
                    offset = 0;
                  }
                  var len = length;
                  if (typeof len === "undefined") {
                    len = value.byteLength - offset;
                  }
                  if (offset >= value.byteLength) {
                    throw new RangeError("'offset' is out of bounds");
                  }
                  if (len > value.byteLength - offset) {
                    throw new RangeError("'length' is out of bounds");
                  }
                  return new Buffer2(value.slice(offset, offset + len));
                }
                if (Buffer2.isBuffer(value)) {
                  var out = new Buffer2(value.length);
                  value.copy(out, 0, 0, value.length);
                  return out;
                }
                if (value) {
                  if (Array.isArray(value) || typeof ArrayBuffer !== "undefined" && value.buffer instanceof ArrayBuffer || "length" in value) {
                    return new Buffer2(value);
                  }
                  if (value.type === "Buffer" && Array.isArray(value.data)) {
                    return new Buffer2(value.data);
                  }
                }
                throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.");
              };
              exports2.allocUnsafeSlow = function allocUnsafeSlow(size) {
                if (typeof Buffer2.allocUnsafeSlow === "function") {
                  return Buffer2.allocUnsafeSlow(size);
                }
                if (typeof size !== "number") {
                  throw new TypeError("size must be a number");
                }
                if (size >= MAX_LEN) {
                  throw new RangeError("size is too large");
                }
                return new SlowBuffer(size);
              };
            }).call(exports2, /* @__PURE__ */ function() {
              return this;
            }());
          },
          /* 18 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(Buffer2) {
              function isArray(arg) {
                if (Array.isArray) {
                  return Array.isArray(arg);
                }
                return objectToString(arg) === "[object Array]";
              }
              exports2.isArray = isArray;
              function isBoolean(arg) {
                return typeof arg === "boolean";
              }
              exports2.isBoolean = isBoolean;
              function isNull(arg) {
                return arg === null;
              }
              exports2.isNull = isNull;
              function isNullOrUndefined(arg) {
                return arg == null;
              }
              exports2.isNullOrUndefined = isNullOrUndefined;
              function isNumber(arg) {
                return typeof arg === "number";
              }
              exports2.isNumber = isNumber;
              function isString(arg) {
                return typeof arg === "string";
              }
              exports2.isString = isString;
              function isSymbol(arg) {
                return typeof arg === "symbol";
              }
              exports2.isSymbol = isSymbol;
              function isUndefined(arg) {
                return arg === void 0;
              }
              exports2.isUndefined = isUndefined;
              function isRegExp(re) {
                return objectToString(re) === "[object RegExp]";
              }
              exports2.isRegExp = isRegExp;
              function isObject(arg) {
                return typeof arg === "object" && arg !== null;
              }
              exports2.isObject = isObject;
              function isDate(d) {
                return objectToString(d) === "[object Date]";
              }
              exports2.isDate = isDate;
              function isError(e) {
                return objectToString(e) === "[object Error]" || e instanceof Error;
              }
              exports2.isError = isError;
              function isFunction(arg) {
                return typeof arg === "function";
              }
              exports2.isFunction = isFunction;
              function isPrimitive(arg) {
                return arg === null || typeof arg === "boolean" || typeof arg === "number" || typeof arg === "string" || typeof arg === "symbol" || // ES6 symbol
                typeof arg === "undefined";
              }
              exports2.isPrimitive = isPrimitive;
              exports2.isBuffer = Buffer2.isBuffer;
              function objectToString(o) {
                return Object.prototype.toString.call(o);
              }
            }).call(exports2, __webpack_require__(1));
          },
          /* 19 */
          /***/
          function(module3, exports2) {
          },
          /* 20 */
          /***/
          function(module3, exports2, __webpack_require__) {
            "use strict";
            var Buffer2 = __webpack_require__(2).Buffer;
            var bufferShim = __webpack_require__(17);
            module3.exports = BufferList;
            function BufferList() {
              this.head = null;
              this.tail = null;
              this.length = 0;
            }
            BufferList.prototype.push = function(v) {
              var entry = { data: v, next: null };
              if (this.length > 0) this.tail.next = entry;
              else this.head = entry;
              this.tail = entry;
              ++this.length;
            };
            BufferList.prototype.unshift = function(v) {
              var entry = { data: v, next: this.head };
              if (this.length === 0) this.tail = entry;
              this.head = entry;
              ++this.length;
            };
            BufferList.prototype.shift = function() {
              if (this.length === 0) return;
              var ret = this.head.data;
              if (this.length === 1) this.head = this.tail = null;
              else this.head = this.head.next;
              --this.length;
              return ret;
            };
            BufferList.prototype.clear = function() {
              this.head = this.tail = null;
              this.length = 0;
            };
            BufferList.prototype.join = function(s) {
              if (this.length === 0) return "";
              var p = this.head;
              var ret = "" + p.data;
              while (p = p.next) {
                ret += s + p.data;
              }
              return ret;
            };
            BufferList.prototype.concat = function(n) {
              if (this.length === 0) return bufferShim.alloc(0);
              if (this.length === 1) return this.head.data;
              var ret = bufferShim.allocUnsafe(n >>> 0);
              var p = this.head;
              var i = 0;
              while (p) {
                p.data.copy(ret, i);
                i += p.data.length;
                p = p.next;
              }
              return ret;
            };
          },
          /* 21 */
          /***/
          function(module3, exports2, __webpack_require__) {
            "use strict";
            var objectKeys = Object.keys || function(obj) {
              var keys2 = [];
              for (var key in obj) {
                keys2.push(key);
              }
              return keys2;
            };
            module3.exports = Duplex;
            var processNextTick = __webpack_require__(15);
            var util = __webpack_require__(18);
            util.inherits = __webpack_require__(12);
            var Readable = __webpack_require__(14);
            var Writable = __webpack_require__(22);
            util.inherits(Duplex, Readable);
            var keys = objectKeys(Writable.prototype);
            for (var v = 0; v < keys.length; v++) {
              var method = keys[v];
              if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
            }
            function Duplex(options) {
              if (!(this instanceof Duplex)) return new Duplex(options);
              Readable.call(this, options);
              Writable.call(this, options);
              if (options && options.readable === false) this.readable = false;
              if (options && options.writable === false) this.writable = false;
              this.allowHalfOpen = true;
              if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;
              this.once("end", onend);
            }
            function onend() {
              if (this.allowHalfOpen || this._writableState.ended) return;
              processNextTick(onEndNT, this);
            }
            function onEndNT(self2) {
              self2.end();
            }
            function forEach(xs, f) {
              for (var i = 0, l = xs.length; i < l; i++) {
                f(xs[i], i);
              }
            }
          },
          /* 22 */
          /***/
          function(module3, exports2, __webpack_require__) {
            (function(process2) {
              "use strict";
              module3.exports = Writable;
              var processNextTick = __webpack_require__(15);
              var asyncWrite = !process2.browser && ["v0.10", "v0.9."].indexOf(process2.version.slice(0, 5)) > -1 ? setImmediate : processNextTick;
              var Duplex;
              Writable.WritableState = WritableState;
              var util = __webpack_require__(18);
              util.inherits = __webpack_require__(12);
              var internalUtil = {
                deprecate: __webpack_require__(23)
              };
              var Stream;
              (function() {
                try {
                  Stream = __webpack_require__(11);
                } catch (_) {
                } finally {
                  if (!Stream) Stream = __webpack_require__(8).EventEmitter;
                }
              })();
              var Buffer2 = __webpack_require__(2).Buffer;
              var bufferShim = __webpack_require__(17);
              util.inherits(Writable, Stream);
              function nop() {
              }
              function WriteReq(chunk, encoding, cb) {
                this.chunk = chunk;
                this.encoding = encoding;
                this.callback = cb;
                this.next = null;
              }
              function WritableState(options, stream) {
                Duplex = Duplex || __webpack_require__(21);
                options = options || {};
                this.objectMode = !!options.objectMode;
                if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.writableObjectMode;
                var hwm = options.highWaterMark;
                var defaultHwm = this.objectMode ? 16 : 16 * 1024;
                this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;
                this.highWaterMark = ~~this.highWaterMark;
                this.needDrain = false;
                this.ending = false;
                this.ended = false;
                this.finished = false;
                var noDecode = options.decodeStrings === false;
                this.decodeStrings = !noDecode;
                this.defaultEncoding = options.defaultEncoding || "utf8";
                this.length = 0;
                this.writing = false;
                this.corked = 0;
                this.sync = true;
                this.bufferProcessing = false;
                this.onwrite = function(er) {
                  onwrite(stream, er);
                };
                this.writecb = null;
                this.writelen = 0;
                this.bufferedRequest = null;
                this.lastBufferedRequest = null;
                this.pendingcb = 0;
                this.prefinished = false;
                this.errorEmitted = false;
                this.bufferedRequestCount = 0;
                this.corkedRequestsFree = new CorkedRequest(this);
              }
              WritableState.prototype.getBuffer = function getBuffer() {
                var current = this.bufferedRequest;
                var out = [];
                while (current) {
                  out.push(current);
                  current = current.next;
                }
                return out;
              };
              (function() {
                try {
                  Object.defineProperty(WritableState.prototype, "buffer", {
                    get: internalUtil.deprecate(function() {
                      return this.getBuffer();
                    }, "_writableState.buffer is deprecated. Use _writableState.getBuffer instead.")
                  });
                } catch (_) {
                }
              })();
              var realHasInstance;
              if (typeof Symbol === "function" && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === "function") {
                realHasInstance = Function.prototype[Symbol.hasInstance];
                Object.defineProperty(Writable, Symbol.hasInstance, {
                  value: function(object) {
                    if (realHasInstance.call(this, object)) return true;
                    return object && object._writableState instanceof WritableState;
                  }
                });
              } else {
                realHasInstance = function(object) {
                  return object instanceof this;
                };
              }
              function Writable(options) {
                Duplex = Duplex || __webpack_require__(21);
                if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
                  return new Writable(options);
                }
                this._writableState = new WritableState(options, this);
                this.writable = true;
                if (options) {
                  if (typeof options.write === "function") this._write = options.write;
                  if (typeof options.writev === "function") this._writev = options.writev;
                }
                Stream.call(this);
              }
              Writable.prototype.pipe = function() {
                this.emit("error", new Error("Cannot pipe, not readable"));
              };
              function writeAfterEnd(stream, cb) {
                var er = new Error("write after end");
                stream.emit("error", er);
                processNextTick(cb, er);
              }
              function validChunk(stream, state, chunk, cb) {
                var valid = true;
                var er = false;
                if (chunk === null) {
                  er = new TypeError("May not write null values to stream");
                } else if (typeof chunk !== "string" && chunk !== void 0 && !state.objectMode) {
                  er = new TypeError("Invalid non-string/buffer chunk");
                }
                if (er) {
                  stream.emit("error", er);
                  processNextTick(cb, er);
                  valid = false;
                }
                return valid;
              }
              Writable.prototype.write = function(chunk, encoding, cb) {
                var state = this._writableState;
                var ret = false;
                var isBuf = Buffer2.isBuffer(chunk);
                if (typeof encoding === "function") {
                  cb = encoding;
                  encoding = null;
                }
                if (isBuf) encoding = "buffer";
                else if (!encoding) encoding = state.defaultEncoding;
                if (typeof cb !== "function") cb = nop;
                if (state.ended) writeAfterEnd(this, cb);
                else if (isBuf || validChunk(this, state, chunk, cb)) {
                  state.pendingcb++;
                  ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
                }
                return ret;
              };
              Writable.prototype.cork = function() {
                var state = this._writableState;
                state.corked++;
              };
              Writable.prototype.uncork = function() {
                var state = this._writableState;
                if (state.corked) {
                  state.corked--;
                  if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
                }
              };
              Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
                if (typeof encoding === "string") encoding = encoding.toLowerCase();
                if (!(["hex", "utf8", "utf-8", "ascii", "binary", "base64", "ucs2", "ucs-2", "utf16le", "utf-16le", "raw"].indexOf((encoding + "").toLowerCase()) > -1)) throw new TypeError("Unknown encoding: " + encoding);
                this._writableState.defaultEncoding = encoding;
                return this;
              };
              function decodeChunk(state, chunk, encoding) {
                if (!state.objectMode && state.decodeStrings !== false && typeof chunk === "string") {
                  chunk = bufferShim.from(chunk, encoding);
                }
                return chunk;
              }
              function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
                if (!isBuf) {
                  chunk = decodeChunk(state, chunk, encoding);
                  if (Buffer2.isBuffer(chunk)) encoding = "buffer";
                }
                var len = state.objectMode ? 1 : chunk.length;
                state.length += len;
                var ret = state.length < state.highWaterMark;
                if (!ret) state.needDrain = true;
                if (state.writing || state.corked) {
                  var last = state.lastBufferedRequest;
                  state.lastBufferedRequest = new WriteReq(chunk, encoding, cb);
                  if (last) {
                    last.next = state.lastBufferedRequest;
                  } else {
                    state.bufferedRequest = state.lastBufferedRequest;
                  }
                  state.bufferedRequestCount += 1;
                } else {
                  doWrite(stream, state, false, len, chunk, encoding, cb);
                }
                return ret;
              }
              function doWrite(stream, state, writev, len, chunk, encoding, cb) {
                state.writelen = len;
                state.writecb = cb;
                state.writing = true;
                state.sync = true;
                if (writev) stream._writev(chunk, state.onwrite);
                else stream._write(chunk, encoding, state.onwrite);
                state.sync = false;
              }
              function onwriteError(stream, state, sync, er, cb) {
                --state.pendingcb;
                if (sync) processNextTick(cb, er);
                else cb(er);
                stream._writableState.errorEmitted = true;
                stream.emit("error", er);
              }
              function onwriteStateUpdate(state) {
                state.writing = false;
                state.writecb = null;
                state.length -= state.writelen;
                state.writelen = 0;
              }
              function onwrite(stream, er) {
                var state = stream._writableState;
                var sync = state.sync;
                var cb = state.writecb;
                onwriteStateUpdate(state);
                if (er) onwriteError(stream, state, sync, er, cb);
                else {
                  var finished = needFinish(state);
                  if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
                    clearBuffer(stream, state);
                  }
                  if (sync) {
                    asyncWrite(afterWrite, stream, state, finished, cb);
                  } else {
                    afterWrite(stream, state, finished, cb);
                  }
                }
              }
              function afterWrite(stream, state, finished, cb) {
                if (!finished) onwriteDrain(stream, state);
                state.pendingcb--;
                cb();
                finishMaybe(stream, state);
              }
              function onwriteDrain(stream, state) {
                if (state.length === 0 && state.needDrain) {
                  state.needDrain = false;
                  stream.emit("drain");
                }
              }
              function clearBuffer(stream, state) {
                state.bufferProcessing = true;
                var entry = state.bufferedRequest;
                if (stream._writev && entry && entry.next) {
                  var l = state.bufferedRequestCount;
                  var buffer = new Array(l);
                  var holder = state.corkedRequestsFree;
                  holder.entry = entry;
                  var count = 0;
                  while (entry) {
                    buffer[count] = entry;
                    entry = entry.next;
                    count += 1;
                  }
                  doWrite(stream, state, true, state.length, buffer, "", holder.finish);
                  state.pendingcb++;
                  state.lastBufferedRequest = null;
                  if (holder.next) {
                    state.corkedRequestsFree = holder.next;
                    holder.next = null;
                  } else {
                    state.corkedRequestsFree = new CorkedRequest(state);
                  }
                } else {
                  while (entry) {
                    var chunk = entry.chunk;
                    var encoding = entry.encoding;
                    var cb = entry.callback;
                    var len = state.objectMode ? 1 : chunk.length;
                    doWrite(stream, state, false, len, chunk, encoding, cb);
                    entry = entry.next;
                    if (state.writing) {
                      break;
                    }
                  }
                  if (entry === null) state.lastBufferedRequest = null;
                }
                state.bufferedRequestCount = 0;
                state.bufferedRequest = entry;
                state.bufferProcessing = false;
              }
              Writable.prototype._write = function(chunk, encoding, cb) {
                cb(new Error("_write() is not implemented"));
              };
              Writable.prototype._writev = null;
              Writable.prototype.end = function(chunk, encoding, cb) {
                var state = this._writableState;
                if (typeof chunk === "function") {
                  cb = chunk;
                  chunk = null;
                  encoding = null;
                } else if (typeof encoding === "function") {
                  cb = encoding;
                  encoding = null;
                }
                if (chunk !== null && chunk !== void 0) this.write(chunk, encoding);
                if (state.corked) {
                  state.corked = 1;
                  this.uncork();
                }
                if (!state.ending && !state.finished) endWritable(this, state, cb);
              };
              function needFinish(state) {
                return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
              }
              function prefinish(stream, state) {
                if (!state.prefinished) {
                  state.prefinished = true;
                  stream.emit("prefinish");
                }
              }
              function finishMaybe(stream, state) {
                var need = needFinish(state);
                if (need) {
                  if (state.pendingcb === 0) {
                    prefinish(stream, state);
                    state.finished = true;
                    stream.emit("finish");
                  } else {
                    prefinish(stream, state);
                  }
                }
                return need;
              }
              function endWritable(stream, state, cb) {
                state.ending = true;
                finishMaybe(stream, state);
                if (cb) {
                  if (state.finished) processNextTick(cb);
                  else stream.once("finish", cb);
                }
                state.ended = true;
                stream.writable = false;
              }
              function CorkedRequest(state) {
                var _this = this;
                this.next = null;
                this.entry = null;
                this.finish = function(err) {
                  var entry = _this.entry;
                  _this.entry = null;
                  while (entry) {
                    var cb = entry.callback;
                    state.pendingcb--;
                    cb(err);
                    entry = entry.next;
                  }
                  if (state.corkedRequestsFree) {
                    state.corkedRequestsFree.next = _this;
                  } else {
                    state.corkedRequestsFree = _this;
                  }
                };
              }
            }).call(exports2, __webpack_require__(6));
          },
          /* 23 */
          /***/
          function(module3, exports2) {
            (function(global2) {
              module3.exports = deprecate;
              function deprecate(fn, msg) {
                if (config("noDeprecation")) {
                  return fn;
                }
                var warned = false;
                function deprecated() {
                  if (!warned) {
                    if (config("throwDeprecation")) {
                      throw new Error(msg);
                    } else if (config("traceDeprecation")) {
                      console.trace(msg);
                    } else {
                      console.warn(msg);
                    }
                    warned = true;
                  }
                  return fn.apply(this, arguments);
                }
                return deprecated;
              }
              function config(name) {
                try {
                  if (!global2.localStorage) return false;
                } catch (_) {
                  return false;
                }
                var val = global2.localStorage[name];
                if (null == val) return false;
                return String(val).toLowerCase() === "true";
              }
            }).call(exports2, /* @__PURE__ */ function() {
              return this;
            }());
          },
          /* 24 */
          /***/
          function(module3, exports2, __webpack_require__) {
            var Buffer2 = __webpack_require__(2).Buffer;
            var isBufferEncoding = Buffer2.isEncoding || function(encoding) {
              switch (encoding && encoding.toLowerCase()) {
                case "hex":
                case "utf8":
                case "utf-8":
                case "ascii":
                case "binary":
                case "base64":
                case "ucs2":
                case "ucs-2":
                case "utf16le":
                case "utf-16le":
                case "raw":
                  return true;
                default:
                  return false;
              }
            };
            function assertEncoding(encoding) {
              if (encoding && !isBufferEncoding(encoding)) {
                throw new Error("Unknown encoding: " + encoding);
              }
            }
            var StringDecoder = exports2.StringDecoder = function(encoding) {
              this.encoding = (encoding || "utf8").toLowerCase().replace(/[-_]/, "");
              assertEncoding(encoding);
              switch (this.encoding) {
                case "utf8":
                  this.surrogateSize = 3;
                  break;
                case "ucs2":
                case "utf16le":
                  this.surrogateSize = 2;
                  this.detectIncompleteChar = utf16DetectIncompleteChar;
                  break;
                case "base64":
                  this.surrogateSize = 3;
                  this.detectIncompleteChar = base64DetectIncompleteChar;
                  break;
                default:
                  this.write = passThroughWrite;
                  return;
              }
              this.charBuffer = new Buffer2(6);
              this.charReceived = 0;
              this.charLength = 0;
            };
            StringDecoder.prototype.write = function(buffer) {
              var charStr = "";
              while (this.charLength) {
                var available = buffer.length >= this.charLength - this.charReceived ? this.charLength - this.charReceived : buffer.length;
                buffer.copy(this.charBuffer, this.charReceived, 0, available);
                this.charReceived += available;
                if (this.charReceived < this.charLength) {
                  return "";
                }
                buffer = buffer.slice(available, buffer.length);
                charStr = this.charBuffer.slice(0, this.charLength).toString(this.encoding);
                var charCode = charStr.charCodeAt(charStr.length - 1);
                if (charCode >= 55296 && charCode <= 56319) {
                  this.charLength += this.surrogateSize;
                  charStr = "";
                  continue;
                }
                this.charReceived = this.charLength = 0;
                if (buffer.length === 0) {
                  return charStr;
                }
                break;
              }
              this.detectIncompleteChar(buffer);
              var end = buffer.length;
              if (this.charLength) {
                buffer.copy(this.charBuffer, 0, buffer.length - this.charReceived, end);
                end -= this.charReceived;
              }
              charStr += buffer.toString(this.encoding, 0, end);
              var end = charStr.length - 1;
              var charCode = charStr.charCodeAt(end);
              if (charCode >= 55296 && charCode <= 56319) {
                var size = this.surrogateSize;
                this.charLength += size;
                this.charReceived += size;
                this.charBuffer.copy(this.charBuffer, size, 0, size);
                buffer.copy(this.charBuffer, 0, 0, size);
                return charStr.substring(0, end);
              }
              return charStr;
            };
            StringDecoder.prototype.detectIncompleteChar = function(buffer) {
              var i = buffer.length >= 3 ? 3 : buffer.length;
              for (; i > 0; i--) {
                var c = buffer[buffer.length - i];
                if (i == 1 && c >> 5 == 6) {
                  this.charLength = 2;
                  break;
                }
                if (i <= 2 && c >> 4 == 14) {
                  this.charLength = 3;
                  break;
                }
                if (i <= 3 && c >> 3 == 30) {
                  this.charLength = 4;
                  break;
                }
              }
              this.charReceived = i;
            };
            StringDecoder.prototype.end = function(buffer) {
              var res = "";
              if (buffer && buffer.length)
                res = this.write(buffer);
              if (this.charReceived) {
                var cr = this.charReceived;
                var buf = this.charBuffer;
                var enc = this.encoding;
                res += buf.slice(0, cr).toString(enc);
              }
              return res;
            };
            function passThroughWrite(buffer) {
              return buffer.toString(this.encoding);
            }
            function utf16DetectIncompleteChar(buffer) {
              this.charReceived = buffer.length % 2;
              this.charLength = this.charReceived ? 2 : 0;
            }
            function base64DetectIncompleteChar(buffer) {
              this.charReceived = buffer.length % 3;
              this.charLength = this.charReceived ? 3 : 0;
            }
          },
          /* 25 */
          /***/
          function(module3, exports2, __webpack_require__) {
            "use strict";
            module3.exports = Transform;
            var Duplex = __webpack_require__(21);
            var util = __webpack_require__(18);
            util.inherits = __webpack_require__(12);
            util.inherits(Transform, Duplex);
            function TransformState(stream) {
              this.afterTransform = function(er, data) {
                return afterTransform(stream, er, data);
              };
              this.needTransform = false;
              this.transforming = false;
              this.writecb = null;
              this.writechunk = null;
              this.writeencoding = null;
            }
            function afterTransform(stream, er, data) {
              var ts = stream._transformState;
              ts.transforming = false;
              var cb = ts.writecb;
              if (!cb) return stream.emit("error", new Error("no writecb in Transform class"));
              ts.writechunk = null;
              ts.writecb = null;
              if (data !== null && data !== void 0) stream.push(data);
              cb(er);
              var rs = stream._readableState;
              rs.reading = false;
              if (rs.needReadable || rs.length < rs.highWaterMark) {
                stream._read(rs.highWaterMark);
              }
            }
            function Transform(options) {
              if (!(this instanceof Transform)) return new Transform(options);
              Duplex.call(this, options);
              this._transformState = new TransformState(this);
              var stream = this;
              this._readableState.needReadable = true;
              this._readableState.sync = false;
              if (options) {
                if (typeof options.transform === "function") this._transform = options.transform;
                if (typeof options.flush === "function") this._flush = options.flush;
              }
              this.once("prefinish", function() {
                if (typeof this._flush === "function") this._flush(function(er, data) {
                  done(stream, er, data);
                });
                else done(stream);
              });
            }
            Transform.prototype.push = function(chunk, encoding) {
              this._transformState.needTransform = false;
              return Duplex.prototype.push.call(this, chunk, encoding);
            };
            Transform.prototype._transform = function(chunk, encoding, cb) {
              throw new Error("_transform() is not implemented");
            };
            Transform.prototype._write = function(chunk, encoding, cb) {
              var ts = this._transformState;
              ts.writecb = cb;
              ts.writechunk = chunk;
              ts.writeencoding = encoding;
              if (!ts.transforming) {
                var rs = this._readableState;
                if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
              }
            };
            Transform.prototype._read = function(n) {
              var ts = this._transformState;
              if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
                ts.transforming = true;
                this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
              } else {
                ts.needTransform = true;
              }
            };
            function done(stream, er, data) {
              if (er) return stream.emit("error", er);
              if (data !== null && data !== void 0) stream.push(data);
              var ws = stream._writableState;
              var ts = stream._transformState;
              if (ws.length) throw new Error("Calling transform done when ws.length != 0");
              if (ts.transforming) throw new Error("Calling transform done when still transforming");
              return stream.push(null);
            }
          },
          /* 26 */
          /***/
          function(module3, exports2, __webpack_require__) {
            "use strict";
            module3.exports = PassThrough;
            var Transform = __webpack_require__(25);
            var util = __webpack_require__(18);
            util.inherits = __webpack_require__(12);
            util.inherits(PassThrough, Transform);
            function PassThrough(options) {
              if (!(this instanceof PassThrough)) return new PassThrough(options);
              Transform.call(this, options);
            }
            PassThrough.prototype._transform = function(chunk, encoding, cb) {
              cb(null, chunk);
            };
          },
          /* 27 */
          /***/
          function(module3, exports2, __webpack_require__) {
            module3.exports = __webpack_require__(22);
          },
          /* 28 */
          /***/
          function(module3, exports2, __webpack_require__) {
            module3.exports = __webpack_require__(21);
          },
          /* 29 */
          /***/
          function(module3, exports2, __webpack_require__) {
            module3.exports = __webpack_require__(25);
          },
          /* 30 */
          /***/
          function(module3, exports2, __webpack_require__) {
            module3.exports = __webpack_require__(26);
          },
          /* 31 */
          /***/
          function(module3, exports2, __webpack_require__) {
            "use strict";
            var zlib_inflate = __webpack_require__(32);
            var utils = __webpack_require__(33);
            var strings = __webpack_require__(38);
            var c = __webpack_require__(39);
            var msg = __webpack_require__(40);
            var ZStream = __webpack_require__(41);
            var GZheader = __webpack_require__(42);
            var toString = Object.prototype.toString;
            function Inflate(options) {
              if (!(this instanceof Inflate)) return new Inflate(options);
              this.options = utils.assign({
                chunkSize: 16384,
                windowBits: 0,
                to: ""
              }, options || {});
              var opt = this.options;
              if (opt.raw && opt.windowBits >= 0 && opt.windowBits < 16) {
                opt.windowBits = -opt.windowBits;
                if (opt.windowBits === 0) {
                  opt.windowBits = -15;
                }
              }
              if (opt.windowBits >= 0 && opt.windowBits < 16 && !(options && options.windowBits)) {
                opt.windowBits += 32;
              }
              if (opt.windowBits > 15 && opt.windowBits < 48) {
                if ((opt.windowBits & 15) === 0) {
                  opt.windowBits |= 15;
                }
              }
              this.err = 0;
              this.msg = "";
              this.ended = false;
              this.chunks = [];
              this.strm = new ZStream();
              this.strm.avail_out = 0;
              var status = zlib_inflate.inflateInit2(
                this.strm,
                opt.windowBits
              );
              if (status !== c.Z_OK) {
                throw new Error(msg[status]);
              }
              this.header = new GZheader();
              zlib_inflate.inflateGetHeader(this.strm, this.header);
            }
            Inflate.prototype.push = function(data, mode) {
              var strm = this.strm;
              var chunkSize = this.options.chunkSize;
              var dictionary = this.options.dictionary;
              var status, _mode;
              var next_out_utf8, tail, utf8str;
              var dict;
              var allowBufError = false;
              if (this.ended) {
                return false;
              }
              _mode = mode === ~~mode ? mode : mode === true ? c.Z_FINISH : c.Z_NO_FLUSH;
              if (typeof data === "string") {
                strm.input = strings.binstring2buf(data);
              } else if (toString.call(data) === "[object ArrayBuffer]") {
                strm.input = new Uint8Array(data);
              } else {
                strm.input = data;
              }
              strm.next_in = 0;
              strm.avail_in = strm.input.length;
              do {
                if (strm.avail_out === 0) {
                  strm.output = new utils.Buf8(chunkSize);
                  strm.next_out = 0;
                  strm.avail_out = chunkSize;
                }
                status = zlib_inflate.inflate(strm, c.Z_NO_FLUSH);
                if (status === c.Z_NEED_DICT && dictionary) {
                  if (typeof dictionary === "string") {
                    dict = strings.string2buf(dictionary);
                  } else if (toString.call(dictionary) === "[object ArrayBuffer]") {
                    dict = new Uint8Array(dictionary);
                  } else {
                    dict = dictionary;
                  }
                  status = zlib_inflate.inflateSetDictionary(this.strm, dict);
                }
                if (status === c.Z_BUF_ERROR && allowBufError === true) {
                  status = c.Z_OK;
                  allowBufError = false;
                }
                if (status !== c.Z_STREAM_END && status !== c.Z_OK) {
                  this.onEnd(status);
                  this.ended = true;
                  return false;
                }
                if (strm.next_out) {
                  if (strm.avail_out === 0 || status === c.Z_STREAM_END || strm.avail_in === 0 && (_mode === c.Z_FINISH || _mode === c.Z_SYNC_FLUSH)) {
                    if (this.options.to === "string") {
                      next_out_utf8 = strings.utf8border(strm.output, strm.next_out);
                      tail = strm.next_out - next_out_utf8;
                      utf8str = strings.buf2string(strm.output, next_out_utf8);
                      strm.next_out = tail;
                      strm.avail_out = chunkSize - tail;
                      if (tail) {
                        utils.arraySet(strm.output, strm.output, next_out_utf8, tail, 0);
                      }
                      this.onData(utf8str);
                    } else {
                      this.onData(utils.shrinkBuf(strm.output, strm.next_out));
                    }
                  }
                }
                if (strm.avail_in === 0 && strm.avail_out === 0) {
                  allowBufError = true;
                }
              } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== c.Z_STREAM_END);
              if (status === c.Z_STREAM_END) {
                _mode = c.Z_FINISH;
              }
              if (_mode === c.Z_FINISH) {
                status = zlib_inflate.inflateEnd(this.strm);
                this.onEnd(status);
                this.ended = true;
                return status === c.Z_OK;
              }
              if (_mode === c.Z_SYNC_FLUSH) {
                this.onEnd(c.Z_OK);
                strm.avail_out = 0;
                return true;
              }
              return true;
            };
            Inflate.prototype.onData = function(chunk) {
              this.chunks.push(chunk);
            };
            Inflate.prototype.onEnd = function(status) {
              if (status === c.Z_OK) {
                if (this.options.to === "string") {
                  this.result = this.chunks.join("");
                } else {
                  this.result = utils.flattenChunks(this.chunks);
                }
              }
              this.chunks = [];
              this.err = status;
              this.msg = this.strm.msg;
            };
            function inflate(input, options) {
              var inflator = new Inflate(options);
              inflator.push(input, true);
              if (inflator.err) {
                throw inflator.msg || msg[inflator.err];
              }
              return inflator.result;
            }
            function inflateRaw(input, options) {
              options = options || {};
              options.raw = true;
              return inflate(input, options);
            }
            exports2.Inflate = Inflate;
            exports2.inflate = inflate;
            exports2.inflateRaw = inflateRaw;
            exports2.ungzip = inflate;
          },
          /* 32 */
          /***/
          function(module3, exports2, __webpack_require__) {
            "use strict";
            var utils = __webpack_require__(33);
            var adler32 = __webpack_require__(34);
            var crc32 = __webpack_require__(35);
            var inflate_fast = __webpack_require__(36);
            var inflate_table = __webpack_require__(37);
            var CODES = 0;
            var LENS = 1;
            var DISTS = 2;
            var Z_FINISH = 4;
            var Z_BLOCK = 5;
            var Z_TREES = 6;
            var Z_OK = 0;
            var Z_STREAM_END = 1;
            var Z_NEED_DICT = 2;
            var Z_STREAM_ERROR = -2;
            var Z_DATA_ERROR = -3;
            var Z_MEM_ERROR = -4;
            var Z_BUF_ERROR = -5;
            var Z_DEFLATED = 8;
            var HEAD = 1;
            var FLAGS = 2;
            var TIME = 3;
            var OS = 4;
            var EXLEN = 5;
            var EXTRA = 6;
            var NAME2 = 7;
            var COMMENT = 8;
            var HCRC = 9;
            var DICTID = 10;
            var DICT = 11;
            var TYPE = 12;
            var TYPEDO = 13;
            var STORED = 14;
            var COPY_ = 15;
            var COPY = 16;
            var TABLE = 17;
            var LENLENS = 18;
            var CODELENS = 19;
            var LEN_ = 20;
            var LEN = 21;
            var LENEXT = 22;
            var DIST = 23;
            var DISTEXT = 24;
            var MATCH = 25;
            var LIT = 26;
            var CHECK = 27;
            var LENGTH = 28;
            var DONE = 29;
            var BAD = 30;
            var MEM = 31;
            var SYNC = 32;
            var ENOUGH_LENS = 852;
            var ENOUGH_DISTS = 592;
            var MAX_WBITS = 15;
            var DEF_WBITS = MAX_WBITS;
            function zswap32(q) {
              return (q >>> 24 & 255) + (q >>> 8 & 65280) + ((q & 65280) << 8) + ((q & 255) << 24);
            }
            function InflateState() {
              this.mode = 0;
              this.last = false;
              this.wrap = 0;
              this.havedict = false;
              this.flags = 0;
              this.dmax = 0;
              this.check = 0;
              this.total = 0;
              this.head = null;
              this.wbits = 0;
              this.wsize = 0;
              this.whave = 0;
              this.wnext = 0;
              this.window = null;
              this.hold = 0;
              this.bits = 0;
              this.length = 0;
              this.offset = 0;
              this.extra = 0;
              this.lencode = null;
              this.distcode = null;
              this.lenbits = 0;
              this.distbits = 0;
              this.ncode = 0;
              this.nlen = 0;
              this.ndist = 0;
              this.have = 0;
              this.next = null;
              this.lens = new utils.Buf16(320);
              this.work = new utils.Buf16(288);
              this.lendyn = null;
              this.distdyn = null;
              this.sane = 0;
              this.back = 0;
              this.was = 0;
            }
            function inflateResetKeep(strm) {
              var state;
              if (!strm || !strm.state) {
                return Z_STREAM_ERROR;
              }
              state = strm.state;
              strm.total_in = strm.total_out = state.total = 0;
              strm.msg = "";
              if (state.wrap) {
                strm.adler = state.wrap & 1;
              }
              state.mode = HEAD;
              state.last = 0;
              state.havedict = 0;
              state.dmax = 32768;
              state.head = null;
              state.hold = 0;
              state.bits = 0;
              state.lencode = state.lendyn = new utils.Buf32(ENOUGH_LENS);
              state.distcode = state.distdyn = new utils.Buf32(ENOUGH_DISTS);
              state.sane = 1;
              state.back = -1;
              return Z_OK;
            }
            function inflateReset(strm) {
              var state;
              if (!strm || !strm.state) {
                return Z_STREAM_ERROR;
              }
              state = strm.state;
              state.wsize = 0;
              state.whave = 0;
              state.wnext = 0;
              return inflateResetKeep(strm);
            }
            function inflateReset2(strm, windowBits) {
              var wrap;
              var state;
              if (!strm || !strm.state) {
                return Z_STREAM_ERROR;
              }
              state = strm.state;
              if (windowBits < 0) {
                wrap = 0;
                windowBits = -windowBits;
              } else {
                wrap = (windowBits >> 4) + 1;
                if (windowBits < 48) {
                  windowBits &= 15;
                }
              }
              if (windowBits && (windowBits < 8 || windowBits > 15)) {
                return Z_STREAM_ERROR;
              }
              if (state.window !== null && state.wbits !== windowBits) {
                state.window = null;
              }
              state.wrap = wrap;
              state.wbits = windowBits;
              return inflateReset(strm);
            }
            function inflateInit2(strm, windowBits) {
              var ret;
              var state;
              if (!strm) {
                return Z_STREAM_ERROR;
              }
              state = new InflateState();
              strm.state = state;
              state.window = null;
              ret = inflateReset2(strm, windowBits);
              if (ret !== Z_OK) {
                strm.state = null;
              }
              return ret;
            }
            function inflateInit(strm) {
              return inflateInit2(strm, DEF_WBITS);
            }
            var virgin = true;
            var lenfix, distfix;
            function fixedtables(state) {
              if (virgin) {
                var sym;
                lenfix = new utils.Buf32(512);
                distfix = new utils.Buf32(32);
                sym = 0;
                while (sym < 144) {
                  state.lens[sym++] = 8;
                }
                while (sym < 256) {
                  state.lens[sym++] = 9;
                }
                while (sym < 280) {
                  state.lens[sym++] = 7;
                }
                while (sym < 288) {
                  state.lens[sym++] = 8;
                }
                inflate_table(LENS, state.lens, 0, 288, lenfix, 0, state.work, { bits: 9 });
                sym = 0;
                while (sym < 32) {
                  state.lens[sym++] = 5;
                }
                inflate_table(DISTS, state.lens, 0, 32, distfix, 0, state.work, { bits: 5 });
                virgin = false;
              }
              state.lencode = lenfix;
              state.lenbits = 9;
              state.distcode = distfix;
              state.distbits = 5;
            }
            function updatewindow(strm, src, end, copy) {
              var dist;
              var state = strm.state;
              if (state.window === null) {
                state.wsize = 1 << state.wbits;
                state.wnext = 0;
                state.whave = 0;
                state.window = new utils.Buf8(state.wsize);
              }
              if (copy >= state.wsize) {
                utils.arraySet(state.window, src, end - state.wsize, state.wsize, 0);
                state.wnext = 0;
                state.whave = state.wsize;
              } else {
                dist = state.wsize - state.wnext;
                if (dist > copy) {
                  dist = copy;
                }
                utils.arraySet(state.window, src, end - copy, dist, state.wnext);
                copy -= dist;
                if (copy) {
                  utils.arraySet(state.window, src, end - copy, copy, 0);
                  state.wnext = copy;
                  state.whave = state.wsize;
                } else {
                  state.wnext += dist;
                  if (state.wnext === state.wsize) {
                    state.wnext = 0;
                  }
                  if (state.whave < state.wsize) {
                    state.whave += dist;
                  }
                }
              }
              return 0;
            }
            function inflate(strm, flush) {
              var state;
              var input, output;
              var next;
              var put;
              var have, left;
              var hold;
              var bits;
              var _in, _out;
              var copy;
              var from;
              var from_source;
              var here = 0;
              var here_bits, here_op, here_val;
              var last_bits, last_op, last_val;
              var len;
              var ret;
              var hbuf = new utils.Buf8(4);
              var opts;
              var n;
              var order = (
                /* permutation of code lengths */
                [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]
              );
              if (!strm || !strm.state || !strm.output || !strm.input && strm.avail_in !== 0) {
                return Z_STREAM_ERROR;
              }
              state = strm.state;
              if (state.mode === TYPE) {
                state.mode = TYPEDO;
              }
              put = strm.next_out;
              output = strm.output;
              left = strm.avail_out;
              next = strm.next_in;
              input = strm.input;
              have = strm.avail_in;
              hold = state.hold;
              bits = state.bits;
              _in = have;
              _out = left;
              ret = Z_OK;
              inf_leave:
                for (; ; ) {
                  switch (state.mode) {
                    case HEAD:
                      if (state.wrap === 0) {
                        state.mode = TYPEDO;
                        break;
                      }
                      while (bits < 16) {
                        if (have === 0) {
                          break inf_leave;
                        }
                        have--;
                        hold += input[next++] << bits;
                        bits += 8;
                      }
                      if (state.wrap & 2 && hold === 35615) {
                        state.check = 0;
                        hbuf[0] = hold & 255;
                        hbuf[1] = hold >>> 8 & 255;
                        state.check = crc32(state.check, hbuf, 2, 0);
                        hold = 0;
                        bits = 0;
                        state.mode = FLAGS;
                        break;
                      }
                      state.flags = 0;
                      if (state.head) {
                        state.head.done = false;
                      }
                      if (!(state.wrap & 1) || /* check if zlib header allowed */
                      (((hold & 255) << 8) + (hold >> 8)) % 31) {
                        strm.msg = "incorrect header check";
                        state.mode = BAD;
                        break;
                      }
                      if ((hold & 15) !== Z_DEFLATED) {
                        strm.msg = "unknown compression method";
                        state.mode = BAD;
                        break;
                      }
                      hold >>>= 4;
                      bits -= 4;
                      len = (hold & 15) + 8;
                      if (state.wbits === 0) {
                        state.wbits = len;
                      } else if (len > state.wbits) {
                        strm.msg = "invalid window size";
                        state.mode = BAD;
                        break;
                      }
                      state.dmax = 1 << len;
                      strm.adler = state.check = 1;
                      state.mode = hold & 512 ? DICTID : TYPE;
                      hold = 0;
                      bits = 0;
                      break;
                    case FLAGS:
                      while (bits < 16) {
                        if (have === 0) {
                          break inf_leave;
                        }
                        have--;
                        hold += input[next++] << bits;
                        bits += 8;
                      }
                      state.flags = hold;
                      if ((state.flags & 255) !== Z_DEFLATED) {
                        strm.msg = "unknown compression method";
                        state.mode = BAD;
                        break;
                      }
                      if (state.flags & 57344) {
                        strm.msg = "unknown header flags set";
                        state.mode = BAD;
                        break;
                      }
                      if (state.head) {
                        state.head.text = hold >> 8 & 1;
                      }
                      if (state.flags & 512) {
                        hbuf[0] = hold & 255;
                        hbuf[1] = hold >>> 8 & 255;
                        state.check = crc32(state.check, hbuf, 2, 0);
                      }
                      hold = 0;
                      bits = 0;
                      state.mode = TIME;
                    /* falls through */
                    case TIME:
                      while (bits < 32) {
                        if (have === 0) {
                          break inf_leave;
                        }
                        have--;
                        hold += input[next++] << bits;
                        bits += 8;
                      }
                      if (state.head) {
                        state.head.time = hold;
                      }
                      if (state.flags & 512) {
                        hbuf[0] = hold & 255;
                        hbuf[1] = hold >>> 8 & 255;
                        hbuf[2] = hold >>> 16 & 255;
                        hbuf[3] = hold >>> 24 & 255;
                        state.check = crc32(state.check, hbuf, 4, 0);
                      }
                      hold = 0;
                      bits = 0;
                      state.mode = OS;
                    /* falls through */
                    case OS:
                      while (bits < 16) {
                        if (have === 0) {
                          break inf_leave;
                        }
                        have--;
                        hold += input[next++] << bits;
                        bits += 8;
                      }
                      if (state.head) {
                        state.head.xflags = hold & 255;
                        state.head.os = hold >> 8;
                      }
                      if (state.flags & 512) {
                        hbuf[0] = hold & 255;
                        hbuf[1] = hold >>> 8 & 255;
                        state.check = crc32(state.check, hbuf, 2, 0);
                      }
                      hold = 0;
                      bits = 0;
                      state.mode = EXLEN;
                    /* falls through */
                    case EXLEN:
                      if (state.flags & 1024) {
                        while (bits < 16) {
                          if (have === 0) {
                            break inf_leave;
                          }
                          have--;
                          hold += input[next++] << bits;
                          bits += 8;
                        }
                        state.length = hold;
                        if (state.head) {
                          state.head.extra_len = hold;
                        }
                        if (state.flags & 512) {
                          hbuf[0] = hold & 255;
                          hbuf[1] = hold >>> 8 & 255;
                          state.check = crc32(state.check, hbuf, 2, 0);
                        }
                        hold = 0;
                        bits = 0;
                      } else if (state.head) {
                        state.head.extra = null;
                      }
                      state.mode = EXTRA;
                    /* falls through */
                    case EXTRA:
                      if (state.flags & 1024) {
                        copy = state.length;
                        if (copy > have) {
                          copy = have;
                        }
                        if (copy) {
                          if (state.head) {
                            len = state.head.extra_len - state.length;
                            if (!state.head.extra) {
                              state.head.extra = new Array(state.head.extra_len);
                            }
                            utils.arraySet(
                              state.head.extra,
                              input,
                              next,
                              // extra field is limited to 65536 bytes
                              // - no need for additional size check
                              copy,
                              /*len + copy > state.head.extra_max - len ? state.head.extra_max : copy,*/
                              len
                            );
                          }
                          if (state.flags & 512) {
                            state.check = crc32(state.check, input, copy, next);
                          }
                          have -= copy;
                          next += copy;
                          state.length -= copy;
                        }
                        if (state.length) {
                          break inf_leave;
                        }
                      }
                      state.length = 0;
                      state.mode = NAME2;
                    /* falls through */
                    case NAME2:
                      if (state.flags & 2048) {
                        if (have === 0) {
                          break inf_leave;
                        }
                        copy = 0;
                        do {
                          len = input[next + copy++];
                          if (state.head && len && state.length < 65536) {
                            state.head.name += String.fromCharCode(len);
                          }
                        } while (len && copy < have);
                        if (state.flags & 512) {
                          state.check = crc32(state.check, input, copy, next);
                        }
                        have -= copy;
                        next += copy;
                        if (len) {
                          break inf_leave;
                        }
                      } else if (state.head) {
                        state.head.name = null;
                      }
                      state.length = 0;
                      state.mode = COMMENT;
                    /* falls through */
                    case COMMENT:
                      if (state.flags & 4096) {
                        if (have === 0) {
                          break inf_leave;
                        }
                        copy = 0;
                        do {
                          len = input[next + copy++];
                          if (state.head && len && state.length < 65536) {
                            state.head.comment += String.fromCharCode(len);
                          }
                        } while (len && copy < have);
                        if (state.flags & 512) {
                          state.check = crc32(state.check, input, copy, next);
                        }
                        have -= copy;
                        next += copy;
                        if (len) {
                          break inf_leave;
                        }
                      } else if (state.head) {
                        state.head.comment = null;
                      }
                      state.mode = HCRC;
                    /* falls through */
                    case HCRC:
                      if (state.flags & 512) {
                        while (bits < 16) {
                          if (have === 0) {
                            break inf_leave;
                          }
                          have--;
                          hold += input[next++] << bits;
                          bits += 8;
                        }
                        if (hold !== (state.check & 65535)) {
                          strm.msg = "header crc mismatch";
                          state.mode = BAD;
                          break;
                        }
                        hold = 0;
                        bits = 0;
                      }
                      if (state.head) {
                        state.head.hcrc = state.flags >> 9 & 1;
                        state.head.done = true;
                      }
                      strm.adler = state.check = 0;
                      state.mode = TYPE;
                      break;
                    case DICTID:
                      while (bits < 32) {
                        if (have === 0) {
                          break inf_leave;
                        }
                        have--;
                        hold += input[next++] << bits;
                        bits += 8;
                      }
                      strm.adler = state.check = zswap32(hold);
                      hold = 0;
                      bits = 0;
                      state.mode = DICT;
                    /* falls through */
                    case DICT:
                      if (state.havedict === 0) {
                        strm.next_out = put;
                        strm.avail_out = left;
                        strm.next_in = next;
                        strm.avail_in = have;
                        state.hold = hold;
                        state.bits = bits;
                        return Z_NEED_DICT;
                      }
                      strm.adler = state.check = 1;
                      state.mode = TYPE;
                    /* falls through */
                    case TYPE:
                      if (flush === Z_BLOCK || flush === Z_TREES) {
                        break inf_leave;
                      }
                    /* falls through */
                    case TYPEDO:
                      if (state.last) {
                        hold >>>= bits & 7;
                        bits -= bits & 7;
                        state.mode = CHECK;
                        break;
                      }
                      while (bits < 3) {
                        if (have === 0) {
                          break inf_leave;
                        }
                        have--;
                        hold += input[next++] << bits;
                        bits += 8;
                      }
                      state.last = hold & 1;
                      hold >>>= 1;
                      bits -= 1;
                      switch (hold & 3) {
                        case 0:
                          state.mode = STORED;
                          break;
                        case 1:
                          fixedtables(state);
                          state.mode = LEN_;
                          if (flush === Z_TREES) {
                            hold >>>= 2;
                            bits -= 2;
                            break inf_leave;
                          }
                          break;
                        case 2:
                          state.mode = TABLE;
                          break;
                        case 3:
                          strm.msg = "invalid block type";
                          state.mode = BAD;
                      }
                      hold >>>= 2;
                      bits -= 2;
                      break;
                    case STORED:
                      hold >>>= bits & 7;
                      bits -= bits & 7;
                      while (bits < 32) {
                        if (have === 0) {
                          break inf_leave;
                        }
                        have--;
                        hold += input[next++] << bits;
                        bits += 8;
                      }
                      if ((hold & 65535) !== (hold >>> 16 ^ 65535)) {
                        strm.msg = "invalid stored block lengths";
                        state.mode = BAD;
                        break;
                      }
                      state.length = hold & 65535;
                      hold = 0;
                      bits = 0;
                      state.mode = COPY_;
                      if (flush === Z_TREES) {
                        break inf_leave;
                      }
                    /* falls through */
                    case COPY_:
                      state.mode = COPY;
                    /* falls through */
                    case COPY:
                      copy = state.length;
                      if (copy) {
                        if (copy > have) {
                          copy = have;
                        }
                        if (copy > left) {
                          copy = left;
                        }
                        if (copy === 0) {
                          break inf_leave;
                        }
                        utils.arraySet(output, input, next, copy, put);
                        have -= copy;
                        next += copy;
                        left -= copy;
                        put += copy;
                        state.length -= copy;
                        break;
                      }
                      state.mode = TYPE;
                      break;
                    case TABLE:
                      while (bits < 14) {
                        if (have === 0) {
                          break inf_leave;
                        }
                        have--;
                        hold += input[next++] << bits;
                        bits += 8;
                      }
                      state.nlen = (hold & 31) + 257;
                      hold >>>= 5;
                      bits -= 5;
                      state.ndist = (hold & 31) + 1;
                      hold >>>= 5;
                      bits -= 5;
                      state.ncode = (hold & 15) + 4;
                      hold >>>= 4;
                      bits -= 4;
                      if (state.nlen > 286 || state.ndist > 30) {
                        strm.msg = "too many length or distance symbols";
                        state.mode = BAD;
                        break;
                      }
                      state.have = 0;
                      state.mode = LENLENS;
                    /* falls through */
                    case LENLENS:
                      while (state.have < state.ncode) {
                        while (bits < 3) {
                          if (have === 0) {
                            break inf_leave;
                          }
                          have--;
                          hold += input[next++] << bits;
                          bits += 8;
                        }
                        state.lens[order[state.have++]] = hold & 7;
                        hold >>>= 3;
                        bits -= 3;
                      }
                      while (state.have < 19) {
                        state.lens[order[state.have++]] = 0;
                      }
                      state.lencode = state.lendyn;
                      state.lenbits = 7;
                      opts = { bits: state.lenbits };
                      ret = inflate_table(CODES, state.lens, 0, 19, state.lencode, 0, state.work, opts);
                      state.lenbits = opts.bits;
                      if (ret) {
                        strm.msg = "invalid code lengths set";
                        state.mode = BAD;
                        break;
                      }
                      state.have = 0;
                      state.mode = CODELENS;
                    /* falls through */
                    case CODELENS:
                      while (state.have < state.nlen + state.ndist) {
                        for (; ; ) {
                          here = state.lencode[hold & (1 << state.lenbits) - 1];
                          here_bits = here >>> 24;
                          here_op = here >>> 16 & 255;
                          here_val = here & 65535;
                          if (here_bits <= bits) {
                            break;
                          }
                          if (have === 0) {
                            break inf_leave;
                          }
                          have--;
                          hold += input[next++] << bits;
                          bits += 8;
                        }
                        if (here_val < 16) {
                          hold >>>= here_bits;
                          bits -= here_bits;
                          state.lens[state.have++] = here_val;
                        } else {
                          if (here_val === 16) {
                            n = here_bits + 2;
                            while (bits < n) {
                              if (have === 0) {
                                break inf_leave;
                              }
                              have--;
                              hold += input[next++] << bits;
                              bits += 8;
                            }
                            hold >>>= here_bits;
                            bits -= here_bits;
                            if (state.have === 0) {
                              strm.msg = "invalid bit length repeat";
                              state.mode = BAD;
                              break;
                            }
                            len = state.lens[state.have - 1];
                            copy = 3 + (hold & 3);
                            hold >>>= 2;
                            bits -= 2;
                          } else if (here_val === 17) {
                            n = here_bits + 3;
                            while (bits < n) {
                              if (have === 0) {
                                break inf_leave;
                              }
                              have--;
                              hold += input[next++] << bits;
                              bits += 8;
                            }
                            hold >>>= here_bits;
                            bits -= here_bits;
                            len = 0;
                            copy = 3 + (hold & 7);
                            hold >>>= 3;
                            bits -= 3;
                          } else {
                            n = here_bits + 7;
                            while (bits < n) {
                              if (have === 0) {
                                break inf_leave;
                              }
                              have--;
                              hold += input[next++] << bits;
                              bits += 8;
                            }
                            hold >>>= here_bits;
                            bits -= here_bits;
                            len = 0;
                            copy = 11 + (hold & 127);
                            hold >>>= 7;
                            bits -= 7;
                          }
                          if (state.have + copy > state.nlen + state.ndist) {
                            strm.msg = "invalid bit length repeat";
                            state.mode = BAD;
                            break;
                          }
                          while (copy--) {
                            state.lens[state.have++] = len;
                          }
                        }
                      }
                      if (state.mode === BAD) {
                        break;
                      }
                      if (state.lens[256] === 0) {
                        strm.msg = "invalid code -- missing end-of-block";
                        state.mode = BAD;
                        break;
                      }
                      state.lenbits = 9;
                      opts = { bits: state.lenbits };
                      ret = inflate_table(LENS, state.lens, 0, state.nlen, state.lencode, 0, state.work, opts);
                      state.lenbits = opts.bits;
                      if (ret) {
                        strm.msg = "invalid literal/lengths set";
                        state.mode = BAD;
                        break;
                      }
                      state.distbits = 6;
                      state.distcode = state.distdyn;
                      opts = { bits: state.distbits };
                      ret = inflate_table(DISTS, state.lens, state.nlen, state.ndist, state.distcode, 0, state.work, opts);
                      state.distbits = opts.bits;
                      if (ret) {
                        strm.msg = "invalid distances set";
                        state.mode = BAD;
                        break;
                      }
                      state.mode = LEN_;
                      if (flush === Z_TREES) {
                        break inf_leave;
                      }
                    /* falls through */
                    case LEN_:
                      state.mode = LEN;
                    /* falls through */
                    case LEN:
                      if (have >= 6 && left >= 258) {
                        strm.next_out = put;
                        strm.avail_out = left;
                        strm.next_in = next;
                        strm.avail_in = have;
                        state.hold = hold;
                        state.bits = bits;
                        inflate_fast(strm, _out);
                        put = strm.next_out;
                        output = strm.output;
                        left = strm.avail_out;
                        next = strm.next_in;
                        input = strm.input;
                        have = strm.avail_in;
                        hold = state.hold;
                        bits = state.bits;
                        if (state.mode === TYPE) {
                          state.back = -1;
                        }
                        break;
                      }
                      state.back = 0;
                      for (; ; ) {
                        here = state.lencode[hold & (1 << state.lenbits) - 1];
                        here_bits = here >>> 24;
                        here_op = here >>> 16 & 255;
                        here_val = here & 65535;
                        if (here_bits <= bits) {
                          break;
                        }
                        if (have === 0) {
                          break inf_leave;
                        }
                        have--;
                        hold += input[next++] << bits;
                        bits += 8;
                      }
                      if (here_op && (here_op & 240) === 0) {
                        last_bits = here_bits;
                        last_op = here_op;
                        last_val = here_val;
                        for (; ; ) {
                          here = state.lencode[last_val + ((hold & (1 << last_bits + last_op) - 1) >> last_bits)];
                          here_bits = here >>> 24;
                          here_op = here >>> 16 & 255;
                          here_val = here & 65535;
                          if (last_bits + here_bits <= bits) {
                            break;
                          }
                          if (have === 0) {
                            break inf_leave;
                          }
                          have--;
                          hold += input[next++] << bits;
                          bits += 8;
                        }
                        hold >>>= last_bits;
                        bits -= last_bits;
                        state.back += last_bits;
                      }
                      hold >>>= here_bits;
                      bits -= here_bits;
                      state.back += here_bits;
                      state.length = here_val;
                      if (here_op === 0) {
                        state.mode = LIT;
                        break;
                      }
                      if (here_op & 32) {
                        state.back = -1;
                        state.mode = TYPE;
                        break;
                      }
                      if (here_op & 64) {
                        strm.msg = "invalid literal/length code";
                        state.mode = BAD;
                        break;
                      }
                      state.extra = here_op & 15;
                      state.mode = LENEXT;
                    /* falls through */
                    case LENEXT:
                      if (state.extra) {
                        n = state.extra;
                        while (bits < n) {
                          if (have === 0) {
                            break inf_leave;
                          }
                          have--;
                          hold += input[next++] << bits;
                          bits += 8;
                        }
                        state.length += hold & (1 << state.extra) - 1;
                        hold >>>= state.extra;
                        bits -= state.extra;
                        state.back += state.extra;
                      }
                      state.was = state.length;
                      state.mode = DIST;
                    /* falls through */
                    case DIST:
                      for (; ; ) {
                        here = state.distcode[hold & (1 << state.distbits) - 1];
                        here_bits = here >>> 24;
                        here_op = here >>> 16 & 255;
                        here_val = here & 65535;
                        if (here_bits <= bits) {
                          break;
                        }
                        if (have === 0) {
                          break inf_leave;
                        }
                        have--;
                        hold += input[next++] << bits;
                        bits += 8;
                      }
                      if ((here_op & 240) === 0) {
                        last_bits = here_bits;
                        last_op = here_op;
                        last_val = here_val;
                        for (; ; ) {
                          here = state.distcode[last_val + ((hold & (1 << last_bits + last_op) - 1) >> last_bits)];
                          here_bits = here >>> 24;
                          here_op = here >>> 16 & 255;
                          here_val = here & 65535;
                          if (last_bits + here_bits <= bits) {
                            break;
                          }
                          if (have === 0) {
                            break inf_leave;
                          }
                          have--;
                          hold += input[next++] << bits;
                          bits += 8;
                        }
                        hold >>>= last_bits;
                        bits -= last_bits;
                        state.back += last_bits;
                      }
                      hold >>>= here_bits;
                      bits -= here_bits;
                      state.back += here_bits;
                      if (here_op & 64) {
                        strm.msg = "invalid distance code";
                        state.mode = BAD;
                        break;
                      }
                      state.offset = here_val;
                      state.extra = here_op & 15;
                      state.mode = DISTEXT;
                    /* falls through */
                    case DISTEXT:
                      if (state.extra) {
                        n = state.extra;
                        while (bits < n) {
                          if (have === 0) {
                            break inf_leave;
                          }
                          have--;
                          hold += input[next++] << bits;
                          bits += 8;
                        }
                        state.offset += hold & (1 << state.extra) - 1;
                        hold >>>= state.extra;
                        bits -= state.extra;
                        state.back += state.extra;
                      }
                      if (state.offset > state.dmax) {
                        strm.msg = "invalid distance too far back";
                        state.mode = BAD;
                        break;
                      }
                      state.mode = MATCH;
                    /* falls through */
                    case MATCH:
                      if (left === 0) {
                        break inf_leave;
                      }
                      copy = _out - left;
                      if (state.offset > copy) {
                        copy = state.offset - copy;
                        if (copy > state.whave) {
                          if (state.sane) {
                            strm.msg = "invalid distance too far back";
                            state.mode = BAD;
                            break;
                          }
                        }
                        if (copy > state.wnext) {
                          copy -= state.wnext;
                          from = state.wsize - copy;
                        } else {
                          from = state.wnext - copy;
                        }
                        if (copy > state.length) {
                          copy = state.length;
                        }
                        from_source = state.window;
                      } else {
                        from_source = output;
                        from = put - state.offset;
                        copy = state.length;
                      }
                      if (copy > left) {
                        copy = left;
                      }
                      left -= copy;
                      state.length -= copy;
                      do {
                        output[put++] = from_source[from++];
                      } while (--copy);
                      if (state.length === 0) {
                        state.mode = LEN;
                      }
                      break;
                    case LIT:
                      if (left === 0) {
                        break inf_leave;
                      }
                      output[put++] = state.length;
                      left--;
                      state.mode = LEN;
                      break;
                    case CHECK:
                      if (state.wrap) {
                        while (bits < 32) {
                          if (have === 0) {
                            break inf_leave;
                          }
                          have--;
                          hold |= input[next++] << bits;
                          bits += 8;
                        }
                        _out -= left;
                        strm.total_out += _out;
                        state.total += _out;
                        if (_out) {
                          strm.adler = state.check = /*UPDATE(state.check, put - _out, _out);*/
                          state.flags ? crc32(state.check, output, _out, put - _out) : adler32(state.check, output, _out, put - _out);
                        }
                        _out = left;
                        if ((state.flags ? hold : zswap32(hold)) !== state.check) {
                          strm.msg = "incorrect data check";
                          state.mode = BAD;
                          break;
                        }
                        hold = 0;
                        bits = 0;
                      }
                      state.mode = LENGTH;
                    /* falls through */
                    case LENGTH:
                      if (state.wrap && state.flags) {
                        while (bits < 32) {
                          if (have === 0) {
                            break inf_leave;
                          }
                          have--;
                          hold += input[next++] << bits;
                          bits += 8;
                        }
                        if (hold !== (state.total & 4294967295)) {
                          strm.msg = "incorrect length check";
                          state.mode = BAD;
                          break;
                        }
                        hold = 0;
                        bits = 0;
                      }
                      state.mode = DONE;
                    /* falls through */
                    case DONE:
                      ret = Z_STREAM_END;
                      break inf_leave;
                    case BAD:
                      ret = Z_DATA_ERROR;
                      break inf_leave;
                    case MEM:
                      return Z_MEM_ERROR;
                    case SYNC:
                    /* falls through */
                    default:
                      return Z_STREAM_ERROR;
                  }
                }
              strm.next_out = put;
              strm.avail_out = left;
              strm.next_in = next;
              strm.avail_in = have;
              state.hold = hold;
              state.bits = bits;
              if (state.wsize || _out !== strm.avail_out && state.mode < BAD && (state.mode < CHECK || flush !== Z_FINISH)) {
                if (updatewindow(strm, strm.output, strm.next_out, _out - strm.avail_out)) {
                  state.mode = MEM;
                  return Z_MEM_ERROR;
                }
              }
              _in -= strm.avail_in;
              _out -= strm.avail_out;
              strm.total_in += _in;
              strm.total_out += _out;
              state.total += _out;
              if (state.wrap && _out) {
                strm.adler = state.check = /*UPDATE(state.check, strm.next_out - _out, _out);*/
                state.flags ? crc32(state.check, output, _out, strm.next_out - _out) : adler32(state.check, output, _out, strm.next_out - _out);
              }
              strm.data_type = state.bits + (state.last ? 64 : 0) + (state.mode === TYPE ? 128 : 0) + (state.mode === LEN_ || state.mode === COPY_ ? 256 : 0);
              if ((_in === 0 && _out === 0 || flush === Z_FINISH) && ret === Z_OK) {
                ret = Z_BUF_ERROR;
              }
              return ret;
            }
            function inflateEnd(strm) {
              if (!strm || !strm.state) {
                return Z_STREAM_ERROR;
              }
              var state = strm.state;
              if (state.window) {
                state.window = null;
              }
              strm.state = null;
              return Z_OK;
            }
            function inflateGetHeader(strm, head) {
              var state;
              if (!strm || !strm.state) {
                return Z_STREAM_ERROR;
              }
              state = strm.state;
              if ((state.wrap & 2) === 0) {
                return Z_STREAM_ERROR;
              }
              state.head = head;
              head.done = false;
              return Z_OK;
            }
            function inflateSetDictionary(strm, dictionary) {
              var dictLength = dictionary.length;
              var state;
              var dictid;
              var ret;
              if (!strm || !strm.state) {
                return Z_STREAM_ERROR;
              }
              state = strm.state;
              if (state.wrap !== 0 && state.mode !== DICT) {
                return Z_STREAM_ERROR;
              }
              if (state.mode === DICT) {
                dictid = 1;
                dictid = adler32(dictid, dictionary, dictLength, 0);
                if (dictid !== state.check) {
                  return Z_DATA_ERROR;
                }
              }
              ret = updatewindow(strm, dictionary, dictLength, dictLength);
              if (ret) {
                state.mode = MEM;
                return Z_MEM_ERROR;
              }
              state.havedict = 1;
              return Z_OK;
            }
            exports2.inflateReset = inflateReset;
            exports2.inflateReset2 = inflateReset2;
            exports2.inflateResetKeep = inflateResetKeep;
            exports2.inflateInit = inflateInit;
            exports2.inflateInit2 = inflateInit2;
            exports2.inflate = inflate;
            exports2.inflateEnd = inflateEnd;
            exports2.inflateGetHeader = inflateGetHeader;
            exports2.inflateSetDictionary = inflateSetDictionary;
            exports2.inflateInfo = "pako inflate (from Nodeca project)";
          },
          /* 33 */
          /***/
          function(module3, exports2) {
            "use strict";
            var TYPED_OK = typeof Uint8Array !== "undefined" && typeof Uint16Array !== "undefined" && typeof Int32Array !== "undefined";
            exports2.assign = function(obj) {
              var sources = Array.prototype.slice.call(arguments, 1);
              while (sources.length) {
                var source = sources.shift();
                if (!source) {
                  continue;
                }
                if (typeof source !== "object") {
                  throw new TypeError(source + "must be non-object");
                }
                for (var p in source) {
                  if (source.hasOwnProperty(p)) {
                    obj[p] = source[p];
                  }
                }
              }
              return obj;
            };
            exports2.shrinkBuf = function(buf, size) {
              if (buf.length === size) {
                return buf;
              }
              if (buf.subarray) {
                return buf.subarray(0, size);
              }
              buf.length = size;
              return buf;
            };
            var fnTyped = {
              arraySet: function(dest, src, src_offs, len, dest_offs) {
                if (src.subarray && dest.subarray) {
                  dest.set(src.subarray(src_offs, src_offs + len), dest_offs);
                  return;
                }
                for (var i = 0; i < len; i++) {
                  dest[dest_offs + i] = src[src_offs + i];
                }
              },
              // Join array of chunks to single array.
              flattenChunks: function(chunks) {
                var i, l, len, pos, chunk, result;
                len = 0;
                for (i = 0, l = chunks.length; i < l; i++) {
                  len += chunks[i].length;
                }
                result = new Uint8Array(len);
                pos = 0;
                for (i = 0, l = chunks.length; i < l; i++) {
                  chunk = chunks[i];
                  result.set(chunk, pos);
                  pos += chunk.length;
                }
                return result;
              }
            };
            var fnUntyped = {
              arraySet: function(dest, src, src_offs, len, dest_offs) {
                for (var i = 0; i < len; i++) {
                  dest[dest_offs + i] = src[src_offs + i];
                }
              },
              // Join array of chunks to single array.
              flattenChunks: function(chunks) {
                return [].concat.apply([], chunks);
              }
            };
            exports2.setTyped = function(on) {
              if (on) {
                exports2.Buf8 = Uint8Array;
                exports2.Buf16 = Uint16Array;
                exports2.Buf32 = Int32Array;
                exports2.assign(exports2, fnTyped);
              } else {
                exports2.Buf8 = Array;
                exports2.Buf16 = Array;
                exports2.Buf32 = Array;
                exports2.assign(exports2, fnUntyped);
              }
            };
            exports2.setTyped(TYPED_OK);
          },
          /* 34 */
          /***/
          function(module3, exports2) {
            "use strict";
            function adler32(adler, buf, len, pos) {
              var s1 = adler & 65535 | 0, s2 = adler >>> 16 & 65535 | 0, n = 0;
              while (len !== 0) {
                n = len > 2e3 ? 2e3 : len;
                len -= n;
                do {
                  s1 = s1 + buf[pos++] | 0;
                  s2 = s2 + s1 | 0;
                } while (--n);
                s1 %= 65521;
                s2 %= 65521;
              }
              return s1 | s2 << 16 | 0;
            }
            module3.exports = adler32;
          },
          /* 35 */
          /***/
          function(module3, exports2) {
            "use strict";
            function makeTable() {
              var c, table = [];
              for (var n = 0; n < 256; n++) {
                c = n;
                for (var k = 0; k < 8; k++) {
                  c = c & 1 ? 3988292384 ^ c >>> 1 : c >>> 1;
                }
                table[n] = c;
              }
              return table;
            }
            var crcTable = makeTable();
            function crc32(crc, buf, len, pos) {
              var t = crcTable, end = pos + len;
              crc ^= -1;
              for (var i = pos; i < end; i++) {
                crc = crc >>> 8 ^ t[(crc ^ buf[i]) & 255];
              }
              return crc ^ -1;
            }
            module3.exports = crc32;
          },
          /* 36 */
          /***/
          function(module3, exports2) {
            "use strict";
            var BAD = 30;
            var TYPE = 12;
            module3.exports = function inflate_fast(strm, start2) {
              var state;
              var _in;
              var last;
              var _out;
              var beg;
              var end;
              var dmax;
              var wsize;
              var whave;
              var wnext;
              var s_window;
              var hold;
              var bits;
              var lcode;
              var dcode;
              var lmask;
              var dmask;
              var here;
              var op;
              var len;
              var dist;
              var from;
              var from_source;
              var input, output;
              state = strm.state;
              _in = strm.next_in;
              input = strm.input;
              last = _in + (strm.avail_in - 5);
              _out = strm.next_out;
              output = strm.output;
              beg = _out - (start2 - strm.avail_out);
              end = _out + (strm.avail_out - 257);
              dmax = state.dmax;
              wsize = state.wsize;
              whave = state.whave;
              wnext = state.wnext;
              s_window = state.window;
              hold = state.hold;
              bits = state.bits;
              lcode = state.lencode;
              dcode = state.distcode;
              lmask = (1 << state.lenbits) - 1;
              dmask = (1 << state.distbits) - 1;
              top:
                do {
                  if (bits < 15) {
                    hold += input[_in++] << bits;
                    bits += 8;
                    hold += input[_in++] << bits;
                    bits += 8;
                  }
                  here = lcode[hold & lmask];
                  dolen:
                    for (; ; ) {
                      op = here >>> 24;
                      hold >>>= op;
                      bits -= op;
                      op = here >>> 16 & 255;
                      if (op === 0) {
                        output[_out++] = here & 65535;
                      } else if (op & 16) {
                        len = here & 65535;
                        op &= 15;
                        if (op) {
                          if (bits < op) {
                            hold += input[_in++] << bits;
                            bits += 8;
                          }
                          len += hold & (1 << op) - 1;
                          hold >>>= op;
                          bits -= op;
                        }
                        if (bits < 15) {
                          hold += input[_in++] << bits;
                          bits += 8;
                          hold += input[_in++] << bits;
                          bits += 8;
                        }
                        here = dcode[hold & dmask];
                        dodist:
                          for (; ; ) {
                            op = here >>> 24;
                            hold >>>= op;
                            bits -= op;
                            op = here >>> 16 & 255;
                            if (op & 16) {
                              dist = here & 65535;
                              op &= 15;
                              if (bits < op) {
                                hold += input[_in++] << bits;
                                bits += 8;
                                if (bits < op) {
                                  hold += input[_in++] << bits;
                                  bits += 8;
                                }
                              }
                              dist += hold & (1 << op) - 1;
                              if (dist > dmax) {
                                strm.msg = "invalid distance too far back";
                                state.mode = BAD;
                                break top;
                              }
                              hold >>>= op;
                              bits -= op;
                              op = _out - beg;
                              if (dist > op) {
                                op = dist - op;
                                if (op > whave) {
                                  if (state.sane) {
                                    strm.msg = "invalid distance too far back";
                                    state.mode = BAD;
                                    break top;
                                  }
                                }
                                from = 0;
                                from_source = s_window;
                                if (wnext === 0) {
                                  from += wsize - op;
                                  if (op < len) {
                                    len -= op;
                                    do {
                                      output[_out++] = s_window[from++];
                                    } while (--op);
                                    from = _out - dist;
                                    from_source = output;
                                  }
                                } else if (wnext < op) {
                                  from += wsize + wnext - op;
                                  op -= wnext;
                                  if (op < len) {
                                    len -= op;
                                    do {
                                      output[_out++] = s_window[from++];
                                    } while (--op);
                                    from = 0;
                                    if (wnext < len) {
                                      op = wnext;
                                      len -= op;
                                      do {
                                        output[_out++] = s_window[from++];
                                      } while (--op);
                                      from = _out - dist;
                                      from_source = output;
                                    }
                                  }
                                } else {
                                  from += wnext - op;
                                  if (op < len) {
                                    len -= op;
                                    do {
                                      output[_out++] = s_window[from++];
                                    } while (--op);
                                    from = _out - dist;
                                    from_source = output;
                                  }
                                }
                                while (len > 2) {
                                  output[_out++] = from_source[from++];
                                  output[_out++] = from_source[from++];
                                  output[_out++] = from_source[from++];
                                  len -= 3;
                                }
                                if (len) {
                                  output[_out++] = from_source[from++];
                                  if (len > 1) {
                                    output[_out++] = from_source[from++];
                                  }
                                }
                              } else {
                                from = _out - dist;
                                do {
                                  output[_out++] = output[from++];
                                  output[_out++] = output[from++];
                                  output[_out++] = output[from++];
                                  len -= 3;
                                } while (len > 2);
                                if (len) {
                                  output[_out++] = output[from++];
                                  if (len > 1) {
                                    output[_out++] = output[from++];
                                  }
                                }
                              }
                            } else if ((op & 64) === 0) {
                              here = dcode[(here & 65535) + (hold & (1 << op) - 1)];
                              continue dodist;
                            } else {
                              strm.msg = "invalid distance code";
                              state.mode = BAD;
                              break top;
                            }
                            break;
                          }
                      } else if ((op & 64) === 0) {
                        here = lcode[(here & 65535) + (hold & (1 << op) - 1)];
                        continue dolen;
                      } else if (op & 32) {
                        state.mode = TYPE;
                        break top;
                      } else {
                        strm.msg = "invalid literal/length code";
                        state.mode = BAD;
                        break top;
                      }
                      break;
                    }
                } while (_in < last && _out < end);
              len = bits >> 3;
              _in -= len;
              bits -= len << 3;
              hold &= (1 << bits) - 1;
              strm.next_in = _in;
              strm.next_out = _out;
              strm.avail_in = _in < last ? 5 + (last - _in) : 5 - (_in - last);
              strm.avail_out = _out < end ? 257 + (end - _out) : 257 - (_out - end);
              state.hold = hold;
              state.bits = bits;
              return;
            };
          },
          /* 37 */
          /***/
          function(module3, exports2, __webpack_require__) {
            "use strict";
            var utils = __webpack_require__(33);
            var MAXBITS = 15;
            var ENOUGH_LENS = 852;
            var ENOUGH_DISTS = 592;
            var CODES = 0;
            var LENS = 1;
            var DISTS = 2;
            var lbase = [
              /* Length codes 257..285 base */
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              13,
              15,
              17,
              19,
              23,
              27,
              31,
              35,
              43,
              51,
              59,
              67,
              83,
              99,
              115,
              131,
              163,
              195,
              227,
              258,
              0,
              0
            ];
            var lext = [
              /* Length codes 257..285 extra */
              16,
              16,
              16,
              16,
              16,
              16,
              16,
              16,
              17,
              17,
              17,
              17,
              18,
              18,
              18,
              18,
              19,
              19,
              19,
              19,
              20,
              20,
              20,
              20,
              21,
              21,
              21,
              21,
              16,
              72,
              78
            ];
            var dbase = [
              /* Distance codes 0..29 base */
              1,
              2,
              3,
              4,
              5,
              7,
              9,
              13,
              17,
              25,
              33,
              49,
              65,
              97,
              129,
              193,
              257,
              385,
              513,
              769,
              1025,
              1537,
              2049,
              3073,
              4097,
              6145,
              8193,
              12289,
              16385,
              24577,
              0,
              0
            ];
            var dext = [
              /* Distance codes 0..29 extra */
              16,
              16,
              16,
              16,
              17,
              17,
              18,
              18,
              19,
              19,
              20,
              20,
              21,
              21,
              22,
              22,
              23,
              23,
              24,
              24,
              25,
              25,
              26,
              26,
              27,
              27,
              28,
              28,
              29,
              29,
              64,
              64
            ];
            module3.exports = function inflate_table(type, lens, lens_index, codes, table, table_index, work, opts) {
              var bits = opts.bits;
              var len = 0;
              var sym = 0;
              var min = 0, max = 0;
              var root = 0;
              var curr = 0;
              var drop = 0;
              var left = 0;
              var used = 0;
              var huff = 0;
              var incr;
              var fill;
              var low;
              var mask;
              var next;
              var base = null;
              var base_index = 0;
              var end;
              var count = new utils.Buf16(MAXBITS + 1);
              var offs = new utils.Buf16(MAXBITS + 1);
              var extra = null;
              var extra_index = 0;
              var here_bits, here_op, here_val;
              for (len = 0; len <= MAXBITS; len++) {
                count[len] = 0;
              }
              for (sym = 0; sym < codes; sym++) {
                count[lens[lens_index + sym]]++;
              }
              root = bits;
              for (max = MAXBITS; max >= 1; max--) {
                if (count[max] !== 0) {
                  break;
                }
              }
              if (root > max) {
                root = max;
              }
              if (max === 0) {
                table[table_index++] = 1 << 24 | 64 << 16 | 0;
                table[table_index++] = 1 << 24 | 64 << 16 | 0;
                opts.bits = 1;
                return 0;
              }
              for (min = 1; min < max; min++) {
                if (count[min] !== 0) {
                  break;
                }
              }
              if (root < min) {
                root = min;
              }
              left = 1;
              for (len = 1; len <= MAXBITS; len++) {
                left <<= 1;
                left -= count[len];
                if (left < 0) {
                  return -1;
                }
              }
              if (left > 0 && (type === CODES || max !== 1)) {
                return -1;
              }
              offs[1] = 0;
              for (len = 1; len < MAXBITS; len++) {
                offs[len + 1] = offs[len] + count[len];
              }
              for (sym = 0; sym < codes; sym++) {
                if (lens[lens_index + sym] !== 0) {
                  work[offs[lens[lens_index + sym]]++] = sym;
                }
              }
              if (type === CODES) {
                base = extra = work;
                end = 19;
              } else if (type === LENS) {
                base = lbase;
                base_index -= 257;
                extra = lext;
                extra_index -= 257;
                end = 256;
              } else {
                base = dbase;
                extra = dext;
                end = -1;
              }
              huff = 0;
              sym = 0;
              len = min;
              next = table_index;
              curr = root;
              drop = 0;
              low = -1;
              used = 1 << root;
              mask = used - 1;
              if (type === LENS && used > ENOUGH_LENS || type === DISTS && used > ENOUGH_DISTS) {
                return 1;
              }
              for (; ; ) {
                here_bits = len - drop;
                if (work[sym] < end) {
                  here_op = 0;
                  here_val = work[sym];
                } else if (work[sym] > end) {
                  here_op = extra[extra_index + work[sym]];
                  here_val = base[base_index + work[sym]];
                } else {
                  here_op = 32 + 64;
                  here_val = 0;
                }
                incr = 1 << len - drop;
                fill = 1 << curr;
                min = fill;
                do {
                  fill -= incr;
                  table[next + (huff >> drop) + fill] = here_bits << 24 | here_op << 16 | here_val | 0;
                } while (fill !== 0);
                incr = 1 << len - 1;
                while (huff & incr) {
                  incr >>= 1;
                }
                if (incr !== 0) {
                  huff &= incr - 1;
                  huff += incr;
                } else {
                  huff = 0;
                }
                sym++;
                if (--count[len] === 0) {
                  if (len === max) {
                    break;
                  }
                  len = lens[lens_index + work[sym]];
                }
                if (len > root && (huff & mask) !== low) {
                  if (drop === 0) {
                    drop = root;
                  }
                  next += min;
                  curr = len - drop;
                  left = 1 << curr;
                  while (curr + drop < max) {
                    left -= count[curr + drop];
                    if (left <= 0) {
                      break;
                    }
                    curr++;
                    left <<= 1;
                  }
                  used += 1 << curr;
                  if (type === LENS && used > ENOUGH_LENS || type === DISTS && used > ENOUGH_DISTS) {
                    return 1;
                  }
                  low = huff & mask;
                  table[low] = root << 24 | curr << 16 | next - table_index | 0;
                }
              }
              if (huff !== 0) {
                table[next + huff] = len - drop << 24 | 64 << 16 | 0;
              }
              opts.bits = root;
              return 0;
            };
          },
          /* 38 */
          /***/
          function(module3, exports2, __webpack_require__) {
            "use strict";
            var utils = __webpack_require__(33);
            var STR_APPLY_OK = true;
            var STR_APPLY_UIA_OK = true;
            try {
              String.fromCharCode.apply(null, [0]);
            } catch (__) {
              STR_APPLY_OK = false;
            }
            try {
              String.fromCharCode.apply(null, new Uint8Array(1));
            } catch (__) {
              STR_APPLY_UIA_OK = false;
            }
            var _utf8len = new utils.Buf8(256);
            for (var q = 0; q < 256; q++) {
              _utf8len[q] = q >= 252 ? 6 : q >= 248 ? 5 : q >= 240 ? 4 : q >= 224 ? 3 : q >= 192 ? 2 : 1;
            }
            _utf8len[254] = _utf8len[254] = 1;
            exports2.string2buf = function(str) {
              var buf, c, c2, m_pos, i, str_len = str.length, buf_len = 0;
              for (m_pos = 0; m_pos < str_len; m_pos++) {
                c = str.charCodeAt(m_pos);
                if ((c & 64512) === 55296 && m_pos + 1 < str_len) {
                  c2 = str.charCodeAt(m_pos + 1);
                  if ((c2 & 64512) === 56320) {
                    c = 65536 + (c - 55296 << 10) + (c2 - 56320);
                    m_pos++;
                  }
                }
                buf_len += c < 128 ? 1 : c < 2048 ? 2 : c < 65536 ? 3 : 4;
              }
              buf = new utils.Buf8(buf_len);
              for (i = 0, m_pos = 0; i < buf_len; m_pos++) {
                c = str.charCodeAt(m_pos);
                if ((c & 64512) === 55296 && m_pos + 1 < str_len) {
                  c2 = str.charCodeAt(m_pos + 1);
                  if ((c2 & 64512) === 56320) {
                    c = 65536 + (c - 55296 << 10) + (c2 - 56320);
                    m_pos++;
                  }
                }
                if (c < 128) {
                  buf[i++] = c;
                } else if (c < 2048) {
                  buf[i++] = 192 | c >>> 6;
                  buf[i++] = 128 | c & 63;
                } else if (c < 65536) {
                  buf[i++] = 224 | c >>> 12;
                  buf[i++] = 128 | c >>> 6 & 63;
                  buf[i++] = 128 | c & 63;
                } else {
                  buf[i++] = 240 | c >>> 18;
                  buf[i++] = 128 | c >>> 12 & 63;
                  buf[i++] = 128 | c >>> 6 & 63;
                  buf[i++] = 128 | c & 63;
                }
              }
              return buf;
            };
            function buf2binstring(buf, len) {
              if (len < 65537) {
                if (buf.subarray && STR_APPLY_UIA_OK || !buf.subarray && STR_APPLY_OK) {
                  return String.fromCharCode.apply(null, utils.shrinkBuf(buf, len));
                }
              }
              var result = "";
              for (var i = 0; i < len; i++) {
                result += String.fromCharCode(buf[i]);
              }
              return result;
            }
            exports2.buf2binstring = function(buf) {
              return buf2binstring(buf, buf.length);
            };
            exports2.binstring2buf = function(str) {
              var buf = new utils.Buf8(str.length);
              for (var i = 0, len = buf.length; i < len; i++) {
                buf[i] = str.charCodeAt(i);
              }
              return buf;
            };
            exports2.buf2string = function(buf, max) {
              var i, out, c, c_len;
              var len = max || buf.length;
              var utf16buf = new Array(len * 2);
              for (out = 0, i = 0; i < len; ) {
                c = buf[i++];
                if (c < 128) {
                  utf16buf[out++] = c;
                  continue;
                }
                c_len = _utf8len[c];
                if (c_len > 4) {
                  utf16buf[out++] = 65533;
                  i += c_len - 1;
                  continue;
                }
                c &= c_len === 2 ? 31 : c_len === 3 ? 15 : 7;
                while (c_len > 1 && i < len) {
                  c = c << 6 | buf[i++] & 63;
                  c_len--;
                }
                if (c_len > 1) {
                  utf16buf[out++] = 65533;
                  continue;
                }
                if (c < 65536) {
                  utf16buf[out++] = c;
                } else {
                  c -= 65536;
                  utf16buf[out++] = 55296 | c >> 10 & 1023;
                  utf16buf[out++] = 56320 | c & 1023;
                }
              }
              return buf2binstring(utf16buf, out);
            };
            exports2.utf8border = function(buf, max) {
              var pos;
              max = max || buf.length;
              if (max > buf.length) {
                max = buf.length;
              }
              pos = max - 1;
              while (pos >= 0 && (buf[pos] & 192) === 128) {
                pos--;
              }
              if (pos < 0) {
                return max;
              }
              if (pos === 0) {
                return max;
              }
              return pos + _utf8len[buf[pos]] > max ? pos : max;
            };
          },
          /* 39 */
          /***/
          function(module3, exports2) {
            "use strict";
            module3.exports = {
              /* Allowed flush values; see deflate() and inflate() below for details */
              Z_NO_FLUSH: 0,
              Z_PARTIAL_FLUSH: 1,
              Z_SYNC_FLUSH: 2,
              Z_FULL_FLUSH: 3,
              Z_FINISH: 4,
              Z_BLOCK: 5,
              Z_TREES: 6,
              /* Return codes for the compression/decompression functions. Negative values
              * are errors, positive values are used for special but normal events.
              */
              Z_OK: 0,
              Z_STREAM_END: 1,
              Z_NEED_DICT: 2,
              Z_ERRNO: -1,
              Z_STREAM_ERROR: -2,
              Z_DATA_ERROR: -3,
              //Z_MEM_ERROR:     -4,
              Z_BUF_ERROR: -5,
              //Z_VERSION_ERROR: -6,
              /* compression levels */
              Z_NO_COMPRESSION: 0,
              Z_BEST_SPEED: 1,
              Z_BEST_COMPRESSION: 9,
              Z_DEFAULT_COMPRESSION: -1,
              Z_FILTERED: 1,
              Z_HUFFMAN_ONLY: 2,
              Z_RLE: 3,
              Z_FIXED: 4,
              Z_DEFAULT_STRATEGY: 0,
              /* Possible values of the data_type field (though see inflate()) */
              Z_BINARY: 0,
              Z_TEXT: 1,
              //Z_ASCII:                1, // = Z_TEXT (deprecated)
              Z_UNKNOWN: 2,
              /* The deflate compression method */
              Z_DEFLATED: 8
              //Z_NULL:                 null // Use -1 or null inline, depending on var type
            };
          },
          /* 40 */
          /***/
          function(module3, exports2) {
            "use strict";
            module3.exports = {
              2: "need dictionary",
              /* Z_NEED_DICT       2  */
              1: "stream end",
              /* Z_STREAM_END      1  */
              0: "",
              /* Z_OK              0  */
              "-1": "file error",
              /* Z_ERRNO         (-1) */
              "-2": "stream error",
              /* Z_STREAM_ERROR  (-2) */
              "-3": "data error",
              /* Z_DATA_ERROR    (-3) */
              "-4": "insufficient memory",
              /* Z_MEM_ERROR     (-4) */
              "-5": "buffer error",
              /* Z_BUF_ERROR     (-5) */
              "-6": "incompatible version"
              /* Z_VERSION_ERROR (-6) */
            };
          },
          /* 41 */
          /***/
          function(module3, exports2) {
            "use strict";
            function ZStream() {
              this.input = null;
              this.next_in = 0;
              this.avail_in = 0;
              this.total_in = 0;
              this.output = null;
              this.next_out = 0;
              this.avail_out = 0;
              this.total_out = 0;
              this.msg = "";
              this.state = null;
              this.data_type = 2;
              this.adler = 0;
            }
            module3.exports = ZStream;
          },
          /* 42 */
          /***/
          function(module3, exports2) {
            "use strict";
            function GZheader() {
              this.text = 0;
              this.time = 0;
              this.xflags = 0;
              this.os = 0;
              this.extra = null;
              this.extra_len = 0;
              this.name = "";
              this.comment = "";
              this.hcrc = 0;
              this.done = false;
            }
            module3.exports = GZheader;
          }
          /******/
        ])
      );
    });
  }
});

// ../../node_modules/browserfs/dist/node/core/file_flag.js
var require_file_flag = __commonJS({
  "../../node_modules/browserfs/dist/node/core/file_flag.js"(exports) {
    exports.__esModule = true;
    var api_error_1 = require_api_error();
    var ActionType3;
    (function(ActionType4) {
      ActionType4[ActionType4["NOP"] = 0] = "NOP";
      ActionType4[ActionType4["THROW_EXCEPTION"] = 1] = "THROW_EXCEPTION";
      ActionType4[ActionType4["TRUNCATE_FILE"] = 2] = "TRUNCATE_FILE";
      ActionType4[ActionType4["CREATE_FILE"] = 3] = "CREATE_FILE";
    })(ActionType3 = exports.ActionType || (exports.ActionType = {}));
    var FileFlag8 = function() {
      function FileFlag9(flagStr) {
        this.flagStr = flagStr;
        if (FileFlag9.validFlagStrs.indexOf(flagStr) < 0) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid flag: " + flagStr);
        }
      }
      FileFlag9.getFileFlag = function(flagStr) {
        if (FileFlag9.flagCache.hasOwnProperty(flagStr)) {
          return FileFlag9.flagCache[flagStr];
        }
        return FileFlag9.flagCache[flagStr] = new FileFlag9(flagStr);
      };
      FileFlag9.prototype.getFlagString = function() {
        return this.flagStr;
      };
      FileFlag9.prototype.isReadable = function() {
        return this.flagStr.indexOf("r") !== -1 || this.flagStr.indexOf("+") !== -1;
      };
      FileFlag9.prototype.isWriteable = function() {
        return this.flagStr.indexOf("w") !== -1 || this.flagStr.indexOf("a") !== -1 || this.flagStr.indexOf("+") !== -1;
      };
      FileFlag9.prototype.isTruncating = function() {
        return this.flagStr.indexOf("w") !== -1;
      };
      FileFlag9.prototype.isAppendable = function() {
        return this.flagStr.indexOf("a") !== -1;
      };
      FileFlag9.prototype.isSynchronous = function() {
        return this.flagStr.indexOf("s") !== -1;
      };
      FileFlag9.prototype.isExclusive = function() {
        return this.flagStr.indexOf("x") !== -1;
      };
      FileFlag9.prototype.pathExistsAction = function() {
        if (this.isExclusive()) {
          return ActionType3.THROW_EXCEPTION;
        } else if (this.isTruncating()) {
          return ActionType3.TRUNCATE_FILE;
        } else {
          return ActionType3.NOP;
        }
      };
      FileFlag9.prototype.pathNotExistsAction = function() {
        if ((this.isWriteable() || this.isAppendable()) && this.flagStr !== "r+") {
          return ActionType3.CREATE_FILE;
        } else {
          return ActionType3.THROW_EXCEPTION;
        }
      };
      return FileFlag9;
    }();
    FileFlag8.flagCache = {};
    FileFlag8.validFlagStrs = ["r", "r+", "rs", "rs+", "w", "wx", "w+", "wx+", "a", "ax", "a+", "ax+"];
    exports.FileFlag = FileFlag8;
  }
});

// node-modules-polyfills:path
var path_exports = {};
__export(path_exports, {
  basename: () => basename,
  default: () => path_default,
  delimiter: () => delimiter,
  dirname: () => dirname,
  extname: () => extname,
  isAbsolute: () => isAbsolute,
  join: () => join,
  normalize: () => normalize,
  relative: () => relative,
  resolve: () => resolve,
  sep: () => sep
});
function normalizeArray(parts, allowAboveRoot) {
  var up = 0;
  for (var i = parts.length - 1; i >= 0; i--) {
    var last = parts[i];
    if (last === ".") {
      parts.splice(i, 1);
    } else if (last === "..") {
      parts.splice(i, 1);
      up++;
    } else if (up) {
      parts.splice(i, 1);
      up--;
    }
  }
  if (allowAboveRoot) {
    for (; up--; up) {
      parts.unshift("..");
    }
  }
  return parts;
}
function resolve() {
  var resolvedPath = "", resolvedAbsolute = false;
  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
    var path = i >= 0 ? arguments[i] : "/";
    if (typeof path !== "string") {
      throw new TypeError("Arguments to path.resolve must be strings");
    } else if (!path) {
      continue;
    }
    resolvedPath = path + "/" + resolvedPath;
    resolvedAbsolute = path.charAt(0) === "/";
  }
  resolvedPath = normalizeArray(filter(resolvedPath.split("/"), function(p) {
    return !!p;
  }), !resolvedAbsolute).join("/");
  return (resolvedAbsolute ? "/" : "") + resolvedPath || ".";
}
function normalize(path) {
  var isPathAbsolute = isAbsolute(path), trailingSlash = substr(path, -1) === "/";
  path = normalizeArray(filter(path.split("/"), function(p) {
    return !!p;
  }), !isPathAbsolute).join("/");
  if (!path && !isPathAbsolute) {
    path = ".";
  }
  if (path && trailingSlash) {
    path += "/";
  }
  return (isPathAbsolute ? "/" : "") + path;
}
function isAbsolute(path) {
  return path.charAt(0) === "/";
}
function join() {
  var paths = Array.prototype.slice.call(arguments, 0);
  return normalize(filter(paths, function(p, index) {
    if (typeof p !== "string") {
      throw new TypeError("Arguments to path.join must be strings");
    }
    return p;
  }).join("/"));
}
function relative(from, to) {
  from = resolve(from).substr(1);
  to = resolve(to).substr(1);
  function trim(arr) {
    var start2 = 0;
    for (; start2 < arr.length; start2++) {
      if (arr[start2] !== "") break;
    }
    var end = arr.length - 1;
    for (; end >= 0; end--) {
      if (arr[end] !== "") break;
    }
    if (start2 > end) return [];
    return arr.slice(start2, end - start2 + 1);
  }
  var fromParts = trim(from.split("/"));
  var toParts = trim(to.split("/"));
  var length = Math.min(fromParts.length, toParts.length);
  var samePartsLength = length;
  for (var i = 0; i < length; i++) {
    if (fromParts[i] !== toParts[i]) {
      samePartsLength = i;
      break;
    }
  }
  var outputParts = [];
  for (var i = samePartsLength; i < fromParts.length; i++) {
    outputParts.push("..");
  }
  outputParts = outputParts.concat(toParts.slice(samePartsLength));
  return outputParts.join("/");
}
function dirname(path) {
  var result = splitPath(path), root = result[0], dir = result[1];
  if (!root && !dir) {
    return ".";
  }
  if (dir) {
    dir = dir.substr(0, dir.length - 1);
  }
  return root + dir;
}
function basename(path, ext) {
  var f = splitPath(path)[2];
  if (ext && f.substr(-1 * ext.length) === ext) {
    f = f.substr(0, f.length - ext.length);
  }
  return f;
}
function extname(path) {
  return splitPath(path)[3];
}
function filter(xs, f) {
  if (xs.filter) return xs.filter(f);
  var res = [];
  for (var i = 0; i < xs.length; i++) {
    if (f(xs[i], i, xs)) res.push(xs[i]);
  }
  return res;
}
var splitPathRe, splitPath, sep, delimiter, path_default, substr;
var init_path = __esm({
  "node-modules-polyfills:path"() {
    splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
    splitPath = function(filename) {
      return splitPathRe.exec(filename).slice(1);
    };
    sep = "/";
    delimiter = ":";
    path_default = {
      extname,
      basename,
      dirname,
      sep,
      delimiter,
      relative,
      join,
      isAbsolute,
      normalize,
      resolve
    };
    substr = "ab".substr(-1) === "b" ? function(str, start2, len) {
      return str.substr(start2, len);
    } : function(str, start2, len) {
      if (start2 < 0) start2 = str.length + start2;
      return str.substr(start2, len);
    };
  }
});

// node-modules-polyfills-commonjs:path
var require_path = __commonJS({
  "node-modules-polyfills-commonjs:path"(exports, module2) {
    var polyfill = (init_path(), __toCommonJS(path_exports));
    if (polyfill && polyfill.default) {
      module2.exports = polyfill.default;
      for (let k in polyfill) {
        module2.exports[k] = polyfill[k];
      }
    } else if (polyfill) {
      module2.exports = polyfill;
    }
  }
});

// ../../node_modules/browserfs/dist/node/core/levenshtein.js
var require_levenshtein = __commonJS({
  "../../node_modules/browserfs/dist/node/core/levenshtein.js"(exports) {
    exports.__esModule = true;
    function _min(d0, d1, d2, bx, ay) {
      return d0 < d1 || d2 < d1 ? d0 > d2 ? d2 + 1 : d0 + 1 : bx === ay ? d1 : d1 + 1;
    }
    function levenshtein(a, b) {
      if (a === b) {
        return 0;
      }
      if (a.length > b.length) {
        var tmp = a;
        a = b;
        b = tmp;
      }
      var la = a.length;
      var lb = b.length;
      while (la > 0 && a.charCodeAt(la - 1) === b.charCodeAt(lb - 1)) {
        la--;
        lb--;
      }
      var offset = 0;
      while (offset < la && a.charCodeAt(offset) === b.charCodeAt(offset)) {
        offset++;
      }
      la -= offset;
      lb -= offset;
      if (la === 0 || lb === 1) {
        return lb;
      }
      var vector = new Array(la << 1);
      for (var y = 0; y < la; ) {
        vector[la + y] = a.charCodeAt(offset + y);
        vector[y] = ++y;
      }
      var x;
      var d0;
      var d1;
      var d2;
      var d3;
      for (x = 0; x + 3 < lb; ) {
        var bx0 = b.charCodeAt(offset + (d0 = x));
        var bx1 = b.charCodeAt(offset + (d1 = x + 1));
        var bx2 = b.charCodeAt(offset + (d2 = x + 2));
        var bx3 = b.charCodeAt(offset + (d3 = x + 3));
        var dd_1 = x += 4;
        for (var y = 0; y < la; ) {
          var ay = vector[la + y];
          var dy = vector[y];
          d0 = _min(dy, d0, d1, bx0, ay);
          d1 = _min(d0, d1, d2, bx1, ay);
          d2 = _min(d1, d2, d3, bx2, ay);
          dd_1 = _min(d2, d3, dd_1, bx3, ay);
          vector[y++] = dd_1;
          d3 = d2;
          d2 = d1;
          d1 = d0;
          d0 = dy;
        }
      }
      var dd = 0;
      for (; x < lb; ) {
        var bx0 = b.charCodeAt(offset + (d0 = x));
        dd = ++x;
        for (var y = 0; y < la; y++) {
          var dy = vector[y];
          vector[y] = dd = dy < d0 || dd < d0 ? dy > dd ? dd + 1 : dy + 1 : bx0 === vector[la + y] ? d0 : d0 + 1;
          d0 = dy;
        }
      }
      return dd;
    }
    exports["default"] = levenshtein;
  }
});

// ../../node_modules/browserfs/dist/node/core/util.js
var require_util = __commonJS({
  "../../node_modules/browserfs/dist/node/core/util.js"(exports) {
    exports.__esModule = true;
    var api_error_1 = require_api_error();
    var levenshtein_1 = require_levenshtein();
    var path = require_path();
    function deprecationMessage(print, fsName, opts) {
      if (print) {
        console.warn("[" + fsName + "] Direct file system constructor usage is deprecated for this file system, and will be removed in the next major version. Please use the '" + fsName + ".Create(" + JSON.stringify(opts) + ", callback)' method instead. See https://github.com/jvilk/BrowserFS/issues/176 for more details.");
      }
    }
    exports.deprecationMessage = deprecationMessage;
    exports.isIE = typeof navigator !== "undefined" && !!(/(msie) ([\w.]+)/.exec(navigator.userAgent.toLowerCase()) || navigator.userAgent.indexOf("Trident") !== -1);
    exports.isWebWorker = typeof window === "undefined";
    function fail() {
      throw new Error("BFS has reached an impossible code path; please file a bug.");
    }
    exports.fail = fail;
    function mkdirpSync(p, mode, fs) {
      if (!fs.existsSync(p)) {
        mkdirpSync(path.dirname(p), mode, fs);
        fs.mkdirSync(p, mode);
      }
    }
    exports.mkdirpSync = mkdirpSync;
    function buffer2ArrayBuffer(buff) {
      var u8 = buffer2Uint8array(buff), u8offset = u8.byteOffset, u8Len = u8.byteLength;
      if (u8offset === 0 && u8Len === u8.buffer.byteLength) {
        return u8.buffer;
      } else {
        return u8.buffer.slice(u8offset, u8offset + u8Len);
      }
    }
    exports.buffer2ArrayBuffer = buffer2ArrayBuffer;
    function buffer2Uint8array(buff) {
      if (buff instanceof Uint8Array) {
        return buff;
      } else {
        return new Uint8Array(buff);
      }
    }
    exports.buffer2Uint8array = buffer2Uint8array;
    function arrayish2Buffer(arr) {
      if (arr instanceof Buffer) {
        return arr;
      } else if (arr instanceof Uint8Array) {
        return uint8Array2Buffer(arr);
      } else {
        return Buffer.from(arr);
      }
    }
    exports.arrayish2Buffer = arrayish2Buffer;
    function uint8Array2Buffer(u8) {
      if (u8 instanceof Buffer) {
        return u8;
      } else if (u8.byteOffset === 0 && u8.byteLength === u8.buffer.byteLength) {
        return arrayBuffer2Buffer(u8.buffer);
      } else {
        return Buffer.from(u8.buffer, u8.byteOffset, u8.byteLength);
      }
    }
    exports.uint8Array2Buffer = uint8Array2Buffer;
    function arrayBuffer2Buffer(ab) {
      return Buffer.from(ab);
    }
    exports.arrayBuffer2Buffer = arrayBuffer2Buffer;
    function copyingSlice2(buff, start2, end) {
      if (start2 === void 0) {
        start2 = 0;
      }
      if (end === void 0) {
        end = buff.length;
      }
      if (start2 < 0 || end < 0 || end > buff.length || start2 > end) {
        throw new TypeError("Invalid slice bounds on buffer of length " + buff.length + ": [" + start2 + ", " + end + "]");
      }
      if (buff.length === 0) {
        return emptyBuffer();
      } else {
        var u8 = buffer2Uint8array(buff), s0 = buff[0], newS0 = (s0 + 1) % 255;
        buff[0] = newS0;
        if (u8[0] === newS0) {
          u8[0] = s0;
          return uint8Array2Buffer(u8.slice(start2, end));
        } else {
          buff[0] = s0;
          return uint8Array2Buffer(u8.subarray(start2, end));
        }
      }
    }
    exports.copyingSlice = copyingSlice2;
    var emptyBuff = null;
    function emptyBuffer() {
      if (emptyBuff) {
        return emptyBuff;
      }
      return emptyBuff = Buffer.alloc(0);
    }
    exports.emptyBuffer = emptyBuffer;
    function bufferValidator(v, cb) {
      if (Buffer.isBuffer(v)) {
        cb();
      } else {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "option must be a Buffer."));
      }
    }
    exports.bufferValidator = bufferValidator;
    function checkOptions(fsType, opts, cb) {
      var optsInfo = fsType.Options;
      var fsName = fsType.Name;
      var pendingValidators = 0;
      var callbackCalled = false;
      var loopEnded = false;
      function validatorCallback(e) {
        if (!callbackCalled) {
          if (e) {
            callbackCalled = true;
            cb(e);
          }
          pendingValidators--;
          if (pendingValidators === 0 && loopEnded) {
            cb();
          }
        }
      }
      var _loop_1 = function(optName2) {
        if (optsInfo.hasOwnProperty(optName2)) {
          var opt = optsInfo[optName2];
          var providedValue = opts[optName2];
          if (providedValue === void 0 || providedValue === null) {
            if (!opt.optional) {
              var incorrectOptions = Object.keys(opts).filter(function(o) {
                return !(o in optsInfo);
              }).map(function(a) {
                return { str: a, distance: levenshtein_1["default"](optName2, a) };
              }).filter(function(o) {
                return o.distance < 5;
              }).sort(function(a, b) {
                return a.distance - b.distance;
              });
              if (callbackCalled) {
                return { value: void 0 };
              }
              callbackCalled = true;
              return { value: cb(new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "[" + fsName + "] Required option '" + optName2 + "' not provided." + (incorrectOptions.length > 0 ? " You provided unrecognized option '" + incorrectOptions[0].str + "'; perhaps you meant to type '" + optName2 + "'." : "") + "\nOption description: " + opt.description)) };
            }
          } else {
            var typeMatches = false;
            if (Array.isArray(opt.type)) {
              typeMatches = opt.type.indexOf(typeof providedValue) !== -1;
            } else {
              typeMatches = typeof providedValue === opt.type;
            }
            if (!typeMatches) {
              if (callbackCalled) {
                return { value: void 0 };
              }
              callbackCalled = true;
              return { value: cb(new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "[" + fsName + "] Value provided for option " + optName2 + " is not the proper type. Expected " + (Array.isArray(opt.type) ? "one of {" + opt.type.join(", ") + "}" : opt.type) + ", but received " + typeof providedValue + "\nOption description: " + opt.description)) };
            } else if (opt.validator) {
              pendingValidators++;
              opt.validator(providedValue, validatorCallback);
            }
          }
        }
      };
      for (var optName in optsInfo) {
        var state_1 = _loop_1(optName);
        if (typeof state_1 === "object")
          return state_1.value;
      }
      loopEnded = true;
      if (pendingValidators === 0 && !callbackCalled) {
        cb();
      }
    }
    exports.checkOptions = checkOptions;
  }
});

// ../../node_modules/browserfs/dist/node/core/file_system.js
var require_file_system = __commonJS({
  "../../node_modules/browserfs/dist/node/core/file_system.js"(exports) {
    var __extends = exports && exports.__extends || function() {
      var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d, b) {
        d.__proto__ = b;
      } || function(d, b) {
        for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      };
      return function(d, b) {
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    exports.__esModule = true;
    var api_error_1 = require_api_error();
    var file_flag_1 = require_file_flag();
    var path = require_path();
    var util_1 = require_util();
    var BaseFileSystem3 = function() {
      function BaseFileSystem4() {
      }
      BaseFileSystem4.prototype.supportsLinks = function() {
        return false;
      };
      BaseFileSystem4.prototype.diskSpace = function(p, cb) {
        cb(0, 0);
      };
      BaseFileSystem4.prototype.openFile = function(p, flag, cb) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.createFile = function(p, flag, mode, cb) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.open = function(p, flag, mode, cb) {
        var _this = this;
        var mustBeFile = function(e, stats) {
          if (e) {
            switch (flag.pathNotExistsAction()) {
              case file_flag_1.ActionType.CREATE_FILE:
                return _this.stat(path.dirname(p), false, function(e2, parentStats) {
                  if (e2) {
                    cb(e2);
                  } else if (parentStats && !parentStats.isDirectory()) {
                    cb(api_error_1.ApiError.ENOTDIR(path.dirname(p)));
                  } else {
                    _this.createFile(p, flag, mode, cb);
                  }
                });
              case file_flag_1.ActionType.THROW_EXCEPTION:
                return cb(api_error_1.ApiError.ENOENT(p));
              default:
                return cb(new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid FileFlag object."));
            }
          } else {
            if (stats && stats.isDirectory()) {
              return cb(api_error_1.ApiError.EISDIR(p));
            }
            switch (flag.pathExistsAction()) {
              case file_flag_1.ActionType.THROW_EXCEPTION:
                return cb(api_error_1.ApiError.EEXIST(p));
              case file_flag_1.ActionType.TRUNCATE_FILE:
                return _this.openFile(p, flag, function(e2, fd) {
                  if (e2) {
                    cb(e2);
                  } else if (fd) {
                    fd.truncate(0, function() {
                      fd.sync(function() {
                        cb(null, fd);
                      });
                    });
                  } else {
                    util_1.fail();
                  }
                });
              case file_flag_1.ActionType.NOP:
                return _this.openFile(p, flag, cb);
              default:
                return cb(new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid FileFlag object."));
            }
          }
        };
        this.stat(p, false, mustBeFile);
      };
      BaseFileSystem4.prototype.rename = function(oldPath, newPath, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.renameSync = function(oldPath, newPath) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.stat = function(p, isLstat, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.statSync = function(p, isLstat) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.openFileSync = function(p, flag, mode) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.createFileSync = function(p, flag, mode) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.openSync = function(p, flag, mode) {
        var stats;
        try {
          stats = this.statSync(p, false);
        } catch (e) {
          switch (flag.pathNotExistsAction()) {
            case file_flag_1.ActionType.CREATE_FILE:
              var parentStats = this.statSync(path.dirname(p), false);
              if (!parentStats.isDirectory()) {
                throw api_error_1.ApiError.ENOTDIR(path.dirname(p));
              }
              return this.createFileSync(p, flag, mode);
            case file_flag_1.ActionType.THROW_EXCEPTION:
              throw api_error_1.ApiError.ENOENT(p);
            default:
              throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid FileFlag object.");
          }
        }
        if (stats.isDirectory()) {
          throw api_error_1.ApiError.EISDIR(p);
        }
        switch (flag.pathExistsAction()) {
          case file_flag_1.ActionType.THROW_EXCEPTION:
            throw api_error_1.ApiError.EEXIST(p);
          case file_flag_1.ActionType.TRUNCATE_FILE:
            this.unlinkSync(p);
            return this.createFileSync(p, flag, stats.mode);
          case file_flag_1.ActionType.NOP:
            return this.openFileSync(p, flag, mode);
          default:
            throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid FileFlag object.");
        }
      };
      BaseFileSystem4.prototype.unlink = function(p, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.unlinkSync = function(p) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.rmdir = function(p, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.rmdirSync = function(p) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.mkdir = function(p, mode, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.mkdirSync = function(p, mode) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.readdir = function(p, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.readdirSync = function(p) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.exists = function(p, cb) {
        this.stat(p, null, function(err) {
          cb(!err);
        });
      };
      BaseFileSystem4.prototype.existsSync = function(p) {
        try {
          this.statSync(p, true);
          return true;
        } catch (e) {
          return false;
        }
      };
      BaseFileSystem4.prototype.realpath = function(p, cache, cb) {
        if (this.supportsLinks()) {
          var splitPath2 = p.split(path.sep);
          for (var i = 0; i < splitPath2.length; i++) {
            var addPaths = splitPath2.slice(0, i + 1);
            splitPath2[i] = path.join.apply(null, addPaths);
          }
        } else {
          this.exists(p, function(doesExist) {
            if (doesExist) {
              cb(null, p);
            } else {
              cb(api_error_1.ApiError.ENOENT(p));
            }
          });
        }
      };
      BaseFileSystem4.prototype.realpathSync = function(p, cache) {
        if (this.supportsLinks()) {
          var splitPath2 = p.split(path.sep);
          for (var i = 0; i < splitPath2.length; i++) {
            var addPaths = splitPath2.slice(0, i + 1);
            splitPath2[i] = path.join.apply(path, addPaths);
          }
          return splitPath2.join(path.sep);
        } else {
          if (this.existsSync(p)) {
            return p;
          } else {
            throw api_error_1.ApiError.ENOENT(p);
          }
        }
      };
      BaseFileSystem4.prototype.truncate = function(p, len, cb) {
        this.open(p, file_flag_1.FileFlag.getFileFlag("r+"), 420, function(er, fd) {
          if (er) {
            return cb(er);
          }
          fd.truncate(len, function(er2) {
            fd.close(function(er22) {
              cb(er2 || er22);
            });
          });
        });
      };
      BaseFileSystem4.prototype.truncateSync = function(p, len) {
        var fd = this.openSync(p, file_flag_1.FileFlag.getFileFlag("r+"), 420);
        try {
          fd.truncateSync(len);
        } catch (e) {
          throw e;
        } finally {
          fd.closeSync();
        }
      };
      BaseFileSystem4.prototype.readFile = function(fname, encoding, flag, cb) {
        var oldCb = cb;
        this.open(fname, flag, 420, function(err, fd) {
          if (err) {
            return cb(err);
          }
          cb = function(err2, arg) {
            fd.close(function(err22) {
              if (!err2) {
                err2 = err22;
              }
              return oldCb(err2, arg);
            });
          };
          fd.stat(function(err2, stat) {
            if (err2) {
              return cb(err2);
            }
            var buf = Buffer.alloc(stat.size);
            fd.read(buf, 0, stat.size, 0, function(err3) {
              if (err3) {
                return cb(err3);
              } else if (encoding === null) {
                return cb(err3, buf);
              }
              try {
                cb(null, buf.toString(encoding));
              } catch (e) {
                cb(e);
              }
            });
          });
        });
      };
      BaseFileSystem4.prototype.readFileSync = function(fname, encoding, flag) {
        var fd = this.openSync(fname, flag, 420);
        try {
          var stat = fd.statSync();
          var buf = Buffer.alloc(stat.size);
          fd.readSync(buf, 0, stat.size, 0);
          fd.closeSync();
          if (encoding === null) {
            return buf;
          }
          return buf.toString(encoding);
        } finally {
          fd.closeSync();
        }
      };
      BaseFileSystem4.prototype.writeFile = function(fname, data, encoding, flag, mode, cb) {
        var oldCb = cb;
        this.open(fname, flag, 420, function(err, fd) {
          if (err) {
            return cb(err);
          }
          cb = function(err2) {
            fd.close(function(err22) {
              oldCb(err2 ? err2 : err22);
            });
          };
          try {
            if (typeof data === "string") {
              data = Buffer.from(data, encoding);
            }
          } catch (e) {
            return cb(e);
          }
          fd.write(data, 0, data.length, 0, cb);
        });
      };
      BaseFileSystem4.prototype.writeFileSync = function(fname, data, encoding, flag, mode) {
        var fd = this.openSync(fname, flag, mode);
        try {
          if (typeof data === "string") {
            data = Buffer.from(data, encoding);
          }
          fd.writeSync(data, 0, data.length, 0);
        } finally {
          fd.closeSync();
        }
      };
      BaseFileSystem4.prototype.appendFile = function(fname, data, encoding, flag, mode, cb) {
        var oldCb = cb;
        this.open(fname, flag, mode, function(err, fd) {
          if (err) {
            return cb(err);
          }
          cb = function(err2) {
            fd.close(function(err22) {
              oldCb(err2 ? err2 : err22);
            });
          };
          if (typeof data === "string") {
            data = Buffer.from(data, encoding);
          }
          fd.write(data, 0, data.length, null, cb);
        });
      };
      BaseFileSystem4.prototype.appendFileSync = function(fname, data, encoding, flag, mode) {
        var fd = this.openSync(fname, flag, mode);
        try {
          if (typeof data === "string") {
            data = Buffer.from(data, encoding);
          }
          fd.writeSync(data, 0, data.length, null);
        } finally {
          fd.closeSync();
        }
      };
      BaseFileSystem4.prototype.chmod = function(p, isLchmod, mode, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.chmodSync = function(p, isLchmod, mode) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.chown = function(p, isLchown, uid, gid, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.chownSync = function(p, isLchown, uid, gid) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.utimes = function(p, atime, mtime, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.utimesSync = function(p, atime, mtime) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.link = function(srcpath, dstpath, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.linkSync = function(srcpath, dstpath) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.symlink = function(srcpath, dstpath, type, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.symlinkSync = function(srcpath, dstpath, type) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFileSystem4.prototype.readlink = function(p, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFileSystem4.prototype.readlinkSync = function(p) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      return BaseFileSystem4;
    }();
    exports.BaseFileSystem = BaseFileSystem3;
    var SynchronousFileSystem = function(_super) {
      __extends(SynchronousFileSystem2, _super);
      function SynchronousFileSystem2() {
        return _super !== null && _super.apply(this, arguments) || this;
      }
      SynchronousFileSystem2.prototype.supportsSynch = function() {
        return true;
      };
      SynchronousFileSystem2.prototype.rename = function(oldPath, newPath, cb) {
        try {
          this.renameSync(oldPath, newPath);
          cb();
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.stat = function(p, isLstat, cb) {
        try {
          cb(null, this.statSync(p, isLstat));
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.open = function(p, flags, mode, cb) {
        try {
          cb(null, this.openSync(p, flags, mode));
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.unlink = function(p, cb) {
        try {
          this.unlinkSync(p);
          cb();
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.rmdir = function(p, cb) {
        try {
          this.rmdirSync(p);
          cb();
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.mkdir = function(p, mode, cb) {
        try {
          this.mkdirSync(p, mode);
          cb();
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.readdir = function(p, cb) {
        try {
          cb(null, this.readdirSync(p));
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.chmod = function(p, isLchmod, mode, cb) {
        try {
          this.chmodSync(p, isLchmod, mode);
          cb();
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.chown = function(p, isLchown, uid, gid, cb) {
        try {
          this.chownSync(p, isLchown, uid, gid);
          cb();
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.utimes = function(p, atime, mtime, cb) {
        try {
          this.utimesSync(p, atime, mtime);
          cb();
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.link = function(srcpath, dstpath, cb) {
        try {
          this.linkSync(srcpath, dstpath);
          cb();
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.symlink = function(srcpath, dstpath, type, cb) {
        try {
          this.symlinkSync(srcpath, dstpath, type);
          cb();
        } catch (e) {
          cb(e);
        }
      };
      SynchronousFileSystem2.prototype.readlink = function(p, cb) {
        try {
          cb(null, this.readlinkSync(p));
        } catch (e) {
          cb(e);
        }
      };
      return SynchronousFileSystem2;
    }(BaseFileSystem3);
    exports.SynchronousFileSystem = SynchronousFileSystem;
  }
});

// ../../node_modules/browserfs/dist/node/core/global.js
var require_global = __commonJS({
  "../../node_modules/browserfs/dist/node/core/global.js"(exports) {
    exports.__esModule = true;
    var toExport;
    if (typeof window !== "undefined") {
      toExport = window;
    } else if (typeof self !== "undefined") {
      toExport = self;
    } else {
      toExport = globalThis;
    }
    exports["default"] = toExport;
  }
});

// ../../node_modules/browserfs/dist/node/generic/setImmediate.js
var require_setImmediate = __commonJS({
  "../../node_modules/browserfs/dist/node/generic/setImmediate.js"(exports) {
    exports.__esModule = true;
    var global_1 = require_global();
    var bfsSetImmediate;
    if (typeof setImmediate !== "undefined") {
      bfsSetImmediate = setImmediate;
    } else {
      gScope_1 = global_1["default"];
      timeouts_1 = [];
      messageName_1 = "zero-timeout-message";
      canUsePostMessage = function() {
        if (typeof gScope_1.importScripts !== "undefined" || !gScope_1.postMessage) {
          return false;
        }
        var postMessageIsAsync = true;
        var oldOnMessage = gScope_1.onmessage;
        gScope_1.onmessage = function() {
          postMessageIsAsync = false;
        };
        gScope_1.postMessage("", "*");
        gScope_1.onmessage = oldOnMessage;
        return postMessageIsAsync;
      };
      if (canUsePostMessage()) {
        bfsSetImmediate = function(fn) {
          timeouts_1.push(fn);
          gScope_1.postMessage(messageName_1, "*");
        };
        handleMessage = function(event) {
          if (event.source === self && event.data === messageName_1) {
            if (event.stopPropagation) {
              event.stopPropagation();
            } else {
              event.cancelBubble = true;
            }
            if (timeouts_1.length > 0) {
              var fn = timeouts_1.shift();
              return fn();
            }
          }
        };
        if (gScope_1.addEventListener) {
          gScope_1.addEventListener("message", handleMessage, true);
        } else {
          gScope_1.attachEvent("onmessage", handleMessage);
        }
      } else if (gScope_1.MessageChannel) {
        channel_1 = new gScope_1.MessageChannel();
        channel_1.port1.onmessage = function(event) {
          if (timeouts_1.length > 0) {
            return timeouts_1.shift()();
          }
        };
        bfsSetImmediate = function(fn) {
          timeouts_1.push(fn);
          channel_1.port2.postMessage("");
        };
      } else {
        bfsSetImmediate = function(fn) {
          return setTimeout(fn, 0);
        };
      }
    }
    var gScope_1;
    var timeouts_1;
    var messageName_1;
    var canUsePostMessage;
    var handleMessage;
    var channel_1;
    exports["default"] = bfsSetImmediate;
  }
});

// ../../node_modules/browserfs/dist/node/generic/mutex.js
var require_mutex = __commonJS({
  "../../node_modules/browserfs/dist/node/generic/mutex.js"(exports) {
    exports.__esModule = true;
    var setImmediate_1 = require_setImmediate();
    var Mutex = function() {
      function Mutex2() {
        this._locked = false;
        this._waiters = [];
      }
      Mutex2.prototype.lock = function(cb) {
        if (this._locked) {
          this._waiters.push(cb);
          return;
        }
        this._locked = true;
        cb();
      };
      Mutex2.prototype.unlock = function() {
        if (!this._locked) {
          throw new Error("unlock of a non-locked mutex");
        }
        var next = this._waiters.shift();
        if (next) {
          setImmediate_1["default"](next);
          return;
        }
        this._locked = false;
      };
      Mutex2.prototype.tryLock = function() {
        if (this._locked) {
          return false;
        }
        this._locked = true;
        return true;
      };
      Mutex2.prototype.isLocked = function() {
        return this._locked;
      };
      return Mutex2;
    }();
    exports["default"] = Mutex;
  }
});

// ../../node_modules/browserfs/dist/node/generic/locked_fs.js
var require_locked_fs = __commonJS({
  "../../node_modules/browserfs/dist/node/generic/locked_fs.js"(exports) {
    exports.__esModule = true;
    var mutex_1 = require_mutex();
    var LockedFS2 = function() {
      function LockedFS3(fs) {
        this._fs = fs;
        this._mu = new mutex_1["default"]();
      }
      LockedFS3.prototype.getName = function() {
        return "LockedFS<" + this._fs.getName() + ">";
      };
      LockedFS3.prototype.getFSUnlocked = function() {
        return this._fs;
      };
      LockedFS3.prototype.initialize = function(cb) {
        this._fs.initialize(cb);
      };
      LockedFS3.prototype.diskSpace = function(p, cb) {
        this._fs.diskSpace(p, cb);
      };
      LockedFS3.prototype.isReadOnly = function() {
        return this._fs.isReadOnly();
      };
      LockedFS3.prototype.supportsLinks = function() {
        return this._fs.supportsLinks();
      };
      LockedFS3.prototype.supportsProps = function() {
        return this._fs.supportsProps();
      };
      LockedFS3.prototype.supportsSynch = function() {
        return this._fs.supportsSynch();
      };
      LockedFS3.prototype.rename = function(oldPath, newPath, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.rename(oldPath, newPath, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.renameSync = function(oldPath, newPath) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.renameSync(oldPath, newPath);
      };
      LockedFS3.prototype.stat = function(p, isLstat, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.stat(p, isLstat, function(err, stat) {
            _this._mu.unlock();
            cb(err, stat);
          });
        });
      };
      LockedFS3.prototype.statSync = function(p, isLstat) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.statSync(p, isLstat);
      };
      LockedFS3.prototype.open = function(p, flag, mode, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.open(p, flag, mode, function(err, fd) {
            _this._mu.unlock();
            cb(err, fd);
          });
        });
      };
      LockedFS3.prototype.openSync = function(p, flag, mode) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.openSync(p, flag, mode);
      };
      LockedFS3.prototype.unlink = function(p, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.unlink(p, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.unlinkSync = function(p) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.unlinkSync(p);
      };
      LockedFS3.prototype.rmdir = function(p, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.rmdir(p, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.rmdirSync = function(p) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.rmdirSync(p);
      };
      LockedFS3.prototype.mkdir = function(p, mode, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.mkdir(p, mode, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.mkdirSync = function(p, mode) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.mkdirSync(p, mode);
      };
      LockedFS3.prototype.readdir = function(p, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.readdir(p, function(err, files) {
            _this._mu.unlock();
            cb(err, files);
          });
        });
      };
      LockedFS3.prototype.readdirSync = function(p) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.readdirSync(p);
      };
      LockedFS3.prototype.exists = function(p, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.exists(p, function(exists) {
            _this._mu.unlock();
            cb(exists);
          });
        });
      };
      LockedFS3.prototype.existsSync = function(p) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.existsSync(p);
      };
      LockedFS3.prototype.realpath = function(p, cache, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.realpath(p, cache, function(err, resolvedPath) {
            _this._mu.unlock();
            cb(err, resolvedPath);
          });
        });
      };
      LockedFS3.prototype.realpathSync = function(p, cache) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.realpathSync(p, cache);
      };
      LockedFS3.prototype.truncate = function(p, len, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.truncate(p, len, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.truncateSync = function(p, len) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.truncateSync(p, len);
      };
      LockedFS3.prototype.readFile = function(fname, encoding, flag, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.readFile(fname, encoding, flag, function(err, data) {
            _this._mu.unlock();
            cb(err, data);
          });
        });
      };
      LockedFS3.prototype.readFileSync = function(fname, encoding, flag) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.readFileSync(fname, encoding, flag);
      };
      LockedFS3.prototype.writeFile = function(fname, data, encoding, flag, mode, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.writeFile(fname, data, encoding, flag, mode, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.writeFileSync = function(fname, data, encoding, flag, mode) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.writeFileSync(fname, data, encoding, flag, mode);
      };
      LockedFS3.prototype.appendFile = function(fname, data, encoding, flag, mode, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.appendFile(fname, data, encoding, flag, mode, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.appendFileSync = function(fname, data, encoding, flag, mode) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.appendFileSync(fname, data, encoding, flag, mode);
      };
      LockedFS3.prototype.chmod = function(p, isLchmod, mode, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.chmod(p, isLchmod, mode, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.chmodSync = function(p, isLchmod, mode) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.chmodSync(p, isLchmod, mode);
      };
      LockedFS3.prototype.chown = function(p, isLchown, uid, gid, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.chown(p, isLchown, uid, gid, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.chownSync = function(p, isLchown, uid, gid) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.chownSync(p, isLchown, uid, gid);
      };
      LockedFS3.prototype.utimes = function(p, atime, mtime, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.utimes(p, atime, mtime, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.utimesSync = function(p, atime, mtime) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.utimesSync(p, atime, mtime);
      };
      LockedFS3.prototype.link = function(srcpath, dstpath, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.link(srcpath, dstpath, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.linkSync = function(srcpath, dstpath) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.linkSync(srcpath, dstpath);
      };
      LockedFS3.prototype.symlink = function(srcpath, dstpath, type, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.symlink(srcpath, dstpath, type, function(err) {
            _this._mu.unlock();
            cb(err);
          });
        });
      };
      LockedFS3.prototype.symlinkSync = function(srcpath, dstpath, type) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.symlinkSync(srcpath, dstpath, type);
      };
      LockedFS3.prototype.readlink = function(p, cb) {
        var _this = this;
        this._mu.lock(function() {
          _this._fs.readlink(p, function(err, linkString) {
            _this._mu.unlock();
            cb(err, linkString);
          });
        });
      };
      LockedFS3.prototype.readlinkSync = function(p) {
        if (this._mu.isLocked()) {
          throw new Error("invalid sync call");
        }
        return this._fs.readlinkSync(p);
      };
      return LockedFS3;
    }();
    exports["default"] = LockedFS2;
  }
});

// ../../node_modules/browserfs/dist/node/core/file.js
var require_file = __commonJS({
  "../../node_modules/browserfs/dist/node/core/file.js"(exports) {
    exports.__esModule = true;
    var api_error_1 = require_api_error();
    var BaseFile = function() {
      function BaseFile2() {
      }
      BaseFile2.prototype.sync = function(cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFile2.prototype.syncSync = function() {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFile2.prototype.datasync = function(cb) {
        this.sync(cb);
      };
      BaseFile2.prototype.datasyncSync = function() {
        return this.syncSync();
      };
      BaseFile2.prototype.chown = function(uid, gid, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFile2.prototype.chownSync = function(uid, gid) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFile2.prototype.chmod = function(mode, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFile2.prototype.chmodSync = function(mode) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      BaseFile2.prototype.utimes = function(atime, mtime, cb) {
        cb(new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP));
      };
      BaseFile2.prototype.utimesSync = function(atime, mtime) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      return BaseFile2;
    }();
    exports.BaseFile = BaseFile;
  }
});

// ../../node_modules/browserfs/dist/node/core/node_fs_stats.js
var require_node_fs_stats = __commonJS({
  "../../node_modules/browserfs/dist/node/core/node_fs_stats.js"(exports) {
    exports.__esModule = true;
    var FileType5;
    (function(FileType6) {
      FileType6[FileType6["FILE"] = 32768] = "FILE";
      FileType6[FileType6["DIRECTORY"] = 16384] = "DIRECTORY";
      FileType6[FileType6["SYMLINK"] = 40960] = "SYMLINK";
    })(FileType5 = exports.FileType || (exports.FileType = {}));
    var Stats2 = function() {
      function Stats3(itemType, size, mode, atime, mtime, ctime) {
        if (atime === void 0) {
          atime = /* @__PURE__ */ new Date();
        }
        if (mtime === void 0) {
          mtime = /* @__PURE__ */ new Date();
        }
        if (ctime === void 0) {
          ctime = /* @__PURE__ */ new Date();
        }
        this.size = size;
        this.atime = atime;
        this.mtime = mtime;
        this.ctime = ctime;
        this.dev = 0;
        this.ino = 0;
        this.rdev = 0;
        this.nlink = 1;
        this.blksize = 4096;
        this.uid = 0;
        this.gid = 0;
        this.birthtime = /* @__PURE__ */ new Date(0);
        this.fileData = null;
        if (!mode) {
          switch (itemType) {
            case FileType5.FILE:
              this.mode = 420;
              break;
            case FileType5.DIRECTORY:
            default:
              this.mode = 511;
          }
        } else {
          this.mode = mode;
        }
        this.blocks = Math.ceil(size / 512);
        if (this.mode < 4096) {
          this.mode |= itemType;
        }
      }
      Stats3.fromBuffer = function(buffer) {
        var size = buffer.readUInt32LE(0), mode = buffer.readUInt32LE(4), atime = buffer.readDoubleLE(8), mtime = buffer.readDoubleLE(16), ctime = buffer.readDoubleLE(24);
        return new Stats3(mode & 61440, size, mode & 4095, new Date(atime), new Date(mtime), new Date(ctime));
      };
      Stats3.prototype.toBuffer = function() {
        var buffer = Buffer.alloc(32);
        buffer.writeUInt32LE(this.size, 0);
        buffer.writeUInt32LE(this.mode, 4);
        buffer.writeDoubleLE(this.atime.getTime(), 8);
        buffer.writeDoubleLE(this.mtime.getTime(), 16);
        buffer.writeDoubleLE(this.ctime.getTime(), 24);
        return buffer;
      };
      Stats3.prototype.clone = function() {
        return new Stats3(this.mode & 61440, this.size, this.mode & 4095, this.atime, this.mtime, this.ctime);
      };
      Stats3.prototype.isFile = function() {
        return (this.mode & 61440) === FileType5.FILE;
      };
      Stats3.prototype.isDirectory = function() {
        return (this.mode & 61440) === FileType5.DIRECTORY;
      };
      Stats3.prototype.isSymbolicLink = function() {
        return (this.mode & 61440) === FileType5.SYMLINK;
      };
      Stats3.prototype.chmod = function(mode) {
        this.mode = this.mode & 61440 | mode;
      };
      Stats3.prototype.isSocket = function() {
        return false;
      };
      Stats3.prototype.isBlockDevice = function() {
        return false;
      };
      Stats3.prototype.isCharacterDevice = function() {
        return false;
      };
      Stats3.prototype.isFIFO = function() {
        return false;
      };
      return Stats3;
    }();
    exports["default"] = Stats2;
  }
});

// ../../node_modules/browserfs/dist/node/core/FS.js
var require_FS = __commonJS({
  "../../node_modules/browserfs/dist/node/core/FS.js"(exports) {
    exports.__esModule = true;
    var api_error_1 = require_api_error();
    var file_flag_1 = require_file_flag();
    var path = require_path();
    var node_fs_stats_1 = require_node_fs_stats();
    var wrapCb = function(cb, numArgs) {
      return cb;
    };
    function assertRoot(fs) {
      if (fs) {
        return fs;
      }
      throw new api_error_1.ApiError(api_error_1.ErrorCode.EIO, "Initialize BrowserFS with a file system using BrowserFS.initialize(filesystem)");
    }
    function normalizeMode(mode, def) {
      switch (typeof mode) {
        case "number":
          return mode;
        case "string":
          var trueMode = parseInt(mode, 8);
          if (!isNaN(trueMode)) {
            return trueMode;
          }
          return def;
        default:
          return def;
      }
    }
    function normalizeTime(time) {
      if (time instanceof Date) {
        return time;
      } else if (typeof time === "number") {
        return new Date(time * 1e3);
      } else {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid time.");
      }
    }
    function normalizePath(p) {
      if (p.indexOf("\0") >= 0) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Path must be a string without null bytes.");
      } else if (p === "") {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Path must not be empty.");
      }
      return path.resolve(p);
    }
    function normalizeOptions(options, defEnc, defFlag, defMode) {
      switch (typeof options) {
        case "object":
          return {
            encoding: typeof options["encoding"] !== "undefined" ? options["encoding"] : defEnc,
            flag: typeof options["flag"] !== "undefined" ? options["flag"] : defFlag,
            mode: normalizeMode(options["mode"], defMode)
          };
        case "string":
          return {
            encoding: options,
            flag: defFlag,
            mode: defMode
          };
        default:
          return {
            encoding: defEnc,
            flag: defFlag,
            mode: defMode
          };
      }
    }
    function nopCb() {
    }
    var FS = function() {
      function FS2() {
        this.F_OK = 0;
        this.R_OK = 4;
        this.W_OK = 2;
        this.X_OK = 1;
        this.root = null;
        this.fdMap = {};
        this.nextFd = 100;
      }
      FS2.prototype.initialize = function(rootFS) {
        if (!rootFS.constructor.isAvailable()) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Tried to instantiate BrowserFS with an unavailable file system.");
        }
        return this.root = rootFS;
      };
      FS2.prototype._toUnixTimestamp = function(time) {
        if (typeof time === "number") {
          return time;
        } else if (time instanceof Date) {
          return time.getTime() / 1e3;
        }
        throw new Error("Cannot parse time: " + time);
      };
      FS2.prototype.getRootFS = function() {
        if (this.root) {
          return this.root;
        } else {
          return null;
        }
      };
      FS2.prototype.rename = function(oldPath, newPath, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          assertRoot(this.root).rename(normalizePath(oldPath), normalizePath(newPath), newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.renameSync = function(oldPath, newPath) {
        assertRoot(this.root).renameSync(normalizePath(oldPath), normalizePath(newPath));
      };
      FS2.prototype.exists = function(path2, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          return assertRoot(this.root).exists(normalizePath(path2), newCb);
        } catch (e) {
          return newCb(false);
        }
      };
      FS2.prototype.existsSync = function(path2) {
        try {
          return assertRoot(this.root).existsSync(normalizePath(path2));
        } catch (e) {
          return false;
        }
      };
      FS2.prototype.stat = function(path2, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 2);
        try {
          return assertRoot(this.root).stat(normalizePath(path2), false, newCb);
        } catch (e) {
          return newCb(e);
        }
      };
      FS2.prototype.statSync = function(path2) {
        return assertRoot(this.root).statSync(normalizePath(path2), false);
      };
      FS2.prototype.lstat = function(path2, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 2);
        try {
          return assertRoot(this.root).stat(normalizePath(path2), true, newCb);
        } catch (e) {
          return newCb(e);
        }
      };
      FS2.prototype.lstatSync = function(path2) {
        return assertRoot(this.root).statSync(normalizePath(path2), true);
      };
      FS2.prototype.truncate = function(path2, arg2, cb) {
        if (arg2 === void 0) {
          arg2 = 0;
        }
        if (cb === void 0) {
          cb = nopCb;
        }
        var len = 0;
        if (typeof arg2 === "function") {
          cb = arg2;
        } else if (typeof arg2 === "number") {
          len = arg2;
        }
        var newCb = wrapCb(cb, 1);
        try {
          if (len < 0) {
            throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL);
          }
          return assertRoot(this.root).truncate(normalizePath(path2), len, newCb);
        } catch (e) {
          return newCb(e);
        }
      };
      FS2.prototype.truncateSync = function(path2, len) {
        if (len === void 0) {
          len = 0;
        }
        if (len < 0) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL);
        }
        return assertRoot(this.root).truncateSync(normalizePath(path2), len);
      };
      FS2.prototype.unlink = function(path2, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          return assertRoot(this.root).unlink(normalizePath(path2), newCb);
        } catch (e) {
          return newCb(e);
        }
      };
      FS2.prototype.unlinkSync = function(path2) {
        return assertRoot(this.root).unlinkSync(normalizePath(path2));
      };
      FS2.prototype.open = function(path2, flag, arg2, cb) {
        var _this = this;
        if (cb === void 0) {
          cb = nopCb;
        }
        var mode = normalizeMode(arg2, 420);
        cb = typeof arg2 === "function" ? arg2 : cb;
        var newCb = wrapCb(cb, 2);
        try {
          assertRoot(this.root).open(normalizePath(path2), file_flag_1.FileFlag.getFileFlag(flag), mode, function(e, file) {
            if (file) {
              newCb(e, _this.getFdForFile(file));
            } else {
              newCb(e);
            }
          });
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.openSync = function(path2, flag, mode) {
        if (mode === void 0) {
          mode = 420;
        }
        return this.getFdForFile(assertRoot(this.root).openSync(normalizePath(path2), file_flag_1.FileFlag.getFileFlag(flag), normalizeMode(mode, 420)));
      };
      FS2.prototype.readFile = function(filename, arg2, cb) {
        if (arg2 === void 0) {
          arg2 = {};
        }
        if (cb === void 0) {
          cb = nopCb;
        }
        var options = normalizeOptions(arg2, null, "r", null);
        cb = typeof arg2 === "function" ? arg2 : cb;
        var newCb = wrapCb(cb, 2);
        try {
          var flag = file_flag_1.FileFlag.getFileFlag(options["flag"]);
          if (!flag.isReadable()) {
            return newCb(new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Flag passed to readFile must allow for reading."));
          }
          return assertRoot(this.root).readFile(normalizePath(filename), options.encoding, flag, newCb);
        } catch (e) {
          return newCb(e);
        }
      };
      FS2.prototype.readFileSync = function(filename, arg2) {
        if (arg2 === void 0) {
          arg2 = {};
        }
        var options = normalizeOptions(arg2, null, "r", null);
        var flag = file_flag_1.FileFlag.getFileFlag(options.flag);
        if (!flag.isReadable()) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Flag passed to readFile must allow for reading.");
        }
        return assertRoot(this.root).readFileSync(normalizePath(filename), options.encoding, flag);
      };
      FS2.prototype.writeFile = function(filename, data, arg3, cb) {
        if (arg3 === void 0) {
          arg3 = {};
        }
        if (cb === void 0) {
          cb = nopCb;
        }
        var options = normalizeOptions(arg3, "utf8", "w", 420);
        cb = typeof arg3 === "function" ? arg3 : cb;
        var newCb = wrapCb(cb, 1);
        try {
          var flag = file_flag_1.FileFlag.getFileFlag(options.flag);
          if (!flag.isWriteable()) {
            return newCb(new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Flag passed to writeFile must allow for writing."));
          }
          return assertRoot(this.root).writeFile(normalizePath(filename), data, options.encoding, flag, options.mode, newCb);
        } catch (e) {
          return newCb(e);
        }
      };
      FS2.prototype.writeFileSync = function(filename, data, arg3) {
        var options = normalizeOptions(arg3, "utf8", "w", 420);
        var flag = file_flag_1.FileFlag.getFileFlag(options.flag);
        if (!flag.isWriteable()) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Flag passed to writeFile must allow for writing.");
        }
        return assertRoot(this.root).writeFileSync(normalizePath(filename), data, options.encoding, flag, options.mode);
      };
      FS2.prototype.appendFile = function(filename, data, arg3, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var options = normalizeOptions(arg3, "utf8", "a", 420);
        cb = typeof arg3 === "function" ? arg3 : cb;
        var newCb = wrapCb(cb, 1);
        try {
          var flag = file_flag_1.FileFlag.getFileFlag(options.flag);
          if (!flag.isAppendable()) {
            return newCb(new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Flag passed to appendFile must allow for appending."));
          }
          assertRoot(this.root).appendFile(normalizePath(filename), data, options.encoding, flag, options.mode, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.appendFileSync = function(filename, data, arg3) {
        var options = normalizeOptions(arg3, "utf8", "a", 420);
        var flag = file_flag_1.FileFlag.getFileFlag(options.flag);
        if (!flag.isAppendable()) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Flag passed to appendFile must allow for appending.");
        }
        return assertRoot(this.root).appendFileSync(normalizePath(filename), data, options.encoding, flag, options.mode);
      };
      FS2.prototype.fstat = function(fd, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 2);
        try {
          var file = this.fd2file(fd);
          file.stat(newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.fstatSync = function(fd) {
        return this.fd2file(fd).statSync();
      };
      FS2.prototype.close = function(fd, cb) {
        var _this = this;
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          this.fd2file(fd).close(function(e) {
            if (!e) {
              _this.closeFd(fd);
            }
            newCb(e);
          });
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.closeSync = function(fd) {
        this.fd2file(fd).closeSync();
        this.closeFd(fd);
      };
      FS2.prototype.ftruncate = function(fd, arg2, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var length = typeof arg2 === "number" ? arg2 : 0;
        cb = typeof arg2 === "function" ? arg2 : cb;
        var newCb = wrapCb(cb, 1);
        try {
          var file = this.fd2file(fd);
          if (length < 0) {
            throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL);
          }
          file.truncate(length, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.ftruncateSync = function(fd, len) {
        if (len === void 0) {
          len = 0;
        }
        var file = this.fd2file(fd);
        if (len < 0) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL);
        }
        file.truncateSync(len);
      };
      FS2.prototype.fsync = function(fd, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          this.fd2file(fd).sync(newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.fsyncSync = function(fd) {
        this.fd2file(fd).syncSync();
      };
      FS2.prototype.fdatasync = function(fd, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          this.fd2file(fd).datasync(newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.fdatasyncSync = function(fd) {
        this.fd2file(fd).datasyncSync();
      };
      FS2.prototype.write = function(fd, arg2, arg3, arg4, arg5, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var buffer, offset, length, position = null;
        if (typeof arg2 === "string") {
          var encoding = "utf8";
          switch (typeof arg3) {
            case "function":
              cb = arg3;
              break;
            case "number":
              position = arg3;
              encoding = typeof arg4 === "string" ? arg4 : "utf8";
              cb = typeof arg5 === "function" ? arg5 : cb;
              break;
            default:
              cb = typeof arg4 === "function" ? arg4 : typeof arg5 === "function" ? arg5 : cb;
              return cb(new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid arguments."));
          }
          buffer = Buffer.from(arg2, encoding);
          offset = 0;
          length = buffer.length;
        } else {
          buffer = arg2;
          offset = arg3;
          length = arg4;
          position = typeof arg5 === "number" ? arg5 : null;
          cb = typeof arg5 === "function" ? arg5 : cb;
        }
        var newCb = wrapCb(cb, 3);
        try {
          var file = this.fd2file(fd);
          if (position === void 0 || position === null) {
            position = file.getPos();
          }
          file.write(buffer, offset, length, position, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.writeSync = function(fd, arg2, arg3, arg4, arg5) {
        var buffer, offset = 0, length, position;
        if (typeof arg2 === "string") {
          position = typeof arg3 === "number" ? arg3 : null;
          var encoding = typeof arg4 === "string" ? arg4 : "utf8";
          offset = 0;
          buffer = Buffer.from(arg2, encoding);
          length = buffer.length;
        } else {
          buffer = arg2;
          offset = arg3;
          length = arg4;
          position = typeof arg5 === "number" ? arg5 : null;
        }
        var file = this.fd2file(fd);
        if (position === void 0 || position === null) {
          position = file.getPos();
        }
        return file.writeSync(buffer, offset, length, position);
      };
      FS2.prototype.read = function(fd, arg2, arg3, arg4, arg5, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var position, offset, length, buffer, newCb;
        if (typeof arg2 === "number") {
          length = arg2;
          position = arg3;
          var encoding_1 = arg4;
          cb = typeof arg5 === "function" ? arg5 : cb;
          offset = 0;
          buffer = Buffer.alloc(length);
          newCb = wrapCb(function(err, bytesRead, buf) {
            if (err) {
              return cb(err);
            }
            cb(err, buf.toString(encoding_1), bytesRead);
          }, 3);
        } else {
          buffer = arg2;
          offset = arg3;
          length = arg4;
          position = arg5;
          newCb = wrapCb(cb, 3);
        }
        try {
          var file = this.fd2file(fd);
          if (position === void 0 || position === null) {
            position = file.getPos();
          }
          file.read(buffer, offset, length, position, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.readSync = function(fd, arg2, arg3, arg4, arg5) {
        var shenanigans = false;
        var buffer, offset, length, position, encoding = "utf8";
        if (typeof arg2 === "number") {
          length = arg2;
          position = arg3;
          encoding = arg4;
          offset = 0;
          buffer = Buffer.alloc(length);
          shenanigans = true;
        } else {
          buffer = arg2;
          offset = arg3;
          length = arg4;
          position = arg5;
        }
        var file = this.fd2file(fd);
        if (position === void 0 || position === null) {
          position = file.getPos();
        }
        var rv = file.readSync(buffer, offset, length, position);
        if (!shenanigans) {
          return rv;
        } else {
          return [buffer.toString(encoding), rv];
        }
      };
      FS2.prototype.fchown = function(fd, uid, gid, callback) {
        if (callback === void 0) {
          callback = nopCb;
        }
        var newCb = wrapCb(callback, 1);
        try {
          this.fd2file(fd).chown(uid, gid, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.fchownSync = function(fd, uid, gid) {
        this.fd2file(fd).chownSync(uid, gid);
      };
      FS2.prototype.fchmod = function(fd, mode, cb) {
        var newCb = wrapCb(cb, 1);
        try {
          var numMode = typeof mode === "string" ? parseInt(mode, 8) : mode;
          this.fd2file(fd).chmod(numMode, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.fchmodSync = function(fd, mode) {
        var numMode = typeof mode === "string" ? parseInt(mode, 8) : mode;
        this.fd2file(fd).chmodSync(numMode);
      };
      FS2.prototype.futimes = function(fd, atime, mtime, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          var file = this.fd2file(fd);
          if (typeof atime === "number") {
            atime = new Date(atime * 1e3);
          }
          if (typeof mtime === "number") {
            mtime = new Date(mtime * 1e3);
          }
          file.utimes(atime, mtime, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.futimesSync = function(fd, atime, mtime) {
        this.fd2file(fd).utimesSync(normalizeTime(atime), normalizeTime(mtime));
      };
      FS2.prototype.rmdir = function(path2, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          path2 = normalizePath(path2);
          assertRoot(this.root).rmdir(path2, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.rmdirSync = function(path2) {
        path2 = normalizePath(path2);
        return assertRoot(this.root).rmdirSync(path2);
      };
      FS2.prototype.mkdir = function(path2, mode, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        if (typeof mode === "function") {
          cb = mode;
          mode = 511;
        }
        var newCb = wrapCb(cb, 1);
        try {
          path2 = normalizePath(path2);
          assertRoot(this.root).mkdir(path2, mode, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.mkdirSync = function(path2, mode) {
        assertRoot(this.root).mkdirSync(normalizePath(path2), normalizeMode(mode, 511));
      };
      FS2.prototype.readdir = function(path2, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 2);
        try {
          path2 = normalizePath(path2);
          assertRoot(this.root).readdir(path2, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.readdirSync = function(path2) {
        path2 = normalizePath(path2);
        return assertRoot(this.root).readdirSync(path2);
      };
      FS2.prototype.link = function(srcpath, dstpath, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          srcpath = normalizePath(srcpath);
          dstpath = normalizePath(dstpath);
          assertRoot(this.root).link(srcpath, dstpath, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.linkSync = function(srcpath, dstpath) {
        srcpath = normalizePath(srcpath);
        dstpath = normalizePath(dstpath);
        return assertRoot(this.root).linkSync(srcpath, dstpath);
      };
      FS2.prototype.symlink = function(srcpath, dstpath, arg3, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var type = typeof arg3 === "string" ? arg3 : "file";
        cb = typeof arg3 === "function" ? arg3 : cb;
        var newCb = wrapCb(cb, 1);
        try {
          if (type !== "file" && type !== "dir") {
            return newCb(new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid type: " + type));
          }
          srcpath = normalizePath(srcpath);
          dstpath = normalizePath(dstpath);
          assertRoot(this.root).symlink(srcpath, dstpath, type, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.symlinkSync = function(srcpath, dstpath, type) {
        if (!type) {
          type = "file";
        } else if (type !== "file" && type !== "dir") {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid type: " + type);
        }
        srcpath = normalizePath(srcpath);
        dstpath = normalizePath(dstpath);
        return assertRoot(this.root).symlinkSync(srcpath, dstpath, type);
      };
      FS2.prototype.readlink = function(path2, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 2);
        try {
          path2 = normalizePath(path2);
          assertRoot(this.root).readlink(path2, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.readlinkSync = function(path2) {
        path2 = normalizePath(path2);
        return assertRoot(this.root).readlinkSync(path2);
      };
      FS2.prototype.chown = function(path2, uid, gid, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          path2 = normalizePath(path2);
          assertRoot(this.root).chown(path2, false, uid, gid, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.chownSync = function(path2, uid, gid) {
        path2 = normalizePath(path2);
        assertRoot(this.root).chownSync(path2, false, uid, gid);
      };
      FS2.prototype.lchown = function(path2, uid, gid, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          path2 = normalizePath(path2);
          assertRoot(this.root).chown(path2, true, uid, gid, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.lchownSync = function(path2, uid, gid) {
        path2 = normalizePath(path2);
        assertRoot(this.root).chownSync(path2, true, uid, gid);
      };
      FS2.prototype.chmod = function(path2, mode, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          var numMode = normalizeMode(mode, -1);
          if (numMode < 0) {
            throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid mode.");
          }
          assertRoot(this.root).chmod(normalizePath(path2), false, numMode, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.chmodSync = function(path2, mode) {
        var numMode = normalizeMode(mode, -1);
        if (numMode < 0) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid mode.");
        }
        path2 = normalizePath(path2);
        assertRoot(this.root).chmodSync(path2, false, numMode);
      };
      FS2.prototype.lchmod = function(path2, mode, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          var numMode = normalizeMode(mode, -1);
          if (numMode < 0) {
            throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid mode.");
          }
          assertRoot(this.root).chmod(normalizePath(path2), true, numMode, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.lchmodSync = function(path2, mode) {
        var numMode = normalizeMode(mode, -1);
        if (numMode < 1) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EINVAL, "Invalid mode.");
        }
        assertRoot(this.root).chmodSync(normalizePath(path2), true, numMode);
      };
      FS2.prototype.utimes = function(path2, atime, mtime, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var newCb = wrapCb(cb, 1);
        try {
          assertRoot(this.root).utimes(normalizePath(path2), normalizeTime(atime), normalizeTime(mtime), newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.utimesSync = function(path2, atime, mtime) {
        assertRoot(this.root).utimesSync(normalizePath(path2), normalizeTime(atime), normalizeTime(mtime));
      };
      FS2.prototype.realpath = function(path2, arg2, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        var cache = typeof arg2 === "object" ? arg2 : {};
        cb = typeof arg2 === "function" ? arg2 : nopCb;
        var newCb = wrapCb(cb, 2);
        try {
          path2 = normalizePath(path2);
          assertRoot(this.root).realpath(path2, cache, newCb);
        } catch (e) {
          newCb(e);
        }
      };
      FS2.prototype.realpathSync = function(path2, cache) {
        if (cache === void 0) {
          cache = {};
        }
        path2 = normalizePath(path2);
        return assertRoot(this.root).realpathSync(path2, cache);
      };
      FS2.prototype.watchFile = function(filename, arg2, listener) {
        if (listener === void 0) {
          listener = nopCb;
        }
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      FS2.prototype.unwatchFile = function(filename, listener) {
        if (listener === void 0) {
          listener = nopCb;
        }
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      FS2.prototype.watch = function(filename, arg2, listener) {
        if (listener === void 0) {
          listener = nopCb;
        }
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      FS2.prototype.access = function(path2, arg2, cb) {
        if (cb === void 0) {
          cb = nopCb;
        }
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      FS2.prototype.accessSync = function(path2, mode) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      FS2.prototype.createReadStream = function(path2, options) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      FS2.prototype.createWriteStream = function(path2, options) {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      FS2.prototype.wrapCallbacks = function(cbWrapper) {
        wrapCb = cbWrapper;
      };
      FS2.prototype.getFdForFile = function(file) {
        var fd = this.nextFd++;
        this.fdMap[fd] = file;
        return fd;
      };
      FS2.prototype.fd2file = function(fd) {
        var rv = this.fdMap[fd];
        if (rv) {
          return rv;
        } else {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EBADF, "Invalid file descriptor.");
        }
      };
      FS2.prototype.closeFd = function(fd) {
        delete this.fdMap[fd];
      };
      return FS2;
    }();
    FS.Stats = node_fs_stats_1["default"];
    exports["default"] = FS;
  }
});

// ../../node_modules/browserfs/dist/node/core/node_fs.js
var require_node_fs = __commonJS({
  "../../node_modules/browserfs/dist/node/core/node_fs.js"(exports) {
    exports.__esModule = true;
    var FS_1 = require_FS();
    var fs = new FS_1["default"]();
    var _fsMock = {};
    var fsProto = FS_1["default"].prototype;
    Object.keys(fsProto).forEach(function(key) {
      if (typeof fs[key] === "function") {
        _fsMock[key] = function() {
          return fs[key].apply(fs, arguments);
        };
      } else {
        _fsMock[key] = fs[key];
      }
    });
    _fsMock["changeFSModule"] = function(newFs) {
      fs = newFs;
    };
    _fsMock["getFSModule"] = function() {
      return fs;
    };
    _fsMock["FS"] = FS_1["default"];
    exports["default"] = _fsMock;
  }
});

// ../../node_modules/browserfs/dist/node/generic/preload_file.js
var require_preload_file = __commonJS({
  "../../node_modules/browserfs/dist/node/generic/preload_file.js"(exports) {
    var __extends = exports && exports.__extends || function() {
      var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d, b) {
        d.__proto__ = b;
      } || function(d, b) {
        for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      };
      return function(d, b) {
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    exports.__esModule = true;
    var file_1 = require_file();
    var api_error_1 = require_api_error();
    var node_fs_1 = require_node_fs();
    var util_1 = require_util();
    var PreloadFile2 = function(_super) {
      __extends(PreloadFile3, _super);
      function PreloadFile3(_fs, _path, _flag, _stat, contents) {
        var _this = _super.call(this) || this;
        _this._pos = 0;
        _this._dirty = false;
        _this._fs = _fs;
        _this._path = _path;
        _this._flag = _flag;
        _this._stat = _stat;
        if (contents) {
          _this._buffer = contents;
        } else {
          _this._buffer = util_1.emptyBuffer();
        }
        if (_this._stat.size !== _this._buffer.length && _this._flag.isReadable()) {
          throw new Error("Invalid buffer: Buffer is " + _this._buffer.length + " long, yet Stats object specifies that file is " + _this._stat.size + " long.");
        }
        return _this;
      }
      PreloadFile3.prototype.getBuffer = function() {
        return this._buffer;
      };
      PreloadFile3.prototype.getStats = function() {
        return this._stat;
      };
      PreloadFile3.prototype.getFlag = function() {
        return this._flag;
      };
      PreloadFile3.prototype.getPath = function() {
        return this._path;
      };
      PreloadFile3.prototype.getPos = function() {
        if (this._flag.isAppendable()) {
          return this._stat.size;
        }
        return this._pos;
      };
      PreloadFile3.prototype.advancePos = function(delta) {
        return this._pos += delta;
      };
      PreloadFile3.prototype.setPos = function(newPos) {
        return this._pos = newPos;
      };
      PreloadFile3.prototype.sync = function(cb) {
        try {
          this.syncSync();
          cb();
        } catch (e) {
          cb(e);
        }
      };
      PreloadFile3.prototype.syncSync = function() {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      PreloadFile3.prototype.close = function(cb) {
        try {
          this.closeSync();
          cb();
        } catch (e) {
          cb(e);
        }
      };
      PreloadFile3.prototype.closeSync = function() {
        throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
      };
      PreloadFile3.prototype.stat = function(cb) {
        try {
          cb(null, this._stat.clone());
        } catch (e) {
          cb(e);
        }
      };
      PreloadFile3.prototype.statSync = function() {
        return this._stat.clone();
      };
      PreloadFile3.prototype.truncate = function(len, cb) {
        try {
          this.truncateSync(len);
          if (this._flag.isSynchronous() && !node_fs_1["default"].getRootFS().supportsSynch()) {
            this.sync(cb);
          }
          cb();
        } catch (e) {
          return cb(e);
        }
      };
      PreloadFile3.prototype.truncateSync = function(len) {
        this._dirty = true;
        if (!this._flag.isWriteable()) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EPERM, "File not opened with a writeable mode.");
        }
        this._stat.mtime = /* @__PURE__ */ new Date();
        if (len > this._buffer.length) {
          var buf = Buffer.alloc(len - this._buffer.length, 0);
          this.writeSync(buf, 0, buf.length, this._buffer.length);
          if (this._flag.isSynchronous() && node_fs_1["default"].getRootFS().supportsSynch()) {
            this.syncSync();
          }
          return;
        }
        this._stat.size = len;
        var newBuff = Buffer.alloc(len);
        this._buffer.copy(newBuff, 0, 0, len);
        this._buffer = newBuff;
        if (this._flag.isSynchronous() && node_fs_1["default"].getRootFS().supportsSynch()) {
          this.syncSync();
        }
      };
      PreloadFile3.prototype.write = function(buffer, offset, length, position, cb) {
        try {
          cb(null, this.writeSync(buffer, offset, length, position), buffer);
        } catch (e) {
          cb(e);
        }
      };
      PreloadFile3.prototype.writeSync = function(buffer, offset, length, position) {
        this._dirty = true;
        if (position === void 0 || position === null) {
          position = this.getPos();
        }
        if (!this._flag.isWriteable()) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EPERM, "File not opened with a writeable mode.");
        }
        var endFp = position + length;
        if (endFp > this._stat.size) {
          this._stat.size = endFp;
          if (endFp > this._buffer.length) {
            var newBuff = Buffer.alloc(endFp);
            this._buffer.copy(newBuff);
            this._buffer = newBuff;
          }
        }
        var len = buffer.copy(this._buffer, position, offset, offset + length);
        this._stat.mtime = /* @__PURE__ */ new Date();
        if (this._flag.isSynchronous()) {
          this.syncSync();
          return len;
        }
        this.setPos(position + len);
        return len;
      };
      PreloadFile3.prototype.read = function(buffer, offset, length, position, cb) {
        try {
          cb(null, this.readSync(buffer, offset, length, position), buffer);
        } catch (e) {
          cb(e);
        }
      };
      PreloadFile3.prototype.readSync = function(buffer, offset, length, position) {
        if (!this._flag.isReadable()) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.EPERM, "File not opened with a readable mode.");
        }
        if (position === void 0 || position === null) {
          position = this.getPos();
        }
        var endRead = position + length;
        if (endRead > this._stat.size) {
          length = this._stat.size - position;
        }
        var rv = this._buffer.copy(buffer, offset, position, position + length);
        this._stat.atime = /* @__PURE__ */ new Date();
        this._pos = position + length;
        return rv;
      };
      PreloadFile3.prototype.chmod = function(mode, cb) {
        try {
          this.chmodSync(mode);
          cb();
        } catch (e) {
          cb(e);
        }
      };
      PreloadFile3.prototype.chmodSync = function(mode) {
        if (!this._fs.supportsProps()) {
          throw new api_error_1.ApiError(api_error_1.ErrorCode.ENOTSUP);
        }
        this._dirty = true;
        this._stat.chmod(mode);
        this.syncSync();
      };
      PreloadFile3.prototype.isDirty = function() {
        return this._dirty;
      };
      PreloadFile3.prototype.resetDirty = function() {
        this._dirty = false;
      };
      return PreloadFile3;
    }(file_1.BaseFile);
    exports["default"] = PreloadFile2;
    var NoSyncFile2 = function(_super) {
      __extends(NoSyncFile3, _super);
      function NoSyncFile3(_fs, _path, _flag, _stat, contents) {
        return _super.call(this, _fs, _path, _flag, _stat, contents) || this;
      }
      NoSyncFile3.prototype.sync = function(cb) {
        cb();
      };
      NoSyncFile3.prototype.syncSync = function() {
      };
      NoSyncFile3.prototype.close = function(cb) {
        cb();
      };
      NoSyncFile3.prototype.closeSync = function() {
      };
      return NoSyncFile3;
    }(PreloadFile2);
    exports.NoSyncFile = NoSyncFile2;
  }
});

// ../../node_modules/lodash/lodash.js
var require_lodash = __commonJS({
  "../../node_modules/lodash/lodash.js"(exports, module2) {
    (function() {
      var undefined2;
      var VERSION = "4.17.21";
      var LARGE_ARRAY_SIZE = 200;
      var CORE_ERROR_TEXT = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.", FUNC_ERROR_TEXT = "Expected a function", INVALID_TEMPL_VAR_ERROR_TEXT = "Invalid `variable` option passed into `_.template`";
      var HASH_UNDEFINED = "__lodash_hash_undefined__";
      var MAX_MEMOIZE_SIZE = 500;
      var PLACEHOLDER = "__lodash_placeholder__";
      var CLONE_DEEP_FLAG = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG = 4;
      var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
      var WRAP_BIND_FLAG = 1, WRAP_BIND_KEY_FLAG = 2, WRAP_CURRY_BOUND_FLAG = 4, WRAP_CURRY_FLAG = 8, WRAP_CURRY_RIGHT_FLAG = 16, WRAP_PARTIAL_FLAG = 32, WRAP_PARTIAL_RIGHT_FLAG = 64, WRAP_ARY_FLAG = 128, WRAP_REARG_FLAG = 256, WRAP_FLIP_FLAG = 512;
      var DEFAULT_TRUNC_LENGTH = 30, DEFAULT_TRUNC_OMISSION = "...";
      var HOT_COUNT = 800, HOT_SPAN = 16;
      var LAZY_FILTER_FLAG = 1, LAZY_MAP_FLAG = 2, LAZY_WHILE_FLAG = 3;
      var INFINITY = 1 / 0, MAX_SAFE_INTEGER = 9007199254740991, MAX_INTEGER = 17976931348623157e292, NAN = 0 / 0;
      var MAX_ARRAY_LENGTH = 4294967295, MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH - 1, HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;
      var wrapFlags = [
        ["ary", WRAP_ARY_FLAG],
        ["bind", WRAP_BIND_FLAG],
        ["bindKey", WRAP_BIND_KEY_FLAG],
        ["curry", WRAP_CURRY_FLAG],
        ["curryRight", WRAP_CURRY_RIGHT_FLAG],
        ["flip", WRAP_FLIP_FLAG],
        ["partial", WRAP_PARTIAL_FLAG],
        ["partialRight", WRAP_PARTIAL_RIGHT_FLAG],
        ["rearg", WRAP_REARG_FLAG]
      ];
      var argsTag = "[object Arguments]", arrayTag = "[object Array]", asyncTag = "[object AsyncFunction]", boolTag = "[object Boolean]", dateTag = "[object Date]", domExcTag = "[object DOMException]", errorTag = "[object Error]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", mapTag = "[object Map]", numberTag = "[object Number]", nullTag = "[object Null]", objectTag = "[object Object]", promiseTag = "[object Promise]", proxyTag = "[object Proxy]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", symbolTag = "[object Symbol]", undefinedTag = "[object Undefined]", weakMapTag = "[object WeakMap]", weakSetTag = "[object WeakSet]";
      var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
      var reEmptyStringLeading = /\b__p \+= '';/g, reEmptyStringMiddle = /\b(__p \+=) '' \+/g, reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
      var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g, reUnescapedHtml = /[&<>"']/g, reHasEscapedHtml = RegExp(reEscapedHtml.source), reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
      var reEscape = /<%-([\s\S]+?)%>/g, reEvaluate = /<%([\s\S]+?)%>/g, reInterpolate = /<%=([\s\S]+?)%>/g;
      var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/, rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
      var reRegExpChar = /[\\^$.*+?()[\]{}|]/g, reHasRegExpChar = RegExp(reRegExpChar.source);
      var reTrimStart = /^\s+/;
      var reWhitespace = /\s/;
      var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/, reSplitDetails = /,? & /;
      var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
      var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
      var reEscapeChar = /\\(\\)?/g;
      var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
      var reFlags = /\w*$/;
      var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
      var reIsBinary = /^0b[01]+$/i;
      var reIsHostCtor = /^\[object .+?Constructor\]$/;
      var reIsOctal = /^0o[0-7]+$/i;
      var reIsUint = /^(?:0|[1-9]\d*)$/;
      var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
      var reNoMatch = /($^)/;
      var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
      var rsAstralRange = "\\ud800-\\udfff", rsComboMarksRange = "\\u0300-\\u036f", reComboHalfMarksRange = "\\ufe20-\\ufe2f", rsComboSymbolsRange = "\\u20d0-\\u20ff", rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange, rsDingbatRange = "\\u2700-\\u27bf", rsLowerRange = "a-z\\xdf-\\xf6\\xf8-\\xff", rsMathOpRange = "\\xac\\xb1\\xd7\\xf7", rsNonCharRange = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", rsPunctuationRange = "\\u2000-\\u206f", rsSpaceRange = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", rsUpperRange = "A-Z\\xc0-\\xd6\\xd8-\\xde", rsVarRange = "\\ufe0e\\ufe0f", rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
      var rsApos = "['\u2019]", rsAstral = "[" + rsAstralRange + "]", rsBreak = "[" + rsBreakRange + "]", rsCombo = "[" + rsComboRange + "]", rsDigits = "\\d+", rsDingbat = "[" + rsDingbatRange + "]", rsLower = "[" + rsLowerRange + "]", rsMisc = "[^" + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + "]", rsFitz = "\\ud83c[\\udffb-\\udfff]", rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")", rsNonAstral = "[^" + rsAstralRange + "]", rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}", rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]", rsUpper = "[" + rsUpperRange + "]", rsZWJ = "\\u200d";
      var rsMiscLower = "(?:" + rsLower + "|" + rsMisc + ")", rsMiscUpper = "(?:" + rsUpper + "|" + rsMisc + ")", rsOptContrLower = "(?:" + rsApos + "(?:d|ll|m|re|s|t|ve))?", rsOptContrUpper = "(?:" + rsApos + "(?:D|LL|M|RE|S|T|VE))?", reOptMod = rsModifier + "?", rsOptVar = "[" + rsVarRange + "]?", rsOptJoin = "(?:" + rsZWJ + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*", rsOrdLower = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", rsOrdUpper = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", rsSeq = rsOptVar + reOptMod + rsOptJoin, rsEmoji = "(?:" + [rsDingbat, rsRegional, rsSurrPair].join("|") + ")" + rsSeq, rsSymbol = "(?:" + [rsNonAstral + rsCombo + "?", rsCombo, rsRegional, rsSurrPair, rsAstral].join("|") + ")";
      var reApos = RegExp(rsApos, "g");
      var reComboMark = RegExp(rsCombo, "g");
      var reUnicode = RegExp(rsFitz + "(?=" + rsFitz + ")|" + rsSymbol + rsSeq, "g");
      var reUnicodeWord = RegExp([
        rsUpper + "?" + rsLower + "+" + rsOptContrLower + "(?=" + [rsBreak, rsUpper, "$"].join("|") + ")",
        rsMiscUpper + "+" + rsOptContrUpper + "(?=" + [rsBreak, rsUpper + rsMiscLower, "$"].join("|") + ")",
        rsUpper + "?" + rsMiscLower + "+" + rsOptContrLower,
        rsUpper + "+" + rsOptContrUpper,
        rsOrdUpper,
        rsOrdLower,
        rsDigits,
        rsEmoji
      ].join("|"), "g");
      var reHasUnicode = RegExp("[" + rsZWJ + rsAstralRange + rsComboRange + rsVarRange + "]");
      var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
      var contextProps = [
        "Array",
        "Buffer",
        "DataView",
        "Date",
        "Error",
        "Float32Array",
        "Float64Array",
        "Function",
        "Int8Array",
        "Int16Array",
        "Int32Array",
        "Map",
        "Math",
        "Object",
        "Promise",
        "RegExp",
        "Set",
        "String",
        "Symbol",
        "TypeError",
        "Uint8Array",
        "Uint8ClampedArray",
        "Uint16Array",
        "Uint32Array",
        "WeakMap",
        "_",
        "clearTimeout",
        "isFinite",
        "parseInt",
        "setTimeout"
      ];
      var templateCounter = -1;
      var typedArrayTags = {};
      typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
      typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
      var cloneableTags = {};
      cloneableTags[argsTag] = cloneableTags[arrayTag] = cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] = cloneableTags[boolTag] = cloneableTags[dateTag] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[mapTag] = cloneableTags[numberTag] = cloneableTags[objectTag] = cloneableTags[regexpTag] = cloneableTags[setTag] = cloneableTags[stringTag] = cloneableTags[symbolTag] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
      cloneableTags[errorTag] = cloneableTags[funcTag] = cloneableTags[weakMapTag] = false;
      var deburredLetters = {
        // Latin-1 Supplement block.
        "\xC0": "A",
        "\xC1": "A",
        "\xC2": "A",
        "\xC3": "A",
        "\xC4": "A",
        "\xC5": "A",
        "\xE0": "a",
        "\xE1": "a",
        "\xE2": "a",
        "\xE3": "a",
        "\xE4": "a",
        "\xE5": "a",
        "\xC7": "C",
        "\xE7": "c",
        "\xD0": "D",
        "\xF0": "d",
        "\xC8": "E",
        "\xC9": "E",
        "\xCA": "E",
        "\xCB": "E",
        "\xE8": "e",
        "\xE9": "e",
        "\xEA": "e",
        "\xEB": "e",
        "\xCC": "I",
        "\xCD": "I",
        "\xCE": "I",
        "\xCF": "I",
        "\xEC": "i",
        "\xED": "i",
        "\xEE": "i",
        "\xEF": "i",
        "\xD1": "N",
        "\xF1": "n",
        "\xD2": "O",
        "\xD3": "O",
        "\xD4": "O",
        "\xD5": "O",
        "\xD6": "O",
        "\xD8": "O",
        "\xF2": "o",
        "\xF3": "o",
        "\xF4": "o",
        "\xF5": "o",
        "\xF6": "o",
        "\xF8": "o",
        "\xD9": "U",
        "\xDA": "U",
        "\xDB": "U",
        "\xDC": "U",
        "\xF9": "u",
        "\xFA": "u",
        "\xFB": "u",
        "\xFC": "u",
        "\xDD": "Y",
        "\xFD": "y",
        "\xFF": "y",
        "\xC6": "Ae",
        "\xE6": "ae",
        "\xDE": "Th",
        "\xFE": "th",
        "\xDF": "ss",
        // Latin Extended-A block.
        "\u0100": "A",
        "\u0102": "A",
        "\u0104": "A",
        "\u0101": "a",
        "\u0103": "a",
        "\u0105": "a",
        "\u0106": "C",
        "\u0108": "C",
        "\u010A": "C",
        "\u010C": "C",
        "\u0107": "c",
        "\u0109": "c",
        "\u010B": "c",
        "\u010D": "c",
        "\u010E": "D",
        "\u0110": "D",
        "\u010F": "d",
        "\u0111": "d",
        "\u0112": "E",
        "\u0114": "E",
        "\u0116": "E",
        "\u0118": "E",
        "\u011A": "E",
        "\u0113": "e",
        "\u0115": "e",
        "\u0117": "e",
        "\u0119": "e",
        "\u011B": "e",
        "\u011C": "G",
        "\u011E": "G",
        "\u0120": "G",
        "\u0122": "G",
        "\u011D": "g",
        "\u011F": "g",
        "\u0121": "g",
        "\u0123": "g",
        "\u0124": "H",
        "\u0126": "H",
        "\u0125": "h",
        "\u0127": "h",
        "\u0128": "I",
        "\u012A": "I",
        "\u012C": "I",
        "\u012E": "I",
        "\u0130": "I",
        "\u0129": "i",
        "\u012B": "i",
        "\u012D": "i",
        "\u012F": "i",
        "\u0131": "i",
        "\u0134": "J",
        "\u0135": "j",
        "\u0136": "K",
        "\u0137": "k",
        "\u0138": "k",
        "\u0139": "L",
        "\u013B": "L",
        "\u013D": "L",
        "\u013F": "L",
        "\u0141": "L",
        "\u013A": "l",
        "\u013C": "l",
        "\u013E": "l",
        "\u0140": "l",
        "\u0142": "l",
        "\u0143": "N",
        "\u0145": "N",
        "\u0147": "N",
        "\u014A": "N",
        "\u0144": "n",
        "\u0146": "n",
        "\u0148": "n",
        "\u014B": "n",
        "\u014C": "O",
        "\u014E": "O",
        "\u0150": "O",
        "\u014D": "o",
        "\u014F": "o",
        "\u0151": "o",
        "\u0154": "R",
        "\u0156": "R",
        "\u0158": "R",
        "\u0155": "r",
        "\u0157": "r",
        "\u0159": "r",
        "\u015A": "S",
        "\u015C": "S",
        "\u015E": "S",
        "\u0160": "S",
        "\u015B": "s",
        "\u015D": "s",
        "\u015F": "s",
        "\u0161": "s",
        "\u0162": "T",
        "\u0164": "T",
        "\u0166": "T",
        "\u0163": "t",
        "\u0165": "t",
        "\u0167": "t",
        "\u0168": "U",
        "\u016A": "U",
        "\u016C": "U",
        "\u016E": "U",
        "\u0170": "U",
        "\u0172": "U",
        "\u0169": "u",
        "\u016B": "u",
        "\u016D": "u",
        "\u016F": "u",
        "\u0171": "u",
        "\u0173": "u",
        "\u0174": "W",
        "\u0175": "w",
        "\u0176": "Y",
        "\u0177": "y",
        "\u0178": "Y",
        "\u0179": "Z",
        "\u017B": "Z",
        "\u017D": "Z",
        "\u017A": "z",
        "\u017C": "z",
        "\u017E": "z",
        "\u0132": "IJ",
        "\u0133": "ij",
        "\u0152": "Oe",
        "\u0153": "oe",
        "\u0149": "'n",
        "\u017F": "s"
      };
      var htmlEscapes = {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': "&quot;",
        "'": "&#39;"
      };
      var htmlUnescapes = {
        "&amp;": "&",
        "&lt;": "<",
        "&gt;": ">",
        "&quot;": '"',
        "&#39;": "'"
      };
      var stringEscapes = {
        "\\": "\\",
        "'": "'",
        "\n": "n",
        "\r": "r",
        "\u2028": "u2028",
        "\u2029": "u2029"
      };
      var freeParseFloat = parseFloat, freeParseInt = parseInt;
      var freeGlobal = typeof globalThis == "object" && globalThis && globalThis.Object === Object && globalThis;
      var freeSelf = typeof self == "object" && self && self.Object === Object && self;
      var root = freeGlobal || freeSelf || Function("return this")();
      var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
      var freeModule = freeExports && typeof module2 == "object" && module2 && !module2.nodeType && module2;
      var moduleExports = freeModule && freeModule.exports === freeExports;
      var freeProcess = moduleExports && freeGlobal.process;
      var nodeUtil = function() {
        try {
          var types = freeModule && freeModule.require && freeModule.require("util").types;
          if (types) {
            return types;
          }
          return freeProcess && freeProcess.binding && freeProcess.binding("util");
        } catch (e) {
        }
      }();
      var nodeIsArrayBuffer = nodeUtil && nodeUtil.isArrayBuffer, nodeIsDate = nodeUtil && nodeUtil.isDate, nodeIsMap = nodeUtil && nodeUtil.isMap, nodeIsRegExp = nodeUtil && nodeUtil.isRegExp, nodeIsSet = nodeUtil && nodeUtil.isSet, nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
      function apply(func, thisArg, args) {
        switch (args.length) {
          case 0:
            return func.call(thisArg);
          case 1:
            return func.call(thisArg, args[0]);
          case 2:
            return func.call(thisArg, args[0], args[1]);
          case 3:
            return func.call(thisArg, args[0], args[1], args[2]);
        }
        return func.apply(thisArg, args);
      }
      function arrayAggregator(array, setter, iteratee, accumulator) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          var value = array[index];
          setter(accumulator, value, iteratee(value), array);
        }
        return accumulator;
      }
      function arrayEach(array, iteratee) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (iteratee(array[index], index, array) === false) {
            break;
          }
        }
        return array;
      }
      function arrayEachRight(array, iteratee) {
        var length = array == null ? 0 : array.length;
        while (length--) {
          if (iteratee(array[length], length, array) === false) {
            break;
          }
        }
        return array;
      }
      function arrayEvery(array, predicate) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (!predicate(array[index], index, array)) {
            return false;
          }
        }
        return true;
      }
      function arrayFilter(array, predicate) {
        var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
        while (++index < length) {
          var value = array[index];
          if (predicate(value, index, array)) {
            result[resIndex++] = value;
          }
        }
        return result;
      }
      function arrayIncludes(array, value) {
        var length = array == null ? 0 : array.length;
        return !!length && baseIndexOf(array, value, 0) > -1;
      }
      function arrayIncludesWith(array, value, comparator) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (comparator(value, array[index])) {
            return true;
          }
        }
        return false;
      }
      function arrayMap(array, iteratee) {
        var index = -1, length = array == null ? 0 : array.length, result = Array(length);
        while (++index < length) {
          result[index] = iteratee(array[index], index, array);
        }
        return result;
      }
      function arrayPush(array, values) {
        var index = -1, length = values.length, offset = array.length;
        while (++index < length) {
          array[offset + index] = values[index];
        }
        return array;
      }
      function arrayReduce(array, iteratee, accumulator, initAccum) {
        var index = -1, length = array == null ? 0 : array.length;
        if (initAccum && length) {
          accumulator = array[++index];
        }
        while (++index < length) {
          accumulator = iteratee(accumulator, array[index], index, array);
        }
        return accumulator;
      }
      function arrayReduceRight(array, iteratee, accumulator, initAccum) {
        var length = array == null ? 0 : array.length;
        if (initAccum && length) {
          accumulator = array[--length];
        }
        while (length--) {
          accumulator = iteratee(accumulator, array[length], length, array);
        }
        return accumulator;
      }
      function arraySome(array, predicate) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (predicate(array[index], index, array)) {
            return true;
          }
        }
        return false;
      }
      var asciiSize = baseProperty("length");
      function asciiToArray(string) {
        return string.split("");
      }
      function asciiWords(string) {
        return string.match(reAsciiWord) || [];
      }
      function baseFindKey(collection, predicate, eachFunc) {
        var result;
        eachFunc(collection, function(value, key, collection2) {
          if (predicate(value, key, collection2)) {
            result = key;
            return false;
          }
        });
        return result;
      }
      function baseFindIndex(array, predicate, fromIndex, fromRight) {
        var length = array.length, index = fromIndex + (fromRight ? 1 : -1);
        while (fromRight ? index-- : ++index < length) {
          if (predicate(array[index], index, array)) {
            return index;
          }
        }
        return -1;
      }
      function baseIndexOf(array, value, fromIndex) {
        return value === value ? strictIndexOf(array, value, fromIndex) : baseFindIndex(array, baseIsNaN, fromIndex);
      }
      function baseIndexOfWith(array, value, fromIndex, comparator) {
        var index = fromIndex - 1, length = array.length;
        while (++index < length) {
          if (comparator(array[index], value)) {
            return index;
          }
        }
        return -1;
      }
      function baseIsNaN(value) {
        return value !== value;
      }
      function baseMean(array, iteratee) {
        var length = array == null ? 0 : array.length;
        return length ? baseSum(array, iteratee) / length : NAN;
      }
      function baseProperty(key) {
        return function(object) {
          return object == null ? undefined2 : object[key];
        };
      }
      function basePropertyOf(object) {
        return function(key) {
          return object == null ? undefined2 : object[key];
        };
      }
      function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
        eachFunc(collection, function(value, index, collection2) {
          accumulator = initAccum ? (initAccum = false, value) : iteratee(accumulator, value, index, collection2);
        });
        return accumulator;
      }
      function baseSortBy(array, comparer) {
        var length = array.length;
        array.sort(comparer);
        while (length--) {
          array[length] = array[length].value;
        }
        return array;
      }
      function baseSum(array, iteratee) {
        var result, index = -1, length = array.length;
        while (++index < length) {
          var current = iteratee(array[index]);
          if (current !== undefined2) {
            result = result === undefined2 ? current : result + current;
          }
        }
        return result;
      }
      function baseTimes(n, iteratee) {
        var index = -1, result = Array(n);
        while (++index < n) {
          result[index] = iteratee(index);
        }
        return result;
      }
      function baseToPairs(object, props) {
        return arrayMap(props, function(key) {
          return [key, object[key]];
        });
      }
      function baseTrim(string) {
        return string ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, "") : string;
      }
      function baseUnary(func) {
        return function(value) {
          return func(value);
        };
      }
      function baseValues(object, props) {
        return arrayMap(props, function(key) {
          return object[key];
        });
      }
      function cacheHas(cache, key) {
        return cache.has(key);
      }
      function charsStartIndex(strSymbols, chrSymbols) {
        var index = -1, length = strSymbols.length;
        while (++index < length && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {
        }
        return index;
      }
      function charsEndIndex(strSymbols, chrSymbols) {
        var index = strSymbols.length;
        while (index-- && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {
        }
        return index;
      }
      function countHolders(array, placeholder) {
        var length = array.length, result = 0;
        while (length--) {
          if (array[length] === placeholder) {
            ++result;
          }
        }
        return result;
      }
      var deburrLetter = basePropertyOf(deburredLetters);
      var escapeHtmlChar = basePropertyOf(htmlEscapes);
      function escapeStringChar(chr) {
        return "\\" + stringEscapes[chr];
      }
      function getValue(object, key) {
        return object == null ? undefined2 : object[key];
      }
      function hasUnicode(string) {
        return reHasUnicode.test(string);
      }
      function hasUnicodeWord(string) {
        return reHasUnicodeWord.test(string);
      }
      function iteratorToArray(iterator) {
        var data, result = [];
        while (!(data = iterator.next()).done) {
          result.push(data.value);
        }
        return result;
      }
      function mapToArray(map) {
        var index = -1, result = Array(map.size);
        map.forEach(function(value, key) {
          result[++index] = [key, value];
        });
        return result;
      }
      function overArg(func, transform) {
        return function(arg) {
          return func(transform(arg));
        };
      }
      function replaceHolders(array, placeholder) {
        var index = -1, length = array.length, resIndex = 0, result = [];
        while (++index < length) {
          var value = array[index];
          if (value === placeholder || value === PLACEHOLDER) {
            array[index] = PLACEHOLDER;
            result[resIndex++] = index;
          }
        }
        return result;
      }
      function setToArray(set) {
        var index = -1, result = Array(set.size);
        set.forEach(function(value) {
          result[++index] = value;
        });
        return result;
      }
      function setToPairs(set) {
        var index = -1, result = Array(set.size);
        set.forEach(function(value) {
          result[++index] = [value, value];
        });
        return result;
      }
      function strictIndexOf(array, value, fromIndex) {
        var index = fromIndex - 1, length = array.length;
        while (++index < length) {
          if (array[index] === value) {
            return index;
          }
        }
        return -1;
      }
      function strictLastIndexOf(array, value, fromIndex) {
        var index = fromIndex + 1;
        while (index--) {
          if (array[index] === value) {
            return index;
          }
        }
        return index;
      }
      function stringSize(string) {
        return hasUnicode(string) ? unicodeSize(string) : asciiSize(string);
      }
      function stringToArray(string) {
        return hasUnicode(string) ? unicodeToArray(string) : asciiToArray(string);
      }
      function trimmedEndIndex(string) {
        var index = string.length;
        while (index-- && reWhitespace.test(string.charAt(index))) {
        }
        return index;
      }
      var unescapeHtmlChar = basePropertyOf(htmlUnescapes);
      function unicodeSize(string) {
        var result = reUnicode.lastIndex = 0;
        while (reUnicode.test(string)) {
          ++result;
        }
        return result;
      }
      function unicodeToArray(string) {
        return string.match(reUnicode) || [];
      }
      function unicodeWords(string) {
        return string.match(reUnicodeWord) || [];
      }
      var runInContext = function runInContext2(context) {
        context = context == null ? root : _.defaults(root.Object(), context, _.pick(root, contextProps));
        var Array2 = context.Array, Date2 = context.Date, Error2 = context.Error, Function2 = context.Function, Math2 = context.Math, Object2 = context.Object, RegExp2 = context.RegExp, String2 = context.String, TypeError2 = context.TypeError;
        var arrayProto = Array2.prototype, funcProto = Function2.prototype, objectProto = Object2.prototype;
        var coreJsData = context["__core-js_shared__"];
        var funcToString = funcProto.toString;
        var hasOwnProperty = objectProto.hasOwnProperty;
        var idCounter = 0;
        var maskSrcKey = function() {
          var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
          return uid ? "Symbol(src)_1." + uid : "";
        }();
        var nativeObjectToString = objectProto.toString;
        var objectCtorString = funcToString.call(Object2);
        var oldDash = root._;
        var reIsNative = RegExp2(
          "^" + funcToString.call(hasOwnProperty).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
        );
        var Buffer2 = moduleExports ? context.Buffer : undefined2, Symbol2 = context.Symbol, Uint8Array2 = context.Uint8Array, allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : undefined2, getPrototype = overArg(Object2.getPrototypeOf, Object2), objectCreate = Object2.create, propertyIsEnumerable = objectProto.propertyIsEnumerable, splice = arrayProto.splice, spreadableSymbol = Symbol2 ? Symbol2.isConcatSpreadable : undefined2, symIterator = Symbol2 ? Symbol2.iterator : undefined2, symToStringTag = Symbol2 ? Symbol2.toStringTag : undefined2;
        var defineProperty = function() {
          try {
            var func = getNative(Object2, "defineProperty");
            func({}, "", {});
            return func;
          } catch (e) {
          }
        }();
        var ctxClearTimeout = context.clearTimeout !== root.clearTimeout && context.clearTimeout, ctxNow = Date2 && Date2.now !== root.Date.now && Date2.now, ctxSetTimeout = context.setTimeout !== root.setTimeout && context.setTimeout;
        var nativeCeil = Math2.ceil, nativeFloor = Math2.floor, nativeGetSymbols = Object2.getOwnPropertySymbols, nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : undefined2, nativeIsFinite = context.isFinite, nativeJoin = arrayProto.join, nativeKeys = overArg(Object2.keys, Object2), nativeMax = Math2.max, nativeMin = Math2.min, nativeNow = Date2.now, nativeParseInt = context.parseInt, nativeRandom = Math2.random, nativeReverse = arrayProto.reverse;
        var DataView2 = getNative(context, "DataView"), Map2 = getNative(context, "Map"), Promise2 = getNative(context, "Promise"), Set2 = getNative(context, "Set"), WeakMap2 = getNative(context, "WeakMap"), nativeCreate = getNative(Object2, "create");
        var metaMap = WeakMap2 && new WeakMap2();
        var realNames = {};
        var dataViewCtorString = toSource(DataView2), mapCtorString = toSource(Map2), promiseCtorString = toSource(Promise2), setCtorString = toSource(Set2), weakMapCtorString = toSource(WeakMap2);
        var symbolProto = Symbol2 ? Symbol2.prototype : undefined2, symbolValueOf = symbolProto ? symbolProto.valueOf : undefined2, symbolToString = symbolProto ? symbolProto.toString : undefined2;
        function lodash(value) {
          if (isObjectLike(value) && !isArray(value) && !(value instanceof LazyWrapper)) {
            if (value instanceof LodashWrapper) {
              return value;
            }
            if (hasOwnProperty.call(value, "__wrapped__")) {
              return wrapperClone(value);
            }
          }
          return new LodashWrapper(value);
        }
        var baseCreate = /* @__PURE__ */ function() {
          function object() {
          }
          return function(proto) {
            if (!isObject(proto)) {
              return {};
            }
            if (objectCreate) {
              return objectCreate(proto);
            }
            object.prototype = proto;
            var result2 = new object();
            object.prototype = undefined2;
            return result2;
          };
        }();
        function baseLodash() {
        }
        function LodashWrapper(value, chainAll) {
          this.__wrapped__ = value;
          this.__actions__ = [];
          this.__chain__ = !!chainAll;
          this.__index__ = 0;
          this.__values__ = undefined2;
        }
        lodash.templateSettings = {
          /**
           * Used to detect `data` property values to be HTML-escaped.
           *
           * @memberOf _.templateSettings
           * @type {RegExp}
           */
          "escape": reEscape,
          /**
           * Used to detect code to be evaluated.
           *
           * @memberOf _.templateSettings
           * @type {RegExp}
           */
          "evaluate": reEvaluate,
          /**
           * Used to detect `data` property values to inject.
           *
           * @memberOf _.templateSettings
           * @type {RegExp}
           */
          "interpolate": reInterpolate,
          /**
           * Used to reference the data object in the template text.
           *
           * @memberOf _.templateSettings
           * @type {string}
           */
          "variable": "",
          /**
           * Used to import variables into the compiled template.
           *
           * @memberOf _.templateSettings
           * @type {Object}
           */
          "imports": {
            /**
             * A reference to the `lodash` function.
             *
             * @memberOf _.templateSettings.imports
             * @type {Function}
             */
            "_": lodash
          }
        };
        lodash.prototype = baseLodash.prototype;
        lodash.prototype.constructor = lodash;
        LodashWrapper.prototype = baseCreate(baseLodash.prototype);
        LodashWrapper.prototype.constructor = LodashWrapper;
        function LazyWrapper(value) {
          this.__wrapped__ = value;
          this.__actions__ = [];
          this.__dir__ = 1;
          this.__filtered__ = false;
          this.__iteratees__ = [];
          this.__takeCount__ = MAX_ARRAY_LENGTH;
          this.__views__ = [];
        }
        function lazyClone() {
          var result2 = new LazyWrapper(this.__wrapped__);
          result2.__actions__ = copyArray(this.__actions__);
          result2.__dir__ = this.__dir__;
          result2.__filtered__ = this.__filtered__;
          result2.__iteratees__ = copyArray(this.__iteratees__);
          result2.__takeCount__ = this.__takeCount__;
          result2.__views__ = copyArray(this.__views__);
          return result2;
        }
        function lazyReverse() {
          if (this.__filtered__) {
            var result2 = new LazyWrapper(this);
            result2.__dir__ = -1;
            result2.__filtered__ = true;
          } else {
            result2 = this.clone();
            result2.__dir__ *= -1;
          }
          return result2;
        }
        function lazyValue() {
          var array = this.__wrapped__.value(), dir = this.__dir__, isArr = isArray(array), isRight = dir < 0, arrLength = isArr ? array.length : 0, view = getView(0, arrLength, this.__views__), start2 = view.start, end = view.end, length = end - start2, index = isRight ? end : start2 - 1, iteratees = this.__iteratees__, iterLength = iteratees.length, resIndex = 0, takeCount = nativeMin(length, this.__takeCount__);
          if (!isArr || !isRight && arrLength == length && takeCount == length) {
            return baseWrapperValue(array, this.__actions__);
          }
          var result2 = [];
          outer:
            while (length-- && resIndex < takeCount) {
              index += dir;
              var iterIndex = -1, value = array[index];
              while (++iterIndex < iterLength) {
                var data = iteratees[iterIndex], iteratee2 = data.iteratee, type = data.type, computed = iteratee2(value);
                if (type == LAZY_MAP_FLAG) {
                  value = computed;
                } else if (!computed) {
                  if (type == LAZY_FILTER_FLAG) {
                    continue outer;
                  } else {
                    break outer;
                  }
                }
              }
              result2[resIndex++] = value;
            }
          return result2;
        }
        LazyWrapper.prototype = baseCreate(baseLodash.prototype);
        LazyWrapper.prototype.constructor = LazyWrapper;
        function Hash(entries) {
          var index = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
          }
        }
        function hashClear() {
          this.__data__ = nativeCreate ? nativeCreate(null) : {};
          this.size = 0;
        }
        function hashDelete(key) {
          var result2 = this.has(key) && delete this.__data__[key];
          this.size -= result2 ? 1 : 0;
          return result2;
        }
        function hashGet(key) {
          var data = this.__data__;
          if (nativeCreate) {
            var result2 = data[key];
            return result2 === HASH_UNDEFINED ? undefined2 : result2;
          }
          return hasOwnProperty.call(data, key) ? data[key] : undefined2;
        }
        function hashHas(key) {
          var data = this.__data__;
          return nativeCreate ? data[key] !== undefined2 : hasOwnProperty.call(data, key);
        }
        function hashSet(key, value) {
          var data = this.__data__;
          this.size += this.has(key) ? 0 : 1;
          data[key] = nativeCreate && value === undefined2 ? HASH_UNDEFINED : value;
          return this;
        }
        Hash.prototype.clear = hashClear;
        Hash.prototype["delete"] = hashDelete;
        Hash.prototype.get = hashGet;
        Hash.prototype.has = hashHas;
        Hash.prototype.set = hashSet;
        function ListCache(entries) {
          var index = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
          }
        }
        function listCacheClear() {
          this.__data__ = [];
          this.size = 0;
        }
        function listCacheDelete(key) {
          var data = this.__data__, index = assocIndexOf(data, key);
          if (index < 0) {
            return false;
          }
          var lastIndex = data.length - 1;
          if (index == lastIndex) {
            data.pop();
          } else {
            splice.call(data, index, 1);
          }
          --this.size;
          return true;
        }
        function listCacheGet(key) {
          var data = this.__data__, index = assocIndexOf(data, key);
          return index < 0 ? undefined2 : data[index][1];
        }
        function listCacheHas(key) {
          return assocIndexOf(this.__data__, key) > -1;
        }
        function listCacheSet(key, value) {
          var data = this.__data__, index = assocIndexOf(data, key);
          if (index < 0) {
            ++this.size;
            data.push([key, value]);
          } else {
            data[index][1] = value;
          }
          return this;
        }
        ListCache.prototype.clear = listCacheClear;
        ListCache.prototype["delete"] = listCacheDelete;
        ListCache.prototype.get = listCacheGet;
        ListCache.prototype.has = listCacheHas;
        ListCache.prototype.set = listCacheSet;
        function MapCache(entries) {
          var index = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
          }
        }
        function mapCacheClear() {
          this.size = 0;
          this.__data__ = {
            "hash": new Hash(),
            "map": new (Map2 || ListCache)(),
            "string": new Hash()
          };
        }
        function mapCacheDelete(key) {
          var result2 = getMapData(this, key)["delete"](key);
          this.size -= result2 ? 1 : 0;
          return result2;
        }
        function mapCacheGet(key) {
          return getMapData(this, key).get(key);
        }
        function mapCacheHas(key) {
          return getMapData(this, key).has(key);
        }
        function mapCacheSet(key, value) {
          var data = getMapData(this, key), size2 = data.size;
          data.set(key, value);
          this.size += data.size == size2 ? 0 : 1;
          return this;
        }
        MapCache.prototype.clear = mapCacheClear;
        MapCache.prototype["delete"] = mapCacheDelete;
        MapCache.prototype.get = mapCacheGet;
        MapCache.prototype.has = mapCacheHas;
        MapCache.prototype.set = mapCacheSet;
        function SetCache(values2) {
          var index = -1, length = values2 == null ? 0 : values2.length;
          this.__data__ = new MapCache();
          while (++index < length) {
            this.add(values2[index]);
          }
        }
        function setCacheAdd(value) {
          this.__data__.set(value, HASH_UNDEFINED);
          return this;
        }
        function setCacheHas(value) {
          return this.__data__.has(value);
        }
        SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
        SetCache.prototype.has = setCacheHas;
        function Stack(entries) {
          var data = this.__data__ = new ListCache(entries);
          this.size = data.size;
        }
        function stackClear() {
          this.__data__ = new ListCache();
          this.size = 0;
        }
        function stackDelete(key) {
          var data = this.__data__, result2 = data["delete"](key);
          this.size = data.size;
          return result2;
        }
        function stackGet(key) {
          return this.__data__.get(key);
        }
        function stackHas(key) {
          return this.__data__.has(key);
        }
        function stackSet(key, value) {
          var data = this.__data__;
          if (data instanceof ListCache) {
            var pairs = data.__data__;
            if (!Map2 || pairs.length < LARGE_ARRAY_SIZE - 1) {
              pairs.push([key, value]);
              this.size = ++data.size;
              return this;
            }
            data = this.__data__ = new MapCache(pairs);
          }
          data.set(key, value);
          this.size = data.size;
          return this;
        }
        Stack.prototype.clear = stackClear;
        Stack.prototype["delete"] = stackDelete;
        Stack.prototype.get = stackGet;
        Stack.prototype.has = stackHas;
        Stack.prototype.set = stackSet;
        function arrayLikeKeys(value, inherited) {
          var isArr = isArray(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer(value), isType = !isArr && !isArg && !isBuff && isTypedArray(value), skipIndexes = isArr || isArg || isBuff || isType, result2 = skipIndexes ? baseTimes(value.length, String2) : [], length = result2.length;
          for (var key in value) {
            if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
            (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
            isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
            isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
            isIndex(key, length)))) {
              result2.push(key);
            }
          }
          return result2;
        }
        function arraySample(array) {
          var length = array.length;
          return length ? array[baseRandom(0, length - 1)] : undefined2;
        }
        function arraySampleSize(array, n) {
          return shuffleSelf(copyArray(array), baseClamp(n, 0, array.length));
        }
        function arrayShuffle(array) {
          return shuffleSelf(copyArray(array));
        }
        function assignMergeValue(object, key, value) {
          if (value !== undefined2 && !eq(object[key], value) || value === undefined2 && !(key in object)) {
            baseAssignValue(object, key, value);
          }
        }
        function assignValue(object, key, value) {
          var objValue = object[key];
          if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) || value === undefined2 && !(key in object)) {
            baseAssignValue(object, key, value);
          }
        }
        function assocIndexOf(array, key) {
          var length = array.length;
          while (length--) {
            if (eq(array[length][0], key)) {
              return length;
            }
          }
          return -1;
        }
        function baseAggregator(collection, setter, iteratee2, accumulator) {
          baseEach(collection, function(value, key, collection2) {
            setter(accumulator, value, iteratee2(value), collection2);
          });
          return accumulator;
        }
        function baseAssign(object, source) {
          return object && copyObject(source, keys(source), object);
        }
        function baseAssignIn(object, source) {
          return object && copyObject(source, keysIn(source), object);
        }
        function baseAssignValue(object, key, value) {
          if (key == "__proto__" && defineProperty) {
            defineProperty(object, key, {
              "configurable": true,
              "enumerable": true,
              "value": value,
              "writable": true
            });
          } else {
            object[key] = value;
          }
        }
        function baseAt(object, paths) {
          var index = -1, length = paths.length, result2 = Array2(length), skip = object == null;
          while (++index < length) {
            result2[index] = skip ? undefined2 : get(object, paths[index]);
          }
          return result2;
        }
        function baseClamp(number, lower, upper) {
          if (number === number) {
            if (upper !== undefined2) {
              number = number <= upper ? number : upper;
            }
            if (lower !== undefined2) {
              number = number >= lower ? number : lower;
            }
          }
          return number;
        }
        function baseClone(value, bitmask, customizer, key, object, stack) {
          var result2, isDeep = bitmask & CLONE_DEEP_FLAG, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG;
          if (customizer) {
            result2 = object ? customizer(value, key, object, stack) : customizer(value);
          }
          if (result2 !== undefined2) {
            return result2;
          }
          if (!isObject(value)) {
            return value;
          }
          var isArr = isArray(value);
          if (isArr) {
            result2 = initCloneArray(value);
            if (!isDeep) {
              return copyArray(value, result2);
            }
          } else {
            var tag = getTag(value), isFunc = tag == funcTag || tag == genTag;
            if (isBuffer(value)) {
              return cloneBuffer(value, isDeep);
            }
            if (tag == objectTag || tag == argsTag || isFunc && !object) {
              result2 = isFlat || isFunc ? {} : initCloneObject(value);
              if (!isDeep) {
                return isFlat ? copySymbolsIn(value, baseAssignIn(result2, value)) : copySymbols(value, baseAssign(result2, value));
              }
            } else {
              if (!cloneableTags[tag]) {
                return object ? value : {};
              }
              result2 = initCloneByTag(value, tag, isDeep);
            }
          }
          stack || (stack = new Stack());
          var stacked = stack.get(value);
          if (stacked) {
            return stacked;
          }
          stack.set(value, result2);
          if (isSet(value)) {
            value.forEach(function(subValue) {
              result2.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
            });
          } else if (isMap(value)) {
            value.forEach(function(subValue, key2) {
              result2.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
            });
          }
          var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys : isFlat ? keysIn : keys;
          var props = isArr ? undefined2 : keysFunc(value);
          arrayEach(props || value, function(subValue, key2) {
            if (props) {
              key2 = subValue;
              subValue = value[key2];
            }
            assignValue(result2, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
          });
          return result2;
        }
        function baseConforms(source) {
          var props = keys(source);
          return function(object) {
            return baseConformsTo(object, source, props);
          };
        }
        function baseConformsTo(object, source, props) {
          var length = props.length;
          if (object == null) {
            return !length;
          }
          object = Object2(object);
          while (length--) {
            var key = props[length], predicate = source[key], value = object[key];
            if (value === undefined2 && !(key in object) || !predicate(value)) {
              return false;
            }
          }
          return true;
        }
        function baseDelay(func, wait2, args) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          return setTimeout2(function() {
            func.apply(undefined2, args);
          }, wait2);
        }
        function baseDifference(array, values2, iteratee2, comparator) {
          var index = -1, includes2 = arrayIncludes, isCommon = true, length = array.length, result2 = [], valuesLength = values2.length;
          if (!length) {
            return result2;
          }
          if (iteratee2) {
            values2 = arrayMap(values2, baseUnary(iteratee2));
          }
          if (comparator) {
            includes2 = arrayIncludesWith;
            isCommon = false;
          } else if (values2.length >= LARGE_ARRAY_SIZE) {
            includes2 = cacheHas;
            isCommon = false;
            values2 = new SetCache(values2);
          }
          outer:
            while (++index < length) {
              var value = array[index], computed = iteratee2 == null ? value : iteratee2(value);
              value = comparator || value !== 0 ? value : 0;
              if (isCommon && computed === computed) {
                var valuesIndex = valuesLength;
                while (valuesIndex--) {
                  if (values2[valuesIndex] === computed) {
                    continue outer;
                  }
                }
                result2.push(value);
              } else if (!includes2(values2, computed, comparator)) {
                result2.push(value);
              }
            }
          return result2;
        }
        var baseEach = createBaseEach(baseForOwn);
        var baseEachRight = createBaseEach(baseForOwnRight, true);
        function baseEvery(collection, predicate) {
          var result2 = true;
          baseEach(collection, function(value, index, collection2) {
            result2 = !!predicate(value, index, collection2);
            return result2;
          });
          return result2;
        }
        function baseExtremum(array, iteratee2, comparator) {
          var index = -1, length = array.length;
          while (++index < length) {
            var value = array[index], current = iteratee2(value);
            if (current != null && (computed === undefined2 ? current === current && !isSymbol(current) : comparator(current, computed))) {
              var computed = current, result2 = value;
            }
          }
          return result2;
        }
        function baseFill(array, value, start2, end) {
          var length = array.length;
          start2 = toInteger(start2);
          if (start2 < 0) {
            start2 = -start2 > length ? 0 : length + start2;
          }
          end = end === undefined2 || end > length ? length : toInteger(end);
          if (end < 0) {
            end += length;
          }
          end = start2 > end ? 0 : toLength(end);
          while (start2 < end) {
            array[start2++] = value;
          }
          return array;
        }
        function baseFilter(collection, predicate) {
          var result2 = [];
          baseEach(collection, function(value, index, collection2) {
            if (predicate(value, index, collection2)) {
              result2.push(value);
            }
          });
          return result2;
        }
        function baseFlatten(array, depth, predicate, isStrict, result2) {
          var index = -1, length = array.length;
          predicate || (predicate = isFlattenable);
          result2 || (result2 = []);
          while (++index < length) {
            var value = array[index];
            if (depth > 0 && predicate(value)) {
              if (depth > 1) {
                baseFlatten(value, depth - 1, predicate, isStrict, result2);
              } else {
                arrayPush(result2, value);
              }
            } else if (!isStrict) {
              result2[result2.length] = value;
            }
          }
          return result2;
        }
        var baseFor = createBaseFor();
        var baseForRight = createBaseFor(true);
        function baseForOwn(object, iteratee2) {
          return object && baseFor(object, iteratee2, keys);
        }
        function baseForOwnRight(object, iteratee2) {
          return object && baseForRight(object, iteratee2, keys);
        }
        function baseFunctions(object, props) {
          return arrayFilter(props, function(key) {
            return isFunction(object[key]);
          });
        }
        function baseGet(object, path) {
          path = castPath(path, object);
          var index = 0, length = path.length;
          while (object != null && index < length) {
            object = object[toKey(path[index++])];
          }
          return index && index == length ? object : undefined2;
        }
        function baseGetAllKeys(object, keysFunc, symbolsFunc) {
          var result2 = keysFunc(object);
          return isArray(object) ? result2 : arrayPush(result2, symbolsFunc(object));
        }
        function baseGetTag(value) {
          if (value == null) {
            return value === undefined2 ? undefinedTag : nullTag;
          }
          return symToStringTag && symToStringTag in Object2(value) ? getRawTag(value) : objectToString(value);
        }
        function baseGt(value, other) {
          return value > other;
        }
        function baseHas(object, key) {
          return object != null && hasOwnProperty.call(object, key);
        }
        function baseHasIn(object, key) {
          return object != null && key in Object2(object);
        }
        function baseInRange(number, start2, end) {
          return number >= nativeMin(start2, end) && number < nativeMax(start2, end);
        }
        function baseIntersection(arrays, iteratee2, comparator) {
          var includes2 = comparator ? arrayIncludesWith : arrayIncludes, length = arrays[0].length, othLength = arrays.length, othIndex = othLength, caches = Array2(othLength), maxLength = Infinity, result2 = [];
          while (othIndex--) {
            var array = arrays[othIndex];
            if (othIndex && iteratee2) {
              array = arrayMap(array, baseUnary(iteratee2));
            }
            maxLength = nativeMin(array.length, maxLength);
            caches[othIndex] = !comparator && (iteratee2 || length >= 120 && array.length >= 120) ? new SetCache(othIndex && array) : undefined2;
          }
          array = arrays[0];
          var index = -1, seen = caches[0];
          outer:
            while (++index < length && result2.length < maxLength) {
              var value = array[index], computed = iteratee2 ? iteratee2(value) : value;
              value = comparator || value !== 0 ? value : 0;
              if (!(seen ? cacheHas(seen, computed) : includes2(result2, computed, comparator))) {
                othIndex = othLength;
                while (--othIndex) {
                  var cache = caches[othIndex];
                  if (!(cache ? cacheHas(cache, computed) : includes2(arrays[othIndex], computed, comparator))) {
                    continue outer;
                  }
                }
                if (seen) {
                  seen.push(computed);
                }
                result2.push(value);
              }
            }
          return result2;
        }
        function baseInverter(object, setter, iteratee2, accumulator) {
          baseForOwn(object, function(value, key, object2) {
            setter(accumulator, iteratee2(value), key, object2);
          });
          return accumulator;
        }
        function baseInvoke(object, path, args) {
          path = castPath(path, object);
          object = parent(object, path);
          var func = object == null ? object : object[toKey(last(path))];
          return func == null ? undefined2 : apply(func, object, args);
        }
        function baseIsArguments(value) {
          return isObjectLike(value) && baseGetTag(value) == argsTag;
        }
        function baseIsArrayBuffer(value) {
          return isObjectLike(value) && baseGetTag(value) == arrayBufferTag;
        }
        function baseIsDate(value) {
          return isObjectLike(value) && baseGetTag(value) == dateTag;
        }
        function baseIsEqual(value, other, bitmask, customizer, stack) {
          if (value === other) {
            return true;
          }
          if (value == null || other == null || !isObjectLike(value) && !isObjectLike(other)) {
            return value !== value && other !== other;
          }
          return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
        }
        function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
          var objIsArr = isArray(object), othIsArr = isArray(other), objTag = objIsArr ? arrayTag : getTag(object), othTag = othIsArr ? arrayTag : getTag(other);
          objTag = objTag == argsTag ? objectTag : objTag;
          othTag = othTag == argsTag ? objectTag : othTag;
          var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
          if (isSameTag && isBuffer(object)) {
            if (!isBuffer(other)) {
              return false;
            }
            objIsArr = true;
            objIsObj = false;
          }
          if (isSameTag && !objIsObj) {
            stack || (stack = new Stack());
            return objIsArr || isTypedArray(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
          }
          if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
            var objIsWrapped = objIsObj && hasOwnProperty.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty.call(other, "__wrapped__");
            if (objIsWrapped || othIsWrapped) {
              var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
              stack || (stack = new Stack());
              return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
            }
          }
          if (!isSameTag) {
            return false;
          }
          stack || (stack = new Stack());
          return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
        }
        function baseIsMap(value) {
          return isObjectLike(value) && getTag(value) == mapTag;
        }
        function baseIsMatch(object, source, matchData, customizer) {
          var index = matchData.length, length = index, noCustomizer = !customizer;
          if (object == null) {
            return !length;
          }
          object = Object2(object);
          while (index--) {
            var data = matchData[index];
            if (noCustomizer && data[2] ? data[1] !== object[data[0]] : !(data[0] in object)) {
              return false;
            }
          }
          while (++index < length) {
            data = matchData[index];
            var key = data[0], objValue = object[key], srcValue = data[1];
            if (noCustomizer && data[2]) {
              if (objValue === undefined2 && !(key in object)) {
                return false;
              }
            } else {
              var stack = new Stack();
              if (customizer) {
                var result2 = customizer(objValue, srcValue, key, object, source, stack);
              }
              if (!(result2 === undefined2 ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack) : result2)) {
                return false;
              }
            }
          }
          return true;
        }
        function baseIsNative(value) {
          if (!isObject(value) || isMasked(value)) {
            return false;
          }
          var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
          return pattern.test(toSource(value));
        }
        function baseIsRegExp(value) {
          return isObjectLike(value) && baseGetTag(value) == regexpTag;
        }
        function baseIsSet(value) {
          return isObjectLike(value) && getTag(value) == setTag;
        }
        function baseIsTypedArray(value) {
          return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
        }
        function baseIteratee(value) {
          if (typeof value == "function") {
            return value;
          }
          if (value == null) {
            return identity;
          }
          if (typeof value == "object") {
            return isArray(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
          }
          return property(value);
        }
        function baseKeys(object) {
          if (!isPrototype(object)) {
            return nativeKeys(object);
          }
          var result2 = [];
          for (var key in Object2(object)) {
            if (hasOwnProperty.call(object, key) && key != "constructor") {
              result2.push(key);
            }
          }
          return result2;
        }
        function baseKeysIn(object) {
          if (!isObject(object)) {
            return nativeKeysIn(object);
          }
          var isProto = isPrototype(object), result2 = [];
          for (var key in object) {
            if (!(key == "constructor" && (isProto || !hasOwnProperty.call(object, key)))) {
              result2.push(key);
            }
          }
          return result2;
        }
        function baseLt(value, other) {
          return value < other;
        }
        function baseMap(collection, iteratee2) {
          var index = -1, result2 = isArrayLike(collection) ? Array2(collection.length) : [];
          baseEach(collection, function(value, key, collection2) {
            result2[++index] = iteratee2(value, key, collection2);
          });
          return result2;
        }
        function baseMatches(source) {
          var matchData = getMatchData(source);
          if (matchData.length == 1 && matchData[0][2]) {
            return matchesStrictComparable(matchData[0][0], matchData[0][1]);
          }
          return function(object) {
            return object === source || baseIsMatch(object, source, matchData);
          };
        }
        function baseMatchesProperty(path, srcValue) {
          if (isKey(path) && isStrictComparable(srcValue)) {
            return matchesStrictComparable(toKey(path), srcValue);
          }
          return function(object) {
            var objValue = get(object, path);
            return objValue === undefined2 && objValue === srcValue ? hasIn(object, path) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
          };
        }
        function baseMerge(object, source, srcIndex, customizer, stack) {
          if (object === source) {
            return;
          }
          baseFor(source, function(srcValue, key) {
            stack || (stack = new Stack());
            if (isObject(srcValue)) {
              baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
            } else {
              var newValue = customizer ? customizer(safeGet(object, key), srcValue, key + "", object, source, stack) : undefined2;
              if (newValue === undefined2) {
                newValue = srcValue;
              }
              assignMergeValue(object, key, newValue);
            }
          }, keysIn);
        }
        function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
          var objValue = safeGet(object, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
          if (stacked) {
            assignMergeValue(object, key, stacked);
            return;
          }
          var newValue = customizer ? customizer(objValue, srcValue, key + "", object, source, stack) : undefined2;
          var isCommon = newValue === undefined2;
          if (isCommon) {
            var isArr = isArray(srcValue), isBuff = !isArr && isBuffer(srcValue), isTyped = !isArr && !isBuff && isTypedArray(srcValue);
            newValue = srcValue;
            if (isArr || isBuff || isTyped) {
              if (isArray(objValue)) {
                newValue = objValue;
              } else if (isArrayLikeObject(objValue)) {
                newValue = copyArray(objValue);
              } else if (isBuff) {
                isCommon = false;
                newValue = cloneBuffer(srcValue, true);
              } else if (isTyped) {
                isCommon = false;
                newValue = cloneTypedArray(srcValue, true);
              } else {
                newValue = [];
              }
            } else if (isPlainObject(srcValue) || isArguments(srcValue)) {
              newValue = objValue;
              if (isArguments(objValue)) {
                newValue = toPlainObject(objValue);
              } else if (!isObject(objValue) || isFunction(objValue)) {
                newValue = initCloneObject(srcValue);
              }
            } else {
              isCommon = false;
            }
          }
          if (isCommon) {
            stack.set(srcValue, newValue);
            mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
            stack["delete"](srcValue);
          }
          assignMergeValue(object, key, newValue);
        }
        function baseNth(array, n) {
          var length = array.length;
          if (!length) {
            return;
          }
          n += n < 0 ? length : 0;
          return isIndex(n, length) ? array[n] : undefined2;
        }
        function baseOrderBy(collection, iteratees, orders) {
          if (iteratees.length) {
            iteratees = arrayMap(iteratees, function(iteratee2) {
              if (isArray(iteratee2)) {
                return function(value) {
                  return baseGet(value, iteratee2.length === 1 ? iteratee2[0] : iteratee2);
                };
              }
              return iteratee2;
            });
          } else {
            iteratees = [identity];
          }
          var index = -1;
          iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
          var result2 = baseMap(collection, function(value, key, collection2) {
            var criteria = arrayMap(iteratees, function(iteratee2) {
              return iteratee2(value);
            });
            return { "criteria": criteria, "index": ++index, "value": value };
          });
          return baseSortBy(result2, function(object, other) {
            return compareMultiple(object, other, orders);
          });
        }
        function basePick(object, paths) {
          return basePickBy(object, paths, function(value, path) {
            return hasIn(object, path);
          });
        }
        function basePickBy(object, paths, predicate) {
          var index = -1, length = paths.length, result2 = {};
          while (++index < length) {
            var path = paths[index], value = baseGet(object, path);
            if (predicate(value, path)) {
              baseSet(result2, castPath(path, object), value);
            }
          }
          return result2;
        }
        function basePropertyDeep(path) {
          return function(object) {
            return baseGet(object, path);
          };
        }
        function basePullAll(array, values2, iteratee2, comparator) {
          var indexOf2 = comparator ? baseIndexOfWith : baseIndexOf, index = -1, length = values2.length, seen = array;
          if (array === values2) {
            values2 = copyArray(values2);
          }
          if (iteratee2) {
            seen = arrayMap(array, baseUnary(iteratee2));
          }
          while (++index < length) {
            var fromIndex = 0, value = values2[index], computed = iteratee2 ? iteratee2(value) : value;
            while ((fromIndex = indexOf2(seen, computed, fromIndex, comparator)) > -1) {
              if (seen !== array) {
                splice.call(seen, fromIndex, 1);
              }
              splice.call(array, fromIndex, 1);
            }
          }
          return array;
        }
        function basePullAt(array, indexes) {
          var length = array ? indexes.length : 0, lastIndex = length - 1;
          while (length--) {
            var index = indexes[length];
            if (length == lastIndex || index !== previous) {
              var previous = index;
              if (isIndex(index)) {
                splice.call(array, index, 1);
              } else {
                baseUnset(array, index);
              }
            }
          }
          return array;
        }
        function baseRandom(lower, upper) {
          return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
        }
        function baseRange(start2, end, step, fromRight) {
          var index = -1, length = nativeMax(nativeCeil((end - start2) / (step || 1)), 0), result2 = Array2(length);
          while (length--) {
            result2[fromRight ? length : ++index] = start2;
            start2 += step;
          }
          return result2;
        }
        function baseRepeat(string, n) {
          var result2 = "";
          if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
            return result2;
          }
          do {
            if (n % 2) {
              result2 += string;
            }
            n = nativeFloor(n / 2);
            if (n) {
              string += string;
            }
          } while (n);
          return result2;
        }
        function baseRest(func, start2) {
          return setToString(overRest(func, start2, identity), func + "");
        }
        function baseSample(collection) {
          return arraySample(values(collection));
        }
        function baseSampleSize(collection, n) {
          var array = values(collection);
          return shuffleSelf(array, baseClamp(n, 0, array.length));
        }
        function baseSet(object, path, value, customizer) {
          if (!isObject(object)) {
            return object;
          }
          path = castPath(path, object);
          var index = -1, length = path.length, lastIndex = length - 1, nested = object;
          while (nested != null && ++index < length) {
            var key = toKey(path[index]), newValue = value;
            if (key === "__proto__" || key === "constructor" || key === "prototype") {
              return object;
            }
            if (index != lastIndex) {
              var objValue = nested[key];
              newValue = customizer ? customizer(objValue, key, nested) : undefined2;
              if (newValue === undefined2) {
                newValue = isObject(objValue) ? objValue : isIndex(path[index + 1]) ? [] : {};
              }
            }
            assignValue(nested, key, newValue);
            nested = nested[key];
          }
          return object;
        }
        var baseSetData = !metaMap ? identity : function(func, data) {
          metaMap.set(func, data);
          return func;
        };
        var baseSetToString = !defineProperty ? identity : function(func, string) {
          return defineProperty(func, "toString", {
            "configurable": true,
            "enumerable": false,
            "value": constant(string),
            "writable": true
          });
        };
        function baseShuffle(collection) {
          return shuffleSelf(values(collection));
        }
        function baseSlice(array, start2, end) {
          var index = -1, length = array.length;
          if (start2 < 0) {
            start2 = -start2 > length ? 0 : length + start2;
          }
          end = end > length ? length : end;
          if (end < 0) {
            end += length;
          }
          length = start2 > end ? 0 : end - start2 >>> 0;
          start2 >>>= 0;
          var result2 = Array2(length);
          while (++index < length) {
            result2[index] = array[index + start2];
          }
          return result2;
        }
        function baseSome(collection, predicate) {
          var result2;
          baseEach(collection, function(value, index, collection2) {
            result2 = predicate(value, index, collection2);
            return !result2;
          });
          return !!result2;
        }
        function baseSortedIndex(array, value, retHighest) {
          var low = 0, high = array == null ? low : array.length;
          if (typeof value == "number" && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
            while (low < high) {
              var mid = low + high >>> 1, computed = array[mid];
              if (computed !== null && !isSymbol(computed) && (retHighest ? computed <= value : computed < value)) {
                low = mid + 1;
              } else {
                high = mid;
              }
            }
            return high;
          }
          return baseSortedIndexBy(array, value, identity, retHighest);
        }
        function baseSortedIndexBy(array, value, iteratee2, retHighest) {
          var low = 0, high = array == null ? 0 : array.length;
          if (high === 0) {
            return 0;
          }
          value = iteratee2(value);
          var valIsNaN = value !== value, valIsNull = value === null, valIsSymbol = isSymbol(value), valIsUndefined = value === undefined2;
          while (low < high) {
            var mid = nativeFloor((low + high) / 2), computed = iteratee2(array[mid]), othIsDefined = computed !== undefined2, othIsNull = computed === null, othIsReflexive = computed === computed, othIsSymbol = isSymbol(computed);
            if (valIsNaN) {
              var setLow = retHighest || othIsReflexive;
            } else if (valIsUndefined) {
              setLow = othIsReflexive && (retHighest || othIsDefined);
            } else if (valIsNull) {
              setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
            } else if (valIsSymbol) {
              setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
            } else if (othIsNull || othIsSymbol) {
              setLow = false;
            } else {
              setLow = retHighest ? computed <= value : computed < value;
            }
            if (setLow) {
              low = mid + 1;
            } else {
              high = mid;
            }
          }
          return nativeMin(high, MAX_ARRAY_INDEX);
        }
        function baseSortedUniq(array, iteratee2) {
          var index = -1, length = array.length, resIndex = 0, result2 = [];
          while (++index < length) {
            var value = array[index], computed = iteratee2 ? iteratee2(value) : value;
            if (!index || !eq(computed, seen)) {
              var seen = computed;
              result2[resIndex++] = value === 0 ? 0 : value;
            }
          }
          return result2;
        }
        function baseToNumber(value) {
          if (typeof value == "number") {
            return value;
          }
          if (isSymbol(value)) {
            return NAN;
          }
          return +value;
        }
        function baseToString(value) {
          if (typeof value == "string") {
            return value;
          }
          if (isArray(value)) {
            return arrayMap(value, baseToString) + "";
          }
          if (isSymbol(value)) {
            return symbolToString ? symbolToString.call(value) : "";
          }
          var result2 = value + "";
          return result2 == "0" && 1 / value == -INFINITY ? "-0" : result2;
        }
        function baseUniq(array, iteratee2, comparator) {
          var index = -1, includes2 = arrayIncludes, length = array.length, isCommon = true, result2 = [], seen = result2;
          if (comparator) {
            isCommon = false;
            includes2 = arrayIncludesWith;
          } else if (length >= LARGE_ARRAY_SIZE) {
            var set2 = iteratee2 ? null : createSet(array);
            if (set2) {
              return setToArray(set2);
            }
            isCommon = false;
            includes2 = cacheHas;
            seen = new SetCache();
          } else {
            seen = iteratee2 ? [] : result2;
          }
          outer:
            while (++index < length) {
              var value = array[index], computed = iteratee2 ? iteratee2(value) : value;
              value = comparator || value !== 0 ? value : 0;
              if (isCommon && computed === computed) {
                var seenIndex = seen.length;
                while (seenIndex--) {
                  if (seen[seenIndex] === computed) {
                    continue outer;
                  }
                }
                if (iteratee2) {
                  seen.push(computed);
                }
                result2.push(value);
              } else if (!includes2(seen, computed, comparator)) {
                if (seen !== result2) {
                  seen.push(computed);
                }
                result2.push(value);
              }
            }
          return result2;
        }
        function baseUnset(object, path) {
          path = castPath(path, object);
          object = parent(object, path);
          return object == null || delete object[toKey(last(path))];
        }
        function baseUpdate(object, path, updater, customizer) {
          return baseSet(object, path, updater(baseGet(object, path)), customizer);
        }
        function baseWhile(array, predicate, isDrop, fromRight) {
          var length = array.length, index = fromRight ? length : -1;
          while ((fromRight ? index-- : ++index < length) && predicate(array[index], index, array)) {
          }
          return isDrop ? baseSlice(array, fromRight ? 0 : index, fromRight ? index + 1 : length) : baseSlice(array, fromRight ? index + 1 : 0, fromRight ? length : index);
        }
        function baseWrapperValue(value, actions) {
          var result2 = value;
          if (result2 instanceof LazyWrapper) {
            result2 = result2.value();
          }
          return arrayReduce(actions, function(result3, action) {
            return action.func.apply(action.thisArg, arrayPush([result3], action.args));
          }, result2);
        }
        function baseXor(arrays, iteratee2, comparator) {
          var length = arrays.length;
          if (length < 2) {
            return length ? baseUniq(arrays[0]) : [];
          }
          var index = -1, result2 = Array2(length);
          while (++index < length) {
            var array = arrays[index], othIndex = -1;
            while (++othIndex < length) {
              if (othIndex != index) {
                result2[index] = baseDifference(result2[index] || array, arrays[othIndex], iteratee2, comparator);
              }
            }
          }
          return baseUniq(baseFlatten(result2, 1), iteratee2, comparator);
        }
        function baseZipObject(props, values2, assignFunc) {
          var index = -1, length = props.length, valsLength = values2.length, result2 = {};
          while (++index < length) {
            var value = index < valsLength ? values2[index] : undefined2;
            assignFunc(result2, props[index], value);
          }
          return result2;
        }
        function castArrayLikeObject(value) {
          return isArrayLikeObject(value) ? value : [];
        }
        function castFunction(value) {
          return typeof value == "function" ? value : identity;
        }
        function castPath(value, object) {
          if (isArray(value)) {
            return value;
          }
          return isKey(value, object) ? [value] : stringToPath(toString(value));
        }
        var castRest = baseRest;
        function castSlice(array, start2, end) {
          var length = array.length;
          end = end === undefined2 ? length : end;
          return !start2 && end >= length ? array : baseSlice(array, start2, end);
        }
        var clearTimeout2 = ctxClearTimeout || function(id) {
          return root.clearTimeout(id);
        };
        function cloneBuffer(buffer, isDeep) {
          if (isDeep) {
            return buffer.slice();
          }
          var length = buffer.length, result2 = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
          buffer.copy(result2);
          return result2;
        }
        function cloneArrayBuffer(arrayBuffer) {
          var result2 = new arrayBuffer.constructor(arrayBuffer.byteLength);
          new Uint8Array2(result2).set(new Uint8Array2(arrayBuffer));
          return result2;
        }
        function cloneDataView(dataView, isDeep) {
          var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
          return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
        }
        function cloneRegExp(regexp) {
          var result2 = new regexp.constructor(regexp.source, reFlags.exec(regexp));
          result2.lastIndex = regexp.lastIndex;
          return result2;
        }
        function cloneSymbol(symbol) {
          return symbolValueOf ? Object2(symbolValueOf.call(symbol)) : {};
        }
        function cloneTypedArray(typedArray, isDeep) {
          var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
          return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
        }
        function compareAscending(value, other) {
          if (value !== other) {
            var valIsDefined = value !== undefined2, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = isSymbol(value);
            var othIsDefined = other !== undefined2, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol(other);
            if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
              return 1;
            }
            if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
              return -1;
            }
          }
          return 0;
        }
        function compareMultiple(object, other, orders) {
          var index = -1, objCriteria = object.criteria, othCriteria = other.criteria, length = objCriteria.length, ordersLength = orders.length;
          while (++index < length) {
            var result2 = compareAscending(objCriteria[index], othCriteria[index]);
            if (result2) {
              if (index >= ordersLength) {
                return result2;
              }
              var order = orders[index];
              return result2 * (order == "desc" ? -1 : 1);
            }
          }
          return object.index - other.index;
        }
        function composeArgs(args, partials, holders, isCurried) {
          var argsIndex = -1, argsLength = args.length, holdersLength = holders.length, leftIndex = -1, leftLength = partials.length, rangeLength = nativeMax(argsLength - holdersLength, 0), result2 = Array2(leftLength + rangeLength), isUncurried = !isCurried;
          while (++leftIndex < leftLength) {
            result2[leftIndex] = partials[leftIndex];
          }
          while (++argsIndex < holdersLength) {
            if (isUncurried || argsIndex < argsLength) {
              result2[holders[argsIndex]] = args[argsIndex];
            }
          }
          while (rangeLength--) {
            result2[leftIndex++] = args[argsIndex++];
          }
          return result2;
        }
        function composeArgsRight(args, partials, holders, isCurried) {
          var argsIndex = -1, argsLength = args.length, holdersIndex = -1, holdersLength = holders.length, rightIndex = -1, rightLength = partials.length, rangeLength = nativeMax(argsLength - holdersLength, 0), result2 = Array2(rangeLength + rightLength), isUncurried = !isCurried;
          while (++argsIndex < rangeLength) {
            result2[argsIndex] = args[argsIndex];
          }
          var offset = argsIndex;
          while (++rightIndex < rightLength) {
            result2[offset + rightIndex] = partials[rightIndex];
          }
          while (++holdersIndex < holdersLength) {
            if (isUncurried || argsIndex < argsLength) {
              result2[offset + holders[holdersIndex]] = args[argsIndex++];
            }
          }
          return result2;
        }
        function copyArray(source, array) {
          var index = -1, length = source.length;
          array || (array = Array2(length));
          while (++index < length) {
            array[index] = source[index];
          }
          return array;
        }
        function copyObject(source, props, object, customizer) {
          var isNew = !object;
          object || (object = {});
          var index = -1, length = props.length;
          while (++index < length) {
            var key = props[index];
            var newValue = customizer ? customizer(object[key], source[key], key, object, source) : undefined2;
            if (newValue === undefined2) {
              newValue = source[key];
            }
            if (isNew) {
              baseAssignValue(object, key, newValue);
            } else {
              assignValue(object, key, newValue);
            }
          }
          return object;
        }
        function copySymbols(source, object) {
          return copyObject(source, getSymbols(source), object);
        }
        function copySymbolsIn(source, object) {
          return copyObject(source, getSymbolsIn(source), object);
        }
        function createAggregator(setter, initializer) {
          return function(collection, iteratee2) {
            var func = isArray(collection) ? arrayAggregator : baseAggregator, accumulator = initializer ? initializer() : {};
            return func(collection, setter, getIteratee(iteratee2, 2), accumulator);
          };
        }
        function createAssigner(assigner) {
          return baseRest(function(object, sources) {
            var index = -1, length = sources.length, customizer = length > 1 ? sources[length - 1] : undefined2, guard = length > 2 ? sources[2] : undefined2;
            customizer = assigner.length > 3 && typeof customizer == "function" ? (length--, customizer) : undefined2;
            if (guard && isIterateeCall(sources[0], sources[1], guard)) {
              customizer = length < 3 ? undefined2 : customizer;
              length = 1;
            }
            object = Object2(object);
            while (++index < length) {
              var source = sources[index];
              if (source) {
                assigner(object, source, index, customizer);
              }
            }
            return object;
          });
        }
        function createBaseEach(eachFunc, fromRight) {
          return function(collection, iteratee2) {
            if (collection == null) {
              return collection;
            }
            if (!isArrayLike(collection)) {
              return eachFunc(collection, iteratee2);
            }
            var length = collection.length, index = fromRight ? length : -1, iterable = Object2(collection);
            while (fromRight ? index-- : ++index < length) {
              if (iteratee2(iterable[index], index, iterable) === false) {
                break;
              }
            }
            return collection;
          };
        }
        function createBaseFor(fromRight) {
          return function(object, iteratee2, keysFunc) {
            var index = -1, iterable = Object2(object), props = keysFunc(object), length = props.length;
            while (length--) {
              var key = props[fromRight ? length : ++index];
              if (iteratee2(iterable[key], key, iterable) === false) {
                break;
              }
            }
            return object;
          };
        }
        function createBind(func, bitmask, thisArg) {
          var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
          function wrapper() {
            var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
            return fn.apply(isBind ? thisArg : this, arguments);
          }
          return wrapper;
        }
        function createCaseFirst(methodName) {
          return function(string) {
            string = toString(string);
            var strSymbols = hasUnicode(string) ? stringToArray(string) : undefined2;
            var chr = strSymbols ? strSymbols[0] : string.charAt(0);
            var trailing = strSymbols ? castSlice(strSymbols, 1).join("") : string.slice(1);
            return chr[methodName]() + trailing;
          };
        }
        function createCompounder(callback) {
          return function(string) {
            return arrayReduce(words(deburr(string).replace(reApos, "")), callback, "");
          };
        }
        function createCtor(Ctor) {
          return function() {
            var args = arguments;
            switch (args.length) {
              case 0:
                return new Ctor();
              case 1:
                return new Ctor(args[0]);
              case 2:
                return new Ctor(args[0], args[1]);
              case 3:
                return new Ctor(args[0], args[1], args[2]);
              case 4:
                return new Ctor(args[0], args[1], args[2], args[3]);
              case 5:
                return new Ctor(args[0], args[1], args[2], args[3], args[4]);
              case 6:
                return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
              case 7:
                return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
            var thisBinding = baseCreate(Ctor.prototype), result2 = Ctor.apply(thisBinding, args);
            return isObject(result2) ? result2 : thisBinding;
          };
        }
        function createCurry(func, bitmask, arity) {
          var Ctor = createCtor(func);
          function wrapper() {
            var length = arguments.length, args = Array2(length), index = length, placeholder = getHolder(wrapper);
            while (index--) {
              args[index] = arguments[index];
            }
            var holders = length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder ? [] : replaceHolders(args, placeholder);
            length -= holders.length;
            if (length < arity) {
              return createRecurry(
                func,
                bitmask,
                createHybrid,
                wrapper.placeholder,
                undefined2,
                args,
                holders,
                undefined2,
                undefined2,
                arity - length
              );
            }
            var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
            return apply(fn, this, args);
          }
          return wrapper;
        }
        function createFind(findIndexFunc) {
          return function(collection, predicate, fromIndex) {
            var iterable = Object2(collection);
            if (!isArrayLike(collection)) {
              var iteratee2 = getIteratee(predicate, 3);
              collection = keys(collection);
              predicate = function(key) {
                return iteratee2(iterable[key], key, iterable);
              };
            }
            var index = findIndexFunc(collection, predicate, fromIndex);
            return index > -1 ? iterable[iteratee2 ? collection[index] : index] : undefined2;
          };
        }
        function createFlow(fromRight) {
          return flatRest(function(funcs) {
            var length = funcs.length, index = length, prereq = LodashWrapper.prototype.thru;
            if (fromRight) {
              funcs.reverse();
            }
            while (index--) {
              var func = funcs[index];
              if (typeof func != "function") {
                throw new TypeError2(FUNC_ERROR_TEXT);
              }
              if (prereq && !wrapper && getFuncName(func) == "wrapper") {
                var wrapper = new LodashWrapper([], true);
              }
            }
            index = wrapper ? index : length;
            while (++index < length) {
              func = funcs[index];
              var funcName = getFuncName(func), data = funcName == "wrapper" ? getData(func) : undefined2;
              if (data && isLaziable(data[0]) && data[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) && !data[4].length && data[9] == 1) {
                wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
              } else {
                wrapper = func.length == 1 && isLaziable(func) ? wrapper[funcName]() : wrapper.thru(func);
              }
            }
            return function() {
              var args = arguments, value = args[0];
              if (wrapper && args.length == 1 && isArray(value)) {
                return wrapper.plant(value).value();
              }
              var index2 = 0, result2 = length ? funcs[index2].apply(this, args) : value;
              while (++index2 < length) {
                result2 = funcs[index2].call(this, result2);
              }
              return result2;
            };
          });
        }
        function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary2, arity) {
          var isAry = bitmask & WRAP_ARY_FLAG, isBind = bitmask & WRAP_BIND_FLAG, isBindKey = bitmask & WRAP_BIND_KEY_FLAG, isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG), isFlip = bitmask & WRAP_FLIP_FLAG, Ctor = isBindKey ? undefined2 : createCtor(func);
          function wrapper() {
            var length = arguments.length, args = Array2(length), index = length;
            while (index--) {
              args[index] = arguments[index];
            }
            if (isCurried) {
              var placeholder = getHolder(wrapper), holdersCount = countHolders(args, placeholder);
            }
            if (partials) {
              args = composeArgs(args, partials, holders, isCurried);
            }
            if (partialsRight) {
              args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
            }
            length -= holdersCount;
            if (isCurried && length < arity) {
              var newHolders = replaceHolders(args, placeholder);
              return createRecurry(
                func,
                bitmask,
                createHybrid,
                wrapper.placeholder,
                thisArg,
                args,
                newHolders,
                argPos,
                ary2,
                arity - length
              );
            }
            var thisBinding = isBind ? thisArg : this, fn = isBindKey ? thisBinding[func] : func;
            length = args.length;
            if (argPos) {
              args = reorder(args, argPos);
            } else if (isFlip && length > 1) {
              args.reverse();
            }
            if (isAry && ary2 < length) {
              args.length = ary2;
            }
            if (this && this !== root && this instanceof wrapper) {
              fn = Ctor || createCtor(fn);
            }
            return fn.apply(thisBinding, args);
          }
          return wrapper;
        }
        function createInverter(setter, toIteratee) {
          return function(object, iteratee2) {
            return baseInverter(object, setter, toIteratee(iteratee2), {});
          };
        }
        function createMathOperation(operator, defaultValue) {
          return function(value, other) {
            var result2;
            if (value === undefined2 && other === undefined2) {
              return defaultValue;
            }
            if (value !== undefined2) {
              result2 = value;
            }
            if (other !== undefined2) {
              if (result2 === undefined2) {
                return other;
              }
              if (typeof value == "string" || typeof other == "string") {
                value = baseToString(value);
                other = baseToString(other);
              } else {
                value = baseToNumber(value);
                other = baseToNumber(other);
              }
              result2 = operator(value, other);
            }
            return result2;
          };
        }
        function createOver(arrayFunc) {
          return flatRest(function(iteratees) {
            iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
            return baseRest(function(args) {
              var thisArg = this;
              return arrayFunc(iteratees, function(iteratee2) {
                return apply(iteratee2, thisArg, args);
              });
            });
          });
        }
        function createPadding(length, chars) {
          chars = chars === undefined2 ? " " : baseToString(chars);
          var charsLength = chars.length;
          if (charsLength < 2) {
            return charsLength ? baseRepeat(chars, length) : chars;
          }
          var result2 = baseRepeat(chars, nativeCeil(length / stringSize(chars)));
          return hasUnicode(chars) ? castSlice(stringToArray(result2), 0, length).join("") : result2.slice(0, length);
        }
        function createPartial(func, bitmask, thisArg, partials) {
          var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
          function wrapper() {
            var argsIndex = -1, argsLength = arguments.length, leftIndex = -1, leftLength = partials.length, args = Array2(leftLength + argsLength), fn = this && this !== root && this instanceof wrapper ? Ctor : func;
            while (++leftIndex < leftLength) {
              args[leftIndex] = partials[leftIndex];
            }
            while (argsLength--) {
              args[leftIndex++] = arguments[++argsIndex];
            }
            return apply(fn, isBind ? thisArg : this, args);
          }
          return wrapper;
        }
        function createRange(fromRight) {
          return function(start2, end, step) {
            if (step && typeof step != "number" && isIterateeCall(start2, end, step)) {
              end = step = undefined2;
            }
            start2 = toFinite(start2);
            if (end === undefined2) {
              end = start2;
              start2 = 0;
            } else {
              end = toFinite(end);
            }
            step = step === undefined2 ? start2 < end ? 1 : -1 : toFinite(step);
            return baseRange(start2, end, step, fromRight);
          };
        }
        function createRelationalOperation(operator) {
          return function(value, other) {
            if (!(typeof value == "string" && typeof other == "string")) {
              value = toNumber(value);
              other = toNumber(other);
            }
            return operator(value, other);
          };
        }
        function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary2, arity) {
          var isCurry = bitmask & WRAP_CURRY_FLAG, newHolders = isCurry ? holders : undefined2, newHoldersRight = isCurry ? undefined2 : holders, newPartials = isCurry ? partials : undefined2, newPartialsRight = isCurry ? undefined2 : partials;
          bitmask |= isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG;
          bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);
          if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
            bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
          }
          var newData = [
            func,
            bitmask,
            thisArg,
            newPartials,
            newHolders,
            newPartialsRight,
            newHoldersRight,
            argPos,
            ary2,
            arity
          ];
          var result2 = wrapFunc.apply(undefined2, newData);
          if (isLaziable(func)) {
            setData(result2, newData);
          }
          result2.placeholder = placeholder;
          return setWrapToString(result2, func, bitmask);
        }
        function createRound(methodName) {
          var func = Math2[methodName];
          return function(number, precision) {
            number = toNumber(number);
            precision = precision == null ? 0 : nativeMin(toInteger(precision), 292);
            if (precision && nativeIsFinite(number)) {
              var pair = (toString(number) + "e").split("e"), value = func(pair[0] + "e" + (+pair[1] + precision));
              pair = (toString(value) + "e").split("e");
              return +(pair[0] + "e" + (+pair[1] - precision));
            }
            return func(number);
          };
        }
        var createSet = !(Set2 && 1 / setToArray(new Set2([, -0]))[1] == INFINITY) ? noop : function(values2) {
          return new Set2(values2);
        };
        function createToPairs(keysFunc) {
          return function(object) {
            var tag = getTag(object);
            if (tag == mapTag) {
              return mapToArray(object);
            }
            if (tag == setTag) {
              return setToPairs(object);
            }
            return baseToPairs(object, keysFunc(object));
          };
        }
        function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary2, arity) {
          var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
          if (!isBindKey && typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          var length = partials ? partials.length : 0;
          if (!length) {
            bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
            partials = holders = undefined2;
          }
          ary2 = ary2 === undefined2 ? ary2 : nativeMax(toInteger(ary2), 0);
          arity = arity === undefined2 ? arity : toInteger(arity);
          length -= holders ? holders.length : 0;
          if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
            var partialsRight = partials, holdersRight = holders;
            partials = holders = undefined2;
          }
          var data = isBindKey ? undefined2 : getData(func);
          var newData = [
            func,
            bitmask,
            thisArg,
            partials,
            holders,
            partialsRight,
            holdersRight,
            argPos,
            ary2,
            arity
          ];
          if (data) {
            mergeData(newData, data);
          }
          func = newData[0];
          bitmask = newData[1];
          thisArg = newData[2];
          partials = newData[3];
          holders = newData[4];
          arity = newData[9] = newData[9] === undefined2 ? isBindKey ? 0 : func.length : nativeMax(newData[9] - length, 0);
          if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
            bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
          }
          if (!bitmask || bitmask == WRAP_BIND_FLAG) {
            var result2 = createBind(func, bitmask, thisArg);
          } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
            result2 = createCurry(func, bitmask, arity);
          } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
            result2 = createPartial(func, bitmask, thisArg, partials);
          } else {
            result2 = createHybrid.apply(undefined2, newData);
          }
          var setter = data ? baseSetData : setData;
          return setWrapToString(setter(result2, newData), func, bitmask);
        }
        function customDefaultsAssignIn(objValue, srcValue, key, object) {
          if (objValue === undefined2 || eq(objValue, objectProto[key]) && !hasOwnProperty.call(object, key)) {
            return srcValue;
          }
          return objValue;
        }
        function customDefaultsMerge(objValue, srcValue, key, object, source, stack) {
          if (isObject(objValue) && isObject(srcValue)) {
            stack.set(srcValue, objValue);
            baseMerge(objValue, srcValue, undefined2, customDefaultsMerge, stack);
            stack["delete"](srcValue);
          }
          return objValue;
        }
        function customOmitClone(value) {
          return isPlainObject(value) ? undefined2 : value;
        }
        function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG, arrLength = array.length, othLength = other.length;
          if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
            return false;
          }
          var arrStacked = stack.get(array);
          var othStacked = stack.get(other);
          if (arrStacked && othStacked) {
            return arrStacked == other && othStacked == array;
          }
          var index = -1, result2 = true, seen = bitmask & COMPARE_UNORDERED_FLAG ? new SetCache() : undefined2;
          stack.set(array, other);
          stack.set(other, array);
          while (++index < arrLength) {
            var arrValue = array[index], othValue = other[index];
            if (customizer) {
              var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
            }
            if (compared !== undefined2) {
              if (compared) {
                continue;
              }
              result2 = false;
              break;
            }
            if (seen) {
              if (!arraySome(other, function(othValue2, othIndex) {
                if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
                  return seen.push(othIndex);
                }
              })) {
                result2 = false;
                break;
              }
            } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              result2 = false;
              break;
            }
          }
          stack["delete"](array);
          stack["delete"](other);
          return result2;
        }
        function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
          switch (tag) {
            case dataViewTag:
              if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
                return false;
              }
              object = object.buffer;
              other = other.buffer;
            case arrayBufferTag:
              if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array2(object), new Uint8Array2(other))) {
                return false;
              }
              return true;
            case boolTag:
            case dateTag:
            case numberTag:
              return eq(+object, +other);
            case errorTag:
              return object.name == other.name && object.message == other.message;
            case regexpTag:
            case stringTag:
              return object == other + "";
            case mapTag:
              var convert = mapToArray;
            case setTag:
              var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
              convert || (convert = setToArray);
              if (object.size != other.size && !isPartial) {
                return false;
              }
              var stacked = stack.get(object);
              if (stacked) {
                return stacked == other;
              }
              bitmask |= COMPARE_UNORDERED_FLAG;
              stack.set(object, other);
              var result2 = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
              stack["delete"](object);
              return result2;
            case symbolTag:
              if (symbolValueOf) {
                return symbolValueOf.call(object) == symbolValueOf.call(other);
              }
          }
          return false;
        }
        function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG, objProps = getAllKeys(object), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
          if (objLength != othLength && !isPartial) {
            return false;
          }
          var index = objLength;
          while (index--) {
            var key = objProps[index];
            if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
              return false;
            }
          }
          var objStacked = stack.get(object);
          var othStacked = stack.get(other);
          if (objStacked && othStacked) {
            return objStacked == other && othStacked == object;
          }
          var result2 = true;
          stack.set(object, other);
          stack.set(other, object);
          var skipCtor = isPartial;
          while (++index < objLength) {
            key = objProps[index];
            var objValue = object[key], othValue = other[key];
            if (customizer) {
              var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
            }
            if (!(compared === undefined2 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
              result2 = false;
              break;
            }
            skipCtor || (skipCtor = key == "constructor");
          }
          if (result2 && !skipCtor) {
            var objCtor = object.constructor, othCtor = other.constructor;
            if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
              result2 = false;
            }
          }
          stack["delete"](object);
          stack["delete"](other);
          return result2;
        }
        function flatRest(func) {
          return setToString(overRest(func, undefined2, flatten2), func + "");
        }
        function getAllKeys(object) {
          return baseGetAllKeys(object, keys, getSymbols);
        }
        function getAllKeysIn(object) {
          return baseGetAllKeys(object, keysIn, getSymbolsIn);
        }
        var getData = !metaMap ? noop : function(func) {
          return metaMap.get(func);
        };
        function getFuncName(func) {
          var result2 = func.name + "", array = realNames[result2], length = hasOwnProperty.call(realNames, result2) ? array.length : 0;
          while (length--) {
            var data = array[length], otherFunc = data.func;
            if (otherFunc == null || otherFunc == func) {
              return data.name;
            }
          }
          return result2;
        }
        function getHolder(func) {
          var object = hasOwnProperty.call(lodash, "placeholder") ? lodash : func;
          return object.placeholder;
        }
        function getIteratee() {
          var result2 = lodash.iteratee || iteratee;
          result2 = result2 === iteratee ? baseIteratee : result2;
          return arguments.length ? result2(arguments[0], arguments[1]) : result2;
        }
        function getMapData(map2, key) {
          var data = map2.__data__;
          return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
        }
        function getMatchData(object) {
          var result2 = keys(object), length = result2.length;
          while (length--) {
            var key = result2[length], value = object[key];
            result2[length] = [key, value, isStrictComparable(value)];
          }
          return result2;
        }
        function getNative(object, key) {
          var value = getValue(object, key);
          return baseIsNative(value) ? value : undefined2;
        }
        function getRawTag(value) {
          var isOwn = hasOwnProperty.call(value, symToStringTag), tag = value[symToStringTag];
          try {
            value[symToStringTag] = undefined2;
            var unmasked = true;
          } catch (e) {
          }
          var result2 = nativeObjectToString.call(value);
          if (unmasked) {
            if (isOwn) {
              value[symToStringTag] = tag;
            } else {
              delete value[symToStringTag];
            }
          }
          return result2;
        }
        var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
          if (object == null) {
            return [];
          }
          object = Object2(object);
          return arrayFilter(nativeGetSymbols(object), function(symbol) {
            return propertyIsEnumerable.call(object, symbol);
          });
        };
        var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
          var result2 = [];
          while (object) {
            arrayPush(result2, getSymbols(object));
            object = getPrototype(object);
          }
          return result2;
        };
        var getTag = baseGetTag;
        if (DataView2 && getTag(new DataView2(new ArrayBuffer(1))) != dataViewTag || Map2 && getTag(new Map2()) != mapTag || Promise2 && getTag(Promise2.resolve()) != promiseTag || Set2 && getTag(new Set2()) != setTag || WeakMap2 && getTag(new WeakMap2()) != weakMapTag) {
          getTag = function(value) {
            var result2 = baseGetTag(value), Ctor = result2 == objectTag ? value.constructor : undefined2, ctorString = Ctor ? toSource(Ctor) : "";
            if (ctorString) {
              switch (ctorString) {
                case dataViewCtorString:
                  return dataViewTag;
                case mapCtorString:
                  return mapTag;
                case promiseCtorString:
                  return promiseTag;
                case setCtorString:
                  return setTag;
                case weakMapCtorString:
                  return weakMapTag;
              }
            }
            return result2;
          };
        }
        function getView(start2, end, transforms) {
          var index = -1, length = transforms.length;
          while (++index < length) {
            var data = transforms[index], size2 = data.size;
            switch (data.type) {
              case "drop":
                start2 += size2;
                break;
              case "dropRight":
                end -= size2;
                break;
              case "take":
                end = nativeMin(end, start2 + size2);
                break;
              case "takeRight":
                start2 = nativeMax(start2, end - size2);
                break;
            }
          }
          return { "start": start2, "end": end };
        }
        function getWrapDetails(source) {
          var match = source.match(reWrapDetails);
          return match ? match[1].split(reSplitDetails) : [];
        }
        function hasPath(object, path, hasFunc) {
          path = castPath(path, object);
          var index = -1, length = path.length, result2 = false;
          while (++index < length) {
            var key = toKey(path[index]);
            if (!(result2 = object != null && hasFunc(object, key))) {
              break;
            }
            object = object[key];
          }
          if (result2 || ++index != length) {
            return result2;
          }
          length = object == null ? 0 : object.length;
          return !!length && isLength(length) && isIndex(key, length) && (isArray(object) || isArguments(object));
        }
        function initCloneArray(array) {
          var length = array.length, result2 = new array.constructor(length);
          if (length && typeof array[0] == "string" && hasOwnProperty.call(array, "index")) {
            result2.index = array.index;
            result2.input = array.input;
          }
          return result2;
        }
        function initCloneObject(object) {
          return typeof object.constructor == "function" && !isPrototype(object) ? baseCreate(getPrototype(object)) : {};
        }
        function initCloneByTag(object, tag, isDeep) {
          var Ctor = object.constructor;
          switch (tag) {
            case arrayBufferTag:
              return cloneArrayBuffer(object);
            case boolTag:
            case dateTag:
              return new Ctor(+object);
            case dataViewTag:
              return cloneDataView(object, isDeep);
            case float32Tag:
            case float64Tag:
            case int8Tag:
            case int16Tag:
            case int32Tag:
            case uint8Tag:
            case uint8ClampedTag:
            case uint16Tag:
            case uint32Tag:
              return cloneTypedArray(object, isDeep);
            case mapTag:
              return new Ctor();
            case numberTag:
            case stringTag:
              return new Ctor(object);
            case regexpTag:
              return cloneRegExp(object);
            case setTag:
              return new Ctor();
            case symbolTag:
              return cloneSymbol(object);
          }
        }
        function insertWrapDetails(source, details) {
          var length = details.length;
          if (!length) {
            return source;
          }
          var lastIndex = length - 1;
          details[lastIndex] = (length > 1 ? "& " : "") + details[lastIndex];
          details = details.join(length > 2 ? ", " : " ");
          return source.replace(reWrapComment, "{\n/* [wrapped with " + details + "] */\n");
        }
        function isFlattenable(value) {
          return isArray(value) || isArguments(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
        }
        function isIndex(value, length) {
          var type = typeof value;
          length = length == null ? MAX_SAFE_INTEGER : length;
          return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
        }
        function isIterateeCall(value, index, object) {
          if (!isObject(object)) {
            return false;
          }
          var type = typeof index;
          if (type == "number" ? isArrayLike(object) && isIndex(index, object.length) : type == "string" && index in object) {
            return eq(object[index], value);
          }
          return false;
        }
        function isKey(value, object) {
          if (isArray(value)) {
            return false;
          }
          var type = typeof value;
          if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol(value)) {
            return true;
          }
          return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object2(object);
        }
        function isKeyable(value) {
          var type = typeof value;
          return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
        }
        function isLaziable(func) {
          var funcName = getFuncName(func), other = lodash[funcName];
          if (typeof other != "function" || !(funcName in LazyWrapper.prototype)) {
            return false;
          }
          if (func === other) {
            return true;
          }
          var data = getData(other);
          return !!data && func === data[0];
        }
        function isMasked(func) {
          return !!maskSrcKey && maskSrcKey in func;
        }
        var isMaskable = coreJsData ? isFunction : stubFalse;
        function isPrototype(value) {
          var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto;
          return value === proto;
        }
        function isStrictComparable(value) {
          return value === value && !isObject(value);
        }
        function matchesStrictComparable(key, srcValue) {
          return function(object) {
            if (object == null) {
              return false;
            }
            return object[key] === srcValue && (srcValue !== undefined2 || key in Object2(object));
          };
        }
        function memoizeCapped(func) {
          var result2 = memoize4(func, function(key) {
            if (cache.size === MAX_MEMOIZE_SIZE) {
              cache.clear();
            }
            return key;
          });
          var cache = result2.cache;
          return result2;
        }
        function mergeData(data, source) {
          var bitmask = data[1], srcBitmask = source[1], newBitmask = bitmask | srcBitmask, isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);
          var isCombo = srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_CURRY_FLAG || srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_REARG_FLAG && data[7].length <= source[8] || srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG) && source[7].length <= source[8] && bitmask == WRAP_CURRY_FLAG;
          if (!(isCommon || isCombo)) {
            return data;
          }
          if (srcBitmask & WRAP_BIND_FLAG) {
            data[2] = source[2];
            newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
          }
          var value = source[3];
          if (value) {
            var partials = data[3];
            data[3] = partials ? composeArgs(partials, value, source[4]) : value;
            data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : source[4];
          }
          value = source[5];
          if (value) {
            partials = data[5];
            data[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
            data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : source[6];
          }
          value = source[7];
          if (value) {
            data[7] = value;
          }
          if (srcBitmask & WRAP_ARY_FLAG) {
            data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
          }
          if (data[9] == null) {
            data[9] = source[9];
          }
          data[0] = source[0];
          data[1] = newBitmask;
          return data;
        }
        function nativeKeysIn(object) {
          var result2 = [];
          if (object != null) {
            for (var key in Object2(object)) {
              result2.push(key);
            }
          }
          return result2;
        }
        function objectToString(value) {
          return nativeObjectToString.call(value);
        }
        function overRest(func, start2, transform2) {
          start2 = nativeMax(start2 === undefined2 ? func.length - 1 : start2, 0);
          return function() {
            var args = arguments, index = -1, length = nativeMax(args.length - start2, 0), array = Array2(length);
            while (++index < length) {
              array[index] = args[start2 + index];
            }
            index = -1;
            var otherArgs = Array2(start2 + 1);
            while (++index < start2) {
              otherArgs[index] = args[index];
            }
            otherArgs[start2] = transform2(array);
            return apply(func, this, otherArgs);
          };
        }
        function parent(object, path) {
          return path.length < 2 ? object : baseGet(object, baseSlice(path, 0, -1));
        }
        function reorder(array, indexes) {
          var arrLength = array.length, length = nativeMin(indexes.length, arrLength), oldArray = copyArray(array);
          while (length--) {
            var index = indexes[length];
            array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined2;
          }
          return array;
        }
        function safeGet(object, key) {
          if (key === "constructor" && typeof object[key] === "function") {
            return;
          }
          if (key == "__proto__") {
            return;
          }
          return object[key];
        }
        var setData = shortOut(baseSetData);
        var setTimeout2 = ctxSetTimeout || function(func, wait2) {
          return root.setTimeout(func, wait2);
        };
        var setToString = shortOut(baseSetToString);
        function setWrapToString(wrapper, reference, bitmask) {
          var source = reference + "";
          return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
        }
        function shortOut(func) {
          var count = 0, lastCalled = 0;
          return function() {
            var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
            lastCalled = stamp;
            if (remaining > 0) {
              if (++count >= HOT_COUNT) {
                return arguments[0];
              }
            } else {
              count = 0;
            }
            return func.apply(undefined2, arguments);
          };
        }
        function shuffleSelf(array, size2) {
          var index = -1, length = array.length, lastIndex = length - 1;
          size2 = size2 === undefined2 ? length : size2;
          while (++index < size2) {
            var rand = baseRandom(index, lastIndex), value = array[rand];
            array[rand] = array[index];
            array[index] = value;
          }
          array.length = size2;
          return array;
        }
        var stringToPath = memoizeCapped(function(string) {
          var result2 = [];
          if (string.charCodeAt(0) === 46) {
            result2.push("");
          }
          string.replace(rePropName, function(match, number, quote, subString) {
            result2.push(quote ? subString.replace(reEscapeChar, "$1") : number || match);
          });
          return result2;
        });
        function toKey(value) {
          if (typeof value == "string" || isSymbol(value)) {
            return value;
          }
          var result2 = value + "";
          return result2 == "0" && 1 / value == -INFINITY ? "-0" : result2;
        }
        function toSource(func) {
          if (func != null) {
            try {
              return funcToString.call(func);
            } catch (e) {
            }
            try {
              return func + "";
            } catch (e) {
            }
          }
          return "";
        }
        function updateWrapDetails(details, bitmask) {
          arrayEach(wrapFlags, function(pair) {
            var value = "_." + pair[0];
            if (bitmask & pair[1] && !arrayIncludes(details, value)) {
              details.push(value);
            }
          });
          return details.sort();
        }
        function wrapperClone(wrapper) {
          if (wrapper instanceof LazyWrapper) {
            return wrapper.clone();
          }
          var result2 = new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__);
          result2.__actions__ = copyArray(wrapper.__actions__);
          result2.__index__ = wrapper.__index__;
          result2.__values__ = wrapper.__values__;
          return result2;
        }
        function chunk(array, size2, guard) {
          if (guard ? isIterateeCall(array, size2, guard) : size2 === undefined2) {
            size2 = 1;
          } else {
            size2 = nativeMax(toInteger(size2), 0);
          }
          var length = array == null ? 0 : array.length;
          if (!length || size2 < 1) {
            return [];
          }
          var index = 0, resIndex = 0, result2 = Array2(nativeCeil(length / size2));
          while (index < length) {
            result2[resIndex++] = baseSlice(array, index, index += size2);
          }
          return result2;
        }
        function compact(array) {
          var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result2 = [];
          while (++index < length) {
            var value = array[index];
            if (value) {
              result2[resIndex++] = value;
            }
          }
          return result2;
        }
        function concat() {
          var length = arguments.length;
          if (!length) {
            return [];
          }
          var args = Array2(length - 1), array = arguments[0], index = length;
          while (index--) {
            args[index - 1] = arguments[index];
          }
          return arrayPush(isArray(array) ? copyArray(array) : [array], baseFlatten(args, 1));
        }
        var difference = baseRest(function(array, values2) {
          return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true)) : [];
        });
        var differenceBy = baseRest(function(array, values2) {
          var iteratee2 = last(values2);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined2;
          }
          return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2)) : [];
        });
        var differenceWith = baseRest(function(array, values2) {
          var comparator = last(values2);
          if (isArrayLikeObject(comparator)) {
            comparator = undefined2;
          }
          return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true), undefined2, comparator) : [];
        });
        function drop(array, n, guard) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          return baseSlice(array, n < 0 ? 0 : n, length);
        }
        function dropRight(array, n, guard) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          n = length - n;
          return baseSlice(array, 0, n < 0 ? 0 : n);
        }
        function dropRightWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3), true, true) : [];
        }
        function dropWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3), true) : [];
        }
        function fill(array, value, start2, end) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          if (start2 && typeof start2 != "number" && isIterateeCall(array, value, start2)) {
            start2 = 0;
            end = length;
          }
          return baseFill(array, value, start2, end);
        }
        function findIndex(array, predicate, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = fromIndex == null ? 0 : toInteger(fromIndex);
          if (index < 0) {
            index = nativeMax(length + index, 0);
          }
          return baseFindIndex(array, getIteratee(predicate, 3), index);
        }
        function findLastIndex(array, predicate, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = length - 1;
          if (fromIndex !== undefined2) {
            index = toInteger(fromIndex);
            index = fromIndex < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
          }
          return baseFindIndex(array, getIteratee(predicate, 3), index, true);
        }
        function flatten2(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseFlatten(array, 1) : [];
        }
        function flattenDeep(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseFlatten(array, INFINITY) : [];
        }
        function flattenDepth(array, depth) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          depth = depth === undefined2 ? 1 : toInteger(depth);
          return baseFlatten(array, depth);
        }
        function fromPairs(pairs) {
          var index = -1, length = pairs == null ? 0 : pairs.length, result2 = {};
          while (++index < length) {
            var pair = pairs[index];
            result2[pair[0]] = pair[1];
          }
          return result2;
        }
        function head(array) {
          return array && array.length ? array[0] : undefined2;
        }
        function indexOf(array, value, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = fromIndex == null ? 0 : toInteger(fromIndex);
          if (index < 0) {
            index = nativeMax(length + index, 0);
          }
          return baseIndexOf(array, value, index);
        }
        function initial(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseSlice(array, 0, -1) : [];
        }
        var intersection = baseRest(function(arrays) {
          var mapped = arrayMap(arrays, castArrayLikeObject);
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped) : [];
        });
        var intersectionBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays), mapped = arrayMap(arrays, castArrayLikeObject);
          if (iteratee2 === last(mapped)) {
            iteratee2 = undefined2;
          } else {
            mapped.pop();
          }
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped, getIteratee(iteratee2, 2)) : [];
        });
        var intersectionWith = baseRest(function(arrays) {
          var comparator = last(arrays), mapped = arrayMap(arrays, castArrayLikeObject);
          comparator = typeof comparator == "function" ? comparator : undefined2;
          if (comparator) {
            mapped.pop();
          }
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped, undefined2, comparator) : [];
        });
        function join2(array, separator) {
          return array == null ? "" : nativeJoin.call(array, separator);
        }
        function last(array) {
          var length = array == null ? 0 : array.length;
          return length ? array[length - 1] : undefined2;
        }
        function lastIndexOf(array, value, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = length;
          if (fromIndex !== undefined2) {
            index = toInteger(fromIndex);
            index = index < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
          }
          return value === value ? strictLastIndexOf(array, value, index) : baseFindIndex(array, baseIsNaN, index, true);
        }
        function nth(array, n) {
          return array && array.length ? baseNth(array, toInteger(n)) : undefined2;
        }
        var pull = baseRest(pullAll);
        function pullAll(array, values2) {
          return array && array.length && values2 && values2.length ? basePullAll(array, values2) : array;
        }
        function pullAllBy(array, values2, iteratee2) {
          return array && array.length && values2 && values2.length ? basePullAll(array, values2, getIteratee(iteratee2, 2)) : array;
        }
        function pullAllWith(array, values2, comparator) {
          return array && array.length && values2 && values2.length ? basePullAll(array, values2, undefined2, comparator) : array;
        }
        var pullAt = flatRest(function(array, indexes) {
          var length = array == null ? 0 : array.length, result2 = baseAt(array, indexes);
          basePullAt(array, arrayMap(indexes, function(index) {
            return isIndex(index, length) ? +index : index;
          }).sort(compareAscending));
          return result2;
        });
        function remove(array, predicate) {
          var result2 = [];
          if (!(array && array.length)) {
            return result2;
          }
          var index = -1, indexes = [], length = array.length;
          predicate = getIteratee(predicate, 3);
          while (++index < length) {
            var value = array[index];
            if (predicate(value, index, array)) {
              result2.push(value);
              indexes.push(index);
            }
          }
          basePullAt(array, indexes);
          return result2;
        }
        function reverse(array) {
          return array == null ? array : nativeReverse.call(array);
        }
        function slice(array, start2, end) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          if (end && typeof end != "number" && isIterateeCall(array, start2, end)) {
            start2 = 0;
            end = length;
          } else {
            start2 = start2 == null ? 0 : toInteger(start2);
            end = end === undefined2 ? length : toInteger(end);
          }
          return baseSlice(array, start2, end);
        }
        function sortedIndex(array, value) {
          return baseSortedIndex(array, value);
        }
        function sortedIndexBy(array, value, iteratee2) {
          return baseSortedIndexBy(array, value, getIteratee(iteratee2, 2));
        }
        function sortedIndexOf(array, value) {
          var length = array == null ? 0 : array.length;
          if (length) {
            var index = baseSortedIndex(array, value);
            if (index < length && eq(array[index], value)) {
              return index;
            }
          }
          return -1;
        }
        function sortedLastIndex(array, value) {
          return baseSortedIndex(array, value, true);
        }
        function sortedLastIndexBy(array, value, iteratee2) {
          return baseSortedIndexBy(array, value, getIteratee(iteratee2, 2), true);
        }
        function sortedLastIndexOf(array, value) {
          var length = array == null ? 0 : array.length;
          if (length) {
            var index = baseSortedIndex(array, value, true) - 1;
            if (eq(array[index], value)) {
              return index;
            }
          }
          return -1;
        }
        function sortedUniq(array) {
          return array && array.length ? baseSortedUniq(array) : [];
        }
        function sortedUniqBy(array, iteratee2) {
          return array && array.length ? baseSortedUniq(array, getIteratee(iteratee2, 2)) : [];
        }
        function tail(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseSlice(array, 1, length) : [];
        }
        function take(array, n, guard) {
          if (!(array && array.length)) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          return baseSlice(array, 0, n < 0 ? 0 : n);
        }
        function takeRight(array, n, guard) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          n = length - n;
          return baseSlice(array, n < 0 ? 0 : n, length);
        }
        function takeRightWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3), false, true) : [];
        }
        function takeWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3)) : [];
        }
        var union = baseRest(function(arrays) {
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
        });
        var unionBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined2;
          }
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2));
        });
        var unionWith = baseRest(function(arrays) {
          var comparator = last(arrays);
          comparator = typeof comparator == "function" ? comparator : undefined2;
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), undefined2, comparator);
        });
        function uniq3(array) {
          return array && array.length ? baseUniq(array) : [];
        }
        function uniqBy(array, iteratee2) {
          return array && array.length ? baseUniq(array, getIteratee(iteratee2, 2)) : [];
        }
        function uniqWith(array, comparator) {
          comparator = typeof comparator == "function" ? comparator : undefined2;
          return array && array.length ? baseUniq(array, undefined2, comparator) : [];
        }
        function unzip(array) {
          if (!(array && array.length)) {
            return [];
          }
          var length = 0;
          array = arrayFilter(array, function(group) {
            if (isArrayLikeObject(group)) {
              length = nativeMax(group.length, length);
              return true;
            }
          });
          return baseTimes(length, function(index) {
            return arrayMap(array, baseProperty(index));
          });
        }
        function unzipWith(array, iteratee2) {
          if (!(array && array.length)) {
            return [];
          }
          var result2 = unzip(array);
          if (iteratee2 == null) {
            return result2;
          }
          return arrayMap(result2, function(group) {
            return apply(iteratee2, undefined2, group);
          });
        }
        var without = baseRest(function(array, values2) {
          return isArrayLikeObject(array) ? baseDifference(array, values2) : [];
        });
        var xor = baseRest(function(arrays) {
          return baseXor(arrayFilter(arrays, isArrayLikeObject));
        });
        var xorBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined2;
          }
          return baseXor(arrayFilter(arrays, isArrayLikeObject), getIteratee(iteratee2, 2));
        });
        var xorWith = baseRest(function(arrays) {
          var comparator = last(arrays);
          comparator = typeof comparator == "function" ? comparator : undefined2;
          return baseXor(arrayFilter(arrays, isArrayLikeObject), undefined2, comparator);
        });
        var zip = baseRest(unzip);
        function zipObject(props, values2) {
          return baseZipObject(props || [], values2 || [], assignValue);
        }
        function zipObjectDeep(props, values2) {
          return baseZipObject(props || [], values2 || [], baseSet);
        }
        var zipWith = baseRest(function(arrays) {
          var length = arrays.length, iteratee2 = length > 1 ? arrays[length - 1] : undefined2;
          iteratee2 = typeof iteratee2 == "function" ? (arrays.pop(), iteratee2) : undefined2;
          return unzipWith(arrays, iteratee2);
        });
        function chain(value) {
          var result2 = lodash(value);
          result2.__chain__ = true;
          return result2;
        }
        function tap(value, interceptor) {
          interceptor(value);
          return value;
        }
        function thru(value, interceptor) {
          return interceptor(value);
        }
        var wrapperAt = flatRest(function(paths) {
          var length = paths.length, start2 = length ? paths[0] : 0, value = this.__wrapped__, interceptor = function(object) {
            return baseAt(object, paths);
          };
          if (length > 1 || this.__actions__.length || !(value instanceof LazyWrapper) || !isIndex(start2)) {
            return this.thru(interceptor);
          }
          value = value.slice(start2, +start2 + (length ? 1 : 0));
          value.__actions__.push({
            "func": thru,
            "args": [interceptor],
            "thisArg": undefined2
          });
          return new LodashWrapper(value, this.__chain__).thru(function(array) {
            if (length && !array.length) {
              array.push(undefined2);
            }
            return array;
          });
        });
        function wrapperChain() {
          return chain(this);
        }
        function wrapperCommit() {
          return new LodashWrapper(this.value(), this.__chain__);
        }
        function wrapperNext() {
          if (this.__values__ === undefined2) {
            this.__values__ = toArray(this.value());
          }
          var done = this.__index__ >= this.__values__.length, value = done ? undefined2 : this.__values__[this.__index__++];
          return { "done": done, "value": value };
        }
        function wrapperToIterator() {
          return this;
        }
        function wrapperPlant(value) {
          var result2, parent2 = this;
          while (parent2 instanceof baseLodash) {
            var clone2 = wrapperClone(parent2);
            clone2.__index__ = 0;
            clone2.__values__ = undefined2;
            if (result2) {
              previous.__wrapped__ = clone2;
            } else {
              result2 = clone2;
            }
            var previous = clone2;
            parent2 = parent2.__wrapped__;
          }
          previous.__wrapped__ = value;
          return result2;
        }
        function wrapperReverse() {
          var value = this.__wrapped__;
          if (value instanceof LazyWrapper) {
            var wrapped = value;
            if (this.__actions__.length) {
              wrapped = new LazyWrapper(this);
            }
            wrapped = wrapped.reverse();
            wrapped.__actions__.push({
              "func": thru,
              "args": [reverse],
              "thisArg": undefined2
            });
            return new LodashWrapper(wrapped, this.__chain__);
          }
          return this.thru(reverse);
        }
        function wrapperValue() {
          return baseWrapperValue(this.__wrapped__, this.__actions__);
        }
        var countBy = createAggregator(function(result2, value, key) {
          if (hasOwnProperty.call(result2, key)) {
            ++result2[key];
          } else {
            baseAssignValue(result2, key, 1);
          }
        });
        function every(collection, predicate, guard) {
          var func = isArray(collection) ? arrayEvery : baseEvery;
          if (guard && isIterateeCall(collection, predicate, guard)) {
            predicate = undefined2;
          }
          return func(collection, getIteratee(predicate, 3));
        }
        function filter2(collection, predicate) {
          var func = isArray(collection) ? arrayFilter : baseFilter;
          return func(collection, getIteratee(predicate, 3));
        }
        var find = createFind(findIndex);
        var findLast = createFind(findLastIndex);
        function flatMap(collection, iteratee2) {
          return baseFlatten(map(collection, iteratee2), 1);
        }
        function flatMapDeep(collection, iteratee2) {
          return baseFlatten(map(collection, iteratee2), INFINITY);
        }
        function flatMapDepth(collection, iteratee2, depth) {
          depth = depth === undefined2 ? 1 : toInteger(depth);
          return baseFlatten(map(collection, iteratee2), depth);
        }
        function forEach(collection, iteratee2) {
          var func = isArray(collection) ? arrayEach : baseEach;
          return func(collection, getIteratee(iteratee2, 3));
        }
        function forEachRight(collection, iteratee2) {
          var func = isArray(collection) ? arrayEachRight : baseEachRight;
          return func(collection, getIteratee(iteratee2, 3));
        }
        var groupBy = createAggregator(function(result2, value, key) {
          if (hasOwnProperty.call(result2, key)) {
            result2[key].push(value);
          } else {
            baseAssignValue(result2, key, [value]);
          }
        });
        function includes(collection, value, fromIndex, guard) {
          collection = isArrayLike(collection) ? collection : values(collection);
          fromIndex = fromIndex && !guard ? toInteger(fromIndex) : 0;
          var length = collection.length;
          if (fromIndex < 0) {
            fromIndex = nativeMax(length + fromIndex, 0);
          }
          return isString(collection) ? fromIndex <= length && collection.indexOf(value, fromIndex) > -1 : !!length && baseIndexOf(collection, value, fromIndex) > -1;
        }
        var invokeMap = baseRest(function(collection, path, args) {
          var index = -1, isFunc = typeof path == "function", result2 = isArrayLike(collection) ? Array2(collection.length) : [];
          baseEach(collection, function(value) {
            result2[++index] = isFunc ? apply(path, value, args) : baseInvoke(value, path, args);
          });
          return result2;
        });
        var keyBy = createAggregator(function(result2, value, key) {
          baseAssignValue(result2, key, value);
        });
        function map(collection, iteratee2) {
          var func = isArray(collection) ? arrayMap : baseMap;
          return func(collection, getIteratee(iteratee2, 3));
        }
        function orderBy(collection, iteratees, orders, guard) {
          if (collection == null) {
            return [];
          }
          if (!isArray(iteratees)) {
            iteratees = iteratees == null ? [] : [iteratees];
          }
          orders = guard ? undefined2 : orders;
          if (!isArray(orders)) {
            orders = orders == null ? [] : [orders];
          }
          return baseOrderBy(collection, iteratees, orders);
        }
        var partition = createAggregator(function(result2, value, key) {
          result2[key ? 0 : 1].push(value);
        }, function() {
          return [[], []];
        });
        function reduce(collection, iteratee2, accumulator) {
          var func = isArray(collection) ? arrayReduce : baseReduce, initAccum = arguments.length < 3;
          return func(collection, getIteratee(iteratee2, 4), accumulator, initAccum, baseEach);
        }
        function reduceRight(collection, iteratee2, accumulator) {
          var func = isArray(collection) ? arrayReduceRight : baseReduce, initAccum = arguments.length < 3;
          return func(collection, getIteratee(iteratee2, 4), accumulator, initAccum, baseEachRight);
        }
        function reject(collection, predicate) {
          var func = isArray(collection) ? arrayFilter : baseFilter;
          return func(collection, negate(getIteratee(predicate, 3)));
        }
        function sample(collection) {
          var func = isArray(collection) ? arraySample : baseSample;
          return func(collection);
        }
        function sampleSize(collection, n, guard) {
          if (guard ? isIterateeCall(collection, n, guard) : n === undefined2) {
            n = 1;
          } else {
            n = toInteger(n);
          }
          var func = isArray(collection) ? arraySampleSize : baseSampleSize;
          return func(collection, n);
        }
        function shuffle(collection) {
          var func = isArray(collection) ? arrayShuffle : baseShuffle;
          return func(collection);
        }
        function size(collection) {
          if (collection == null) {
            return 0;
          }
          if (isArrayLike(collection)) {
            return isString(collection) ? stringSize(collection) : collection.length;
          }
          var tag = getTag(collection);
          if (tag == mapTag || tag == setTag) {
            return collection.size;
          }
          return baseKeys(collection).length;
        }
        function some(collection, predicate, guard) {
          var func = isArray(collection) ? arraySome : baseSome;
          if (guard && isIterateeCall(collection, predicate, guard)) {
            predicate = undefined2;
          }
          return func(collection, getIteratee(predicate, 3));
        }
        var sortBy = baseRest(function(collection, iteratees) {
          if (collection == null) {
            return [];
          }
          var length = iteratees.length;
          if (length > 1 && isIterateeCall(collection, iteratees[0], iteratees[1])) {
            iteratees = [];
          } else if (length > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
            iteratees = [iteratees[0]];
          }
          return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
        });
        var now = ctxNow || function() {
          return root.Date.now();
        };
        function after(n, func) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          n = toInteger(n);
          return function() {
            if (--n < 1) {
              return func.apply(this, arguments);
            }
          };
        }
        function ary(func, n, guard) {
          n = guard ? undefined2 : n;
          n = func && n == null ? func.length : n;
          return createWrap(func, WRAP_ARY_FLAG, undefined2, undefined2, undefined2, undefined2, n);
        }
        function before(n, func) {
          var result2;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          n = toInteger(n);
          return function() {
            if (--n > 0) {
              result2 = func.apply(this, arguments);
            }
            if (n <= 1) {
              func = undefined2;
            }
            return result2;
          };
        }
        var bind = baseRest(function(func, thisArg, partials) {
          var bitmask = WRAP_BIND_FLAG;
          if (partials.length) {
            var holders = replaceHolders(partials, getHolder(bind));
            bitmask |= WRAP_PARTIAL_FLAG;
          }
          return createWrap(func, bitmask, thisArg, partial