/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsState;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.composite.IncludedBuildInternal;

public class ChildBuildRegisteringSettingsLoader
implements SettingsLoader {
    private final SettingsLoader delegate;
    private final BuildIncluder buildIncluder;

    public ChildBuildRegisteringSettingsLoader(SettingsLoader delegate, BuildIncluder buildIncluder) {
        this.delegate = delegate;
        this.buildIncluder = buildIncluder;
    }

    @Override
    public SettingsState findAndLoadSettings(GradleInternal gradle) {
        SettingsState state = this.delegate.findAndLoadSettings(gradle);
        gradle.setIncludedBuilds(this.getIncludedBuildInternals(state));
        return state;
    }

    private Set<IncludedBuildInternal> getIncludedBuildInternals(SettingsState state) {
        List<IncludedBuildSpec> includedBuilds = state.getSettings().getIncludedBuilds();
        if (includedBuilds.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IncludedBuildInternal> children = new LinkedHashSet<IncludedBuildInternal>(includedBuilds.size());
        for (IncludedBuildSpec includedBuildSpec : includedBuilds) {
            CompositeBuildParticipantBuildState includedBuild = this.buildIncluder.includeBuild(includedBuildSpec);
            children.add(includedBuild.getModel());
        }
        return children;
    }
}

