/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryDisabler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.resolve.ResolveExceptionAnalyzer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class ConnectionFailureRepositoryDisabler
implements RepositoryDisabler {
    private static final Logger LOGGER = Logging.getLogger(ConnectionFailureRepositoryDisabler.class);
    private final Map<String, Throwable> disabledRepositories = new ConcurrentHashMap<String, Throwable>();

    @Override
    public boolean isDisabled(String repositoryId) {
        return this.disabledRepositories.containsKey(repositoryId);
    }

    @Override
    public Optional<Throwable> getDisabledReason(String repositoryId) {
        return Optional.ofNullable(this.disabledRepositories.get(repositoryId));
    }

    @Override
    public boolean tryDisableRepository(String repositoryId, Throwable reason, boolean maxRetriesExceeded) {
        boolean disabled = this.isDisabled(repositoryId);
        if (disabled) {
            return true;
        }
        if (ResolveExceptionAnalyzer.isCriticalFailure(reason) || maxRetriesExceeded) {
            LOGGER.debug("Repository {} has been disabled for this build due to connectivity issues", (Object)repositoryId);
            this.disabledRepositories.put(repositoryId, reason);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public Set<String> getDisabledRepositories() {
        return this.disabledRepositories.keySet();
    }
}

