import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '@grafana/ui';
import 'react';
import '../../QueryEditor/types.js';
import 'lodash';
import '../../QueryEditor/EditorList.js';
import { EditorStack } from '../../QueryEditor/EditorStack.js';
import '../../QueryEditor/Space.js';
import 'react-use';
import '../../QueryEditor/QueryHeader.js';
import 'react-virtualized-auto-sizer';
import 'sql-formatter-plus';
import '../../SQLEditor/standardSql/language.js';
import 'uuid';
import '@grafana/runtime';
import '../../SQLEditor/utils/debugger.js';
import '../../SQLEditor/standardSql/macros.js';
import '../../QueryEditor/visual-query-builder/AwesomeQueryBuilder.js';
import '../../QueryEditor/visual-query-builder/WhereRow.js';
import '../../QueryEditor/visual-query-builder/EditorField.js';
import 'rxjs';
import 'rxjs/operators';

function OperationsEditorRow({ children }) {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: styles.root, children: /* @__PURE__ */ jsx(EditorStack, { gap: 1, children }) });
}
const getStyles = (theme) => {
  return {
    root: css({
      padding: theme.spacing(1, 1, 0, 1),
      backgroundColor: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.default
    })
  };
};

export { OperationsEditorRow };
//# sourceMappingURL=OperationsEditorRow.js.map
