/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.util.SB;
import jspecview.api.SourceReader;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;
import jspecview.source.JDXHeader;
import jspecview.source.JDXSource;
import jspecview.source.XMLParser;
import org.jmol.util.Logger;

abstract class XMLReader
implements SourceReader {
    protected JDXSource source;
    protected String filePath = "";
    protected XMLParser parser;
    protected String tagName = "START";
    protected String attrList = "";
    protected String title = "";
    protected String owner = "UNKNOWN";
    protected String origin = "UNKNOWN";
    protected String tmpEnd = "END";
    protected String molForm = "";
    protected String techname = "";
    protected int npoints = -1;
    protected int samplenum = -1;
    protected double[] yaxisData;
    protected double[] xaxisData;
    protected String xUnits = "";
    protected String yUnits = "ARBITRARY UNITS";
    protected String vendor = "na";
    protected String modelType = "MODEL UNKNOWN";
    protected String LongDate = "";
    protected String pathlength = "na";
    protected String identifier = "";
    protected String plLabel = "";
    protected String resolution = "na";
    protected String resLabel = "";
    protected String LocName = "";
    protected String LocContact = "";
    protected String casName = "";
    protected String sampleowner = "";
    protected String obNucleus = "";
    protected String strObFreq = "";
    protected boolean increasing = false;
    protected boolean continuous = false;
    protected int ivspoints;
    protected int evspoints;
    protected int sampleRefNum = 0;
    protected double deltaX = Double.MAX_VALUE;
    protected double xFactor = Double.MAX_VALUE;
    protected double yFactor = Double.MAX_VALUE;
    protected double firstX = Double.MAX_VALUE;
    protected double lastX = Double.MAX_VALUE;
    protected double firstY = Double.MAX_VALUE;
    protected double obFreq = Double.MAX_VALUE;
    protected double refPoint = Double.MAX_VALUE;
    protected String casRN = "";
    protected String sampleID;
    protected SB errorLog = new SB();
    static final String[] tagNames = new String[]{"audittrail", "experimentstepset", "sampleset", "xx result", "spectrum", "metadatalist", "conditionlist", "parameterlist", "sample", "spectrumdata", "peaklist", "author", "peaklist", "acquisitionnucleus", "effectiveexcitationfield", "spectrum1d", "spectrumAnnotationList", "chemicalcompound", "identifier", "npmrd_id", "structure", "atomlist", "atom", "bondlist", "bond", "atomassignmentlist", "multiplet", "atoms", "multiplicity", "peakList", "peak", "acquisition", "spectrumdataarray", "spectrumlist"};
    static final int AML_0 = 0;
    static final int AML_AUDITTRAIL = 0;
    static final int AML_EXPERIMENTSTEPSET = 1;
    static final int AML_SAMPLESET = 2;
    static final int AML_RESULT = 3;
    static final int AML_1 = 3;
    static final int CML_0 = 4;
    static final int CML_SPECTRUM = 4;
    static final int CML_METADATALIST = 5;
    static final int CML_CONDITIONLIST = 6;
    static final int CML_PARAMETERLIST = 7;
    static final int CML_SAMPLE = 8;
    static final int CML_SPECTRUMDATA = 9;
    static final int CML_PEAKLIST = 10;
    static final int CML_1 = 10;
    static final int AML_AUTHOR = 11;
    static final int CML_PEAKLIST2 = 12;
    static final int NMRML_0 = 13;
    static final int NMRML_acquisitionnucleus = 13;
    static final int NMRML_effectiveexcitationfield = 14;
    static final int NMRML_spectrum1d = 15;
    static final int NMRML_spectrumAnnotationList = 16;
    static final int NMRML_chemicalcompound = 17;
    static final int NMRML_identifier = 18;
    static final int NMRML_npmrd_id = 19;
    static final int NMRML_structure = 20;
    static final int NMRML_atomlist = 21;
    static final int NMRML_atom = 22;
    static final int NMRML_bondlist = 23;
    static final int NMRML_bond = 24;
    static final int NMRML_atomAssignmentList = 25;
    static final int NMRML_multiplet = 26;
    static final int NMRML_atoms = 27;
    static final int NMRML_multiplicity = 28;
    static final int NMRML_peakList = 29;
    static final int NMRML_peak = 30;
    static final int NMRML_acquisition = 31;
    static final int NMRML_spectrumdataarray = 32;
    static final int NMRML_spectrumlist = 33;
    static final int NMRML_1 = 33;

    protected abstract JDXSource getXML(BufferedReader var1);

    protected abstract boolean processTag(int var1) throws Exception;

    protected abstract void processEndTag(int var1) throws Exception;

    @Override
    public JDXSource getSource(String string, BufferedReader bufferedReader) {
        this.filePath = string;
        return this.getXML(bufferedReader);
    }

    protected void getSimpleXmlReader(BufferedReader bufferedReader) {
        this.parser = new XMLParser(bufferedReader);
    }

    protected void checkStart() throws Exception {
        if (this.parser.peek() == 1) {
            return;
        }
        String string = "Error: XML <xxx> not found at beginning of file; not an XML document?";
        this.errorLog.append(string);
        throw new IOException(string);
    }

    protected void populateVariables() {
        JDXHeader.DataLDRTable dataLDRTable = new JDXHeader.DataLDRTable();
        Spectrum spectrum = new Spectrum();
        spectrum.setTitle(this.title);
        spectrum.setJcampdx("5.01");
        spectrum.setDataClass("XYDATA");
        spectrum.setDataType(this.techname);
        spectrum.setContinuous(this.continuous);
        spectrum.setIncreasing(this.increasing);
        spectrum.setXFactor(this.xFactor);
        spectrum.setYFactor(this.yFactor);
        spectrum.setLongDate(this.LongDate);
        spectrum.setOrigin(this.origin);
        spectrum.setOwner(this.owner);
        if (this.obNucleus.length() > 0) {
            spectrum.setObservedNucleus(this.obNucleus);
            spectrum.setObservedFreq(this.obFreq);
        }
        spectrum.setNucleusAndFreq(this.obNucleus, true);
        dataLDRTable.addHeader("##PATHLENGTH", this.pathlength);
        dataLDRTable.addHeader("##RESOLUTION", this.resolution);
        if (!this.strObFreq.equals("")) {
            dataLDRTable.addHeader("##.OBSERVEFREQUENCY", this.strObFreq);
        }
        if (!this.obNucleus.equals("")) {
            dataLDRTable.addHeader("##.OBSERVENUCLEUS", this.obNucleus);
        }
        dataLDRTable.addHeader("##$MANUFACTURER", this.vendor);
        if (!this.casRN.equals("")) {
            dataLDRTable.addHeader("##CASREGISTRYNO", this.casRN);
        }
        if (!this.molForm.equals("")) {
            dataLDRTable.addHeader("##MOLFORM", this.molForm);
        }
        if (!this.modelType.equals("")) {
            dataLDRTable.addHeader("##SPECTROMETER/DATA SYSTEM", this.modelType);
        }
        spectrum.setHeaderTable(dataLDRTable.table);
        double d = 1.0;
        if (this.obFreq != Double.MAX_VALUE) {
            spectrum.setObservedFreq(this.obFreq);
            if (this.xUnits.toUpperCase().equals("HZ")) {
                this.xUnits = "PPM";
                spectrum.setHZtoPPM(true);
                d = this.obFreq;
            }
        }
        Coordinate[] coordinateArray = new Coordinate[this.npoints];
        int n = 0;
        while (n < this.npoints) {
            coordinateArray[n] = new Coordinate().set(this.xaxisData[n] / d, this.yaxisData[n]);
            ++n;
        }
        if (!this.increasing) {
            coordinateArray = Coordinate.reverse(coordinateArray);
        }
        spectrum.setXUnits(this.xUnits);
        spectrum.setYUnits(this.yUnits);
        spectrum.setXYCoords(coordinateArray);
        this.source.addJDXSpectrum(this.filePath, spectrum, false);
    }

    protected boolean checkPointCount() {
        if (this.continuous && this.npoints < 5) {
            System.err.println("Insufficient points to plot");
            this.errorLog.append("Insufficient points to plot \n");
            this.source.setErrorLog(this.errorLog.toString());
            return false;
        }
        return true;
    }

    protected void processErrors(String string) {
        this.parser = null;
        if (this.errorLog.length() > 0) {
            this.errorLog.append("these errors were found in " + string + " \n");
            this.errorLog.append("=====================\n");
        }
        this.source.setErrorLog(this.errorLog.toString());
    }

    protected void processXML(int n, int n2) throws Exception {
        block0: while (this.parser.hasNext()) {
            if (this.parser.nextEvent() != 1) continue;
            String string = this.parser.getTagName();
            boolean bl = this.parser.requiresEndTag();
            if (Logger.debugging) {
                Logger.info(this.tagName);
            }
            int n3 = n;
            while (n3 <= n2) {
                if (string.equals(tagNames[n3])) {
                    this.process(n3, bl);
                    continue block0;
                }
                ++n3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void process(int var1_1, boolean var2_2) {
        var3_3 = XMLReader.tagNames[var1_1];
        try {
            this.tagName = this.parser.getTagName();
            this.attrList = this.parser.getAttributeList();
            if (this.processTag(var1_1) && var2_2) ** GOTO lbl20
            return;
lbl-1000:
            // 1 sources

            {
                switch (this.parser.nextEvent()) {
                    default: {
                        break;
                    }
                    case 2: {
                        if (!this.parser.getEndTag().equals(var3_3)) continue block6;
                        this.processEndTag(var1_1);
                        return;
                    }
                    case 1: {
                        this.tagName = this.parser.getTagName();
                        if (this.tagName.startsWith("!--")) continue block6;
                        this.attrList = this.parser.getAttributeList();
                        if (this.processTag(var1_1)) continue block6;
                        return;
                    }
                }
lbl20:
                // 5 sources

                ** while (this.parser.hasNext())
            }
lbl21:
            // 1 sources

        }
        catch (Exception var4_4) {
            var5_5 = "error reading " + this.tagName + " section: " + var4_4 + "\n" + var4_4.getStackTrace();
            Logger.error(var5_5);
            this.errorLog.append(String.valueOf(var5_5) + "\n");
        }
    }
}

