/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jsampler.CC;
import org.jsampler.view.fantasia.A4n;
import org.jsampler.view.fantasia.MainFrame;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.ToolbarButton;
import org.jsampler.view.fantasia.basic.FantasiaPainter;
import org.jsampler.view.fantasia.basic.FantasiaSubPanel;

public class StandardBar
extends JPanel {
    private final JToolBar toolbar = new JToolBar();
    private final JPanel mainPane;
    private final ToolbarButton btnSamplerInfo;
    private final ToolbarButton btnLoadSession;
    private final ToolbarButton btnExportSession;
    private final ToolbarButton btnRefresh;
    private final ToolbarButton btnResetSampler;
    protected final ToggleButton btnMidiKeyboard;
    private final ToolbarButton btnLSConsole;
    private final ToolbarButton btnInstrumentsDb;
    private final ToolbarButton btnPreferences;
    private final JLabel lLogo;
    private final Boolean screenMenuEnabled;
    private Color midColor;

    public StandardBar() {
        this.btnSamplerInfo = new ToolbarButton(A4n.a4n.samplerInfo);
        this.btnLoadSession = new ToolbarButton(A4n.a4n.loadScript);
        this.btnExportSession = new ToolbarButton(A4n.a4n.exportSamplerConfig);
        this.btnRefresh = new ToolbarButton(A4n.a4n.refresh);
        this.btnResetSampler = new ToolbarButton(A4n.a4n.resetSampler);
        this.btnMidiKeyboard = new ToggleButton();
        this.btnLSConsole = new ToolbarButton(A4n.a4n.windowLSConsole);
        this.btnInstrumentsDb = new ToolbarButton(A4n.a4n.windowInstrumentsDb);
        this.btnPreferences = new ToolbarButton(A4n.a4n.editPreferences);
        this.lLogo = new JLabel(Res.gfxFantasiaLogo);
        this.midColor = new Color(0x797979);
        this.screenMenuEnabled = CC.getViewConfig().isUsingScreenMenuBar();
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        int n = this.screenMenuEnabled != false ? 56 : 51;
        Dimension dimension = new Dimension(60, n);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        dimension = new Dimension(Short.MAX_VALUE, 51);
        this.setMaximumSize(dimension);
        int n2 = this.screenMenuEnabled != false ? 5 : 0;
        this.setBorder(BorderFactory.createEmptyBorder(n2, 5, 2, 5));
        this.mainPane = new MainPane();
        this.mainPane.setOpaque(false);
        this.mainPane.setLayout(new BoxLayout(this.mainPane, 0));
        this.toolbar.setOpaque(false);
        this.toolbar.setFloatable(false);
        this.toolbar.add(this.btnSamplerInfo);
        this.toolbar.addSeparator();
        this.toolbar.add(this.btnLoadSession);
        this.toolbar.add(this.btnExportSession);
        this.toolbar.add(this.btnRefresh);
        this.toolbar.add(this.btnResetSampler);
        this.toolbar.addSeparator();
        this.btnMidiKeyboard.setIcon(Res.iconMidiKeyboard32);
        this.btnMidiKeyboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = StandardBar.this.btnMidiKeyboard.isSelected();
                MainFrame mainFrame = (MainFrame)CC.getMainFrame();
                if (mainFrame == null) {
                    return;
                }
                mainFrame.setMidiKeyboardVisible(bl);
            }
        });
        this.toolbar.add(this.btnMidiKeyboard);
        this.toolbar.add(this.btnLSConsole);
        this.toolbar.add(this.btnInstrumentsDb);
        this.toolbar.addSeparator();
        this.toolbar.add(this.btnPreferences);
        this.mainPane.add(this.toolbar);
        this.mainPane.add(Box.createGlue());
        this.mainPane.add(this.lLogo);
        this.mainPane.add(Box.createRigidArea(new Dimension(17, 0)));
        FantasiaSubPanel fantasiaSubPanel = new FantasiaSubPanel(true, false, false);
        fantasiaSubPanel.add(this.mainPane);
        this.add(fantasiaSubPanel);
    }

    public void showFantasiaLogo(boolean bl) {
        this.lLogo.setVisible(bl);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        double d = this.getSize().getHeight();
        double d2 = this.getSize().getWidth();
        FantasiaPainter.paintGradient(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0, FantasiaPainter.color5, this.midColor);
        boolean bl = this.screenMenuEnabled;
        FantasiaPainter.Border border = new FantasiaPainter.Border(bl, true, false, true);
        FantasiaPainter.paintBoldOuterBorder(graphics2D, 0.0, 0.0, d2 - 1.0, d + 2.0, border);
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    class MainPane
    extends JPanel {
        private final Color color1 = new Color(0x505050);
        private final Color color2 = new Color(0x3E3E3E);

        MainPane() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            Composite composite = graphics2D.getComposite();
            double d = this.getSize().getHeight();
            double d2 = this.getSize().getWidth();
            FantasiaPainter.paintGradient(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0, this.color1, this.color2);
            FantasiaPainter.paintOuterBorder(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0, true, 0.5f, 0.3f);
            graphics2D.setPaint(paint);
            graphics2D.setComposite(composite);
        }
    }

    class ToggleButton
    extends JToggleButton {
        ToggleButton() {
            this.setFocusable(false);
        }

        public ToggleButton(Action action) {
            super(action);
            this.setFocusable(false);
        }

        @Override
        public void setText(String string) {
        }
    }
}

