/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jsampler.Server;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerList {
    private final Vector<Server> servers = new Vector();
    private final Vector<ChangeListener> listeners = new Vector();
    private final ChangeListener l = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ServerList.this.fireChangeEvent();
        }
    };

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void addServer(Server server) {
        this.servers.add(server);
        server.addChangeListener(this.l);
        this.fireChangeEvent();
    }

    public int getServerCount() {
        return this.servers.size();
    }

    public Server getServer(int n) {
        return this.servers.get(n);
    }

    public void removeServer(int n) {
        Server server = this.servers.get(n);
        this.servers.removeElementAt(n);
        server.removeChangeListener(this.l);
        this.fireChangeEvent();
    }

    public boolean removeServer(Server server) {
        boolean bl = this.servers.remove(server);
        this.fireChangeEvent();
        return bl;
    }

    public int getServerIndex(Server server) {
        if (server == null) {
            return -1;
        }
        for (int i = 0; i < this.getServerCount(); ++i) {
            if (this.getServer(i) != server) continue;
            return i;
        }
        return -1;
    }

    public void moveServerOnTop(Server server) {
        if (server == null) {
            return;
        }
        int n = this.getServerIndex(server);
        if (n <= 0) {
            return;
        }
        this.removeServer(n);
        this.servers.insertElementAt(server, 0);
        this.fireChangeEvent();
    }

    public void moveServerUp(Server server) {
        if (server == null) {
            return;
        }
        int n = this.getServerIndex(server);
        if (n <= 0) {
            return;
        }
        this.removeServer(n);
        this.servers.insertElementAt(server, n - 1);
        this.fireChangeEvent();
    }

    public void moveServerDown(Server server) {
        if (server == null) {
            return;
        }
        int n = this.getServerIndex(server);
        if (n < 0 || n == this.getServerCount() - 1) {
            return;
        }
        this.removeServer(n);
        this.servers.insertElementAt(server, n + 1);
        this.fireChangeEvent();
    }

    public void moveServerAtBottom(Server server) {
        if (server == null) {
            return;
        }
        int n = this.getServerIndex(server);
        if (n < 0 || n == this.getServerCount() - 1) {
            return;
        }
        this.removeServer(n);
        this.servers.insertElementAt(server, this.getServerCount());
        this.fireChangeEvent();
    }

    protected void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void readObject(Node node) {
        if (node.getNodeType() != 1 || !node.getNodeName().equals("servers")) {
            throw new IllegalArgumentException("Not a server list node!");
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Server server = new Server();
            server.readObject(node);
            this.addServer(server);
        }
    }

    public void writeObject(Document document, Node node) {
        Element element = document.createElement("servers");
        node.appendChild(element);
        node = element;
        for (int i = 0; i < this.getServerCount(); ++i) {
            this.getServer(i).writeObject(document, node);
        }
    }
}

