/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.oauth2;

import jakarta.json.Json;
import jakarta.json.JsonObjectBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.IdentityCredentialCallback;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism._private.MechanismUtil;
import org.wildfly.security.mechanism.oauth2.OAuth2InitialClientMessage;

public class OAuth2Server {
    public static final String CONFIG_OPENID_CONFIGURATION_URL = "openid-configuration";
    private static final String KV_DELIMITER = "%x01";
    private final CallbackHandler callbackHandler;
    private final Map<String, ?> serverConfig;
    private ElytronMessages log;

    public OAuth2Server(CallbackHandler callbackHandler, Map<String, ?> serverConfig, ElytronMessages log) {
        this.callbackHandler = callbackHandler;
        this.serverConfig = serverConfig;
        this.log = log;
    }

    public OAuth2InitialClientMessage parseInitialClientMessage(byte[] fromBytes) throws AuthenticationMechanismException {
        byte[] messageBytes = (byte[])fromBytes.clone();
        ByteIterator byteIterator = ByteIterator.ofBytes((byte[])((byte[])fromBytes.clone()));
        try {
            String auth;
            int c;
            char cbindFlag = (char)byteIterator.next();
            if (cbindFlag != 'n') {
                throw this.log.mechChannelBindingNotSupported();
            }
            String authorizationID = null;
            if (byteIterator.next() == 44 && (c = byteIterator.next()) == 97) {
                if (byteIterator.next() != 61) {
                    throw this.log.mechInvalidClientMessage();
                }
                authorizationID = byteIterator.delimitedBy(new int[]{44}).asUtf8String().drainToString();
                if (byteIterator.next() != 44) {
                    throw ElytronMessages.log.mechInvalidClientMessage();
                }
            }
            if ((auth = this.getValue("auth", byteIterator.asUtf8String().drainToString())) == null) {
                throw this.log.mechInvalidClientMessage();
            }
            return new OAuth2InitialClientMessage(authorizationID, auth, messageBytes);
        }
        catch (NoSuchElementException ignored) {
            throw ElytronMessages.log.mechInvalidMessageReceived();
        }
    }

    private String getValue(String key, String keyValuesPart) {
        for (String current : keyValuesPart.split(KV_DELIMITER)) {
            String[] keyValue = current.split("=");
            if (!keyValue[0].equals(key)) continue;
            return keyValue[1];
        }
        return null;
    }

    public byte[] evaluateInitialResponse(OAuth2InitialClientMessage initialClientMessage) throws AuthenticationMechanismException {
        if (initialClientMessage.isBearerToken()) {
            String auth = initialClientMessage.getAuth();
            String token = auth.substring(auth.indexOf(" ") + 1);
            BearerTokenEvidence evidence = new BearerTokenEvidence(token);
            EvidenceVerifyCallback evidenceVerifyCallback = new EvidenceVerifyCallback((Evidence)evidence);
            try {
                MechanismUtil.handleCallbacks((ElytronMessages)this.log, (CallbackHandler)this.callbackHandler, (Callback[])new Callback[]{evidenceVerifyCallback});
            }
            catch (UnsupportedCallbackException e) {
                throw this.log.mechAuthorizationUnsupported((Throwable)e);
            }
            if (evidenceVerifyCallback.isVerified()) {
                AuthorizeCallback authorizeCallback = new AuthorizeCallback(null, null);
                try {
                    MechanismUtil.handleCallbacks((ElytronMessages)this.log, (CallbackHandler)this.callbackHandler, (Callback[])new Callback[]{authorizeCallback});
                }
                catch (UnsupportedCallbackException e) {
                    throw this.log.mechAuthorizationUnsupported((Throwable)e);
                }
                if (authorizeCallback.isAuthorized()) {
                    try {
                        this.callbackHandler.handle(new Callback[]{new IdentityCredentialCallback((Credential)new BearerTokenCredential(evidence.getToken()), true)});
                    }
                    catch (UnsupportedCallbackException e) {
                    }
                    catch (AuthenticationMechanismException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw this.log.mechServerSideAuthenticationFailed((Exception)e);
                    }
                    return new byte[0];
                }
            }
            return this.createErrorMessage();
        }
        throw this.log.mechInvalidClientMessage();
    }

    private byte[] createErrorMessage() {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("status", "invalid_token");
        Object asDiscoveryUrl = this.serverConfig.get(CONFIG_OPENID_CONFIGURATION_URL);
        if (asDiscoveryUrl != null) {
            objectBuilder.add(CONFIG_OPENID_CONFIGURATION_URL, asDiscoveryUrl.toString());
        }
        return ByteIterator.ofBytes((byte[])objectBuilder.build().toString().getBytes()).base64Encode().asUtf8().drain();
    }
}

