/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.NameCache;

public class JGroupsAddressCache {
    private static final ConcurrentMap<org.jgroups.Address, JGroupsAddress> addressCache = new ConcurrentHashMap<org.jgroups.Address, JGroupsAddress>();

    public static Address fromJGroupsAddress(org.jgroups.Address jgroupsAddress) {
        JGroupsAddress ispnAddress = (JGroupsAddress)addressCache.get(jgroupsAddress);
        if (ispnAddress != null) {
            return ispnAddress;
        }
        return addressCache.computeIfAbsent(jgroupsAddress, uuid -> {
            if (jgroupsAddress instanceof ExtendedUUID) {
                return new JGroupsTopologyAwareAddress((ExtendedUUID)jgroupsAddress);
            }
            return new JGroupsAddress(jgroupsAddress);
        });
    }

    static void pruneAddressCache() {
        addressCache.forEach((address, ignore) -> {
            if (NameCache.get((org.jgroups.Address)address) == null) {
                addressCache.remove(address);
            }
        });
    }
}

