/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilder;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderException;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.SdJwtCredentialBody;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;
import org.keycloak.protocol.oid4vc.model.CredentialSubject;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.util.JsonSerialization;

public class SdJwtCredentialBuilder
implements CredentialBuilder {
    public static final String ISSUER_CLAIM = "iss";
    public static final String VERIFIABLE_CREDENTIAL_TYPE_CLAIM = "vct";

    @Override
    public String getSupportedFormat() {
        return "dc+sd-jwt";
    }

    @Override
    public SdJwtCredentialBody buildCredentialBody(VerifiableCredential verifiableCredential, CredentialBuildConfig credentialBuildConfig) throws CredentialBuilderException {
        CredentialSubject credentialSubject = verifiableCredential.getCredentialSubject();
        Map<String, Object> claimSet = credentialSubject.getClaims();
        DisclosureSpec.Builder disclosureSpecBuilder = DisclosureSpec.builder();
        claimSet.entrySet().stream().filter(entry -> !credentialBuildConfig.getSdJwtVisibleClaims().contains(entry.getKey())).forEach(entry -> {
            if (entry instanceof List) {
                List listValue = (List)((Object)entry);
                IntStream.range(0, listValue.size()).forEach(i -> disclosureSpecBuilder.withUndisclosedArrayElt((String)entry.getKey(), Integer.valueOf(i), SdJwtUtils.randomSalt()));
            } else {
                disclosureSpecBuilder.withUndisclosedClaim((String)entry.getKey(), SdJwtUtils.randomSalt());
            }
        });
        claimSet.put(ISSUER_CLAIM, credentialBuildConfig.getCredentialIssuer());
        claimSet.put(VERIFIABLE_CREDENTIAL_TYPE_CLAIM, credentialBuildConfig.getCredentialType());
        if (!claimSet.containsKey("exp")) {
            Optional.ofNullable(verifiableCredential.getExpirationDate()).ifPresent(d -> claimSet.put("exp", d.getEpochSecond()));
        }
        if (credentialBuildConfig.getNumberOfDecoys() > 0) {
            IntStream.range(0, credentialBuildConfig.getNumberOfDecoys()).forEach(i -> disclosureSpecBuilder.withDecoyClaim(SdJwtUtils.randomSalt()));
        }
        ObjectNode claimsNode = (ObjectNode)JsonSerialization.mapper.convertValue(claimSet, ObjectNode.class);
        IssuerSignedJWT issuerSignedJWT = IssuerSignedJWT.builder().withClaims(claimsNode, disclosureSpecBuilder.build()).withHashAlg(credentialBuildConfig.getHashAlgorithm()).withJwsType(credentialBuildConfig.getTokenJwsType()).build();
        SdJwt.Builder sdJwtBuilder = SdJwt.builder();
        return new SdJwtCredentialBody(sdJwtBuilder, issuerSignedJWT);
    }
}

