
#ifndef KPIMTEXTEDIT_EXPORT_H
#define KPIMTEXTEDIT_EXPORT_H

#ifdef KPIMTEXTEDIT_STATIC_DEFINE
#  define KPIMTEXTEDIT_EXPORT
#  define KPIMTEXTEDIT_NO_EXPORT
#else
#  ifndef KPIMTEXTEDIT_EXPORT
#    ifdef KPim6TextEdit_EXPORTS
        /* We are building this library */
#      define KPIMTEXTEDIT_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KPIMTEXTEDIT_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KPIMTEXTEDIT_NO_EXPORT
#    define KPIMTEXTEDIT_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KPIMTEXTEDIT_DECL_DEPRECATED
#  define KPIMTEXTEDIT_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KPIMTEXTEDIT_DECL_DEPRECATED_EXPORT
#  define KPIMTEXTEDIT_DECL_DEPRECATED_EXPORT KPIMTEXTEDIT_EXPORT KPIMTEXTEDIT_DECL_DEPRECATED
#endif

#ifndef KPIMTEXTEDIT_DECL_DEPRECATED_NO_EXPORT
#  define KPIMTEXTEDIT_DECL_DEPRECATED_NO_EXPORT KPIMTEXTEDIT_NO_EXPORT KPIMTEXTEDIT_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KPIMTEXTEDIT_NO_DEPRECATED
#    define KPIMTEXTEDIT_NO_DEPRECATED
#  endif
#endif
#include <kpimtextedit_version.h>

#define KPIMTEXTEDIT_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KPIMTEXTEDIT_NO_DEPRECATED)
#  undef KPIMTEXTEDIT_DEPRECATED
#  define KPIMTEXTEDIT_DEPRECATED_EXPORT KPIMTEXTEDIT_EXPORT
#  define KPIMTEXTEDIT_DEPRECATED_NO_EXPORT KPIMTEXTEDIT_NO_EXPORT
#elif defined(KPIMTEXTEDIT_NO_DEPRECATED_WARNINGS)
#  define KPIMTEXTEDIT_DEPRECATED
#  define KPIMTEXTEDIT_DEPRECATED_EXPORT KPIMTEXTEDIT_EXPORT
#  define KPIMTEXTEDIT_DEPRECATED_NO_EXPORT KPIMTEXTEDIT_NO_EXPORT
#else
#  define KPIMTEXTEDIT_DEPRECATED KPIMTEXTEDIT_DECL_DEPRECATED
#  define KPIMTEXTEDIT_DEPRECATED_EXPORT KPIMTEXTEDIT_DECL_DEPRECATED_EXPORT
#  define KPIMTEXTEDIT_DEPRECATED_NO_EXPORT KPIMTEXTEDIT_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KPIMTEXTEDIT_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KPIMTEXTEDIT_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KPIMTEXTEDIT_NO_DEPRECATED
#  define KPIMTEXTEDIT_DISABLE_DEPRECATED_BEFORE_AND_AT KPIMTEXTEDIT_VERSION
#endif
#ifdef KPIMTEXTEDIT_NO_DEPRECATED_WARNINGS
#  define KPIMTEXTEDIT_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KPIMTEXTEDIT_DEPRECATED_WARNINGS_SINCE
#  ifdef KPIMTEXTEDIT_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KPIMTEXTEDIT_DEPRECATED_WARNINGS_SINCE KPIMTEXTEDIT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KPIMTEXTEDIT_DEPRECATED_WARNINGS_SINCE KPIMTEXTEDIT_VERSION
#  endif
#endif

#ifndef KPIMTEXTEDIT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KPIMTEXTEDIT_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KPIMTEXTEDIT_DEPRECATED
#  define KPIMTEXTEDIT_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KPIMTEXTEDIT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KPIMTEXTEDIT_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KPIMTEXTEDIT_EXPORT_H */
