/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.menu.DropTargetLayer;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;

class DragOperation {
    private MenuEditLayer menuEditLayer;
    private JComponent dragComponent;
    private boolean started = false;
    private JComponent targetComponent;
    private Op op = Op.PICK_AND_PLOP_FROM_PALETTE;
    private JMenuItem payloadComponent;
    private List<JMenuItem> payloadComponents;
    private PaletteItem currentItem;

    public boolean isPickAndPlop() {
        return this.op == Op.PICK_AND_PLOP_FROM_PALETTE;
    }

    public DragOperation(MenuEditLayer menuEditLayer) {
        this.menuEditLayer = menuEditLayer;
        this.started = false;
    }

    public JComponent getDragComponent() {
        return this.dragComponent;
    }

    void start(JMenuItem item, Point pt) {
        this.op = Op.INTER_MENU_DRAG;
        this.started = true;
        List<RADComponent> rads = this.menuEditLayer.getSelectedRADComponents();
        this.payloadComponents = new ArrayList<JMenuItem>();
        if (rads.size() > 1) {
            for (RADComponent rad : rads) {
                Object comp = this.menuEditLayer.formDesigner.getComponent(rad);
                if (comp instanceof JMenuItem) {
                    this.payloadComponents.add((JMenuItem)comp);
                    continue;
                }
                this.fastEnd();
                return;
            }
        } else {
            this.payloadComponents.add(item);
        }
        this.dragComponent = (JMenuItem)this.createDragFeedbackComponent(item, null);
        this.dragComponent.setSize(this.dragComponent.getPreferredSize());
        this.dragComponent.setLocation(pt);
        this.menuEditLayer.layers.add((Component)this.dragComponent, JLayeredPane.DRAG_LAYER);
        this.menuEditLayer.repaint();
        this.payloadComponent = item;
    }

    void setTargetVisible(boolean vis) {
        if (!vis) {
            this.menuEditLayer.layers.remove(this.dragComponent);
        } else {
            this.menuEditLayer.layers.add((Component)this.dragComponent, JLayeredPane.DRAG_LAYER);
        }
        this.menuEditLayer.repaint();
    }

    private JComponent createDragFeedbackComponent(JMenuItem item, Class type) {
        PaletteItem paletteItem = PaletteUtils.getSelectedItem();
        if (paletteItem != null) {
            Object comp;
            MetaComponentCreator creator = this.menuEditLayer.formDesigner.getFormModel().getComponentCreator();
            RADVisualComponent precreated = null;
            try {
                precreated = creator.precreateVisualComponent(paletteItem);
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            if (precreated != null && (comp = precreated.getBeanInstance()) instanceof JComponent) {
                JComponent jcomp = (JComponent)comp;
                if (comp instanceof JMenuItem) {
                    JMenuItem mcomp = (JMenuItem)comp;
                    mcomp.setBorder(MenuEditLayer.DRAG_MENU_BORDER);
                    mcomp.setIcon(new MenuEditLayer.WrapperIcon());
                    mcomp.setMargin(new Insets(1, 1, 1, 1));
                    mcomp.setBorderPainted(true);
                }
                if (comp instanceof JSeparator) {
                    jcomp.setPreferredSize(new Dimension(50, 10));
                    jcomp.setVisible(false);
                }
                return jcomp;
            }
        }
        JComponent dragComponent = null;
        dragComponent = new JMenuItem();
        if (item == null && type != null && JComponent.class.isAssignableFrom(type)) {
            try {
                dragComponent = (JComponent)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                System.out.println("exception: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (item instanceof JMenu) {
            dragComponent = new JMenu();
        }
        if (item instanceof JCheckBoxMenuItem) {
            dragComponent = new JCheckBoxMenuItem();
            ((JCheckBoxMenuItem)dragComponent).setSelected(true);
        }
        if (item instanceof JRadioButtonMenuItem) {
            dragComponent = new JRadioButtonMenuItem();
            ((JRadioButtonMenuItem)dragComponent).setSelected(true);
        }
        if (dragComponent instanceof JMenuItem) {
            JMenuItem dragItem = dragComponent;
            if (item != null) {
                dragItem.setText(item.getText());
                dragItem.setIcon(item.getIcon());
                if (!(item instanceof JMenu) && !DropTargetLayer.isMetal()) {
                    dragItem.setAccelerator(item.getAccelerator());
                }
            } else {
                dragItem.setText("a new menu item");
            }
            dragItem.setMargin(new Insets(1, 1, 1, 1));
            dragItem.setBorderPainted(true);
        }
        dragComponent.setBorder(MenuEditLayer.DRAG_MENU_BORDER);
        return dragComponent;
    }

    void start(PaletteItem item, Point pt) {
        if (this.dragComponent != null) {
            this.menuEditLayer.layers.remove(this.dragComponent);
            this.dragComponent = null;
        }
        if (!this.menuEditLayer.doesFormContainMenuBar()) {
            this.menuEditLayer.showMenubarWarning = true;
            FormEditor.getAssistantModel(this.menuEditLayer.formDesigner.getFormModel()).setContext("missingMenubar");
            this.menuEditLayer.repaint();
        }
        this.op = Op.PICK_AND_PLOP_FROM_PALETTE;
        this.started = true;
        this.dragComponent = this.createDragFeedbackComponent(null, item.getComponentClass());
        this.dragComponent.setSize(this.dragComponent.getPreferredSize());
        this.dragComponent.setLocation(pt);
        this.menuEditLayer.layers.add((Component)this.dragComponent, JLayeredPane.DRAG_LAYER);
        this.menuEditLayer.repaint();
        this.currentItem = item;
        this.menuEditLayer.glassLayer.requestFocusInWindow();
    }

    void move(Point pt) {
        if (this.dragComponent != null) {
            this.dragComponent.setLocation(pt);
            RADComponent rad = this.menuEditLayer.formDesigner.getHandleLayer().getMetaComponentAt(pt, 0);
            if (rad != null && JMenuBar.class.isAssignableFrom(rad.getBeanClass()) && JMenu.class.isAssignableFrom(this.dragComponent.getClass())) {
                this.menuEditLayer.dropTargetLayer.setDropTarget(rad, pt);
                this.targetComponent = (JComponent)this.menuEditLayer.formDesigner.getComponent(rad);
            }
            if (rad != null && JMenu.class.isAssignableFrom(rad.getBeanClass())) {
                this.targetComponent = (JComponent)this.menuEditLayer.formDesigner.getComponent(rad);
                this.menuEditLayer.openMenu(rad, this.targetComponent);
                if (JMenu.class.isAssignableFrom(this.dragComponent.getClass())) {
                    this.menuEditLayer.dropTargetLayer.setDropTarget(rad, pt);
                } else {
                    this.menuEditLayer.dropTargetLayer.setDropTarget(rad, pt, DropTargetLayer.DropTargetType.INTO_SUBMENU);
                }
                return;
            }
            JComponent child = this.getDeepestComponentInPopups(pt);
            if (child instanceof JMenuItem && child != this.dragComponent) {
                this.targetComponent = child;
                if (this.targetComponent != null) {
                    this.menuEditLayer.dropTargetLayer.setDropTarget(this.targetComponent, pt, DropTargetLayer.DropTargetType.INTER_MENU);
                }
                this.menuEditLayer.repaint();
            }
            if (child instanceof JMenu) {
                Point pt2 = SwingUtilities.convertPoint(this.menuEditLayer.glassLayer, pt, child);
                JMenu menu = (JMenu)child;
                Point point = pt2;
                menu.setBorderPainted(true);
                if (DropTargetLayer.isSubMenuRightEdge(point, menu)) {
                    this.menuEditLayer.dropTargetLayer.setDropTarget(menu, point, DropTargetLayer.DropTargetType.INTO_SUBMENU);
                    menu.repaint();
                } else {
                    this.menuEditLayer.dropTargetLayer.setDropTarget(menu, pt, DropTargetLayer.DropTargetType.INTER_MENU);
                }
                this.menuEditLayer.showMenuPopup(menu);
            }
            if (child == null) {
                this.menuEditLayer.dropTargetLayer.clearDropTarget();
            }
        }
    }

    void end(EventObject e) {
        this.end(e, true);
    }

    void end(EventObject e, boolean clear) {
        Point pt = e instanceof MouseEvent ? ((MouseEvent)e).getPoint() : ((DropTargetDropEvent)e).getLocation();
        this.started = false;
        this.currentItem = null;
        if (this.dragComponent == null) {
            return;
        }
        if (e instanceof DropTargetDropEvent || e instanceof MouseEvent && !((MouseEvent)e).isShiftDown()) {
            this.menuEditLayer.layers.remove(this.dragComponent);
            this.menuEditLayer.dropTargetLayer.clearDropTarget();
        }
        switch (this.op.ordinal()) {
            case 0: {
                this.completePickAndPlopFromPalette(pt, clear);
                break;
            }
            case 1: {
                this.completeInterMenuDrag(pt);
                break;
            }
        }
        this.menuEditLayer.glassLayer.requestFocusInWindow();
        if (e instanceof DropTargetDropEvent || e instanceof MouseEvent && !((MouseEvent)e).isShiftDown()) {
            this.payloadComponent = null;
            this.targetComponent = null;
        }
        this.menuEditLayer.repaint();
    }

    void fastEnd() {
        this.started = false;
        if (this.dragComponent != null) {
            this.menuEditLayer.layers.remove(this.dragComponent);
            this.menuEditLayer.repaint();
        }
        this.menuEditLayer.dropTargetLayer.clearDropTarget();
        this.menuEditLayer.formDesigner.toggleSelectionMode();
    }

    JComponent getDeepestComponent(Point pt) {
        if (pt == null) {
            return null;
        }
        RADComponent rad = this.menuEditLayer.formDesigner.getHandleLayer().getMetaComponentAt(pt, 0);
        if (rad != null && (JMenu.class.isAssignableFrom(rad.getBeanClass()) || JMenuBar.class.isAssignableFrom(rad.getBeanClass()))) {
            return (JComponent)this.menuEditLayer.formDesigner.getComponent(rad);
        }
        return this.getDeepestComponentInPopups(pt);
    }

    public JComponent getTargetComponent() {
        return this.targetComponent;
    }

    private void completeInterMenuDrag(Point pt) {
        if (this.targetComponent == null) {
            return;
        }
        JComponent tcomp = this.getDeepestComponent(pt);
        if (this.targetComponent != tcomp) {
            this.menuEditLayer.formDesigner.toggleSelectionMode();
            return;
        }
        Point pt2 = SwingUtilities.convertPoint(this.menuEditLayer.glassLayer, pt, tcomp);
        if (tcomp instanceof JMenu) {
            JMenu menu = (JMenu)tcomp;
            if (menu.getParent() instanceof JMenuBar && this.isOnlyJMenus(this.payloadComponents)) {
                if (DropTargetLayer.isMenuLeftEdge(pt2, menu)) {
                    this.menuEditLayer.moveRadComponentToBefore(this.payloadComponent, menu);
                    return;
                }
                if (DropTargetLayer.isMenuRightEdge(pt2, menu)) {
                    this.menuEditLayer.moveRadComponentToAfter(this.payloadComponent, menu);
                    return;
                }
                this.menuEditLayer.moveRadComponentInto(this.payloadComponent, menu);
                return;
            }
            if (DropTargetLayer.isSubMenuRightEdge(pt2, menu)) {
                this.menuEditLayer.moveRadComponentInto(this.payloadComponent, menu);
            } else if (DropTargetLayer.isBelowItem(pt2, menu)) {
                this.menuEditLayer.moveRadComponentToAfter(this.payloadComponent, this.targetComponent);
            } else {
                this.menuEditLayer.moveRadComponentToBefore(this.payloadComponent, this.targetComponent);
            }
            return;
        }
        if (tcomp instanceof JMenuBar) {
            if (this.payloadComponent instanceof JMenu) {
                this.menuEditLayer.moveRadComponentInto(this.payloadComponent, this.targetComponent);
                return;
            }
            return;
        }
        if (DropTargetLayer.isBelowItem(pt2, tcomp)) {
            this.menuEditLayer.moveRadComponentToAfter(this.payloadComponent, this.targetComponent);
        } else {
            this.menuEditLayer.moveRadComponentToBefore(this.payloadComponent, this.targetComponent);
        }
    }

    private void completePickAndPlopFromPalette(Point pt, boolean clear) {
        PaletteItem paletteItem = PaletteUtils.getSelectedItem();
        if (paletteItem == null) {
            return;
        }
        JComponent newComponent = null;
        MetaComponentCreator creator = this.menuEditLayer.formDesigner.getFormModel().getComponentCreator();
        if (creator != null) {
            RADVisualComponent precreated = null;
            try {
                precreated = creator.precreateVisualComponent(paletteItem);
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            if (precreated != null) {
                newComponent = (JComponent)precreated.getBeanInstance();
            }
        }
        if (newComponent == null) {
            try {
                newComponent = (JComponent)paletteItem.getComponentClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        creator.getPrecreatedLayoutComponent();
        Point pt2 = SwingUtilities.convertPoint(this.menuEditLayer.glassLayer, pt, this.targetComponent);
        JComponent tcomp = this.getDeepestComponent(pt);
        if (this.targetComponent != tcomp) {
            creator.addPrecreatedComponent(null, null);
            if (clear) {
                this.menuEditLayer.formDesigner.toggleSelectionMode();
            }
            return;
        }
        if (this.targetComponent == null) {
            creator.addPrecreatedComponent(null, null);
            this.menuEditLayer.formDesigner.toggleSelectionMode();
            return;
        }
        if (this.targetComponent instanceof JMenu) {
            if (this.targetComponent.getParent() instanceof JMenuBar) {
                if (DropTargetLayer.isMenuLeftEdge(pt2, this.targetComponent) && this.isMenuPayload(creator)) {
                    this.menuEditLayer.addRadComponentToBefore(this.targetComponent, creator);
                } else if (DropTargetLayer.isMenuRightEdge(pt2, this.targetComponent) && this.isMenuPayload(creator)) {
                    this.menuEditLayer.addRadComponentToAfter(this.targetComponent, creator);
                } else {
                    this.menuEditLayer.addRadComponentToEnd(this.targetComponent, creator);
                }
            } else if (DropTargetLayer.isSubMenuRightEdge(pt2, this.targetComponent)) {
                this.menuEditLayer.addRadComponentToEnd(this.targetComponent, creator);
            } else if (DropTargetLayer.isBelowItem(pt2, this.targetComponent)) {
                this.menuEditLayer.addRadComponentToAfter(this.targetComponent, creator);
            } else {
                this.menuEditLayer.addRadComponentToBefore(this.targetComponent, creator);
            }
        } else if (this.targetComponent instanceof JMenuBar) {
            this.menuEditLayer.addRadComponentToEnd(this.targetComponent, creator);
        } else if (DropTargetLayer.isBelowItem(pt2, this.targetComponent)) {
            this.menuEditLayer.addRadComponentToAfter(this.targetComponent, creator);
        } else {
            this.menuEditLayer.addRadComponentToBefore(this.targetComponent, creator);
        }
        if (clear) {
            this.menuEditLayer.formDesigner.toggleSelectionMode();
        }
    }

    private boolean isOnlyJMenus(List<JMenuItem> items) {
        for (JMenuItem item : items) {
            if (item instanceof JMenu) continue;
            return false;
        }
        return true;
    }

    private boolean isMenuPayload(MetaComponentCreator creator) {
        return JMenu.class.isAssignableFrom(creator.getPrecreatedMetaComponent().getBeanClass());
    }

    public JComponent getDeepestComponentInPopups(Point pt) {
        Component[] popups;
        for (Component popup : popups = this.menuEditLayer.layers.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER)) {
            if (!popup.isVisible()) continue;
            Point pt2 = SwingUtilities.convertPoint(this.menuEditLayer, pt, popup);
            JComponent child = (JComponent)SwingUtilities.getDeepestComponentAt(popup, pt2.x, pt2.y);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public PaletteItem getCurrentItem() {
        return this.currentItem;
    }

    private static enum Op {
        PICK_AND_PLOP_FROM_PALETTE,
        INTER_MENU_DRAG,
        NO_MENUBAR;

    }
}

