/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.netbeans.Archive;
import org.netbeans.ArchiveResources;
import org.netbeans.Module;
import org.netbeans.NbInstrumentation;
import org.netbeans.PackageAttrsCache;
import org.netbeans.PatchByteCode;
import org.netbeans.ProxyClassLoader;
import org.netbeans.ProxyURLStreamHandlerFactory;
import org.netbeans.Stamps;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;

public class JarClassLoader
extends ProxyClassLoader {
    private static Stamps cache;
    private static final String META_INF = "META-INF/";
    private static final Attributes.Name MULTI_RELEASE;
    private static final int BASE_VERSION = 8;
    private static final int RUNTIME_VERSION;
    static Archive archive;
    private static final Logger LOGGER;
    private Source[] sources;
    private Module module;
    private PatchByteCode patchingBytecode;

    static void initializeCache() {
        cache = Stamps.getModulesJARs();
        archive = new Archive(cache);
        PackageAttrsCache.initialize();
    }

    public static void saveArchive() {
        if (cache != null) {
            try {
                archive.save(cache);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "saving archive", ioe);
            }
        } else {
            archive.stopGathering();
            archive.stopServing();
        }
    }

    public static boolean isArchivePopulated() {
        return archive != null && archive.isPopulated();
    }

    public JarClassLoader(List<File> files, ClassLoader[] parents) {
        this(files, parents, true, null);
    }

    public JarClassLoader(List<File> files, ClassLoader[] parents, boolean transitive) {
        this(files, parents, transitive, null);
    }

    public JarClassLoader(List<File> files, ClassLoader[] parents, boolean transitive, Module mod) {
        super(parents, transitive);
        this.module = mod;
        ArrayList<Source> l = new ArrayList<Source>(files.size());
        try {
            for (File file : files) {
                l.add(Source.create(file, this));
            }
        }
        catch (IOException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
        this.sources = l.toArray(new Source[0]);
        this.addCoveredPackages(JarClassLoader.getCoveredPackages(this.module, this.sources));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addURL(URL location) throws IOException, URISyntaxException {
        File f = BaseUtilities.toFile((URI)location.toURI());
        assert (f.exists()) : "URL must be existing local file: " + String.valueOf(location);
        ArrayList<Source> arr = new ArrayList<Source>(Arrays.asList(this.sources));
        arr.add(new JarSource(f));
        Source[] sourceArray = this.sources;
        synchronized (this.sources) {
            this.sources = arr.toArray(new Source[0]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.addCoveredPackages(JarClassLoader.getCoveredPackages(this.module, this.sources));
            return;
        }
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        return Policy.getPolicy().getPermissions(cs);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        if (man == null) {
            return this.definePackage(name, null, null, null, null, null, null, null);
        }
        String path = name.replace('.', '/').concat("/");
        String[] arr = PackageAttrsCache.findPackageAttrs(url, man, path);
        URL sealBase = "true".equalsIgnoreCase(arr[6]) ? url : null;
        return this.definePackage(name, arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], sealBase);
    }

    byte[] getClassData(String name) {
        String path = name.replace('.', '/').concat(".class");
        for (int i = 0; i < this.sources.length; ++i) {
            Source src = this.sources[i];
            byte[] data = src.getClassData(path);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> doLoadClass(String pkgName, String name) {
        String path = name.replace('.', '/').concat(".class");
        for (int i = 0; i < this.sources.length; ++i) {
            final Source src = this.sources[i];
            byte[] data = src.getClassData(path);
            if (data == null) continue;
            Source[] sourceArray = this.sources;
            synchronized (this.sources) {
                if (this.patchingBytecode == null) {
                    Enumeration<URL> res = this.findResources("META-INF/.bytecodePatched");
                    if (res.hasMoreElements()) {
                        LOGGER.log(Level.FINE, "Patching bytecode in {0}", this);
                    }
                    this.patchingBytecode = PatchByteCode.fromStream(res, this);
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                try {
                    data = this.patchingBytecode.apply(name, data);
                }
                catch (Exception x) {
                    LOGGER.log(Level.INFO, "Could not bytecode-patch " + name, x);
                }
                Package pkg = this.getPackageFast(pkgName, true);
                if (pkg != null) {
                    if (pkg.isSealed() && !pkg.isSealed(src.getURL())) {
                        throw new SecurityException("sealing violation");
                    }
                } else {
                    class DelayedManifest
                    extends Manifest {
                        private Manifest delegate;
                        final /* synthetic */ JarClassLoader this$0;

                        DelayedManifest() {
                            this.this$0 = this$0;
                        }

                        private Manifest delegate() {
                            if (this.delegate == null) {
                                Manifest m;
                                Manifest manifest = m = this.this$0.module == null || src != this.this$0.sources[0] ? src.getManifest() : this.this$0.module.getManifest();
                                if (m == null) {
                                    m = new Manifest();
                                }
                                this.delegate = m;
                                return m;
                            }
                            return this.delegate;
                        }

                        @Override
                        public Attributes getMainAttributes() {
                            return this.delegate().getMainAttributes();
                        }

                        @Override
                        public Attributes getAttributes(String name) {
                            return this.delegate().getAttributes(name);
                        }

                        @Override
                        public Map<String, Attributes> getEntries() {
                            return this.delegate().getEntries();
                        }
                    }
                    DelayedManifest man = new DelayedManifest();
                    try {
                        this.definePackage(pkgName, man, src.getURL());
                    }
                    catch (IllegalArgumentException x) {
                        LOGGER.log(Level.FINE, null, x);
                    }
                }
                try {
                    data = NbInstrumentation.patchByteCode(this, name, src.getProtectionDomain(), data);
                }
                catch (IllegalClassFormatException ex) {
                    LOGGER.log(Level.WARNING, "Problems patching" + name, ex);
                }
                return this.defineClass(name, data, 0, data.length, src.getProtectionDomain());
            }
        }
        return null;
    }

    @Override
    public URL findResource(String name) {
        for (int i = 0; i < this.sources.length; ++i) {
            URL item = this.sources[i].getResource(name);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        Vector<URL> v = new Vector<URL>(3);
        for (int i = 0; i < this.sources.length; ++i) {
            URL item = this.sources[i].getResource(name);
            if (item == null) continue;
            v.add(item);
        }
        return v.elements();
    }

    @Override
    public void destroy() {
        super.destroy();
        for (Source src : this.sources) {
            try {
                src.destroy();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "could not destroy " + String.valueOf(src), ioe);
            }
        }
    }

    void releaseJars() throws IOException {
        for (Source src : this.sources) {
            if (!(src instanceof JarSource)) continue;
            ((JarSource)src).doCloseJar();
        }
    }

    static void dumpFiles(File f, int retry) {
        while (true) {
            if (f == null) {
                LOGGER.log(Level.INFO, "file {0} is null. # of retries {1}", new Object[]{f, retry});
                break;
            }
            if (f.exists()) {
                LOGGER.log(Level.INFO, "file {0} exists. # of retries {1}", new Object[]{f, retry});
                if (f.isDirectory()) {
                    LOGGER.log(Level.INFO, "{0} is directory and contains: {1}", new Object[]{f, Arrays.toString(f.list())});
                    break;
                }
                LOGGER.log(Level.INFO, "{0} isDirectory: {1}, isFile: {2} size: {3}", new Object[]{f, f.isDirectory(), f.isFile(), f.length()});
                break;
            }
            LOGGER.log(Level.INFO, "{0} does not exist, # of retries {1}", new Object[]{f, retry});
            f = f.getParentFile();
        }
    }

    private static Iterable<String> getCoveredPackages(Module mod, Source[] sources) {
        Attributes attr;
        String pack;
        Manifest m;
        Set<String> ret;
        if (mod != null && (ret = mod.getCoveredPackages()) != null) {
            return ret;
        }
        HashSet<String> known = new HashSet<String>();
        Manifest manifest = m = mod == null ? null : mod.getManifest();
        if (m != null && (pack = (attr = m.getMainAttributes()).getValue("Covered-Packages")) != null) {
            known.addAll(Arrays.asList(pack.split(",", -1)));
            mod.registerCoveredPackages(known);
            return known;
        }
        StringBuffer save = new StringBuffer();
        for (Source s : sources) {
            s.listCoveredPackages(known, save);
        }
        if (save.length() > 0) {
            save.setLength(save.length() - 1);
        }
        if (mod != null) {
            mod.registerCoveredPackages(known);
        }
        return known;
    }

    static {
        int version;
        MULTI_RELEASE = new Attributes.Name("Multi-Release");
        try {
            Object runtimeVersion = Runtime.class.getMethod("version", new Class[0]).invoke(null, new Object[0]);
            version = (Integer)runtimeVersion.getClass().getMethod("major", new Class[0]).invoke(runtimeVersion, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            version = 8;
        }
        RUNTIME_VERSION = version;
        archive = new Archive();
        ProxyURLStreamHandlerFactory.register();
        LOGGER = Logger.getLogger(JarClassLoader.class.getName());
    }

    static abstract class Source {
        private URL url;
        private ProtectionDomain pd;
        protected JarClassLoader jcl;
        private static Map<String, Source> sources = new HashMap<String, Source>();
        private Boolean multiRelease;

        public Source(URL url) {
            this.url = url;
        }

        public final URL getURL() {
            return this.url;
        }

        public abstract String getPath();

        public final ProtectionDomain getProtectionDomain() {
            if (this.pd == null) {
                CodeSource cs = new CodeSource(this.url, (Certificate[])null);
                this.pd = new ProtectionDomain(cs, this.jcl.getPermissions(cs));
            }
            return this.pd;
        }

        public final URL getResource(String name) {
            try {
                return this.doGetResource(name);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, null, e);
                return null;
            }
        }

        protected abstract URL doGetResource(String var1) throws IOException;

        public final byte[] getClassData(String path) {
            try {
                return this.readClass(path);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "looking up " + path, e);
                return null;
            }
        }

        protected abstract byte[] readClass(String var1) throws IOException;

        public Manifest getManifest() {
            return null;
        }

        protected abstract void listCoveredPackages(Set<String> var1, StringBuffer var2);

        protected void destroy() throws IOException {
            sources.values().remove(this);
        }

        static Source create(File f, JarClassLoader jcl) throws IOException {
            boolean directory = f.getName().endsWith("jar") ? false : f.isDirectory();
            Source src = directory ? new DirSource(f) : new JarSource(f);
            src.jcl = jcl;
            sources.put(src.getPath(), src);
            return src;
        }

        public String toString() {
            return this.url.toString();
        }

        protected boolean isMultiRelease() {
            Manifest man = this.getManifest();
            if (man == null) {
                return false;
            }
            if (this.multiRelease != null) {
                return this.multiRelease;
            }
            if (man.getMainAttributes().containsKey(MULTI_RELEASE)) {
                String multiReleaseString = (String)man.getMainAttributes().get(MULTI_RELEASE);
                this.multiRelease = Boolean.valueOf(multiReleaseString);
            } else {
                this.multiRelease = false;
            }
            return this.multiRelease;
        }
    }

    static class JarSource
    extends Source
    implements ArchiveResources {
        private String resPrefix;
        private File file;
        private Future<JarFile> fjar;
        private boolean dead;
        private int requests;
        private int used;
        private volatile int[] versions;
        private volatile Reference<Manifest> manifest;
        private final Set<String> nonexistentResources = Collections.synchronizedSet(new HashSet());
        private final Set<File> warnedFiles = Collections.synchronizedSet(new HashSet());
        private static final Map<JarSource, Future<JarFile>> sources = new HashMap<JarSource, Future<JarFile>>();
        private static int LIMIT = Integer.getInteger("org.netbeans.JarClassLoader.limit_fd", 300);

        JarSource(File file) throws IOException {
            this(file, JarSource.toURI(file));
        }

        private JarSource(File file, String resPrefix) throws IOException {
            super(new URL(resPrefix));
            this.resPrefix = resPrefix;
            this.file = file;
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }

        private static String toURI(File file) {
            class VFile
            extends File {
                final /* synthetic */ File val$file;

                public VFile(File file) {
                    this.val$file = file;
                    super(file.getPath());
                }

                @Override
                public boolean isDirectory() {
                    return false;
                }

                @Override
                public File getAbsoluteFile() {
                    return this;
                }
            }
            return "jar:" + String.valueOf(BaseUtilities.toURI((File)new VFile(file))) + "!/";
        }

        @Override
        public Manifest getManifest() {
            Manifest man;
            if (this.manifest != null && (man = this.manifest.get()) != null) {
                return man;
            }
            try {
                byte[] arr = archive.getData(this, "META-INF/MANIFEST.MF");
                if (arr == null) {
                    return null;
                }
                Manifest man2 = new Manifest(new ByteArrayInputStream(arr));
                this.manifest = new SoftReference<Manifest>(man2);
                return man2;
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Cannot read manifest for " + this.getPath(), ex);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JarFile getJarFile(final String forWhat) throws IOException {
            FutureTask<JarFile> init = null;
            Map<JarSource, Future<JarFile>> map = sources;
            synchronized (map) {
                ++this.requests;
                ++this.used;
                if (this.fjar == null) {
                    this.fjar = sources.get(this);
                    if (this.fjar == null) {
                        init = new FutureTask<JarFile>(new Callable<JarFile>(){
                            final /* synthetic */ JarSource this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public JarFile call() throws IOException {
                                int retry = 0;
                                while (true) {
                                    try {
                                        JarFile ret;
                                        long now = System.currentTimeMillis();
                                        try {
                                            ret = new JarFile(this.this$0.file, false);
                                        }
                                        catch (FileNotFoundException | NoSuchFileException ex) {
                                            throw (ZipException)new ZipException(ex.getMessage()).initCause(ex);
                                        }
                                        long took = System.currentTimeMillis() - now;
                                        JarSource.opened(this.this$0, forWhat);
                                        if (took > 500L) {
                                            LOGGER.log(Level.WARNING, "Opening {0} took {1} ms", new Object[]{this.this$0.file, took});
                                        }
                                        return ret;
                                    }
                                    catch (ZipException zip) {
                                        if (this.this$0.file.exists() && retry++ < 3) {
                                            LOGGER.log(Level.WARNING, "Error opening " + String.valueOf(this.this$0.file) + " (exists=" + this.this$0.file.exists() + ") retry: " + retry, zip);
                                            JarSource.opened(this.this$0, "ziperror");
                                            continue;
                                        }
                                        JarClassLoader.dumpFiles(this.this$0.file, retry);
                                        throw zip;
                                    }
                                    break;
                                }
                            }
                        });
                        this.fjar = init;
                        sources.put(this, this.fjar);
                    }
                }
            }
            if (init != null) {
                init.run();
            }
            return this.callGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseJarFile() {
            Map<JarSource, Future<JarFile>> map = sources;
            synchronized (map) {
                assert (this.used > 0);
                --this.used;
            }
        }

        @Override
        protected URL doGetResource(String name) throws IOException {
            byte[] buf = archive.getData(this, name);
            if (buf == null) {
                return null;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Loading {0} from {1}", new Object[]{name, this.file.getPath()});
            }
            try {
                return new URL(null, this.resPrefix + new URI(null, name, null).getRawPath(), new JarURLStreamHandler(this.jcl));
            }
            catch (URISyntaxException x) {
                throw new IOException(name + " in " + this.resPrefix + ": " + x.toString(), x);
            }
        }

        @Override
        protected byte[] readClass(String path) throws IOException {
            try {
                if (!path.startsWith(JarClassLoader.META_INF) && this.isMultiRelease() && RUNTIME_VERSION > 8) {
                    int[] vers;
                    for (int version : vers = this.getVersions()) {
                        byte[] data = archive.getData(this, "META-INF/versions/" + version + "/" + path);
                        if (data == null) continue;
                        return data;
                    }
                }
                return archive.getData(this, path);
            }
            catch (ZipException ex) {
                JarClassLoader.dumpFiles(this.file, -1);
                throw ex;
            }
        }

        private int[] getVersions() {
            if (this.versions != null) {
                return this.versions;
            }
            try {
                TreeSet vers = new TreeSet(Collections.reverseOrder());
                for (int i = 8; i <= RUNTIME_VERSION; ++i) {
                    String directory = "META-INF/versions/" + i;
                    byte[] data = archive.getData(this, directory);
                    if (data == null || data.length != 0) continue;
                    vers.add(i);
                }
                int[] ret = new int[vers.size()];
                int i = 0;
                for (Integer ver : vers) {
                    ret[i++] = ver;
                }
                this.versions = ret;
                return ret;
            }
            catch (IOException ioe) {
                if (this.warnedFiles.add(this.file)) {
                    LOGGER.log(Level.WARNING, "problems with " + String.valueOf(this.file), ioe);
                    JarClassLoader.dumpFiles(this.file, -1);
                }
                return new int[0];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] resource(String path) throws IOException {
            JarFile jf;
            if (this.nonexistentResources.contains(path)) {
                return null;
            }
            try {
                jf = this.getJarFile(path);
            }
            catch (ZipException ex) {
                if (this.warnedFiles.add(this.file)) {
                    LOGGER.log(Level.INFO, "Cannot open " + String.valueOf(this.file), ex);
                    JarClassLoader.dumpFiles(this.file, -1);
                }
                return null;
            }
            try {
                ZipEntry ze = jf.getEntry(path);
                if (ze == null) {
                    this.nonexistentResources.add(path);
                    byte[] byArray = null;
                    return byArray;
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Loading {0} from {1}", new Object[]{path, this.file.getPath()});
                }
                int len = (int)ze.getSize();
                byte[] data = new byte[len];
                InputStream is = jf.getInputStream(ze);
                for (int count = 0; count < len; count += is.read(data, count, len - count)) {
                }
                byte[] byArray = data;
                return byArray;
            }
            finally {
                this.releaseJarFile();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void listCoveredPackages(Set<String> known, StringBuffer save) {
            try {
                JarFile src = this.getJarFile("pkg");
                Enumeration<JarEntry> en = src.entries();
                while (en.hasMoreElements()) {
                    Object res;
                    JarEntry je = en.nextElement();
                    if (je.isDirectory()) continue;
                    String itm = je.getName();
                    int slash = itm.lastIndexOf(47);
                    if (slash == -1) {
                        res = "default/" + je.getName();
                        if (!known.add((String)res)) continue;
                        save.append((String)res).append(',');
                        continue;
                    }
                    if (itm.startsWith(JarClassLoader.META_INF)) {
                        res = itm.substring(8);
                        if (!known.add((String)res)) continue;
                        save.append((String)res).append(',');
                        continue;
                    }
                    String pkg = slash > 0 ? itm.substring(0, slash).replace('/', '.') : "";
                    if (!known.add(pkg)) continue;
                    save.append(pkg).append(',');
                }
            }
            catch (ZipException x) {
                if (this.warnedFiles.add(this.file)) {
                    LOGGER.log(Level.INFO, "Cannot open " + String.valueOf(this.file), x);
                    JarClassLoader.dumpFiles(this.file, -1);
                }
            }
            catch (FileNotFoundException x) {
                if (this.warnedFiles.add(this.file)) {
                    LOGGER.log(Level.INFO, "Cannot open " + String.valueOf(this.file), x);
                    JarClassLoader.dumpFiles(this.file, -1);
                }
            }
            catch (IOException ioe) {
                if (this.warnedFiles.add(this.file)) {
                    LOGGER.log(Level.WARNING, "problems with " + String.valueOf(this.file), ioe);
                    JarClassLoader.dumpFiles(this.file, -1);
                }
            }
            finally {
                this.releaseJarFile();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void destroy() throws IOException {
            String suffix;
            Object prefix;
            super.destroy();
            if (this.dead) {
                return;
            }
            File orig = this.file;
            if (!orig.isFile()) {
                return;
            }
            String name = orig.getName();
            int idx = name.lastIndexOf(46);
            if (idx == -1) {
                prefix = name;
                suffix = null;
            } else {
                prefix = name.substring(0, idx);
                suffix = name.substring(idx);
            }
            while (((String)prefix).length() < 3) {
                prefix = (String)prefix + "x";
            }
            File temp = Files.createTempFile((String)prefix, suffix, new FileAttribute[0]).toFile();
            temp.deleteOnExit();
            try (FileInputStream is = new FileInputStream(orig);
                 FileOutputStream os = new FileOutputStream(temp);){
                int j;
                byte[] buf = new byte[4096];
                while ((j = ((InputStream)is).read(buf)) != -1) {
                    ((OutputStream)os).write(buf, 0, j);
                }
            }
            this.doCloseJar();
            this.file = temp;
            this.dead = true;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "#21114: replacing {0} with {1}", new Object[]{orig, temp});
            }
        }

        private JarFile callGet() throws IOException {
            JarFile ret;
            boolean interrupted = false;
            while (true) {
                try {
                    ret = this.fjar.get();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    if (cause instanceof ThreadDeath) {
                        throw (ThreadDeath)cause;
                    }
                    throw new IOException(cause);
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCloseJar() throws IOException {
            JarFile jar = null;
            Map<JarSource, Future<JarFile>> map = sources;
            synchronized (map) {
                if (this.fjar != null) {
                    jar = this.callGet();
                    if (sources.remove(this) == null) {
                        LOGGER.warning("Can't remove " + String.valueOf(this));
                    }
                    LOGGER.log(Level.FINE, "Closing JAR {0}", jar.getName());
                    this.fjar = null;
                    LOGGER.log(Level.FINE, "Remaining open JARs: {0}", sources.size());
                }
            }
            if (jar != null) {
                jar.close();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.doCloseJar();
            if (this.dead) {
                LOGGER.log(Level.FINE, "#21114: closing and deleting temporary JAR {0}", this.file);
                if (this.file.isFile() && !this.file.delete()) {
                    LOGGER.log(Level.FINE, "(but failed to delete {0})", this.file);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void opened(JarSource source, String forWhat) {
            Map<JarSource, Future<JarFile>> map = sources;
            synchronized (map) {
                if (sources.size() > LIMIT) {
                    JarSource toClose = JarSource.toClose(source);
                    try {
                        toClose.doCloseJar();
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.INFO, "closing " + String.valueOf(toClose), ioe);
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Opening module JAR {0} for {1}", new Object[]{source.file, forWhat});
                    LOGGER.log(Level.FINE, "Currently open JARs: {0}", sources.size());
                }
            }
        }

        private static JarSource toClose(JarSource notThisOne) {
            assert (Thread.holdsLock(sources));
            int min = Integer.MAX_VALUE;
            JarSource candidate = null;
            for (JarSource act : sources.keySet()) {
                act.requests = 5 * act.requests / 6;
                if (act.used > 0 || act.requests >= min) continue;
                min = act.requests;
                candidate = act;
            }
            assert (candidate != null);
            assert (candidate != notThisOne) : "Closing just opened JarSource: " + String.valueOf(notThisOne);
            return candidate;
        }

        @Override
        public String getIdentifier() {
            String tmp = this.getURL().toExternalForm();
            if (tmp.startsWith("jar:file:") && tmp.endsWith("!/")) {
                String path = tmp.substring(9, tmp.length() - 2).replace("%20", " ");
                if (BaseUtilities.isWindows()) {
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    path = path.replace('/', File.separatorChar);
                }
                return Stamps.findRelativePath(path) + "!/";
            }
            return tmp;
        }
    }

    private static class NbJarURLConnection
    extends JarURLConnection {
        private JarSource src;
        private final String name;
        private byte[] data;
        private InputStream iStream;
        private final ClassLoader loader;

        private NbJarURLConnection(URL url, Source src, String name, ClassLoader l) throws MalformedURLException {
            super(url);
            this.src = (JarSource)src;
            this.name = name;
            this.loader = l;
        }

        private boolean isFolder() {
            return this.name.length() == 0 || this.name.endsWith("/");
        }

        @Override
        public void connect() throws IOException {
            if (this.isFolder()) {
                return;
            }
            if (this.data == null) {
                this.data = this.src.getClassData(this.name);
                if (this.data == null) {
                    throw new FileNotFoundException(this.getURL().toString());
                }
            }
        }

        @Override
        public long getLastModified() {
            return Stamps.getModulesJARs().lastModified();
        }

        @Override
        public String getContentType() {
            String contentType = NbJarURLConnection.guessContentTypeFromName(this.name);
            if (contentType == null) {
                contentType = "content/unknown";
            }
            return contentType;
        }

        @Override
        public int getContentLength() {
            if (this.isFolder()) {
                return -1;
            }
            try {
                this.connect();
                return this.data.length;
            }
            catch (IOException e) {
                return -1;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.isFolder()) {
                throw new IOException("Cannot open a folder");
            }
            this.connect();
            if (this.iStream == null) {
                this.iStream = new ByteArrayInputStream(this.data);
            }
            return this.iStream;
        }

        @Override
        public JarFile getJarFile() throws IOException {
            return new JarFile(this.src.file);
        }

        public Object getContent(Class[] classes) throws IOException {
            if (Arrays.asList(classes).contains(ClassLoader.class)) {
                return this.loader;
            }
            return super.getContent(classes);
        }
    }

    static class JarURLStreamHandler
    extends URLStreamHandler {
        private static final URLStreamHandler fallback = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return new URL(u.toString()).openConnection();
            }
        };
        private final URLStreamHandler originalJarHandler;
        private ClassLoader loader;

        JarURLStreamHandler(URLStreamHandler originalJarHandler) {
            this.originalJarHandler = originalJarHandler;
        }

        private JarURLStreamHandler(ClassLoader l) {
            this(fallback);
            this.loader = l;
        }

        @Override
        protected JarURLConnection openConnection(URL u) throws IOException {
            String jar;
            String url = u.getFile();
            int bang = url.indexOf("!/");
            if (bang == -1) {
                throw new IOException("Malformed JAR-protocol URL: " + String.valueOf(u));
            }
            String filePath = url.substring(0, bang);
            while (true) {
                try {
                    URI uri = new URI(filePath);
                    if (uri.getScheme().equals("file")) {
                        jar = BaseUtilities.toFile((URI)uri).getPath();
                        break;
                    }
                    jar = null;
                }
                catch (URISyntaxException x) {
                    if (filePath.contains(" ")) {
                        filePath = filePath.replace(" ", "%20");
                        continue;
                    }
                    throw new IOException(x);
                }
                break;
            }
            Source _src = Source.sources.get(jar);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINER, "openConnection for {0} jar: {1} src: {2}", new Object[]{u, jar, _src});
            }
            if (_src == null) {
                try {
                    Method m = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
                    m.setAccessible(true);
                    JarURLConnection ret = (JarURLConnection)m.invoke((Object)this.originalJarHandler, u);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Calling original {0} yields {1}", new Object[]{this.originalJarHandler, ret});
                    }
                    return ret;
                }
                catch (Exception e) {
                    throw (IOException)new IOException(e.toString()).initCause(e);
                }
            }
            String _name = url.substring(bang + 2);
            try {
                _name = new URI(_name).getPath();
            }
            catch (URISyntaxException x) {
                throw (IOException)new IOException("Decoding " + String.valueOf(u) + ": " + String.valueOf(x)).initCause(x);
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "creating NbJarURLConnection({0},{1},{2})", new Object[]{u, _src, _name});
            }
            return new NbJarURLConnection(u, _src, _name, this.loader);
        }

        @Override
        protected void parseURL(URL u, String spec, int start, int limit) {
            if (spec.startsWith("/")) {
                this.setURL(u, "jar", u.getHost(), u.getPort(), u.getAuthority(), u.getUserInfo(), u.getFile().replaceFirst("!/.*$", "!" + spec), u.getQuery(), u.getRef());
            } else {
                super.parseURL(u, spec, start, limit);
            }
        }
    }

    static class DirSource
    extends Source {
        File dir;
        Manifest manifest;

        DirSource(File file) throws MalformedURLException {
            super(BaseUtilities.toURI((File)file).toURL());
            this.dir = file;
        }

        @Override
        public Manifest getManifest() {
            Manifest mf = this.manifest;
            if (mf != null) {
                return mf;
            }
            File maniF = new File(new File(this.dir, "META-INF"), "MANIFEST.MF");
            mf = new Manifest();
            if (maniF.canRead()) {
                try (FileInputStream istm = new FileInputStream(maniF);){
                    mf.read(istm);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.manifest = mf;
            return this.manifest;
        }

        @Override
        public String getPath() {
            return this.dir.getPath();
        }

        @Override
        protected URL doGetResource(String name) throws MalformedURLException {
            File resFile = new File(this.dir, name);
            return resFile.exists() ? BaseUtilities.toURI((File)resFile).toURL() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected byte[] readClass(String path) throws IOException {
            File clsFile = new File(this.dir, path.replace('/', File.separatorChar));
            if (!clsFile.exists()) {
                return null;
            }
            int len = (int)clsFile.length();
            byte[] data = new byte[len];
            try (FileInputStream is = new FileInputStream(clsFile);){
                for (int count = 0; count < len; count += ((InputStream)is).read(data, count, len - count)) {
                }
                byte[] byArray = data;
                return byArray;
            }
        }

        @Override
        protected void listCoveredPackages(Set<String> known, StringBuffer save) {
            DirSource.appendAllChildren(known, save, this.dir, "");
        }

        private static void appendAllChildren(Set<String> known, StringBuffer save, File dir, String prefix) {
            boolean populated = false;
            for (File f : dir.listFiles()) {
                Object res;
                if (f.isDirectory()) {
                    DirSource.appendAllChildren(known, save, f, prefix + f.getName() + ".");
                    continue;
                }
                if (prefix.length() == 0) {
                    res = "default/" + f.getName();
                    if (!known.add((String)res)) continue;
                    save.append((String)res).append(',');
                    continue;
                }
                populated = true;
                if (!prefix.startsWith("META-INF.") || !known.add((String)(res = prefix.substring(8).replace('.', '/').concat(f.getName())))) continue;
                save.append((String)res).append(',');
            }
            if (populated) {
                String pkg = prefix;
                if (pkg.endsWith(".")) {
                    pkg = pkg.substring(0, pkg.length() - 1);
                }
                if (known.add(pkg)) {
                    save.append(pkg).append(',');
                }
            }
        }
    }
}

