/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.jdbc.LiveJDBCView;
import org.netbeans.lib.profiler.ui.jdbc.LiveJDBCViewUpdater;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureUI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

abstract class SQLFeatureUI
extends FeatureUI {
    private ProfilerToolbar toolbar;
    private LiveJDBCView jdbcView;
    private LiveJDBCViewUpdater updater;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private JLabel pdLabel;
    private JButton pdSnapshotButton;
    private JButton pdResetResultsButton;
    private boolean popupPause;

    SQLFeatureUI() {
    }

    abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    abstract Lookup.Provider getProject();

    abstract ProfilerClient getProfilerClient();

    abstract void refreshResults();

    @Override
    ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    @Override
    JPanel getResultsUI() {
        if (this.jdbcView == null) {
            this.initUI();
        }
        return this.jdbcView;
    }

    @Override
    void sessionStateChanged(int sessionState) {
        this.refreshToolbar(sessionState);
    }

    void resetPause() {
        if (this.lrPauseButton != null) {
            this.lrPauseButton.setSelected(false);
        }
    }

    void setForceRefresh() {
        if (this.updater != null) {
            this.updater.setForceRefresh(true);
        }
    }

    void refreshData() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.updater != null) {
            this.updater.update();
        }
    }

    void resetData() {
        if (this.lrDeltasButton != null) {
            this.lrDeltasButton.setSelected(false);
            this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        }
        if (this.jdbcView != null) {
            this.jdbcView.resetData();
            this.jdbcView.setDiffView(false);
        }
    }

    void cleanup() {
        if (this.jdbcView != null) {
            this.jdbcView.cleanup();
        }
    }

    private void initUI() {
        assert (SwingUtilities.isEventDispatchThread());
        this.jdbcView = new LiveJDBCView(null){

            protected ProfilerClient getProfilerClient() {
                return SQLFeatureUI.this.getProfilerClient();
            }

            protected boolean showSourceSupported() {
                return GoToSource.isAvailable();
            }

            protected void showSource(ClientUtils.SourceCodeSelection value) {
                Lookup.Provider project = SQLFeatureUI.this.getProject();
                String className = value.getClassName();
                String methodName = value.getMethodName();
                String methodSig = value.getMethodSignature();
                GoToSource.openSource((Lookup.Provider)project, (String)className, (String)methodName, (String)methodSig);
            }

            protected void showSQLQuery(String query, String htmlQuery) {
                HTMLTextArea area = new HTMLTextArea(htmlQuery);
                JScrollPane areaScroll = new JScrollPane((Component)area);
                areaScroll.setPreferredSize(new Dimension(500, 250));
                JLabel label = new JLabel(Bundle.LocksFeatureUI_SqlQueryLabel(), 10);
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                label.setLabelFor((Component)area);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)label, "North");
                panel.add((Component)areaScroll, "Center");
                panel.setBorder(BorderFactory.createEmptyBorder(12, 10, 0, 10));
                HelpCtx help = new HelpCtx("SqlQueryViewer.HelpCtx");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)panel, Bundle.LocksFeatureUI_SqlQueryCaption(), false, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, help, null));
            }

            protected void selectForProfiling(ClientUtils.SourceCodeSelection value) {
                SQLFeatureUI.this.selectForProfiling(value);
            }

            protected void popupShowing() {
                if (SQLFeatureUI.this.lrPauseButton.isEnabled() && !SQLFeatureUI.this.lrRefreshButton.isEnabled()) {
                    SQLFeatureUI.this.popupPause = true;
                    SQLFeatureUI.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (SQLFeatureUI.this.lrPauseButton.isEnabled() && SQLFeatureUI.this.popupPause) {
                    SQLFeatureUI.this.popupPause = false;
                    SQLFeatureUI.this.lrPauseButton.setSelected(false);
                }
            }
        };
        this.jdbcView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileSQL.HelpCtx");
        this.updater = new LiveJDBCViewUpdater(this.jdbcView, this.getProfilerClient());
        this.lrLabel = new GrayLabel(Bundle.MethodsFeatureUI_liveResults());
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = this.isSelected();
                SQLFeatureUI.this.updater.setPaused(paused);
                if (!paused) {
                    SQLFeatureUI.this.refreshResults();
                }
                SQLFeatureUI.this.refreshToolbar(SQLFeatureUI.this.getSessionState());
            }
        };
        this.lrPauseButton.setToolTipText(Bundle.MethodsFeatureUI_pauseResults());
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SQLFeatureUI.this.refreshResults();
            }
        };
        this.lrRefreshButton.setToolTipText(Bundle.MethodsFeatureUI_updateResults());
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                if (!SQLFeatureUI.this.jdbcView.setDiffView(this.isSelected())) {
                    this.setSelected(false);
                }
                this.setToolTipText(this.isSelected() ? Bundle.MethodsFeatureUI_showAbsolute() : Bundle.MethodsFeatureUI_showDeltas());
            }
        };
        this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        this.pdLabel = new GrayLabel(Bundle.MethodsFeatureUI_profilingData());
        this.pdSnapshotButton = new JButton((Action)((Object)TakeSnapshotAction.getInstance()));
        this.pdSnapshotButton.setHideActionText(true);
        this.pdResetResultsButton = new JButton((Action)((Object)ResetResultsAction.getInstance()));
        this.pdResetResultsButton.setHideActionText(true);
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrDeltasButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.pdLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.pdSnapshotButton);
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)this.pdResetResultsButton);
        this.sessionStateChanged(this.getSessionState());
    }

    private void refreshToolbar(final int state) {
        if (this.toolbar != null) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ SQLFeatureUI this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    boolean running = state == 4;
                    this.this$0.lrPauseButton.setEnabled(running);
                    this.this$0.lrRefreshButton.setEnabled(!this.this$0.popupPause && running && this.this$0.lrPauseButton.isSelected());
                    this.this$0.lrDeltasButton.setEnabled(running);
                }
            });
        }
    }
}

