/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Watch;
import org.netbeans.spi.debugger.ui.EditorPin;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class WatchesReader
implements Properties.Reader {
    private static final Logger LOG = Logger.getLogger(WatchesReader.class.getName());
    private static final String PIN = "pin";
    private static final String PIN_URL = "url";
    private static final String PIN_LINE = "line";
    private static final String PIN_LOCATION_X = "locationX";
    private static final String PIN_LOCATION_Y = "locationY";
    private static final String PIN_COMMENT = "comment";
    private static final String PIN_VP_ID = "valueProviderId";
    public static PinReaderAccess PIN_READER_ACCESS;

    public String[] getSupportedClassNames() {
        return new String[]{Watch.class.getName(), EditorPin.class.getName()};
    }

    public Object read(String typeID, Properties properties) {
        if (typeID.equals(Watch.class.getName())) {
            String expression = properties.getString("expression", null);
            Watch.Pin pin = (Watch.Pin)properties.getObject(PIN, null);
            Watch watch = pin != null ? DebuggerManager.getDebuggerManager().createPinnedWatch(expression, pin) : DebuggerManager.getDebuggerManager().createWatch(expression);
            watch.setEnabled(properties.getBoolean("enabled", true));
            return watch;
        }
        if (typeID.equals(EditorPin.class.getName())) {
            URL url;
            String urlStr = properties.getString(PIN_URL, null);
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.CONFIG, "urlStr = " + urlStr, ex);
                return null;
            }
            FileObject fo = URLMapper.findFileObject((URL)url);
            if (fo == null) {
                return null;
            }
            int line = properties.getInt(PIN_LINE, 0);
            Point location = new Point(properties.getInt(PIN_LOCATION_X, 0), properties.getInt(PIN_LOCATION_Y, 0));
            EditorPin pin = new EditorPin(fo, line, location);
            String comment = properties.getString(PIN_COMMENT, null);
            if (comment != null) {
                pin.setComment(comment);
            }
            PIN_READER_ACCESS.setVpId(pin, properties.getString(PIN_VP_ID, null));
            return pin;
        }
        return null;
    }

    public void write(Object object, Properties properties) {
        if (object instanceof Watch) {
            Watch w = (Watch)object;
            properties.setString("expression", w.getExpression());
            properties.setBoolean("enabled", w.isEnabled());
            Watch.Pin pin = w.getPin();
            properties.setObject(PIN, (Object)pin);
        } else if (object instanceof EditorPin) {
            EditorPin pin = (EditorPin)object;
            properties.setString(PIN_URL, pin.getFile().toURL().toExternalForm());
            properties.setInt(PIN_LINE, pin.getLine());
            properties.setInt(PIN_LOCATION_X, pin.getLocation().x);
            properties.setInt(PIN_LOCATION_Y, pin.getLocation().y);
            String comment = pin.getComment();
            properties.setString(PIN_COMMENT, comment);
            properties.setString(PIN_VP_ID, PIN_READER_ACCESS.getVpId(pin));
        }
    }

    public static interface PinReaderAccess {
        public String getVpId(EditorPin var1);

        public void setVpId(EditorPin var1, String var2);
    }
}

