/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InvalidObjectException;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.PrimitiveValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ShortenedStrings;
import org.netbeans.modules.debugger.jpda.models.VariableMirrorTranslator;
import org.openide.util.NbBundle;

public class AbstractVariable
implements JDIVariable,
Customizer,
Cloneable {
    private Value value;
    private JPDADebuggerImpl debugger;
    private String id;
    private boolean silent;
    private final Set<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
    private int cloneNumber = 1;

    public AbstractVariable(JPDADebuggerImpl debugger, Value value, String id) {
        this.debugger = debugger;
        this.value = value;
        this.id = id;
        if (this.id == null) {
            this.id = Integer.toString(super.hashCode());
        }
    }

    public String getValue() {
        Value v = this.getInnerValue();
        return AbstractVariable.getValue(v);
    }

    static String getValue(Value v) {
        if (v == null) {
            return "null";
        }
        if (v instanceof VoidValue) {
            return "void";
        }
        if (v instanceof CharValue) {
            return "'" + v.toString() + "'";
        }
        if (v instanceof PrimitiveValue) {
            return v.toString();
        }
        try {
            if (v instanceof StringReference) {
                String str = ShortenedStrings.getStringWithLengthControl((StringReference)v);
                return "\"" + str + "\"";
            }
            if (v instanceof ClassObjectReference) {
                return "class " + ReferenceTypeWrapper.name(ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)v));
            }
            if (v instanceof ArrayReference) {
                return "#" + ObjectReferenceWrapper.uniqueID((ArrayReference)v) + "(length=" + ArrayReferenceWrapper.length((ArrayReference)v) + ")";
            }
            return "#" + ObjectReferenceWrapper.uniqueID((ObjectReference)v);
        }
        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException | ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper e) {
            return "";
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String expression) throws InvalidExpressionException {
        void var4_11;
        String oldValue = this.getValue();
        if (expression.equals(oldValue)) {
            return;
        }
        VirtualMachine vm = this.debugger.getVirtualMachine();
        if (vm == null) {
            return;
        }
        Value oldV = this.getInnerValue();
        try {
            if (oldV instanceof CharValue && expression.startsWith("'") && expression.endsWith("'") && expression.length() > 1) {
                CharValue charValue = VirtualMachineWrapper.mirrorOf(MirrorWrapper.virtualMachine(oldV), expression.charAt(1));
            } else if ((oldV instanceof StringReference || oldV == null) && expression.startsWith("\"") && expression.endsWith("\"") && expression.length() > 1) {
                StringReference stringReference = VirtualMachineWrapper.mirrorOf(vm, expression.substring(1, expression.length() - 1));
            } else if (oldV instanceof StringReference) {
                StringReference stringReference = VirtualMachineWrapper.mirrorOf(vm, expression);
            } else if (oldV instanceof ObjectReference && ObjectReferenceWrapper.referenceType((ObjectReference)oldV) instanceof ClassType && ClassTypeWrapper.isEnum((ClassType)ObjectReferenceWrapper.referenceType((ObjectReference)oldV))) {
                ClassType enumType = (ClassType)ObjectReferenceWrapper.referenceType((ObjectReference)oldV);
                Field enumValue = ReferenceTypeWrapper.fieldByName(enumType, expression);
                if (enumValue == null) throw new InvalidExpressionException(expression);
                Value value = ReferenceTypeWrapper.getValue(enumType, enumValue);
            } else if ("null".equals(expression)) {
                Object var4_9 = null;
            } else {
                Type type;
                Value evaluatedValue = this.debugger.evaluateIn(expression);
                if (oldV != null && evaluatedValue != null && !(type = ValueWrapper.type(oldV)).equals(ValueWrapper.type(evaluatedValue))) {
                    evaluatedValue = this.convertValue(evaluatedValue, type);
                }
                Value value = evaluatedValue;
            }
        }
        catch (InternalExceptionWrapper e) {
            throw new InvalidExpressionException((Throwable)e);
        }
        catch (ClassNotPreparedExceptionWrapper e) {
            throw new InvalidExpressionException((Throwable)e);
        }
        catch (ObjectCollectedExceptionWrapper e) {
            throw new InvalidExpressionException((Throwable)e);
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return;
        }
        catch (UnsupportedOperationExceptionWrapper e) {
            throw new InvalidExpressionException((Throwable)e);
        }
        this.setValue((Value)var4_11);
        this.setInnerValue((Value)var4_11);
    }

    private Value convertValue(Value value, Type type) {
        JPDAThread ct;
        if (type instanceof PrimitiveType) {
            if (value instanceof ObjectReference) {
                boolean equalsType;
                ct = this.getDebugger().getCurrentThread();
                if (ct != null) {
                    try {
                        value = EvaluatorVisitor.unbox((ObjectReference)value, (PrimitiveType)type, ((JPDAThreadImpl)ct).getThreadReference(), null);
                    }
                    catch (InvalidTypeException invalidTypeException) {
                    }
                    catch (ClassNotLoadedException classNotLoadedException) {
                    }
                    catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    }
                    catch (InvocationException invocationException) {
                        // empty catch block
                    }
                }
                try {
                    equalsType = ValueWrapper.type(value).equals(type);
                }
                catch (InternalExceptionWrapper ex) {
                    equalsType = true;
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    equalsType = true;
                }
                catch (ObjectCollectedExceptionWrapper ex) {
                    equalsType = true;
                }
                if (equalsType) {
                    return value;
                }
            }
            if (value instanceof PrimitiveValue) {
                PrimitiveValue pv = (PrimitiveValue)value;
                try {
                    VirtualMachine vm = MirrorWrapper.virtualMachine(pv);
                    if (type instanceof BooleanType) {
                        return VirtualMachineWrapper.mirrorOf(vm, PrimitiveValueWrapper.booleanValue(pv));
                    }
                    if (type instanceof ByteType) {
                        return VirtualMachineWrapper.mirrorOf(vm, PrimitiveValueWrapper.byteValue(pv));
                    }
                    if (type instanceof CharType) {
                        return VirtualMachineWrapper.mirrorOf(vm, PrimitiveValueWrapper.charValue(pv));
                    }
                    if (type instanceof ShortType) {
                        return VirtualMachineWrapper.mirrorOf(vm, PrimitiveValueWrapper.shortValue(pv));
                    }
                    if (type instanceof IntegerType) {
                        return VirtualMachineWrapper.mirrorOf(vm, PrimitiveValueWrapper.intValue(pv));
                    }
                    if (type instanceof LongType) {
                        return VirtualMachineWrapper.mirrorOf(vm, PrimitiveValueWrapper.longValue(pv));
                    }
                    if (type instanceof FloatType) {
                        return VirtualMachineWrapper.mirrorOf(vm, PrimitiveValueWrapper.floatValue(pv));
                    }
                    if (type instanceof DoubleType) {
                        return VirtualMachineWrapper.mirrorOf(vm, PrimitiveValueWrapper.doubleValue(pv));
                    }
                }
                catch (InternalExceptionWrapper vm) {
                }
                catch (VMDisconnectedExceptionWrapper vm) {
                    // empty catch block
                }
            }
        }
        if (type instanceof ClassType && value instanceof PrimitiveValue && (ct = this.getDebugger().getCurrentThread()) != null) {
            PrimitiveValue pv = (PrimitiveValue)value;
            try {
                value = EvaluatorVisitor.box(pv, (ReferenceType)type, ((JPDAThreadImpl)ct).getThreadReference(), null);
            }
            catch (InvalidTypeException invalidTypeException) {
            }
            catch (ClassNotLoadedException classNotLoadedException) {
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            }
            catch (InvocationException invocationException) {
            }
            catch (InternalException internalException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        return value;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        throw new InternalError(this.getClass().getName());
    }

    @Override
    public void setObject(Object bean) {
        try {
            if (!(bean instanceof String)) {
                throw new IllegalArgumentException("" + bean);
            }
            this.setValue((String)bean);
        }
        catch (InvalidExpressionException ieex) {
            throw new IllegalArgumentException(ieex);
        }
    }

    public String getType() {
        if (this.getInnerValue() == null) {
            return "";
        }
        try {
            return TypeWrapper.name(ValueWrapper.type(this.getInnerValue()));
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vmdex) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_Disconnected");
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_ObjCollected");
        }
    }

    public JPDAClassType getClassType() {
        Type type;
        Value value = this.getInnerValue();
        if (value == null) {
            return null;
        }
        try {
            type = ValueWrapper.type(value);
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return null;
        }
        if (type instanceof ReferenceType) {
            return this.debugger.getClassType((ReferenceType)type);
        }
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof AbstractVariable && this.id.equals(((AbstractVariable)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Value getInnerValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInnerValue(Value v) {
        this.value = v;
        if (!this.silent) {
            Object[] ls;
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "value", null, v);
            Set<PropertyChangeListener> set = this.listeners;
            synchronized (set) {
                ls = this.listeners.toArray();
            }
            for (int i = 0; i < ls.length; ++i) {
                ((PropertyChangeListener)ls[i]).propertyChange(evt);
            }
            this.debugger.varChangeSupport.firePropertyChange(evt);
        }
    }

    public void setSilentChange(boolean silent) {
        this.silent = silent;
    }

    @Override
    public Value getJDIValue() {
        return this.getInnerValue();
    }

    public final JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    protected final String getID() {
        return this.id;
    }

    public Variable clone() {
        AbstractVariable clon = new AbstractVariable(this.debugger, this.value, this.id + "_clone" + this.cloneNumber++);
        return clon;
    }

    public Object createMirrorObject() {
        Value v = this.getJDIValue();
        if (v == null) {
            return null;
        }
        return VariableMirrorTranslator.createMirrorObject(v);
    }

    public void setFromMirrorObject(Object obj) throws InvalidObjectException {
        Value v;
        if (obj == null) {
            v = null;
        } else {
            try {
                v = VariableMirrorTranslator.createValueFromMirror(obj, this instanceof ObjectVariable, this.getDebugger());
            }
            catch (ClassNotLoadedException | InvalidTypeException | ClassNotPreparedExceptionWrapper | IllegalArgumentExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
                ioex.initCause(ex);
                throw ioex;
            }
            if (v == null) {
                throw new InvalidObjectException("No target value from " + obj);
            }
        }
        try {
            this.setValue(v);
        }
        catch (InvalidExpressionException iex) {
            InvalidObjectException ioex = new InvalidObjectException(iex.getLocalizedMessage());
            ioex.initCause(iex);
            throw ioex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public String toString() {
        return "Variable ";
    }
}

