/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.lang.model.element.TypeElement;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.clientproject.Utils;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MainClassChooser
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ChangeListener changeListener;
    private String dialogSubtitle = null;
    private Collection<ElementHandle<TypeElement>> possibleMainClasses;
    public static Boolean unitTestingSupport_hasMainMethodResult = null;
    private JLabel jLabel1;
    private JList jMainClassList;
    private JScrollPane jScrollPane1;

    public MainClassChooser(FileObject[] sourcesRoots) {
        this(sourcesRoots, null);
    }

    public MainClassChooser(FileObject[] sourcesRoots, String subtitle) {
        this.dialogSubtitle = subtitle;
        this.initComponents();
        this.jMainClassList.setCellRenderer(new MainClassRenderer());
        this.initClassesView(sourcesRoots);
    }

    private void initClassesView(final FileObject[] sourcesRoots) {
        this.possibleMainClasses = null;
        this.jMainClassList.setSelectionMode(0);
        this.jMainClassList.setListData(this.getWarmupList());
        this.jMainClassList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(evt));
                }
            }
        });
        this.jMainClassList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && MainClassChooser.this.getSelectedMainClass() != null && MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(e));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ MainClassChooser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.possibleMainClasses = SourceUtils.getMainClasses((FileObject[])sourcesRoots);
                if (this.this$0.possibleMainClasses.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this$0.jMainClassList.setListData(new String[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_NO_CLASSES_NODE")});
                        }
                    });
                } else {
                    final ElementHandle[] arr = this.this$0.possibleMainClasses.toArray(new ElementHandle[0]);
                    Arrays.sort(arr, new MainClassComparator());
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.this$0.jMainClassList.setListData(arr);
                            this.this$1.this$0.jMainClassList.setSelectedIndex(0);
                        }
                    });
                }
            }
        });
        if (this.dialogSubtitle != null) {
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.dialogSubtitle);
        }
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_WARMUP_MESSAGE")};
    }

    private boolean isValidMainClassName(Object value) {
        return this.possibleMainClasses != null && this.possibleMainClasses.contains(value);
    }

    public String getSelectedMainClass() {
        if (this.isValidMainClassName(this.jMainClassList.getSelectedValue())) {
            return ((ElementHandle)this.jMainClassList.getSelectedValue()).getQualifiedName();
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListener = null;
    }

    public static boolean hasMainMethod(FileObject classFO) {
        return Utils.hasMainMethod(classFO);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jMainClassList = new JList();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(380, 300));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooser.class).getString("AD_MainClassChooser"));
        this.jLabel1.setLabelFor(this.jMainClassList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(MainClassChooser.class).getString("CTL_AvaialableMainClasses"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 2, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(100, 200));
        this.jScrollPane1.setViewportView(this.jMainClassList);
        this.jMainClassList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooser.class).getString("AD_jMainClassList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private static final class MainClassRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private MainClassRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                String string = (String)value;
            }
            String displayName = value instanceof ElementHandle ? ((ElementHandle)value).getQualifiedName() : value.toString();
            return super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
        }
    }

    private static class MainClassComparator
    implements Comparator<ElementHandle> {
        private MainClassComparator() {
        }

        @Override
        public int compare(ElementHandle arg0, ElementHandle arg1) {
            return arg0.getQualifiedName().compareTo(arg1.getQualifiedName());
        }
    }
}

